package software.amazon.awscdk.services.ssm;

/**
 * A CloudFormation `AWS::SSM::ResourceDataSync`.
 * <p>
 * The <code>AWS::SSM::ResourceDataSync</code> resource creates, updates, or deletes a resource data sync for AWS Systems Manager . A resource data sync helps you view data from multiple sources in a single location. Systems Manager offers two types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code> .
 * <p>
 * You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize Inventory data from multiple AWS Regions to a single Amazon S3 bucket.
 * <p>
 * You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational work items (OpsItems) and operational data (OpsData) from multiple AWS Regions . This type can synchronize OpsItems and OpsData from multiple AWS accounts and Regions or from an <code>EntireOrganization</code> by using AWS Organizations .
 * <p>
 * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is completed, the system continuously syncs data.
 * <p>
 * By default, data is not encrypted in Amazon S3 . We strongly recommend that you enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a restrictive bucket policy.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-configuring.html#sysman-inventory-datasync">Configuring Inventory Collection</a> and <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting Up Systems Manager Explorer to Display Data from Multiple Accounts and Regions</a> in the <em>AWS Systems Manager User Guide</em> .
 * <p>
 * Important: The following <em>Syntax</em> section shows all fields that are supported for a resource data sync. The <em>Examples</em> section below shows the recommended way to specify configurations for each sync type. Please see the <em>Examples</em> section when you create your resource data sync.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * CfnResourceDataSync cfnResourceDataSync = CfnResourceDataSync.Builder.create(this, "MyCfnResourceDataSync")
 *         .syncName("syncName")
 *         // the properties below are optional
 *         .bucketName("bucketName")
 *         .bucketPrefix("bucketPrefix")
 *         .bucketRegion("bucketRegion")
 *         .kmsKeyArn("kmsKeyArn")
 *         .s3Destination(S3DestinationProperty.builder()
 *                 .bucketName("bucketName")
 *                 .bucketRegion("bucketRegion")
 *                 .syncFormat("syncFormat")
 *                 // the properties below are optional
 *                 .bucketPrefix("bucketPrefix")
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .syncFormat("syncFormat")
 *         .syncSource(SyncSourceProperty.builder()
 *                 .sourceRegions(List.of("sourceRegions"))
 *                 .sourceType("sourceType")
 *                 // the properties below are optional
 *                 .awsOrganizationsSource(AwsOrganizationsSourceProperty.builder()
 *                         .organizationSourceType("organizationSourceType")
 *                         // the properties below are optional
 *                         .organizationalUnits(List.of("organizationalUnits"))
 *                         .build())
 *                 .includeFutureRegions(false)
 *                 .build())
 *         .syncType("syncType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:49.143Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnResourceDataSync")
public class CfnResourceDataSync extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnResourceDataSync(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResourceDataSync(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ssm.CfnResourceDataSync.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SSM::ResourceDataSync`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResourceDataSync(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.CfnResourceDataSyncProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The name of the resource data sync.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSyncName() {
        return software.amazon.jsii.Kernel.get(this, "attrSyncName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A name for the resource data sync.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSyncName() {
        return software.amazon.jsii.Kernel.get(this, "syncName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the resource data sync.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSyncName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "syncName", java.util.Objects.requireNonNull(value, "syncName is required"));
    }

    /**
     * The name of the S3 bucket where the aggregated data is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
        return software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the S3 bucket where the aggregated data is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bucketName", value);
    }

    /**
     * An Amazon S3 prefix for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
        return software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An Amazon S3 prefix for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketPrefix(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bucketPrefix", value);
    }

    /**
     * The AWS Region with the S3 bucket targeted by the resource data sync.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBucketRegion() {
        return software.amazon.jsii.Kernel.get(this, "bucketRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Region with the S3 bucket targeted by the resource data sync.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bucketRegion", value);
    }

    /**
     * The ARN of an encryption key for a destination in Amazon S3 .
     * <p>
     * You can use a KMS key to encrypt inventory data in Amazon S3 . You must specify a key that exist in the same region as the destination Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of an encryption key for a destination in Amazon S3 .
     * <p>
     * You can use a KMS key to encrypt inventory data in Amazon S3 . You must specify a key that exist in the same region as the destination Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyArn", value);
    }

    /**
     * Configuration information for the target S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3Destination() {
        return software.amazon.jsii.Kernel.get(this, "s3Destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration information for the target S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Destination(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.CfnResourceDataSync.S3DestinationProperty value) {
        software.amazon.jsii.Kernel.set(this, "s3Destination", value);
    }

    /**
     * Configuration information for the target S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Destination(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3Destination", value);
    }

    /**
     * A supported sync format.
     * <p>
     * The following format is currently supported: JsonSerDe
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSyncFormat() {
        return software.amazon.jsii.Kernel.get(this, "syncFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A supported sync format.
     * <p>
     * The following format is currently supported: JsonSerDe
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSyncFormat(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "syncFormat", value);
    }

    /**
     * Information about the source where the data was synchronized.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSyncSource() {
        return software.amazon.jsii.Kernel.get(this, "syncSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the source where the data was synchronized.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSyncSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.CfnResourceDataSync.SyncSourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "syncSource", value);
    }

    /**
     * Information about the source where the data was synchronized.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSyncSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "syncSource", value);
    }

    /**
     * The type of resource data sync.
     * <p>
     * If <code>SyncType</code> is <code>SyncToDestination</code> , then the resource data sync synchronizes data to an S3 bucket. If the <code>SyncType</code> is <code>SyncFromSource</code> then the resource data sync synchronizes data from AWS Organizations or from multiple AWS Regions .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSyncType() {
        return software.amazon.jsii.Kernel.get(this, "syncType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of resource data sync.
     * <p>
     * If <code>SyncType</code> is <code>SyncToDestination</code> , then the resource data sync synchronizes data to an S3 bucket. If the <code>SyncType</code> is <code>SyncFromSource</code> then the resource data sync synchronizes data from AWS Organizations or from multiple AWS Regions .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSyncType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "syncType", value);
    }
    /**
     * Information about the `AwsOrganizationsSource` resource data sync source.
     * <p>
     * A sync source of this type can synchronize data from AWS Organizations or, if an AWS organization isn't present, from multiple AWS Regions .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * AwsOrganizationsSourceProperty awsOrganizationsSourceProperty = AwsOrganizationsSourceProperty.builder()
     *         .organizationSourceType("organizationSourceType")
     *         // the properties below are optional
     *         .organizationalUnits(List.of("organizationalUnits"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnResourceDataSync.AwsOrganizationsSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsOrganizationsSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsOrganizationsSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If an AWS organization is present, this is either `OrganizationalUnits` or `EntireOrganization` .
         * <p>
         * For <code>OrganizationalUnits</code> , the data is aggregated from a set of organization units. For <code>EntireOrganization</code> , the data is aggregated from the entire AWS organization.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOrganizationSourceType();

        /**
         * The AWS Organizations organization units included in the sync.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrganizationalUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsOrganizationsSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsOrganizationsSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsOrganizationsSourceProperty> {
            java.lang.String organizationSourceType;
            java.util.List<java.lang.String> organizationalUnits;

            /**
             * Sets the value of {@link AwsOrganizationsSourceProperty#getOrganizationSourceType}
             * @param organizationSourceType If an AWS organization is present, this is either `OrganizationalUnits` or `EntireOrganization` . This parameter is required.
             *                               For <code>OrganizationalUnits</code> , the data is aggregated from a set of organization units. For <code>EntireOrganization</code> , the data is aggregated from the entire AWS organization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationSourceType(java.lang.String organizationSourceType) {
                this.organizationSourceType = organizationSourceType;
                return this;
            }

            /**
             * Sets the value of {@link AwsOrganizationsSourceProperty#getOrganizationalUnits}
             * @param organizationalUnits The AWS Organizations organization units included in the sync.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationalUnits(java.util.List<java.lang.String> organizationalUnits) {
                this.organizationalUnits = organizationalUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsOrganizationsSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsOrganizationsSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsOrganizationsSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsOrganizationsSourceProperty {
            private final java.lang.String organizationSourceType;
            private final java.util.List<java.lang.String> organizationalUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.organizationSourceType = software.amazon.jsii.Kernel.get(this, "organizationSourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organizationalUnits = software.amazon.jsii.Kernel.get(this, "organizationalUnits", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.organizationSourceType = java.util.Objects.requireNonNull(builder.organizationSourceType, "organizationSourceType is required");
                this.organizationalUnits = builder.organizationalUnits;
            }

            @Override
            public final java.lang.String getOrganizationSourceType() {
                return this.organizationSourceType;
            }

            @Override
            public final java.util.List<java.lang.String> getOrganizationalUnits() {
                return this.organizationalUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("organizationSourceType", om.valueToTree(this.getOrganizationSourceType()));
                if (this.getOrganizationalUnits() != null) {
                    data.set("organizationalUnits", om.valueToTree(this.getOrganizationalUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnResourceDataSync.AwsOrganizationsSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsOrganizationsSourceProperty.Jsii$Proxy that = (AwsOrganizationsSourceProperty.Jsii$Proxy) o;

                if (!organizationSourceType.equals(that.organizationSourceType)) return false;
                return this.organizationalUnits != null ? this.organizationalUnits.equals(that.organizationalUnits) : that.organizationalUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.organizationSourceType.hashCode();
                result = 31 * result + (this.organizationalUnits != null ? this.organizationalUnits.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the target S3 bucket for the resource data sync.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * S3DestinationProperty s3DestinationProperty = S3DestinationProperty.builder()
     *         .bucketName("bucketName")
     *         .bucketRegion("bucketRegion")
     *         .syncFormat("syncFormat")
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnResourceDataSync.S3DestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket where the aggregated data is stored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The AWS Region with the S3 bucket targeted by the resource data sync.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketRegion();

        /**
         * A supported sync format.
         * <p>
         * The following format is currently supported: JsonSerDe
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSyncFormat();

        /**
         * An Amazon S3 prefix for the bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The ARN of an encryption key for a destination in Amazon S3.
         * <p>
         * Must belong to the same Region as the destination S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DestinationProperty> {
            java.lang.String bucketName;
            java.lang.String bucketRegion;
            java.lang.String syncFormat;
            java.lang.String bucketPrefix;
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link S3DestinationProperty#getBucketName}
             * @param bucketName The name of the S3 bucket where the aggregated data is stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationProperty#getBucketRegion}
             * @param bucketRegion The AWS Region with the S3 bucket targeted by the resource data sync. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketRegion(java.lang.String bucketRegion) {
                this.bucketRegion = bucketRegion;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationProperty#getSyncFormat}
             * @param syncFormat A supported sync format. This parameter is required.
             *                   The following format is currently supported: JsonSerDe
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder syncFormat(java.lang.String syncFormat) {
                this.syncFormat = syncFormat;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationProperty#getBucketPrefix}
             * @param bucketPrefix An Amazon S3 prefix for the bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationProperty#getKmsKeyArn}
             * @param kmsKeyArn The ARN of an encryption key for a destination in Amazon S3.
             *                  Must belong to the same Region as the destination S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DestinationProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketRegion;
            private final java.lang.String syncFormat;
            private final java.lang.String bucketPrefix;
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketRegion = software.amazon.jsii.Kernel.get(this, "bucketRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.syncFormat = software.amazon.jsii.Kernel.get(this, "syncFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.bucketRegion = java.util.Objects.requireNonNull(builder.bucketRegion, "bucketRegion is required");
                this.syncFormat = java.util.Objects.requireNonNull(builder.syncFormat, "syncFormat is required");
                this.bucketPrefix = builder.bucketPrefix;
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketRegion() {
                return this.bucketRegion;
            }

            @Override
            public final java.lang.String getSyncFormat() {
                return this.syncFormat;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("bucketRegion", om.valueToTree(this.getBucketRegion()));
                data.set("syncFormat", om.valueToTree(this.getSyncFormat()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnResourceDataSync.S3DestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DestinationProperty.Jsii$Proxy that = (S3DestinationProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!bucketRegion.equals(that.bucketRegion)) return false;
                if (!syncFormat.equals(that.syncFormat)) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.bucketRegion.hashCode());
                result = 31 * result + (this.syncFormat.hashCode());
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the source of the data included in the resource data sync.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * SyncSourceProperty syncSourceProperty = SyncSourceProperty.builder()
     *         .sourceRegions(List.of("sourceRegions"))
     *         .sourceType("sourceType")
     *         // the properties below are optional
     *         .awsOrganizationsSource(AwsOrganizationsSourceProperty.builder()
     *                 .organizationSourceType("organizationSourceType")
     *                 // the properties below are optional
     *                 .organizationalUnits(List.of("organizationalUnits"))
     *                 .build())
     *         .includeFutureRegions(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnResourceDataSync.SyncSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SyncSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SyncSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The `SyncSource` AWS Regions included in the resource data sync.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSourceRegions();

        /**
         * The type of data source for the resource data sync.
         * <p>
         * <code>SourceType</code> is either <code>AwsOrganizations</code> (if an organization is present in AWS Organizations ) or <code>SingleAccountMultiRegions</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceType();

        /**
         * Information about the AwsOrganizationsSource resource data sync source.
         * <p>
         * A sync source of this type can synchronize data from AWS Organizations .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsOrganizationsSource() {
            return null;
        }

        /**
         * Whether to automatically synchronize and aggregate data from new AWS Regions when those Regions come online.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeFutureRegions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SyncSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SyncSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SyncSourceProperty> {
            java.util.List<java.lang.String> sourceRegions;
            java.lang.String sourceType;
            java.lang.Object awsOrganizationsSource;
            java.lang.Object includeFutureRegions;

            /**
             * Sets the value of {@link SyncSourceProperty#getSourceRegions}
             * @param sourceRegions The `SyncSource` AWS Regions included in the resource data sync. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceRegions(java.util.List<java.lang.String> sourceRegions) {
                this.sourceRegions = sourceRegions;
                return this;
            }

            /**
             * Sets the value of {@link SyncSourceProperty#getSourceType}
             * @param sourceType The type of data source for the resource data sync. This parameter is required.
             *                   <code>SourceType</code> is either <code>AwsOrganizations</code> (if an organization is present in AWS Organizations ) or <code>SingleAccountMultiRegions</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceType(java.lang.String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            /**
             * Sets the value of {@link SyncSourceProperty#getAwsOrganizationsSource}
             * @param awsOrganizationsSource Information about the AwsOrganizationsSource resource data sync source.
             *                               A sync source of this type can synchronize data from AWS Organizations .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsOrganizationsSource(software.amazon.awscdk.services.ssm.CfnResourceDataSync.AwsOrganizationsSourceProperty awsOrganizationsSource) {
                this.awsOrganizationsSource = awsOrganizationsSource;
                return this;
            }

            /**
             * Sets the value of {@link SyncSourceProperty#getAwsOrganizationsSource}
             * @param awsOrganizationsSource Information about the AwsOrganizationsSource resource data sync source.
             *                               A sync source of this type can synchronize data from AWS Organizations .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsOrganizationsSource(software.amazon.awscdk.IResolvable awsOrganizationsSource) {
                this.awsOrganizationsSource = awsOrganizationsSource;
                return this;
            }

            /**
             * Sets the value of {@link SyncSourceProperty#getIncludeFutureRegions}
             * @param includeFutureRegions Whether to automatically synchronize and aggregate data from new AWS Regions when those Regions come online.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeFutureRegions(java.lang.Boolean includeFutureRegions) {
                this.includeFutureRegions = includeFutureRegions;
                return this;
            }

            /**
             * Sets the value of {@link SyncSourceProperty#getIncludeFutureRegions}
             * @param includeFutureRegions Whether to automatically synchronize and aggregate data from new AWS Regions when those Regions come online.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeFutureRegions(software.amazon.awscdk.IResolvable includeFutureRegions) {
                this.includeFutureRegions = includeFutureRegions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SyncSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SyncSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SyncSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SyncSourceProperty {
            private final java.util.List<java.lang.String> sourceRegions;
            private final java.lang.String sourceType;
            private final java.lang.Object awsOrganizationsSource;
            private final java.lang.Object includeFutureRegions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceRegions = software.amazon.jsii.Kernel.get(this, "sourceRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourceType = software.amazon.jsii.Kernel.get(this, "sourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsOrganizationsSource = software.amazon.jsii.Kernel.get(this, "awsOrganizationsSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeFutureRegions = software.amazon.jsii.Kernel.get(this, "includeFutureRegions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceRegions = java.util.Objects.requireNonNull(builder.sourceRegions, "sourceRegions is required");
                this.sourceType = java.util.Objects.requireNonNull(builder.sourceType, "sourceType is required");
                this.awsOrganizationsSource = builder.awsOrganizationsSource;
                this.includeFutureRegions = builder.includeFutureRegions;
            }

            @Override
            public final java.util.List<java.lang.String> getSourceRegions() {
                return this.sourceRegions;
            }

            @Override
            public final java.lang.String getSourceType() {
                return this.sourceType;
            }

            @Override
            public final java.lang.Object getAwsOrganizationsSource() {
                return this.awsOrganizationsSource;
            }

            @Override
            public final java.lang.Object getIncludeFutureRegions() {
                return this.includeFutureRegions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceRegions", om.valueToTree(this.getSourceRegions()));
                data.set("sourceType", om.valueToTree(this.getSourceType()));
                if (this.getAwsOrganizationsSource() != null) {
                    data.set("awsOrganizationsSource", om.valueToTree(this.getAwsOrganizationsSource()));
                }
                if (this.getIncludeFutureRegions() != null) {
                    data.set("includeFutureRegions", om.valueToTree(this.getIncludeFutureRegions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnResourceDataSync.SyncSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SyncSourceProperty.Jsii$Proxy that = (SyncSourceProperty.Jsii$Proxy) o;

                if (!sourceRegions.equals(that.sourceRegions)) return false;
                if (!sourceType.equals(that.sourceType)) return false;
                if (this.awsOrganizationsSource != null ? !this.awsOrganizationsSource.equals(that.awsOrganizationsSource) : that.awsOrganizationsSource != null) return false;
                return this.includeFutureRegions != null ? this.includeFutureRegions.equals(that.includeFutureRegions) : that.includeFutureRegions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceRegions.hashCode();
                result = 31 * result + (this.sourceType.hashCode());
                result = 31 * result + (this.awsOrganizationsSource != null ? this.awsOrganizationsSource.hashCode() : 0);
                result = 31 * result + (this.includeFutureRegions != null ? this.includeFutureRegions.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssm.CfnResourceDataSync}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssm.CfnResourceDataSync> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssm.CfnResourceDataSyncProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssm.CfnResourceDataSyncProps.Builder();
        }

        /**
         * A name for the resource data sync.
         * <p>
         * @return {@code this}
         * @param syncName A name for the resource data sync. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncName(final java.lang.String syncName) {
            this.props.syncName(syncName);
            return this;
        }

        /**
         * The name of the S3 bucket where the aggregated data is stored.
         * <p>
         * @return {@code this}
         * @param bucketName The name of the S3 bucket where the aggregated data is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(final java.lang.String bucketName) {
            this.props.bucketName(bucketName);
            return this;
        }

        /**
         * An Amazon S3 prefix for the bucket.
         * <p>
         * @return {@code this}
         * @param bucketPrefix An Amazon S3 prefix for the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketPrefix(final java.lang.String bucketPrefix) {
            this.props.bucketPrefix(bucketPrefix);
            return this;
        }

        /**
         * The AWS Region with the S3 bucket targeted by the resource data sync.
         * <p>
         * @return {@code this}
         * @param bucketRegion The AWS Region with the S3 bucket targeted by the resource data sync. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketRegion(final java.lang.String bucketRegion) {
            this.props.bucketRegion(bucketRegion);
            return this;
        }

        /**
         * The ARN of an encryption key for a destination in Amazon S3 .
         * <p>
         * You can use a KMS key to encrypt inventory data in Amazon S3 . You must specify a key that exist in the same region as the destination Amazon S3 bucket.
         * <p>
         * @return {@code this}
         * @param kmsKeyArn The ARN of an encryption key for a destination in Amazon S3 . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(final java.lang.String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        /**
         * Configuration information for the target S3 bucket.
         * <p>
         * @return {@code this}
         * @param s3Destination Configuration information for the target S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Destination(final software.amazon.awscdk.services.ssm.CfnResourceDataSync.S3DestinationProperty s3Destination) {
            this.props.s3Destination(s3Destination);
            return this;
        }
        /**
         * Configuration information for the target S3 bucket.
         * <p>
         * @return {@code this}
         * @param s3Destination Configuration information for the target S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Destination(final software.amazon.awscdk.IResolvable s3Destination) {
            this.props.s3Destination(s3Destination);
            return this;
        }

        /**
         * A supported sync format.
         * <p>
         * The following format is currently supported: JsonSerDe
         * <p>
         * @return {@code this}
         * @param syncFormat A supported sync format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncFormat(final java.lang.String syncFormat) {
            this.props.syncFormat(syncFormat);
            return this;
        }

        /**
         * Information about the source where the data was synchronized.
         * <p>
         * @return {@code this}
         * @param syncSource Information about the source where the data was synchronized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncSource(final software.amazon.awscdk.services.ssm.CfnResourceDataSync.SyncSourceProperty syncSource) {
            this.props.syncSource(syncSource);
            return this;
        }
        /**
         * Information about the source where the data was synchronized.
         * <p>
         * @return {@code this}
         * @param syncSource Information about the source where the data was synchronized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncSource(final software.amazon.awscdk.IResolvable syncSource) {
            this.props.syncSource(syncSource);
            return this;
        }

        /**
         * The type of resource data sync.
         * <p>
         * If <code>SyncType</code> is <code>SyncToDestination</code> , then the resource data sync synchronizes data to an S3 bucket. If the <code>SyncType</code> is <code>SyncFromSource</code> then the resource data sync synchronizes data from AWS Organizations or from multiple AWS Regions .
         * <p>
         * @return {@code this}
         * @param syncType The type of resource data sync. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncType(final java.lang.String syncType) {
            this.props.syncType(syncType);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ssm.CfnResourceDataSync}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssm.CfnResourceDataSync build() {
            return new software.amazon.awscdk.services.ssm.CfnResourceDataSync(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
