package software.amazon.awscdk.services.stepfunctions;

/**
 * Two types of state machines are available in AWS Step Functions: EXPRESS AND STANDARD.
 * <p>
 * Default: STANDARD
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pass stateMachineDefinition = new Pass(this, "PassState");
 * IStateMachine stateMachine = StateMachine.Builder.create(this, "StateMachine")
 *         .definition(stateMachineDefinition)
 *         .stateMachineType(StateMachineType.EXPRESS)
 *         .build();
 * StepFunctionsRestApi.Builder.create(this, "StepFunctionsRestApi")
 *         .deploy(true)
 *         .stateMachine(stateMachine)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:49.216Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.StateMachineType")
public enum StateMachineType {
    /**
     * Express Workflows are ideal for high-volume, event processing workloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXPRESS,
    /**
     * Standard Workflows are ideal for long-running, durable, and auditable workflows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
}
