package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Specify the training algorithm and algorithm-specific metadata.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateTrainingJob.Builder.create(this, "TrainSagemaker")
 *         .trainingJobName(JsonPath.stringAt("$.JobName"))
 *         .algorithmSpecification(AlgorithmSpecification.builder()
 *                 .algorithmName("BlazingText")
 *                 .trainingInputMode(InputMode.FILE)
 *                 .build())
 *         .inputDataConfig(List.of(Channel.builder()
 *                 .channelName("train")
 *                 .dataSource(DataSource.builder()
 *                         .s3DataSource(S3DataSource.builder()
 *                                 .s3DataType(S3DataType.S3_PREFIX)
 *                                 .s3Location(S3Location.fromJsonExpression("$.S3Bucket"))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .outputDataConfig(OutputDataConfig.builder()
 *                 .s3OutputLocation(S3Location.fromBucket(Bucket.fromBucketName(this, "Bucket", "mybucket"), "myoutputpath"))
 *                 .build())
 *         .resourceConfig(ResourceConfig.builder()
 *                 .instanceCount(1)
 *                 .instanceType(new InstanceType(JsonPath.stringAt("$.InstanceType")))
 *                 .volumeSize(Size.gibibytes(50))
 *                 .build()) // optional: default is 1 instance of EC2 `M4.XLarge` with `10GB` volume
 *         .stoppingCondition(StoppingCondition.builder()
 *                 .maxRuntime(Duration.hours(2))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:49.253Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.AlgorithmSpecification")
@software.amazon.jsii.Jsii.Proxy(AlgorithmSpecification.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AlgorithmSpecification extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the algorithm resource to use for the training job.
     * <p>
     * This must be an algorithm resource that you created or subscribe to on AWS Marketplace.
     * If you specify a value for this parameter, you can't specify a value for TrainingImage.
     * <p>
     * Default: - No algorithm is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlgorithmName() {
        return null;
    }

    /**
     * List of metric definition objects.
     * <p>
     * Each object specifies the metric name and regular expressions used to parse algorithm logs.
     * <p>
     * Default: - No metrics
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.MetricDefinition> getMetricDefinitions() {
        return null;
    }

    /**
     * Registry path of the Docker image that contains the training algorithm.
     * <p>
     * Default: - No Docker image is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DockerImage getTrainingImage() {
        return null;
    }

    /**
     * Input mode that the algorithm supports.
     * <p>
     * Default: 'File' mode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.InputMode getTrainingInputMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AlgorithmSpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AlgorithmSpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AlgorithmSpecification> {
        java.lang.String algorithmName;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.MetricDefinition> metricDefinitions;
        software.amazon.awscdk.services.stepfunctions.tasks.DockerImage trainingImage;
        software.amazon.awscdk.services.stepfunctions.tasks.InputMode trainingInputMode;

        /**
         * Sets the value of {@link AlgorithmSpecification#getAlgorithmName}
         * @param algorithmName Name of the algorithm resource to use for the training job.
         *                      This must be an algorithm resource that you created or subscribe to on AWS Marketplace.
         *                      If you specify a value for this parameter, you can't specify a value for TrainingImage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder algorithmName(java.lang.String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        /**
         * Sets the value of {@link AlgorithmSpecification#getMetricDefinitions}
         * @param metricDefinitions List of metric definition objects.
         *                          Each object specifies the metric name and regular expressions used to parse algorithm logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder metricDefinitions(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.MetricDefinition> metricDefinitions) {
            this.metricDefinitions = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.MetricDefinition>)metricDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link AlgorithmSpecification#getTrainingImage}
         * @param trainingImage Registry path of the Docker image that contains the training algorithm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trainingImage(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage trainingImage) {
            this.trainingImage = trainingImage;
            return this;
        }

        /**
         * Sets the value of {@link AlgorithmSpecification#getTrainingInputMode}
         * @param trainingInputMode Input mode that the algorithm supports.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trainingInputMode(software.amazon.awscdk.services.stepfunctions.tasks.InputMode trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlgorithmSpecification}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AlgorithmSpecification build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AlgorithmSpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlgorithmSpecification {
        private final java.lang.String algorithmName;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.MetricDefinition> metricDefinitions;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DockerImage trainingImage;
        private final software.amazon.awscdk.services.stepfunctions.tasks.InputMode trainingInputMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.algorithmName = software.amazon.jsii.Kernel.get(this, "algorithmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metricDefinitions = software.amazon.jsii.Kernel.get(this, "metricDefinitions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.MetricDefinition.class)));
            this.trainingImage = software.amazon.jsii.Kernel.get(this, "trainingImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class));
            this.trainingInputMode = software.amazon.jsii.Kernel.get(this, "trainingInputMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.InputMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.algorithmName = builder.algorithmName;
            this.metricDefinitions = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.MetricDefinition>)builder.metricDefinitions;
            this.trainingImage = builder.trainingImage;
            this.trainingInputMode = builder.trainingInputMode;
        }

        @Override
        public final java.lang.String getAlgorithmName() {
            return this.algorithmName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.MetricDefinition> getMetricDefinitions() {
            return this.metricDefinitions;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.DockerImage getTrainingImage() {
            return this.trainingImage;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.InputMode getTrainingInputMode() {
            return this.trainingInputMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAlgorithmName() != null) {
                data.set("algorithmName", om.valueToTree(this.getAlgorithmName()));
            }
            if (this.getMetricDefinitions() != null) {
                data.set("metricDefinitions", om.valueToTree(this.getMetricDefinitions()));
            }
            if (this.getTrainingImage() != null) {
                data.set("trainingImage", om.valueToTree(this.getTrainingImage()));
            }
            if (this.getTrainingInputMode() != null) {
                data.set("trainingInputMode", om.valueToTree(this.getTrainingInputMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.AlgorithmSpecification"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AlgorithmSpecification.Jsii$Proxy that = (AlgorithmSpecification.Jsii$Proxy) o;

            if (this.algorithmName != null ? !this.algorithmName.equals(that.algorithmName) : that.algorithmName != null) return false;
            if (this.metricDefinitions != null ? !this.metricDefinitions.equals(that.metricDefinitions) : that.metricDefinitions != null) return false;
            if (this.trainingImage != null ? !this.trainingImage.equals(that.trainingImage) : that.trainingImage != null) return false;
            return this.trainingInputMode != null ? this.trainingInputMode.equals(that.trainingInputMode) : that.trainingInputMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.algorithmName != null ? this.algorithmName.hashCode() : 0;
            result = 31 * result + (this.metricDefinitions != null ? this.metricDefinitions.hashCode() : 0);
            result = 31 * result + (this.trainingImage != null ? this.trainingImage.hashCode() : 0);
            result = 31 * result + (this.trainingInputMode != null ? this.trainingInputMode.hashCode() : 0);
            return result;
        }
    }
}
