package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A Step Functions Task to create a SageMaker model.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateModel.Builder.create(this, "Sagemaker")
 *         .modelName("MyModel")
 *         .primaryContainer(ContainerDefinition.Builder.create()
 *                 .image(DockerImage.fromJsonExpression(JsonPath.stringAt("$.Model.imageName")))
 *                 .mode(Mode.SINGLE_MODEL)
 *                 .modelS3Location(S3Location.fromJsonExpression("$.TrainingJob.ModelArtifacts.S3ModelArtifacts"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:49.348Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateModel")
public class SageMakerCreateModel extends software.amazon.awscdk.services.stepfunctions.TaskStateBase implements software.amazon.awscdk.services.iam.IGrantable, software.amazon.awscdk.services.ec2.IConnectable {

    protected SageMakerCreateModel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SageMakerCreateModel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SageMakerCreateModel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add the security group to all instances via the launch configuration security groups array.
     * <p>
     * @param securityGroup : The security group to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        software.amazon.jsii.Kernel.call(this, "addSecurityGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * Allows specify security group connections for instances of this fleet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * The execution role for the Sagemaker Create Model API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return software.amazon.jsii.Kernel.get(this, "taskMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModelProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModelProps.Builder();
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: - No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(final software.amazon.awscdk.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: - The entire task input (JSON path '$')
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns
         * <p>
         * Default: IntegrationPattern.REQUEST_RESPONSE
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * JSONPath expression to select select a portion of the state output to pass to the next state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: - The entire JSON node determined by the state input, the task result,
         * and resultPath is passed to the next state (JSON path '$')
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: - Replaces the entire input with the result (JSON path '$')
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        /**
         * Timeout for the state machine.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param timeout Timeout for the state machine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * The name of the new model.
         * <p>
         * @return {@code this}
         * @param modelName The name of the new model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelName(final java.lang.String modelName) {
            this.props.modelName(modelName);
            return this;
        }

        /**
         * The definition of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.
         * <p>
         * @return {@code this}
         * @param primaryContainer The definition of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryContainer(final software.amazon.awscdk.services.stepfunctions.tasks.IContainerDefinition primaryContainer) {
            this.props.primaryContainer(primaryContainer);
            return this;
        }

        /**
         * Specifies the containers in the inference pipeline.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param containers Specifies the containers in the inference pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.IContainerDefinition> containers) {
            this.props.containers(containers);
            return this;
        }

        /**
         * Isolates the model container.
         * <p>
         * No inbound or outbound network calls can be made to or from the model container.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableNetworkIsolation Isolates the model container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableNetworkIsolation(final java.lang.Boolean enableNetworkIsolation) {
            this.props.enableNetworkIsolation(enableNetworkIsolation);
            return this;
        }

        /**
         * An execution role that you can pass in a CreateModel API request.
         * <p>
         * Default: - a role will be created.
         * <p>
         * @return {@code this}
         * @param role An execution role that you can pass in a CreateModel API request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The subnets of the VPC to which the hosted model is connected (Note this parameter is only used when VPC is provided).
         * <p>
         * Default: - Private Subnets are selected
         * <p>
         * @return {@code this}
         * @param subnetSelection The subnets of the VPC to which the hosted model is connected (Note this parameter is only used when VPC is provided). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * Tags to be applied to the model.
         * <p>
         * Default: - No tags
         * <p>
         * @return {@code this}
         * @param tags Tags to be applied to the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final software.amazon.awscdk.services.stepfunctions.TaskInput tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The VPC that is accessible by the hosted model.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param vpc The VPC that is accessible by the hosted model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModel build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModel(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
