/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.awscdk.services.route53.HostedZone;
import software.amazon.awscdk.services.route53.IPublicHostedZone;
import software.amazon.awscdk.services.route53.PublicHostedZoneProps;
import software.amazon.awscdk.services.route53.ZoneDelegationOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_route53.PublicHostedZone")
public class PublicHostedZone
extends HostedZone
implements IPublicHostedZone {
    protected PublicHostedZone(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PublicHostedZone(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public PublicHostedZone(@NotNull Construct scope, @NotNull String id, @NotNull PublicHostedZoneProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IPublicHostedZone fromPublicHostedZoneId(@NotNull Construct scope, @NotNull String id, @NotNull String publicHostedZoneId) {
        return (IPublicHostedZone)JsiiObject.jsiiStaticCall(PublicHostedZone.class, (String)"fromPublicHostedZoneId", (NativeType)NativeType.forClass(IPublicHostedZone.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(publicHostedZoneId, "publicHostedZoneId is required")});
    }

    public void addDelegation(@NotNull IPublicHostedZone delegate, @Nullable ZoneDelegationOptions opts) {
        Kernel.call((Object)this, (String)"addDelegation", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(delegate, "delegate is required"), opts});
    }

    public void addDelegation(@NotNull IPublicHostedZone delegate) {
        Kernel.call((Object)this, (String)"addDelegation", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(delegate, "delegate is required")});
    }

    @Override
    public void addVpc(@NotNull IVpc _vpc) {
        Kernel.call((Object)this, (String)"addVpc", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(_vpc, "_vpc is required")});
    }

    @Nullable
    public Role getCrossAccountZoneDelegationRole() {
        return (Role)Kernel.get((Object)this, (String)"crossAccountZoneDelegationRole", (NativeType)NativeType.forClass(Role.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<PublicHostedZone> {
        private final Construct scope;
        private final String id;
        private final PublicHostedZoneProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new PublicHostedZoneProps.Builder();
        }

        public Builder zoneName(String zoneName) {
            this.props.zoneName(zoneName);
            return this;
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder queryLogsLogGroupArn(String queryLogsLogGroupArn) {
            this.props.queryLogsLogGroupArn(queryLogsLogGroupArn);
            return this;
        }

        public Builder caaAmazon(Boolean caaAmazon) {
            this.props.caaAmazon(caaAmazon);
            return this;
        }

        public Builder crossAccountZoneDelegationPrincipal(IPrincipal crossAccountZoneDelegationPrincipal) {
            this.props.crossAccountZoneDelegationPrincipal(crossAccountZoneDelegationPrincipal);
            return this;
        }

        public Builder crossAccountZoneDelegationRoleName(String crossAccountZoneDelegationRoleName) {
            this.props.crossAccountZoneDelegationRoleName(crossAccountZoneDelegationRoleName);
            return this;
        }

        public PublicHostedZone build() {
            return new PublicHostedZone(this.scope, this.id, this.props.build());
        }
    }
}

