package software.amazon.awscdk;

/**
 * Represents a validation plugin that will be executed during synthesis.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * public class MyPlugin implements IPolicyValidationPluginBeta1 {
 *     public final Object name;
 *     public PolicyValidationPluginReportBeta1 validate(IPolicyValidationContextBeta1 context) {
 *         // First read the templates using context.templatePaths...
 *         // ...then perform the validation, and then compose and return the report.
 *         // Using hard-coded values here for better clarity:
 *         return PolicyValidationPluginReportBeta1.builder()
 *                 .success(false)
 *                 .violations(List.of(PolicyViolationBeta1.builder()
 *                         .ruleName("CKV_AWS_117")
 *                         .description("Ensure that AWS Lambda function is configured inside a VPC")
 *                         .fix("https://docs.bridgecrew.io/docs/ensure-that-aws-lambda-function-is-configured-inside-a-vpc-1")
 *                         .violatingResources(List.of(PolicyViolatingResourceBeta1.builder()
 *                                 .resourceLogicalId("MyFunction3BAA72D1")
 *                                 .templatePath("/home/johndoe/myapp/cdk.out/MyService.template.json")
 *                                 .locations(List.of("Properties/VpcConfig"))
 *                                 .build()))
 *                         .build()))
 *                 .build();
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:51.908Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.IPolicyValidationPluginBeta1")
@software.amazon.jsii.Jsii.Proxy(IPolicyValidationPluginBeta1.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPolicyValidationPluginBeta1 extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the plugin that will be displayed in the validation report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The list of rule IDs that the plugin will evaluate.
     * <p>
     * Used for analytics
     * purposes.
     * <p>
     * Default: - No rule is reported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRuleIds() {
        return null;
    }

    /**
     * The version of the plugin, following the Semantic Versioning specification (see https://semver.org/). This version is used for analytics purposes, to measure the usage of different plugins and different versions. The value of this property should be kept in sync with the actual version of the software package. If the version is not provided or is not a valid semantic version, it will be reported as <code>0.0.0</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * The method that will be called by the CDK framework to perform validations.
     * <p>
     * This is where the plugin will evaluate the CloudFormation
     * templates for compliance and report and violations
     * <p>
     * @param context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.PolicyValidationPluginReportBeta1 validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IPolicyValidationContextBeta1 context);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.IPolicyValidationPluginBeta1.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The name of the plugin that will be displayed in the validation report.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getName() {
            return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The list of rule IDs that the plugin will evaluate.
         * <p>
         * Used for analytics
         * purposes.
         * <p>
         * Default: - No rule is reported
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRuleIds() {
            return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "ruleIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The version of the plugin, following the Semantic Versioning specification (see https://semver.org/). This version is used for analytics purposes, to measure the usage of different plugins and different versions. The value of this property should be kept in sync with the actual version of the software package. If the version is not provided or is not a valid semantic version, it will be reported as <code>0.0.0</code>.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The method that will be called by the CDK framework to perform validations.
         * <p>
         * This is where the plugin will evaluate the CloudFormation
         * templates for compliance and report and violations
         * <p>
         * @param context This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.PolicyValidationPluginReportBeta1 validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IPolicyValidationContextBeta1 context) {
            return software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.PolicyValidationPluginReportBeta1.class), new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
        }
    }

    /**
     * Internal default implementation for {@link IPolicyValidationPluginBeta1}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IPolicyValidationPluginBeta1 {

        /**
         * The name of the plugin that will be displayed in the validation report.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getName() {
            return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The list of rule IDs that the plugin will evaluate.
         * <p>
         * Used for analytics
         * purposes.
         * <p>
         * Default: - No rule is reported
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRuleIds() {
            return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "ruleIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The version of the plugin, following the Semantic Versioning specification (see https://semver.org/). This version is used for analytics purposes, to measure the usage of different plugins and different versions. The value of this property should be kept in sync with the actual version of the software package. If the version is not provided or is not a valid semantic version, it will be reported as <code>0.0.0</code>.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The method that will be called by the CDK framework to perform validations.
         * <p>
         * This is where the plugin will evaluate the CloudFormation
         * templates for compliance and report and violations
         * <p>
         * @param context This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.PolicyValidationPluginReportBeta1 validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IPolicyValidationContextBeta1 context) {
            return software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.PolicyValidationPluginReportBeta1.class), new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
        }
    }
}
