package software.amazon.awscdk.cloud_assembly_schema;

/**
 * Configuration options for the Asset Manifest.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * AssetManifestOptions assetManifestOptions = AssetManifestOptions.builder()
 *         .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *         .requiresBootstrapStackVersion(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:06.733Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.AssetManifestOptions")
@software.amazon.jsii.Jsii.Proxy(AssetManifestOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssetManifestOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * SSM parameter where the bootstrap stack version number can be found.
     * <p>
     * <ul>
     * <li>If this value is not set, the bootstrap stack name must be known at
     * deployment time so the stack version can be looked up from the stack
     * outputs.</li>
     * <li>If this value is set, the bootstrap stack can have any name because
     * we won't need to look it up.</li>
     * </ul>
     * <p>
     * Default: - Bootstrap stack version number looked up
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBootstrapStackVersionSsmParameter() {
        return null;
    }

    /**
     * Version of bootstrap stack required to deploy this stack.
     * <p>
     * Default: - Version 1 (basic modern bootstrap stack)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRequiresBootstrapStackVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AssetManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssetManifestOptions> {
        java.lang.String bootstrapStackVersionSsmParameter;
        java.lang.Number requiresBootstrapStackVersion;

        /**
         * Sets the value of {@link AssetManifestOptions#getBootstrapStackVersionSsmParameter}
         * @param bootstrapStackVersionSsmParameter SSM parameter where the bootstrap stack version number can be found.
         *                                          <ul>
         *                                          <li>If this value is not set, the bootstrap stack name must be known at
         *                                          deployment time so the stack version can be looked up from the stack
         *                                          outputs.</li>
         *                                          <li>If this value is set, the bootstrap stack can have any name because
         *                                          we won't need to look it up.</li>
         *                                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapStackVersionSsmParameter(java.lang.String bootstrapStackVersionSsmParameter) {
            this.bootstrapStackVersionSsmParameter = bootstrapStackVersionSsmParameter;
            return this;
        }

        /**
         * Sets the value of {@link AssetManifestOptions#getRequiresBootstrapStackVersion}
         * @param requiresBootstrapStackVersion Version of bootstrap stack required to deploy this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requiresBootstrapStackVersion(java.lang.Number requiresBootstrapStackVersion) {
            this.requiresBootstrapStackVersion = requiresBootstrapStackVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetManifestOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssetManifestOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssetManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetManifestOptions {
        private final java.lang.String bootstrapStackVersionSsmParameter;
        private final java.lang.Number requiresBootstrapStackVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bootstrapStackVersionSsmParameter = software.amazon.jsii.Kernel.get(this, "bootstrapStackVersionSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requiresBootstrapStackVersion = software.amazon.jsii.Kernel.get(this, "requiresBootstrapStackVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bootstrapStackVersionSsmParameter = builder.bootstrapStackVersionSsmParameter;
            this.requiresBootstrapStackVersion = builder.requiresBootstrapStackVersion;
        }

        @Override
        public final java.lang.String getBootstrapStackVersionSsmParameter() {
            return this.bootstrapStackVersionSsmParameter;
        }

        @Override
        public final java.lang.Number getRequiresBootstrapStackVersion() {
            return this.requiresBootstrapStackVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBootstrapStackVersionSsmParameter() != null) {
                data.set("bootstrapStackVersionSsmParameter", om.valueToTree(this.getBootstrapStackVersionSsmParameter()));
            }
            if (this.getRequiresBootstrapStackVersion() != null) {
                data.set("requiresBootstrapStackVersion", om.valueToTree(this.getRequiresBootstrapStackVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.AssetManifestOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetManifestOptions.Jsii$Proxy that = (AssetManifestOptions.Jsii$Proxy) o;

            if (this.bootstrapStackVersionSsmParameter != null ? !this.bootstrapStackVersionSsmParameter.equals(that.bootstrapStackVersionSsmParameter) : that.bootstrapStackVersionSsmParameter != null) return false;
            return this.requiresBootstrapStackVersion != null ? this.requiresBootstrapStackVersion.equals(that.requiresBootstrapStackVersion) : that.requiresBootstrapStackVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bootstrapStackVersionSsmParameter != null ? this.bootstrapStackVersionSsmParameter.hashCode() : 0;
            result = 31 * result + (this.requiresBootstrapStackVersion != null ? this.requiresBootstrapStackVersion.hashCode() : 0);
            return result;
        }
    }
}
