package software.amazon.awscdk.pipelines;

/**
 * Properties for a <code>CodePipeline</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline codePipeline;
 * Artifact sourceArtifact = new Artifact("MySourceArtifact");
 * CodePipeline pipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         .codePipeline(codePipeline)
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineFileSet.fromArtifact(sourceArtifact))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:06.873Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CodePipelineProps")
@software.amazon.jsii.Jsii.Proxy(CodePipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodePipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The build step that produces the CDK Cloud Assembly.
     * <p>
     * The primary output of this step needs to be the <code>cdk.out</code> directory
     * generated by the <code>cdk synth</code> command.
     * <p>
     * If you use a <code>ShellStep</code> here and you don't configure an output directory,
     * the output directory will automatically be assumed to be <code>cdk.out</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.IFileSetProducer getSynth();

    /**
     * An existing S3 Bucket to use for storing the pipeline's artifact.
     * <p>
     * Default: - A new S3 bucket will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
        return null;
    }

    /**
     * Additional customizations to apply to the asset publishing CodeBuild projects.
     * <p>
     * Default: - Only `codeBuildDefaults` are applied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.CodeBuildOptions getAssetPublishingCodeBuildDefaults() {
        return null;
    }

    /**
     * CDK CLI version to use in self-mutation and asset publishing steps.
     * <p>
     * If you want to lock the CDK CLI version used in the pipeline, by steps
     * that are automatically generated for you, specify the version here.
     * <p>
     * We recommend you do not specify this value, as not specifying it always
     * uses the latest CLI version which is backwards compatible with old versions.
     * <p>
     * If you do specify it, be aware that this version should always be equal to or higher than the
     * version of the CDK framework used by the CDK app, when the CDK commands are
     * run during your pipeline execution. When you change this version, the <em>next
     * time</em> the <code>SelfMutate</code> step runs it will still be using the CLI of the the
     * <em>previous</em> version that was in this property: it will only start using the
     * new version after <code>SelfMutate</code> completes successfully. That means that if
     * you want to update both framework and CLI version, you should update the
     * CLI version first, commit, push and deploy, and only then update the
     * framework version.
     * <p>
     * Default: - Latest version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCliVersion() {
        return null;
    }

    /**
     * Customize the CodeBuild projects created for this pipeline.
     * <p>
     * Default: - All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_7_0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.CodeBuildOptions getCodeBuildDefaults() {
        return null;
    }

    /**
     * An existing Pipeline to be reused and built upon.
     * <p>
     * [disable-awslint:ref-via-interface]
     * <p>
     * Default: - a new underlying pipeline is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.Pipeline getCodePipeline() {
        return null;
    }

    /**
     * Create KMS keys for the artifact buckets, allowing cross-account deployments.
     * <p>
     * The artifact buckets have to be encrypted to support deploying CDK apps to
     * another account, so if you want to do that or want to have your artifact
     * buckets encrypted, be sure to set this value to <code>true</code>.
     * <p>
     * Be aware there is a cost associated with maintaining the KMS keys.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCrossAccountKeys() {
        return null;
    }

    /**
     * A map of region to S3 bucket name used for cross-region CodePipeline.
     * <p>
     * For every Action that you specify targeting a different region than the Pipeline itself,
     * if you don't provide an explicit Bucket for that region using this property,
     * the construct will automatically create a Stack containing an S3 Bucket in that region.
     * Passed directly through to the {@link cp.Pipeline}.
     * <p>
     * Default: - no cross region replication buckets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> getCrossRegionReplicationBuckets() {
        return null;
    }

    /**
     * A list of credentials used to authenticate to Docker registries.
     * <p>
     * Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.DockerCredential> getDockerCredentials() {
        return null;
    }

    /**
     * Enable Docker for the self-mutate step.
     * <p>
     * Set this to true if the pipeline itself uses Docker container assets
     * (for example, if you use <code>LinuxBuildImage.fromAsset()</code> as the build
     * image of a CodeBuild step in the pipeline).
     * <p>
     * You do not need to set it if you build Docker image assets in the
     * application Stages and Stacks that are <em>deployed</em> by this pipeline.
     * <p>
     * Configures privileged mode for the self-mutation CodeBuild action.
     * <p>
     * If you are about to turn this on in an already-deployed Pipeline,
     * set the value to <code>true</code> first, commit and allow the pipeline to
     * self-update, and only then use the Docker asset in the pipeline.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDockerEnabledForSelfMutation() {
        return null;
    }

    /**
     * Enable Docker for the 'synth' step.
     * <p>
     * Set this to true if you are using file assets that require
     * "bundling" anywhere in your application (meaning an asset
     * compilation step will be run with the tools provided by
     * a Docker image), both for the Pipeline stack as well as the
     * application stacks.
     * <p>
     * A common way to use bundling assets in your application is by
     * using the <code>aws-cdk-lib/aws-lambda-nodejs</code> library.
     * <p>
     * Configures privileged mode for the synth CodeBuild action.
     * <p>
     * If you are about to turn this on in an already-deployed Pipeline,
     * set the value to <code>true</code> first, commit and allow the pipeline to
     * self-update, and only then use the bundled asset.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDockerEnabledForSynth() {
        return null;
    }

    /**
     * Enable KMS key rotation for the generated KMS keys.
     * <p>
     * By default KMS key rotation is disabled, but will add
     * additional costs when enabled.
     * <p>
     * Default: - false (key rotation is disabled)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableKeyRotation() {
        return null;
    }

    /**
     * The name of the CodePipeline pipeline.
     * <p>
     * Default: - Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPipelineName() {
        return null;
    }

    /**
     * Publish assets in multiple CodeBuild projects.
     * <p>
     * If set to false, use one Project per type to publish all assets.
     * <p>
     * Publishing in parallel improves concurrency and may reduce publishing
     * latency, but may also increase overall provisioning time of the CodeBuild
     * projects.
     * <p>
     * Experiment and see what value works best for you.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublishAssetsInParallel() {
        return null;
    }

    /**
     * Reuse the same cross region support stack for all pipelines in the App.
     * <p>
     * Default: - true (Use the same support stack for all pipelines in App)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReuseCrossRegionSupportStacks() {
        return null;
    }

    /**
     * The IAM role to be assumed by this Pipeline.
     * <p>
     * Default: - A new role is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Whether the pipeline will update itself.
     * <p>
     * This needs to be set to <code>true</code> to allow the pipeline to reconfigure
     * itself when assets or stages are being added to it, and <code>true</code> is the
     * recommended setting.
     * <p>
     * You can temporarily set this to <code>false</code> while you are iterating
     * on the pipeline itself and prefer to deploy changes using <code>cdk deploy</code>.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSelfMutation() {
        return null;
    }

    /**
     * Additional customizations to apply to the self mutation CodeBuild projects.
     * <p>
     * Default: - Only `codeBuildDefaults` are applied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.CodeBuildOptions getSelfMutationCodeBuildDefaults() {
        return null;
    }

    /**
     * Additional customizations to apply to the synthesize CodeBuild projects.
     * <p>
     * Default: - Only `codeBuildDefaults` are applied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.CodeBuildOptions getSynthCodeBuildDefaults() {
        return null;
    }

    /**
     * Deploy every stack by creating a change set and executing it.
     * <p>
     * When enabled, creates a "Prepare" and "Execute" action for each stack. Disable
     * to deploy the stack in one pipeline action.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseChangeSets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodePipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodePipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodePipelineProps> {
        software.amazon.awscdk.pipelines.IFileSetProducer synth;
        software.amazon.awscdk.services.s3.IBucket artifactBucket;
        software.amazon.awscdk.pipelines.CodeBuildOptions assetPublishingCodeBuildDefaults;
        java.lang.String cliVersion;
        software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults;
        software.amazon.awscdk.services.codepipeline.Pipeline codePipeline;
        java.lang.Boolean crossAccountKeys;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets;
        java.util.List<software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials;
        java.lang.Boolean dockerEnabledForSelfMutation;
        java.lang.Boolean dockerEnabledForSynth;
        java.lang.Boolean enableKeyRotation;
        java.lang.String pipelineName;
        java.lang.Boolean publishAssetsInParallel;
        java.lang.Boolean reuseCrossRegionSupportStacks;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.Boolean selfMutation;
        software.amazon.awscdk.pipelines.CodeBuildOptions selfMutationCodeBuildDefaults;
        software.amazon.awscdk.pipelines.CodeBuildOptions synthCodeBuildDefaults;
        java.lang.Boolean useChangeSets;

        /**
         * Sets the value of {@link CodePipelineProps#getSynth}
         * @param synth The build step that produces the CDK Cloud Assembly. This parameter is required.
         *              The primary output of this step needs to be the <code>cdk.out</code> directory
         *              generated by the <code>cdk synth</code> command.
         *              <p>
         *              If you use a <code>ShellStep</code> here and you don't configure an output directory,
         *              the output directory will automatically be assumed to be <code>cdk.out</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synth(software.amazon.awscdk.pipelines.IFileSetProducer synth) {
            this.synth = synth;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getArtifactBucket}
         * @param artifactBucket An existing S3 Bucket to use for storing the pipeline's artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBucket(software.amazon.awscdk.services.s3.IBucket artifactBucket) {
            this.artifactBucket = artifactBucket;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getAssetPublishingCodeBuildDefaults}
         * @param assetPublishingCodeBuildDefaults Additional customizations to apply to the asset publishing CodeBuild projects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetPublishingCodeBuildDefaults(software.amazon.awscdk.pipelines.CodeBuildOptions assetPublishingCodeBuildDefaults) {
            this.assetPublishingCodeBuildDefaults = assetPublishingCodeBuildDefaults;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getCliVersion}
         * @param cliVersion CDK CLI version to use in self-mutation and asset publishing steps.
         *                   If you want to lock the CDK CLI version used in the pipeline, by steps
         *                   that are automatically generated for you, specify the version here.
         *                   <p>
         *                   We recommend you do not specify this value, as not specifying it always
         *                   uses the latest CLI version which is backwards compatible with old versions.
         *                   <p>
         *                   If you do specify it, be aware that this version should always be equal to or higher than the
         *                   version of the CDK framework used by the CDK app, when the CDK commands are
         *                   run during your pipeline execution. When you change this version, the <em>next
         *                   time</em> the <code>SelfMutate</code> step runs it will still be using the CLI of the the
         *                   <em>previous</em> version that was in this property: it will only start using the
         *                   new version after <code>SelfMutate</code> completes successfully. That means that if
         *                   you want to update both framework and CLI version, you should update the
         *                   CLI version first, commit, push and deploy, and only then update the
         *                   framework version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cliVersion(java.lang.String cliVersion) {
            this.cliVersion = cliVersion;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getCodeBuildDefaults}
         * @param codeBuildDefaults Customize the CodeBuild projects created for this pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeBuildDefaults(software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults) {
            this.codeBuildDefaults = codeBuildDefaults;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getCodePipeline}
         * @param codePipeline An existing Pipeline to be reused and built upon.
         *                     [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codePipeline(software.amazon.awscdk.services.codepipeline.Pipeline codePipeline) {
            this.codePipeline = codePipeline;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getCrossAccountKeys}
         * @param crossAccountKeys Create KMS keys for the artifact buckets, allowing cross-account deployments.
         *                         The artifact buckets have to be encrypted to support deploying CDK apps to
         *                         another account, so if you want to do that or want to have your artifact
         *                         buckets encrypted, be sure to set this value to <code>true</code>.
         *                         <p>
         *                         Be aware there is a cost associated with maintaining the KMS keys.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountKeys(java.lang.Boolean crossAccountKeys) {
            this.crossAccountKeys = crossAccountKeys;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getCrossRegionReplicationBuckets}
         * @param crossRegionReplicationBuckets A map of region to S3 bucket name used for cross-region CodePipeline.
         *                                      For every Action that you specify targeting a different region than the Pipeline itself,
         *                                      if you don't provide an explicit Bucket for that region using this property,
         *                                      the construct will automatically create a Stack containing an S3 Bucket in that region.
         *                                      Passed directly through to the {@link cp.Pipeline}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder crossRegionReplicationBuckets(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets) {
            this.crossRegionReplicationBuckets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket>)crossRegionReplicationBuckets;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getDockerCredentials}
         * @param dockerCredentials A list of credentials used to authenticate to Docker registries.
         *                          Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder dockerCredentials(java.util.List<? extends software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials) {
            this.dockerCredentials = (java.util.List<software.amazon.awscdk.pipelines.DockerCredential>)dockerCredentials;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getDockerEnabledForSelfMutation}
         * @param dockerEnabledForSelfMutation Enable Docker for the self-mutate step.
         *                                     Set this to true if the pipeline itself uses Docker container assets
         *                                     (for example, if you use <code>LinuxBuildImage.fromAsset()</code> as the build
         *                                     image of a CodeBuild step in the pipeline).
         *                                     <p>
         *                                     You do not need to set it if you build Docker image assets in the
         *                                     application Stages and Stacks that are <em>deployed</em> by this pipeline.
         *                                     <p>
         *                                     Configures privileged mode for the self-mutation CodeBuild action.
         *                                     <p>
         *                                     If you are about to turn this on in an already-deployed Pipeline,
         *                                     set the value to <code>true</code> first, commit and allow the pipeline to
         *                                     self-update, and only then use the Docker asset in the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerEnabledForSelfMutation(java.lang.Boolean dockerEnabledForSelfMutation) {
            this.dockerEnabledForSelfMutation = dockerEnabledForSelfMutation;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getDockerEnabledForSynth}
         * @param dockerEnabledForSynth Enable Docker for the 'synth' step.
         *                              Set this to true if you are using file assets that require
         *                              "bundling" anywhere in your application (meaning an asset
         *                              compilation step will be run with the tools provided by
         *                              a Docker image), both for the Pipeline stack as well as the
         *                              application stacks.
         *                              <p>
         *                              A common way to use bundling assets in your application is by
         *                              using the <code>aws-cdk-lib/aws-lambda-nodejs</code> library.
         *                              <p>
         *                              Configures privileged mode for the synth CodeBuild action.
         *                              <p>
         *                              If you are about to turn this on in an already-deployed Pipeline,
         *                              set the value to <code>true</code> first, commit and allow the pipeline to
         *                              self-update, and only then use the bundled asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerEnabledForSynth(java.lang.Boolean dockerEnabledForSynth) {
            this.dockerEnabledForSynth = dockerEnabledForSynth;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getEnableKeyRotation}
         * @param enableKeyRotation Enable KMS key rotation for the generated KMS keys.
         *                          By default KMS key rotation is disabled, but will add
         *                          additional costs when enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(java.lang.Boolean enableKeyRotation) {
            this.enableKeyRotation = enableKeyRotation;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getPipelineName}
         * @param pipelineName The name of the CodePipeline pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(java.lang.String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getPublishAssetsInParallel}
         * @param publishAssetsInParallel Publish assets in multiple CodeBuild projects.
         *                                If set to false, use one Project per type to publish all assets.
         *                                <p>
         *                                Publishing in parallel improves concurrency and may reduce publishing
         *                                latency, but may also increase overall provisioning time of the CodeBuild
         *                                projects.
         *                                <p>
         *                                Experiment and see what value works best for you.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishAssetsInParallel(java.lang.Boolean publishAssetsInParallel) {
            this.publishAssetsInParallel = publishAssetsInParallel;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getReuseCrossRegionSupportStacks}
         * @param reuseCrossRegionSupportStacks Reuse the same cross region support stack for all pipelines in the App.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reuseCrossRegionSupportStacks(java.lang.Boolean reuseCrossRegionSupportStacks) {
            this.reuseCrossRegionSupportStacks = reuseCrossRegionSupportStacks;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getRole}
         * @param role The IAM role to be assumed by this Pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getSelfMutation}
         * @param selfMutation Whether the pipeline will update itself.
         *                     This needs to be set to <code>true</code> to allow the pipeline to reconfigure
         *                     itself when assets or stages are being added to it, and <code>true</code> is the
         *                     recommended setting.
         *                     <p>
         *                     You can temporarily set this to <code>false</code> while you are iterating
         *                     on the pipeline itself and prefer to deploy changes using <code>cdk deploy</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfMutation(java.lang.Boolean selfMutation) {
            this.selfMutation = selfMutation;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getSelfMutationCodeBuildDefaults}
         * @param selfMutationCodeBuildDefaults Additional customizations to apply to the self mutation CodeBuild projects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfMutationCodeBuildDefaults(software.amazon.awscdk.pipelines.CodeBuildOptions selfMutationCodeBuildDefaults) {
            this.selfMutationCodeBuildDefaults = selfMutationCodeBuildDefaults;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getSynthCodeBuildDefaults}
         * @param synthCodeBuildDefaults Additional customizations to apply to the synthesize CodeBuild projects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synthCodeBuildDefaults(software.amazon.awscdk.pipelines.CodeBuildOptions synthCodeBuildDefaults) {
            this.synthCodeBuildDefaults = synthCodeBuildDefaults;
            return this;
        }

        /**
         * Sets the value of {@link CodePipelineProps#getUseChangeSets}
         * @param useChangeSets Deploy every stack by creating a change set and executing it.
         *                      When enabled, creates a "Prepare" and "Execute" action for each stack. Disable
         *                      to deploy the stack in one pipeline action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useChangeSets(java.lang.Boolean useChangeSets) {
            this.useChangeSets = useChangeSets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodePipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodePipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodePipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodePipelineProps {
        private final software.amazon.awscdk.pipelines.IFileSetProducer synth;
        private final software.amazon.awscdk.services.s3.IBucket artifactBucket;
        private final software.amazon.awscdk.pipelines.CodeBuildOptions assetPublishingCodeBuildDefaults;
        private final java.lang.String cliVersion;
        private final software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults;
        private final software.amazon.awscdk.services.codepipeline.Pipeline codePipeline;
        private final java.lang.Boolean crossAccountKeys;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets;
        private final java.util.List<software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials;
        private final java.lang.Boolean dockerEnabledForSelfMutation;
        private final java.lang.Boolean dockerEnabledForSynth;
        private final java.lang.Boolean enableKeyRotation;
        private final java.lang.String pipelineName;
        private final java.lang.Boolean publishAssetsInParallel;
        private final java.lang.Boolean reuseCrossRegionSupportStacks;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.Boolean selfMutation;
        private final software.amazon.awscdk.pipelines.CodeBuildOptions selfMutationCodeBuildDefaults;
        private final software.amazon.awscdk.pipelines.CodeBuildOptions synthCodeBuildDefaults;
        private final java.lang.Boolean useChangeSets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.synth = software.amazon.jsii.Kernel.get(this, "synth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.IFileSetProducer.class));
            this.artifactBucket = software.amazon.jsii.Kernel.get(this, "artifactBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.assetPublishingCodeBuildDefaults = software.amazon.jsii.Kernel.get(this, "assetPublishingCodeBuildDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodeBuildOptions.class));
            this.cliVersion = software.amazon.jsii.Kernel.get(this, "cliVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeBuildDefaults = software.amazon.jsii.Kernel.get(this, "codeBuildDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodeBuildOptions.class));
            this.codePipeline = software.amazon.jsii.Kernel.get(this, "codePipeline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Pipeline.class));
            this.crossAccountKeys = software.amazon.jsii.Kernel.get(this, "crossAccountKeys", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.crossRegionReplicationBuckets = software.amazon.jsii.Kernel.get(this, "crossRegionReplicationBuckets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.dockerCredentials = software.amazon.jsii.Kernel.get(this, "dockerCredentials", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.DockerCredential.class)));
            this.dockerEnabledForSelfMutation = software.amazon.jsii.Kernel.get(this, "dockerEnabledForSelfMutation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dockerEnabledForSynth = software.amazon.jsii.Kernel.get(this, "dockerEnabledForSynth", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableKeyRotation = software.amazon.jsii.Kernel.get(this, "enableKeyRotation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.pipelineName = software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publishAssetsInParallel = software.amazon.jsii.Kernel.get(this, "publishAssetsInParallel", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.reuseCrossRegionSupportStacks = software.amazon.jsii.Kernel.get(this, "reuseCrossRegionSupportStacks", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.selfMutation = software.amazon.jsii.Kernel.get(this, "selfMutation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.selfMutationCodeBuildDefaults = software.amazon.jsii.Kernel.get(this, "selfMutationCodeBuildDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodeBuildOptions.class));
            this.synthCodeBuildDefaults = software.amazon.jsii.Kernel.get(this, "synthCodeBuildDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodeBuildOptions.class));
            this.useChangeSets = software.amazon.jsii.Kernel.get(this, "useChangeSets", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.synth = java.util.Objects.requireNonNull(builder.synth, "synth is required");
            this.artifactBucket = builder.artifactBucket;
            this.assetPublishingCodeBuildDefaults = builder.assetPublishingCodeBuildDefaults;
            this.cliVersion = builder.cliVersion;
            this.codeBuildDefaults = builder.codeBuildDefaults;
            this.codePipeline = builder.codePipeline;
            this.crossAccountKeys = builder.crossAccountKeys;
            this.crossRegionReplicationBuckets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket>)builder.crossRegionReplicationBuckets;
            this.dockerCredentials = (java.util.List<software.amazon.awscdk.pipelines.DockerCredential>)builder.dockerCredentials;
            this.dockerEnabledForSelfMutation = builder.dockerEnabledForSelfMutation;
            this.dockerEnabledForSynth = builder.dockerEnabledForSynth;
            this.enableKeyRotation = builder.enableKeyRotation;
            this.pipelineName = builder.pipelineName;
            this.publishAssetsInParallel = builder.publishAssetsInParallel;
            this.reuseCrossRegionSupportStacks = builder.reuseCrossRegionSupportStacks;
            this.role = builder.role;
            this.selfMutation = builder.selfMutation;
            this.selfMutationCodeBuildDefaults = builder.selfMutationCodeBuildDefaults;
            this.synthCodeBuildDefaults = builder.synthCodeBuildDefaults;
            this.useChangeSets = builder.useChangeSets;
        }

        @Override
        public final software.amazon.awscdk.pipelines.IFileSetProducer getSynth() {
            return this.synth;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
            return this.artifactBucket;
        }

        @Override
        public final software.amazon.awscdk.pipelines.CodeBuildOptions getAssetPublishingCodeBuildDefaults() {
            return this.assetPublishingCodeBuildDefaults;
        }

        @Override
        public final java.lang.String getCliVersion() {
            return this.cliVersion;
        }

        @Override
        public final software.amazon.awscdk.pipelines.CodeBuildOptions getCodeBuildDefaults() {
            return this.codeBuildDefaults;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Pipeline getCodePipeline() {
            return this.codePipeline;
        }

        @Override
        public final java.lang.Boolean getCrossAccountKeys() {
            return this.crossAccountKeys;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> getCrossRegionReplicationBuckets() {
            return this.crossRegionReplicationBuckets;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.DockerCredential> getDockerCredentials() {
            return this.dockerCredentials;
        }

        @Override
        public final java.lang.Boolean getDockerEnabledForSelfMutation() {
            return this.dockerEnabledForSelfMutation;
        }

        @Override
        public final java.lang.Boolean getDockerEnabledForSynth() {
            return this.dockerEnabledForSynth;
        }

        @Override
        public final java.lang.Boolean getEnableKeyRotation() {
            return this.enableKeyRotation;
        }

        @Override
        public final java.lang.String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final java.lang.Boolean getPublishAssetsInParallel() {
            return this.publishAssetsInParallel;
        }

        @Override
        public final java.lang.Boolean getReuseCrossRegionSupportStacks() {
            return this.reuseCrossRegionSupportStacks;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.Boolean getSelfMutation() {
            return this.selfMutation;
        }

        @Override
        public final software.amazon.awscdk.pipelines.CodeBuildOptions getSelfMutationCodeBuildDefaults() {
            return this.selfMutationCodeBuildDefaults;
        }

        @Override
        public final software.amazon.awscdk.pipelines.CodeBuildOptions getSynthCodeBuildDefaults() {
            return this.synthCodeBuildDefaults;
        }

        @Override
        public final java.lang.Boolean getUseChangeSets() {
            return this.useChangeSets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("synth", om.valueToTree(this.getSynth()));
            if (this.getArtifactBucket() != null) {
                data.set("artifactBucket", om.valueToTree(this.getArtifactBucket()));
            }
            if (this.getAssetPublishingCodeBuildDefaults() != null) {
                data.set("assetPublishingCodeBuildDefaults", om.valueToTree(this.getAssetPublishingCodeBuildDefaults()));
            }
            if (this.getCliVersion() != null) {
                data.set("cliVersion", om.valueToTree(this.getCliVersion()));
            }
            if (this.getCodeBuildDefaults() != null) {
                data.set("codeBuildDefaults", om.valueToTree(this.getCodeBuildDefaults()));
            }
            if (this.getCodePipeline() != null) {
                data.set("codePipeline", om.valueToTree(this.getCodePipeline()));
            }
            if (this.getCrossAccountKeys() != null) {
                data.set("crossAccountKeys", om.valueToTree(this.getCrossAccountKeys()));
            }
            if (this.getCrossRegionReplicationBuckets() != null) {
                data.set("crossRegionReplicationBuckets", om.valueToTree(this.getCrossRegionReplicationBuckets()));
            }
            if (this.getDockerCredentials() != null) {
                data.set("dockerCredentials", om.valueToTree(this.getDockerCredentials()));
            }
            if (this.getDockerEnabledForSelfMutation() != null) {
                data.set("dockerEnabledForSelfMutation", om.valueToTree(this.getDockerEnabledForSelfMutation()));
            }
            if (this.getDockerEnabledForSynth() != null) {
                data.set("dockerEnabledForSynth", om.valueToTree(this.getDockerEnabledForSynth()));
            }
            if (this.getEnableKeyRotation() != null) {
                data.set("enableKeyRotation", om.valueToTree(this.getEnableKeyRotation()));
            }
            if (this.getPipelineName() != null) {
                data.set("pipelineName", om.valueToTree(this.getPipelineName()));
            }
            if (this.getPublishAssetsInParallel() != null) {
                data.set("publishAssetsInParallel", om.valueToTree(this.getPublishAssetsInParallel()));
            }
            if (this.getReuseCrossRegionSupportStacks() != null) {
                data.set("reuseCrossRegionSupportStacks", om.valueToTree(this.getReuseCrossRegionSupportStacks()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSelfMutation() != null) {
                data.set("selfMutation", om.valueToTree(this.getSelfMutation()));
            }
            if (this.getSelfMutationCodeBuildDefaults() != null) {
                data.set("selfMutationCodeBuildDefaults", om.valueToTree(this.getSelfMutationCodeBuildDefaults()));
            }
            if (this.getSynthCodeBuildDefaults() != null) {
                data.set("synthCodeBuildDefaults", om.valueToTree(this.getSynthCodeBuildDefaults()));
            }
            if (this.getUseChangeSets() != null) {
                data.set("useChangeSets", om.valueToTree(this.getUseChangeSets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.CodePipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodePipelineProps.Jsii$Proxy that = (CodePipelineProps.Jsii$Proxy) o;

            if (!synth.equals(that.synth)) return false;
            if (this.artifactBucket != null ? !this.artifactBucket.equals(that.artifactBucket) : that.artifactBucket != null) return false;
            if (this.assetPublishingCodeBuildDefaults != null ? !this.assetPublishingCodeBuildDefaults.equals(that.assetPublishingCodeBuildDefaults) : that.assetPublishingCodeBuildDefaults != null) return false;
            if (this.cliVersion != null ? !this.cliVersion.equals(that.cliVersion) : that.cliVersion != null) return false;
            if (this.codeBuildDefaults != null ? !this.codeBuildDefaults.equals(that.codeBuildDefaults) : that.codeBuildDefaults != null) return false;
            if (this.codePipeline != null ? !this.codePipeline.equals(that.codePipeline) : that.codePipeline != null) return false;
            if (this.crossAccountKeys != null ? !this.crossAccountKeys.equals(that.crossAccountKeys) : that.crossAccountKeys != null) return false;
            if (this.crossRegionReplicationBuckets != null ? !this.crossRegionReplicationBuckets.equals(that.crossRegionReplicationBuckets) : that.crossRegionReplicationBuckets != null) return false;
            if (this.dockerCredentials != null ? !this.dockerCredentials.equals(that.dockerCredentials) : that.dockerCredentials != null) return false;
            if (this.dockerEnabledForSelfMutation != null ? !this.dockerEnabledForSelfMutation.equals(that.dockerEnabledForSelfMutation) : that.dockerEnabledForSelfMutation != null) return false;
            if (this.dockerEnabledForSynth != null ? !this.dockerEnabledForSynth.equals(that.dockerEnabledForSynth) : that.dockerEnabledForSynth != null) return false;
            if (this.enableKeyRotation != null ? !this.enableKeyRotation.equals(that.enableKeyRotation) : that.enableKeyRotation != null) return false;
            if (this.pipelineName != null ? !this.pipelineName.equals(that.pipelineName) : that.pipelineName != null) return false;
            if (this.publishAssetsInParallel != null ? !this.publishAssetsInParallel.equals(that.publishAssetsInParallel) : that.publishAssetsInParallel != null) return false;
            if (this.reuseCrossRegionSupportStacks != null ? !this.reuseCrossRegionSupportStacks.equals(that.reuseCrossRegionSupportStacks) : that.reuseCrossRegionSupportStacks != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.selfMutation != null ? !this.selfMutation.equals(that.selfMutation) : that.selfMutation != null) return false;
            if (this.selfMutationCodeBuildDefaults != null ? !this.selfMutationCodeBuildDefaults.equals(that.selfMutationCodeBuildDefaults) : that.selfMutationCodeBuildDefaults != null) return false;
            if (this.synthCodeBuildDefaults != null ? !this.synthCodeBuildDefaults.equals(that.synthCodeBuildDefaults) : that.synthCodeBuildDefaults != null) return false;
            return this.useChangeSets != null ? this.useChangeSets.equals(that.useChangeSets) : that.useChangeSets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.synth.hashCode();
            result = 31 * result + (this.artifactBucket != null ? this.artifactBucket.hashCode() : 0);
            result = 31 * result + (this.assetPublishingCodeBuildDefaults != null ? this.assetPublishingCodeBuildDefaults.hashCode() : 0);
            result = 31 * result + (this.cliVersion != null ? this.cliVersion.hashCode() : 0);
            result = 31 * result + (this.codeBuildDefaults != null ? this.codeBuildDefaults.hashCode() : 0);
            result = 31 * result + (this.codePipeline != null ? this.codePipeline.hashCode() : 0);
            result = 31 * result + (this.crossAccountKeys != null ? this.crossAccountKeys.hashCode() : 0);
            result = 31 * result + (this.crossRegionReplicationBuckets != null ? this.crossRegionReplicationBuckets.hashCode() : 0);
            result = 31 * result + (this.dockerCredentials != null ? this.dockerCredentials.hashCode() : 0);
            result = 31 * result + (this.dockerEnabledForSelfMutation != null ? this.dockerEnabledForSelfMutation.hashCode() : 0);
            result = 31 * result + (this.dockerEnabledForSynth != null ? this.dockerEnabledForSynth.hashCode() : 0);
            result = 31 * result + (this.enableKeyRotation != null ? this.enableKeyRotation.hashCode() : 0);
            result = 31 * result + (this.pipelineName != null ? this.pipelineName.hashCode() : 0);
            result = 31 * result + (this.publishAssetsInParallel != null ? this.publishAssetsInParallel.hashCode() : 0);
            result = 31 * result + (this.reuseCrossRegionSupportStacks != null ? this.reuseCrossRegionSupportStacks.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.selfMutation != null ? this.selfMutation.hashCode() : 0);
            result = 31 * result + (this.selfMutationCodeBuildDefaults != null ? this.selfMutationCodeBuildDefaults.hashCode() : 0);
            result = 31 * result + (this.synthCodeBuildDefaults != null ? this.synthCodeBuildDefaults.hashCode() : 0);
            result = 31 * result + (this.useChangeSets != null ? this.useChangeSets.hashCode() : 0);
            return result;
        }
    }
}
