package software.amazon.awscdk.pipelines;

/**
 * Factory for CodePipeline source steps.
 * <p>
 * This class contains a number of factory methods for the different types
 * of sources that CodePipeline supports.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Access the CommitId of a GitHub source in the synth
 * CodePipelineSource source = CodePipelineSource.gitHub("owner/repo", "main");
 * CodePipeline pipeline = CodePipeline.Builder.create(scope, "MyPipeline")
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(source)
 *                 .commands(List.of())
 *                 .env(Map.of(
 *                         "COMMIT_ID", source.sourceAttribute("CommitId")))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:06.875Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CodePipelineSource")
public abstract class CodePipelineSource extends software.amazon.awscdk.pipelines.Step implements software.amazon.awscdk.pipelines.ICodePipelineActionFactory {

    protected CodePipelineSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodePipelineSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id Identifier for this step. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected CodePipelineSource(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Returns a CodeCommit source.
     * <p>
     * If you need access to symlinks or the repository history, be sure to set
     * <code>codeBuildCloneOutput</code>.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * IRepository repository;
     * CodePipelineSource.codeCommit(repository, "main");
     * </pre></blockquote>
     * <p>
     * @param repository The CodeCommit repository. This parameter is required.
     * @param branch The branch to use. This parameter is required.
     * @param props The source properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineSource codeCommit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository repository, final @org.jetbrains.annotations.NotNull java.lang.String branch, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.CodeCommitSourceOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.CodePipelineSource.class, "codeCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineSource.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), java.util.Objects.requireNonNull(branch, "branch is required"), props });
    }

    /**
     * Returns a CodeCommit source.
     * <p>
     * If you need access to symlinks or the repository history, be sure to set
     * <code>codeBuildCloneOutput</code>.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * IRepository repository;
     * CodePipelineSource.codeCommit(repository, "main");
     * </pre></blockquote>
     * <p>
     * @param repository The CodeCommit repository. This parameter is required.
     * @param branch The branch to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineSource codeCommit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository repository, final @org.jetbrains.annotations.NotNull java.lang.String branch) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.CodePipelineSource.class, "codeCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineSource.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), java.util.Objects.requireNonNull(branch, "branch is required") });
    }

    /**
     * Returns a CodeStar connection source.
     * <p>
     * A CodeStar connection allows AWS CodePipeline to
     * access external resources, such as repositories in GitHub, GitHub Enterprise or
     * BitBucket.
     * <p>
     * To use this method, you first need to create a CodeStar connection
     * using the AWS console. In the process, you may have to sign in to the external provider
     * -- GitHub, for example -- to authorize AWS to read and modify your repository.
     * Once you have done this, copy the connection ARN and use it to create the source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * CodePipelineSource.connection("owner/repo", "main", ConnectionSourceOptions.builder()
     *         .connectionArn("arn:aws:codestar-connections:us-east-1:222222222222:connection/7d2469ff-514a-4e4f-9003-5ca4a43cdc41")
     *         .build());
     * </pre></blockquote>
     * <p>
     * If you need access to symlinks or the repository history, be sure to set
     * <code>codeBuildCloneOutput</code>.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/welcome-connections.html">https://docs.aws.amazon.com/dtconsole/latest/userguide/welcome-connections.html</a>
     * @param repoString A string that encodes owner and repository separated by a slash (e.g. 'owner/repo'). The provided string must be resolvable at runtime. This parameter is required.
     * @param branch The branch to use. This parameter is required.
     * @param props The source properties, including the connection ARN. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineSource connection(final @org.jetbrains.annotations.NotNull java.lang.String repoString, final @org.jetbrains.annotations.NotNull java.lang.String branch, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.ConnectionSourceOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.CodePipelineSource.class, "connection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineSource.class), new Object[] { java.util.Objects.requireNonNull(repoString, "repoString is required"), java.util.Objects.requireNonNull(branch, "branch is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns an ECR source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * IRepository repository;
     * CodePipelineSource.ecr(repository, ECRSourceOptions.builder()
     *         .imageTag("latest")
     *         .build());
     * </pre></blockquote>
     * <p>
     * @param repository The repository that will be watched for changes. This parameter is required.
     * @param props The options, which include the image tag to be checked for changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineSource ecr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.ECRSourceOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.CodePipelineSource.class, "ecr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineSource.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), props });
    }

    /**
     * Returns an ECR source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * IRepository repository;
     * CodePipelineSource.ecr(repository, ECRSourceOptions.builder()
     *         .imageTag("latest")
     *         .build());
     * </pre></blockquote>
     * <p>
     * @param repository The repository that will be watched for changes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineSource ecr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.CodePipelineSource.class, "ecr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineSource.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Returns a GitHub source, using OAuth tokens to authenticate with GitHub and a separate webhook to detect changes.
     * <p>
     * This is no longer
     * the recommended method. Please consider using <code>connection()</code>
     * instead.
     * <p>
     * Pass in the owner and repository in a single string, like this:
     * <p>
     * <blockquote><pre>
     * CodePipelineSource.gitHub("owner/repo", "main");
     * </pre></blockquote>
     * <p>
     * Authentication will be done by a secret called <code>github-token</code> in AWS
     * Secrets Manager (unless specified otherwise).
     * <p>
     * If you rotate the value in the Secret, you must also change at least one property
     * on the Pipeline, to force CloudFormation to re-read the secret.
     * <p>
     * The token should have these permissions:
     * <p>
     * <ul>
     * <li><strong>repo</strong> - to read the repository</li>
     * <li><strong>admin:repo_hook</strong> - if you plan to use webhooks (true by default)</li>
     * </ul>
     * <p>
     * If you need access to symlinks or the repository history, use a source of type
     * <code>connection</code> instead.
     * <p>
     * @param repoString This parameter is required.
     * @param branch This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineSource gitHub(final @org.jetbrains.annotations.NotNull java.lang.String repoString, final @org.jetbrains.annotations.NotNull java.lang.String branch, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.GitHubSourceOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.CodePipelineSource.class, "gitHub", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineSource.class), new Object[] { java.util.Objects.requireNonNull(repoString, "repoString is required"), java.util.Objects.requireNonNull(branch, "branch is required"), props });
    }

    /**
     * Returns a GitHub source, using OAuth tokens to authenticate with GitHub and a separate webhook to detect changes.
     * <p>
     * This is no longer
     * the recommended method. Please consider using <code>connection()</code>
     * instead.
     * <p>
     * Pass in the owner and repository in a single string, like this:
     * <p>
     * <blockquote><pre>
     * CodePipelineSource.gitHub("owner/repo", "main");
     * </pre></blockquote>
     * <p>
     * Authentication will be done by a secret called <code>github-token</code> in AWS
     * Secrets Manager (unless specified otherwise).
     * <p>
     * If you rotate the value in the Secret, you must also change at least one property
     * on the Pipeline, to force CloudFormation to re-read the secret.
     * <p>
     * The token should have these permissions:
     * <p>
     * <ul>
     * <li><strong>repo</strong> - to read the repository</li>
     * <li><strong>admin:repo_hook</strong> - if you plan to use webhooks (true by default)</li>
     * </ul>
     * <p>
     * If you need access to symlinks or the repository history, use a source of type
     * <code>connection</code> instead.
     * <p>
     * @param repoString This parameter is required.
     * @param branch This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineSource gitHub(final @org.jetbrains.annotations.NotNull java.lang.String repoString, final @org.jetbrains.annotations.NotNull java.lang.String branch) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.CodePipelineSource.class, "gitHub", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineSource.class), new Object[] { java.util.Objects.requireNonNull(repoString, "repoString is required"), java.util.Objects.requireNonNull(branch, "branch is required") });
    }

    /**
     * Returns an S3 source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Bucket bucket;
     * CodePipelineSource.s3(bucket, "path/to/file.zip");
     * </pre></blockquote>
     * <p>
     * @param bucket The bucket where the source code is located. This parameter is required.
     * @param objectKey This parameter is required.
     * @param props The options, which include the key that identifies the source code file and and how the pipeline should be triggered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineSource s3(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String objectKey, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.S3SourceOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.CodePipelineSource.class, "s3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineSource.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(objectKey, "objectKey is required"), props });
    }

    /**
     * Returns an S3 source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Bucket bucket;
     * CodePipelineSource.s3(bucket, "path/to/file.zip");
     * </pre></blockquote>
     * <p>
     * @param bucket The bucket where the source code is located. This parameter is required.
     * @param objectKey This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineSource s3(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String objectKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.CodePipelineSource.class, "s3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineSource.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(objectKey, "objectKey is required") });
    }

    /**
     * @param output This parameter is required.
     * @param actionName This parameter is required.
     * @param runOrder This parameter is required.
     * @param variablesNamespace
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Action getAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact output, final @org.jetbrains.annotations.NotNull java.lang.String actionName, final @org.jetbrains.annotations.NotNull java.lang.Number runOrder, final @org.jetbrains.annotations.Nullable java.lang.String variablesNamespace);

    /**
     * @param output This parameter is required.
     * @param actionName This parameter is required.
     * @param runOrder This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Action getAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact output, final @org.jetbrains.annotations.NotNull java.lang.String actionName, final @org.jetbrains.annotations.NotNull java.lang.Number runOrder);

    /**
     * Create the desired Action and add it to the pipeline.
     * <p>
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineActionFactoryResult produceAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.ProduceActionOptions options) {
        return software.amazon.jsii.Kernel.call(this, "produceAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineActionFactoryResult.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Return an attribute of the current source revision.
     * <p>
     * These values can be passed into the environment variables of pipeline steps,
     * so your steps can access information about the source revision.
     * <p>
     * Pipeline synth step has some source attributes predefined in the environment.
     * If these suffice, you don't need to use this method for the synth step.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // Access the CommitId of a GitHub source in the synth
     * CodePipelineSource source = CodePipelineSource.gitHub("owner/repo", "main");
     * CodePipeline pipeline = CodePipeline.Builder.create(scope, "MyPipeline")
     *         .synth(ShellStep.Builder.create("Synth")
     *                 .input(source)
     *                 .commands(List.of())
     *                 .env(Map.of(
     *                         "COMMIT_ID", source.sourceAttribute("CommitId")))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-variables.html#reference-variables-list">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-variables.html#reference-variables-list</a>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String sourceAttribute(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.Kernel.call(this, "sourceAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Whether or not this is a Source step.
     * <p>
     * What it means to be a Source step depends on the engine.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsSource() {
        return software.amazon.jsii.Kernel.get(this, "isSource", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.pipelines.CodePipelineSource implements software.amazon.awscdk.pipelines.ICodePipelineActionFactory.Jsii$Default, software.amazon.awscdk.pipelines.IFileSetProducer.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * @param output This parameter is required.
         * @param actionName This parameter is required.
         * @param runOrder This parameter is required.
         * @param variablesNamespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        protected final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Action getAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact output, final @org.jetbrains.annotations.NotNull java.lang.String actionName, final @org.jetbrains.annotations.NotNull java.lang.Number runOrder, final @org.jetbrains.annotations.Nullable java.lang.String variablesNamespace) {
            return software.amazon.jsii.Kernel.call(this, "getAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.Action.class), new Object[] { java.util.Objects.requireNonNull(output, "output is required"), java.util.Objects.requireNonNull(actionName, "actionName is required"), java.util.Objects.requireNonNull(runOrder, "runOrder is required"), variablesNamespace });
        }

        /**
         * @param output This parameter is required.
         * @param actionName This parameter is required.
         * @param runOrder This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        protected final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Action getAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact output, final @org.jetbrains.annotations.NotNull java.lang.String actionName, final @org.jetbrains.annotations.NotNull java.lang.Number runOrder) {
            return software.amazon.jsii.Kernel.call(this, "getAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.Action.class), new Object[] { java.util.Objects.requireNonNull(output, "output is required"), java.util.Objects.requireNonNull(actionName, "actionName is required"), java.util.Objects.requireNonNull(runOrder, "runOrder is required") });
        }
    }
}
