package software.amazon.awscdk.services.amazonmq;

/**
 * Properties for defining a <code>CfnBroker</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amazonmq.*;
 * CfnBrokerProps cfnBrokerProps = CfnBrokerProps.builder()
 *         .brokerName("brokerName")
 *         .deploymentMode("deploymentMode")
 *         .engineType("engineType")
 *         .hostInstanceType("hostInstanceType")
 *         .publiclyAccessible(false)
 *         .users(List.of(UserProperty.builder()
 *                 .password("password")
 *                 .username("username")
 *                 // the properties below are optional
 *                 .consoleAccess(false)
 *                 .groups(List.of("groups"))
 *                 .replicationUser(false)
 *                 .build()))
 *         // the properties below are optional
 *         .authenticationStrategy("authenticationStrategy")
 *         .autoMinorVersionUpgrade(false)
 *         .configuration(ConfigurationIdProperty.builder()
 *                 .id("id")
 *                 .revision(123)
 *                 .build())
 *         .dataReplicationMode("dataReplicationMode")
 *         .dataReplicationPrimaryBrokerArn("dataReplicationPrimaryBrokerArn")
 *         .encryptionOptions(EncryptionOptionsProperty.builder()
 *                 .useAwsOwnedKey(false)
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .engineVersion("engineVersion")
 *         .ldapServerMetadata(LdapServerMetadataProperty.builder()
 *                 .hosts(List.of("hosts"))
 *                 .roleBase("roleBase")
 *                 .roleSearchMatching("roleSearchMatching")
 *                 .serviceAccountPassword("serviceAccountPassword")
 *                 .serviceAccountUsername("serviceAccountUsername")
 *                 .userBase("userBase")
 *                 .userSearchMatching("userSearchMatching")
 *                 // the properties below are optional
 *                 .roleName("roleName")
 *                 .roleSearchSubtree(false)
 *                 .userRoleName("userRoleName")
 *                 .userSearchSubtree(false)
 *                 .build())
 *         .logs(LogListProperty.builder()
 *                 .audit(false)
 *                 .general(false)
 *                 .build())
 *         .maintenanceWindowStartTime(MaintenanceWindowProperty.builder()
 *                 .dayOfWeek("dayOfWeek")
 *                 .timeOfDay("timeOfDay")
 *                 .timeZone("timeZone")
 *                 .build())
 *         .securityGroups(List.of("securityGroups"))
 *         .storageType("storageType")
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(TagsEntryProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:52.059Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amazonmq.CfnBrokerProps")
@software.amazon.jsii.Jsii.Proxy(CfnBrokerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBrokerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the broker.
     * <p>
     * This value must be unique in your AWS account , 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
     * <p>
     * <blockquote>
     * <p>
     * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker names. Broker names are accessible to other AWS services, including C CloudWatch Logs . Broker names are not intended to be used for private or sensitive data.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-brokername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-brokername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBrokerName();

    /**
     * The deployment mode of the broker. Available values:.
     * <p>
     * <ul>
     * <li><code>SINGLE_INSTANCE</code></li>
     * <li><code>ACTIVE_STANDBY_MULTI_AZ</code></li>
     * <li><code>CLUSTER_MULTI_AZ</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-deploymentmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-deploymentmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentMode();

    /**
     * The type of broker engine.
     * <p>
     * Currently, Amazon MQ supports <code>ACTIVEMQ</code> and <code>RABBITMQ</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-enginetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-enginetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngineType();

    /**
     * The broker's instance type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-hostinstancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-hostinstancetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHostInstanceType();

    /**
     * Enables connections from applications outside of the VPC that hosts the broker's subnets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPubliclyAccessible();

    /**
     * The list of broker users (persons or applications) who can access queues and topics.
     * <p>
     * For Amazon MQ for RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent RabbitMQ users are created by via the RabbitMQ web console or by using the RabbitMQ management API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getUsers();

    /**
     * Optional.
     * <p>
     * The authentication strategy used to secure the broker. The default is <code>SIMPLE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-authenticationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-authenticationstrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationStrategy() {
        return null;
    }

    /**
     * Enables automatic upgrades to new minor versions for brokers, as new broker engine versions are released and supported by Amazon MQ.
     * <p>
     * Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return null;
    }

    /**
     * A list of information about the configuration.
     * <p>
     * Does not apply to RabbitMQ brokers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return null;
    }

    /**
     * Defines whether this broker is a part of a data replication pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-datareplicationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-datareplicationmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataReplicationMode() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data replication pair, and is applied to the replica broker.
     * <p>
     * Must be set when dataReplicationMode is set to CRDR.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-datareplicationprimarybrokerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-datareplicationprimarybrokerarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataReplicationPrimaryBrokerArn() {
        return null;
    }

    /**
     * Encryption options for the broker.
     * <p>
     * Does not apply to RabbitMQ brokers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionOptions() {
        return null;
    }

    /**
     * The version of the broker engine.
     * <p>
     * For a list of supported engine versions, see <a href="https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html">Engine</a> in the <em>Amazon MQ Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLdapServerMetadata() {
        return null;
    }

    /**
     * Enables Amazon CloudWatch logging for brokers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogs() {
        return null;
    }

    /**
     * The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindowStartTime() {
        return null;
    }

    /**
     * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-securitygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return null;
    }

    /**
     * The broker's storage type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-storagetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return null;
    }

    /**
     * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
     * <p>
     * If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ deployment (ACTIVEMQ) requires two subnets. A CLUSTER_MULTI_AZ deployment (RABBITMQ) has no subnet requirements when deployed with public accessibility, deployment without public accessibility requires at least one subnet.
     * <p>
     * <blockquote>
     * <p>
     * If you specify subnets in a shared VPC for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account . Amazon MQ will not be able to create VPC enpoints in VPCs that are not owned by your AWS account .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-subnetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return null;
    }

    /**
     * An array of key-value pairs.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <em>Billing and Cost Management User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBrokerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBrokerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBrokerProps> {
        java.lang.String brokerName;
        java.lang.String deploymentMode;
        java.lang.String engineType;
        java.lang.String hostInstanceType;
        java.lang.Object publiclyAccessible;
        java.lang.Object users;
        java.lang.String authenticationStrategy;
        java.lang.Object autoMinorVersionUpgrade;
        java.lang.Object configuration;
        java.lang.String dataReplicationMode;
        java.lang.String dataReplicationPrimaryBrokerArn;
        java.lang.Object encryptionOptions;
        java.lang.String engineVersion;
        java.lang.Object ldapServerMetadata;
        java.lang.Object logs;
        java.lang.Object maintenanceWindowStartTime;
        java.util.List<java.lang.String> securityGroups;
        java.lang.String storageType;
        java.util.List<java.lang.String> subnetIds;
        java.util.List<software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty> tags;

        /**
         * Sets the value of {@link CfnBrokerProps#getBrokerName}
         * @param brokerName The name of the broker. This parameter is required.
         *                   This value must be unique in your AWS account , 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   Do not add personally identifiable information (PII) or other confidential or sensitive information in broker names. Broker names are accessible to other AWS services, including C CloudWatch Logs . Broker names are not intended to be used for private or sensitive data.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder brokerName(java.lang.String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getDeploymentMode}
         * @param deploymentMode The deployment mode of the broker. Available values:. This parameter is required.
         *                       <ul>
         *                       <li><code>SINGLE_INSTANCE</code></li>
         *                       <li><code>ACTIVE_STANDBY_MULTI_AZ</code></li>
         *                       <li><code>CLUSTER_MULTI_AZ</code></li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentMode(java.lang.String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getEngineType}
         * @param engineType The type of broker engine. This parameter is required.
         *                   Currently, Amazon MQ supports <code>ACTIVEMQ</code> and <code>RABBITMQ</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineType(java.lang.String engineType) {
            this.engineType = engineType;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getHostInstanceType}
         * @param hostInstanceType The broker's instance type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostInstanceType(java.lang.String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getPubliclyAccessible}
         * @param publiclyAccessible Enables connections from applications outside of the VPC that hosts the broker's subnets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getPubliclyAccessible}
         * @param publiclyAccessible Enables connections from applications outside of the VPC that hosts the broker's subnets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getUsers}
         * @param users The list of broker users (persons or applications) who can access queues and topics. This parameter is required.
         *              For Amazon MQ for RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent RabbitMQ users are created by via the RabbitMQ web console or by using the RabbitMQ management API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(software.amazon.awscdk.IResolvable users) {
            this.users = users;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getUsers}
         * @param users The list of broker users (persons or applications) who can access queues and topics. This parameter is required.
         *              For Amazon MQ for RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent RabbitMQ users are created by via the RabbitMQ web console or by using the RabbitMQ management API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(java.util.List<? extends java.lang.Object> users) {
            this.users = users;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getAuthenticationStrategy}
         * @param authenticationStrategy Optional.
         *                               The authentication strategy used to secure the broker. The default is <code>SIMPLE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationStrategy(java.lang.String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade Enables automatic upgrades to new minor versions for brokers, as new broker engine versions are released and supported by Amazon MQ.
         *                                Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade Enables automatic upgrades to new minor versions for brokers, as new broker engine versions are released and supported by Amazon MQ.
         *                                Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(software.amazon.awscdk.IResolvable autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getConfiguration}
         * @param configuration A list of information about the configuration.
         *                      Does not apply to RabbitMQ brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getConfiguration}
         * @param configuration A list of information about the configuration.
         *                      Does not apply to RabbitMQ brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.amazonmq.CfnBroker.ConfigurationIdProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getDataReplicationMode}
         * @param dataReplicationMode Defines whether this broker is a part of a data replication pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataReplicationMode(java.lang.String dataReplicationMode) {
            this.dataReplicationMode = dataReplicationMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getDataReplicationPrimaryBrokerArn}
         * @param dataReplicationPrimaryBrokerArn The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data replication pair, and is applied to the replica broker.
         *                                        Must be set when dataReplicationMode is set to CRDR.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataReplicationPrimaryBrokerArn(java.lang.String dataReplicationPrimaryBrokerArn) {
            this.dataReplicationPrimaryBrokerArn = dataReplicationPrimaryBrokerArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getEncryptionOptions}
         * @param encryptionOptions Encryption options for the broker.
         *                          Does not apply to RabbitMQ brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionOptions(software.amazon.awscdk.IResolvable encryptionOptions) {
            this.encryptionOptions = encryptionOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getEncryptionOptions}
         * @param encryptionOptions Encryption options for the broker.
         *                          Does not apply to RabbitMQ brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionOptions(software.amazon.awscdk.services.amazonmq.CfnBroker.EncryptionOptionsProperty encryptionOptions) {
            this.encryptionOptions = encryptionOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getEngineVersion}
         * @param engineVersion The version of the broker engine.
         *                      For a list of supported engine versions, see <a href="https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html">Engine</a> in the <em>Amazon MQ Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getLdapServerMetadata}
         * @param ldapServerMetadata Optional.
         *                           The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ldapServerMetadata(software.amazon.awscdk.IResolvable ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getLdapServerMetadata}
         * @param ldapServerMetadata Optional.
         *                           The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ldapServerMetadata(software.amazon.awscdk.services.amazonmq.CfnBroker.LdapServerMetadataProperty ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getLogs}
         * @param logs Enables Amazon CloudWatch logging for brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logs(software.amazon.awscdk.IResolvable logs) {
            this.logs = logs;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getLogs}
         * @param logs Enables Amazon CloudWatch logging for brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logs(software.amazon.awscdk.services.amazonmq.CfnBroker.LogListProperty logs) {
            this.logs = logs;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getMaintenanceWindowStartTime}
         * @param maintenanceWindowStartTime The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindowStartTime(software.amazon.awscdk.IResolvable maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getMaintenanceWindowStartTime}
         * @param maintenanceWindowStartTime The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindowStartTime(software.amazon.awscdk.services.amazonmq.CfnBroker.MaintenanceWindowProperty maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getSecurityGroups}
         * @param securityGroups The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getStorageType}
         * @param storageType The broker's storage type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(java.lang.String storageType) {
            this.storageType = storageType;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getSubnetIds}
         * @param subnetIds The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
         *                  If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ deployment (ACTIVEMQ) requires two subnets. A CLUSTER_MULTI_AZ deployment (RABBITMQ) has no subnet requirements when deployed with public accessibility, deployment without public accessibility requires at least one subnet.
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  If you specify subnets in a shared VPC for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account . Amazon MQ will not be able to create VPC enpoints in VPCs that are not owned by your AWS account .
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnBrokerProps#getTags}
         * @param tags An array of key-value pairs.
         *             For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <em>Billing and Cost Management User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBrokerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBrokerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBrokerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBrokerProps {
        private final java.lang.String brokerName;
        private final java.lang.String deploymentMode;
        private final java.lang.String engineType;
        private final java.lang.String hostInstanceType;
        private final java.lang.Object publiclyAccessible;
        private final java.lang.Object users;
        private final java.lang.String authenticationStrategy;
        private final java.lang.Object autoMinorVersionUpgrade;
        private final java.lang.Object configuration;
        private final java.lang.String dataReplicationMode;
        private final java.lang.String dataReplicationPrimaryBrokerArn;
        private final java.lang.Object encryptionOptions;
        private final java.lang.String engineVersion;
        private final java.lang.Object ldapServerMetadata;
        private final java.lang.Object logs;
        private final java.lang.Object maintenanceWindowStartTime;
        private final java.util.List<java.lang.String> securityGroups;
        private final java.lang.String storageType;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.util.List<software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.brokerName = software.amazon.jsii.Kernel.get(this, "brokerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deploymentMode = software.amazon.jsii.Kernel.get(this, "deploymentMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineType = software.amazon.jsii.Kernel.get(this, "engineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostInstanceType = software.amazon.jsii.Kernel.get(this, "hostInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.users = software.amazon.jsii.Kernel.get(this, "users", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.authenticationStrategy = software.amazon.jsii.Kernel.get(this, "authenticationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataReplicationMode = software.amazon.jsii.Kernel.get(this, "dataReplicationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataReplicationPrimaryBrokerArn = software.amazon.jsii.Kernel.get(this, "dataReplicationPrimaryBrokerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionOptions = software.amazon.jsii.Kernel.get(this, "encryptionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ldapServerMetadata = software.amazon.jsii.Kernel.get(this, "ldapServerMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logs = software.amazon.jsii.Kernel.get(this, "logs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maintenanceWindowStartTime = software.amazon.jsii.Kernel.get(this, "maintenanceWindowStartTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.storageType = software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.brokerName = java.util.Objects.requireNonNull(builder.brokerName, "brokerName is required");
            this.deploymentMode = java.util.Objects.requireNonNull(builder.deploymentMode, "deploymentMode is required");
            this.engineType = java.util.Objects.requireNonNull(builder.engineType, "engineType is required");
            this.hostInstanceType = java.util.Objects.requireNonNull(builder.hostInstanceType, "hostInstanceType is required");
            this.publiclyAccessible = java.util.Objects.requireNonNull(builder.publiclyAccessible, "publiclyAccessible is required");
            this.users = java.util.Objects.requireNonNull(builder.users, "users is required");
            this.authenticationStrategy = builder.authenticationStrategy;
            this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
            this.configuration = builder.configuration;
            this.dataReplicationMode = builder.dataReplicationMode;
            this.dataReplicationPrimaryBrokerArn = builder.dataReplicationPrimaryBrokerArn;
            this.encryptionOptions = builder.encryptionOptions;
            this.engineVersion = builder.engineVersion;
            this.ldapServerMetadata = builder.ldapServerMetadata;
            this.logs = builder.logs;
            this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
            this.securityGroups = builder.securityGroups;
            this.storageType = builder.storageType;
            this.subnetIds = builder.subnetIds;
            this.tags = (java.util.List<software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty>)builder.tags;
        }

        @Override
        public final java.lang.String getBrokerName() {
            return this.brokerName;
        }

        @Override
        public final java.lang.String getDeploymentMode() {
            return this.deploymentMode;
        }

        @Override
        public final java.lang.String getEngineType() {
            return this.engineType;
        }

        @Override
        public final java.lang.String getHostInstanceType() {
            return this.hostInstanceType;
        }

        @Override
        public final java.lang.Object getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final java.lang.Object getUsers() {
            return this.users;
        }

        @Override
        public final java.lang.String getAuthenticationStrategy() {
            return this.authenticationStrategy;
        }

        @Override
        public final java.lang.Object getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getDataReplicationMode() {
            return this.dataReplicationMode;
        }

        @Override
        public final java.lang.String getDataReplicationPrimaryBrokerArn() {
            return this.dataReplicationPrimaryBrokerArn;
        }

        @Override
        public final java.lang.Object getEncryptionOptions() {
            return this.encryptionOptions;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.Object getLdapServerMetadata() {
            return this.ldapServerMetadata;
        }

        @Override
        public final java.lang.Object getLogs() {
            return this.logs;
        }

        @Override
        public final java.lang.Object getMaintenanceWindowStartTime() {
            return this.maintenanceWindowStartTime;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.String getStorageType() {
            return this.storageType;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("brokerName", om.valueToTree(this.getBrokerName()));
            data.set("deploymentMode", om.valueToTree(this.getDeploymentMode()));
            data.set("engineType", om.valueToTree(this.getEngineType()));
            data.set("hostInstanceType", om.valueToTree(this.getHostInstanceType()));
            data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            data.set("users", om.valueToTree(this.getUsers()));
            if (this.getAuthenticationStrategy() != null) {
                data.set("authenticationStrategy", om.valueToTree(this.getAuthenticationStrategy()));
            }
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getConfiguration() != null) {
                data.set("configuration", om.valueToTree(this.getConfiguration()));
            }
            if (this.getDataReplicationMode() != null) {
                data.set("dataReplicationMode", om.valueToTree(this.getDataReplicationMode()));
            }
            if (this.getDataReplicationPrimaryBrokerArn() != null) {
                data.set("dataReplicationPrimaryBrokerArn", om.valueToTree(this.getDataReplicationPrimaryBrokerArn()));
            }
            if (this.getEncryptionOptions() != null) {
                data.set("encryptionOptions", om.valueToTree(this.getEncryptionOptions()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getLdapServerMetadata() != null) {
                data.set("ldapServerMetadata", om.valueToTree(this.getLdapServerMetadata()));
            }
            if (this.getLogs() != null) {
                data.set("logs", om.valueToTree(this.getLogs()));
            }
            if (this.getMaintenanceWindowStartTime() != null) {
                data.set("maintenanceWindowStartTime", om.valueToTree(this.getMaintenanceWindowStartTime()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getStorageType() != null) {
                data.set("storageType", om.valueToTree(this.getStorageType()));
            }
            if (this.getSubnetIds() != null) {
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amazonmq.CfnBrokerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBrokerProps.Jsii$Proxy that = (CfnBrokerProps.Jsii$Proxy) o;

            if (!brokerName.equals(that.brokerName)) return false;
            if (!deploymentMode.equals(that.deploymentMode)) return false;
            if (!engineType.equals(that.engineType)) return false;
            if (!hostInstanceType.equals(that.hostInstanceType)) return false;
            if (!publiclyAccessible.equals(that.publiclyAccessible)) return false;
            if (!users.equals(that.users)) return false;
            if (this.authenticationStrategy != null ? !this.authenticationStrategy.equals(that.authenticationStrategy) : that.authenticationStrategy != null) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
            if (this.dataReplicationMode != null ? !this.dataReplicationMode.equals(that.dataReplicationMode) : that.dataReplicationMode != null) return false;
            if (this.dataReplicationPrimaryBrokerArn != null ? !this.dataReplicationPrimaryBrokerArn.equals(that.dataReplicationPrimaryBrokerArn) : that.dataReplicationPrimaryBrokerArn != null) return false;
            if (this.encryptionOptions != null ? !this.encryptionOptions.equals(that.encryptionOptions) : that.encryptionOptions != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.ldapServerMetadata != null ? !this.ldapServerMetadata.equals(that.ldapServerMetadata) : that.ldapServerMetadata != null) return false;
            if (this.logs != null ? !this.logs.equals(that.logs) : that.logs != null) return false;
            if (this.maintenanceWindowStartTime != null ? !this.maintenanceWindowStartTime.equals(that.maintenanceWindowStartTime) : that.maintenanceWindowStartTime != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.storageType != null ? !this.storageType.equals(that.storageType) : that.storageType != null) return false;
            if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.brokerName.hashCode();
            result = 31 * result + (this.deploymentMode.hashCode());
            result = 31 * result + (this.engineType.hashCode());
            result = 31 * result + (this.hostInstanceType.hashCode());
            result = 31 * result + (this.publiclyAccessible.hashCode());
            result = 31 * result + (this.users.hashCode());
            result = 31 * result + (this.authenticationStrategy != null ? this.authenticationStrategy.hashCode() : 0);
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
            result = 31 * result + (this.dataReplicationMode != null ? this.dataReplicationMode.hashCode() : 0);
            result = 31 * result + (this.dataReplicationPrimaryBrokerArn != null ? this.dataReplicationPrimaryBrokerArn.hashCode() : 0);
            result = 31 * result + (this.encryptionOptions != null ? this.encryptionOptions.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.ldapServerMetadata != null ? this.ldapServerMetadata.hashCode() : 0);
            result = 31 * result + (this.logs != null ? this.logs.hashCode() : 0);
            result = 31 * result + (this.maintenanceWindowStartTime != null ? this.maintenanceWindowStartTime.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
            result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
