package software.amazon.awscdk.services.apigatewayv2;

/**
 * Supported integration types.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:52.459Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpIntegrationType")
public enum HttpIntegrationType {
    /**
     * Integration type is an HTTP proxy.
     * <p>
     * For integrating the route or method request with an HTTP endpoint, with the
     * client request passed through as-is. This is also referred to as HTTP proxy
     * integration. For HTTP API private integrations, use an HTTP_PROXY integration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-http.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-http.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP_PROXY,
    /**
     * Integration type is an AWS proxy.
     * <p>
     * For integrating the route or method request with a Lambda function or other
     * AWS service action. This integration is also referred to as a Lambda proxy
     * integration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_PROXY,
}
