package software.amazon.awscdk.services.apigatewayv2;

/**
 * Supported HTTP methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpLambdaIntegration;
 * Function bookStoreDefaultFn;
 * HttpUrlIntegration getBooksIntegration = new HttpUrlIntegration("GetBooksIntegration", "https://get-books-proxy.example.com");
 * HttpLambdaIntegration bookStoreDefaultIntegration = new HttpLambdaIntegration("BooksIntegration", bookStoreDefaultFn);
 * HttpApi httpApi = new HttpApi(this, "HttpApi");
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/books")
 *         .methods(List.of(HttpMethod.GET))
 *         .integration(getBooksIntegration)
 *         .build());
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/books")
 *         .methods(List.of(HttpMethod.ANY))
 *         .integration(bookStoreDefaultIntegration)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:52.459Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpMethod")
public enum HttpMethod {
    /**
     * HTTP ANY.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ANY,
    /**
     * HTTP DELETE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELETE,
    /**
     * HTTP GET.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GET,
    /**
     * HTTP HEAD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HEAD,
    /**
     * HTTP OPTIONS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONS,
    /**
     * HTTP PATCH.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PATCH,
    /**
     * HTTP POST.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POST,
    /**
     * HTTP PUT.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUT,
}
