package software.amazon.awscdk.services.appconfig;

/**
 * Properties for the Rollout Strategy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application application;
 * HostedConfiguration.Builder.create(this, "MyHostedConfiguration")
 *         .application(application)
 *         .content(ConfigurationContent.fromInlineText("This is my configuration content."))
 *         .deploymentStrategy(DeploymentStrategy.Builder.create(this, "MyDeploymentStrategy")
 *                 .rolloutStrategy(RolloutStrategy.linear(RolloutStrategyProps.builder()
 *                         .growthFactor(15)
 *                         .deploymentDuration(Duration.minutes(30))
 *                         .finalBakeTime(Duration.minutes(15))
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:52.629Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.RolloutStrategyProps")
@software.amazon.jsii.Jsii.Proxy(RolloutStrategyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RolloutStrategyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The deployment duration of the deployment strategy.
     * <p>
     * This defines
     * the total amount of time for a deployment to last.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getDeploymentDuration();

    /**
     * The growth factor of the deployment strategy.
     * <p>
     * This defines
     * the percentage of targets to receive a deployed configuration
     * during each interval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getGrowthFactor();

    /**
     * The final bake time of the deployment strategy.
     * <p>
     * This setting specifies the amount of time AWS AppConfig monitors for Amazon
     * CloudWatch alarms after the configuration has been deployed to
     * 100% of its targets, before considering the deployment to be complete.
     * If an alarm is triggered during this time, AWS AppConfig rolls back
     * the deployment.
     * <p>
     * Default: Duration.minutes(0)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getFinalBakeTime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RolloutStrategyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RolloutStrategyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RolloutStrategyProps> {
        software.amazon.awscdk.Duration deploymentDuration;
        java.lang.Number growthFactor;
        software.amazon.awscdk.Duration finalBakeTime;

        /**
         * Sets the value of {@link RolloutStrategyProps#getDeploymentDuration}
         * @param deploymentDuration The deployment duration of the deployment strategy. This parameter is required.
         *                           This defines
         *                           the total amount of time for a deployment to last.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentDuration(software.amazon.awscdk.Duration deploymentDuration) {
            this.deploymentDuration = deploymentDuration;
            return this;
        }

        /**
         * Sets the value of {@link RolloutStrategyProps#getGrowthFactor}
         * @param growthFactor The growth factor of the deployment strategy. This parameter is required.
         *                     This defines
         *                     the percentage of targets to receive a deployed configuration
         *                     during each interval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder growthFactor(java.lang.Number growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        /**
         * Sets the value of {@link RolloutStrategyProps#getFinalBakeTime}
         * @param finalBakeTime The final bake time of the deployment strategy.
         *                      This setting specifies the amount of time AWS AppConfig monitors for Amazon
         *                      CloudWatch alarms after the configuration has been deployed to
         *                      100% of its targets, before considering the deployment to be complete.
         *                      If an alarm is triggered during this time, AWS AppConfig rolls back
         *                      the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder finalBakeTime(software.amazon.awscdk.Duration finalBakeTime) {
            this.finalBakeTime = finalBakeTime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RolloutStrategyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RolloutStrategyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RolloutStrategyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RolloutStrategyProps {
        private final software.amazon.awscdk.Duration deploymentDuration;
        private final java.lang.Number growthFactor;
        private final software.amazon.awscdk.Duration finalBakeTime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploymentDuration = software.amazon.jsii.Kernel.get(this, "deploymentDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.growthFactor = software.amazon.jsii.Kernel.get(this, "growthFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.finalBakeTime = software.amazon.jsii.Kernel.get(this, "finalBakeTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploymentDuration = java.util.Objects.requireNonNull(builder.deploymentDuration, "deploymentDuration is required");
            this.growthFactor = java.util.Objects.requireNonNull(builder.growthFactor, "growthFactor is required");
            this.finalBakeTime = builder.finalBakeTime;
        }

        @Override
        public final software.amazon.awscdk.Duration getDeploymentDuration() {
            return this.deploymentDuration;
        }

        @Override
        public final java.lang.Number getGrowthFactor() {
            return this.growthFactor;
        }

        @Override
        public final software.amazon.awscdk.Duration getFinalBakeTime() {
            return this.finalBakeTime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deploymentDuration", om.valueToTree(this.getDeploymentDuration()));
            data.set("growthFactor", om.valueToTree(this.getGrowthFactor()));
            if (this.getFinalBakeTime() != null) {
                data.set("finalBakeTime", om.valueToTree(this.getFinalBakeTime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appconfig.RolloutStrategyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RolloutStrategyProps.Jsii$Proxy that = (RolloutStrategyProps.Jsii$Proxy) o;

            if (!deploymentDuration.equals(that.deploymentDuration)) return false;
            if (!growthFactor.equals(that.growthFactor)) return false;
            return this.finalBakeTime != null ? this.finalBakeTime.equals(that.finalBakeTime) : that.finalBakeTime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deploymentDuration.hashCode();
            result = 31 * result + (this.growthFactor.hashCode());
            result = 31 * result + (this.finalBakeTime != null ? this.finalBakeTime.hashCode() : 0);
            return result;
        }
    }
}
