package software.amazon.awscdk.services.appmesh;

/**
 * Configuration for <code>QueryParameterMatch</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * QueryParameterMatchConfig queryParameterMatchConfig = QueryParameterMatchConfig.builder()
 *         .queryParameterMatch(QueryParameterProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .match(HttpQueryParameterMatchProperty.builder()
 *                         .exact("exact")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:53.023Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.QueryParameterMatchConfig")
@software.amazon.jsii.Jsii.Proxy(QueryParameterMatchConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueryParameterMatchConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Route CFN configuration for route query parameter match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnRoute.QueryParameterProperty getQueryParameterMatch();

    /**
     * @return a {@link Builder} of {@link QueryParameterMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueryParameterMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueryParameterMatchConfig> {
        software.amazon.awscdk.services.appmesh.CfnRoute.QueryParameterProperty queryParameterMatch;

        /**
         * Sets the value of {@link QueryParameterMatchConfig#getQueryParameterMatch}
         * @param queryParameterMatch Route CFN configuration for route query parameter match. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryParameterMatch(software.amazon.awscdk.services.appmesh.CfnRoute.QueryParameterProperty queryParameterMatch) {
            this.queryParameterMatch = queryParameterMatch;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueryParameterMatchConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueryParameterMatchConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QueryParameterMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryParameterMatchConfig {
        private final software.amazon.awscdk.services.appmesh.CfnRoute.QueryParameterProperty queryParameterMatch;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.queryParameterMatch = software.amazon.jsii.Kernel.get(this, "queryParameterMatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnRoute.QueryParameterProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.queryParameterMatch = java.util.Objects.requireNonNull(builder.queryParameterMatch, "queryParameterMatch is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnRoute.QueryParameterProperty getQueryParameterMatch() {
            return this.queryParameterMatch;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("queryParameterMatch", om.valueToTree(this.getQueryParameterMatch()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.QueryParameterMatchConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueryParameterMatchConfig.Jsii$Proxy that = (QueryParameterMatchConfig.Jsii$Proxy) o;

            return this.queryParameterMatch.equals(that.queryParameterMatch);
        }

        @Override
        public final int hashCode() {
            int result = this.queryParameterMatch.hashCode();
            return result;
        }
    }
}
