package software.amazon.awscdk.services.appmesh;

/**
 * Used to generate specs with different protocols for a RouteSpec.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-http2-retry", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.http2(HttpRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder().virtualNode(node).build()))
 *                 .retryPolicy(HttpRetryPolicy.builder()
 *                         // Retry if the connection failed
 *                         .tcpRetryEvents(List.of(TcpRetryEvent.CONNECTION_ERROR))
 *                         // Retry if HTTP responds with a gateway error (502, 503, 504)
 *                         .httpRetryEvents(List.of(HttpRetryEvent.GATEWAY_ERROR))
 *                         // Retry five times
 *                         .retryAttempts(5)
 *                         // Use a 1 second timeout per retry
 *                         .retryTimeout(Duration.seconds(1))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:53.025Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.RouteSpec")
public abstract class RouteSpec extends software.amazon.jsii.JsiiObject {

    protected RouteSpec(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RouteSpec(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected RouteSpec() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a GRPC Based RouteSpec.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.RouteSpec grpc(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GrpcRouteSpecOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.RouteSpec.class, "grpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.RouteSpec.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Creates an HTTP Based RouteSpec.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.RouteSpec http(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpRouteSpecOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.RouteSpec.class, "http", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.RouteSpec.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Creates an HTTP2 Based RouteSpec.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.RouteSpec http2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpRouteSpecOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.RouteSpec.class, "http2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.RouteSpec.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Creates a TCP Based RouteSpec.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.RouteSpec tcp(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TcpRouteSpecOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.RouteSpec.class, "tcp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.RouteSpec.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Called when the RouteSpec type is initialized.
     * <p>
     * Can be used to enforce
     * mutual exclusivity with future properties
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.RouteSpecConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.RouteSpec {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the RouteSpec type is initialized.
         * <p>
         * Can be used to enforce
         * mutual exclusivity with future properties
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.RouteSpecConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.RouteSpecConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
