package software.amazon.awscdk.services.appsync;

/**
 * CachingConfig for AppSync resolvers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.appsync.*;
 * CachingConfig cachingConfig = CachingConfig.builder()
 *         .ttl(Duration.minutes(30))
 *         // the properties below are optional
 *         .cachingKeys(List.of("cachingKeys"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:53.149Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CachingConfig")
@software.amazon.jsii.Jsii.Proxy(CachingConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CachingConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The TTL in seconds for a resolver that has caching enabled.
     * <p>
     * Valid values are between 1 and 3600 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getTtl();

    /**
     * The caching keys for a resolver that has caching enabled.
     * <p>
     * Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
     * <p>
     * Default: - No caching keys
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCachingKeys() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CachingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CachingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CachingConfig> {
        software.amazon.awscdk.Duration ttl;
        java.util.List<java.lang.String> cachingKeys;

        /**
         * Sets the value of {@link CachingConfig#getTtl}
         * @param ttl The TTL in seconds for a resolver that has caching enabled. This parameter is required.
         *            Valid values are between 1 and 3600 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(software.amazon.awscdk.Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        /**
         * Sets the value of {@link CachingConfig#getCachingKeys}
         * @param cachingKeys The caching keys for a resolver that has caching enabled.
         *                    Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachingKeys(java.util.List<java.lang.String> cachingKeys) {
            this.cachingKeys = cachingKeys;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CachingConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CachingConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CachingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CachingConfig {
        private final software.amazon.awscdk.Duration ttl;
        private final java.util.List<java.lang.String> cachingKeys;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ttl = software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.cachingKeys = software.amazon.jsii.Kernel.get(this, "cachingKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ttl = java.util.Objects.requireNonNull(builder.ttl, "ttl is required");
            this.cachingKeys = builder.cachingKeys;
        }

        @Override
        public final software.amazon.awscdk.Duration getTtl() {
            return this.ttl;
        }

        @Override
        public final java.util.List<java.lang.String> getCachingKeys() {
            return this.cachingKeys;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ttl", om.valueToTree(this.getTtl()));
            if (this.getCachingKeys() != null) {
                data.set("cachingKeys", om.valueToTree(this.getCachingKeys()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CachingConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CachingConfig.Jsii$Proxy that = (CachingConfig.Jsii$Proxy) o;

            if (!ttl.equals(that.ttl)) return false;
            return this.cachingKeys != null ? this.cachingKeys.equals(that.cachingKeys) : that.cachingKeys == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ttl.hashCode();
            result = 31 * result + (this.cachingKeys != null ? this.cachingKeys.hashCode() : 0);
            return result;
        }
    }
}
