package software.amazon.awscdk.services.athena;

/**
 * Properties for defining a <code>CfnWorkGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.athena.*;
 * CfnWorkGroupProps cfnWorkGroupProps = CfnWorkGroupProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .recursiveDeleteOption(false)
 *         .state("state")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workGroupConfiguration(WorkGroupConfigurationProperty.builder()
 *                 .additionalConfiguration("additionalConfiguration")
 *                 .bytesScannedCutoffPerQuery(123)
 *                 .customerContentEncryptionConfiguration(CustomerContentEncryptionConfigurationProperty.builder()
 *                         .kmsKey("kmsKey")
 *                         .build())
 *                 .enforceWorkGroupConfiguration(false)
 *                 .engineVersion(EngineVersionProperty.builder()
 *                         .effectiveEngineVersion("effectiveEngineVersion")
 *                         .selectedEngineVersion("selectedEngineVersion")
 *                         .build())
 *                 .executionRole("executionRole")
 *                 .publishCloudWatchMetricsEnabled(false)
 *                 .requesterPaysEnabled(false)
 *                 .resultConfiguration(ResultConfigurationProperty.builder()
 *                         .aclConfiguration(AclConfigurationProperty.builder()
 *                                 .s3AclOption("s3AclOption")
 *                                 .build())
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .encryptionOption("encryptionOption")
 *                                 // the properties below are optional
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .expectedBucketOwner("expectedBucketOwner")
 *                         .outputLocation("outputLocation")
 *                         .build())
 *                 .build())
 *         .workGroupConfigurationUpdates(WorkGroupConfigurationUpdatesProperty.builder()
 *                 .additionalConfiguration("additionalConfiguration")
 *                 .bytesScannedCutoffPerQuery(123)
 *                 .customerContentEncryptionConfiguration(CustomerContentEncryptionConfigurationProperty.builder()
 *                         .kmsKey("kmsKey")
 *                         .build())
 *                 .enforceWorkGroupConfiguration(false)
 *                 .engineVersion(EngineVersionProperty.builder()
 *                         .effectiveEngineVersion("effectiveEngineVersion")
 *                         .selectedEngineVersion("selectedEngineVersion")
 *                         .build())
 *                 .executionRole("executionRole")
 *                 .publishCloudWatchMetricsEnabled(false)
 *                 .removeBytesScannedCutoffPerQuery(false)
 *                 .removeCustomerContentEncryptionConfiguration(false)
 *                 .requesterPaysEnabled(false)
 *                 .resultConfigurationUpdates(ResultConfigurationUpdatesProperty.builder()
 *                         .aclConfiguration(AclConfigurationProperty.builder()
 *                                 .s3AclOption("s3AclOption")
 *                                 .build())
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .encryptionOption("encryptionOption")
 *                                 // the properties below are optional
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .expectedBucketOwner("expectedBucketOwner")
 *                         .outputLocation("outputLocation")
 *                         .removeAclConfiguration(false)
 *                         .removeEncryptionConfiguration(false)
 *                         .removeExpectedBucketOwner(false)
 *                         .removeOutputLocation(false)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:53.323Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnWorkGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWorkGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The workgroup name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The workgroup description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
     * <p>
     * The default is false.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRecursiveDeleteOption() {
        return null;
    }

    /**
     * The state of the workgroup: ENABLED or DISABLED.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-state</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * The tags (key-value pairs) to associate with this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWorkGroupConfiguration() {
        return null;
    }

    /**
     * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Object getWorkGroupConfigurationUpdates() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWorkGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWorkGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWorkGroupProps> {
        java.lang.String name;
        java.lang.String description;
        java.lang.Object recursiveDeleteOption;
        java.lang.String state;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object workGroupConfiguration;
        java.lang.Object workGroupConfigurationUpdates;

        /**
         * Sets the value of {@link CfnWorkGroupProps#getName}
         * @param name The workgroup name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkGroupProps#getDescription}
         * @param description The workgroup description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkGroupProps#getRecursiveDeleteOption}
         * @param recursiveDeleteOption The option to delete a workgroup and its contents even if the workgroup contains any named queries.
         *                              The default is false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recursiveDeleteOption(java.lang.Boolean recursiveDeleteOption) {
            this.recursiveDeleteOption = recursiveDeleteOption;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkGroupProps#getRecursiveDeleteOption}
         * @param recursiveDeleteOption The option to delete a workgroup and its contents even if the workgroup contains any named queries.
         *                              The default is false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recursiveDeleteOption(software.amazon.awscdk.IResolvable recursiveDeleteOption) {
            this.recursiveDeleteOption = recursiveDeleteOption;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkGroupProps#getState}
         * @param state The state of the workgroup: ENABLED or DISABLED.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkGroupProps#getTags}
         * @param tags The tags (key-value pairs) to associate with this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkGroupProps#getWorkGroupConfiguration}
         * @param workGroupConfiguration The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
         *                               The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroupConfiguration(software.amazon.awscdk.IResolvable workGroupConfiguration) {
            this.workGroupConfiguration = workGroupConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkGroupProps#getWorkGroupConfiguration}
         * @param workGroupConfiguration The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
         *                               The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroupConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty workGroupConfiguration) {
            this.workGroupConfiguration = workGroupConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkGroupProps#getWorkGroupConfigurationUpdates}
         * @param workGroupConfigurationUpdates The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder workGroupConfigurationUpdates(software.amazon.awscdk.IResolvable workGroupConfigurationUpdates) {
            this.workGroupConfigurationUpdates = workGroupConfigurationUpdates;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkGroupProps#getWorkGroupConfigurationUpdates}
         * @param workGroupConfigurationUpdates The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder workGroupConfigurationUpdates(software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty workGroupConfigurationUpdates) {
            this.workGroupConfigurationUpdates = workGroupConfigurationUpdates;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWorkGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWorkGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWorkGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWorkGroupProps {
        private final java.lang.String name;
        private final java.lang.String description;
        private final java.lang.Object recursiveDeleteOption;
        private final java.lang.String state;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object workGroupConfiguration;
        private final java.lang.Object workGroupConfigurationUpdates;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recursiveDeleteOption = software.amazon.jsii.Kernel.get(this, "recursiveDeleteOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.workGroupConfiguration = software.amazon.jsii.Kernel.get(this, "workGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.workGroupConfigurationUpdates = software.amazon.jsii.Kernel.get(this, "workGroupConfigurationUpdates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.recursiveDeleteOption = builder.recursiveDeleteOption;
            this.state = builder.state;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.workGroupConfiguration = builder.workGroupConfiguration;
            this.workGroupConfigurationUpdates = builder.workGroupConfigurationUpdates;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getRecursiveDeleteOption() {
            return this.recursiveDeleteOption;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getWorkGroupConfiguration() {
            return this.workGroupConfiguration;
        }

        @Override
        public final java.lang.Object getWorkGroupConfigurationUpdates() {
            return this.workGroupConfigurationUpdates;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRecursiveDeleteOption() != null) {
                data.set("recursiveDeleteOption", om.valueToTree(this.getRecursiveDeleteOption()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkGroupConfiguration() != null) {
                data.set("workGroupConfiguration", om.valueToTree(this.getWorkGroupConfiguration()));
            }
            if (this.getWorkGroupConfigurationUpdates() != null) {
                data.set("workGroupConfigurationUpdates", om.valueToTree(this.getWorkGroupConfigurationUpdates()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWorkGroupProps.Jsii$Proxy that = (CfnWorkGroupProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.recursiveDeleteOption != null ? !this.recursiveDeleteOption.equals(that.recursiveDeleteOption) : that.recursiveDeleteOption != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.workGroupConfiguration != null ? !this.workGroupConfiguration.equals(that.workGroupConfiguration) : that.workGroupConfiguration != null) return false;
            return this.workGroupConfigurationUpdates != null ? this.workGroupConfigurationUpdates.equals(that.workGroupConfigurationUpdates) : that.workGroupConfigurationUpdates == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.recursiveDeleteOption != null ? this.recursiveDeleteOption.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workGroupConfiguration != null ? this.workGroupConfiguration.hashCode() : 0);
            result = 31 * result + (this.workGroupConfigurationUpdates != null ? this.workGroupConfigurationUpdates.hashCode() : 0);
            return result;
        }
    }
}
