package software.amazon.awscdk.services.autoscaling;

/**
 * ELB Heath check options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.autoscaling.*;
 * ElbHealthCheckOptions elbHealthCheckOptions = ElbHealthCheckOptions.builder()
 *         .grace(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:53.460Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.ElbHealthCheckOptions")
@software.amazon.jsii.Jsii.Proxy(ElbHealthCheckOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ElbHealthCheckOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specified the time Auto Scaling waits before checking the health status of an EC2 instance that has come into service.
     * <p>
     * This option is required for ELB health checks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getGrace();

    /**
     * @return a {@link Builder} of {@link ElbHealthCheckOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ElbHealthCheckOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ElbHealthCheckOptions> {
        software.amazon.awscdk.Duration grace;

        /**
         * Sets the value of {@link ElbHealthCheckOptions#getGrace}
         * @param grace Specified the time Auto Scaling waits before checking the health status of an EC2 instance that has come into service. This parameter is required.
         *              This option is required for ELB health checks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grace(software.amazon.awscdk.Duration grace) {
            this.grace = grace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ElbHealthCheckOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ElbHealthCheckOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ElbHealthCheckOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElbHealthCheckOptions {
        private final software.amazon.awscdk.Duration grace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.grace = software.amazon.jsii.Kernel.get(this, "grace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.grace = java.util.Objects.requireNonNull(builder.grace, "grace is required");
        }

        @Override
        public final software.amazon.awscdk.Duration getGrace() {
            return this.grace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("grace", om.valueToTree(this.getGrace()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.ElbHealthCheckOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ElbHealthCheckOptions.Jsii$Proxy that = (ElbHealthCheckOptions.Jsii$Proxy) o;

            return this.grace.equals(that.grace);
        }

        @Override
        public final int hashCode() {
            int result = this.grace.hashCode();
            return result;
        }
    }
}
