package software.amazon.awscdk.services.autoscaling;

/**
 * A list of ScalingEvents, you can use one of the predefined lists, such as ScalingEvents.ERRORS or create a custom group by instantiating a <code>NotificationTypes</code> object, e.g: <code>new NotificationTypes(</code>NotificationType.INSTANCE_LAUNCH<code>)</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * ScalingEvents scalingEvents = ScalingEvents.ALL;
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:53.471Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.ScalingEvents")
public class ScalingEvents extends software.amazon.jsii.JsiiObject {

    protected ScalingEvents(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScalingEvents(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscaling.ScalingEvents.class, "ALL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScalingEvents.class));
        ERRORS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscaling.ScalingEvents.class, "ERRORS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScalingEvents.class));
        LAUNCH_EVENTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscaling.ScalingEvents.class, "LAUNCH_EVENTS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScalingEvents.class));
        TERMINATION_EVENTS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscaling.ScalingEvents.class, "TERMINATION_EVENTS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScalingEvents.class));
    }

    /**
     * @param types This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ScalingEvents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.ScalingEvent... types) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.Arrays.<Object>stream(types).toArray(Object[]::new));
    }

    /**
     * All fleet scaling events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.autoscaling.ScalingEvents ALL;

    /**
     * Fleet scaling errors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.autoscaling.ScalingEvents ERRORS;

    /**
     * Fleet scaling launch events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.autoscaling.ScalingEvents LAUNCH_EVENTS;

    /**
     * Fleet termination launch events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.autoscaling.ScalingEvents TERMINATION_EVENTS;
}
