package software.amazon.awscdk.services.backup;

/**
 * Creates a report plan.
 * <p>
 * A report plan is a document that contains information about the contents of the report and where AWS Backup will deliver it.
 * <p>
 * If you call <code>CreateReportPlan</code> with a plan that already exists, you receive an <code>AlreadyExistsException</code> exception.
 * <p>
 * For a sample AWS CloudFormation template, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-cfn">AWS Backup Developer Guide</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * Object reportDeliveryChannel;
 * Object reportSetting;
 * CfnReportPlan cfnReportPlan = CfnReportPlan.Builder.create(this, "MyCfnReportPlan")
 *         .reportDeliveryChannel(reportDeliveryChannel)
 *         .reportSetting(reportSetting)
 *         // the properties below are optional
 *         .reportPlanDescription("reportPlanDescription")
 *         .reportPlanName("reportPlanName")
 *         .reportPlanTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:53.579Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnReportPlan")
public class CfnReportPlan extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnReportPlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReportPlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.backup.CfnReportPlan.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnReportPlan(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.CfnReportPlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of your report plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReportPlanArn() {
        return software.amazon.jsii.Kernel.get(this, "attrReportPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getReportDeliveryChannel() {
        return software.amazon.jsii.Kernel.get(this, "reportDeliveryChannel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReportDeliveryChannel(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "reportDeliveryChannel", java.util.Objects.requireNonNull(value, "reportDeliveryChannel is required"));
    }

    /**
     * Identifies the report template for the report.
     * <p>
     * Reports are built using a report template. The report templates are:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getReportSetting() {
        return software.amazon.jsii.Kernel.get(this, "reportSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Identifies the report template for the report.
     * <p>
     * Reports are built using a report template. The report templates are:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReportSetting(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "reportSetting", java.util.Objects.requireNonNull(value, "reportSetting is required"));
    }

    /**
     * An optional description of the report plan with a maximum 1,024 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReportPlanDescription() {
        return software.amazon.jsii.Kernel.get(this, "reportPlanDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional description of the report plan with a maximum 1,024 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReportPlanDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "reportPlanDescription", value);
    }

    /**
     * The unique name of the report plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReportPlanName() {
        return software.amazon.jsii.Kernel.get(this, "reportPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of the report plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReportPlanName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "reportPlanName", value);
    }

    /**
     * The tags to assign to your report plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getReportPlanTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "reportPlanTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to assign to your report plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReportPlanTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "reportPlanTags", value);
    }
    /**
     * Contains information from your report plan about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * ReportDeliveryChannelProperty reportDeliveryChannelProperty = ReportDeliveryChannelProperty.builder()
     *         .s3BucketName("s3BucketName")
     *         // the properties below are optional
     *         .formats(List.of("formats"))
     *         .s3KeyPrefix("s3KeyPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportdeliverychannel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportdeliverychannel.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnReportPlan.ReportDeliveryChannelProperty")
    @software.amazon.jsii.Jsii.Proxy(ReportDeliveryChannelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReportDeliveryChannelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique name of the S3 bucket that receives your reports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportdeliverychannel.html#cfn-backup-reportplan-reportdeliverychannel-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportdeliverychannel.html#cfn-backup-reportplan-reportdeliverychannel-s3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName();

        /**
         * The format of your reports: <code>CSV</code> , <code>JSON</code> , or both.
         * <p>
         * If not specified, the default format is <code>CSV</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportdeliverychannel.html#cfn-backup-reportplan-reportdeliverychannel-formats">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportdeliverychannel.html#cfn-backup-reportplan-reportdeliverychannel-formats</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFormats() {
            return null;
        }

        /**
         * The prefix for where AWS Backup Audit Manager delivers your reports to Amazon S3.
         * <p>
         * The prefix is this part of the following path: s3://your-bucket-name/ <code>prefix</code> /Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportdeliverychannel.html#cfn-backup-reportplan-reportdeliverychannel-s3keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportdeliverychannel.html#cfn-backup-reportplan-reportdeliverychannel-s3keyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReportDeliveryChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReportDeliveryChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReportDeliveryChannelProperty> {
            java.lang.String s3BucketName;
            java.util.List<java.lang.String> formats;
            java.lang.String s3KeyPrefix;

            /**
             * Sets the value of {@link ReportDeliveryChannelProperty#getS3BucketName}
             * @param s3BucketName The unique name of the S3 bucket that receives your reports. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link ReportDeliveryChannelProperty#getFormats}
             * @param formats The format of your reports: <code>CSV</code> , <code>JSON</code> , or both.
             *                If not specified, the default format is <code>CSV</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formats(java.util.List<java.lang.String> formats) {
                this.formats = formats;
                return this;
            }

            /**
             * Sets the value of {@link ReportDeliveryChannelProperty#getS3KeyPrefix}
             * @param s3KeyPrefix The prefix for where AWS Backup Audit Manager delivers your reports to Amazon S3.
             *                    The prefix is this part of the following path: s3://your-bucket-name/ <code>prefix</code> /Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3KeyPrefix(java.lang.String s3KeyPrefix) {
                this.s3KeyPrefix = s3KeyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReportDeliveryChannelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReportDeliveryChannelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReportDeliveryChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReportDeliveryChannelProperty {
            private final java.lang.String s3BucketName;
            private final java.util.List<java.lang.String> formats;
            private final java.lang.String s3KeyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.formats = software.amazon.jsii.Kernel.get(this, "formats", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.s3KeyPrefix = software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3BucketName = java.util.Objects.requireNonNull(builder.s3BucketName, "s3BucketName is required");
                this.formats = builder.formats;
                this.s3KeyPrefix = builder.s3KeyPrefix;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.util.List<java.lang.String> getFormats() {
                return this.formats;
            }

            @Override
            public final java.lang.String getS3KeyPrefix() {
                return this.s3KeyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                if (this.getFormats() != null) {
                    data.set("formats", om.valueToTree(this.getFormats()));
                }
                if (this.getS3KeyPrefix() != null) {
                    data.set("s3KeyPrefix", om.valueToTree(this.getS3KeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnReportPlan.ReportDeliveryChannelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReportDeliveryChannelProperty.Jsii$Proxy that = (ReportDeliveryChannelProperty.Jsii$Proxy) o;

                if (!s3BucketName.equals(that.s3BucketName)) return false;
                if (this.formats != null ? !this.formats.equals(that.formats) : that.formats != null) return false;
                return this.s3KeyPrefix != null ? this.s3KeyPrefix.equals(that.s3KeyPrefix) : that.s3KeyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3BucketName.hashCode();
                result = 31 * result + (this.formats != null ? this.formats.hashCode() : 0);
                result = 31 * result + (this.s3KeyPrefix != null ? this.s3KeyPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains detailed information about a report setting.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * ReportSettingProperty reportSettingProperty = ReportSettingProperty.builder()
     *         .reportTemplate("reportTemplate")
     *         // the properties below are optional
     *         .accounts(List.of("accounts"))
     *         .frameworkArns(List.of("frameworkArns"))
     *         .organizationUnits(List.of("organizationUnits"))
     *         .regions(List.of("regions"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnReportPlan.ReportSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(ReportSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReportSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Identifies the report template for the report. Reports are built using a report template. The report templates are:.
         * <p>
         * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html#cfn-backup-reportplan-reportsetting-reporttemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html#cfn-backup-reportplan-reportsetting-reporttemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getReportTemplate();

        /**
         * These are the accounts to be included in the report.
         * <p>
         * Use string value of <code>ROOT</code> to include all organizational units.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html#cfn-backup-reportplan-reportsetting-accounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html#cfn-backup-reportplan-reportsetting-accounts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAccounts() {
            return null;
        }

        /**
         * The Amazon Resource Names (ARNs) of the frameworks a report covers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html#cfn-backup-reportplan-reportsetting-frameworkarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html#cfn-backup-reportplan-reportsetting-frameworkarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFrameworkArns() {
            return null;
        }

        /**
         * These are the Organizational Units to be included in the report.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html#cfn-backup-reportplan-reportsetting-organizationunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html#cfn-backup-reportplan-reportsetting-organizationunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrganizationUnits() {
            return null;
        }

        /**
         * These are the Regions to be included in the report.
         * <p>
         * Use the wildcard as the string value to include all Regions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html#cfn-backup-reportplan-reportsetting-regions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-reportplan-reportsetting.html#cfn-backup-reportplan-reportsetting-regions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReportSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReportSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReportSettingProperty> {
            java.lang.String reportTemplate;
            java.util.List<java.lang.String> accounts;
            java.util.List<java.lang.String> frameworkArns;
            java.util.List<java.lang.String> organizationUnits;
            java.util.List<java.lang.String> regions;

            /**
             * Sets the value of {@link ReportSettingProperty#getReportTemplate}
             * @param reportTemplate Identifies the report template for the report. Reports are built using a report template. The report templates are:. This parameter is required.
             *                       <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportTemplate(java.lang.String reportTemplate) {
                this.reportTemplate = reportTemplate;
                return this;
            }

            /**
             * Sets the value of {@link ReportSettingProperty#getAccounts}
             * @param accounts These are the accounts to be included in the report.
             *                 Use string value of <code>ROOT</code> to include all organizational units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accounts(java.util.List<java.lang.String> accounts) {
                this.accounts = accounts;
                return this;
            }

            /**
             * Sets the value of {@link ReportSettingProperty#getFrameworkArns}
             * @param frameworkArns The Amazon Resource Names (ARNs) of the frameworks a report covers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameworkArns(java.util.List<java.lang.String> frameworkArns) {
                this.frameworkArns = frameworkArns;
                return this;
            }

            /**
             * Sets the value of {@link ReportSettingProperty#getOrganizationUnits}
             * @param organizationUnits These are the Organizational Units to be included in the report.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationUnits(java.util.List<java.lang.String> organizationUnits) {
                this.organizationUnits = organizationUnits;
                return this;
            }

            /**
             * Sets the value of {@link ReportSettingProperty#getRegions}
             * @param regions These are the Regions to be included in the report.
             *                Use the wildcard as the string value to include all Regions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regions(java.util.List<java.lang.String> regions) {
                this.regions = regions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReportSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReportSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReportSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReportSettingProperty {
            private final java.lang.String reportTemplate;
            private final java.util.List<java.lang.String> accounts;
            private final java.util.List<java.lang.String> frameworkArns;
            private final java.util.List<java.lang.String> organizationUnits;
            private final java.util.List<java.lang.String> regions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reportTemplate = software.amazon.jsii.Kernel.get(this, "reportTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accounts = software.amazon.jsii.Kernel.get(this, "accounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.frameworkArns = software.amazon.jsii.Kernel.get(this, "frameworkArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.organizationUnits = software.amazon.jsii.Kernel.get(this, "organizationUnits", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reportTemplate = java.util.Objects.requireNonNull(builder.reportTemplate, "reportTemplate is required");
                this.accounts = builder.accounts;
                this.frameworkArns = builder.frameworkArns;
                this.organizationUnits = builder.organizationUnits;
                this.regions = builder.regions;
            }

            @Override
            public final java.lang.String getReportTemplate() {
                return this.reportTemplate;
            }

            @Override
            public final java.util.List<java.lang.String> getAccounts() {
                return this.accounts;
            }

            @Override
            public final java.util.List<java.lang.String> getFrameworkArns() {
                return this.frameworkArns;
            }

            @Override
            public final java.util.List<java.lang.String> getOrganizationUnits() {
                return this.organizationUnits;
            }

            @Override
            public final java.util.List<java.lang.String> getRegions() {
                return this.regions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("reportTemplate", om.valueToTree(this.getReportTemplate()));
                if (this.getAccounts() != null) {
                    data.set("accounts", om.valueToTree(this.getAccounts()));
                }
                if (this.getFrameworkArns() != null) {
                    data.set("frameworkArns", om.valueToTree(this.getFrameworkArns()));
                }
                if (this.getOrganizationUnits() != null) {
                    data.set("organizationUnits", om.valueToTree(this.getOrganizationUnits()));
                }
                if (this.getRegions() != null) {
                    data.set("regions", om.valueToTree(this.getRegions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnReportPlan.ReportSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReportSettingProperty.Jsii$Proxy that = (ReportSettingProperty.Jsii$Proxy) o;

                if (!reportTemplate.equals(that.reportTemplate)) return false;
                if (this.accounts != null ? !this.accounts.equals(that.accounts) : that.accounts != null) return false;
                if (this.frameworkArns != null ? !this.frameworkArns.equals(that.frameworkArns) : that.frameworkArns != null) return false;
                if (this.organizationUnits != null ? !this.organizationUnits.equals(that.organizationUnits) : that.organizationUnits != null) return false;
                return this.regions != null ? this.regions.equals(that.regions) : that.regions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reportTemplate.hashCode();
                result = 31 * result + (this.accounts != null ? this.accounts.hashCode() : 0);
                result = 31 * result + (this.frameworkArns != null ? this.frameworkArns.hashCode() : 0);
                result = 31 * result + (this.organizationUnits != null ? this.organizationUnits.hashCode() : 0);
                result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.CfnReportPlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.CfnReportPlan> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.backup.CfnReportPlanProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.backup.CfnReportPlanProps.Builder();
        }

        /**
         * Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportdeliverychannel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportdeliverychannel</a>
         * @param reportDeliveryChannel Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportDeliveryChannel(final java.lang.Object reportDeliveryChannel) {
            this.props.reportDeliveryChannel(reportDeliveryChannel);
            return this;
        }

        /**
         * Identifies the report template for the report. Reports are built using a report template. The report templates are:.
         * <p>
         * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * <p>
         * If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code> , this API resource also describes the report coverage by AWS Regions and frameworks.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportsetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportsetting</a>
         * @param reportSetting Identifies the report template for the report. Reports are built using a report template. The report templates are:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportSetting(final java.lang.Object reportSetting) {
            this.props.reportSetting(reportSetting);
            return this;
        }

        /**
         * An optional description of the report plan with a maximum 1,024 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplandescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplandescription</a>
         * @param reportPlanDescription An optional description of the report plan with a maximum 1,024 characters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportPlanDescription(final java.lang.String reportPlanDescription) {
            this.props.reportPlanDescription(reportPlanDescription);
            return this;
        }

        /**
         * The unique name of the report plan.
         * <p>
         * This name is between 1 and 256 characters starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplanname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplanname</a>
         * @param reportPlanName The unique name of the report plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportPlanName(final java.lang.String reportPlanName) {
            this.props.reportPlanName(reportPlanName);
            return this;
        }

        /**
         * The tags to assign to your report plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplantags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplantags</a>
         * @param reportPlanTags The tags to assign to your report plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportPlanTags(final java.util.List<? extends software.amazon.awscdk.CfnTag> reportPlanTags) {
            this.props.reportPlanTags(reportPlanTags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.backup.CfnReportPlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.CfnReportPlan build() {
            return new software.amazon.awscdk.services.backup.CfnReportPlan(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
