package software.amazon.awscdk.services.batch;

/**
 * A container that can be run with EKS orchestration on EC2 resources.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:53.742Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.IEksContainerDefinition")
@software.amazon.jsii.Jsii.Proxy(IEksContainerDefinition.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEksContainerDefinition extends software.amazon.jsii.JsiiSerializable, software.constructs.IConstruct {

    /**
     * The image that this container will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage();

    /**
     * The Volumes to mount to this container.
     * <p>
     * Automatically added to the Pod.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/">https://kubernetes.io/docs/concepts/storage/volumes/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.EksVolume> getVolumes();

    /**
     * An array of arguments to the entrypoint.
     * <p>
     * If this isn't specified, the CMD of the container image is used.
     * This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes.
     * Environment variable references are expanded using the container's environment.
     * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
     * For example, if the reference is to "$(NAME1)" and the NAME1 environment variable doesn't exist,
     * the command string will remain "$(NAME1)." $$ is replaced with $, and the resulting string isn't expanded.
     * or example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME environment variable exists.
     * <p>
     * @see <a href="https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
        return null;
    }

    /**
     * The entrypoint for the container.
     * <p>
     * This isn't run within a shell.
     * If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used.
     * Environment variable references are expanded using the container's environment.
     * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
     * For example, if the reference is to <code>"$(NAME1)"</code> and the <code>NAME1</code> environment variable doesn't exist,
     * the command string will remain <code>"$(NAME1)."</code> <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded.
     * For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists.
     * <p>
     * The entrypoint can't be updated.
     * <p>
     * @see <a href="https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * The hard limit of CPUs to present to this container. Must be an even multiple of 0.25.
     * <p>
     * If your container attempts to exceed this limit, it will be terminated.
     * <p>
     * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
     * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
     * <p>
     * Default: - No CPU limit
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpuLimit() {
        return null;
    }

    /**
     * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
     * <p>
     * The container will given at least this many CPUs, but may consume more.
     * <p>
     * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
     * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
     * <p>
     * Default: - No CPUs reserved
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpuReservation() {
        return null;
    }

    /**
     * The environment variables to pass to this container.
     * <p>
     * <em>Note</em>: Environment variables cannot start with "AWS_BATCH".
     * This naming convention is reserved for variables that AWS Batch sets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return null;
    }

    /**
     * The hard limit of GPUs to present to this container.
     * <p>
     * If your container attempts to exceed this limit, it will be terminated.
     * <p>
     * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
     * <p>
     * Default: - No GPU limit
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpuLimit() {
        return null;
    }

    /**
     * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
     * <p>
     * The container will given at least this many CPUs, but may consume more.
     * <p>
     * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
     * <p>
     * Default: - No GPUs reserved
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpuReservation() {
        return null;
    }

    /**
     * The image pull policy for this container.
     * <p>
     * Default: - `ALWAYS` if the `:latest` tag is specified, `IF_NOT_PRESENT` otherwise
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/containers/images/#updating-images">https://kubernetes.io/docs/concepts/containers/images/#updating-images</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ImagePullPolicy getImagePullPolicy() {
        return null;
    }

    /**
     * The amount (in MiB) of memory to present to the container.
     * <p>
     * If your container attempts to exceed the allocated memory, it will be terminated.
     * <p>
     * Must be larger that 4 MiB
     * <p>
     * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required
     * <p>
     * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
     * for the specific instance type that you are using.
     * <p>
     * Default: - No memory limit
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemoryLimit() {
        return null;
    }

    /**
     * The soft limit (in MiB) of memory to reserve for the container.
     * <p>
     * Your container will be given at least this much memory, but may consume more.
     * <p>
     * Must be larger that 4 MiB
     * <p>
     * When system memory is under heavy contention, Docker attempts to keep the
     * container memory to this soft limit. However, your container can consume more
     * memory when it needs to, up to either the hard limit specified with the memory
     * parameter (if applicable), or all of the available memory on the container
     * instance, whichever comes first.
     * <p>
     * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required.
     * If both are specified, then <code>memoryLimit</code> must be equal to <code>memoryReservation</code>
     * <p>
     * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
     * for the specific instance type that you are using.
     * <p>
     * Default: - No memory reserved
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemoryReservation() {
        return null;
    }

    /**
     * The name of this container.
     * <p>
     * Default: : `'Default'`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * If specified, gives this container elevated permissions on the host container instance.
     * <p>
     * The level of permissions are similar to the root user permissions.
     * <p>
     * This parameter maps to <code>privileged</code> policy in the Privileged pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
        return null;
    }

    /**
     * If specified, gives this container readonly access to its root file system.
     * <p>
     * This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the Volumes and file systems pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
        return null;
    }

    /**
     * If specified, the container is run as the specified group ID (<code>gid</code>).
     * <p>
     * If this parameter isn't specified, the default is the group that's specified in the image metadata.
     * This parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     * <p>
     * Default: none
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRunAsGroup() {
        return null;
    }

    /**
     * If specified, the container is run as a user with a <code>uid</code> other than 0.
     * <p>
     * Otherwise, no such rule is enforced.
     * This parameter maps to <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     * <p>
     * Default: - the container is *not* required to run as a non-root user
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRunAsRoot() {
        return null;
    }

    /**
     * If specified, this container is run as the specified user ID (<code>uid</code>).
     * <p>
     * This parameter maps to <code>RunAsUser</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
     * <p>
     * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
     * <p>
     * Default: - the user that is specified in the image metadata.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRunAsUser() {
        return null;
    }

    /**
     * Mount a Volume to this container.
     * <p>
     * Automatically added to the Pod.
     * <p>
     * @param volume This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksVolume volume);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.batch.IEksContainerDefinition.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The image that this container will run.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
        }

        /**
         * The Volumes to mount to this container.
         * <p>
         * Automatically added to the Pod.
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/">https://kubernetes.io/docs/concepts/storage/volumes/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.EksVolume> getVolumes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EksVolume.class))));
        }

        /**
         * An array of arguments to the entrypoint.
         * <p>
         * If this isn't specified, the CMD of the container image is used.
         * This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes.
         * Environment variable references are expanded using the container's environment.
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
         * For example, if the reference is to "$(NAME1)" and the NAME1 environment variable doesn't exist,
         * the command string will remain "$(NAME1)." $$ is replaced with $, and the resulting string isn't expanded.
         * or example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME environment variable exists.
         * <p>
         * @see <a href="https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The entrypoint for the container.
         * <p>
         * This isn't run within a shell.
         * If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used.
         * Environment variable references are expanded using the container's environment.
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
         * For example, if the reference is to <code>"$(NAME1)"</code> and the <code>NAME1</code> environment variable doesn't exist,
         * the command string will remain <code>"$(NAME1)."</code> <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded.
         * For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists.
         * <p>
         * The entrypoint can't be updated.
         * <p>
         * @see <a href="https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The hard limit of CPUs to present to this container. Must be an even multiple of 0.25.
         * <p>
         * If your container attempts to exceed this limit, it will be terminated.
         * <p>
         * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
         * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
         * <p>
         * Default: - No CPU limit
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getCpuLimit() {
            return software.amazon.jsii.Kernel.get(this, "cpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
         * <p>
         * The container will given at least this many CPUs, but may consume more.
         * <p>
         * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
         * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
         * <p>
         * Default: - No CPUs reserved
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getCpuReservation() {
            return software.amazon.jsii.Kernel.get(this, "cpuReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The environment variables to pass to this container.
         * <p>
         * <em>Note</em>: Environment variables cannot start with "AWS_BATCH".
         * This naming convention is reserved for variables that AWS Batch sets.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The hard limit of GPUs to present to this container.
         * <p>
         * If your container attempts to exceed this limit, it will be terminated.
         * <p>
         * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
         * <p>
         * Default: - No GPU limit
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getGpuLimit() {
            return software.amazon.jsii.Kernel.get(this, "gpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
         * <p>
         * The container will given at least this many CPUs, but may consume more.
         * <p>
         * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
         * <p>
         * Default: - No GPUs reserved
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getGpuReservation() {
            return software.amazon.jsii.Kernel.get(this, "gpuReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The image pull policy for this container.
         * <p>
         * Default: - `ALWAYS` if the `:latest` tag is specified, `IF_NOT_PRESENT` otherwise
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/containers/images/#updating-images">https://kubernetes.io/docs/concepts/containers/images/#updating-images</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ImagePullPolicy getImagePullPolicy() {
            return software.amazon.jsii.Kernel.get(this, "imagePullPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ImagePullPolicy.class));
        }

        /**
         * The amount (in MiB) of memory to present to the container.
         * <p>
         * If your container attempts to exceed the allocated memory, it will be terminated.
         * <p>
         * Must be larger that 4 MiB
         * <p>
         * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required
         * <p>
         * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
         * for the specific instance type that you are using.
         * <p>
         * Default: - No memory limit
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemoryLimit() {
            return software.amazon.jsii.Kernel.get(this, "memoryLimit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
        }

        /**
         * The soft limit (in MiB) of memory to reserve for the container.
         * <p>
         * Your container will be given at least this much memory, but may consume more.
         * <p>
         * Must be larger that 4 MiB
         * <p>
         * When system memory is under heavy contention, Docker attempts to keep the
         * container memory to this soft limit. However, your container can consume more
         * memory when it needs to, up to either the hard limit specified with the memory
         * parameter (if applicable), or all of the available memory on the container
         * instance, whichever comes first.
         * <p>
         * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required.
         * If both are specified, then <code>memoryLimit</code> must be equal to <code>memoryReservation</code>
         * <p>
         * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
         * for the specific instance type that you are using.
         * <p>
         * Default: - No memory reserved
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemoryReservation() {
            return software.amazon.jsii.Kernel.get(this, "memoryReservation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
        }

        /**
         * The name of this container.
         * <p>
         * Default: : `'Default'`
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * If specified, gives this container elevated permissions on the host container instance.
         * <p>
         * The level of permissions are similar to the root user permissions.
         * <p>
         * This parameter maps to <code>privileged</code> policy in the Privileged pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: false
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
            return software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * If specified, gives this container readonly access to its root file system.
         * <p>
         * This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the Volumes and file systems pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: false
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
            return software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * If specified, the container is run as the specified group ID (<code>gid</code>).
         * <p>
         * If this parameter isn't specified, the default is the group that's specified in the image metadata.
         * This parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: none
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getRunAsGroup() {
            return software.amazon.jsii.Kernel.get(this, "runAsGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * If specified, the container is run as a user with a <code>uid</code> other than 0.
         * <p>
         * Otherwise, no such rule is enforced.
         * This parameter maps to <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: - the container is *not* required to run as a non-root user
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getRunAsRoot() {
            return software.amazon.jsii.Kernel.get(this, "runAsRoot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * If specified, this container is run as the specified user ID (<code>uid</code>).
         * <p>
         * This parameter maps to <code>RunAsUser</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: - the user that is specified in the image metadata.
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Number getRunAsUser() {
            return software.amazon.jsii.Kernel.get(this, "runAsUser", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Mount a Volume to this container.
         * <p>
         * Automatically added to the Pod.
         * <p>
         * @param volume This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksVolume volume) {
            software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
        }
    }

    /**
     * Internal default implementation for {@link IEksContainerDefinition}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEksContainerDefinition, software.constructs.IConstruct.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The image that this container will run.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
        }

        /**
         * The Volumes to mount to this container.
         * <p>
         * Automatically added to the Pod.
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/">https://kubernetes.io/docs/concepts/storage/volumes/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.EksVolume> getVolumes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EksVolume.class))));
        }

        /**
         * An array of arguments to the entrypoint.
         * <p>
         * If this isn't specified, the CMD of the container image is used.
         * This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes.
         * Environment variable references are expanded using the container's environment.
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
         * For example, if the reference is to "$(NAME1)" and the NAME1 environment variable doesn't exist,
         * the command string will remain "$(NAME1)." $$ is replaced with $, and the resulting string isn't expanded.
         * or example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME environment variable exists.
         * <p>
         * @see <a href="https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The entrypoint for the container.
         * <p>
         * This isn't run within a shell.
         * If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used.
         * Environment variable references are expanded using the container's environment.
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed.
         * For example, if the reference is to <code>"$(NAME1)"</code> and the <code>NAME1</code> environment variable doesn't exist,
         * the command string will remain <code>"$(NAME1)."</code> <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded.
         * For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists.
         * <p>
         * The entrypoint can't be updated.
         * <p>
         * @see <a href="https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The hard limit of CPUs to present to this container. Must be an even multiple of 0.25.
         * <p>
         * If your container attempts to exceed this limit, it will be terminated.
         * <p>
         * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
         * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
         * <p>
         * Default: - No CPU limit
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCpuLimit() {
            return software.amazon.jsii.Kernel.get(this, "cpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
         * <p>
         * The container will given at least this many CPUs, but may consume more.
         * <p>
         * At least one of <code>cpuReservation</code> and <code>cpuLimit</code> is required.
         * If both are specified, then <code>cpuLimit</code> must be at least as large as <code>cpuReservation</code>.
         * <p>
         * Default: - No CPUs reserved
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCpuReservation() {
            return software.amazon.jsii.Kernel.get(this, "cpuReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The environment variables to pass to this container.
         * <p>
         * <em>Note</em>: Environment variables cannot start with "AWS_BATCH".
         * This naming convention is reserved for variables that AWS Batch sets.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnv() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The hard limit of GPUs to present to this container.
         * <p>
         * If your container attempts to exceed this limit, it will be terminated.
         * <p>
         * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
         * <p>
         * Default: - No GPU limit
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGpuLimit() {
            return software.amazon.jsii.Kernel.get(this, "gpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The soft limit of CPUs to reserve for the container Must be an even multiple of 0.25.
         * <p>
         * The container will given at least this many CPUs, but may consume more.
         * <p>
         * If both <code>gpuReservation</code> and <code>gpuLimit</code> are specified, then <code>gpuLimit</code> must be equal to <code>gpuReservation</code>.
         * <p>
         * Default: - No GPUs reserved
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGpuReservation() {
            return software.amazon.jsii.Kernel.get(this, "gpuReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The image pull policy for this container.
         * <p>
         * Default: - `ALWAYS` if the `:latest` tag is specified, `IF_NOT_PRESENT` otherwise
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/containers/images/#updating-images">https://kubernetes.io/docs/concepts/containers/images/#updating-images</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ImagePullPolicy getImagePullPolicy() {
            return software.amazon.jsii.Kernel.get(this, "imagePullPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ImagePullPolicy.class));
        }

        /**
         * The amount (in MiB) of memory to present to the container.
         * <p>
         * If your container attempts to exceed the allocated memory, it will be terminated.
         * <p>
         * Must be larger that 4 MiB
         * <p>
         * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required
         * <p>
         * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
         * for the specific instance type that you are using.
         * <p>
         * Default: - No memory limit
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemoryLimit() {
            return software.amazon.jsii.Kernel.get(this, "memoryLimit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
        }

        /**
         * The soft limit (in MiB) of memory to reserve for the container.
         * <p>
         * Your container will be given at least this much memory, but may consume more.
         * <p>
         * Must be larger that 4 MiB
         * <p>
         * When system memory is under heavy contention, Docker attempts to keep the
         * container memory to this soft limit. However, your container can consume more
         * memory when it needs to, up to either the hard limit specified with the memory
         * parameter (if applicable), or all of the available memory on the container
         * instance, whichever comes first.
         * <p>
         * At least one of <code>memoryLimit</code> and <code>memoryReservation</code> is required.
         * If both are specified, then <code>memoryLimit</code> must be equal to <code>memoryReservation</code>
         * <p>
         * <em>Note</em>: To maximize your resource utilization, provide your jobs with as much memory as possible
         * for the specific instance type that you are using.
         * <p>
         * Default: - No memory reserved
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemoryReservation() {
            return software.amazon.jsii.Kernel.get(this, "memoryReservation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
        }

        /**
         * The name of this container.
         * <p>
         * Default: : `'Default'`
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * If specified, gives this container elevated permissions on the host container instance.
         * <p>
         * The level of permissions are similar to the root user permissions.
         * <p>
         * This parameter maps to <code>privileged</code> policy in the Privileged pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: false
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
            return software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * If specified, gives this container readonly access to its root file system.
         * <p>
         * This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the Volumes and file systems pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: false
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
            return software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * If specified, the container is run as the specified group ID (<code>gid</code>).
         * <p>
         * If this parameter isn't specified, the default is the group that's specified in the image metadata.
         * This parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: none
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRunAsGroup() {
            return software.amazon.jsii.Kernel.get(this, "runAsGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * If specified, the container is run as a user with a <code>uid</code> other than 0.
         * <p>
         * Otherwise, no such rule is enforced.
         * This parameter maps to <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: - the container is *not* required to run as a non-root user
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getRunAsRoot() {
            return software.amazon.jsii.Kernel.get(this, "runAsRoot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * If specified, this container is run as the specified user ID (<code>uid</code>).
         * <p>
         * This parameter maps to <code>RunAsUser</code> and <code>MustRunAs</code> policy in the Users and groups pod security policies in the Kubernetes documentation.
         * <p>
         * <em>Note</em>: this is only compatible with Kubernetes &lt; v1.25
         * <p>
         * Default: - the user that is specified in the image metadata.
         * <p>
         * @see <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRunAsUser() {
            return software.amazon.jsii.Kernel.get(this, "runAsUser", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Mount a Volume to this container.
         * <p>
         * Automatically added to the Pod.
         * <p>
         * @param volume This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksVolume volume) {
            software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
        }
    }
}
