package software.amazon.awscdk.services.batch;

/**
 * Common job exit reasons.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EcsJobDefinition jobDefn = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .build())
 *         .retryAttempts(5)
 *         .retryStrategies(List.of(RetryStrategy.of(Action.EXIT, Reason.CANNOT_PULL_CONTAINER)))
 *         .build();
 * jobDefn.addRetryStrategy(RetryStrategy.of(Action.EXIT, Reason.SPOT_INSTANCE_RECLAIMED));
 * jobDefn.addRetryStrategy(RetryStrategy.of(Action.EXIT, Reason.CANNOT_PULL_CONTAINER));
 * jobDefn.addRetryStrategy(RetryStrategy.of(Action.EXIT, Reason.custom(CustomReason.builder()
 *         .onExitCode("40*")
 *         .onReason("some reason")
 *         .build())));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:53.792Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.Reason")
public class Reason extends software.amazon.jsii.JsiiObject {

    protected Reason(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Reason(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CANNOT_PULL_CONTAINER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.Reason.class, "CANNOT_PULL_CONTAINER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Reason.class));
        NON_ZERO_EXIT_CODE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.Reason.class, "NON_ZERO_EXIT_CODE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Reason.class));
        SPOT_INSTANCE_RECLAIMED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.Reason.class, "SPOT_INSTANCE_RECLAIMED", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Reason.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Reason() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A custom Reason that can match on multiple conditions.
     * <p>
     * Note that all specified conditions must be met for this reason to match.
     * <p>
     * @param customReasonProps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Reason custom(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.CustomReason customReasonProps) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.Reason.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Reason.class), new Object[] { java.util.Objects.requireNonNull(customReasonProps, "customReasonProps is required") });
    }

    /**
     * Will only match if the Docker container could not be pulled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.batch.Reason CANNOT_PULL_CONTAINER;

    /**
     * Will match any non-zero exit code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.batch.Reason NON_ZERO_EXIT_CODE;

    /**
     * Will only match if the Spot instance executing the job was reclaimed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.batch.Reason SPOT_INSTANCE_RECLAIMED;
}
