package software.amazon.awscdk.services.cloudformation;

/**
 * Properties for defining a <code>CfnStackSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudformation.*;
 * Object managedExecution;
 * CfnStackSetProps cfnStackSetProps = CfnStackSetProps.builder()
 *         .permissionModel("permissionModel")
 *         .stackSetName("stackSetName")
 *         // the properties below are optional
 *         .administrationRoleArn("administrationRoleArn")
 *         .autoDeployment(AutoDeploymentProperty.builder()
 *                 .enabled(false)
 *                 .retainStacksOnAccountRemoval(false)
 *                 .build())
 *         .callAs("callAs")
 *         .capabilities(List.of("capabilities"))
 *         .description("description")
 *         .executionRoleName("executionRoleName")
 *         .managedExecution(managedExecution)
 *         .operationPreferences(OperationPreferencesProperty.builder()
 *                 .concurrencyMode("concurrencyMode")
 *                 .failureToleranceCount(123)
 *                 .failureTolerancePercentage(123)
 *                 .maxConcurrentCount(123)
 *                 .maxConcurrentPercentage(123)
 *                 .regionConcurrencyType("regionConcurrencyType")
 *                 .regionOrder(List.of("regionOrder"))
 *                 .build())
 *         .parameters(List.of(ParameterProperty.builder()
 *                 .parameterKey("parameterKey")
 *                 .parameterValue("parameterValue")
 *                 .build()))
 *         .stackInstancesGroup(List.of(StackInstancesProperty.builder()
 *                 .deploymentTargets(DeploymentTargetsProperty.builder()
 *                         .accountFilterType("accountFilterType")
 *                         .accounts(List.of("accounts"))
 *                         .accountsUrl("accountsUrl")
 *                         .organizationalUnitIds(List.of("organizationalUnitIds"))
 *                         .build())
 *                 .regions(List.of("regions"))
 *                 // the properties below are optional
 *                 .parameterOverrides(List.of(ParameterProperty.builder()
 *                         .parameterKey("parameterKey")
 *                         .parameterValue("parameterValue")
 *                         .build()))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .templateBody("templateBody")
 *         .templateUrl("templateUrl")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:54.160Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudformation.CfnStackSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnStackSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStackSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Describes how the IAM roles required for stack set operations are created.
     * <p>
     * <ul>
     * <li>With <code>SELF_MANAGED</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a> .</li>
     * <li>With <code>SERVICE_MANAGED</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by AWS Organizations .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-permissionmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-permissionmodel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPermissionModel();

    /**
     * The name to associate with the stack set.
     * <p>
     * The name must be unique in the Region where you create your stack set.
     * <p>
     * <blockquote>
     * <p>
     * The <code>StackSetName</code> property is required.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-stacksetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-stacksetname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackSetName();

    /**
     * The Amazon Resource Number (ARN) of the IAM role to use to create this stack set.
     * <p>
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account.
     * <p>
     * Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <em>Minimum</em> : <code>20</code>
     * <p>
     * <em>Maximum</em> : <code>2048</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-administrationrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-administrationrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdministrationRoleArn() {
        return null;
    }

    /**
     * [ <code>Service-managed</code> permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-autodeployment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-autodeployment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoDeployment() {
        return null;
    }

    /**
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * <p>
     * <ul>
     * <li>To create a stack set with service-managed permissions while signed in to the management account, specify <code>SELF</code> .</li>
     * <li>To create a stack set with service-managed permissions while signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code> .</li>
     * </ul>
     * <p>
     * Your AWS account must be registered as a delegated admin in the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * Stack sets with service-managed permissions are created in the management account, including stack sets that are created by delegated administrators.
     * <p>
     * <em>Valid Values</em> : <code>SELF</code> | <code>DELEGATED_ADMIN</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-callas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-callas</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCallAs() {
        return null;
    }

    /**
     * The capabilities that are allowed in the stack set.
     * <p>
     * Some stack set templates might include resources that can affect permissions in your AWS account —for example, by creating new AWS Identity and Access Management ( IAM ) users. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-capabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-capabilities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCapabilities() {
        return null;
    }

    /**
     * A description of the stack set.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>1024</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the IAM execution role to use to create the stack set.
     * <p>
     * If you don't specify an execution role, AWS CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>64</code>
     * <p>
     * <em>Pattern</em> : <code>[a-zA-Z_0-9+=,.&#64;-]+</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-executionrolename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-executionrolename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleName() {
        return null;
    }

    /**
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     * <p>
     * When active, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.
     * <p>
     * <blockquote>
     * <p>
     * If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
     * <p>
     * You can't modify your stack set's execution configuration while there are running or queued operations for that stack set.
     * <p>
     * </blockquote>
     * <p>
     * When inactive (default), StackSets performs one operation at a time in request order.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-managedexecution">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-managedexecution</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManagedExecution() {
        return null;
    }

    /**
     * The user-specified preferences for how AWS CloudFormation performs a stack set operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-operationpreferences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-operationpreferences</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOperationPreferences() {
        return null;
    }

    /**
     * The input parameters for the stack set template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * A group of stack instances with parameters in some specific accounts and Regions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-stackinstancesgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-stackinstancesgroup</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStackInstancesGroup() {
        return null;
    }

    /**
     * Key-value pairs to associate with this stack.
     * <p>
     * CloudFormation also propagates these tags to supported resources in the stack. You can specify a maximum number of 50 tags.
     * <p>
     * If you don't specify this parameter, CloudFormation doesn't modify the stack's tags. If you specify an empty value, CloudFormation removes all associated tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes.
     * <p>
     * You must include either <code>TemplateURL</code> or <code>TemplateBody</code> in a StackSet, but you can't use both. Dynamic references in the <code>TemplateBody</code> may not work correctly in all cases. It's recommended to pass templates containing dynamic references through <code>TemplateUrl</code> instead.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-templatebody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-templatebody</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateBody() {
        return null;
    }

    /**
     * Location of file containing the template body.
     * <p>
     * The URL must point to a template that's located in an Amazon S3 bucket or a Systems Manager document. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> , <code>TemplateURL</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-templateurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stackset.html#cfn-cloudformation-stackset-templateurl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateUrl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStackSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStackSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStackSetProps> {
        java.lang.String permissionModel;
        java.lang.String stackSetName;
        java.lang.String administrationRoleArn;
        java.lang.Object autoDeployment;
        java.lang.String callAs;
        java.util.List<java.lang.String> capabilities;
        java.lang.String description;
        java.lang.String executionRoleName;
        java.lang.Object managedExecution;
        java.lang.Object operationPreferences;
        java.lang.Object parameters;
        java.lang.Object stackInstancesGroup;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String templateBody;
        java.lang.String templateUrl;

        /**
         * Sets the value of {@link CfnStackSetProps#getPermissionModel}
         * @param permissionModel Describes how the IAM roles required for stack set operations are created. This parameter is required.
         *                        <ul>
         *                        <li>With <code>SELF_MANAGED</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a> .</li>
         *                        <li>With <code>SERVICE_MANAGED</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by AWS Organizations .</li>
         *                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionModel(java.lang.String permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getStackSetName}
         * @param stackSetName The name to associate with the stack set. This parameter is required.
         *                     The name must be unique in the Region where you create your stack set.
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     The <code>StackSetName</code> property is required.
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetName(java.lang.String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getAdministrationRoleArn}
         * @param administrationRoleArn The Amazon Resource Number (ARN) of the IAM role to use to create this stack set.
         *                              Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account.
         *                              <p>
         *                              Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <em>AWS CloudFormation User Guide</em> .
         *                              <p>
         *                              <em>Minimum</em> : <code>20</code>
         *                              <p>
         *                              <em>Maximum</em> : <code>2048</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder administrationRoleArn(java.lang.String administrationRoleArn) {
            this.administrationRoleArn = administrationRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getAutoDeployment}
         * @param autoDeployment [ <code>Service-managed</code> permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeployment(software.amazon.awscdk.IResolvable autoDeployment) {
            this.autoDeployment = autoDeployment;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getAutoDeployment}
         * @param autoDeployment [ <code>Service-managed</code> permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeployment(software.amazon.awscdk.services.cloudformation.CfnStackSet.AutoDeploymentProperty autoDeployment) {
            this.autoDeployment = autoDeployment;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getCallAs}
         * @param callAs [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
         *               By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
         *               <p>
         *               <ul>
         *               <li>To create a stack set with service-managed permissions while signed in to the management account, specify <code>SELF</code> .</li>
         *               <li>To create a stack set with service-managed permissions while signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code> .</li>
         *               </ul>
         *               <p>
         *               Your AWS account must be registered as a delegated admin in the management account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">Register a delegated administrator</a> in the <em>AWS CloudFormation User Guide</em> .
         *               <p>
         *               Stack sets with service-managed permissions are created in the management account, including stack sets that are created by delegated administrators.
         *               <p>
         *               <em>Valid Values</em> : <code>SELF</code> | <code>DELEGATED_ADMIN</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder callAs(java.lang.String callAs) {
            this.callAs = callAs;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getCapabilities}
         * @param capabilities The capabilities that are allowed in the stack set.
         *                     Some stack set templates might include resources that can affect permissions in your AWS account —for example, by creating new AWS Identity and Access Management ( IAM ) users. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capabilities(java.util.List<java.lang.String> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getDescription}
         * @param description A description of the stack set.
         *                    <em>Minimum</em> : <code>1</code>
         *                    <p>
         *                    <em>Maximum</em> : <code>1024</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getExecutionRoleName}
         * @param executionRoleName The name of the IAM execution role to use to create the stack set.
         *                          If you don't specify an execution role, AWS CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
         *                          <p>
         *                          <em>Minimum</em> : <code>1</code>
         *                          <p>
         *                          <em>Maximum</em> : <code>64</code>
         *                          <p>
         *                          <em>Pattern</em> : <code>[a-zA-Z_0-9+=,.&#64;-]+</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleName(java.lang.String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getManagedExecution}
         * @param managedExecution Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
         *                         When active, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
         *                         <p>
         *                         You can't modify your stack set's execution configuration while there are running or queued operations for that stack set.
         *                         <p>
         *                         </blockquote>
         *                         <p>
         *                         When inactive (default), StackSets performs one operation at a time in request order.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedExecution(java.lang.Object managedExecution) {
            this.managedExecution = managedExecution;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getOperationPreferences}
         * @param operationPreferences The user-specified preferences for how AWS CloudFormation performs a stack set operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationPreferences(software.amazon.awscdk.IResolvable operationPreferences) {
            this.operationPreferences = operationPreferences;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getOperationPreferences}
         * @param operationPreferences The user-specified preferences for how AWS CloudFormation performs a stack set operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationPreferences(software.amazon.awscdk.services.cloudformation.CfnStackSet.OperationPreferencesProperty operationPreferences) {
            this.operationPreferences = operationPreferences;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getParameters}
         * @param parameters The input parameters for the stack set template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getParameters}
         * @param parameters The input parameters for the stack set template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.List<? extends java.lang.Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getStackInstancesGroup}
         * @param stackInstancesGroup A group of stack instances with parameters in some specific accounts and Regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackInstancesGroup(software.amazon.awscdk.IResolvable stackInstancesGroup) {
            this.stackInstancesGroup = stackInstancesGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getStackInstancesGroup}
         * @param stackInstancesGroup A group of stack instances with parameters in some specific accounts and Regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackInstancesGroup(java.util.List<? extends java.lang.Object> stackInstancesGroup) {
            this.stackInstancesGroup = stackInstancesGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getTags}
         * @param tags Key-value pairs to associate with this stack.
         *             CloudFormation also propagates these tags to supported resources in the stack. You can specify a maximum number of 50 tags.
         *             <p>
         *             If you don't specify this parameter, CloudFormation doesn't modify the stack's tags. If you specify an empty value, CloudFormation removes all associated tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getTemplateBody}
         * @param templateBody The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         *                     You must include either <code>TemplateURL</code> or <code>TemplateBody</code> in a StackSet, but you can't use both. Dynamic references in the <code>TemplateBody</code> may not work correctly in all cases. It's recommended to pass templates containing dynamic references through <code>TemplateUrl</code> instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateBody(java.lang.String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackSetProps#getTemplateUrl}
         * @param templateUrl Location of file containing the template body.
         *                    The URL must point to a template that's located in an Amazon S3 bucket or a Systems Manager document. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.
         *                    <p>
         *                    Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> , <code>TemplateURL</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateUrl(java.lang.String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStackSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStackSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStackSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStackSetProps {
        private final java.lang.String permissionModel;
        private final java.lang.String stackSetName;
        private final java.lang.String administrationRoleArn;
        private final java.lang.Object autoDeployment;
        private final java.lang.String callAs;
        private final java.util.List<java.lang.String> capabilities;
        private final java.lang.String description;
        private final java.lang.String executionRoleName;
        private final java.lang.Object managedExecution;
        private final java.lang.Object operationPreferences;
        private final java.lang.Object parameters;
        private final java.lang.Object stackInstancesGroup;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String templateBody;
        private final java.lang.String templateUrl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.permissionModel = software.amazon.jsii.Kernel.get(this, "permissionModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackSetName = software.amazon.jsii.Kernel.get(this, "stackSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.administrationRoleArn = software.amazon.jsii.Kernel.get(this, "administrationRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoDeployment = software.amazon.jsii.Kernel.get(this, "autoDeployment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.callAs = software.amazon.jsii.Kernel.get(this, "callAs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.capabilities = software.amazon.jsii.Kernel.get(this, "capabilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRoleName = software.amazon.jsii.Kernel.get(this, "executionRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.managedExecution = software.amazon.jsii.Kernel.get(this, "managedExecution", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.operationPreferences = software.amazon.jsii.Kernel.get(this, "operationPreferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stackInstancesGroup = software.amazon.jsii.Kernel.get(this, "stackInstancesGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.templateBody = software.amazon.jsii.Kernel.get(this, "templateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateUrl = software.amazon.jsii.Kernel.get(this, "templateUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.permissionModel = java.util.Objects.requireNonNull(builder.permissionModel, "permissionModel is required");
            this.stackSetName = java.util.Objects.requireNonNull(builder.stackSetName, "stackSetName is required");
            this.administrationRoleArn = builder.administrationRoleArn;
            this.autoDeployment = builder.autoDeployment;
            this.callAs = builder.callAs;
            this.capabilities = builder.capabilities;
            this.description = builder.description;
            this.executionRoleName = builder.executionRoleName;
            this.managedExecution = builder.managedExecution;
            this.operationPreferences = builder.operationPreferences;
            this.parameters = builder.parameters;
            this.stackInstancesGroup = builder.stackInstancesGroup;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.templateBody = builder.templateBody;
            this.templateUrl = builder.templateUrl;
        }

        @Override
        public final java.lang.String getPermissionModel() {
            return this.permissionModel;
        }

        @Override
        public final java.lang.String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final java.lang.String getAdministrationRoleArn() {
            return this.administrationRoleArn;
        }

        @Override
        public final java.lang.Object getAutoDeployment() {
            return this.autoDeployment;
        }

        @Override
        public final java.lang.String getCallAs() {
            return this.callAs;
        }

        @Override
        public final java.util.List<java.lang.String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExecutionRoleName() {
            return this.executionRoleName;
        }

        @Override
        public final java.lang.Object getManagedExecution() {
            return this.managedExecution;
        }

        @Override
        public final java.lang.Object getOperationPreferences() {
            return this.operationPreferences;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Object getStackInstancesGroup() {
            return this.stackInstancesGroup;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final java.lang.String getTemplateUrl() {
            return this.templateUrl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("permissionModel", om.valueToTree(this.getPermissionModel()));
            data.set("stackSetName", om.valueToTree(this.getStackSetName()));
            if (this.getAdministrationRoleArn() != null) {
                data.set("administrationRoleArn", om.valueToTree(this.getAdministrationRoleArn()));
            }
            if (this.getAutoDeployment() != null) {
                data.set("autoDeployment", om.valueToTree(this.getAutoDeployment()));
            }
            if (this.getCallAs() != null) {
                data.set("callAs", om.valueToTree(this.getCallAs()));
            }
            if (this.getCapabilities() != null) {
                data.set("capabilities", om.valueToTree(this.getCapabilities()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExecutionRoleName() != null) {
                data.set("executionRoleName", om.valueToTree(this.getExecutionRoleName()));
            }
            if (this.getManagedExecution() != null) {
                data.set("managedExecution", om.valueToTree(this.getManagedExecution()));
            }
            if (this.getOperationPreferences() != null) {
                data.set("operationPreferences", om.valueToTree(this.getOperationPreferences()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getStackInstancesGroup() != null) {
                data.set("stackInstancesGroup", om.valueToTree(this.getStackInstancesGroup()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTemplateBody() != null) {
                data.set("templateBody", om.valueToTree(this.getTemplateBody()));
            }
            if (this.getTemplateUrl() != null) {
                data.set("templateUrl", om.valueToTree(this.getTemplateUrl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudformation.CfnStackSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStackSetProps.Jsii$Proxy that = (CfnStackSetProps.Jsii$Proxy) o;

            if (!permissionModel.equals(that.permissionModel)) return false;
            if (!stackSetName.equals(that.stackSetName)) return false;
            if (this.administrationRoleArn != null ? !this.administrationRoleArn.equals(that.administrationRoleArn) : that.administrationRoleArn != null) return false;
            if (this.autoDeployment != null ? !this.autoDeployment.equals(that.autoDeployment) : that.autoDeployment != null) return false;
            if (this.callAs != null ? !this.callAs.equals(that.callAs) : that.callAs != null) return false;
            if (this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.executionRoleName != null ? !this.executionRoleName.equals(that.executionRoleName) : that.executionRoleName != null) return false;
            if (this.managedExecution != null ? !this.managedExecution.equals(that.managedExecution) : that.managedExecution != null) return false;
            if (this.operationPreferences != null ? !this.operationPreferences.equals(that.operationPreferences) : that.operationPreferences != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.stackInstancesGroup != null ? !this.stackInstancesGroup.equals(that.stackInstancesGroup) : that.stackInstancesGroup != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.templateBody != null ? !this.templateBody.equals(that.templateBody) : that.templateBody != null) return false;
            return this.templateUrl != null ? this.templateUrl.equals(that.templateUrl) : that.templateUrl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.permissionModel.hashCode();
            result = 31 * result + (this.stackSetName.hashCode());
            result = 31 * result + (this.administrationRoleArn != null ? this.administrationRoleArn.hashCode() : 0);
            result = 31 * result + (this.autoDeployment != null ? this.autoDeployment.hashCode() : 0);
            result = 31 * result + (this.callAs != null ? this.callAs.hashCode() : 0);
            result = 31 * result + (this.capabilities != null ? this.capabilities.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.executionRoleName != null ? this.executionRoleName.hashCode() : 0);
            result = 31 * result + (this.managedExecution != null ? this.managedExecution.hashCode() : 0);
            result = 31 * result + (this.operationPreferences != null ? this.operationPreferences.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.stackInstancesGroup != null ? this.stackInstancesGroup.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.templateBody != null ? this.templateBody.hashCode() : 0);
            result = 31 * result + (this.templateUrl != null ? this.templateUrl.hashCode() : 0);
            return result;
        }
    }
}
