package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnMonitoringSubscription</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnMonitoringSubscriptionProps cfnMonitoringSubscriptionProps = CfnMonitoringSubscriptionProps.builder()
 *         .distributionId("distributionId")
 *         .monitoringSubscription(MonitoringSubscriptionProperty.builder()
 *                 .realtimeMetricsSubscriptionConfig(RealtimeMetricsSubscriptionConfigProperty.builder()
 *                         .realtimeMetricsSubscriptionStatus("realtimeMetricsSubscriptionStatus")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:54.266Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnMonitoringSubscriptionProps")
@software.amazon.jsii.Jsii.Proxy(CfnMonitoringSubscriptionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMonitoringSubscriptionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the distribution that you are enabling metrics for.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-distributionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-distributionid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDistributionId();

    /**
     * A subscription configuration for additional CloudWatch metrics.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-monitoringsubscription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-monitoringsubscription.html#cfn-cloudfront-monitoringsubscription-monitoringsubscription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringSubscription();

    /**
     * @return a {@link Builder} of {@link CfnMonitoringSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMonitoringSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMonitoringSubscriptionProps> {
        java.lang.String distributionId;
        java.lang.Object monitoringSubscription;

        /**
         * Sets the value of {@link CfnMonitoringSubscriptionProps#getDistributionId}
         * @param distributionId The ID of the distribution that you are enabling metrics for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionId(java.lang.String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitoringSubscriptionProps#getMonitoringSubscription}
         * @param monitoringSubscription A subscription configuration for additional CloudWatch metrics. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringSubscription(software.amazon.awscdk.IResolvable monitoringSubscription) {
            this.monitoringSubscription = monitoringSubscription;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitoringSubscriptionProps#getMonitoringSubscription}
         * @param monitoringSubscription A subscription configuration for additional CloudWatch metrics. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringSubscription(software.amazon.awscdk.services.cloudfront.CfnMonitoringSubscription.MonitoringSubscriptionProperty monitoringSubscription) {
            this.monitoringSubscription = monitoringSubscription;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMonitoringSubscriptionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMonitoringSubscriptionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMonitoringSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMonitoringSubscriptionProps {
        private final java.lang.String distributionId;
        private final java.lang.Object monitoringSubscription;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.distributionId = software.amazon.jsii.Kernel.get(this, "distributionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.monitoringSubscription = software.amazon.jsii.Kernel.get(this, "monitoringSubscription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.distributionId = java.util.Objects.requireNonNull(builder.distributionId, "distributionId is required");
            this.monitoringSubscription = java.util.Objects.requireNonNull(builder.monitoringSubscription, "monitoringSubscription is required");
        }

        @Override
        public final java.lang.String getDistributionId() {
            return this.distributionId;
        }

        @Override
        public final java.lang.Object getMonitoringSubscription() {
            return this.monitoringSubscription;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("distributionId", om.valueToTree(this.getDistributionId()));
            data.set("monitoringSubscription", om.valueToTree(this.getMonitoringSubscription()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnMonitoringSubscriptionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMonitoringSubscriptionProps.Jsii$Proxy that = (CfnMonitoringSubscriptionProps.Jsii$Proxy) o;

            if (!distributionId.equals(that.distributionId)) return false;
            return this.monitoringSubscription.equals(that.monitoringSubscription);
        }

        @Override
        public final int hashCode() {
            int result = this.distributionId.hashCode();
            result = 31 * result + (this.monitoringSubscription.hashCode());
            return result;
        }
    }
}
