package software.amazon.awscdk.services.cloudfront;

/**
 * Represents the endpoints available for targetting within a realtime log config resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Adding realtime logs config to a Cloudfront Distribution on default behavior.
 * import software.amazon.awscdk.services.kinesis.*;
 * Stream stream;
 * RealtimeLogConfig realTimeConfig = RealtimeLogConfig.Builder.create(this, "realtimeLog")
 *         .endPoints(List.of(Endpoint.fromKinesisStream(stream)))
 *         .fields(List.of("timestamp", "c-ip", "time-to-first-byte", "sc-status"))
 *         .realtimeLogConfigName("my-delivery-stream")
 *         .samplingRate(100)
 *         .build();
 * Distribution.Builder.create(this, "myCdn")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new HttpOrigin("www.example.com"))
 *                 .realtimeLogConfig(realTimeConfig)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:54.307Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.Endpoint")
public abstract class Endpoint extends software.amazon.jsii.JsiiObject {

    protected Endpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Endpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Configure a Kinesis Stream Endpoint for Realtime Log Config.
     * <p>
     * Default: - a role will be created and used across your endpoints
     * <p>
     * @param stream This parameter is required.
     * @param role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.Endpoint fromKinesisStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream stream, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole role) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.Endpoint.class, "fromKinesisStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.Endpoint.class), new Object[] { java.util.Objects.requireNonNull(stream, "stream is required"), role });
    }

    /**
     * Configure a Kinesis Stream Endpoint for Realtime Log Config.
     * <p>
     * Default: - a role will be created and used across your endpoints
     * <p>
     * @param stream This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.Endpoint fromKinesisStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream stream) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.Endpoint.class, "fromKinesisStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.Endpoint.class), new Object[] { java.util.Objects.requireNonNull(stream, "stream is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.cloudfront.Endpoint {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
