package software.amazon.awscdk.services.cloudfront;

/**
 * A Public Key Configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Validating signed URLs or signed cookies with Trusted Key Groups
 * // public key in PEM format
 * String publicKey;
 * PublicKey pubKey = PublicKey.Builder.create(this, "MyPubKey")
 *         .encodedKey(publicKey)
 *         .build();
 * KeyGroup keyGroup = KeyGroup.Builder.create(this, "MyKeyGroup")
 *         .items(List.of(pubKey))
 *         .build();
 * Distribution.Builder.create(this, "Dist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new HttpOrigin("www.example.com"))
 *                 .trustedKeyGroups(List.of(keyGroup))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:54.339Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.PublicKey")
public class PublicKey extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IPublicKey {

    protected PublicKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PublicKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PublicKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.PublicKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a Public Key from its id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param publicKeyId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IPublicKey fromPublicKeyId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String publicKeyId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.PublicKey.class, "fromPublicKeyId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IPublicKey.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(publicKeyId, "publicKeyId is required") });
    }

    /**
     * The ID of the key group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPublicKeyId() {
        return software.amazon.jsii.Kernel.get(this, "publicKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.PublicKey}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.PublicKey> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.PublicKeyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.PublicKeyProps.Builder();
        }

        /**
         * The public key that you can use with signed URLs and signed cookies, or with field-level encryption.
         * <p>
         * The <code>encodedKey</code> parameter must include <code>-----BEGIN PUBLIC KEY-----</code> and <code>-----END PUBLIC KEY-----</code> lines.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html</a>
         * @param encodedKey The public key that you can use with signed URLs and signed cookies, or with field-level encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encodedKey(final java.lang.String encodedKey) {
            this.props.encodedKey(encodedKey);
            return this;
        }

        /**
         * A comment to describe the public key.
         * <p>
         * Default: - no comment
         * <p>
         * @return {@code this}
         * @param comment A comment to describe the public key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * A name to identify the public key.
         * <p>
         * Default: - generated from the `id`
         * <p>
         * @return {@code this}
         * @param publicKeyName A name to identify the public key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicKeyName(final java.lang.String publicKeyName) {
            this.props.publicKeyName(publicKeyName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.PublicKey}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.PublicKey build() {
            return new software.amazon.awscdk.services.cloudfront.PublicKey(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
