package software.amazon.awscdk.services.cloudwatch;

/**
 * A Composite Alarm based on Alarm Rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Alarm alarm1;
 * Alarm alarm2;
 * Alarm alarm3;
 * Alarm alarm4;
 * IAlarmRule alarmRule = AlarmRule.anyOf(AlarmRule.allOf(AlarmRule.anyOf(alarm1, AlarmRule.fromAlarm(alarm2, AlarmState.OK), alarm3), AlarmRule.not(AlarmRule.fromAlarm(alarm4, AlarmState.INSUFFICIENT_DATA))), AlarmRule.fromBoolean(false));
 * CompositeAlarm.Builder.create(this, "MyAwesomeCompositeAlarm")
 *         .alarmRule(alarmRule)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:54.505Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CompositeAlarm")
public class CompositeAlarm extends software.amazon.awscdk.services.cloudwatch.AlarmBase {

    protected CompositeAlarm(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CompositeAlarm(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CompositeAlarm(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.CompositeAlarmProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing CloudWatch composite alarm provided an ARN.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param compositeAlarmArn Composite Alarm ARN (i.e. arn:aws:cloudwatch:<region>:<account-id>:alarm:CompositeAlarmName). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm fromCompositeAlarmArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String compositeAlarmArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.CompositeAlarm.class, "fromCompositeAlarmArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IAlarm.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(compositeAlarmArn, "compositeAlarmArn is required") });
    }

    /**
     * Import an existing CloudWatch composite alarm provided an Name.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param compositeAlarmName Composite Alarm Name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm fromCompositeAlarmName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String compositeAlarmName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.CompositeAlarm.class, "fromCompositeAlarmName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IAlarm.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(compositeAlarmName, "compositeAlarmName is required") });
    }

    /**
     * ARN of this alarm.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAlarmArn() {
        return software.amazon.jsii.Kernel.get(this, "alarmArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of this alarm.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAlarmName() {
        return software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.CompositeAlarm}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.CompositeAlarm> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudwatch.CompositeAlarmProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudwatch.CompositeAlarmProps.Builder();
        }

        /**
         * Expression that specifies which other alarms are to be evaluated to determine this composite alarm's state.
         * <p>
         * @return {@code this}
         * @param alarmRule Expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmRule(final software.amazon.awscdk.services.cloudwatch.IAlarmRule alarmRule) {
            this.props.alarmRule(alarmRule);
            return this;
        }

        /**
         * Whether the actions for this alarm are enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param actionsEnabled Whether the actions for this alarm are enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(final java.lang.Boolean actionsEnabled) {
            this.props.actionsEnabled(actionsEnabled);
            return this;
        }

        /**
         * Actions will be suppressed if the suppressor alarm is in the ALARM state.
         * <p>
         * Default: - alarm will not be suppressed.
         * <p>
         * @return {@code this}
         * @param actionsSuppressor Actions will be suppressed if the suppressor alarm is in the ALARM state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressor(final software.amazon.awscdk.services.cloudwatch.IAlarm actionsSuppressor) {
            this.props.actionsSuppressor(actionsSuppressor);
            return this;
        }

        /**
         * The maximum duration that the composite alarm waits after suppressor alarm goes out of the ALARM state.
         * <p>
         * After this time, the composite alarm performs its actions.
         * <p>
         * Default: - 1 minute extension period will be set.
         * <p>
         * @return {@code this}
         * @param actionsSuppressorExtensionPeriod The maximum duration that the composite alarm waits after suppressor alarm goes out of the ALARM state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressorExtensionPeriod(final software.amazon.awscdk.Duration actionsSuppressorExtensionPeriod) {
            this.props.actionsSuppressorExtensionPeriod(actionsSuppressorExtensionPeriod);
            return this;
        }

        /**
         * The maximum duration that the composite alarm waits for the suppressor alarm to go into the ALARM state.
         * <p>
         * After this time, the composite alarm performs its actions.
         * <p>
         * Default: - 1 minute wait period will be set.
         * <p>
         * @return {@code this}
         * @param actionsSuppressorWaitPeriod The maximum duration that the composite alarm waits for the suppressor alarm to go into the ALARM state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressorWaitPeriod(final software.amazon.awscdk.Duration actionsSuppressorWaitPeriod) {
            this.props.actionsSuppressorWaitPeriod(actionsSuppressorWaitPeriod);
            return this;
        }

        /**
         * Description for the alarm.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param alarmDescription Description for the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmDescription(final java.lang.String alarmDescription) {
            this.props.alarmDescription(alarmDescription);
            return this;
        }

        /**
         * Name of the alarm.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param compositeAlarmName Name of the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeAlarmName(final java.lang.String compositeAlarmName) {
            this.props.compositeAlarmName(compositeAlarmName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.CompositeAlarm}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.CompositeAlarm build() {
            return new software.amazon.awscdk.services.cloudwatch.CompositeAlarm(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
