package software.amazon.awscdk.services.cognito;

/**
 * The different ways in which a user pool can obtain their MFA token for sign in.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .mfa(Mfa.REQUIRED)
 *         .mfaSecondFactor(MfaSecondFactor.builder()
 *                 .sms(true)
 *                 .otp(true)
 *                 .email(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:55.150Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.MfaSecondFactor")
@software.amazon.jsii.Jsii.Proxy(MfaSecondFactor.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MfaSecondFactor extends software.amazon.jsii.JsiiSerializable {

    /**
     * The MFA token is a time-based one time password that is generated by a hardware or software token.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa-totp.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa-totp.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getOtp();

    /**
     * The MFA token is sent to the user via SMS to their verified phone numbers.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa-sms-email-message.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa-sms-email-message.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getSms();

    /**
     * The MFA token is sent to the user via EMAIL.
     * <p>
     * To enable email-based MFA, set <code>email</code> property to the Amazon SES email-sending configuration
     * and set <code>advancedSecurityMode</code> to <code>AdvancedSecurity.ENFORCED</code> or <code>AdvancedSecurity.AUDIT</code>
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa-sms-email-message.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa-sms-email-message.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmail() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MfaSecondFactor}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MfaSecondFactor}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MfaSecondFactor> {
        java.lang.Boolean otp;
        java.lang.Boolean sms;
        java.lang.Boolean email;

        /**
         * Sets the value of {@link MfaSecondFactor#getOtp}
         * @param otp The MFA token is a time-based one time password that is generated by a hardware or software token. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder otp(java.lang.Boolean otp) {
            this.otp = otp;
            return this;
        }

        /**
         * Sets the value of {@link MfaSecondFactor#getSms}
         * @param sms The MFA token is sent to the user via SMS to their verified phone numbers. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sms(java.lang.Boolean sms) {
            this.sms = sms;
            return this;
        }

        /**
         * Sets the value of {@link MfaSecondFactor#getEmail}
         * @param email The MFA token is sent to the user via EMAIL.
         *              To enable email-based MFA, set <code>email</code> property to the Amazon SES email-sending configuration
         *              and set <code>advancedSecurityMode</code> to <code>AdvancedSecurity.ENFORCED</code> or <code>AdvancedSecurity.AUDIT</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder email(java.lang.Boolean email) {
            this.email = email;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MfaSecondFactor}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MfaSecondFactor build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MfaSecondFactor}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MfaSecondFactor {
        private final java.lang.Boolean otp;
        private final java.lang.Boolean sms;
        private final java.lang.Boolean email;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.otp = software.amazon.jsii.Kernel.get(this, "otp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sms = software.amazon.jsii.Kernel.get(this, "sms", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.otp = java.util.Objects.requireNonNull(builder.otp, "otp is required");
            this.sms = java.util.Objects.requireNonNull(builder.sms, "sms is required");
            this.email = builder.email;
        }

        @Override
        public final java.lang.Boolean getOtp() {
            return this.otp;
        }

        @Override
        public final java.lang.Boolean getSms() {
            return this.sms;
        }

        @Override
        public final java.lang.Boolean getEmail() {
            return this.email;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("otp", om.valueToTree(this.getOtp()));
            data.set("sms", om.valueToTree(this.getSms()));
            if (this.getEmail() != null) {
                data.set("email", om.valueToTree(this.getEmail()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.MfaSecondFactor"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MfaSecondFactor.Jsii$Proxy that = (MfaSecondFactor.Jsii$Proxy) o;

            if (!otp.equals(that.otp)) return false;
            if (!sms.equals(that.sms)) return false;
            return this.email != null ? this.email.equals(that.email) : that.email == null;
        }

        @Override
        public final int hashCode() {
            int result = this.otp.hashCode();
            result = 31 * result + (this.sms.hashCode());
            result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
            return result;
        }
    }
}
