package software.amazon.awscdk.services.cognito;

/**
 * Result of binding email settings with a user pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * UserPoolEmailConfig userPoolEmailConfig = UserPoolEmailConfig.builder()
 *         .configurationSet("configurationSet")
 *         .emailSendingAccount("emailSendingAccount")
 *         .from("from")
 *         .replyToEmailAddress("replyToEmailAddress")
 *         .sourceArn("sourceArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:55.184Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolEmailConfig")
@software.amazon.jsii.Jsii.Proxy(UserPoolEmailConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolEmailConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the configuration set in SES.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationSet() {
        return null;
    }

    /**
     * Specifies whether to use Cognito's built in email functionality or SES.
     * <p>
     * Default: - Cognito built in email functionality
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailSendingAccount() {
        return null;
    }

    /**
     * Identifies either the sender's email address or the sender's name with their email address.
     * <p>
     * If emailSendingAccount is DEVELOPER then this cannot be specified.
     * <p>
     * Default: 'no-reply@verificationemail.com'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFrom() {
        return null;
    }

    /**
     * The destination to which the receiver of the email should reply to.
     * <p>
     * Default: - same as `from`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReplyToEmailAddress() {
        return null;
    }

    /**
     * The ARN of a verified email address in Amazon SES.
     * <p>
     * required if emailSendingAccount is DEVELOPER or if
     * 'from' is provided.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolEmailConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolEmailConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolEmailConfig> {
        java.lang.String configurationSet;
        java.lang.String emailSendingAccount;
        java.lang.String from;
        java.lang.String replyToEmailAddress;
        java.lang.String sourceArn;

        /**
         * Sets the value of {@link UserPoolEmailConfig#getConfigurationSet}
         * @param configurationSet The name of the configuration set in SES.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSet(java.lang.String configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolEmailConfig#getEmailSendingAccount}
         * @param emailSendingAccount Specifies whether to use Cognito's built in email functionality or SES.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailSendingAccount(java.lang.String emailSendingAccount) {
            this.emailSendingAccount = emailSendingAccount;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolEmailConfig#getFrom}
         * @param from Identifies either the sender's email address or the sender's name with their email address.
         *             If emailSendingAccount is DEVELOPER then this cannot be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder from(java.lang.String from) {
            this.from = from;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolEmailConfig#getReplyToEmailAddress}
         * @param replyToEmailAddress The destination to which the receiver of the email should reply to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replyToEmailAddress(java.lang.String replyToEmailAddress) {
            this.replyToEmailAddress = replyToEmailAddress;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolEmailConfig#getSourceArn}
         * @param sourceArn The ARN of a verified email address in Amazon SES.
         *                  required if emailSendingAccount is DEVELOPER or if
         *                  'from' is provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceArn(java.lang.String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolEmailConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolEmailConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolEmailConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolEmailConfig {
        private final java.lang.String configurationSet;
        private final java.lang.String emailSendingAccount;
        private final java.lang.String from;
        private final java.lang.String replyToEmailAddress;
        private final java.lang.String sourceArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configurationSet = software.amazon.jsii.Kernel.get(this, "configurationSet", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.emailSendingAccount = software.amazon.jsii.Kernel.get(this, "emailSendingAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.from = software.amazon.jsii.Kernel.get(this, "from", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replyToEmailAddress = software.amazon.jsii.Kernel.get(this, "replyToEmailAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configurationSet = builder.configurationSet;
            this.emailSendingAccount = builder.emailSendingAccount;
            this.from = builder.from;
            this.replyToEmailAddress = builder.replyToEmailAddress;
            this.sourceArn = builder.sourceArn;
        }

        @Override
        public final java.lang.String getConfigurationSet() {
            return this.configurationSet;
        }

        @Override
        public final java.lang.String getEmailSendingAccount() {
            return this.emailSendingAccount;
        }

        @Override
        public final java.lang.String getFrom() {
            return this.from;
        }

        @Override
        public final java.lang.String getReplyToEmailAddress() {
            return this.replyToEmailAddress;
        }

        @Override
        public final java.lang.String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConfigurationSet() != null) {
                data.set("configurationSet", om.valueToTree(this.getConfigurationSet()));
            }
            if (this.getEmailSendingAccount() != null) {
                data.set("emailSendingAccount", om.valueToTree(this.getEmailSendingAccount()));
            }
            if (this.getFrom() != null) {
                data.set("from", om.valueToTree(this.getFrom()));
            }
            if (this.getReplyToEmailAddress() != null) {
                data.set("replyToEmailAddress", om.valueToTree(this.getReplyToEmailAddress()));
            }
            if (this.getSourceArn() != null) {
                data.set("sourceArn", om.valueToTree(this.getSourceArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolEmailConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolEmailConfig.Jsii$Proxy that = (UserPoolEmailConfig.Jsii$Proxy) o;

            if (this.configurationSet != null ? !this.configurationSet.equals(that.configurationSet) : that.configurationSet != null) return false;
            if (this.emailSendingAccount != null ? !this.emailSendingAccount.equals(that.emailSendingAccount) : that.emailSendingAccount != null) return false;
            if (this.from != null ? !this.from.equals(that.from) : that.from != null) return false;
            if (this.replyToEmailAddress != null ? !this.replyToEmailAddress.equals(that.replyToEmailAddress) : that.replyToEmailAddress != null) return false;
            return this.sourceArn != null ? this.sourceArn.equals(that.sourceArn) : that.sourceArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configurationSet != null ? this.configurationSet.hashCode() : 0;
            result = 31 * result + (this.emailSendingAccount != null ? this.emailSendingAccount.hashCode() : 0);
            result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
            result = 31 * result + (this.replyToEmailAddress != null ? this.replyToEmailAddress.hashCode() : 0);
            result = 31 * result + (this.sourceArn != null ? this.sourceArn.hashCode() : 0);
            return result;
        }
    }
}
