package software.amazon.awscdk.services.config;

/**
 * Properties for defining a <code>CfnConfigRule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * Object inputParameters;
 * CfnConfigRuleProps cfnConfigRuleProps = CfnConfigRuleProps.builder()
 *         .source(SourceProperty.builder()
 *                 .owner("owner")
 *                 // the properties below are optional
 *                 .customPolicyDetails(CustomPolicyDetailsProperty.builder()
 *                         .enableDebugLogDelivery(false)
 *                         .policyRuntime("policyRuntime")
 *                         .policyText("policyText")
 *                         .build())
 *                 .sourceDetails(List.of(SourceDetailProperty.builder()
 *                         .eventSource("eventSource")
 *                         .messageType("messageType")
 *                         // the properties below are optional
 *                         .maximumExecutionFrequency("maximumExecutionFrequency")
 *                         .build()))
 *                 .sourceIdentifier("sourceIdentifier")
 *                 .build())
 *         // the properties below are optional
 *         .compliance(ComplianceProperty.builder()
 *                 .type("type")
 *                 .build())
 *         .configRuleName("configRuleName")
 *         .description("description")
 *         .evaluationModes(List.of(EvaluationModeConfigurationProperty.builder()
 *                 .mode("mode")
 *                 .build()))
 *         .inputParameters(inputParameters)
 *         .maximumExecutionFrequency("maximumExecutionFrequency")
 *         .scope(ScopeProperty.builder()
 *                 .complianceResourceId("complianceResourceId")
 *                 .complianceResourceTypes(List.of("complianceResourceTypes"))
 *                 .tagKey("tagKey")
 *                 .tagValue("tagValue")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:55.236Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfigRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfigRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Provides the rule owner ( <code>AWS</code> for managed rules, <code>CUSTOM_POLICY</code> for Custom Policy rules, and <code>CUSTOM_LAMBDA</code> for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-source</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSource();

    /**
     * Indicates whether an AWS resource or AWS Config rule is compliant and provides the number of contributors that affect the compliance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-compliance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-compliance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCompliance() {
        return null;
    }

    /**
     * A name for the AWS Config rule.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the rule name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-configrulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-configrulename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigRuleName() {
        return null;
    }

    /**
     * The description that you provide for the AWS Config rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The modes the AWS Config rule can be evaluated in.
     * <p>
     * The valid values are distinct objects. By default, the value is Detective evaluation mode only.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-evaluationmodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-evaluationmodes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEvaluationModes() {
        return null;
    }

    /**
     * A string, in JSON format, that is passed to the AWS Config rule Lambda function.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-inputparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-inputparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInputParameters() {
        return null;
    }

    /**
     * The maximum frequency with which AWS Config runs evaluations for a rule.
     * <p>
     * You can specify a value for <code>MaximumExecutionFrequency</code> when:
     * <p>
     * <ul>
     * <li>You are using an AWS managed rule that is triggered at a periodic frequency.</li>
     * <li>Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html">ConfigSnapshotDeliveryProperties</a> .</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-maximumexecutionfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-maximumexecutionfrequency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
        return null;
    }

    /**
     * Defines which resources can trigger an evaluation for the rule.
     * <p>
     * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
     * <p>
     * <blockquote>
     * <p>
     * The scope can be empty.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-scope</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScope() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfigRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfigRuleProps> {
        java.lang.Object source;
        java.lang.Object compliance;
        java.lang.String configRuleName;
        java.lang.String description;
        java.lang.Object evaluationModes;
        java.lang.Object inputParameters;
        java.lang.String maximumExecutionFrequency;
        java.lang.Object scope;

        /**
         * Sets the value of {@link CfnConfigRuleProps#getSource}
         * @param source Provides the rule owner ( <code>AWS</code> for managed rules, <code>CUSTOM_POLICY</code> for Custom Policy rules, and <code>CUSTOM_LAMBDA</code> for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.IResolvable source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getSource}
         * @param source Provides the rule owner ( <code>AWS</code> for managed rules, <code>CUSTOM_POLICY</code> for Custom Policy rules, and <code>CUSTOM_LAMBDA</code> for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.services.config.CfnConfigRule.SourceProperty source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getCompliance}
         * @param compliance Indicates whether an AWS resource or AWS Config rule is compliant and provides the number of contributors that affect the compliance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compliance(software.amazon.awscdk.IResolvable compliance) {
            this.compliance = compliance;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getCompliance}
         * @param compliance Indicates whether an AWS resource or AWS Config rule is compliant and provides the number of contributors that affect the compliance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compliance(software.amazon.awscdk.services.config.CfnConfigRule.ComplianceProperty compliance) {
            this.compliance = compliance;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getConfigRuleName}
         * @param configRuleName A name for the AWS Config rule.
         *                       If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the rule name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(java.lang.String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getDescription}
         * @param description The description that you provide for the AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getEvaluationModes}
         * @param evaluationModes The modes the AWS Config rule can be evaluated in.
         *                        The valid values are distinct objects. By default, the value is Detective evaluation mode only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationModes(software.amazon.awscdk.IResolvable evaluationModes) {
            this.evaluationModes = evaluationModes;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getEvaluationModes}
         * @param evaluationModes The modes the AWS Config rule can be evaluated in.
         *                        The valid values are distinct objects. By default, the value is Detective evaluation mode only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationModes(java.util.List<? extends java.lang.Object> evaluationModes) {
            this.evaluationModes = evaluationModes;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getInputParameters}
         * @param inputParameters A string, in JSON format, that is passed to the AWS Config rule Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputParameters(java.lang.Object inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getMaximumExecutionFrequency}
         * @param maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule.
         *                                  You can specify a value for <code>MaximumExecutionFrequency</code> when:
         *                                  <p>
         *                                  <ul>
         *                                  <li>You are using an AWS managed rule that is triggered at a periodic frequency.</li>
         *                                  <li>Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html">ConfigSnapshotDeliveryProperties</a> .</li>
         *                                  </ul>
         *                                  <p>
         *                                  <blockquote>
         *                                  <p>
         *                                  By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         *                                  <p>
         *                                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumExecutionFrequency(java.lang.String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getScope}
         * @param scope Defines which resources can trigger an evaluation for the rule.
         *              The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
         *              <p>
         *              <blockquote>
         *              <p>
         *              The scope can be empty.
         *              <p>
         *              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.amazon.awscdk.IResolvable scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigRuleProps#getScope}
         * @param scope Defines which resources can trigger an evaluation for the rule.
         *              The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
         *              <p>
         *              <blockquote>
         *              <p>
         *              The scope can be empty.
         *              <p>
         *              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.amazon.awscdk.services.config.CfnConfigRule.ScopeProperty scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfigRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfigRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigRuleProps {
        private final java.lang.Object source;
        private final java.lang.Object compliance;
        private final java.lang.String configRuleName;
        private final java.lang.String description;
        private final java.lang.Object evaluationModes;
        private final java.lang.Object inputParameters;
        private final java.lang.String maximumExecutionFrequency;
        private final java.lang.Object scope;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.compliance = software.amazon.jsii.Kernel.get(this, "compliance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.configRuleName = software.amazon.jsii.Kernel.get(this, "configRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationModes = software.amazon.jsii.Kernel.get(this, "evaluationModes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.compliance = builder.compliance;
            this.configRuleName = builder.configRuleName;
            this.description = builder.description;
            this.evaluationModes = builder.evaluationModes;
            this.inputParameters = builder.inputParameters;
            this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
            this.scope = builder.scope;
        }

        @Override
        public final java.lang.Object getSource() {
            return this.source;
        }

        @Override
        public final java.lang.Object getCompliance() {
            return this.compliance;
        }

        @Override
        public final java.lang.String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEvaluationModes() {
            return this.evaluationModes;
        }

        @Override
        public final java.lang.Object getInputParameters() {
            return this.inputParameters;
        }

        @Override
        public final java.lang.String getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final java.lang.Object getScope() {
            return this.scope;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("source", om.valueToTree(this.getSource()));
            if (this.getCompliance() != null) {
                data.set("compliance", om.valueToTree(this.getCompliance()));
            }
            if (this.getConfigRuleName() != null) {
                data.set("configRuleName", om.valueToTree(this.getConfigRuleName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEvaluationModes() != null) {
                data.set("evaluationModes", om.valueToTree(this.getEvaluationModes()));
            }
            if (this.getInputParameters() != null) {
                data.set("inputParameters", om.valueToTree(this.getInputParameters()));
            }
            if (this.getMaximumExecutionFrequency() != null) {
                data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
            }
            if (this.getScope() != null) {
                data.set("scope", om.valueToTree(this.getScope()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigRuleProps.Jsii$Proxy that = (CfnConfigRuleProps.Jsii$Proxy) o;

            if (!source.equals(that.source)) return false;
            if (this.compliance != null ? !this.compliance.equals(that.compliance) : that.compliance != null) return false;
            if (this.configRuleName != null ? !this.configRuleName.equals(that.configRuleName) : that.configRuleName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.evaluationModes != null ? !this.evaluationModes.equals(that.evaluationModes) : that.evaluationModes != null) return false;
            if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
            if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
            return this.scope != null ? this.scope.equals(that.scope) : that.scope == null;
        }

        @Override
        public final int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + (this.compliance != null ? this.compliance.hashCode() : 0);
            result = 31 * result + (this.configRuleName != null ? this.configRuleName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.evaluationModes != null ? this.evaluationModes.hashCode() : 0);
            result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
            result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            return result;
        }
    }
}
