package software.amazon.awscdk.services.dlm;

/**
 * Properties for defining a <code>CfnLifecyclePolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dlm.*;
 * Object crossRegionCopyTargets;
 * Object excludeTags;
 * Object excludeVolumeTypes;
 * CfnLifecyclePolicyProps cfnLifecyclePolicyProps = CfnLifecyclePolicyProps.builder()
 *         .copyTags(false)
 *         .createInterval(123)
 *         .crossRegionCopyTargets(crossRegionCopyTargets)
 *         .defaultPolicy("defaultPolicy")
 *         .description("description")
 *         .exclusions(ExclusionsProperty.builder()
 *                 .excludeBootVolumes(false)
 *                 .excludeTags(excludeTags)
 *                 .excludeVolumeTypes(excludeVolumeTypes)
 *                 .build())
 *         .executionRoleArn("executionRoleArn")
 *         .extendDeletion(false)
 *         .policyDetails(PolicyDetailsProperty.builder()
 *                 .actions(List.of(ActionProperty.builder()
 *                         .crossRegionCopy(List.of(CrossRegionCopyActionProperty.builder()
 *                                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                         .encrypted(false)
 *                                         // the properties below are optional
 *                                         .cmkArn("cmkArn")
 *                                         .build())
 *                                 .target("target")
 *                                 // the properties below are optional
 *                                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .build()))
 *                         .name("name")
 *                         .build()))
 *                 .copyTags(false)
 *                 .createInterval(123)
 *                 .crossRegionCopyTargets(crossRegionCopyTargets)
 *                 .eventSource(EventSourceProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .parameters(EventParametersProperty.builder()
 *                                 .eventType("eventType")
 *                                 .snapshotOwner(List.of("snapshotOwner"))
 *                                 // the properties below are optional
 *                                 .descriptionRegex("descriptionRegex")
 *                                 .build())
 *                         .build())
 *                 .exclusions(ExclusionsProperty.builder()
 *                         .excludeBootVolumes(false)
 *                         .excludeTags(excludeTags)
 *                         .excludeVolumeTypes(excludeVolumeTypes)
 *                         .build())
 *                 .extendDeletion(false)
 *                 .parameters(ParametersProperty.builder()
 *                         .excludeBootVolume(false)
 *                         .excludeDataVolumeTags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .noReboot(false)
 *                         .build())
 *                 .policyLanguage("policyLanguage")
 *                 .policyType("policyType")
 *                 .resourceLocations(List.of("resourceLocations"))
 *                 .resourceType("resourceType")
 *                 .resourceTypes(List.of("resourceTypes"))
 *                 .retainInterval(123)
 *                 .schedules(List.of(ScheduleProperty.builder()
 *                         .archiveRule(ArchiveRuleProperty.builder()
 *                                 .retainRule(ArchiveRetainRuleProperty.builder()
 *                                         .retentionArchiveTier(RetentionArchiveTierProperty.builder()
 *                                                 .count(123)
 *                                                 .interval(123)
 *                                                 .intervalUnit("intervalUnit")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .copyTags(false)
 *                         .createRule(CreateRuleProperty.builder()
 *                                 .cronExpression("cronExpression")
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .location("location")
 *                                 .scripts(List.of(ScriptProperty.builder()
 *                                         .executeOperationOnScriptFailure(false)
 *                                         .executionHandler("executionHandler")
 *                                         .executionHandlerService("executionHandlerService")
 *                                         .executionTimeout(123)
 *                                         .maximumRetryCount(123)
 *                                         .stages(List.of("stages"))
 *                                         .build()))
 *                                 .times(List.of("times"))
 *                                 .build())
 *                         .crossRegionCopyRules(List.of(CrossRegionCopyRuleProperty.builder()
 *                                 .encrypted(false)
 *                                 // the properties below are optional
 *                                 .cmkArn("cmkArn")
 *                                 .copyTags(false)
 *                                 .deprecateRule(CrossRegionCopyDeprecateRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .target("target")
 *                                 .targetRegion("targetRegion")
 *                                 .build()))
 *                         .deprecateRule(DeprecateRuleProperty.builder()
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .fastRestoreRule(FastRestoreRuleProperty.builder()
 *                                 .availabilityZones(List.of("availabilityZones"))
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .name("name")
 *                         .retainRule(RetainRuleProperty.builder()
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .shareRules(List.of(ShareRuleProperty.builder()
 *                                 .targetAccounts(List.of("targetAccounts"))
 *                                 .unshareInterval(123)
 *                                 .unshareIntervalUnit("unshareIntervalUnit")
 *                                 .build()))
 *                         .tagsToAdd(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .variableTags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .targetTags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .retainInterval(123)
 *         .state("state")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:55.790Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnLifecyclePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLifecyclePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
     * <p>
     * If you do not specify a value, the default is <code>false</code> .
     * <p>
     * Default: false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-copytags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-copytags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTags() {
        return null;
    }

    /**
     * <em>[Default policies only]</em> Specifies how often the policy should run and create snapshots or AMIs.
     * <p>
     * The creation frequency can range from 1 to 7 days. If you do not specify a value, the default is 1.
     * <p>
     * Default: 1
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-createinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-createinterval</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCreateInterval() {
        return null;
    }

    /**
     * <em>[Default policies only]</em> Specifies destination Regions for snapshot or AMI copies.
     * <p>
     * You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-crossregioncopytargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-crossregioncopytargets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCrossRegionCopyTargets() {
        return null;
    }

    /**
     * <em>[Default policies only]</em> Specify the type of default policy to create.
     * <p>
     * <ul>
     * <li>To create a default policy for EBS snapshots, that creates snapshots of all volumes in the Region that do not have recent backups, specify <code>VOLUME</code> .</li>
     * <li>To create a default policy for EBS-backed AMIs, that creates EBS-backed AMIs from all instances in the Region that do not have recent backups, specify <code>INSTANCE</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-defaultpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-defaultpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultPolicy() {
        return null;
    }

    /**
     * A description of the lifecycle policy.
     * <p>
     * The characters ^[0-9A-Za-z _-]+$ are supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
     * <p>
     * The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-exclusions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-exclusions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExclusions() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-executionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return null;
    }

    /**
     * <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
     * <p>
     * By default ( <em>ExtendDeletion=false</em> ):
     * <p>
     * <ul>
     * <li>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code> .</li>
     * <li>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code> .</li>
     * </ul>
     * <p>
     * If you enable extended deletion ( <em>ExtendDeletion=true</em> ), you override both default behaviors simultaneously.
     * <p>
     * If you do not specify a value, the default is <code>false</code> .
     * <p>
     * Default: false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-extenddeletion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-extenddeletion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExtendDeletion() {
        return null;
    }

    /**
     * The configuration details of the lifecycle policy.
     * <p>
     * <blockquote>
     * <p>
     * If you create a default policy, you can specify the request parameters either in the request body, or in the PolicyDetails request structure, but not both.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-policydetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-policydetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicyDetails() {
        return null;
    }

    /**
     * <em>[Default policies only]</em> Specifies how long the policy should retain snapshots or AMIs before deleting them.
     * <p>
     * The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time. If you do not specify a value, the default is 7.
     * <p>
     * Default: 7
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-retaininterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-retaininterval</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetainInterval() {
        return null;
    }

    /**
     * The activation state of the lifecycle policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-state</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * The tags to apply to the lifecycle policy during creation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLifecyclePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLifecyclePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLifecyclePolicyProps> {
        java.lang.Object copyTags;
        java.lang.Number createInterval;
        java.lang.Object crossRegionCopyTargets;
        java.lang.String defaultPolicy;
        java.lang.String description;
        java.lang.Object exclusions;
        java.lang.String executionRoleArn;
        java.lang.Object extendDeletion;
        java.lang.Object policyDetails;
        java.lang.Number retainInterval;
        java.lang.String state;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getCopyTags}
         * @param copyTags <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
         *                 If you do not specify a value, the default is <code>false</code> .
         *                 <p>
         *                 Default: false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTags(java.lang.Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getCopyTags}
         * @param copyTags <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
         *                 If you do not specify a value, the default is <code>false</code> .
         *                 <p>
         *                 Default: false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTags(software.amazon.awscdk.IResolvable copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getCreateInterval}
         * @param createInterval <em>[Default policies only]</em> Specifies how often the policy should run and create snapshots or AMIs.
         *                       The creation frequency can range from 1 to 7 days. If you do not specify a value, the default is 1.
         *                       <p>
         *                       Default: 1
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createInterval(java.lang.Number createInterval) {
            this.createInterval = createInterval;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getCrossRegionCopyTargets}
         * @param crossRegionCopyTargets <em>[Default policies only]</em> Specifies destination Regions for snapshot or AMI copies.
         *                               You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossRegionCopyTargets(java.lang.Object crossRegionCopyTargets) {
            this.crossRegionCopyTargets = crossRegionCopyTargets;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getDefaultPolicy}
         * @param defaultPolicy <em>[Default policies only]</em> Specify the type of default policy to create.
         *                      <ul>
         *                      <li>To create a default policy for EBS snapshots, that creates snapshots of all volumes in the Region that do not have recent backups, specify <code>VOLUME</code> .</li>
         *                      <li>To create a default policy for EBS-backed AMIs, that creates EBS-backed AMIs from all instances in the Region that do not have recent backups, specify <code>INSTANCE</code> .</li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPolicy(java.lang.String defaultPolicy) {
            this.defaultPolicy = defaultPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getDescription}
         * @param description A description of the lifecycle policy.
         *                    The characters ^[0-9A-Za-z _-]+$ are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getExclusions}
         * @param exclusions <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
         *                   The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclusions(software.amazon.awscdk.IResolvable exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getExclusions}
         * @param exclusions <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
         *                   The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclusions(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ExclusionsProperty exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getExecutionRoleArn}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getExtendDeletion}
         * @param extendDeletion <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
         *                       By default ( <em>ExtendDeletion=false</em> ):
         *                       <p>
         *                       <ul>
         *                       <li>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code> .</li>
         *                       <li>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code> .</li>
         *                       </ul>
         *                       <p>
         *                       If you enable extended deletion ( <em>ExtendDeletion=true</em> ), you override both default behaviors simultaneously.
         *                       <p>
         *                       If you do not specify a value, the default is <code>false</code> .
         *                       <p>
         *                       Default: false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendDeletion(java.lang.Boolean extendDeletion) {
            this.extendDeletion = extendDeletion;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getExtendDeletion}
         * @param extendDeletion <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
         *                       By default ( <em>ExtendDeletion=false</em> ):
         *                       <p>
         *                       <ul>
         *                       <li>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code> .</li>
         *                       <li>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code> .</li>
         *                       </ul>
         *                       <p>
         *                       If you enable extended deletion ( <em>ExtendDeletion=true</em> ), you override both default behaviors simultaneously.
         *                       <p>
         *                       If you do not specify a value, the default is <code>false</code> .
         *                       <p>
         *                       Default: false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendDeletion(software.amazon.awscdk.IResolvable extendDeletion) {
            this.extendDeletion = extendDeletion;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getPolicyDetails}
         * @param policyDetails The configuration details of the lifecycle policy.
         *                      <blockquote>
         *                      <p>
         *                      If you create a default policy, you can specify the request parameters either in the request body, or in the PolicyDetails request structure, but not both.
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(software.amazon.awscdk.IResolvable policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getPolicyDetails}
         * @param policyDetails The configuration details of the lifecycle policy.
         *                      <blockquote>
         *                      <p>
         *                      If you create a default policy, you can specify the request parameters either in the request body, or in the PolicyDetails request structure, but not both.
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.PolicyDetailsProperty policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getRetainInterval}
         * @param retainInterval <em>[Default policies only]</em> Specifies how long the policy should retain snapshots or AMIs before deleting them.
         *                       The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time. If you do not specify a value, the default is 7.
         *                       <p>
         *                       Default: 7
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainInterval(java.lang.Number retainInterval) {
            this.retainInterval = retainInterval;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getState}
         * @param state The activation state of the lifecycle policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getTags}
         * @param tags The tags to apply to the lifecycle policy during creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLifecyclePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLifecyclePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLifecyclePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLifecyclePolicyProps {
        private final java.lang.Object copyTags;
        private final java.lang.Number createInterval;
        private final java.lang.Object crossRegionCopyTargets;
        private final java.lang.String defaultPolicy;
        private final java.lang.String description;
        private final java.lang.Object exclusions;
        private final java.lang.String executionRoleArn;
        private final java.lang.Object extendDeletion;
        private final java.lang.Object policyDetails;
        private final java.lang.Number retainInterval;
        private final java.lang.String state;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.copyTags = software.amazon.jsii.Kernel.get(this, "copyTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.createInterval = software.amazon.jsii.Kernel.get(this, "createInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.crossRegionCopyTargets = software.amazon.jsii.Kernel.get(this, "crossRegionCopyTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultPolicy = software.amazon.jsii.Kernel.get(this, "defaultPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exclusions = software.amazon.jsii.Kernel.get(this, "exclusions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extendDeletion = software.amazon.jsii.Kernel.get(this, "extendDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policyDetails = software.amazon.jsii.Kernel.get(this, "policyDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retainInterval = software.amazon.jsii.Kernel.get(this, "retainInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.copyTags = builder.copyTags;
            this.createInterval = builder.createInterval;
            this.crossRegionCopyTargets = builder.crossRegionCopyTargets;
            this.defaultPolicy = builder.defaultPolicy;
            this.description = builder.description;
            this.exclusions = builder.exclusions;
            this.executionRoleArn = builder.executionRoleArn;
            this.extendDeletion = builder.extendDeletion;
            this.policyDetails = builder.policyDetails;
            this.retainInterval = builder.retainInterval;
            this.state = builder.state;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getCopyTags() {
            return this.copyTags;
        }

        @Override
        public final java.lang.Number getCreateInterval() {
            return this.createInterval;
        }

        @Override
        public final java.lang.Object getCrossRegionCopyTargets() {
            return this.crossRegionCopyTargets;
        }

        @Override
        public final java.lang.String getDefaultPolicy() {
            return this.defaultPolicy;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getExclusions() {
            return this.exclusions;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.Object getExtendDeletion() {
            return this.extendDeletion;
        }

        @Override
        public final java.lang.Object getPolicyDetails() {
            return this.policyDetails;
        }

        @Override
        public final java.lang.Number getRetainInterval() {
            return this.retainInterval;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCopyTags() != null) {
                data.set("copyTags", om.valueToTree(this.getCopyTags()));
            }
            if (this.getCreateInterval() != null) {
                data.set("createInterval", om.valueToTree(this.getCreateInterval()));
            }
            if (this.getCrossRegionCopyTargets() != null) {
                data.set("crossRegionCopyTargets", om.valueToTree(this.getCrossRegionCopyTargets()));
            }
            if (this.getDefaultPolicy() != null) {
                data.set("defaultPolicy", om.valueToTree(this.getDefaultPolicy()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExclusions() != null) {
                data.set("exclusions", om.valueToTree(this.getExclusions()));
            }
            if (this.getExecutionRoleArn() != null) {
                data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            }
            if (this.getExtendDeletion() != null) {
                data.set("extendDeletion", om.valueToTree(this.getExtendDeletion()));
            }
            if (this.getPolicyDetails() != null) {
                data.set("policyDetails", om.valueToTree(this.getPolicyDetails()));
            }
            if (this.getRetainInterval() != null) {
                data.set("retainInterval", om.valueToTree(this.getRetainInterval()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLifecyclePolicyProps.Jsii$Proxy that = (CfnLifecyclePolicyProps.Jsii$Proxy) o;

            if (this.copyTags != null ? !this.copyTags.equals(that.copyTags) : that.copyTags != null) return false;
            if (this.createInterval != null ? !this.createInterval.equals(that.createInterval) : that.createInterval != null) return false;
            if (this.crossRegionCopyTargets != null ? !this.crossRegionCopyTargets.equals(that.crossRegionCopyTargets) : that.crossRegionCopyTargets != null) return false;
            if (this.defaultPolicy != null ? !this.defaultPolicy.equals(that.defaultPolicy) : that.defaultPolicy != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.exclusions != null ? !this.exclusions.equals(that.exclusions) : that.exclusions != null) return false;
            if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
            if (this.extendDeletion != null ? !this.extendDeletion.equals(that.extendDeletion) : that.extendDeletion != null) return false;
            if (this.policyDetails != null ? !this.policyDetails.equals(that.policyDetails) : that.policyDetails != null) return false;
            if (this.retainInterval != null ? !this.retainInterval.equals(that.retainInterval) : that.retainInterval != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.copyTags != null ? this.copyTags.hashCode() : 0;
            result = 31 * result + (this.createInterval != null ? this.createInterval.hashCode() : 0);
            result = 31 * result + (this.crossRegionCopyTargets != null ? this.crossRegionCopyTargets.hashCode() : 0);
            result = 31 * result + (this.defaultPolicy != null ? this.defaultPolicy.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.exclusions != null ? this.exclusions.hashCode() : 0);
            result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
            result = 31 * result + (this.extendDeletion != null ? this.extendDeletion.hashCode() : 0);
            result = 31 * result + (this.policyDetails != null ? this.policyDetails.hashCode() : 0);
            result = 31 * result + (this.retainInterval != null ? this.retainInterval.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
