package software.amazon.awscdk.services.dms;

/**
 * The <code>AWS::DMS::Endpoint</code> resource specifies an AWS DMS endpoint.
 * <p>
 * Currently, AWS CloudFormation supports all AWS DMS endpoint types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnEndpoint cfnEndpoint = CfnEndpoint.Builder.create(this, "MyCfnEndpoint")
 *         .endpointType("endpointType")
 *         .engineName("engineName")
 *         // the properties below are optional
 *         .certificateArn("certificateArn")
 *         .databaseName("databaseName")
 *         .docDbSettings(DocDbSettingsProperty.builder()
 *                 .docsToInvestigate(123)
 *                 .extractDocId(false)
 *                 .nestingLevel("nestingLevel")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .dynamoDbSettings(DynamoDbSettingsProperty.builder()
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .elasticsearchSettings(ElasticsearchSettingsProperty.builder()
 *                 .endpointUri("endpointUri")
 *                 .errorRetryDuration(123)
 *                 .fullLoadErrorPercentage(123)
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .endpointIdentifier("endpointIdentifier")
 *         .extraConnectionAttributes("extraConnectionAttributes")
 *         .gcpMySqlSettings(GcpMySQLSettingsProperty.builder()
 *                 .afterConnectScript("afterConnectScript")
 *                 .cleanSourceMetadataOnMismatch(false)
 *                 .databaseName("databaseName")
 *                 .eventsPollInterval(123)
 *                 .maxFileSize(123)
 *                 .parallelLoadThreads(123)
 *                 .password("password")
 *                 .port(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverName("serverName")
 *                 .serverTimezone("serverTimezone")
 *                 .username("username")
 *                 .build())
 *         .ibmDb2Settings(IbmDb2SettingsProperty.builder()
 *                 .currentLsn("currentLsn")
 *                 .keepCsvFiles(false)
 *                 .loadTimeout(123)
 *                 .maxFileSize(123)
 *                 .maxKBytesPerRead(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .setDataCaptureChanges(false)
 *                 .writeBufferSize(123)
 *                 .build())
 *         .kafkaSettings(KafkaSettingsProperty.builder()
 *                 .broker("broker")
 *                 .includeControlDetails(false)
 *                 .includeNullAndEmpty(false)
 *                 .includePartitionValue(false)
 *                 .includeTableAlterOperations(false)
 *                 .includeTransactionDetails(false)
 *                 .messageFormat("messageFormat")
 *                 .messageMaxBytes(123)
 *                 .noHexPrefix(false)
 *                 .partitionIncludeSchemaTable(false)
 *                 .saslPassword("saslPassword")
 *                 .saslUserName("saslUserName")
 *                 .securityProtocol("securityProtocol")
 *                 .sslCaCertificateArn("sslCaCertificateArn")
 *                 .sslClientCertificateArn("sslClientCertificateArn")
 *                 .sslClientKeyArn("sslClientKeyArn")
 *                 .sslClientKeyPassword("sslClientKeyPassword")
 *                 .topic("topic")
 *                 .build())
 *         .kinesisSettings(KinesisSettingsProperty.builder()
 *                 .includeControlDetails(false)
 *                 .includeNullAndEmpty(false)
 *                 .includePartitionValue(false)
 *                 .includeTableAlterOperations(false)
 *                 .includeTransactionDetails(false)
 *                 .messageFormat("messageFormat")
 *                 .noHexPrefix(false)
 *                 .partitionIncludeSchemaTable(false)
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .streamArn("streamArn")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .microsoftSqlServerSettings(MicrosoftSqlServerSettingsProperty.builder()
 *                 .bcpPacketSize(123)
 *                 .controlTablesFileGroup("controlTablesFileGroup")
 *                 .databaseName("databaseName")
 *                 .forceLobLookup(false)
 *                 .password("password")
 *                 .port(123)
 *                 .querySingleAlwaysOnNode(false)
 *                 .readBackupOnly(false)
 *                 .safeguardPolicy("safeguardPolicy")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverName("serverName")
 *                 .tlogAccessMode("tlogAccessMode")
 *                 .trimSpaceInChar(false)
 *                 .useBcpFullLoad(false)
 *                 .username("username")
 *                 .useThirdPartyBackupDevice(false)
 *                 .build())
 *         .mongoDbSettings(MongoDbSettingsProperty.builder()
 *                 .authMechanism("authMechanism")
 *                 .authSource("authSource")
 *                 .authType("authType")
 *                 .databaseName("databaseName")
 *                 .docsToInvestigate("docsToInvestigate")
 *                 .extractDocId("extractDocId")
 *                 .nestingLevel("nestingLevel")
 *                 .password("password")
 *                 .port(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverName("serverName")
 *                 .username("username")
 *                 .build())
 *         .mySqlSettings(MySqlSettingsProperty.builder()
 *                 .afterConnectScript("afterConnectScript")
 *                 .cleanSourceMetadataOnMismatch(false)
 *                 .eventsPollInterval(123)
 *                 .maxFileSize(123)
 *                 .parallelLoadThreads(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverTimezone("serverTimezone")
 *                 .targetDbType("targetDbType")
 *                 .build())
 *         .neptuneSettings(NeptuneSettingsProperty.builder()
 *                 .errorRetryDuration(123)
 *                 .iamAuthEnabled(false)
 *                 .maxFileSize(123)
 *                 .maxRetryCount(123)
 *                 .s3BucketFolder("s3BucketFolder")
 *                 .s3BucketName("s3BucketName")
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .oracleSettings(OracleSettingsProperty.builder()
 *                 .accessAlternateDirectly(false)
 *                 .additionalArchivedLogDestId(123)
 *                 .addSupplementalLogging(false)
 *                 .allowSelectNestedTables(false)
 *                 .archivedLogDestId(123)
 *                 .archivedLogsOnly(false)
 *                 .asmPassword("asmPassword")
 *                 .asmServer("asmServer")
 *                 .asmUser("asmUser")
 *                 .charLengthSemantics("charLengthSemantics")
 *                 .directPathNoLog(false)
 *                 .directPathParallelLoad(false)
 *                 .enableHomogenousTablespace(false)
 *                 .extraArchivedLogDestIds(List.of(123))
 *                 .failTasksOnLobTruncation(false)
 *                 .numberDatatypeScale(123)
 *                 .oraclePathPrefix("oraclePathPrefix")
 *                 .parallelAsmReadThreads(123)
 *                 .readAheadBlocks(123)
 *                 .readTableSpaceName(false)
 *                 .replacePathPrefix(false)
 *                 .retryInterval(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
 *                 .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .securityDbEncryption("securityDbEncryption")
 *                 .securityDbEncryptionName("securityDbEncryptionName")
 *                 .spatialDataOptionToGeoJsonFunctionName("spatialDataOptionToGeoJsonFunctionName")
 *                 .standbyDelayTime(123)
 *                 .useAlternateFolderForOnline(false)
 *                 .useBFile(false)
 *                 .useDirectPathFullLoad(false)
 *                 .useLogminerReader(false)
 *                 .usePathPrefix("usePathPrefix")
 *                 .build())
 *         .password("password")
 *         .port(123)
 *         .postgreSqlSettings(PostgreSqlSettingsProperty.builder()
 *                 .afterConnectScript("afterConnectScript")
 *                 .babelfishDatabaseName("babelfishDatabaseName")
 *                 .captureDdls(false)
 *                 .databaseMode("databaseMode")
 *                 .ddlArtifactsSchema("ddlArtifactsSchema")
 *                 .executeTimeout(123)
 *                 .failTasksOnLobTruncation(false)
 *                 .heartbeatEnable(false)
 *                 .heartbeatFrequency(123)
 *                 .heartbeatSchema("heartbeatSchema")
 *                 .mapBooleanAsBoolean(false)
 *                 .maxFileSize(123)
 *                 .pluginName("pluginName")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .slotName("slotName")
 *                 .build())
 *         .redisSettings(RedisSettingsProperty.builder()
 *                 .authPassword("authPassword")
 *                 .authType("authType")
 *                 .authUserName("authUserName")
 *                 .port(123)
 *                 .serverName("serverName")
 *                 .sslCaCertificateArn("sslCaCertificateArn")
 *                 .sslSecurityProtocol("sslSecurityProtocol")
 *                 .build())
 *         .redshiftSettings(RedshiftSettingsProperty.builder()
 *                 .acceptAnyDate(false)
 *                 .afterConnectScript("afterConnectScript")
 *                 .bucketFolder("bucketFolder")
 *                 .bucketName("bucketName")
 *                 .caseSensitiveNames(false)
 *                 .compUpdate(false)
 *                 .connectionTimeout(123)
 *                 .dateFormat("dateFormat")
 *                 .emptyAsNull(false)
 *                 .encryptionMode("encryptionMode")
 *                 .explicitIds(false)
 *                 .fileTransferUploadStreams(123)
 *                 .loadTimeout(123)
 *                 .mapBooleanAsBoolean(false)
 *                 .maxFileSize(123)
 *                 .removeQuotes(false)
 *                 .replaceChars("replaceChars")
 *                 .replaceInvalidChars("replaceInvalidChars")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverSideEncryptionKmsKeyId("serverSideEncryptionKmsKeyId")
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .timeFormat("timeFormat")
 *                 .trimBlanks(false)
 *                 .truncateColumns(false)
 *                 .writeBufferSize(123)
 *                 .build())
 *         .resourceIdentifier("resourceIdentifier")
 *         .s3Settings(S3SettingsProperty.builder()
 *                 .addColumnName(false)
 *                 .addTrailingPaddingCharacter(false)
 *                 .bucketFolder("bucketFolder")
 *                 .bucketName("bucketName")
 *                 .cannedAclForObjects("cannedAclForObjects")
 *                 .cdcInsertsAndUpdates(false)
 *                 .cdcInsertsOnly(false)
 *                 .cdcMaxBatchInterval(123)
 *                 .cdcMinFileSize(123)
 *                 .cdcPath("cdcPath")
 *                 .compressionType("compressionType")
 *                 .csvDelimiter("csvDelimiter")
 *                 .csvNoSupValue("csvNoSupValue")
 *                 .csvNullValue("csvNullValue")
 *                 .csvRowDelimiter("csvRowDelimiter")
 *                 .dataFormat("dataFormat")
 *                 .dataPageSize(123)
 *                 .datePartitionDelimiter("datePartitionDelimiter")
 *                 .datePartitionEnabled(false)
 *                 .datePartitionSequence("datePartitionSequence")
 *                 .datePartitionTimezone("datePartitionTimezone")
 *                 .dictPageSizeLimit(123)
 *                 .enableStatistics(false)
 *                 .encodingType("encodingType")
 *                 .encryptionMode("encryptionMode")
 *                 .expectedBucketOwner("expectedBucketOwner")
 *                 .externalTableDefinition("externalTableDefinition")
 *                 .glueCatalogGeneration(false)
 *                 .ignoreHeaderRows(123)
 *                 .includeOpForFullLoad(false)
 *                 .maxFileSize(123)
 *                 .parquetTimestampInMillisecond(false)
 *                 .parquetVersion("parquetVersion")
 *                 .preserveTransactions(false)
 *                 .rfc4180(false)
 *                 .rowGroupLength(123)
 *                 .serverSideEncryptionKmsKeyId("serverSideEncryptionKmsKeyId")
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .timestampColumnName("timestampColumnName")
 *                 .useCsvNoSupValue(false)
 *                 .useTaskStartTimeForFullLoadTimestamp(false)
 *                 .build())
 *         .serverName("serverName")
 *         .sslMode("sslMode")
 *         .sybaseSettings(SybaseSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .username("username")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:55.803Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint")
public class CfnEndpoint extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dms.CfnEndpoint.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEndpoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dms.CfnEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A value that can be used for cross-account validation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrExternalId() {
        return software.amazon.jsii.Kernel.get(this, "attrExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The type of endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEndpointType() {
        return software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointType", java.util.Objects.requireNonNull(value, "endpointType is required"));
    }

    /**
     * The type of engine for the endpoint, depending on the <code>EndpointType</code> value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngineName() {
        return software.amazon.jsii.Kernel.get(this, "engineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of engine for the endpoint, depending on the <code>EndpointType</code> value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineName", java.util.Objects.requireNonNull(value, "engineName is required"));
    }

    /**
     * The Amazon Resource Name (ARN) for the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
        return software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateArn", value);
    }

    /**
     * The name of the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", value);
    }

    /**
     * Settings in JSON format for the source and target DocumentDB endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDocDbSettings() {
        return software.amazon.jsii.Kernel.get(this, "docDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source and target DocumentDB endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "docDbSettings", value);
    }

    /**
     * Settings in JSON format for the source and target DocumentDB endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.DocDbSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "docDbSettings", value);
    }

    /**
     * Settings in JSON format for the target Amazon DynamoDB endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbSettings() {
        return software.amazon.jsii.Kernel.get(this, "dynamoDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target Amazon DynamoDB endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDynamoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dynamoDbSettings", value);
    }

    /**
     * Settings in JSON format for the target Amazon DynamoDB endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDynamoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.DynamoDbSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "dynamoDbSettings", value);
    }

    /**
     * Settings in JSON format for the target OpenSearch endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchSettings() {
        return software.amazon.jsii.Kernel.get(this, "elasticsearchSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target OpenSearch endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchSettings", value);
    }

    /**
     * Settings in JSON format for the target OpenSearch endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.ElasticsearchSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchSettings", value);
    }

    /**
     * The database endpoint identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "endpointIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The database endpoint identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointIdentifier", value);
    }

    /**
     * Additional attributes associated with the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExtraConnectionAttributes() {
        return software.amazon.jsii.Kernel.get(this, "extraConnectionAttributes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Additional attributes associated with the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtraConnectionAttributes(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "extraConnectionAttributes", value);
    }

    /**
     * Settings in JSON format for the source GCP MySQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGcpMySqlSettings() {
        return software.amazon.jsii.Kernel.get(this, "gcpMySqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source GCP MySQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGcpMySqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "gcpMySqlSettings", value);
    }

    /**
     * Settings in JSON format for the source GCP MySQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGcpMySqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.GcpMySQLSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "gcpMySqlSettings", value);
    }

    /**
     * Settings in JSON format for the source IBM Db2 LUW endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIbmDb2Settings() {
        return software.amazon.jsii.Kernel.get(this, "ibmDb2Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source IBM Db2 LUW endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIbmDb2Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ibmDb2Settings", value);
    }

    /**
     * Settings in JSON format for the source IBM Db2 LUW endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIbmDb2Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.IbmDb2SettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "ibmDb2Settings", value);
    }

    /**
     * Settings in JSON format for the target Apache Kafka endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKafkaSettings() {
        return software.amazon.jsii.Kernel.get(this, "kafkaSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target Apache Kafka endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kafkaSettings", value);
    }

    /**
     * Settings in JSON format for the target Apache Kafka endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.KafkaSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "kafkaSettings", value);
    }

    /**
     * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKinesisSettings() {
        return software.amazon.jsii.Kernel.get(this, "kinesisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisSettings", value);
    }

    /**
     * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.KinesisSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisSettings", value);
    }

    /**
     * An AWS KMS key identifier that is used to encrypt the connection parameters for the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An AWS KMS key identifier that is used to encrypt the connection parameters for the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Settings in JSON format for the source and target Microsoft SQL Server endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMicrosoftSqlServerSettings() {
        return software.amazon.jsii.Kernel.get(this, "microsoftSqlServerSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source and target Microsoft SQL Server endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMicrosoftSqlServerSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "microsoftSqlServerSettings", value);
    }

    /**
     * Settings in JSON format for the source and target Microsoft SQL Server endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMicrosoftSqlServerSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "microsoftSqlServerSettings", value);
    }

    /**
     * Settings in JSON format for the source MongoDB endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMongoDbSettings() {
        return software.amazon.jsii.Kernel.get(this, "mongoDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source MongoDB endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMongoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mongoDbSettings", value);
    }

    /**
     * Settings in JSON format for the source MongoDB endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMongoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.MongoDbSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "mongoDbSettings", value);
    }

    /**
     * Settings in JSON format for the source and target MySQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMySqlSettings() {
        return software.amazon.jsii.Kernel.get(this, "mySqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source and target MySQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMySqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mySqlSettings", value);
    }

    /**
     * Settings in JSON format for the source and target MySQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMySqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.MySqlSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "mySqlSettings", value);
    }

    /**
     * Settings in JSON format for the target Amazon Neptune endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNeptuneSettings() {
        return software.amazon.jsii.Kernel.get(this, "neptuneSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target Amazon Neptune endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNeptuneSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "neptuneSettings", value);
    }

    /**
     * Settings in JSON format for the target Amazon Neptune endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNeptuneSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.NeptuneSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "neptuneSettings", value);
    }

    /**
     * Settings in JSON format for the source and target Oracle endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOracleSettings() {
        return software.amazon.jsii.Kernel.get(this, "oracleSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source and target Oracle endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOracleSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "oracleSettings", value);
    }

    /**
     * Settings in JSON format for the source and target Oracle endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOracleSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.OracleSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "oracleSettings", value);
    }

    /**
     * The password to be used to log in to the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The password to be used to log in to the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "password", value);
    }

    /**
     * The port used by the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port used by the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * Settings in JSON format for the source and target PostgreSQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPostgreSqlSettings() {
        return software.amazon.jsii.Kernel.get(this, "postgreSqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source and target PostgreSQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPostgreSqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "postgreSqlSettings", value);
    }

    /**
     * Settings in JSON format for the source and target PostgreSQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPostgreSqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.PostgreSqlSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "postgreSqlSettings", value);
    }

    /**
     * Settings in JSON format for the target Redis endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedisSettings() {
        return software.amazon.jsii.Kernel.get(this, "redisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target Redis endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "redisSettings", value);
    }

    /**
     * Settings in JSON format for the target Redis endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.RedisSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "redisSettings", value);
    }

    /**
     * Settings in JSON format for the Amazon Redshift endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftSettings() {
        return software.amazon.jsii.Kernel.get(this, "redshiftSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the Amazon Redshift endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "redshiftSettings", value);
    }

    /**
     * Settings in JSON format for the Amazon Redshift endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.RedshiftSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "redshiftSettings", value);
    }

    /**
     * A display name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A display name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceIdentifier", value);
    }

    /**
     * Settings in JSON format for the source and target Amazon S3 endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3Settings() {
        return software.amazon.jsii.Kernel.get(this, "s3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source and target Amazon S3 endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3Settings", value);
    }

    /**
     * Settings in JSON format for the source and target Amazon S3 endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.S3SettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "s3Settings", value);
    }

    /**
     * The name of the server where the endpoint database resides.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
        return software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the server where the endpoint database resides.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverName", value);
    }

    /**
     * The Secure Sockets Layer (SSL) mode to use for the SSL connection.
     * <p>
     * The default is <code>none</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSslMode() {
        return software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Secure Sockets Layer (SSL) mode to use for the SSL connection.
     * <p>
     * The default is <code>none</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSslMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sslMode", value);
    }

    /**
     * Settings in JSON format for the source and target SAP ASE endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSybaseSettings() {
        return software.amazon.jsii.Kernel.get(this, "sybaseSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source and target SAP ASE endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSybaseSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sybaseSettings", value);
    }

    /**
     * Settings in JSON format for the source and target SAP ASE endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSybaseSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.SybaseSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "sybaseSettings", value);
    }

    /**
     * One or more tags to be assigned to the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more tags to be assigned to the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The user name to be used to log in to the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
        return software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user name to be used to log in to the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsername(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "username", value);
    }
    /**
     * Provides information that defines a DocumentDB endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html#CHAP_Source.DocumentDB.ECAs">Using extra connections attributes with Amazon DocumentDB as a source</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DocumentDB.html">Using Amazon DocumentDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * DocDbSettingsProperty docDbSettingsProperty = DocDbSettingsProperty.builder()
     *         .docsToInvestigate(123)
     *         .extractDocId(false)
     *         .nestingLevel("nestingLevel")
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.DocDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DocDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates the number of documents to preview to determine the document organization.
         * <p>
         * Use this setting when <code>NestingLevel</code> is set to <code>"one"</code> .
         * <p>
         * Must be a positive value greater than <code>0</code> . Default value is <code>1000</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html#cfn-dms-endpoint-docdbsettings-docstoinvestigate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html#cfn-dms-endpoint-docdbsettings-docstoinvestigate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDocsToInvestigate() {
            return null;
        }

        /**
         * Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to <code>"none"</code> .
         * <p>
         * Default value is <code>"false"</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html#cfn-dms-endpoint-docdbsettings-extractdocid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html#cfn-dms-endpoint-docdbsettings-extractdocid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtractDocId() {
            return null;
        }

        /**
         * Specifies either document or table mode.
         * <p>
         * Default value is <code>"none"</code> . Specify <code>"none"</code> to use document mode. Specify <code>"one"</code> to use table mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html#cfn-dms-endpoint-docdbsettings-nestinglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html#cfn-dms-endpoint-docdbsettings-nestinglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNestingLevel() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the DocumentDB endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html#cfn-dms-endpoint-docdbsettings-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html#cfn-dms-endpoint-docdbsettings-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the DocumentDB endpoint connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html#cfn-dms-endpoint-docdbsettings-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-docdbsettings.html#cfn-dms-endpoint-docdbsettings-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocDbSettingsProperty> {
            java.lang.Number docsToInvestigate;
            java.lang.Object extractDocId;
            java.lang.String nestingLevel;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link DocDbSettingsProperty#getDocsToInvestigate}
             * @param docsToInvestigate Indicates the number of documents to preview to determine the document organization.
             *                          Use this setting when <code>NestingLevel</code> is set to <code>"one"</code> .
             *                          <p>
             *                          Must be a positive value greater than <code>0</code> . Default value is <code>1000</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder docsToInvestigate(java.lang.Number docsToInvestigate) {
                this.docsToInvestigate = docsToInvestigate;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getExtractDocId}
             * @param extractDocId Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to <code>"none"</code> .
             *                     Default value is <code>"false"</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extractDocId(java.lang.Boolean extractDocId) {
                this.extractDocId = extractDocId;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getExtractDocId}
             * @param extractDocId Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to <code>"none"</code> .
             *                     Default value is <code>"false"</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extractDocId(software.amazon.awscdk.IResolvable extractDocId) {
                this.extractDocId = extractDocId;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getNestingLevel}
             * @param nestingLevel Specifies either document or table mode.
             *                     Default value is <code>"none"</code> . Specify <code>"none"</code> to use document mode. Specify <code>"one"</code> to use table mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nestingLevel(java.lang.String nestingLevel) {
                this.nestingLevel = nestingLevel;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
             *                                    The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the DocumentDB endpoint.
             *                                    <p>
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
             *                                    <p>
             *                                    For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the DocumentDB endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocDbSettingsProperty {
            private final java.lang.Number docsToInvestigate;
            private final java.lang.Object extractDocId;
            private final java.lang.String nestingLevel;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.docsToInvestigate = software.amazon.jsii.Kernel.get(this, "docsToInvestigate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.extractDocId = software.amazon.jsii.Kernel.get(this, "extractDocId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nestingLevel = software.amazon.jsii.Kernel.get(this, "nestingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.docsToInvestigate = builder.docsToInvestigate;
                this.extractDocId = builder.extractDocId;
                this.nestingLevel = builder.nestingLevel;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.Number getDocsToInvestigate() {
                return this.docsToInvestigate;
            }

            @Override
            public final java.lang.Object getExtractDocId() {
                return this.extractDocId;
            }

            @Override
            public final java.lang.String getNestingLevel() {
                return this.nestingLevel;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDocsToInvestigate() != null) {
                    data.set("docsToInvestigate", om.valueToTree(this.getDocsToInvestigate()));
                }
                if (this.getExtractDocId() != null) {
                    data.set("extractDocId", om.valueToTree(this.getExtractDocId()));
                }
                if (this.getNestingLevel() != null) {
                    data.set("nestingLevel", om.valueToTree(this.getNestingLevel()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.DocDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocDbSettingsProperty.Jsii$Proxy that = (DocDbSettingsProperty.Jsii$Proxy) o;

                if (this.docsToInvestigate != null ? !this.docsToInvestigate.equals(that.docsToInvestigate) : that.docsToInvestigate != null) return false;
                if (this.extractDocId != null ? !this.extractDocId.equals(that.extractDocId) : that.extractDocId != null) return false;
                if (this.nestingLevel != null ? !this.nestingLevel.equals(that.nestingLevel) : that.nestingLevel != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.docsToInvestigate != null ? this.docsToInvestigate.hashCode() : 0;
                result = 31 * result + (this.extractDocId != null ? this.extractDocId.hashCode() : 0);
                result = 31 * result + (this.nestingLevel != null ? this.nestingLevel.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information, including the Amazon Resource Name (ARN) of the IAM role used to define an Amazon DynamoDB target endpoint.
     * <p>
     * This information also includes the output format of records applied to the endpoint and details of transaction and control table data information. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using object mapping to migrate data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * DynamoDbSettingsProperty dynamoDbSettingsProperty = DynamoDbSettingsProperty.builder()
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-dynamodbsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-dynamodbsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.DynamoDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) used by the service to access the IAM role.
         * <p>
         * The role must allow the <code>iam:PassRole</code> action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-dynamodbsettings.html#cfn-dms-endpoint-dynamodbsettings-serviceaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-dynamodbsettings.html#cfn-dms-endpoint-dynamodbsettings-serviceaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDbSettingsProperty> {
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link DynamoDbSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn The Amazon Resource Name (ARN) used by the service to access the IAM role.
             *                             The role must allow the <code>iam:PassRole</code> action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDbSettingsProperty {
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.DynamoDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDbSettingsProperty.Jsii$Proxy that = (DynamoDbSettingsProperty.Jsii$Proxy) o;

                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Provides information that defines an OpenSearch endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra connection attributes when using OpenSearch as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * ElasticsearchSettingsProperty elasticsearchSettingsProperty = ElasticsearchSettingsProperty.builder()
     *         .endpointUri("endpointUri")
     *         .errorRetryDuration(123)
     *         .fullLoadErrorPercentage(123)
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.ElasticsearchSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint for the OpenSearch cluster.
         * <p>
         * AWS DMS uses HTTPS if a transport protocol (either HTTP or HTTPS) isn't specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-endpointuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-endpointuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointUri() {
            return null;
        }

        /**
         * The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-errorretryduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-errorretryduration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorRetryDuration() {
            return null;
        }

        /**
         * The maximum percentage of records that can fail to be written before a full load operation stops.
         * <p>
         * To avoid early failure, this counter is only effective after 1,000 records are transferred. OpenSearch also has the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all records fail in the last 10 minutes, the full load operation stops.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-fullloaderrorpercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-fullloaderrorpercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFullLoadErrorPercentage() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) used by the service to access the IAM role.
         * <p>
         * The role must allow the <code>iam:PassRole</code> action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-serviceaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-serviceaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchSettingsProperty> {
            java.lang.String endpointUri;
            java.lang.Number errorRetryDuration;
            java.lang.Number fullLoadErrorPercentage;
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getEndpointUri}
             * @param endpointUri The endpoint for the OpenSearch cluster.
             *                    AWS DMS uses HTTPS if a transport protocol (either HTTP or HTTPS) isn't specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointUri(java.lang.String endpointUri) {
                this.endpointUri = endpointUri;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getErrorRetryDuration}
             * @param errorRetryDuration The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorRetryDuration(java.lang.Number errorRetryDuration) {
                this.errorRetryDuration = errorRetryDuration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getFullLoadErrorPercentage}
             * @param fullLoadErrorPercentage The maximum percentage of records that can fail to be written before a full load operation stops.
             *                                To avoid early failure, this counter is only effective after 1,000 records are transferred. OpenSearch also has the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all records fail in the last 10 minutes, the full load operation stops.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullLoadErrorPercentage(java.lang.Number fullLoadErrorPercentage) {
                this.fullLoadErrorPercentage = fullLoadErrorPercentage;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn The Amazon Resource Name (ARN) used by the service to access the IAM role.
             *                             The role must allow the <code>iam:PassRole</code> action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchSettingsProperty {
            private final java.lang.String endpointUri;
            private final java.lang.Number errorRetryDuration;
            private final java.lang.Number fullLoadErrorPercentage;
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointUri = software.amazon.jsii.Kernel.get(this, "endpointUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorRetryDuration = software.amazon.jsii.Kernel.get(this, "errorRetryDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fullLoadErrorPercentage = software.amazon.jsii.Kernel.get(this, "fullLoadErrorPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointUri = builder.endpointUri;
                this.errorRetryDuration = builder.errorRetryDuration;
                this.fullLoadErrorPercentage = builder.fullLoadErrorPercentage;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getEndpointUri() {
                return this.endpointUri;
            }

            @Override
            public final java.lang.Number getErrorRetryDuration() {
                return this.errorRetryDuration;
            }

            @Override
            public final java.lang.Number getFullLoadErrorPercentage() {
                return this.fullLoadErrorPercentage;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEndpointUri() != null) {
                    data.set("endpointUri", om.valueToTree(this.getEndpointUri()));
                }
                if (this.getErrorRetryDuration() != null) {
                    data.set("errorRetryDuration", om.valueToTree(this.getErrorRetryDuration()));
                }
                if (this.getFullLoadErrorPercentage() != null) {
                    data.set("fullLoadErrorPercentage", om.valueToTree(this.getFullLoadErrorPercentage()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.ElasticsearchSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchSettingsProperty.Jsii$Proxy that = (ElasticsearchSettingsProperty.Jsii$Proxy) o;

                if (this.endpointUri != null ? !this.endpointUri.equals(that.endpointUri) : that.endpointUri != null) return false;
                if (this.errorRetryDuration != null ? !this.errorRetryDuration.equals(that.errorRetryDuration) : that.errorRetryDuration != null) return false;
                if (this.fullLoadErrorPercentage != null ? !this.fullLoadErrorPercentage.equals(that.fullLoadErrorPercentage) : that.fullLoadErrorPercentage != null) return false;
                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpointUri != null ? this.endpointUri.hashCode() : 0;
                result = 31 * result + (this.errorRetryDuration != null ? this.errorRetryDuration.hashCode() : 0);
                result = 31 * result + (this.fullLoadErrorPercentage != null ? this.fullLoadErrorPercentage.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a GCP MySQL endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. These settings are much the same as the settings for any MySQL-compatible endpoint. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * GcpMySQLSettingsProperty gcpMySQLSettingsProperty = GcpMySQLSettingsProperty.builder()
     *         .afterConnectScript("afterConnectScript")
     *         .cleanSourceMetadataOnMismatch(false)
     *         .databaseName("databaseName")
     *         .eventsPollInterval(123)
     *         .maxFileSize(123)
     *         .parallelLoadThreads(123)
     *         .password("password")
     *         .port(123)
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .serverName("serverName")
     *         .serverTimezone("serverTimezone")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.GcpMySQLSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(GcpMySQLSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GcpMySQLSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a script to run immediately after AWS DMS connects to the endpoint.
         * <p>
         * The migration task continues running regardless if the SQL statement succeeds or fails.
         * <p>
         * For this parameter, provide the code of the script itself, not the name of a file containing the script.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-afterconnectscript">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-afterconnectscript</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAfterConnectScript() {
            return null;
        }

        /**
         * Adjusts the behavior of AWS DMS when migrating from an SQL Server source database that is hosted as part of an Always On availability group cluster.
         * <p>
         * If you need AWS DMS to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-cleansourcemetadataonmismatch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-cleansourcemetadataonmismatch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCleanSourceMetadataOnMismatch() {
            return null;
        }

        /**
         * Database name for the endpoint.
         * <p>
         * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code> request parameter on either the <code>CreateEndpoint</code> or <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create or modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the AWS DMS task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * Specifies how often to check the binary log for new changes/events when the database is idle.
         * <p>
         * The default is five seconds.
         * <p>
         * Example: <code>eventsPollInterval=5;</code>
         * <p>
         * In the example, AWS DMS checks for changes in the binary logs every five seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-eventspollinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-eventspollinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEventsPollInterval() {
            return null;
        }

        /**
         * Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.
         * <p>
         * Example: <code>maxFileSize=512</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-maxfilesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-maxfilesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFileSize() {
            return null;
        }

        /**
         * Improves performance when loading data into the MySQL-compatible target database.
         * <p>
         * Specifies how many threads to use to load the data into the MySQL-compatible target database. Setting a large number of threads can have an adverse effect on database performance, because a separate connection is required for each thread. The default is one.
         * <p>
         * Example: <code>parallelLoadThreads=1</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-parallelloadthreads">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-parallelloadthreads</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParallelLoadThreads() {
            return null;
        }

        /**
         * Endpoint connection password.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The port used by the endpoint database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret.</code> The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the MySQL endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the MySQL endpoint connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * The MySQL host name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
            return null;
        }

        /**
         * Specifies the time zone for the source MySQL database. Don't enclose time zones in single quotation marks.
         * <p>
         * Example: <code>serverTimezone=US/Pacific;</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-servertimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-servertimezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerTimezone() {
            return null;
        }

        /**
         * Endpoint connection user name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-gcpmysqlsettings.html#cfn-dms-endpoint-gcpmysqlsettings-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GcpMySQLSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GcpMySQLSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GcpMySQLSettingsProperty> {
            java.lang.String afterConnectScript;
            java.lang.Object cleanSourceMetadataOnMismatch;
            java.lang.String databaseName;
            java.lang.Number eventsPollInterval;
            java.lang.Number maxFileSize;
            java.lang.Number parallelLoadThreads;
            java.lang.String password;
            java.lang.Number port;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;
            java.lang.String serverName;
            java.lang.String serverTimezone;
            java.lang.String username;

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getAfterConnectScript}
             * @param afterConnectScript Specifies a script to run immediately after AWS DMS connects to the endpoint.
             *                           The migration task continues running regardless if the SQL statement succeeds or fails.
             *                           <p>
             *                           For this parameter, provide the code of the script itself, not the name of a file containing the script.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder afterConnectScript(java.lang.String afterConnectScript) {
                this.afterConnectScript = afterConnectScript;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getCleanSourceMetadataOnMismatch}
             * @param cleanSourceMetadataOnMismatch Adjusts the behavior of AWS DMS when migrating from an SQL Server source database that is hosted as part of an Always On availability group cluster.
             *                                      If you need AWS DMS to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cleanSourceMetadataOnMismatch(java.lang.Boolean cleanSourceMetadataOnMismatch) {
                this.cleanSourceMetadataOnMismatch = cleanSourceMetadataOnMismatch;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getCleanSourceMetadataOnMismatch}
             * @param cleanSourceMetadataOnMismatch Adjusts the behavior of AWS DMS when migrating from an SQL Server source database that is hosted as part of an Always On availability group cluster.
             *                                      If you need AWS DMS to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cleanSourceMetadataOnMismatch(software.amazon.awscdk.IResolvable cleanSourceMetadataOnMismatch) {
                this.cleanSourceMetadataOnMismatch = cleanSourceMetadataOnMismatch;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getDatabaseName}
             * @param databaseName Database name for the endpoint.
             *                     For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code> request parameter on either the <code>CreateEndpoint</code> or <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create or modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the AWS DMS task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getEventsPollInterval}
             * @param eventsPollInterval Specifies how often to check the binary log for new changes/events when the database is idle.
             *                           The default is five seconds.
             *                           <p>
             *                           Example: <code>eventsPollInterval=5;</code>
             *                           <p>
             *                           In the example, AWS DMS checks for changes in the binary logs every five seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventsPollInterval(java.lang.Number eventsPollInterval) {
                this.eventsPollInterval = eventsPollInterval;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getMaxFileSize}
             * @param maxFileSize Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.
             *                    Example: <code>maxFileSize=512</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFileSize(java.lang.Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getParallelLoadThreads}
             * @param parallelLoadThreads Improves performance when loading data into the MySQL-compatible target database.
             *                            Specifies how many threads to use to load the data into the MySQL-compatible target database. Setting a large number of threads can have an adverse effect on database performance, because a separate connection is required for each thread. The default is one.
             *                            <p>
             *                            Example: <code>parallelLoadThreads=1</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelLoadThreads(java.lang.Number parallelLoadThreads) {
                this.parallelLoadThreads = parallelLoadThreads;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getPassword}
             * @param password Endpoint connection password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getPort}
             * @param port The port used by the endpoint database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret.</code> The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the MySQL endpoint.
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
             *                                    <p>
             *                                    For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the MySQL endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getServerName}
             * @param serverName The MySQL host name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getServerTimezone}
             * @param serverTimezone Specifies the time zone for the source MySQL database. Don't enclose time zones in single quotation marks.
             *                       Example: <code>serverTimezone=US/Pacific;</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverTimezone(java.lang.String serverTimezone) {
                this.serverTimezone = serverTimezone;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getUsername}
             * @param username Endpoint connection user name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GcpMySQLSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GcpMySQLSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GcpMySQLSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GcpMySQLSettingsProperty {
            private final java.lang.String afterConnectScript;
            private final java.lang.Object cleanSourceMetadataOnMismatch;
            private final java.lang.String databaseName;
            private final java.lang.Number eventsPollInterval;
            private final java.lang.Number maxFileSize;
            private final java.lang.Number parallelLoadThreads;
            private final java.lang.String password;
            private final java.lang.Number port;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.String serverName;
            private final java.lang.String serverTimezone;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.afterConnectScript = software.amazon.jsii.Kernel.get(this, "afterConnectScript", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cleanSourceMetadataOnMismatch = software.amazon.jsii.Kernel.get(this, "cleanSourceMetadataOnMismatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventsPollInterval = software.amazon.jsii.Kernel.get(this, "eventsPollInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxFileSize = software.amazon.jsii.Kernel.get(this, "maxFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.parallelLoadThreads = software.amazon.jsii.Kernel.get(this, "parallelLoadThreads", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverTimezone = software.amazon.jsii.Kernel.get(this, "serverTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.afterConnectScript = builder.afterConnectScript;
                this.cleanSourceMetadataOnMismatch = builder.cleanSourceMetadataOnMismatch;
                this.databaseName = builder.databaseName;
                this.eventsPollInterval = builder.eventsPollInterval;
                this.maxFileSize = builder.maxFileSize;
                this.parallelLoadThreads = builder.parallelLoadThreads;
                this.password = builder.password;
                this.port = builder.port;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.serverName = builder.serverName;
                this.serverTimezone = builder.serverTimezone;
                this.username = builder.username;
            }

            @Override
            public final java.lang.String getAfterConnectScript() {
                return this.afterConnectScript;
            }

            @Override
            public final java.lang.Object getCleanSourceMetadataOnMismatch() {
                return this.cleanSourceMetadataOnMismatch;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Number getEventsPollInterval() {
                return this.eventsPollInterval;
            }

            @Override
            public final java.lang.Number getMaxFileSize() {
                return this.maxFileSize;
            }

            @Override
            public final java.lang.Number getParallelLoadThreads() {
                return this.parallelLoadThreads;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getServerTimezone() {
                return this.serverTimezone;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAfterConnectScript() != null) {
                    data.set("afterConnectScript", om.valueToTree(this.getAfterConnectScript()));
                }
                if (this.getCleanSourceMetadataOnMismatch() != null) {
                    data.set("cleanSourceMetadataOnMismatch", om.valueToTree(this.getCleanSourceMetadataOnMismatch()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getEventsPollInterval() != null) {
                    data.set("eventsPollInterval", om.valueToTree(this.getEventsPollInterval()));
                }
                if (this.getMaxFileSize() != null) {
                    data.set("maxFileSize", om.valueToTree(this.getMaxFileSize()));
                }
                if (this.getParallelLoadThreads() != null) {
                    data.set("parallelLoadThreads", om.valueToTree(this.getParallelLoadThreads()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getServerName() != null) {
                    data.set("serverName", om.valueToTree(this.getServerName()));
                }
                if (this.getServerTimezone() != null) {
                    data.set("serverTimezone", om.valueToTree(this.getServerTimezone()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.GcpMySQLSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GcpMySQLSettingsProperty.Jsii$Proxy that = (GcpMySQLSettingsProperty.Jsii$Proxy) o;

                if (this.afterConnectScript != null ? !this.afterConnectScript.equals(that.afterConnectScript) : that.afterConnectScript != null) return false;
                if (this.cleanSourceMetadataOnMismatch != null ? !this.cleanSourceMetadataOnMismatch.equals(that.cleanSourceMetadataOnMismatch) : that.cleanSourceMetadataOnMismatch != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.eventsPollInterval != null ? !this.eventsPollInterval.equals(that.eventsPollInterval) : that.eventsPollInterval != null) return false;
                if (this.maxFileSize != null ? !this.maxFileSize.equals(that.maxFileSize) : that.maxFileSize != null) return false;
                if (this.parallelLoadThreads != null ? !this.parallelLoadThreads.equals(that.parallelLoadThreads) : that.parallelLoadThreads != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
                if (this.serverTimezone != null ? !this.serverTimezone.equals(that.serverTimezone) : that.serverTimezone != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.afterConnectScript != null ? this.afterConnectScript.hashCode() : 0;
                result = 31 * result + (this.cleanSourceMetadataOnMismatch != null ? this.cleanSourceMetadataOnMismatch.hashCode() : 0);
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.eventsPollInterval != null ? this.eventsPollInterval.hashCode() : 0);
                result = 31 * result + (this.maxFileSize != null ? this.maxFileSize.hashCode() : 0);
                result = 31 * result + (this.parallelLoadThreads != null ? this.parallelLoadThreads.hashCode() : 0);
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
                result = 31 * result + (this.serverTimezone != null ? this.serverTimezone.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines an IBMDB2 endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * IbmDb2SettingsProperty ibmDb2SettingsProperty = IbmDb2SettingsProperty.builder()
     *         .currentLsn("currentLsn")
     *         .keepCsvFiles(false)
     *         .loadTimeout(123)
     *         .maxFileSize(123)
     *         .maxKBytesPerRead(123)
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .setDataCaptureChanges(false)
     *         .writeBufferSize(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.IbmDb2SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(IbmDb2SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IbmDb2SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For ongoing replication (CDC), use CurrentLSN to specify a log sequence number (LSN) where you want the replication to start.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-currentlsn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-currentlsn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCurrentLsn() {
            return null;
        }

        /**
         * If true, AWS DMS saves any .csv files to the Db2 LUW target that were used to replicate data. DMS uses these files for analysis and troubleshooting.
         * <p>
         * The default value is false.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-keepcsvfiles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-keepcsvfiles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeepCsvFiles() {
            return null;
        }

        /**
         * The amount of time (in milliseconds) before AWS DMS times out operations performed by DMS on the Db2 target.
         * <p>
         * The default value is 1200 (20 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-loadtimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-loadtimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoadTimeout() {
            return null;
        }

        /**
         * Specifies the maximum size (in KB) of .csv files used to transfer data to Db2 LUW.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-maxfilesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-maxfilesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFileSize() {
            return null;
        }

        /**
         * Maximum number of bytes per read, as a NUMBER value.
         * <p>
         * The default is 64 KB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-maxkbytesperread">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-maxkbytesperread</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxKBytesPerRead() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value ofthe AWS Secrets Manager secret that allows access to the Db2 LUW endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the IBMDB2 endpoint connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * Enables ongoing replication (CDC) as a BOOLEAN value.
         * <p>
         * The default is true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-setdatacapturechanges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-setdatacapturechanges</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSetDataCaptureChanges() {
            return null;
        }

        /**
         * The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk on the DMS replication instance. The default value is 1024 (1 MB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-writebuffersize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-ibmdb2settings.html#cfn-dms-endpoint-ibmdb2settings-writebuffersize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWriteBufferSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IbmDb2SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IbmDb2SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IbmDb2SettingsProperty> {
            java.lang.String currentLsn;
            java.lang.Object keepCsvFiles;
            java.lang.Number loadTimeout;
            java.lang.Number maxFileSize;
            java.lang.Number maxKBytesPerRead;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;
            java.lang.Object setDataCaptureChanges;
            java.lang.Number writeBufferSize;

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getCurrentLsn}
             * @param currentLsn For ongoing replication (CDC), use CurrentLSN to specify a log sequence number (LSN) where you want the replication to start.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currentLsn(java.lang.String currentLsn) {
                this.currentLsn = currentLsn;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getKeepCsvFiles}
             * @param keepCsvFiles If true, AWS DMS saves any .csv files to the Db2 LUW target that were used to replicate data. DMS uses these files for analysis and troubleshooting.
             *                     The default value is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keepCsvFiles(java.lang.Boolean keepCsvFiles) {
                this.keepCsvFiles = keepCsvFiles;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getKeepCsvFiles}
             * @param keepCsvFiles If true, AWS DMS saves any .csv files to the Db2 LUW target that were used to replicate data. DMS uses these files for analysis and troubleshooting.
             *                     The default value is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keepCsvFiles(software.amazon.awscdk.IResolvable keepCsvFiles) {
                this.keepCsvFiles = keepCsvFiles;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getLoadTimeout}
             * @param loadTimeout The amount of time (in milliseconds) before AWS DMS times out operations performed by DMS on the Db2 target.
             *                    The default value is 1200 (20 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadTimeout(java.lang.Number loadTimeout) {
                this.loadTimeout = loadTimeout;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getMaxFileSize}
             * @param maxFileSize Specifies the maximum size (in KB) of .csv files used to transfer data to Db2 LUW.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFileSize(java.lang.Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getMaxKBytesPerRead}
             * @param maxKBytesPerRead Maximum number of bytes per read, as a NUMBER value.
             *                         The default is 64 KB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxKBytesPerRead(java.lang.Number maxKBytesPerRead) {
                this.maxKBytesPerRead = maxKBytesPerRead;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
             *                                    The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value ofthe AWS Secrets Manager secret that allows access to the Db2 LUW endpoint.
             *                                    <p>
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
             *                                    <p>
             *                                    For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the IBMDB2 endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getSetDataCaptureChanges}
             * @param setDataCaptureChanges Enables ongoing replication (CDC) as a BOOLEAN value.
             *                              The default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setDataCaptureChanges(java.lang.Boolean setDataCaptureChanges) {
                this.setDataCaptureChanges = setDataCaptureChanges;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getSetDataCaptureChanges}
             * @param setDataCaptureChanges Enables ongoing replication (CDC) as a BOOLEAN value.
             *                              The default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setDataCaptureChanges(software.amazon.awscdk.IResolvable setDataCaptureChanges) {
                this.setDataCaptureChanges = setDataCaptureChanges;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getWriteBufferSize}
             * @param writeBufferSize The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk on the DMS replication instance. The default value is 1024 (1 MB).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeBufferSize(java.lang.Number writeBufferSize) {
                this.writeBufferSize = writeBufferSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IbmDb2SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IbmDb2SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IbmDb2SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IbmDb2SettingsProperty {
            private final java.lang.String currentLsn;
            private final java.lang.Object keepCsvFiles;
            private final java.lang.Number loadTimeout;
            private final java.lang.Number maxFileSize;
            private final java.lang.Number maxKBytesPerRead;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.Object setDataCaptureChanges;
            private final java.lang.Number writeBufferSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.currentLsn = software.amazon.jsii.Kernel.get(this, "currentLsn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keepCsvFiles = software.amazon.jsii.Kernel.get(this, "keepCsvFiles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loadTimeout = software.amazon.jsii.Kernel.get(this, "loadTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxFileSize = software.amazon.jsii.Kernel.get(this, "maxFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxKBytesPerRead = software.amazon.jsii.Kernel.get(this, "maxKBytesPerRead", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.setDataCaptureChanges = software.amazon.jsii.Kernel.get(this, "setDataCaptureChanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.writeBufferSize = software.amazon.jsii.Kernel.get(this, "writeBufferSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.currentLsn = builder.currentLsn;
                this.keepCsvFiles = builder.keepCsvFiles;
                this.loadTimeout = builder.loadTimeout;
                this.maxFileSize = builder.maxFileSize;
                this.maxKBytesPerRead = builder.maxKBytesPerRead;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.setDataCaptureChanges = builder.setDataCaptureChanges;
                this.writeBufferSize = builder.writeBufferSize;
            }

            @Override
            public final java.lang.String getCurrentLsn() {
                return this.currentLsn;
            }

            @Override
            public final java.lang.Object getKeepCsvFiles() {
                return this.keepCsvFiles;
            }

            @Override
            public final java.lang.Number getLoadTimeout() {
                return this.loadTimeout;
            }

            @Override
            public final java.lang.Number getMaxFileSize() {
                return this.maxFileSize;
            }

            @Override
            public final java.lang.Number getMaxKBytesPerRead() {
                return this.maxKBytesPerRead;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.Object getSetDataCaptureChanges() {
                return this.setDataCaptureChanges;
            }

            @Override
            public final java.lang.Number getWriteBufferSize() {
                return this.writeBufferSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCurrentLsn() != null) {
                    data.set("currentLsn", om.valueToTree(this.getCurrentLsn()));
                }
                if (this.getKeepCsvFiles() != null) {
                    data.set("keepCsvFiles", om.valueToTree(this.getKeepCsvFiles()));
                }
                if (this.getLoadTimeout() != null) {
                    data.set("loadTimeout", om.valueToTree(this.getLoadTimeout()));
                }
                if (this.getMaxFileSize() != null) {
                    data.set("maxFileSize", om.valueToTree(this.getMaxFileSize()));
                }
                if (this.getMaxKBytesPerRead() != null) {
                    data.set("maxKBytesPerRead", om.valueToTree(this.getMaxKBytesPerRead()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getSetDataCaptureChanges() != null) {
                    data.set("setDataCaptureChanges", om.valueToTree(this.getSetDataCaptureChanges()));
                }
                if (this.getWriteBufferSize() != null) {
                    data.set("writeBufferSize", om.valueToTree(this.getWriteBufferSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.IbmDb2SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IbmDb2SettingsProperty.Jsii$Proxy that = (IbmDb2SettingsProperty.Jsii$Proxy) o;

                if (this.currentLsn != null ? !this.currentLsn.equals(that.currentLsn) : that.currentLsn != null) return false;
                if (this.keepCsvFiles != null ? !this.keepCsvFiles.equals(that.keepCsvFiles) : that.keepCsvFiles != null) return false;
                if (this.loadTimeout != null ? !this.loadTimeout.equals(that.loadTimeout) : that.loadTimeout != null) return false;
                if (this.maxFileSize != null ? !this.maxFileSize.equals(that.maxFileSize) : that.maxFileSize != null) return false;
                if (this.maxKBytesPerRead != null ? !this.maxKBytesPerRead.equals(that.maxKBytesPerRead) : that.maxKBytesPerRead != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                if (this.setDataCaptureChanges != null ? !this.setDataCaptureChanges.equals(that.setDataCaptureChanges) : that.setDataCaptureChanges != null) return false;
                return this.writeBufferSize != null ? this.writeBufferSize.equals(that.writeBufferSize) : that.writeBufferSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.currentLsn != null ? this.currentLsn.hashCode() : 0;
                result = 31 * result + (this.keepCsvFiles != null ? this.keepCsvFiles.hashCode() : 0);
                result = 31 * result + (this.loadTimeout != null ? this.loadTimeout.hashCode() : 0);
                result = 31 * result + (this.maxFileSize != null ? this.maxFileSize.hashCode() : 0);
                result = 31 * result + (this.maxKBytesPerRead != null ? this.maxKBytesPerRead.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.setDataCaptureChanges != null ? this.setDataCaptureChanges.hashCode() : 0);
                result = 31 * result + (this.writeBufferSize != null ? this.writeBufferSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that describes an Apache Kafka endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * KafkaSettingsProperty kafkaSettingsProperty = KafkaSettingsProperty.builder()
     *         .broker("broker")
     *         .includeControlDetails(false)
     *         .includeNullAndEmpty(false)
     *         .includePartitionValue(false)
     *         .includeTableAlterOperations(false)
     *         .includeTransactionDetails(false)
     *         .messageFormat("messageFormat")
     *         .messageMaxBytes(123)
     *         .noHexPrefix(false)
     *         .partitionIncludeSchemaTable(false)
     *         .saslPassword("saslPassword")
     *         .saslUserName("saslUserName")
     *         .securityProtocol("securityProtocol")
     *         .sslCaCertificateArn("sslCaCertificateArn")
     *         .sslClientCertificateArn("sslClientCertificateArn")
     *         .sslClientKeyArn("sslClientKeyArn")
     *         .sslClientKeyPassword("sslClientKeyPassword")
     *         .topic("topic")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.KafkaSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(KafkaSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KafkaSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A comma-separated list of one or more broker locations in your Kafka cluster that host your Kafka instance.
         * <p>
         * Specify each broker location in the form <code>*broker-hostname-or-ip* : *port*</code> . For example, <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code> . For more information and examples of specifying a list of broker locations, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using Apache Kafka as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-broker">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-broker</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBroker() {
            return null;
        }

        /**
         * Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-includecontroldetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-includecontroldetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeControlDetails() {
            return null;
        }

        /**
         * Include NULL and empty columns for records migrated to the endpoint.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-includenullandempty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-includenullandempty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeNullAndEmpty() {
            return null;
        }

        /**
         * Shows the partition value within the Kafka message output unless the partition type is <code>schema-table-type</code> .
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-includepartitionvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-includepartitionvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludePartitionValue() {
            return null;
        }

        /**
         * Includes any data definition language (DDL) operations that change the table in the control data, such as <code>rename-table</code> , <code>drop-table</code> , <code>add-column</code> , <code>drop-column</code> , and <code>rename-column</code> .
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-includetablealteroperations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-includetablealteroperations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTableAlterOperations() {
            return null;
        }

        /**
         * Provides detailed transaction information from the source database.
         * <p>
         * This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-includetransactiondetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-includetransactiondetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTransactionDetails() {
            return null;
        }

        /**
         * The output format for the records created on the endpoint.
         * <p>
         * The message format is <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-messageformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-messageformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageFormat() {
            return null;
        }

        /**
         * The maximum size in bytes for records created on the endpoint The default is 1,000,000.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-messagemaxbytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-messagemaxbytes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMessageMaxBytes() {
            return null;
        }

        /**
         * Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix to raw data in hexadecimal format.
         * <p>
         * For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-nohexprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-nohexprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoHexPrefix() {
            return null;
        }

        /**
         * Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code> .
         * <p>
         * Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-partitionincludeschematable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-partitionincludeschematable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPartitionIncludeSchemaTable() {
            return null;
        }

        /**
         * The secure password that you created when you first set up your Amazon MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-saslpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-saslpassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSaslPassword() {
            return null;
        }

        /**
         * The secure user name you created when you first set up your Amazon MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-saslusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-saslusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSaslUserName() {
            return null;
        }

        /**
         * Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS).
         * <p>
         * Options include <code>ssl-encryption</code> , <code>ssl-authentication</code> , and <code>sasl-ssl</code> . <code>sasl-ssl</code> requires <code>SaslUsername</code> and <code>SaslPassword</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-securityprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-securityprotocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityProtocol() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-sslcacertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-sslcacertificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslCaCertificateArn() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-sslclientcertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-sslclientcertificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslClientCertificateArn() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-sslclientkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-sslclientkeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslClientKeyArn() {
            return null;
        }

        /**
         * The password for the client private key used to securely connect to a Kafka target endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-sslclientkeypassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-sslclientkeypassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslClientKeyPassword() {
            return null;
        }

        /**
         * The topic to which you migrate the data.
         * <p>
         * If you don't specify a topic, AWS DMS specifies <code>"kafka-default-topic"</code> as the migration topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-topic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-topic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KafkaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KafkaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KafkaSettingsProperty> {
            java.lang.String broker;
            java.lang.Object includeControlDetails;
            java.lang.Object includeNullAndEmpty;
            java.lang.Object includePartitionValue;
            java.lang.Object includeTableAlterOperations;
            java.lang.Object includeTransactionDetails;
            java.lang.String messageFormat;
            java.lang.Number messageMaxBytes;
            java.lang.Object noHexPrefix;
            java.lang.Object partitionIncludeSchemaTable;
            java.lang.String saslPassword;
            java.lang.String saslUserName;
            java.lang.String securityProtocol;
            java.lang.String sslCaCertificateArn;
            java.lang.String sslClientCertificateArn;
            java.lang.String sslClientKeyArn;
            java.lang.String sslClientKeyPassword;
            java.lang.String topic;

            /**
             * Sets the value of {@link KafkaSettingsProperty#getBroker}
             * @param broker A comma-separated list of one or more broker locations in your Kafka cluster that host your Kafka instance.
             *               Specify each broker location in the form <code>*broker-hostname-or-ip* : *port*</code> . For example, <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code> . For more information and examples of specifying a list of broker locations, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using Apache Kafka as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder broker(java.lang.String broker) {
                this.broker = broker;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output.
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(java.lang.Boolean includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output.
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(software.amazon.awscdk.IResolvable includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty Include NULL and empty columns for records migrated to the endpoint.
             *                            The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(java.lang.Boolean includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty Include NULL and empty columns for records migrated to the endpoint.
             *                            The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(software.amazon.awscdk.IResolvable includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludePartitionValue}
             * @param includePartitionValue Shows the partition value within the Kafka message output unless the partition type is <code>schema-table-type</code> .
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includePartitionValue(java.lang.Boolean includePartitionValue) {
                this.includePartitionValue = includePartitionValue;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludePartitionValue}
             * @param includePartitionValue Shows the partition value within the Kafka message output unless the partition type is <code>schema-table-type</code> .
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includePartitionValue(software.amazon.awscdk.IResolvable includePartitionValue) {
                this.includePartitionValue = includePartitionValue;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data, such as <code>rename-table</code> , <code>drop-table</code> , <code>add-column</code> , <code>drop-column</code> , and <code>rename-column</code> .
             *                                    The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(java.lang.Boolean includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data, such as <code>rename-table</code> , <code>drop-table</code> , <code>add-column</code> , <code>drop-column</code> , and <code>rename-column</code> .
             *                                    The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(software.amazon.awscdk.IResolvable includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails Provides detailed transaction information from the source database.
             *                                  This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(java.lang.Boolean includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails Provides detailed transaction information from the source database.
             *                                  This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(software.amazon.awscdk.IResolvable includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getMessageFormat}
             * @param messageFormat The output format for the records created on the endpoint.
             *                      The message format is <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageFormat(java.lang.String messageFormat) {
                this.messageFormat = messageFormat;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getMessageMaxBytes}
             * @param messageMaxBytes The maximum size in bytes for records created on the endpoint The default is 1,000,000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageMaxBytes(java.lang.Number messageMaxBytes) {
                this.messageMaxBytes = messageMaxBytes;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix to raw data in hexadecimal format.
             *                    For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(java.lang.Boolean noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix to raw data in hexadecimal format.
             *                    For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(software.amazon.awscdk.IResolvable noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code> .
             *                                    Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(java.lang.Boolean partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code> .
             *                                    Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(software.amazon.awscdk.IResolvable partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSaslPassword}
             * @param saslPassword The secure password that you created when you first set up your Amazon MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saslPassword(java.lang.String saslPassword) {
                this.saslPassword = saslPassword;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSaslUserName}
             * @param saslUserName The secure user name you created when you first set up your Amazon MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saslUserName(java.lang.String saslUserName) {
                this.saslUserName = saslUserName;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSecurityProtocol}
             * @param securityProtocol Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS).
             *                         Options include <code>ssl-encryption</code> , <code>ssl-authentication</code> , and <code>sasl-ssl</code> . <code>sasl-ssl</code> requires <code>SaslUsername</code> and <code>SaslPassword</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityProtocol(java.lang.String securityProtocol) {
                this.securityProtocol = securityProtocol;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslCaCertificateArn}
             * @param sslCaCertificateArn The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslCaCertificateArn(java.lang.String sslCaCertificateArn) {
                this.sslCaCertificateArn = sslCaCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslClientCertificateArn}
             * @param sslClientCertificateArn The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslClientCertificateArn(java.lang.String sslClientCertificateArn) {
                this.sslClientCertificateArn = sslClientCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslClientKeyArn}
             * @param sslClientKeyArn The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslClientKeyArn(java.lang.String sslClientKeyArn) {
                this.sslClientKeyArn = sslClientKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslClientKeyPassword}
             * @param sslClientKeyPassword The password for the client private key used to securely connect to a Kafka target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslClientKeyPassword(java.lang.String sslClientKeyPassword) {
                this.sslClientKeyPassword = sslClientKeyPassword;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getTopic}
             * @param topic The topic to which you migrate the data.
             *              If you don't specify a topic, AWS DMS specifies <code>"kafka-default-topic"</code> as the migration topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KafkaSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KafkaSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KafkaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaSettingsProperty {
            private final java.lang.String broker;
            private final java.lang.Object includeControlDetails;
            private final java.lang.Object includeNullAndEmpty;
            private final java.lang.Object includePartitionValue;
            private final java.lang.Object includeTableAlterOperations;
            private final java.lang.Object includeTransactionDetails;
            private final java.lang.String messageFormat;
            private final java.lang.Number messageMaxBytes;
            private final java.lang.Object noHexPrefix;
            private final java.lang.Object partitionIncludeSchemaTable;
            private final java.lang.String saslPassword;
            private final java.lang.String saslUserName;
            private final java.lang.String securityProtocol;
            private final java.lang.String sslCaCertificateArn;
            private final java.lang.String sslClientCertificateArn;
            private final java.lang.String sslClientKeyArn;
            private final java.lang.String sslClientKeyPassword;
            private final java.lang.String topic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.broker = software.amazon.jsii.Kernel.get(this, "broker", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeControlDetails = software.amazon.jsii.Kernel.get(this, "includeControlDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeNullAndEmpty = software.amazon.jsii.Kernel.get(this, "includeNullAndEmpty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includePartitionValue = software.amazon.jsii.Kernel.get(this, "includePartitionValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTableAlterOperations = software.amazon.jsii.Kernel.get(this, "includeTableAlterOperations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTransactionDetails = software.amazon.jsii.Kernel.get(this, "includeTransactionDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.messageFormat = software.amazon.jsii.Kernel.get(this, "messageFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageMaxBytes = software.amazon.jsii.Kernel.get(this, "messageMaxBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.noHexPrefix = software.amazon.jsii.Kernel.get(this, "noHexPrefix", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.partitionIncludeSchemaTable = software.amazon.jsii.Kernel.get(this, "partitionIncludeSchemaTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.saslPassword = software.amazon.jsii.Kernel.get(this, "saslPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.saslUserName = software.amazon.jsii.Kernel.get(this, "saslUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityProtocol = software.amazon.jsii.Kernel.get(this, "securityProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslCaCertificateArn = software.amazon.jsii.Kernel.get(this, "sslCaCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslClientCertificateArn = software.amazon.jsii.Kernel.get(this, "sslClientCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslClientKeyArn = software.amazon.jsii.Kernel.get(this, "sslClientKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslClientKeyPassword = software.amazon.jsii.Kernel.get(this, "sslClientKeyPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.broker = builder.broker;
                this.includeControlDetails = builder.includeControlDetails;
                this.includeNullAndEmpty = builder.includeNullAndEmpty;
                this.includePartitionValue = builder.includePartitionValue;
                this.includeTableAlterOperations = builder.includeTableAlterOperations;
                this.includeTransactionDetails = builder.includeTransactionDetails;
                this.messageFormat = builder.messageFormat;
                this.messageMaxBytes = builder.messageMaxBytes;
                this.noHexPrefix = builder.noHexPrefix;
                this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
                this.saslPassword = builder.saslPassword;
                this.saslUserName = builder.saslUserName;
                this.securityProtocol = builder.securityProtocol;
                this.sslCaCertificateArn = builder.sslCaCertificateArn;
                this.sslClientCertificateArn = builder.sslClientCertificateArn;
                this.sslClientKeyArn = builder.sslClientKeyArn;
                this.sslClientKeyPassword = builder.sslClientKeyPassword;
                this.topic = builder.topic;
            }

            @Override
            public final java.lang.String getBroker() {
                return this.broker;
            }

            @Override
            public final java.lang.Object getIncludeControlDetails() {
                return this.includeControlDetails;
            }

            @Override
            public final java.lang.Object getIncludeNullAndEmpty() {
                return this.includeNullAndEmpty;
            }

            @Override
            public final java.lang.Object getIncludePartitionValue() {
                return this.includePartitionValue;
            }

            @Override
            public final java.lang.Object getIncludeTableAlterOperations() {
                return this.includeTableAlterOperations;
            }

            @Override
            public final java.lang.Object getIncludeTransactionDetails() {
                return this.includeTransactionDetails;
            }

            @Override
            public final java.lang.String getMessageFormat() {
                return this.messageFormat;
            }

            @Override
            public final java.lang.Number getMessageMaxBytes() {
                return this.messageMaxBytes;
            }

            @Override
            public final java.lang.Object getNoHexPrefix() {
                return this.noHexPrefix;
            }

            @Override
            public final java.lang.Object getPartitionIncludeSchemaTable() {
                return this.partitionIncludeSchemaTable;
            }

            @Override
            public final java.lang.String getSaslPassword() {
                return this.saslPassword;
            }

            @Override
            public final java.lang.String getSaslUserName() {
                return this.saslUserName;
            }

            @Override
            public final java.lang.String getSecurityProtocol() {
                return this.securityProtocol;
            }

            @Override
            public final java.lang.String getSslCaCertificateArn() {
                return this.sslCaCertificateArn;
            }

            @Override
            public final java.lang.String getSslClientCertificateArn() {
                return this.sslClientCertificateArn;
            }

            @Override
            public final java.lang.String getSslClientKeyArn() {
                return this.sslClientKeyArn;
            }

            @Override
            public final java.lang.String getSslClientKeyPassword() {
                return this.sslClientKeyPassword;
            }

            @Override
            public final java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBroker() != null) {
                    data.set("broker", om.valueToTree(this.getBroker()));
                }
                if (this.getIncludeControlDetails() != null) {
                    data.set("includeControlDetails", om.valueToTree(this.getIncludeControlDetails()));
                }
                if (this.getIncludeNullAndEmpty() != null) {
                    data.set("includeNullAndEmpty", om.valueToTree(this.getIncludeNullAndEmpty()));
                }
                if (this.getIncludePartitionValue() != null) {
                    data.set("includePartitionValue", om.valueToTree(this.getIncludePartitionValue()));
                }
                if (this.getIncludeTableAlterOperations() != null) {
                    data.set("includeTableAlterOperations", om.valueToTree(this.getIncludeTableAlterOperations()));
                }
                if (this.getIncludeTransactionDetails() != null) {
                    data.set("includeTransactionDetails", om.valueToTree(this.getIncludeTransactionDetails()));
                }
                if (this.getMessageFormat() != null) {
                    data.set("messageFormat", om.valueToTree(this.getMessageFormat()));
                }
                if (this.getMessageMaxBytes() != null) {
                    data.set("messageMaxBytes", om.valueToTree(this.getMessageMaxBytes()));
                }
                if (this.getNoHexPrefix() != null) {
                    data.set("noHexPrefix", om.valueToTree(this.getNoHexPrefix()));
                }
                if (this.getPartitionIncludeSchemaTable() != null) {
                    data.set("partitionIncludeSchemaTable", om.valueToTree(this.getPartitionIncludeSchemaTable()));
                }
                if (this.getSaslPassword() != null) {
                    data.set("saslPassword", om.valueToTree(this.getSaslPassword()));
                }
                if (this.getSaslUserName() != null) {
                    data.set("saslUserName", om.valueToTree(this.getSaslUserName()));
                }
                if (this.getSecurityProtocol() != null) {
                    data.set("securityProtocol", om.valueToTree(this.getSecurityProtocol()));
                }
                if (this.getSslCaCertificateArn() != null) {
                    data.set("sslCaCertificateArn", om.valueToTree(this.getSslCaCertificateArn()));
                }
                if (this.getSslClientCertificateArn() != null) {
                    data.set("sslClientCertificateArn", om.valueToTree(this.getSslClientCertificateArn()));
                }
                if (this.getSslClientKeyArn() != null) {
                    data.set("sslClientKeyArn", om.valueToTree(this.getSslClientKeyArn()));
                }
                if (this.getSslClientKeyPassword() != null) {
                    data.set("sslClientKeyPassword", om.valueToTree(this.getSslClientKeyPassword()));
                }
                if (this.getTopic() != null) {
                    data.set("topic", om.valueToTree(this.getTopic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.KafkaSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KafkaSettingsProperty.Jsii$Proxy that = (KafkaSettingsProperty.Jsii$Proxy) o;

                if (this.broker != null ? !this.broker.equals(that.broker) : that.broker != null) return false;
                if (this.includeControlDetails != null ? !this.includeControlDetails.equals(that.includeControlDetails) : that.includeControlDetails != null) return false;
                if (this.includeNullAndEmpty != null ? !this.includeNullAndEmpty.equals(that.includeNullAndEmpty) : that.includeNullAndEmpty != null) return false;
                if (this.includePartitionValue != null ? !this.includePartitionValue.equals(that.includePartitionValue) : that.includePartitionValue != null) return false;
                if (this.includeTableAlterOperations != null ? !this.includeTableAlterOperations.equals(that.includeTableAlterOperations) : that.includeTableAlterOperations != null) return false;
                if (this.includeTransactionDetails != null ? !this.includeTransactionDetails.equals(that.includeTransactionDetails) : that.includeTransactionDetails != null) return false;
                if (this.messageFormat != null ? !this.messageFormat.equals(that.messageFormat) : that.messageFormat != null) return false;
                if (this.messageMaxBytes != null ? !this.messageMaxBytes.equals(that.messageMaxBytes) : that.messageMaxBytes != null) return false;
                if (this.noHexPrefix != null ? !this.noHexPrefix.equals(that.noHexPrefix) : that.noHexPrefix != null) return false;
                if (this.partitionIncludeSchemaTable != null ? !this.partitionIncludeSchemaTable.equals(that.partitionIncludeSchemaTable) : that.partitionIncludeSchemaTable != null) return false;
                if (this.saslPassword != null ? !this.saslPassword.equals(that.saslPassword) : that.saslPassword != null) return false;
                if (this.saslUserName != null ? !this.saslUserName.equals(that.saslUserName) : that.saslUserName != null) return false;
                if (this.securityProtocol != null ? !this.securityProtocol.equals(that.securityProtocol) : that.securityProtocol != null) return false;
                if (this.sslCaCertificateArn != null ? !this.sslCaCertificateArn.equals(that.sslCaCertificateArn) : that.sslCaCertificateArn != null) return false;
                if (this.sslClientCertificateArn != null ? !this.sslClientCertificateArn.equals(that.sslClientCertificateArn) : that.sslClientCertificateArn != null) return false;
                if (this.sslClientKeyArn != null ? !this.sslClientKeyArn.equals(that.sslClientKeyArn) : that.sslClientKeyArn != null) return false;
                if (this.sslClientKeyPassword != null ? !this.sslClientKeyPassword.equals(that.sslClientKeyPassword) : that.sslClientKeyPassword != null) return false;
                return this.topic != null ? this.topic.equals(that.topic) : that.topic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.broker != null ? this.broker.hashCode() : 0;
                result = 31 * result + (this.includeControlDetails != null ? this.includeControlDetails.hashCode() : 0);
                result = 31 * result + (this.includeNullAndEmpty != null ? this.includeNullAndEmpty.hashCode() : 0);
                result = 31 * result + (this.includePartitionValue != null ? this.includePartitionValue.hashCode() : 0);
                result = 31 * result + (this.includeTableAlterOperations != null ? this.includeTableAlterOperations.hashCode() : 0);
                result = 31 * result + (this.includeTransactionDetails != null ? this.includeTransactionDetails.hashCode() : 0);
                result = 31 * result + (this.messageFormat != null ? this.messageFormat.hashCode() : 0);
                result = 31 * result + (this.messageMaxBytes != null ? this.messageMaxBytes.hashCode() : 0);
                result = 31 * result + (this.noHexPrefix != null ? this.noHexPrefix.hashCode() : 0);
                result = 31 * result + (this.partitionIncludeSchemaTable != null ? this.partitionIncludeSchemaTable.hashCode() : 0);
                result = 31 * result + (this.saslPassword != null ? this.saslPassword.hashCode() : 0);
                result = 31 * result + (this.saslUserName != null ? this.saslUserName.hashCode() : 0);
                result = 31 * result + (this.securityProtocol != null ? this.securityProtocol.hashCode() : 0);
                result = 31 * result + (this.sslCaCertificateArn != null ? this.sslCaCertificateArn.hashCode() : 0);
                result = 31 * result + (this.sslClientCertificateArn != null ? this.sslClientCertificateArn.hashCode() : 0);
                result = 31 * result + (this.sslClientKeyArn != null ? this.sslClientKeyArn.hashCode() : 0);
                result = 31 * result + (this.sslClientKeyPassword != null ? this.sslClientKeyPassword.hashCode() : 0);
                result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that describes an Amazon Kinesis Data Stream endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * KinesisSettingsProperty kinesisSettingsProperty = KinesisSettingsProperty.builder()
     *         .includeControlDetails(false)
     *         .includeNullAndEmpty(false)
     *         .includePartitionValue(false)
     *         .includeTableAlterOperations(false)
     *         .includeTransactionDetails(false)
     *         .messageFormat("messageFormat")
     *         .noHexPrefix(false)
     *         .partitionIncludeSchemaTable(false)
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .streamArn("streamArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.KinesisSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-includecontroldetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-includecontroldetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeControlDetails() {
            return null;
        }

        /**
         * Include NULL and empty columns for records migrated to the endpoint.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-includenullandempty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-includenullandempty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeNullAndEmpty() {
            return null;
        }

        /**
         * Shows the partition value within the Kinesis message output, unless the partition type is <code>schema-table-type</code> .
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-includepartitionvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-includepartitionvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludePartitionValue() {
            return null;
        }

        /**
         * Includes any data definition language (DDL) operations that change the table in the control data, such as <code>rename-table</code> , <code>drop-table</code> , <code>add-column</code> , <code>drop-column</code> , and <code>rename-column</code> .
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-includetablealteroperations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-includetablealteroperations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTableAlterOperations() {
            return null;
        }

        /**
         * Provides detailed transaction information from the source database.
         * <p>
         * This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-includetransactiondetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-includetransactiondetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTransactionDetails() {
            return null;
        }

        /**
         * The output format for the records created on the endpoint.
         * <p>
         * The message format is <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-messageformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-messageformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageFormat() {
            return null;
        }

        /**
         * Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix to raw data in hexadecimal format.
         * <p>
         * For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to an Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-nohexprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-nohexprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoHexPrefix() {
            return null;
        }

        /**
         * Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code> .
         * <p>
         * Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same shard, which causes throttling. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-partitionincludeschematable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-partitionincludeschematable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPartitionIncludeSchemaTable() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the IAM role that AWS DMS uses to write to the Kinesis data stream.
         * <p>
         * The role must allow the <code>iam:PassRole</code> action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-serviceaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-serviceaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-streamarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-streamarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KinesisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisSettingsProperty> {
            java.lang.Object includeControlDetails;
            java.lang.Object includeNullAndEmpty;
            java.lang.Object includePartitionValue;
            java.lang.Object includeTableAlterOperations;
            java.lang.Object includeTransactionDetails;
            java.lang.String messageFormat;
            java.lang.Object noHexPrefix;
            java.lang.Object partitionIncludeSchemaTable;
            java.lang.String serviceAccessRoleArn;
            java.lang.String streamArn;

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output.
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(java.lang.Boolean includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output.
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(software.amazon.awscdk.IResolvable includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty Include NULL and empty columns for records migrated to the endpoint.
             *                            The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(java.lang.Boolean includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty Include NULL and empty columns for records migrated to the endpoint.
             *                            The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(software.amazon.awscdk.IResolvable includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludePartitionValue}
             * @param includePartitionValue Shows the partition value within the Kinesis message output, unless the partition type is <code>schema-table-type</code> .
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includePartitionValue(java.lang.Boolean includePartitionValue) {
                this.includePartitionValue = includePartitionValue;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludePartitionValue}
             * @param includePartitionValue Shows the partition value within the Kinesis message output, unless the partition type is <code>schema-table-type</code> .
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includePartitionValue(software.amazon.awscdk.IResolvable includePartitionValue) {
                this.includePartitionValue = includePartitionValue;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data, such as <code>rename-table</code> , <code>drop-table</code> , <code>add-column</code> , <code>drop-column</code> , and <code>rename-column</code> .
             *                                    The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(java.lang.Boolean includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data, such as <code>rename-table</code> , <code>drop-table</code> , <code>add-column</code> , <code>drop-column</code> , and <code>rename-column</code> .
             *                                    The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(software.amazon.awscdk.IResolvable includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails Provides detailed transaction information from the source database.
             *                                  This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(java.lang.Boolean includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails Provides detailed transaction information from the source database.
             *                                  This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(software.amazon.awscdk.IResolvable includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getMessageFormat}
             * @param messageFormat The output format for the records created on the endpoint.
             *                      The message format is <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageFormat(java.lang.String messageFormat) {
                this.messageFormat = messageFormat;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix to raw data in hexadecimal format.
             *                    For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to an Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(java.lang.Boolean noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix to raw data in hexadecimal format.
             *                    For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to an Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(software.amazon.awscdk.IResolvable noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code> .
             *                                    Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same shard, which causes throttling. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(java.lang.Boolean partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code> .
             *                                    Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same shard, which causes throttling. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(software.amazon.awscdk.IResolvable partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn The Amazon Resource Name (ARN) for the IAM role that AWS DMS uses to write to the Kinesis data stream.
             *                             The role must allow the <code>iam:PassRole</code> action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getStreamArn}
             * @param streamArn The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamArn(java.lang.String streamArn) {
                this.streamArn = streamArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisSettingsProperty {
            private final java.lang.Object includeControlDetails;
            private final java.lang.Object includeNullAndEmpty;
            private final java.lang.Object includePartitionValue;
            private final java.lang.Object includeTableAlterOperations;
            private final java.lang.Object includeTransactionDetails;
            private final java.lang.String messageFormat;
            private final java.lang.Object noHexPrefix;
            private final java.lang.Object partitionIncludeSchemaTable;
            private final java.lang.String serviceAccessRoleArn;
            private final java.lang.String streamArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeControlDetails = software.amazon.jsii.Kernel.get(this, "includeControlDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeNullAndEmpty = software.amazon.jsii.Kernel.get(this, "includeNullAndEmpty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includePartitionValue = software.amazon.jsii.Kernel.get(this, "includePartitionValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTableAlterOperations = software.amazon.jsii.Kernel.get(this, "includeTableAlterOperations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTransactionDetails = software.amazon.jsii.Kernel.get(this, "includeTransactionDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.messageFormat = software.amazon.jsii.Kernel.get(this, "messageFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.noHexPrefix = software.amazon.jsii.Kernel.get(this, "noHexPrefix", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.partitionIncludeSchemaTable = software.amazon.jsii.Kernel.get(this, "partitionIncludeSchemaTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamArn = software.amazon.jsii.Kernel.get(this, "streamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeControlDetails = builder.includeControlDetails;
                this.includeNullAndEmpty = builder.includeNullAndEmpty;
                this.includePartitionValue = builder.includePartitionValue;
                this.includeTableAlterOperations = builder.includeTableAlterOperations;
                this.includeTransactionDetails = builder.includeTransactionDetails;
                this.messageFormat = builder.messageFormat;
                this.noHexPrefix = builder.noHexPrefix;
                this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
                this.streamArn = builder.streamArn;
            }

            @Override
            public final java.lang.Object getIncludeControlDetails() {
                return this.includeControlDetails;
            }

            @Override
            public final java.lang.Object getIncludeNullAndEmpty() {
                return this.includeNullAndEmpty;
            }

            @Override
            public final java.lang.Object getIncludePartitionValue() {
                return this.includePartitionValue;
            }

            @Override
            public final java.lang.Object getIncludeTableAlterOperations() {
                return this.includeTableAlterOperations;
            }

            @Override
            public final java.lang.Object getIncludeTransactionDetails() {
                return this.includeTransactionDetails;
            }

            @Override
            public final java.lang.String getMessageFormat() {
                return this.messageFormat;
            }

            @Override
            public final java.lang.Object getNoHexPrefix() {
                return this.noHexPrefix;
            }

            @Override
            public final java.lang.Object getPartitionIncludeSchemaTable() {
                return this.partitionIncludeSchemaTable;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getStreamArn() {
                return this.streamArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeControlDetails() != null) {
                    data.set("includeControlDetails", om.valueToTree(this.getIncludeControlDetails()));
                }
                if (this.getIncludeNullAndEmpty() != null) {
                    data.set("includeNullAndEmpty", om.valueToTree(this.getIncludeNullAndEmpty()));
                }
                if (this.getIncludePartitionValue() != null) {
                    data.set("includePartitionValue", om.valueToTree(this.getIncludePartitionValue()));
                }
                if (this.getIncludeTableAlterOperations() != null) {
                    data.set("includeTableAlterOperations", om.valueToTree(this.getIncludeTableAlterOperations()));
                }
                if (this.getIncludeTransactionDetails() != null) {
                    data.set("includeTransactionDetails", om.valueToTree(this.getIncludeTransactionDetails()));
                }
                if (this.getMessageFormat() != null) {
                    data.set("messageFormat", om.valueToTree(this.getMessageFormat()));
                }
                if (this.getNoHexPrefix() != null) {
                    data.set("noHexPrefix", om.valueToTree(this.getNoHexPrefix()));
                }
                if (this.getPartitionIncludeSchemaTable() != null) {
                    data.set("partitionIncludeSchemaTable", om.valueToTree(this.getPartitionIncludeSchemaTable()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }
                if (this.getStreamArn() != null) {
                    data.set("streamArn", om.valueToTree(this.getStreamArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.KinesisSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisSettingsProperty.Jsii$Proxy that = (KinesisSettingsProperty.Jsii$Proxy) o;

                if (this.includeControlDetails != null ? !this.includeControlDetails.equals(that.includeControlDetails) : that.includeControlDetails != null) return false;
                if (this.includeNullAndEmpty != null ? !this.includeNullAndEmpty.equals(that.includeNullAndEmpty) : that.includeNullAndEmpty != null) return false;
                if (this.includePartitionValue != null ? !this.includePartitionValue.equals(that.includePartitionValue) : that.includePartitionValue != null) return false;
                if (this.includeTableAlterOperations != null ? !this.includeTableAlterOperations.equals(that.includeTableAlterOperations) : that.includeTableAlterOperations != null) return false;
                if (this.includeTransactionDetails != null ? !this.includeTransactionDetails.equals(that.includeTransactionDetails) : that.includeTransactionDetails != null) return false;
                if (this.messageFormat != null ? !this.messageFormat.equals(that.messageFormat) : that.messageFormat != null) return false;
                if (this.noHexPrefix != null ? !this.noHexPrefix.equals(that.noHexPrefix) : that.noHexPrefix != null) return false;
                if (this.partitionIncludeSchemaTable != null ? !this.partitionIncludeSchemaTable.equals(that.partitionIncludeSchemaTable) : that.partitionIncludeSchemaTable != null) return false;
                if (this.serviceAccessRoleArn != null ? !this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn != null) return false;
                return this.streamArn != null ? this.streamArn.equals(that.streamArn) : that.streamArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeControlDetails != null ? this.includeControlDetails.hashCode() : 0;
                result = 31 * result + (this.includeNullAndEmpty != null ? this.includeNullAndEmpty.hashCode() : 0);
                result = 31 * result + (this.includePartitionValue != null ? this.includePartitionValue.hashCode() : 0);
                result = 31 * result + (this.includeTableAlterOperations != null ? this.includeTableAlterOperations.hashCode() : 0);
                result = 31 * result + (this.includeTransactionDetails != null ? this.includeTransactionDetails.hashCode() : 0);
                result = 31 * result + (this.messageFormat != null ? this.messageFormat.hashCode() : 0);
                result = 31 * result + (this.noHexPrefix != null ? this.noHexPrefix.hashCode() : 0);
                result = 31 * result + (this.partitionIncludeSchemaTable != null ? this.partitionIncludeSchemaTable.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.streamArn != null ? this.streamArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a Microsoft SQL Server endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MicrosoftSqlServerSettingsProperty microsoftSqlServerSettingsProperty = MicrosoftSqlServerSettingsProperty.builder()
     *         .bcpPacketSize(123)
     *         .controlTablesFileGroup("controlTablesFileGroup")
     *         .databaseName("databaseName")
     *         .forceLobLookup(false)
     *         .password("password")
     *         .port(123)
     *         .querySingleAlwaysOnNode(false)
     *         .readBackupOnly(false)
     *         .safeguardPolicy("safeguardPolicy")
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .serverName("serverName")
     *         .tlogAccessMode("tlogAccessMode")
     *         .trimSpaceInChar(false)
     *         .useBcpFullLoad(false)
     *         .username("username")
     *         .useThirdPartyBackupDevice(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MicrosoftSqlServerSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MicrosoftSqlServerSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum size of the packets (in bytes) used to transfer data using BCP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-bcppacketsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-bcppacketsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBcpPacketSize() {
            return null;
        }

        /**
         * Specifies a file group for the AWS DMS internal tables.
         * <p>
         * When the replication task starts, all the internal AWS DMS control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for the specified file group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-controltablesfilegroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-controltablesfilegroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getControlTablesFileGroup() {
            return null;
        }

        /**
         * Database name for the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * Forces LOB lookup on inline LOB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-forceloblookup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-forceloblookup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForceLobLookup() {
            return null;
        }

        /**
         * Endpoint connection password.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * Endpoint TCP port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * Cleans and recreates table metadata information on the replication instance when a mismatch occurs.
         * <p>
         * An example is a situation where running an alter DDL statement on a table might result in different information about the table cached in the replication instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-querysinglealwaysonnode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-querysinglealwaysonnode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQuerySingleAlwaysOnNode() {
            return null;
        }

        /**
         * When this attribute is set to <code>Y</code> , AWS DMS only reads changes from transaction log backups and doesn't read from the active transaction log file during ongoing replication.
         * <p>
         * Setting this parameter to <code>Y</code> enables you to control active transaction log file growth during full load and ongoing replication tasks. However, it can add some source latency to ongoing replication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-readbackuponly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-readbackuponly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadBackupOnly() {
            return null;
        }

        /**
         * Use this attribute to minimize the need to access the backup log and enable AWS DMS to prevent truncation using one of the following two methods.
         * <p>
         * <em>Start transactions in the database:</em> This is the default method. When this method is used, AWS DMS prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open, changes that appear after the transaction started aren't truncated. If you need Microsoft Replication to be enabled in your database, then you must choose this method.
         * <p>
         * <em>Exclusively use sp_repldone within a single task</em> : When this method is used, AWS DMS reads the changes and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn't involve any transactional activities, it can only be used when Microsoft Replication isn't running. Also, when using this method, only one AWS DMS task can access the database at any given time. Therefore, if you need to run parallel AWS DMS tasks against the same database, use the default method.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-safeguardpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-safeguardpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSafeguardPolicy() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the SQL Server endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the MicrosoftSQLServer endpoint connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * Fully qualified domain name of the endpoint.
         * <p>
         * For an Amazon RDS SQL Server instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a> , in the <code>[Endpoint](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html) .Address</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
            return null;
        }

        /**
         * Indicates the mode used to fetch CDC data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-tlogaccessmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-tlogaccessmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTlogAccessMode() {
            return null;
        }

        /**
         * Use the <code>TrimSpaceInChar</code> source endpoint setting to right-trim data on CHAR and NCHAR data types during migration.
         * <p>
         * Setting <code>TrimSpaceInChar</code> does not left-trim data. The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-trimspaceinchar">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-trimspaceinchar</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTrimSpaceInChar() {
            return null;
        }

        /**
         * Use this to attribute to transfer data for full-load operations using BCP.
         * <p>
         * When the target table contains an identity column that does not exist in the source table, you must disable the use BCP for loading table option.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-usebcpfullload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-usebcpfullload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseBcpFullLoad() {
            return null;
        }

        /**
         * Endpoint connection user name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * When this attribute is set to <code>Y</code> , DMS processes third-party transaction log backups if they are created in native format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-usethirdpartybackupdevice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-microsoftsqlserversettings.html#cfn-dms-endpoint-microsoftsqlserversettings-usethirdpartybackupdevice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseThirdPartyBackupDevice() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MicrosoftSqlServerSettingsProperty> {
            java.lang.Number bcpPacketSize;
            java.lang.String controlTablesFileGroup;
            java.lang.String databaseName;
            java.lang.Object forceLobLookup;
            java.lang.String password;
            java.lang.Number port;
            java.lang.Object querySingleAlwaysOnNode;
            java.lang.Object readBackupOnly;
            java.lang.String safeguardPolicy;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;
            java.lang.String serverName;
            java.lang.String tlogAccessMode;
            java.lang.Object trimSpaceInChar;
            java.lang.Object useBcpFullLoad;
            java.lang.String username;
            java.lang.Object useThirdPartyBackupDevice;

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getBcpPacketSize}
             * @param bcpPacketSize The maximum size of the packets (in bytes) used to transfer data using BCP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bcpPacketSize(java.lang.Number bcpPacketSize) {
                this.bcpPacketSize = bcpPacketSize;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getControlTablesFileGroup}
             * @param controlTablesFileGroup Specifies a file group for the AWS DMS internal tables.
             *                               When the replication task starts, all the internal AWS DMS control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for the specified file group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlTablesFileGroup(java.lang.String controlTablesFileGroup) {
                this.controlTablesFileGroup = controlTablesFileGroup;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getDatabaseName}
             * @param databaseName Database name for the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getForceLobLookup}
             * @param forceLobLookup Forces LOB lookup on inline LOB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forceLobLookup(java.lang.Boolean forceLobLookup) {
                this.forceLobLookup = forceLobLookup;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getForceLobLookup}
             * @param forceLobLookup Forces LOB lookup on inline LOB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forceLobLookup(software.amazon.awscdk.IResolvable forceLobLookup) {
                this.forceLobLookup = forceLobLookup;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getPassword}
             * @param password Endpoint connection password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getPort}
             * @param port Endpoint TCP port.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getQuerySingleAlwaysOnNode}
             * @param querySingleAlwaysOnNode Cleans and recreates table metadata information on the replication instance when a mismatch occurs.
             *                                An example is a situation where running an alter DDL statement on a table might result in different information about the table cached in the replication instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder querySingleAlwaysOnNode(java.lang.Boolean querySingleAlwaysOnNode) {
                this.querySingleAlwaysOnNode = querySingleAlwaysOnNode;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getQuerySingleAlwaysOnNode}
             * @param querySingleAlwaysOnNode Cleans and recreates table metadata information on the replication instance when a mismatch occurs.
             *                                An example is a situation where running an alter DDL statement on a table might result in different information about the table cached in the replication instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder querySingleAlwaysOnNode(software.amazon.awscdk.IResolvable querySingleAlwaysOnNode) {
                this.querySingleAlwaysOnNode = querySingleAlwaysOnNode;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getReadBackupOnly}
             * @param readBackupOnly When this attribute is set to <code>Y</code> , AWS DMS only reads changes from transaction log backups and doesn't read from the active transaction log file during ongoing replication.
             *                       Setting this parameter to <code>Y</code> enables you to control active transaction log file growth during full load and ongoing replication tasks. However, it can add some source latency to ongoing replication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readBackupOnly(java.lang.Boolean readBackupOnly) {
                this.readBackupOnly = readBackupOnly;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getReadBackupOnly}
             * @param readBackupOnly When this attribute is set to <code>Y</code> , AWS DMS only reads changes from transaction log backups and doesn't read from the active transaction log file during ongoing replication.
             *                       Setting this parameter to <code>Y</code> enables you to control active transaction log file growth during full load and ongoing replication tasks. However, it can add some source latency to ongoing replication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readBackupOnly(software.amazon.awscdk.IResolvable readBackupOnly) {
                this.readBackupOnly = readBackupOnly;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getSafeguardPolicy}
             * @param safeguardPolicy Use this attribute to minimize the need to access the backup log and enable AWS DMS to prevent truncation using one of the following two methods.
             *                        <em>Start transactions in the database:</em> This is the default method. When this method is used, AWS DMS prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open, changes that appear after the transaction started aren't truncated. If you need Microsoft Replication to be enabled in your database, then you must choose this method.
             *                        <p>
             *                        <em>Exclusively use sp_repldone within a single task</em> : When this method is used, AWS DMS reads the changes and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn't involve any transactional activities, it can only be used when Microsoft Replication isn't running. Also, when using this method, only one AWS DMS task can access the database at any given time. Therefore, if you need to run parallel AWS DMS tasks against the same database, use the default method.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder safeguardPolicy(java.lang.String safeguardPolicy) {
                this.safeguardPolicy = safeguardPolicy;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
             *                                    The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the SQL Server endpoint.
             *                                    <p>
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
             *                                    <p>
             *                                    For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the MicrosoftSQLServer endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getServerName}
             * @param serverName Fully qualified domain name of the endpoint.
             *                   For an Amazon RDS SQL Server instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a> , in the <code>[Endpoint](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html) .Address</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getTlogAccessMode}
             * @param tlogAccessMode Indicates the mode used to fetch CDC data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tlogAccessMode(java.lang.String tlogAccessMode) {
                this.tlogAccessMode = tlogAccessMode;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getTrimSpaceInChar}
             * @param trimSpaceInChar Use the <code>TrimSpaceInChar</code> source endpoint setting to right-trim data on CHAR and NCHAR data types during migration.
             *                        Setting <code>TrimSpaceInChar</code> does not left-trim data. The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trimSpaceInChar(java.lang.Boolean trimSpaceInChar) {
                this.trimSpaceInChar = trimSpaceInChar;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getTrimSpaceInChar}
             * @param trimSpaceInChar Use the <code>TrimSpaceInChar</code> source endpoint setting to right-trim data on CHAR and NCHAR data types during migration.
             *                        Setting <code>TrimSpaceInChar</code> does not left-trim data. The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trimSpaceInChar(software.amazon.awscdk.IResolvable trimSpaceInChar) {
                this.trimSpaceInChar = trimSpaceInChar;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getUseBcpFullLoad}
             * @param useBcpFullLoad Use this to attribute to transfer data for full-load operations using BCP.
             *                       When the target table contains an identity column that does not exist in the source table, you must disable the use BCP for loading table option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBcpFullLoad(java.lang.Boolean useBcpFullLoad) {
                this.useBcpFullLoad = useBcpFullLoad;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getUseBcpFullLoad}
             * @param useBcpFullLoad Use this to attribute to transfer data for full-load operations using BCP.
             *                       When the target table contains an identity column that does not exist in the source table, you must disable the use BCP for loading table option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBcpFullLoad(software.amazon.awscdk.IResolvable useBcpFullLoad) {
                this.useBcpFullLoad = useBcpFullLoad;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getUsername}
             * @param username Endpoint connection user name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getUseThirdPartyBackupDevice}
             * @param useThirdPartyBackupDevice When this attribute is set to <code>Y</code> , DMS processes third-party transaction log backups if they are created in native format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useThirdPartyBackupDevice(java.lang.Boolean useThirdPartyBackupDevice) {
                this.useThirdPartyBackupDevice = useThirdPartyBackupDevice;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getUseThirdPartyBackupDevice}
             * @param useThirdPartyBackupDevice When this attribute is set to <code>Y</code> , DMS processes third-party transaction log backups if they are created in native format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useThirdPartyBackupDevice(software.amazon.awscdk.IResolvable useThirdPartyBackupDevice) {
                this.useThirdPartyBackupDevice = useThirdPartyBackupDevice;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MicrosoftSqlServerSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MicrosoftSqlServerSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MicrosoftSqlServerSettingsProperty {
            private final java.lang.Number bcpPacketSize;
            private final java.lang.String controlTablesFileGroup;
            private final java.lang.String databaseName;
            private final java.lang.Object forceLobLookup;
            private final java.lang.String password;
            private final java.lang.Number port;
            private final java.lang.Object querySingleAlwaysOnNode;
            private final java.lang.Object readBackupOnly;
            private final java.lang.String safeguardPolicy;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.String serverName;
            private final java.lang.String tlogAccessMode;
            private final java.lang.Object trimSpaceInChar;
            private final java.lang.Object useBcpFullLoad;
            private final java.lang.String username;
            private final java.lang.Object useThirdPartyBackupDevice;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bcpPacketSize = software.amazon.jsii.Kernel.get(this, "bcpPacketSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.controlTablesFileGroup = software.amazon.jsii.Kernel.get(this, "controlTablesFileGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.forceLobLookup = software.amazon.jsii.Kernel.get(this, "forceLobLookup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.querySingleAlwaysOnNode = software.amazon.jsii.Kernel.get(this, "querySingleAlwaysOnNode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readBackupOnly = software.amazon.jsii.Kernel.get(this, "readBackupOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.safeguardPolicy = software.amazon.jsii.Kernel.get(this, "safeguardPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tlogAccessMode = software.amazon.jsii.Kernel.get(this, "tlogAccessMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trimSpaceInChar = software.amazon.jsii.Kernel.get(this, "trimSpaceInChar", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useBcpFullLoad = software.amazon.jsii.Kernel.get(this, "useBcpFullLoad", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.useThirdPartyBackupDevice = software.amazon.jsii.Kernel.get(this, "useThirdPartyBackupDevice", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bcpPacketSize = builder.bcpPacketSize;
                this.controlTablesFileGroup = builder.controlTablesFileGroup;
                this.databaseName = builder.databaseName;
                this.forceLobLookup = builder.forceLobLookup;
                this.password = builder.password;
                this.port = builder.port;
                this.querySingleAlwaysOnNode = builder.querySingleAlwaysOnNode;
                this.readBackupOnly = builder.readBackupOnly;
                this.safeguardPolicy = builder.safeguardPolicy;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.serverName = builder.serverName;
                this.tlogAccessMode = builder.tlogAccessMode;
                this.trimSpaceInChar = builder.trimSpaceInChar;
                this.useBcpFullLoad = builder.useBcpFullLoad;
                this.username = builder.username;
                this.useThirdPartyBackupDevice = builder.useThirdPartyBackupDevice;
            }

            @Override
            public final java.lang.Number getBcpPacketSize() {
                return this.bcpPacketSize;
            }

            @Override
            public final java.lang.String getControlTablesFileGroup() {
                return this.controlTablesFileGroup;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Object getForceLobLookup() {
                return this.forceLobLookup;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getQuerySingleAlwaysOnNode() {
                return this.querySingleAlwaysOnNode;
            }

            @Override
            public final java.lang.Object getReadBackupOnly() {
                return this.readBackupOnly;
            }

            @Override
            public final java.lang.String getSafeguardPolicy() {
                return this.safeguardPolicy;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getTlogAccessMode() {
                return this.tlogAccessMode;
            }

            @Override
            public final java.lang.Object getTrimSpaceInChar() {
                return this.trimSpaceInChar;
            }

            @Override
            public final java.lang.Object getUseBcpFullLoad() {
                return this.useBcpFullLoad;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            public final java.lang.Object getUseThirdPartyBackupDevice() {
                return this.useThirdPartyBackupDevice;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBcpPacketSize() != null) {
                    data.set("bcpPacketSize", om.valueToTree(this.getBcpPacketSize()));
                }
                if (this.getControlTablesFileGroup() != null) {
                    data.set("controlTablesFileGroup", om.valueToTree(this.getControlTablesFileGroup()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getForceLobLookup() != null) {
                    data.set("forceLobLookup", om.valueToTree(this.getForceLobLookup()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getQuerySingleAlwaysOnNode() != null) {
                    data.set("querySingleAlwaysOnNode", om.valueToTree(this.getQuerySingleAlwaysOnNode()));
                }
                if (this.getReadBackupOnly() != null) {
                    data.set("readBackupOnly", om.valueToTree(this.getReadBackupOnly()));
                }
                if (this.getSafeguardPolicy() != null) {
                    data.set("safeguardPolicy", om.valueToTree(this.getSafeguardPolicy()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getServerName() != null) {
                    data.set("serverName", om.valueToTree(this.getServerName()));
                }
                if (this.getTlogAccessMode() != null) {
                    data.set("tlogAccessMode", om.valueToTree(this.getTlogAccessMode()));
                }
                if (this.getTrimSpaceInChar() != null) {
                    data.set("trimSpaceInChar", om.valueToTree(this.getTrimSpaceInChar()));
                }
                if (this.getUseBcpFullLoad() != null) {
                    data.set("useBcpFullLoad", om.valueToTree(this.getUseBcpFullLoad()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }
                if (this.getUseThirdPartyBackupDevice() != null) {
                    data.set("useThirdPartyBackupDevice", om.valueToTree(this.getUseThirdPartyBackupDevice()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MicrosoftSqlServerSettingsProperty.Jsii$Proxy that = (MicrosoftSqlServerSettingsProperty.Jsii$Proxy) o;

                if (this.bcpPacketSize != null ? !this.bcpPacketSize.equals(that.bcpPacketSize) : that.bcpPacketSize != null) return false;
                if (this.controlTablesFileGroup != null ? !this.controlTablesFileGroup.equals(that.controlTablesFileGroup) : that.controlTablesFileGroup != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.forceLobLookup != null ? !this.forceLobLookup.equals(that.forceLobLookup) : that.forceLobLookup != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.querySingleAlwaysOnNode != null ? !this.querySingleAlwaysOnNode.equals(that.querySingleAlwaysOnNode) : that.querySingleAlwaysOnNode != null) return false;
                if (this.readBackupOnly != null ? !this.readBackupOnly.equals(that.readBackupOnly) : that.readBackupOnly != null) return false;
                if (this.safeguardPolicy != null ? !this.safeguardPolicy.equals(that.safeguardPolicy) : that.safeguardPolicy != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
                if (this.tlogAccessMode != null ? !this.tlogAccessMode.equals(that.tlogAccessMode) : that.tlogAccessMode != null) return false;
                if (this.trimSpaceInChar != null ? !this.trimSpaceInChar.equals(that.trimSpaceInChar) : that.trimSpaceInChar != null) return false;
                if (this.useBcpFullLoad != null ? !this.useBcpFullLoad.equals(that.useBcpFullLoad) : that.useBcpFullLoad != null) return false;
                if (this.username != null ? !this.username.equals(that.username) : that.username != null) return false;
                return this.useThirdPartyBackupDevice != null ? this.useThirdPartyBackupDevice.equals(that.useThirdPartyBackupDevice) : that.useThirdPartyBackupDevice == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bcpPacketSize != null ? this.bcpPacketSize.hashCode() : 0;
                result = 31 * result + (this.controlTablesFileGroup != null ? this.controlTablesFileGroup.hashCode() : 0);
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.forceLobLookup != null ? this.forceLobLookup.hashCode() : 0);
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.querySingleAlwaysOnNode != null ? this.querySingleAlwaysOnNode.hashCode() : 0);
                result = 31 * result + (this.readBackupOnly != null ? this.readBackupOnly.hashCode() : 0);
                result = 31 * result + (this.safeguardPolicy != null ? this.safeguardPolicy.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
                result = 31 * result + (this.tlogAccessMode != null ? this.tlogAccessMode.hashCode() : 0);
                result = 31 * result + (this.trimSpaceInChar != null ? this.trimSpaceInChar.hashCode() : 0);
                result = 31 * result + (this.useBcpFullLoad != null ? this.useBcpFullLoad.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                result = 31 * result + (this.useThirdPartyBackupDevice != null ? this.useThirdPartyBackupDevice.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a MongoDB endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings when using MongoDB as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MongoDbSettingsProperty mongoDbSettingsProperty = MongoDbSettingsProperty.builder()
     *         .authMechanism("authMechanism")
     *         .authSource("authSource")
     *         .authType("authType")
     *         .databaseName("databaseName")
     *         .docsToInvestigate("docsToInvestigate")
     *         .extractDocId("extractDocId")
     *         .nestingLevel("nestingLevel")
     *         .password("password")
     *         .port(123)
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .serverName("serverName")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.MongoDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MongoDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MongoDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authentication mechanism you use to access the MongoDB source endpoint.
         * <p>
         * For the default value, in MongoDB version 2.x, <code>"default"</code> is <code>"mongodb_cr"</code> . For MongoDB version 3.x or later, <code>"default"</code> is <code>"scram_sha_1"</code> . This setting isn't used when <code>AuthType</code> is set to <code>"no"</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authmechanism">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authmechanism</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthMechanism() {
            return null;
        }

        /**
         * The MongoDB database name. This setting isn't used when <code>AuthType</code> is set to <code>"no"</code> .
         * <p>
         * The default is <code>"admin"</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthSource() {
            return null;
        }

        /**
         * The authentication type you use to access the MongoDB source endpoint.
         * <p>
         * When set to <code>"no"</code> , user name and password parameters are not used and can be empty.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthType() {
            return null;
        }

        /**
         * The database name on the MongoDB source endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * Indicates the number of documents to preview to determine the document organization.
         * <p>
         * Use this setting when <code>NestingLevel</code> is set to <code>"one"</code> .
         * <p>
         * Must be a positive value greater than <code>0</code> . Default value is <code>1000</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-docstoinvestigate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-docstoinvestigate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocsToInvestigate() {
            return null;
        }

        /**
         * Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to <code>"none"</code> .
         * <p>
         * Default value is <code>"false"</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-extractdocid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-extractdocid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExtractDocId() {
            return null;
        }

        /**
         * Specifies either document or table mode.
         * <p>
         * Default value is <code>"none"</code> . Specify <code>"none"</code> to use document mode. Specify <code>"one"</code> to use table mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-nestinglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-nestinglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNestingLevel() {
            return null;
        }

        /**
         * The password for the user account you use to access the MongoDB source endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The port value for the MongoDB source endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the MongoDB endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the MongoDB endpoint connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * The name of the server on the MongoDB source endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
            return null;
        }

        /**
         * The user name you use to access the MongoDB source endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MongoDbSettingsProperty> {
            java.lang.String authMechanism;
            java.lang.String authSource;
            java.lang.String authType;
            java.lang.String databaseName;
            java.lang.String docsToInvestigate;
            java.lang.String extractDocId;
            java.lang.String nestingLevel;
            java.lang.String password;
            java.lang.Number port;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;
            java.lang.String serverName;
            java.lang.String username;

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthMechanism}
             * @param authMechanism The authentication mechanism you use to access the MongoDB source endpoint.
             *                      For the default value, in MongoDB version 2.x, <code>"default"</code> is <code>"mongodb_cr"</code> . For MongoDB version 3.x or later, <code>"default"</code> is <code>"scram_sha_1"</code> . This setting isn't used when <code>AuthType</code> is set to <code>"no"</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authMechanism(java.lang.String authMechanism) {
                this.authMechanism = authMechanism;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthSource}
             * @param authSource The MongoDB database name. This setting isn't used when <code>AuthType</code> is set to <code>"no"</code> .
             *                   The default is <code>"admin"</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authSource(java.lang.String authSource) {
                this.authSource = authSource;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthType}
             * @param authType The authentication type you use to access the MongoDB source endpoint.
             *                 When set to <code>"no"</code> , user name and password parameters are not used and can be empty.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getDatabaseName}
             * @param databaseName The database name on the MongoDB source endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getDocsToInvestigate}
             * @param docsToInvestigate Indicates the number of documents to preview to determine the document organization.
             *                          Use this setting when <code>NestingLevel</code> is set to <code>"one"</code> .
             *                          <p>
             *                          Must be a positive value greater than <code>0</code> . Default value is <code>1000</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder docsToInvestigate(java.lang.String docsToInvestigate) {
                this.docsToInvestigate = docsToInvestigate;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getExtractDocId}
             * @param extractDocId Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to <code>"none"</code> .
             *                     Default value is <code>"false"</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extractDocId(java.lang.String extractDocId) {
                this.extractDocId = extractDocId;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getNestingLevel}
             * @param nestingLevel Specifies either document or table mode.
             *                     Default value is <code>"none"</code> . Specify <code>"none"</code> to use document mode. Specify <code>"one"</code> to use table mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nestingLevel(java.lang.String nestingLevel) {
                this.nestingLevel = nestingLevel;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getPassword}
             * @param password The password for the user account you use to access the MongoDB source endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getPort}
             * @param port The port value for the MongoDB source endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
             *                                    The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the MongoDB endpoint.
             *                                    <p>
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
             *                                    <p>
             *                                    For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the MongoDB endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getServerName}
             * @param serverName The name of the server on the MongoDB source endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getUsername}
             * @param username The user name you use to access the MongoDB source endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MongoDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MongoDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MongoDbSettingsProperty {
            private final java.lang.String authMechanism;
            private final java.lang.String authSource;
            private final java.lang.String authType;
            private final java.lang.String databaseName;
            private final java.lang.String docsToInvestigate;
            private final java.lang.String extractDocId;
            private final java.lang.String nestingLevel;
            private final java.lang.String password;
            private final java.lang.Number port;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.String serverName;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authMechanism = software.amazon.jsii.Kernel.get(this, "authMechanism", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authSource = software.amazon.jsii.Kernel.get(this, "authSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.docsToInvestigate = software.amazon.jsii.Kernel.get(this, "docsToInvestigate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.extractDocId = software.amazon.jsii.Kernel.get(this, "extractDocId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nestingLevel = software.amazon.jsii.Kernel.get(this, "nestingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authMechanism = builder.authMechanism;
                this.authSource = builder.authSource;
                this.authType = builder.authType;
                this.databaseName = builder.databaseName;
                this.docsToInvestigate = builder.docsToInvestigate;
                this.extractDocId = builder.extractDocId;
                this.nestingLevel = builder.nestingLevel;
                this.password = builder.password;
                this.port = builder.port;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.serverName = builder.serverName;
                this.username = builder.username;
            }

            @Override
            public final java.lang.String getAuthMechanism() {
                return this.authMechanism;
            }

            @Override
            public final java.lang.String getAuthSource() {
                return this.authSource;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getDocsToInvestigate() {
                return this.docsToInvestigate;
            }

            @Override
            public final java.lang.String getExtractDocId() {
                return this.extractDocId;
            }

            @Override
            public final java.lang.String getNestingLevel() {
                return this.nestingLevel;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthMechanism() != null) {
                    data.set("authMechanism", om.valueToTree(this.getAuthMechanism()));
                }
                if (this.getAuthSource() != null) {
                    data.set("authSource", om.valueToTree(this.getAuthSource()));
                }
                if (this.getAuthType() != null) {
                    data.set("authType", om.valueToTree(this.getAuthType()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getDocsToInvestigate() != null) {
                    data.set("docsToInvestigate", om.valueToTree(this.getDocsToInvestigate()));
                }
                if (this.getExtractDocId() != null) {
                    data.set("extractDocId", om.valueToTree(this.getExtractDocId()));
                }
                if (this.getNestingLevel() != null) {
                    data.set("nestingLevel", om.valueToTree(this.getNestingLevel()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getServerName() != null) {
                    data.set("serverName", om.valueToTree(this.getServerName()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.MongoDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MongoDbSettingsProperty.Jsii$Proxy that = (MongoDbSettingsProperty.Jsii$Proxy) o;

                if (this.authMechanism != null ? !this.authMechanism.equals(that.authMechanism) : that.authMechanism != null) return false;
                if (this.authSource != null ? !this.authSource.equals(that.authSource) : that.authSource != null) return false;
                if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.docsToInvestigate != null ? !this.docsToInvestigate.equals(that.docsToInvestigate) : that.docsToInvestigate != null) return false;
                if (this.extractDocId != null ? !this.extractDocId.equals(that.extractDocId) : that.extractDocId != null) return false;
                if (this.nestingLevel != null ? !this.nestingLevel.equals(that.nestingLevel) : that.nestingLevel != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authMechanism != null ? this.authMechanism.hashCode() : 0;
                result = 31 * result + (this.authSource != null ? this.authSource.hashCode() : 0);
                result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.docsToInvestigate != null ? this.docsToInvestigate.hashCode() : 0);
                result = 31 * result + (this.extractDocId != null ? this.extractDocId.hashCode() : 0);
                result = 31 * result + (this.nestingLevel != null ? this.nestingLevel.hashCode() : 0);
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a MySQL endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MySqlSettingsProperty mySqlSettingsProperty = MySqlSettingsProperty.builder()
     *         .afterConnectScript("afterConnectScript")
     *         .cleanSourceMetadataOnMismatch(false)
     *         .eventsPollInterval(123)
     *         .maxFileSize(123)
     *         .parallelLoadThreads(123)
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .serverTimezone("serverTimezone")
     *         .targetDbType("targetDbType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.MySqlSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MySqlSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MySqlSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a script to run immediately after AWS DMS connects to the endpoint.
         * <p>
         * The migration task continues running regardless if the SQL statement succeeds or fails.
         * <p>
         * For this parameter, provide the code of the script itself, not the name of a file containing the script.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-afterconnectscript">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-afterconnectscript</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAfterConnectScript() {
            return null;
        }

        /**
         * Cleans and recreates table metadata information on the replication instance when a mismatch occurs.
         * <p>
         * For example, in a situation where running an alter DDL on the table could result in different information about the table cached in the replication instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-cleansourcemetadataonmismatch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-cleansourcemetadataonmismatch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCleanSourceMetadataOnMismatch() {
            return null;
        }

        /**
         * Specifies how often to check the binary log for new changes/events when the database is idle.
         * <p>
         * The default is five seconds.
         * <p>
         * Example: <code>eventsPollInterval=5;</code>
         * <p>
         * In the example, AWS DMS checks for changes in the binary logs every five seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-eventspollinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-eventspollinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEventsPollInterval() {
            return null;
        }

        /**
         * Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.
         * <p>
         * Example: <code>maxFileSize=512</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-maxfilesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-maxfilesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFileSize() {
            return null;
        }

        /**
         * Improves performance when loading data into the MySQL-compatible target database.
         * <p>
         * Specifies how many threads to use to load the data into the MySQL-compatible target database. Setting a large number of threads can have an adverse effect on database performance, because a separate connection is required for each thread. The default is one.
         * <p>
         * Example: <code>parallelLoadThreads=1</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-parallelloadthreads">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-parallelloadthreads</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParallelLoadThreads() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the MySQL endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the MySQL endpoint connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * Specifies the time zone for the source MySQL database.
         * <p>
         * Example: <code>serverTimezone=US/Pacific;</code>
         * <p>
         * Note: Do not enclose time zones in single quotes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-servertimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-servertimezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerTimezone() {
            return null;
        }

        /**
         * Specifies where to migrate source tables on the target, either to a single database or multiple databases.
         * <p>
         * If you specify <code>SPECIFIC_DATABASE</code> , specify the database name using the <code>DatabaseName</code> parameter of the <code>Endpoint</code> object.
         * <p>
         * Example: <code>targetDbType=MULTIPLE_DATABASES</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-targetdbtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mysqlsettings.html#cfn-dms-endpoint-mysqlsettings-targetdbtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetDbType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MySqlSettingsProperty> {
            java.lang.String afterConnectScript;
            java.lang.Object cleanSourceMetadataOnMismatch;
            java.lang.Number eventsPollInterval;
            java.lang.Number maxFileSize;
            java.lang.Number parallelLoadThreads;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;
            java.lang.String serverTimezone;
            java.lang.String targetDbType;

            /**
             * Sets the value of {@link MySqlSettingsProperty#getAfterConnectScript}
             * @param afterConnectScript Specifies a script to run immediately after AWS DMS connects to the endpoint.
             *                           The migration task continues running regardless if the SQL statement succeeds or fails.
             *                           <p>
             *                           For this parameter, provide the code of the script itself, not the name of a file containing the script.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder afterConnectScript(java.lang.String afterConnectScript) {
                this.afterConnectScript = afterConnectScript;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getCleanSourceMetadataOnMismatch}
             * @param cleanSourceMetadataOnMismatch Cleans and recreates table metadata information on the replication instance when a mismatch occurs.
             *                                      For example, in a situation where running an alter DDL on the table could result in different information about the table cached in the replication instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cleanSourceMetadataOnMismatch(java.lang.Boolean cleanSourceMetadataOnMismatch) {
                this.cleanSourceMetadataOnMismatch = cleanSourceMetadataOnMismatch;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getCleanSourceMetadataOnMismatch}
             * @param cleanSourceMetadataOnMismatch Cleans and recreates table metadata information on the replication instance when a mismatch occurs.
             *                                      For example, in a situation where running an alter DDL on the table could result in different information about the table cached in the replication instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cleanSourceMetadataOnMismatch(software.amazon.awscdk.IResolvable cleanSourceMetadataOnMismatch) {
                this.cleanSourceMetadataOnMismatch = cleanSourceMetadataOnMismatch;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getEventsPollInterval}
             * @param eventsPollInterval Specifies how often to check the binary log for new changes/events when the database is idle.
             *                           The default is five seconds.
             *                           <p>
             *                           Example: <code>eventsPollInterval=5;</code>
             *                           <p>
             *                           In the example, AWS DMS checks for changes in the binary logs every five seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventsPollInterval(java.lang.Number eventsPollInterval) {
                this.eventsPollInterval = eventsPollInterval;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getMaxFileSize}
             * @param maxFileSize Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.
             *                    Example: <code>maxFileSize=512</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFileSize(java.lang.Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getParallelLoadThreads}
             * @param parallelLoadThreads Improves performance when loading data into the MySQL-compatible target database.
             *                            Specifies how many threads to use to load the data into the MySQL-compatible target database. Setting a large number of threads can have an adverse effect on database performance, because a separate connection is required for each thread. The default is one.
             *                            <p>
             *                            Example: <code>parallelLoadThreads=1</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelLoadThreads(java.lang.Number parallelLoadThreads) {
                this.parallelLoadThreads = parallelLoadThreads;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
             *                                    The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the MySQL endpoint.
             *                                    <p>
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
             *                                    <p>
             *                                    For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the MySQL endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getServerTimezone}
             * @param serverTimezone Specifies the time zone for the source MySQL database.
             *                       Example: <code>serverTimezone=US/Pacific;</code>
             *                       <p>
             *                       Note: Do not enclose time zones in single quotes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverTimezone(java.lang.String serverTimezone) {
                this.serverTimezone = serverTimezone;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getTargetDbType}
             * @param targetDbType Specifies where to migrate source tables on the target, either to a single database or multiple databases.
             *                     If you specify <code>SPECIFIC_DATABASE</code> , specify the database name using the <code>DatabaseName</code> parameter of the <code>Endpoint</code> object.
             *                     <p>
             *                     Example: <code>targetDbType=MULTIPLE_DATABASES</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetDbType(java.lang.String targetDbType) {
                this.targetDbType = targetDbType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MySqlSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MySqlSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MySqlSettingsProperty {
            private final java.lang.String afterConnectScript;
            private final java.lang.Object cleanSourceMetadataOnMismatch;
            private final java.lang.Number eventsPollInterval;
            private final java.lang.Number maxFileSize;
            private final java.lang.Number parallelLoadThreads;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.String serverTimezone;
            private final java.lang.String targetDbType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.afterConnectScript = software.amazon.jsii.Kernel.get(this, "afterConnectScript", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cleanSourceMetadataOnMismatch = software.amazon.jsii.Kernel.get(this, "cleanSourceMetadataOnMismatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventsPollInterval = software.amazon.jsii.Kernel.get(this, "eventsPollInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxFileSize = software.amazon.jsii.Kernel.get(this, "maxFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.parallelLoadThreads = software.amazon.jsii.Kernel.get(this, "parallelLoadThreads", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverTimezone = software.amazon.jsii.Kernel.get(this, "serverTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetDbType = software.amazon.jsii.Kernel.get(this, "targetDbType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.afterConnectScript = builder.afterConnectScript;
                this.cleanSourceMetadataOnMismatch = builder.cleanSourceMetadataOnMismatch;
                this.eventsPollInterval = builder.eventsPollInterval;
                this.maxFileSize = builder.maxFileSize;
                this.parallelLoadThreads = builder.parallelLoadThreads;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.serverTimezone = builder.serverTimezone;
                this.targetDbType = builder.targetDbType;
            }

            @Override
            public final java.lang.String getAfterConnectScript() {
                return this.afterConnectScript;
            }

            @Override
            public final java.lang.Object getCleanSourceMetadataOnMismatch() {
                return this.cleanSourceMetadataOnMismatch;
            }

            @Override
            public final java.lang.Number getEventsPollInterval() {
                return this.eventsPollInterval;
            }

            @Override
            public final java.lang.Number getMaxFileSize() {
                return this.maxFileSize;
            }

            @Override
            public final java.lang.Number getParallelLoadThreads() {
                return this.parallelLoadThreads;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getServerTimezone() {
                return this.serverTimezone;
            }

            @Override
            public final java.lang.String getTargetDbType() {
                return this.targetDbType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAfterConnectScript() != null) {
                    data.set("afterConnectScript", om.valueToTree(this.getAfterConnectScript()));
                }
                if (this.getCleanSourceMetadataOnMismatch() != null) {
                    data.set("cleanSourceMetadataOnMismatch", om.valueToTree(this.getCleanSourceMetadataOnMismatch()));
                }
                if (this.getEventsPollInterval() != null) {
                    data.set("eventsPollInterval", om.valueToTree(this.getEventsPollInterval()));
                }
                if (this.getMaxFileSize() != null) {
                    data.set("maxFileSize", om.valueToTree(this.getMaxFileSize()));
                }
                if (this.getParallelLoadThreads() != null) {
                    data.set("parallelLoadThreads", om.valueToTree(this.getParallelLoadThreads()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getServerTimezone() != null) {
                    data.set("serverTimezone", om.valueToTree(this.getServerTimezone()));
                }
                if (this.getTargetDbType() != null) {
                    data.set("targetDbType", om.valueToTree(this.getTargetDbType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.MySqlSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MySqlSettingsProperty.Jsii$Proxy that = (MySqlSettingsProperty.Jsii$Proxy) o;

                if (this.afterConnectScript != null ? !this.afterConnectScript.equals(that.afterConnectScript) : that.afterConnectScript != null) return false;
                if (this.cleanSourceMetadataOnMismatch != null ? !this.cleanSourceMetadataOnMismatch.equals(that.cleanSourceMetadataOnMismatch) : that.cleanSourceMetadataOnMismatch != null) return false;
                if (this.eventsPollInterval != null ? !this.eventsPollInterval.equals(that.eventsPollInterval) : that.eventsPollInterval != null) return false;
                if (this.maxFileSize != null ? !this.maxFileSize.equals(that.maxFileSize) : that.maxFileSize != null) return false;
                if (this.parallelLoadThreads != null ? !this.parallelLoadThreads.equals(that.parallelLoadThreads) : that.parallelLoadThreads != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                if (this.serverTimezone != null ? !this.serverTimezone.equals(that.serverTimezone) : that.serverTimezone != null) return false;
                return this.targetDbType != null ? this.targetDbType.equals(that.targetDbType) : that.targetDbType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.afterConnectScript != null ? this.afterConnectScript.hashCode() : 0;
                result = 31 * result + (this.cleanSourceMetadataOnMismatch != null ? this.cleanSourceMetadataOnMismatch.hashCode() : 0);
                result = 31 * result + (this.eventsPollInterval != null ? this.eventsPollInterval.hashCode() : 0);
                result = 31 * result + (this.maxFileSize != null ? this.maxFileSize.hashCode() : 0);
                result = 31 * result + (this.parallelLoadThreads != null ? this.parallelLoadThreads.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.serverTimezone != null ? this.serverTimezone.hashCode() : 0);
                result = 31 * result + (this.targetDbType != null ? this.targetDbType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines an Amazon Neptune endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying endpoint settings for Amazon Neptune as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * NeptuneSettingsProperty neptuneSettingsProperty = NeptuneSettingsProperty.builder()
     *         .errorRetryDuration(123)
     *         .iamAuthEnabled(false)
     *         .maxFileSize(123)
     *         .maxRetryCount(123)
     *         .s3BucketFolder("s3BucketFolder")
     *         .s3BucketName("s3BucketName")
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.NeptuneSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(NeptuneSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NeptuneSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of milliseconds for AWS DMS to wait to retry a bulk-load of migrated graph data to the Neptune target database before raising an error.
         * <p>
         * The default is 250.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-errorretryduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-errorretryduration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorRetryDuration() {
            return null;
        }

        /**
         * If you want IAM authorization enabled for this endpoint, set this parameter to <code>true</code> .
         * <p>
         * Then attach the appropriate IAM policy document to your service role specified by <code>ServiceAccessRoleArn</code> . The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-iamauthenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-iamauthenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIamAuthEnabled() {
            return null;
        }

        /**
         * The maximum size in kilobytes of migrated graph data stored in a .csv file before AWS DMS bulk-loads the data to the Neptune target database. The default is 1,048,576 KB. If the bulk load is successful, AWS DMS clears the bucket, ready to store the next batch of migrated graph data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-maxfilesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-maxfilesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFileSize() {
            return null;
        }

        /**
         * The number of times for AWS DMS to retry a bulk load of migrated graph data to the Neptune target database before raising an error.
         * <p>
         * The default is 5.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-maxretrycount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-maxretrycount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetryCount() {
            return null;
        }

        /**
         * A folder path where you want AWS DMS to store migrated graph data in the S3 bucket specified by <code>S3BucketName</code>.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-s3bucketfolder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-s3bucketfolder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketFolder() {
            return null;
        }

        /**
         * The name of the Amazon S3 bucket where AWS DMS can temporarily store migrated graph data in .csv files before bulk-loading it to the Neptune target database. AWS DMS maps the SQL source data to graph data before storing it in these .csv files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-s3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketName() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the service role that you created for the Neptune target endpoint.
         * <p>
         * The role must allow the <code>iam:PassRole</code> action.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole">Creating an IAM Service Role for Accessing Amazon Neptune as a Target</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-serviceaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-serviceaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NeptuneSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NeptuneSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NeptuneSettingsProperty> {
            java.lang.Number errorRetryDuration;
            java.lang.Object iamAuthEnabled;
            java.lang.Number maxFileSize;
            java.lang.Number maxRetryCount;
            java.lang.String s3BucketFolder;
            java.lang.String s3BucketName;
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getErrorRetryDuration}
             * @param errorRetryDuration The number of milliseconds for AWS DMS to wait to retry a bulk-load of migrated graph data to the Neptune target database before raising an error.
             *                           The default is 250.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorRetryDuration(java.lang.Number errorRetryDuration) {
                this.errorRetryDuration = errorRetryDuration;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getIamAuthEnabled}
             * @param iamAuthEnabled If you want IAM authorization enabled for this endpoint, set this parameter to <code>true</code> .
             *                       Then attach the appropriate IAM policy document to your service role specified by <code>ServiceAccessRoleArn</code> . The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamAuthEnabled(java.lang.Boolean iamAuthEnabled) {
                this.iamAuthEnabled = iamAuthEnabled;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getIamAuthEnabled}
             * @param iamAuthEnabled If you want IAM authorization enabled for this endpoint, set this parameter to <code>true</code> .
             *                       Then attach the appropriate IAM policy document to your service role specified by <code>ServiceAccessRoleArn</code> . The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamAuthEnabled(software.amazon.awscdk.IResolvable iamAuthEnabled) {
                this.iamAuthEnabled = iamAuthEnabled;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getMaxFileSize}
             * @param maxFileSize The maximum size in kilobytes of migrated graph data stored in a .csv file before AWS DMS bulk-loads the data to the Neptune target database. The default is 1,048,576 KB. If the bulk load is successful, AWS DMS clears the bucket, ready to store the next batch of migrated graph data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFileSize(java.lang.Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getMaxRetryCount}
             * @param maxRetryCount The number of times for AWS DMS to retry a bulk load of migrated graph data to the Neptune target database before raising an error.
             *                      The default is 5.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRetryCount(java.lang.Number maxRetryCount) {
                this.maxRetryCount = maxRetryCount;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getS3BucketFolder}
             * @param s3BucketFolder A folder path where you want AWS DMS to store migrated graph data in the S3 bucket specified by <code>S3BucketName</code>.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketFolder(java.lang.String s3BucketFolder) {
                this.s3BucketFolder = s3BucketFolder;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getS3BucketName}
             * @param s3BucketName The name of the Amazon S3 bucket where AWS DMS can temporarily store migrated graph data in .csv files before bulk-loading it to the Neptune target database. AWS DMS maps the SQL source data to graph data before storing it in these .csv files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn The Amazon Resource Name (ARN) of the service role that you created for the Neptune target endpoint.
             *                             The role must allow the <code>iam:PassRole</code> action.
             *                             <p>
             *                             For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole">Creating an IAM Service Role for Accessing Amazon Neptune as a Target</a> in the <em>AWS Database Migration Service User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NeptuneSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NeptuneSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NeptuneSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NeptuneSettingsProperty {
            private final java.lang.Number errorRetryDuration;
            private final java.lang.Object iamAuthEnabled;
            private final java.lang.Number maxFileSize;
            private final java.lang.Number maxRetryCount;
            private final java.lang.String s3BucketFolder;
            private final java.lang.String s3BucketName;
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorRetryDuration = software.amazon.jsii.Kernel.get(this, "errorRetryDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.iamAuthEnabled = software.amazon.jsii.Kernel.get(this, "iamAuthEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxFileSize = software.amazon.jsii.Kernel.get(this, "maxFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxRetryCount = software.amazon.jsii.Kernel.get(this, "maxRetryCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.s3BucketFolder = software.amazon.jsii.Kernel.get(this, "s3BucketFolder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorRetryDuration = builder.errorRetryDuration;
                this.iamAuthEnabled = builder.iamAuthEnabled;
                this.maxFileSize = builder.maxFileSize;
                this.maxRetryCount = builder.maxRetryCount;
                this.s3BucketFolder = builder.s3BucketFolder;
                this.s3BucketName = builder.s3BucketName;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.Number getErrorRetryDuration() {
                return this.errorRetryDuration;
            }

            @Override
            public final java.lang.Object getIamAuthEnabled() {
                return this.iamAuthEnabled;
            }

            @Override
            public final java.lang.Number getMaxFileSize() {
                return this.maxFileSize;
            }

            @Override
            public final java.lang.Number getMaxRetryCount() {
                return this.maxRetryCount;
            }

            @Override
            public final java.lang.String getS3BucketFolder() {
                return this.s3BucketFolder;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getErrorRetryDuration() != null) {
                    data.set("errorRetryDuration", om.valueToTree(this.getErrorRetryDuration()));
                }
                if (this.getIamAuthEnabled() != null) {
                    data.set("iamAuthEnabled", om.valueToTree(this.getIamAuthEnabled()));
                }
                if (this.getMaxFileSize() != null) {
                    data.set("maxFileSize", om.valueToTree(this.getMaxFileSize()));
                }
                if (this.getMaxRetryCount() != null) {
                    data.set("maxRetryCount", om.valueToTree(this.getMaxRetryCount()));
                }
                if (this.getS3BucketFolder() != null) {
                    data.set("s3BucketFolder", om.valueToTree(this.getS3BucketFolder()));
                }
                if (this.getS3BucketName() != null) {
                    data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.NeptuneSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NeptuneSettingsProperty.Jsii$Proxy that = (NeptuneSettingsProperty.Jsii$Proxy) o;

                if (this.errorRetryDuration != null ? !this.errorRetryDuration.equals(that.errorRetryDuration) : that.errorRetryDuration != null) return false;
                if (this.iamAuthEnabled != null ? !this.iamAuthEnabled.equals(that.iamAuthEnabled) : that.iamAuthEnabled != null) return false;
                if (this.maxFileSize != null ? !this.maxFileSize.equals(that.maxFileSize) : that.maxFileSize != null) return false;
                if (this.maxRetryCount != null ? !this.maxRetryCount.equals(that.maxRetryCount) : that.maxRetryCount != null) return false;
                if (this.s3BucketFolder != null ? !this.s3BucketFolder.equals(that.s3BucketFolder) : that.s3BucketFolder != null) return false;
                if (this.s3BucketName != null ? !this.s3BucketName.equals(that.s3BucketName) : that.s3BucketName != null) return false;
                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorRetryDuration != null ? this.errorRetryDuration.hashCode() : 0;
                result = 31 * result + (this.iamAuthEnabled != null ? this.iamAuthEnabled.hashCode() : 0);
                result = 31 * result + (this.maxFileSize != null ? this.maxFileSize.hashCode() : 0);
                result = 31 * result + (this.maxRetryCount != null ? this.maxRetryCount.hashCode() : 0);
                result = 31 * result + (this.s3BucketFolder != null ? this.s3BucketFolder.hashCode() : 0);
                result = 31 * result + (this.s3BucketName != null ? this.s3BucketName.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines an Oracle endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * OracleSettingsProperty oracleSettingsProperty = OracleSettingsProperty.builder()
     *         .accessAlternateDirectly(false)
     *         .additionalArchivedLogDestId(123)
     *         .addSupplementalLogging(false)
     *         .allowSelectNestedTables(false)
     *         .archivedLogDestId(123)
     *         .archivedLogsOnly(false)
     *         .asmPassword("asmPassword")
     *         .asmServer("asmServer")
     *         .asmUser("asmUser")
     *         .charLengthSemantics("charLengthSemantics")
     *         .directPathNoLog(false)
     *         .directPathParallelLoad(false)
     *         .enableHomogenousTablespace(false)
     *         .extraArchivedLogDestIds(List.of(123))
     *         .failTasksOnLobTruncation(false)
     *         .numberDatatypeScale(123)
     *         .oraclePathPrefix("oraclePathPrefix")
     *         .parallelAsmReadThreads(123)
     *         .readAheadBlocks(123)
     *         .readTableSpaceName(false)
     *         .replacePathPrefix(false)
     *         .retryInterval(123)
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
     *         .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .securityDbEncryption("securityDbEncryption")
     *         .securityDbEncryptionName("securityDbEncryptionName")
     *         .spatialDataOptionToGeoJsonFunctionName("spatialDataOptionToGeoJsonFunctionName")
     *         .standbyDelayTime(123)
     *         .useAlternateFolderForOnline(false)
     *         .useBFile(false)
     *         .useDirectPathFullLoad(false)
     *         .useLogminerReader(false)
     *         .usePathPrefix("usePathPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.OracleSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(OracleSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OracleSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Set this attribute to <code>false</code> in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
         * <p>
         * This tells the DMS instance to not access redo logs through any specified path prefix replacement using direct file access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-accessalternatedirectly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-accessalternatedirectly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessAlternateDirectly() {
            return null;
        }

        /**
         * Set this attribute with <code>ArchivedLogDestId</code> in a primary/ standby setup.
         * <p>
         * This attribute is useful in the case of a switchover. In this case, AWS DMS needs to know which destination to get archive redo logs from to read changes. This need arises because the previous primary instance is now a standby instance after switchover.
         * <p>
         * Although AWS DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use <code>RESETLOGS</code> unless necessary. For additional information about <code>RESETLOGS</code> , see <a href="https://docs.aws.amazon.com/https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B">RMAN Data Repair Concepts</a> in the <em>Oracle Database Backup and Recovery User's Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-additionalarchivedlogdestid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-additionalarchivedlogdestid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAdditionalArchivedLogDestId() {
            return null;
        }

        /**
         * Set this attribute to set up table-level supplemental logging for the Oracle database.
         * <p>
         * This attribute enables PRIMARY KEY supplemental logging on all tables selected for a migration task.
         * <p>
         * If you use this option, you still need to enable database-level supplemental logging.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-addsupplementallogging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-addsupplementallogging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddSupplementalLogging() {
            return null;
        }

        /**
         * Set this attribute to <code>true</code> to enable replication of Oracle tables containing columns that are nested tables or defined types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-allowselectnestedtables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-allowselectnestedtables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowSelectNestedTables() {
            return null;
        }

        /**
         * Specifies the ID of the destination for the archived redo logs.
         * <p>
         * This value should be the same as a number in the dest_id column of the v$archived_log view. If you work with an additional redo log destination, use the <code>AdditionalArchivedLogDestId</code> option to specify the additional destination ID. Doing this improves performance by ensuring that the correct logs are accessed from the outset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-archivedlogdestid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-archivedlogdestid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getArchivedLogDestId() {
            return null;
        }

        /**
         * When this field is set to <code>True</code> , AWS DMS only accesses the archived redo logs.
         * <p>
         * If the archived redo logs are stored on Automatic Storage Management (ASM) only, the AWS DMS user account needs to be granted ASM privileges.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-archivedlogsonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-archivedlogsonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArchivedLogsOnly() {
            return null;
        }

        /**
         * For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password.
         * <p>
         * You can set this value from the <code>*asm_user_password*</code> value. You set this value as part of the comma-separated value that you set to the <code>Password</code> request parameter when you create the endpoint to access transaction logs using Binary Reader. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-asmpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-asmpassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAsmPassword() {
            return null;
        }

        /**
         * For an Oracle source endpoint, your ASM server address.
         * <p>
         * You can set this value from the <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-asmserver">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-asmserver</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAsmServer() {
            return null;
        }

        /**
         * For an Oracle source endpoint, your ASM user name.
         * <p>
         * You can set this value from the <code>asm_user</code> value. You set <code>asm_user</code> as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-asmuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-asmuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAsmUser() {
            return null;
        }

        /**
         * Specifies whether the length of a character column is in bytes or in characters.
         * <p>
         * To indicate that the character column length is in characters, set this attribute to <code>CHAR</code> . Otherwise, the character column length is in bytes.
         * <p>
         * Example: <code>charLengthSemantics=CHAR;</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-charlengthsemantics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-charlengthsemantics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCharLengthSemantics() {
            return null;
        }

        /**
         * When set to <code>true</code> , this attribute helps to increase the commit rate on the Oracle target database by writing directly to tables and not writing a trail to database logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-directpathnolog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-directpathnolog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDirectPathNoLog() {
            return null;
        }

        /**
         * When set to <code>true</code> , this attribute specifies a parallel load when <code>useDirectPathFullLoad</code> is set to <code>Y</code> .
         * <p>
         * This attribute also only applies when you use the AWS DMS parallel load feature. Note that the target table cannot have any constraints or indexes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-directpathparallelload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-directpathparallelload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDirectPathParallelLoad() {
            return null;
        }

        /**
         * Set this attribute to enable homogenous tablespace replication and create existing tables or indexes under the same tablespace on the target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-enablehomogenoustablespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-enablehomogenoustablespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableHomogenousTablespace() {
            return null;
        }

        /**
         * Specifies the IDs of one more destinations for one or more archived redo logs.
         * <p>
         * These IDs are the values of the <code>dest_id</code> column in the <code>v$archived_log</code> view. Use this setting with the <code>archivedLogDestId</code> extra connection attribute in a primary-to-single setup or a primary-to-multiple-standby setup.
         * <p>
         * This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this case, AWS DMS needs information about what destination to get archive redo logs from to read changes. AWS DMS needs this because after the switchover the previous primary is a standby instance. For example, in a primary-to-single standby setup you might apply the following settings.
         * <p>
         * <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
         * <p>
         * In a primary-to-multiple-standby setup, you might apply the following settings.
         * <p>
         * <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
         * <p>
         * Although AWS DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use <code>RESETLOGS</code> unless it's necessary. For more information about <code>RESETLOGS</code> , see <a href="https://docs.aws.amazon.com/https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B">RMAN Data Repair Concepts</a> in the <em>Oracle Database Backup and Recovery User's Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-extraarchivedlogdestids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-extraarchivedlogdestids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtraArchivedLogDestIds() {
            return null;
        }

        /**
         * When set to <code>true</code> , this attribute causes a task to fail if the actual size of an LOB column is greater than the specified <code>LobMaxSize</code> .
         * <p>
         * If a task is set to limited LOB mode and this option is set to <code>true</code> , the task fails instead of truncating the LOB data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-failtasksonlobtruncation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-failtasksonlobtruncation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailTasksOnLobTruncation() {
            return null;
        }

        /**
         * Specifies the number scale.
         * <p>
         * You can select a scale up to 38, or you can select FLOAT. By default, the NUMBER data type is converted to precision 38, scale 10.
         * <p>
         * Example: <code>numberDataTypeScale=12</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-numberdatatypescale">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-numberdatatypescale</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberDatatypeScale() {
            return null;
        }

        /**
         * Set this string attribute to the required value in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
         * <p>
         * This value specifies the default Oracle root used to access the redo logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-oraclepathprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-oraclepathprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOraclePathPrefix() {
            return null;
        }

        /**
         * Set this attribute to change the number of threads that DMS configures to perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM).
         * <p>
         * You can specify an integer value between 2 (the default) and 8 (the maximum). Use this attribute together with the <code>readAheadBlocks</code> attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-parallelasmreadthreads">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-parallelasmreadthreads</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParallelAsmReadThreads() {
            return null;
        }

        /**
         * Set this attribute to change the number of read-ahead blocks that DMS configures to perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM).
         * <p>
         * You can specify an integer value between 1000 (the default) and 200,000 (the maximum).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-readaheadblocks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-readaheadblocks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getReadAheadBlocks() {
            return null;
        }

        /**
         * When set to <code>true</code> , this attribute supports tablespace replication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-readtablespacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-readtablespacename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadTableSpaceName() {
            return null;
        }

        /**
         * Set this attribute to true in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
         * <p>
         * This setting tells DMS instance to replace the default Oracle root with the specified <code>usePathPrefix</code> setting to access the redo logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-replacepathprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-replacepathprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReplacePathPrefix() {
            return null;
        }

        /**
         * Specifies the number of seconds that the system waits before resending a query.
         * <p>
         * Example: <code>retryInterval=6;</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-retryinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-retryinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetryInterval() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the Oracle endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * Required only if your Oracle endpoint uses Advanced Storage Manager (ASM).
         * <p>
         * The full ARN of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the <code>SecretsManagerOracleAsmSecret</code> . This <code>SecretsManagerOracleAsmSecret</code> has the secret value that allows access to the Oracle ASM of the endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerOracleAsmSecretId</code> . Or you can specify clear-text values for <code>AsmUser</code> , <code>AsmPassword</code> , and <code>AsmServerName</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerOracleAsmSecret</code> , the corresponding <code>SecretsManagerOracleAsmAccessRoleArn</code> , and the <code>SecretsManagerOracleAsmSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-secretsmanageroracleasmaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-secretsmanageroracleasmaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerOracleAsmAccessRoleArn() {
            return null;
        }

        /**
         * Required only if your Oracle endpoint uses Advanced Storage Manager (ASM).
         * <p>
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerOracleAsmSecret</code> that contains the Oracle ASM connection details for the Oracle endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-secretsmanageroracleasmsecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-secretsmanageroracleasmsecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerOracleAsmSecretId() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the Oracle endpoint connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * For an Oracle source endpoint, the transparent data encryption (TDE) password required by AWM DMS to access Oracle redo logs encrypted by TDE using Binary Reader.
         * <p>
         * It is also the <code>*TDE_Password*</code> part of the comma-separated value you set to the <code>Password</code> request parameter when you create the endpoint. The <code>SecurityDbEncryptian</code> setting is related to this <code>SecurityDbEncryptionName</code> setting. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption">Supported encryption methods for using Oracle as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-securitydbencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-securitydbencryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityDbEncryption() {
            return null;
        }

        /**
         * For an Oracle source endpoint, the name of a key used for the transparent data encryption (TDE) of the columns and tablespaces in an Oracle source database that is encrypted using TDE.
         * <p>
         * The key value is the value of the <code>SecurityDbEncryption</code> setting. For more information on setting the key name value of <code>SecurityDbEncryptionName</code> , see the information and example for setting the <code>securityDbEncryptionName</code> extra connection attribute in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption">Supported encryption methods for using Oracle as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-securitydbencryptionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-securitydbencryptionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityDbEncryptionName() {
            return null;
        }

        /**
         * Use this attribute to convert <code>SDO_GEOMETRY</code> to <code>GEOJSON</code> format.
         * <p>
         * By default, DMS calls the <code>SDO2GEOJSON</code> custom function if present and accessible. Or you can create your own custom function that mimics the operation of <code>SDOGEOJSON</code> and set <code>SpatialDataOptionToGeoJsonFunctionName</code> to call it instead.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-spatialdataoptiontogeojsonfunctionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-spatialdataoptiontogeojsonfunctionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpatialDataOptionToGeoJsonFunctionName() {
            return null;
        }

        /**
         * Use this attribute to specify a time in minutes for the delay in standby sync.
         * <p>
         * If the source is an Oracle Active Data Guard standby database, use this attribute to specify the time lag between primary and standby databases.
         * <p>
         * In AWS DMS , you can create an Oracle CDC task that uses an Active Data Guard standby instance as a source for replicating ongoing changes. Doing this eliminates the need to connect to an active database that might be in production.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-standbydelaytime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-standbydelaytime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStandbyDelayTime() {
            return null;
        }

        /**
         * Set this attribute to <code>true</code> in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
         * <p>
         * This tells the DMS instance to use any specified prefix replacement to access all online redo logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-usealternatefolderforonline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-usealternatefolderforonline</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseAlternateFolderForOnline() {
            return null;
        }

        /**
         * Set this attribute to True to capture change data using the Binary Reader utility.
         * <p>
         * Set <code>UseLogminerReader</code> to False to set this attribute to True. To use Binary Reader with Amazon RDS for Oracle as the source, you set additional attributes. For more information about using this setting with Oracle Automatic Storage Management (ASM), see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC">Using Oracle LogMiner or AWS DMS Binary Reader for CDC</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-usebfile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-usebfile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseBFile() {
            return null;
        }

        /**
         * Set this attribute to True to have AWS DMS use a direct path full load.
         * <p>
         * Specify this value to use the direct path protocol in the Oracle Call Interface (OCI). By using this OCI protocol, you can bulk-load Oracle target tables during a full load.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-usedirectpathfullload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-usedirectpathfullload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseDirectPathFullLoad() {
            return null;
        }

        /**
         * Set this attribute to True to capture change data using the Oracle LogMiner utility (the default).
         * <p>
         * Set this attribute to False if you want to access the redo logs as a binary file. When you set <code>UseLogminerReader</code> to False, also set <code>UseBfile</code> to True. For more information on this setting and using Oracle ASM, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC">Using Oracle LogMiner or AWS DMS Binary Reader for CDC</a> in the <em>AWS DMS User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-uselogminerreader">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-uselogminerreader</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseLogminerReader() {
            return null;
        }

        /**
         * Set this string attribute to the required value in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
         * <p>
         * This value specifies the path prefix used to replace the default Oracle root to access the redo logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-usepathprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-oraclesettings.html#cfn-dms-endpoint-oraclesettings-usepathprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsePathPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OracleSettingsProperty> {
            java.lang.Object accessAlternateDirectly;
            java.lang.Number additionalArchivedLogDestId;
            java.lang.Object addSupplementalLogging;
            java.lang.Object allowSelectNestedTables;
            java.lang.Number archivedLogDestId;
            java.lang.Object archivedLogsOnly;
            java.lang.String asmPassword;
            java.lang.String asmServer;
            java.lang.String asmUser;
            java.lang.String charLengthSemantics;
            java.lang.Object directPathNoLog;
            java.lang.Object directPathParallelLoad;
            java.lang.Object enableHomogenousTablespace;
            java.lang.Object extraArchivedLogDestIds;
            java.lang.Object failTasksOnLobTruncation;
            java.lang.Number numberDatatypeScale;
            java.lang.String oraclePathPrefix;
            java.lang.Number parallelAsmReadThreads;
            java.lang.Number readAheadBlocks;
            java.lang.Object readTableSpaceName;
            java.lang.Object replacePathPrefix;
            java.lang.Number retryInterval;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerOracleAsmAccessRoleArn;
            java.lang.String secretsManagerOracleAsmSecretId;
            java.lang.String secretsManagerSecretId;
            java.lang.String securityDbEncryption;
            java.lang.String securityDbEncryptionName;
            java.lang.String spatialDataOptionToGeoJsonFunctionName;
            java.lang.Number standbyDelayTime;
            java.lang.Object useAlternateFolderForOnline;
            java.lang.Object useBFile;
            java.lang.Object useDirectPathFullLoad;
            java.lang.Object useLogminerReader;
            java.lang.String usePathPrefix;

            /**
             * Sets the value of {@link OracleSettingsProperty#getAccessAlternateDirectly}
             * @param accessAlternateDirectly Set this attribute to <code>false</code> in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
             *                                This tells the DMS instance to not access redo logs through any specified path prefix replacement using direct file access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessAlternateDirectly(java.lang.Boolean accessAlternateDirectly) {
                this.accessAlternateDirectly = accessAlternateDirectly;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getAccessAlternateDirectly}
             * @param accessAlternateDirectly Set this attribute to <code>false</code> in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
             *                                This tells the DMS instance to not access redo logs through any specified path prefix replacement using direct file access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessAlternateDirectly(software.amazon.awscdk.IResolvable accessAlternateDirectly) {
                this.accessAlternateDirectly = accessAlternateDirectly;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getAdditionalArchivedLogDestId}
             * @param additionalArchivedLogDestId Set this attribute with <code>ArchivedLogDestId</code> in a primary/ standby setup.
             *                                    This attribute is useful in the case of a switchover. In this case, AWS DMS needs to know which destination to get archive redo logs from to read changes. This need arises because the previous primary instance is now a standby instance after switchover.
             *                                    <p>
             *                                    Although AWS DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use <code>RESETLOGS</code> unless necessary. For additional information about <code>RESETLOGS</code> , see <a href="https://docs.aws.amazon.com/https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B">RMAN Data Repair Concepts</a> in the <em>Oracle Database Backup and Recovery User's Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalArchivedLogDestId(java.lang.Number additionalArchivedLogDestId) {
                this.additionalArchivedLogDestId = additionalArchivedLogDestId;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getAddSupplementalLogging}
             * @param addSupplementalLogging Set this attribute to set up table-level supplemental logging for the Oracle database.
             *                               This attribute enables PRIMARY KEY supplemental logging on all tables selected for a migration task.
             *                               <p>
             *                               If you use this option, you still need to enable database-level supplemental logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addSupplementalLogging(java.lang.Boolean addSupplementalLogging) {
                this.addSupplementalLogging = addSupplementalLogging;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getAddSupplementalLogging}
             * @param addSupplementalLogging Set this attribute to set up table-level supplemental logging for the Oracle database.
             *                               This attribute enables PRIMARY KEY supplemental logging on all tables selected for a migration task.
             *                               <p>
             *                               If you use this option, you still need to enable database-level supplemental logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addSupplementalLogging(software.amazon.awscdk.IResolvable addSupplementalLogging) {
                this.addSupplementalLogging = addSupplementalLogging;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getAllowSelectNestedTables}
             * @param allowSelectNestedTables Set this attribute to <code>true</code> to enable replication of Oracle tables containing columns that are nested tables or defined types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowSelectNestedTables(java.lang.Boolean allowSelectNestedTables) {
                this.allowSelectNestedTables = allowSelectNestedTables;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getAllowSelectNestedTables}
             * @param allowSelectNestedTables Set this attribute to <code>true</code> to enable replication of Oracle tables containing columns that are nested tables or defined types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowSelectNestedTables(software.amazon.awscdk.IResolvable allowSelectNestedTables) {
                this.allowSelectNestedTables = allowSelectNestedTables;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getArchivedLogDestId}
             * @param archivedLogDestId Specifies the ID of the destination for the archived redo logs.
             *                          This value should be the same as a number in the dest_id column of the v$archived_log view. If you work with an additional redo log destination, use the <code>AdditionalArchivedLogDestId</code> option to specify the additional destination ID. Doing this improves performance by ensuring that the correct logs are accessed from the outset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archivedLogDestId(java.lang.Number archivedLogDestId) {
                this.archivedLogDestId = archivedLogDestId;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getArchivedLogsOnly}
             * @param archivedLogsOnly When this field is set to <code>True</code> , AWS DMS only accesses the archived redo logs.
             *                         If the archived redo logs are stored on Automatic Storage Management (ASM) only, the AWS DMS user account needs to be granted ASM privileges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archivedLogsOnly(java.lang.Boolean archivedLogsOnly) {
                this.archivedLogsOnly = archivedLogsOnly;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getArchivedLogsOnly}
             * @param archivedLogsOnly When this field is set to <code>True</code> , AWS DMS only accesses the archived redo logs.
             *                         If the archived redo logs are stored on Automatic Storage Management (ASM) only, the AWS DMS user account needs to be granted ASM privileges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archivedLogsOnly(software.amazon.awscdk.IResolvable archivedLogsOnly) {
                this.archivedLogsOnly = archivedLogsOnly;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getAsmPassword}
             * @param asmPassword For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password.
             *                    You can set this value from the <code>*asm_user_password*</code> value. You set this value as part of the comma-separated value that you set to the <code>Password</code> request parameter when you create the endpoint to access transaction logs using Binary Reader. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder asmPassword(java.lang.String asmPassword) {
                this.asmPassword = asmPassword;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getAsmServer}
             * @param asmServer For an Oracle source endpoint, your ASM server address.
             *                  You can set this value from the <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder asmServer(java.lang.String asmServer) {
                this.asmServer = asmServer;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getAsmUser}
             * @param asmUser For an Oracle source endpoint, your ASM user name.
             *                You can set this value from the <code>asm_user</code> value. You set <code>asm_user</code> as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder asmUser(java.lang.String asmUser) {
                this.asmUser = asmUser;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getCharLengthSemantics}
             * @param charLengthSemantics Specifies whether the length of a character column is in bytes or in characters.
             *                            To indicate that the character column length is in characters, set this attribute to <code>CHAR</code> . Otherwise, the character column length is in bytes.
             *                            <p>
             *                            Example: <code>charLengthSemantics=CHAR;</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder charLengthSemantics(java.lang.String charLengthSemantics) {
                this.charLengthSemantics = charLengthSemantics;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getDirectPathNoLog}
             * @param directPathNoLog When set to <code>true</code> , this attribute helps to increase the commit rate on the Oracle target database by writing directly to tables and not writing a trail to database logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directPathNoLog(java.lang.Boolean directPathNoLog) {
                this.directPathNoLog = directPathNoLog;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getDirectPathNoLog}
             * @param directPathNoLog When set to <code>true</code> , this attribute helps to increase the commit rate on the Oracle target database by writing directly to tables and not writing a trail to database logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directPathNoLog(software.amazon.awscdk.IResolvable directPathNoLog) {
                this.directPathNoLog = directPathNoLog;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getDirectPathParallelLoad}
             * @param directPathParallelLoad When set to <code>true</code> , this attribute specifies a parallel load when <code>useDirectPathFullLoad</code> is set to <code>Y</code> .
             *                               This attribute also only applies when you use the AWS DMS parallel load feature. Note that the target table cannot have any constraints or indexes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directPathParallelLoad(java.lang.Boolean directPathParallelLoad) {
                this.directPathParallelLoad = directPathParallelLoad;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getDirectPathParallelLoad}
             * @param directPathParallelLoad When set to <code>true</code> , this attribute specifies a parallel load when <code>useDirectPathFullLoad</code> is set to <code>Y</code> .
             *                               This attribute also only applies when you use the AWS DMS parallel load feature. Note that the target table cannot have any constraints or indexes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directPathParallelLoad(software.amazon.awscdk.IResolvable directPathParallelLoad) {
                this.directPathParallelLoad = directPathParallelLoad;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getEnableHomogenousTablespace}
             * @param enableHomogenousTablespace Set this attribute to enable homogenous tablespace replication and create existing tables or indexes under the same tablespace on the target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableHomogenousTablespace(java.lang.Boolean enableHomogenousTablespace) {
                this.enableHomogenousTablespace = enableHomogenousTablespace;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getEnableHomogenousTablespace}
             * @param enableHomogenousTablespace Set this attribute to enable homogenous tablespace replication and create existing tables or indexes under the same tablespace on the target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableHomogenousTablespace(software.amazon.awscdk.IResolvable enableHomogenousTablespace) {
                this.enableHomogenousTablespace = enableHomogenousTablespace;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getExtraArchivedLogDestIds}
             * @param extraArchivedLogDestIds Specifies the IDs of one more destinations for one or more archived redo logs.
             *                                These IDs are the values of the <code>dest_id</code> column in the <code>v$archived_log</code> view. Use this setting with the <code>archivedLogDestId</code> extra connection attribute in a primary-to-single setup or a primary-to-multiple-standby setup.
             *                                <p>
             *                                This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this case, AWS DMS needs information about what destination to get archive redo logs from to read changes. AWS DMS needs this because after the switchover the previous primary is a standby instance. For example, in a primary-to-single standby setup you might apply the following settings.
             *                                <p>
             *                                <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
             *                                <p>
             *                                In a primary-to-multiple-standby setup, you might apply the following settings.
             *                                <p>
             *                                <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
             *                                <p>
             *                                Although AWS DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use <code>RESETLOGS</code> unless it's necessary. For more information about <code>RESETLOGS</code> , see <a href="https://docs.aws.amazon.com/https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B">RMAN Data Repair Concepts</a> in the <em>Oracle Database Backup and Recovery User's Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraArchivedLogDestIds(software.amazon.awscdk.IResolvable extraArchivedLogDestIds) {
                this.extraArchivedLogDestIds = extraArchivedLogDestIds;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getExtraArchivedLogDestIds}
             * @param extraArchivedLogDestIds Specifies the IDs of one more destinations for one or more archived redo logs.
             *                                These IDs are the values of the <code>dest_id</code> column in the <code>v$archived_log</code> view. Use this setting with the <code>archivedLogDestId</code> extra connection attribute in a primary-to-single setup or a primary-to-multiple-standby setup.
             *                                <p>
             *                                This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this case, AWS DMS needs information about what destination to get archive redo logs from to read changes. AWS DMS needs this because after the switchover the previous primary is a standby instance. For example, in a primary-to-single standby setup you might apply the following settings.
             *                                <p>
             *                                <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
             *                                <p>
             *                                In a primary-to-multiple-standby setup, you might apply the following settings.
             *                                <p>
             *                                <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
             *                                <p>
             *                                Although AWS DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use <code>RESETLOGS</code> unless it's necessary. For more information about <code>RESETLOGS</code> , see <a href="https://docs.aws.amazon.com/https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B">RMAN Data Repair Concepts</a> in the <em>Oracle Database Backup and Recovery User's Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraArchivedLogDestIds(java.util.List<? extends java.lang.Number> extraArchivedLogDestIds) {
                this.extraArchivedLogDestIds = extraArchivedLogDestIds;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getFailTasksOnLobTruncation}
             * @param failTasksOnLobTruncation When set to <code>true</code> , this attribute causes a task to fail if the actual size of an LOB column is greater than the specified <code>LobMaxSize</code> .
             *                                 If a task is set to limited LOB mode and this option is set to <code>true</code> , the task fails instead of truncating the LOB data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failTasksOnLobTruncation(java.lang.Boolean failTasksOnLobTruncation) {
                this.failTasksOnLobTruncation = failTasksOnLobTruncation;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getFailTasksOnLobTruncation}
             * @param failTasksOnLobTruncation When set to <code>true</code> , this attribute causes a task to fail if the actual size of an LOB column is greater than the specified <code>LobMaxSize</code> .
             *                                 If a task is set to limited LOB mode and this option is set to <code>true</code> , the task fails instead of truncating the LOB data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failTasksOnLobTruncation(software.amazon.awscdk.IResolvable failTasksOnLobTruncation) {
                this.failTasksOnLobTruncation = failTasksOnLobTruncation;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getNumberDatatypeScale}
             * @param numberDatatypeScale Specifies the number scale.
             *                            You can select a scale up to 38, or you can select FLOAT. By default, the NUMBER data type is converted to precision 38, scale 10.
             *                            <p>
             *                            Example: <code>numberDataTypeScale=12</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberDatatypeScale(java.lang.Number numberDatatypeScale) {
                this.numberDatatypeScale = numberDatatypeScale;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getOraclePathPrefix}
             * @param oraclePathPrefix Set this string attribute to the required value in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
             *                         This value specifies the default Oracle root used to access the redo logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oraclePathPrefix(java.lang.String oraclePathPrefix) {
                this.oraclePathPrefix = oraclePathPrefix;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getParallelAsmReadThreads}
             * @param parallelAsmReadThreads Set this attribute to change the number of threads that DMS configures to perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM).
             *                               You can specify an integer value between 2 (the default) and 8 (the maximum). Use this attribute together with the <code>readAheadBlocks</code> attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelAsmReadThreads(java.lang.Number parallelAsmReadThreads) {
                this.parallelAsmReadThreads = parallelAsmReadThreads;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getReadAheadBlocks}
             * @param readAheadBlocks Set this attribute to change the number of read-ahead blocks that DMS configures to perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM).
             *                        You can specify an integer value between 1000 (the default) and 200,000 (the maximum).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readAheadBlocks(java.lang.Number readAheadBlocks) {
                this.readAheadBlocks = readAheadBlocks;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getReadTableSpaceName}
             * @param readTableSpaceName When set to <code>true</code> , this attribute supports tablespace replication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readTableSpaceName(java.lang.Boolean readTableSpaceName) {
                this.readTableSpaceName = readTableSpaceName;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getReadTableSpaceName}
             * @param readTableSpaceName When set to <code>true</code> , this attribute supports tablespace replication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readTableSpaceName(software.amazon.awscdk.IResolvable readTableSpaceName) {
                this.readTableSpaceName = readTableSpaceName;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getReplacePathPrefix}
             * @param replacePathPrefix Set this attribute to true in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
             *                          This setting tells DMS instance to replace the default Oracle root with the specified <code>usePathPrefix</code> setting to access the redo logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replacePathPrefix(java.lang.Boolean replacePathPrefix) {
                this.replacePathPrefix = replacePathPrefix;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getReplacePathPrefix}
             * @param replacePathPrefix Set this attribute to true in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
             *                          This setting tells DMS instance to replace the default Oracle root with the specified <code>usePathPrefix</code> setting to access the redo logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replacePathPrefix(software.amazon.awscdk.IResolvable replacePathPrefix) {
                this.replacePathPrefix = replacePathPrefix;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getRetryInterval}
             * @param retryInterval Specifies the number of seconds that the system waits before resending a query.
             *                      Example: <code>retryInterval=6;</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryInterval(java.lang.Number retryInterval) {
                this.retryInterval = retryInterval;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
             *                                    The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the Oracle endpoint.
             *                                    <p>
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
             *                                    <p>
             *                                    For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerOracleAsmAccessRoleArn}
             * @param secretsManagerOracleAsmAccessRoleArn Required only if your Oracle endpoint uses Advanced Storage Manager (ASM).
             *                                             The full ARN of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the <code>SecretsManagerOracleAsmSecret</code> . This <code>SecretsManagerOracleAsmSecret</code> has the secret value that allows access to the Oracle ASM of the endpoint.
             *                                             <p>
             *                                             <blockquote>
             *                                             <p>
             *                                             You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerOracleAsmSecretId</code> . Or you can specify clear-text values for <code>AsmUser</code> , <code>AsmPassword</code> , and <code>AsmServerName</code> . You can't specify both.
             *                                             <p>
             *                                             For more information on creating this <code>SecretsManagerOracleAsmSecret</code> , the corresponding <code>SecretsManagerOracleAsmAccessRoleArn</code> , and the <code>SecretsManagerOracleAsmSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                             <p>
             *                                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerOracleAsmAccessRoleArn(java.lang.String secretsManagerOracleAsmAccessRoleArn) {
                this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerOracleAsmSecretId}
             * @param secretsManagerOracleAsmSecretId Required only if your Oracle endpoint uses Advanced Storage Manager (ASM).
             *                                        The full ARN, partial ARN, or display name of the <code>SecretsManagerOracleAsmSecret</code> that contains the Oracle ASM connection details for the Oracle endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerOracleAsmSecretId(java.lang.String secretsManagerOracleAsmSecretId) {
                this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the Oracle endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecurityDbEncryption}
             * @param securityDbEncryption For an Oracle source endpoint, the transparent data encryption (TDE) password required by AWM DMS to access Oracle redo logs encrypted by TDE using Binary Reader.
             *                             It is also the <code>*TDE_Password*</code> part of the comma-separated value you set to the <code>Password</code> request parameter when you create the endpoint. The <code>SecurityDbEncryptian</code> setting is related to this <code>SecurityDbEncryptionName</code> setting. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption">Supported encryption methods for using Oracle as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityDbEncryption(java.lang.String securityDbEncryption) {
                this.securityDbEncryption = securityDbEncryption;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecurityDbEncryptionName}
             * @param securityDbEncryptionName For an Oracle source endpoint, the name of a key used for the transparent data encryption (TDE) of the columns and tablespaces in an Oracle source database that is encrypted using TDE.
             *                                 The key value is the value of the <code>SecurityDbEncryption</code> setting. For more information on setting the key name value of <code>SecurityDbEncryptionName</code> , see the information and example for setting the <code>securityDbEncryptionName</code> extra connection attribute in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption">Supported encryption methods for using Oracle as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityDbEncryptionName(java.lang.String securityDbEncryptionName) {
                this.securityDbEncryptionName = securityDbEncryptionName;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSpatialDataOptionToGeoJsonFunctionName}
             * @param spatialDataOptionToGeoJsonFunctionName Use this attribute to convert <code>SDO_GEOMETRY</code> to <code>GEOJSON</code> format.
             *                                               By default, DMS calls the <code>SDO2GEOJSON</code> custom function if present and accessible. Or you can create your own custom function that mimics the operation of <code>SDOGEOJSON</code> and set <code>SpatialDataOptionToGeoJsonFunctionName</code> to call it instead.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spatialDataOptionToGeoJsonFunctionName(java.lang.String spatialDataOptionToGeoJsonFunctionName) {
                this.spatialDataOptionToGeoJsonFunctionName = spatialDataOptionToGeoJsonFunctionName;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getStandbyDelayTime}
             * @param standbyDelayTime Use this attribute to specify a time in minutes for the delay in standby sync.
             *                         If the source is an Oracle Active Data Guard standby database, use this attribute to specify the time lag between primary and standby databases.
             *                         <p>
             *                         In AWS DMS , you can create an Oracle CDC task that uses an Active Data Guard standby instance as a source for replicating ongoing changes. Doing this eliminates the need to connect to an active database that might be in production.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standbyDelayTime(java.lang.Number standbyDelayTime) {
                this.standbyDelayTime = standbyDelayTime;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getUseAlternateFolderForOnline}
             * @param useAlternateFolderForOnline Set this attribute to <code>true</code> in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
             *                                    This tells the DMS instance to use any specified prefix replacement to access all online redo logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useAlternateFolderForOnline(java.lang.Boolean useAlternateFolderForOnline) {
                this.useAlternateFolderForOnline = useAlternateFolderForOnline;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getUseAlternateFolderForOnline}
             * @param useAlternateFolderForOnline Set this attribute to <code>true</code> in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
             *                                    This tells the DMS instance to use any specified prefix replacement to access all online redo logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useAlternateFolderForOnline(software.amazon.awscdk.IResolvable useAlternateFolderForOnline) {
                this.useAlternateFolderForOnline = useAlternateFolderForOnline;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getUseBFile}
             * @param useBFile Set this attribute to True to capture change data using the Binary Reader utility.
             *                 Set <code>UseLogminerReader</code> to False to set this attribute to True. To use Binary Reader with Amazon RDS for Oracle as the source, you set additional attributes. For more information about using this setting with Oracle Automatic Storage Management (ASM), see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC">Using Oracle LogMiner or AWS DMS Binary Reader for CDC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBFile(java.lang.Boolean useBFile) {
                this.useBFile = useBFile;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getUseBFile}
             * @param useBFile Set this attribute to True to capture change data using the Binary Reader utility.
             *                 Set <code>UseLogminerReader</code> to False to set this attribute to True. To use Binary Reader with Amazon RDS for Oracle as the source, you set additional attributes. For more information about using this setting with Oracle Automatic Storage Management (ASM), see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC">Using Oracle LogMiner or AWS DMS Binary Reader for CDC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBFile(software.amazon.awscdk.IResolvable useBFile) {
                this.useBFile = useBFile;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getUseDirectPathFullLoad}
             * @param useDirectPathFullLoad Set this attribute to True to have AWS DMS use a direct path full load.
             *                              Specify this value to use the direct path protocol in the Oracle Call Interface (OCI). By using this OCI protocol, you can bulk-load Oracle target tables during a full load.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useDirectPathFullLoad(java.lang.Boolean useDirectPathFullLoad) {
                this.useDirectPathFullLoad = useDirectPathFullLoad;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getUseDirectPathFullLoad}
             * @param useDirectPathFullLoad Set this attribute to True to have AWS DMS use a direct path full load.
             *                              Specify this value to use the direct path protocol in the Oracle Call Interface (OCI). By using this OCI protocol, you can bulk-load Oracle target tables during a full load.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useDirectPathFullLoad(software.amazon.awscdk.IResolvable useDirectPathFullLoad) {
                this.useDirectPathFullLoad = useDirectPathFullLoad;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getUseLogminerReader}
             * @param useLogminerReader Set this attribute to True to capture change data using the Oracle LogMiner utility (the default).
             *                          Set this attribute to False if you want to access the redo logs as a binary file. When you set <code>UseLogminerReader</code> to False, also set <code>UseBfile</code> to True. For more information on this setting and using Oracle ASM, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC">Using Oracle LogMiner or AWS DMS Binary Reader for CDC</a> in the <em>AWS DMS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useLogminerReader(java.lang.Boolean useLogminerReader) {
                this.useLogminerReader = useLogminerReader;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getUseLogminerReader}
             * @param useLogminerReader Set this attribute to True to capture change data using the Oracle LogMiner utility (the default).
             *                          Set this attribute to False if you want to access the redo logs as a binary file. When you set <code>UseLogminerReader</code> to False, also set <code>UseBfile</code> to True. For more information on this setting and using Oracle ASM, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC">Using Oracle LogMiner or AWS DMS Binary Reader for CDC</a> in the <em>AWS DMS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useLogminerReader(software.amazon.awscdk.IResolvable useLogminerReader) {
                this.useLogminerReader = useLogminerReader;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getUsePathPrefix}
             * @param usePathPrefix Set this string attribute to the required value in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source.
             *                      This value specifies the path prefix used to replace the default Oracle root to access the redo logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usePathPrefix(java.lang.String usePathPrefix) {
                this.usePathPrefix = usePathPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OracleSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OracleSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OracleSettingsProperty {
            private final java.lang.Object accessAlternateDirectly;
            private final java.lang.Number additionalArchivedLogDestId;
            private final java.lang.Object addSupplementalLogging;
            private final java.lang.Object allowSelectNestedTables;
            private final java.lang.Number archivedLogDestId;
            private final java.lang.Object archivedLogsOnly;
            private final java.lang.String asmPassword;
            private final java.lang.String asmServer;
            private final java.lang.String asmUser;
            private final java.lang.String charLengthSemantics;
            private final java.lang.Object directPathNoLog;
            private final java.lang.Object directPathParallelLoad;
            private final java.lang.Object enableHomogenousTablespace;
            private final java.lang.Object extraArchivedLogDestIds;
            private final java.lang.Object failTasksOnLobTruncation;
            private final java.lang.Number numberDatatypeScale;
            private final java.lang.String oraclePathPrefix;
            private final java.lang.Number parallelAsmReadThreads;
            private final java.lang.Number readAheadBlocks;
            private final java.lang.Object readTableSpaceName;
            private final java.lang.Object replacePathPrefix;
            private final java.lang.Number retryInterval;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerOracleAsmAccessRoleArn;
            private final java.lang.String secretsManagerOracleAsmSecretId;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.String securityDbEncryption;
            private final java.lang.String securityDbEncryptionName;
            private final java.lang.String spatialDataOptionToGeoJsonFunctionName;
            private final java.lang.Number standbyDelayTime;
            private final java.lang.Object useAlternateFolderForOnline;
            private final java.lang.Object useBFile;
            private final java.lang.Object useDirectPathFullLoad;
            private final java.lang.Object useLogminerReader;
            private final java.lang.String usePathPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessAlternateDirectly = software.amazon.jsii.Kernel.get(this, "accessAlternateDirectly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.additionalArchivedLogDestId = software.amazon.jsii.Kernel.get(this, "additionalArchivedLogDestId", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.addSupplementalLogging = software.amazon.jsii.Kernel.get(this, "addSupplementalLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowSelectNestedTables = software.amazon.jsii.Kernel.get(this, "allowSelectNestedTables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.archivedLogDestId = software.amazon.jsii.Kernel.get(this, "archivedLogDestId", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.archivedLogsOnly = software.amazon.jsii.Kernel.get(this, "archivedLogsOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.asmPassword = software.amazon.jsii.Kernel.get(this, "asmPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.asmServer = software.amazon.jsii.Kernel.get(this, "asmServer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.asmUser = software.amazon.jsii.Kernel.get(this, "asmUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.charLengthSemantics = software.amazon.jsii.Kernel.get(this, "charLengthSemantics", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.directPathNoLog = software.amazon.jsii.Kernel.get(this, "directPathNoLog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.directPathParallelLoad = software.amazon.jsii.Kernel.get(this, "directPathParallelLoad", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableHomogenousTablespace = software.amazon.jsii.Kernel.get(this, "enableHomogenousTablespace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extraArchivedLogDestIds = software.amazon.jsii.Kernel.get(this, "extraArchivedLogDestIds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failTasksOnLobTruncation = software.amazon.jsii.Kernel.get(this, "failTasksOnLobTruncation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numberDatatypeScale = software.amazon.jsii.Kernel.get(this, "numberDatatypeScale", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.oraclePathPrefix = software.amazon.jsii.Kernel.get(this, "oraclePathPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parallelAsmReadThreads = software.amazon.jsii.Kernel.get(this, "parallelAsmReadThreads", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.readAheadBlocks = software.amazon.jsii.Kernel.get(this, "readAheadBlocks", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.readTableSpaceName = software.amazon.jsii.Kernel.get(this, "readTableSpaceName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.replacePathPrefix = software.amazon.jsii.Kernel.get(this, "replacePathPrefix", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryInterval = software.amazon.jsii.Kernel.get(this, "retryInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerOracleAsmAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerOracleAsmAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerOracleAsmSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerOracleAsmSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityDbEncryption = software.amazon.jsii.Kernel.get(this, "securityDbEncryption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityDbEncryptionName = software.amazon.jsii.Kernel.get(this, "securityDbEncryptionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.spatialDataOptionToGeoJsonFunctionName = software.amazon.jsii.Kernel.get(this, "spatialDataOptionToGeoJsonFunctionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.standbyDelayTime = software.amazon.jsii.Kernel.get(this, "standbyDelayTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.useAlternateFolderForOnline = software.amazon.jsii.Kernel.get(this, "useAlternateFolderForOnline", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useBFile = software.amazon.jsii.Kernel.get(this, "useBFile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useDirectPathFullLoad = software.amazon.jsii.Kernel.get(this, "useDirectPathFullLoad", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useLogminerReader = software.amazon.jsii.Kernel.get(this, "useLogminerReader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.usePathPrefix = software.amazon.jsii.Kernel.get(this, "usePathPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessAlternateDirectly = builder.accessAlternateDirectly;
                this.additionalArchivedLogDestId = builder.additionalArchivedLogDestId;
                this.addSupplementalLogging = builder.addSupplementalLogging;
                this.allowSelectNestedTables = builder.allowSelectNestedTables;
                this.archivedLogDestId = builder.archivedLogDestId;
                this.archivedLogsOnly = builder.archivedLogsOnly;
                this.asmPassword = builder.asmPassword;
                this.asmServer = builder.asmServer;
                this.asmUser = builder.asmUser;
                this.charLengthSemantics = builder.charLengthSemantics;
                this.directPathNoLog = builder.directPathNoLog;
                this.directPathParallelLoad = builder.directPathParallelLoad;
                this.enableHomogenousTablespace = builder.enableHomogenousTablespace;
                this.extraArchivedLogDestIds = builder.extraArchivedLogDestIds;
                this.failTasksOnLobTruncation = builder.failTasksOnLobTruncation;
                this.numberDatatypeScale = builder.numberDatatypeScale;
                this.oraclePathPrefix = builder.oraclePathPrefix;
                this.parallelAsmReadThreads = builder.parallelAsmReadThreads;
                this.readAheadBlocks = builder.readAheadBlocks;
                this.readTableSpaceName = builder.readTableSpaceName;
                this.replacePathPrefix = builder.replacePathPrefix;
                this.retryInterval = builder.retryInterval;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerOracleAsmAccessRoleArn = builder.secretsManagerOracleAsmAccessRoleArn;
                this.secretsManagerOracleAsmSecretId = builder.secretsManagerOracleAsmSecretId;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.securityDbEncryption = builder.securityDbEncryption;
                this.securityDbEncryptionName = builder.securityDbEncryptionName;
                this.spatialDataOptionToGeoJsonFunctionName = builder.spatialDataOptionToGeoJsonFunctionName;
                this.standbyDelayTime = builder.standbyDelayTime;
                this.useAlternateFolderForOnline = builder.useAlternateFolderForOnline;
                this.useBFile = builder.useBFile;
                this.useDirectPathFullLoad = builder.useDirectPathFullLoad;
                this.useLogminerReader = builder.useLogminerReader;
                this.usePathPrefix = builder.usePathPrefix;
            }

            @Override
            public final java.lang.Object getAccessAlternateDirectly() {
                return this.accessAlternateDirectly;
            }

            @Override
            public final java.lang.Number getAdditionalArchivedLogDestId() {
                return this.additionalArchivedLogDestId;
            }

            @Override
            public final java.lang.Object getAddSupplementalLogging() {
                return this.addSupplementalLogging;
            }

            @Override
            public final java.lang.Object getAllowSelectNestedTables() {
                return this.allowSelectNestedTables;
            }

            @Override
            public final java.lang.Number getArchivedLogDestId() {
                return this.archivedLogDestId;
            }

            @Override
            public final java.lang.Object getArchivedLogsOnly() {
                return this.archivedLogsOnly;
            }

            @Override
            public final java.lang.String getAsmPassword() {
                return this.asmPassword;
            }

            @Override
            public final java.lang.String getAsmServer() {
                return this.asmServer;
            }

            @Override
            public final java.lang.String getAsmUser() {
                return this.asmUser;
            }

            @Override
            public final java.lang.String getCharLengthSemantics() {
                return this.charLengthSemantics;
            }

            @Override
            public final java.lang.Object getDirectPathNoLog() {
                return this.directPathNoLog;
            }

            @Override
            public final java.lang.Object getDirectPathParallelLoad() {
                return this.directPathParallelLoad;
            }

            @Override
            public final java.lang.Object getEnableHomogenousTablespace() {
                return this.enableHomogenousTablespace;
            }

            @Override
            public final java.lang.Object getExtraArchivedLogDestIds() {
                return this.extraArchivedLogDestIds;
            }

            @Override
            public final java.lang.Object getFailTasksOnLobTruncation() {
                return this.failTasksOnLobTruncation;
            }

            @Override
            public final java.lang.Number getNumberDatatypeScale() {
                return this.numberDatatypeScale;
            }

            @Override
            public final java.lang.String getOraclePathPrefix() {
                return this.oraclePathPrefix;
            }

            @Override
            public final java.lang.Number getParallelAsmReadThreads() {
                return this.parallelAsmReadThreads;
            }

            @Override
            public final java.lang.Number getReadAheadBlocks() {
                return this.readAheadBlocks;
            }

            @Override
            public final java.lang.Object getReadTableSpaceName() {
                return this.readTableSpaceName;
            }

            @Override
            public final java.lang.Object getReplacePathPrefix() {
                return this.replacePathPrefix;
            }

            @Override
            public final java.lang.Number getRetryInterval() {
                return this.retryInterval;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerOracleAsmAccessRoleArn() {
                return this.secretsManagerOracleAsmAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerOracleAsmSecretId() {
                return this.secretsManagerOracleAsmSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecurityDbEncryption() {
                return this.securityDbEncryption;
            }

            @Override
            public final java.lang.String getSecurityDbEncryptionName() {
                return this.securityDbEncryptionName;
            }

            @Override
            public final java.lang.String getSpatialDataOptionToGeoJsonFunctionName() {
                return this.spatialDataOptionToGeoJsonFunctionName;
            }

            @Override
            public final java.lang.Number getStandbyDelayTime() {
                return this.standbyDelayTime;
            }

            @Override
            public final java.lang.Object getUseAlternateFolderForOnline() {
                return this.useAlternateFolderForOnline;
            }

            @Override
            public final java.lang.Object getUseBFile() {
                return this.useBFile;
            }

            @Override
            public final java.lang.Object getUseDirectPathFullLoad() {
                return this.useDirectPathFullLoad;
            }

            @Override
            public final java.lang.Object getUseLogminerReader() {
                return this.useLogminerReader;
            }

            @Override
            public final java.lang.String getUsePathPrefix() {
                return this.usePathPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessAlternateDirectly() != null) {
                    data.set("accessAlternateDirectly", om.valueToTree(this.getAccessAlternateDirectly()));
                }
                if (this.getAdditionalArchivedLogDestId() != null) {
                    data.set("additionalArchivedLogDestId", om.valueToTree(this.getAdditionalArchivedLogDestId()));
                }
                if (this.getAddSupplementalLogging() != null) {
                    data.set("addSupplementalLogging", om.valueToTree(this.getAddSupplementalLogging()));
                }
                if (this.getAllowSelectNestedTables() != null) {
                    data.set("allowSelectNestedTables", om.valueToTree(this.getAllowSelectNestedTables()));
                }
                if (this.getArchivedLogDestId() != null) {
                    data.set("archivedLogDestId", om.valueToTree(this.getArchivedLogDestId()));
                }
                if (this.getArchivedLogsOnly() != null) {
                    data.set("archivedLogsOnly", om.valueToTree(this.getArchivedLogsOnly()));
                }
                if (this.getAsmPassword() != null) {
                    data.set("asmPassword", om.valueToTree(this.getAsmPassword()));
                }
                if (this.getAsmServer() != null) {
                    data.set("asmServer", om.valueToTree(this.getAsmServer()));
                }
                if (this.getAsmUser() != null) {
                    data.set("asmUser", om.valueToTree(this.getAsmUser()));
                }
                if (this.getCharLengthSemantics() != null) {
                    data.set("charLengthSemantics", om.valueToTree(this.getCharLengthSemantics()));
                }
                if (this.getDirectPathNoLog() != null) {
                    data.set("directPathNoLog", om.valueToTree(this.getDirectPathNoLog()));
                }
                if (this.getDirectPathParallelLoad() != null) {
                    data.set("directPathParallelLoad", om.valueToTree(this.getDirectPathParallelLoad()));
                }
                if (this.getEnableHomogenousTablespace() != null) {
                    data.set("enableHomogenousTablespace", om.valueToTree(this.getEnableHomogenousTablespace()));
                }
                if (this.getExtraArchivedLogDestIds() != null) {
                    data.set("extraArchivedLogDestIds", om.valueToTree(this.getExtraArchivedLogDestIds()));
                }
                if (this.getFailTasksOnLobTruncation() != null) {
                    data.set("failTasksOnLobTruncation", om.valueToTree(this.getFailTasksOnLobTruncation()));
                }
                if (this.getNumberDatatypeScale() != null) {
                    data.set("numberDatatypeScale", om.valueToTree(this.getNumberDatatypeScale()));
                }
                if (this.getOraclePathPrefix() != null) {
                    data.set("oraclePathPrefix", om.valueToTree(this.getOraclePathPrefix()));
                }
                if (this.getParallelAsmReadThreads() != null) {
                    data.set("parallelAsmReadThreads", om.valueToTree(this.getParallelAsmReadThreads()));
                }
                if (this.getReadAheadBlocks() != null) {
                    data.set("readAheadBlocks", om.valueToTree(this.getReadAheadBlocks()));
                }
                if (this.getReadTableSpaceName() != null) {
                    data.set("readTableSpaceName", om.valueToTree(this.getReadTableSpaceName()));
                }
                if (this.getReplacePathPrefix() != null) {
                    data.set("replacePathPrefix", om.valueToTree(this.getReplacePathPrefix()));
                }
                if (this.getRetryInterval() != null) {
                    data.set("retryInterval", om.valueToTree(this.getRetryInterval()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerOracleAsmAccessRoleArn() != null) {
                    data.set("secretsManagerOracleAsmAccessRoleArn", om.valueToTree(this.getSecretsManagerOracleAsmAccessRoleArn()));
                }
                if (this.getSecretsManagerOracleAsmSecretId() != null) {
                    data.set("secretsManagerOracleAsmSecretId", om.valueToTree(this.getSecretsManagerOracleAsmSecretId()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getSecurityDbEncryption() != null) {
                    data.set("securityDbEncryption", om.valueToTree(this.getSecurityDbEncryption()));
                }
                if (this.getSecurityDbEncryptionName() != null) {
                    data.set("securityDbEncryptionName", om.valueToTree(this.getSecurityDbEncryptionName()));
                }
                if (this.getSpatialDataOptionToGeoJsonFunctionName() != null) {
                    data.set("spatialDataOptionToGeoJsonFunctionName", om.valueToTree(this.getSpatialDataOptionToGeoJsonFunctionName()));
                }
                if (this.getStandbyDelayTime() != null) {
                    data.set("standbyDelayTime", om.valueToTree(this.getStandbyDelayTime()));
                }
                if (this.getUseAlternateFolderForOnline() != null) {
                    data.set("useAlternateFolderForOnline", om.valueToTree(this.getUseAlternateFolderForOnline()));
                }
                if (this.getUseBFile() != null) {
                    data.set("useBFile", om.valueToTree(this.getUseBFile()));
                }
                if (this.getUseDirectPathFullLoad() != null) {
                    data.set("useDirectPathFullLoad", om.valueToTree(this.getUseDirectPathFullLoad()));
                }
                if (this.getUseLogminerReader() != null) {
                    data.set("useLogminerReader", om.valueToTree(this.getUseLogminerReader()));
                }
                if (this.getUsePathPrefix() != null) {
                    data.set("usePathPrefix", om.valueToTree(this.getUsePathPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.OracleSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OracleSettingsProperty.Jsii$Proxy that = (OracleSettingsProperty.Jsii$Proxy) o;

                if (this.accessAlternateDirectly != null ? !this.accessAlternateDirectly.equals(that.accessAlternateDirectly) : that.accessAlternateDirectly != null) return false;
                if (this.additionalArchivedLogDestId != null ? !this.additionalArchivedLogDestId.equals(that.additionalArchivedLogDestId) : that.additionalArchivedLogDestId != null) return false;
                if (this.addSupplementalLogging != null ? !this.addSupplementalLogging.equals(that.addSupplementalLogging) : that.addSupplementalLogging != null) return false;
                if (this.allowSelectNestedTables != null ? !this.allowSelectNestedTables.equals(that.allowSelectNestedTables) : that.allowSelectNestedTables != null) return false;
                if (this.archivedLogDestId != null ? !this.archivedLogDestId.equals(that.archivedLogDestId) : that.archivedLogDestId != null) return false;
                if (this.archivedLogsOnly != null ? !this.archivedLogsOnly.equals(that.archivedLogsOnly) : that.archivedLogsOnly != null) return false;
                if (this.asmPassword != null ? !this.asmPassword.equals(that.asmPassword) : that.asmPassword != null) return false;
                if (this.asmServer != null ? !this.asmServer.equals(that.asmServer) : that.asmServer != null) return false;
                if (this.asmUser != null ? !this.asmUser.equals(that.asmUser) : that.asmUser != null) return false;
                if (this.charLengthSemantics != null ? !this.charLengthSemantics.equals(that.charLengthSemantics) : that.charLengthSemantics != null) return false;
                if (this.directPathNoLog != null ? !this.directPathNoLog.equals(that.directPathNoLog) : that.directPathNoLog != null) return false;
                if (this.directPathParallelLoad != null ? !this.directPathParallelLoad.equals(that.directPathParallelLoad) : that.directPathParallelLoad != null) return false;
                if (this.enableHomogenousTablespace != null ? !this.enableHomogenousTablespace.equals(that.enableHomogenousTablespace) : that.enableHomogenousTablespace != null) return false;
                if (this.extraArchivedLogDestIds != null ? !this.extraArchivedLogDestIds.equals(that.extraArchivedLogDestIds) : that.extraArchivedLogDestIds != null) return false;
                if (this.failTasksOnLobTruncation != null ? !this.failTasksOnLobTruncation.equals(that.failTasksOnLobTruncation) : that.failTasksOnLobTruncation != null) return false;
                if (this.numberDatatypeScale != null ? !this.numberDatatypeScale.equals(that.numberDatatypeScale) : that.numberDatatypeScale != null) return false;
                if (this.oraclePathPrefix != null ? !this.oraclePathPrefix.equals(that.oraclePathPrefix) : that.oraclePathPrefix != null) return false;
                if (this.parallelAsmReadThreads != null ? !this.parallelAsmReadThreads.equals(that.parallelAsmReadThreads) : that.parallelAsmReadThreads != null) return false;
                if (this.readAheadBlocks != null ? !this.readAheadBlocks.equals(that.readAheadBlocks) : that.readAheadBlocks != null) return false;
                if (this.readTableSpaceName != null ? !this.readTableSpaceName.equals(that.readTableSpaceName) : that.readTableSpaceName != null) return false;
                if (this.replacePathPrefix != null ? !this.replacePathPrefix.equals(that.replacePathPrefix) : that.replacePathPrefix != null) return false;
                if (this.retryInterval != null ? !this.retryInterval.equals(that.retryInterval) : that.retryInterval != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerOracleAsmAccessRoleArn != null ? !this.secretsManagerOracleAsmAccessRoleArn.equals(that.secretsManagerOracleAsmAccessRoleArn) : that.secretsManagerOracleAsmAccessRoleArn != null) return false;
                if (this.secretsManagerOracleAsmSecretId != null ? !this.secretsManagerOracleAsmSecretId.equals(that.secretsManagerOracleAsmSecretId) : that.secretsManagerOracleAsmSecretId != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                if (this.securityDbEncryption != null ? !this.securityDbEncryption.equals(that.securityDbEncryption) : that.securityDbEncryption != null) return false;
                if (this.securityDbEncryptionName != null ? !this.securityDbEncryptionName.equals(that.securityDbEncryptionName) : that.securityDbEncryptionName != null) return false;
                if (this.spatialDataOptionToGeoJsonFunctionName != null ? !this.spatialDataOptionToGeoJsonFunctionName.equals(that.spatialDataOptionToGeoJsonFunctionName) : that.spatialDataOptionToGeoJsonFunctionName != null) return false;
                if (this.standbyDelayTime != null ? !this.standbyDelayTime.equals(that.standbyDelayTime) : that.standbyDelayTime != null) return false;
                if (this.useAlternateFolderForOnline != null ? !this.useAlternateFolderForOnline.equals(that.useAlternateFolderForOnline) : that.useAlternateFolderForOnline != null) return false;
                if (this.useBFile != null ? !this.useBFile.equals(that.useBFile) : that.useBFile != null) return false;
                if (this.useDirectPathFullLoad != null ? !this.useDirectPathFullLoad.equals(that.useDirectPathFullLoad) : that.useDirectPathFullLoad != null) return false;
                if (this.useLogminerReader != null ? !this.useLogminerReader.equals(that.useLogminerReader) : that.useLogminerReader != null) return false;
                return this.usePathPrefix != null ? this.usePathPrefix.equals(that.usePathPrefix) : that.usePathPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessAlternateDirectly != null ? this.accessAlternateDirectly.hashCode() : 0;
                result = 31 * result + (this.additionalArchivedLogDestId != null ? this.additionalArchivedLogDestId.hashCode() : 0);
                result = 31 * result + (this.addSupplementalLogging != null ? this.addSupplementalLogging.hashCode() : 0);
                result = 31 * result + (this.allowSelectNestedTables != null ? this.allowSelectNestedTables.hashCode() : 0);
                result = 31 * result + (this.archivedLogDestId != null ? this.archivedLogDestId.hashCode() : 0);
                result = 31 * result + (this.archivedLogsOnly != null ? this.archivedLogsOnly.hashCode() : 0);
                result = 31 * result + (this.asmPassword != null ? this.asmPassword.hashCode() : 0);
                result = 31 * result + (this.asmServer != null ? this.asmServer.hashCode() : 0);
                result = 31 * result + (this.asmUser != null ? this.asmUser.hashCode() : 0);
                result = 31 * result + (this.charLengthSemantics != null ? this.charLengthSemantics.hashCode() : 0);
                result = 31 * result + (this.directPathNoLog != null ? this.directPathNoLog.hashCode() : 0);
                result = 31 * result + (this.directPathParallelLoad != null ? this.directPathParallelLoad.hashCode() : 0);
                result = 31 * result + (this.enableHomogenousTablespace != null ? this.enableHomogenousTablespace.hashCode() : 0);
                result = 31 * result + (this.extraArchivedLogDestIds != null ? this.extraArchivedLogDestIds.hashCode() : 0);
                result = 31 * result + (this.failTasksOnLobTruncation != null ? this.failTasksOnLobTruncation.hashCode() : 0);
                result = 31 * result + (this.numberDatatypeScale != null ? this.numberDatatypeScale.hashCode() : 0);
                result = 31 * result + (this.oraclePathPrefix != null ? this.oraclePathPrefix.hashCode() : 0);
                result = 31 * result + (this.parallelAsmReadThreads != null ? this.parallelAsmReadThreads.hashCode() : 0);
                result = 31 * result + (this.readAheadBlocks != null ? this.readAheadBlocks.hashCode() : 0);
                result = 31 * result + (this.readTableSpaceName != null ? this.readTableSpaceName.hashCode() : 0);
                result = 31 * result + (this.replacePathPrefix != null ? this.replacePathPrefix.hashCode() : 0);
                result = 31 * result + (this.retryInterval != null ? this.retryInterval.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerOracleAsmAccessRoleArn != null ? this.secretsManagerOracleAsmAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerOracleAsmSecretId != null ? this.secretsManagerOracleAsmSecretId.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.securityDbEncryption != null ? this.securityDbEncryption.hashCode() : 0);
                result = 31 * result + (this.securityDbEncryptionName != null ? this.securityDbEncryptionName.hashCode() : 0);
                result = 31 * result + (this.spatialDataOptionToGeoJsonFunctionName != null ? this.spatialDataOptionToGeoJsonFunctionName.hashCode() : 0);
                result = 31 * result + (this.standbyDelayTime != null ? this.standbyDelayTime.hashCode() : 0);
                result = 31 * result + (this.useAlternateFolderForOnline != null ? this.useAlternateFolderForOnline.hashCode() : 0);
                result = 31 * result + (this.useBFile != null ? this.useBFile.hashCode() : 0);
                result = 31 * result + (this.useDirectPathFullLoad != null ? this.useDirectPathFullLoad.hashCode() : 0);
                result = 31 * result + (this.useLogminerReader != null ? this.useLogminerReader.hashCode() : 0);
                result = 31 * result + (this.usePathPrefix != null ? this.usePathPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a PostgreSQL endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * PostgreSqlSettingsProperty postgreSqlSettingsProperty = PostgreSqlSettingsProperty.builder()
     *         .afterConnectScript("afterConnectScript")
     *         .babelfishDatabaseName("babelfishDatabaseName")
     *         .captureDdls(false)
     *         .databaseMode("databaseMode")
     *         .ddlArtifactsSchema("ddlArtifactsSchema")
     *         .executeTimeout(123)
     *         .failTasksOnLobTruncation(false)
     *         .heartbeatEnable(false)
     *         .heartbeatFrequency(123)
     *         .heartbeatSchema("heartbeatSchema")
     *         .mapBooleanAsBoolean(false)
     *         .maxFileSize(123)
     *         .pluginName("pluginName")
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .slotName("slotName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.PostgreSqlSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(PostgreSqlSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PostgreSqlSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For use with change data capture (CDC) only, this attribute has AWS DMS bypass foreign keys and user triggers to reduce the time it takes to bulk load data.
         * <p>
         * Example: <code>afterConnectScript=SET session_replication_role='replica'</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-afterconnectscript">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-afterconnectscript</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAfterConnectScript() {
            return null;
        }

        /**
         * The Babelfish for Aurora PostgreSQL database name for the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-babelfishdatabasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-babelfishdatabasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBabelfishDatabaseName() {
            return null;
        }

        /**
         * To capture DDL events, AWS DMS creates various artifacts in the PostgreSQL database when the task starts.
         * <p>
         * You can later remove these artifacts.
         * <p>
         * If this value is set to <code>True</code> , you don't have to create tables or triggers on the source database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-captureddls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-captureddls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptureDdls() {
            return null;
        }

        /**
         * Specifies the default behavior of the replication's handling of PostgreSQL- compatible endpoints that require some additional configuration, such as Babelfish endpoints.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-databasemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-databasemode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseMode() {
            return null;
        }

        /**
         * The schema in which the operational DDL database artifacts are created.
         * <p>
         * The default value is <code>public</code> .
         * <p>
         * Example: <code>ddlArtifactsSchema=xyzddlschema;</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-ddlartifactsschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-ddlartifactsschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDdlArtifactsSchema() {
            return null;
        }

        /**
         * Sets the client statement timeout for the PostgreSQL instance, in seconds. The default value is 60 seconds.
         * <p>
         * Example: <code>executeTimeout=100;</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-executetimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-executetimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getExecuteTimeout() {
            return null;
        }

        /**
         * When set to <code>true</code> , this value causes a task to fail if the actual size of a LOB column is greater than the specified <code>LobMaxSize</code> .
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * If task is set to Limited LOB mode and this option is set to true, the task fails instead of truncating the LOB data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-failtasksonlobtruncation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-failtasksonlobtruncation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailTasksOnLobTruncation() {
            return null;
        }

        /**
         * The write-ahead log (WAL) heartbeat feature mimics a dummy transaction.
         * <p>
         * By doing this, it prevents idle logical replication slots from holding onto old WAL logs, which can result in storage full situations on the source. This heartbeat keeps <code>restart_lsn</code> moving and prevents storage full scenarios.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-heartbeatenable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-heartbeatenable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeartbeatEnable() {
            return null;
        }

        /**
         * Sets the WAL heartbeat frequency (in minutes).
         * <p>
         * The default value is 5 minutes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-heartbeatfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-heartbeatfrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHeartbeatFrequency() {
            return null;
        }

        /**
         * Sets the schema in which the heartbeat artifacts are created.
         * <p>
         * The default value is <code>public</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-heartbeatschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-heartbeatschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHeartbeatSchema() {
            return null;
        }

        /**
         * When true, lets PostgreSQL migrate the boolean type as boolean.
         * <p>
         * By default, PostgreSQL migrates booleans as <code>varchar(5)</code> . You must set this setting on both the source and target endpoints for it to take effect.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-mapbooleanasboolean">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-mapbooleanasboolean</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMapBooleanAsBoolean() {
            return null;
        }

        /**
         * Specifies the maximum size (in KB) of any .csv file used to transfer data to PostgreSQL.
         * <p>
         * The default value is 32,768 KB (32 MB).
         * <p>
         * Example: <code>maxFileSize=512</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-maxfilesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-maxfilesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFileSize() {
            return null;
        }

        /**
         * Specifies the plugin to use to create a replication slot.
         * <p>
         * The default value is <code>pglogical</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-pluginname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-pluginname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPluginName() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the PostgreSQL endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the PostgreSQL endpoint connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * Sets the name of a previously created logical replication slot for a change data capture (CDC) load of the PostgreSQL source instance.
         * <p>
         * When used with the <code>CdcStartPosition</code> request parameter for the AWS DMS API , this attribute also makes it possible to use native CDC start points. DMS verifies that the specified logical replication slot exists before starting the CDC load task. It also verifies that the task was created with a valid setting of <code>CdcStartPosition</code> . If the specified slot doesn't exist or the task doesn't have a valid <code>CdcStartPosition</code> setting, DMS raises an error.
         * <p>
         * For more information about setting the <code>CdcStartPosition</code> request parameter, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native">Determining a CDC native start point</a> in the <em>AWS Database Migration Service User Guide</em> . For more information about using <code>CdcStartPosition</code> , see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">CreateReplicationTask</a> , <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">StartReplicationTask</a> , and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">ModifyReplicationTask</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-slotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-postgresqlsettings.html#cfn-dms-endpoint-postgresqlsettings-slotname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSlotName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PostgreSqlSettingsProperty> {
            java.lang.String afterConnectScript;
            java.lang.String babelfishDatabaseName;
            java.lang.Object captureDdls;
            java.lang.String databaseMode;
            java.lang.String ddlArtifactsSchema;
            java.lang.Number executeTimeout;
            java.lang.Object failTasksOnLobTruncation;
            java.lang.Object heartbeatEnable;
            java.lang.Number heartbeatFrequency;
            java.lang.String heartbeatSchema;
            java.lang.Object mapBooleanAsBoolean;
            java.lang.Number maxFileSize;
            java.lang.String pluginName;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;
            java.lang.String slotName;

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getAfterConnectScript}
             * @param afterConnectScript For use with change data capture (CDC) only, this attribute has AWS DMS bypass foreign keys and user triggers to reduce the time it takes to bulk load data.
             *                           Example: <code>afterConnectScript=SET session_replication_role='replica'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder afterConnectScript(java.lang.String afterConnectScript) {
                this.afterConnectScript = afterConnectScript;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getBabelfishDatabaseName}
             * @param babelfishDatabaseName The Babelfish for Aurora PostgreSQL database name for the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder babelfishDatabaseName(java.lang.String babelfishDatabaseName) {
                this.babelfishDatabaseName = babelfishDatabaseName;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getCaptureDdls}
             * @param captureDdls To capture DDL events, AWS DMS creates various artifacts in the PostgreSQL database when the task starts.
             *                    You can later remove these artifacts.
             *                    <p>
             *                    If this value is set to <code>True</code> , you don't have to create tables or triggers on the source database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureDdls(java.lang.Boolean captureDdls) {
                this.captureDdls = captureDdls;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getCaptureDdls}
             * @param captureDdls To capture DDL events, AWS DMS creates various artifacts in the PostgreSQL database when the task starts.
             *                    You can later remove these artifacts.
             *                    <p>
             *                    If this value is set to <code>True</code> , you don't have to create tables or triggers on the source database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureDdls(software.amazon.awscdk.IResolvable captureDdls) {
                this.captureDdls = captureDdls;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getDatabaseMode}
             * @param databaseMode Specifies the default behavior of the replication's handling of PostgreSQL- compatible endpoints that require some additional configuration, such as Babelfish endpoints.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseMode(java.lang.String databaseMode) {
                this.databaseMode = databaseMode;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getDdlArtifactsSchema}
             * @param ddlArtifactsSchema The schema in which the operational DDL database artifacts are created.
             *                           The default value is <code>public</code> .
             *                           <p>
             *                           Example: <code>ddlArtifactsSchema=xyzddlschema;</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ddlArtifactsSchema(java.lang.String ddlArtifactsSchema) {
                this.ddlArtifactsSchema = ddlArtifactsSchema;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getExecuteTimeout}
             * @param executeTimeout Sets the client statement timeout for the PostgreSQL instance, in seconds. The default value is 60 seconds.
             *                       Example: <code>executeTimeout=100;</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executeTimeout(java.lang.Number executeTimeout) {
                this.executeTimeout = executeTimeout;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getFailTasksOnLobTruncation}
             * @param failTasksOnLobTruncation When set to <code>true</code> , this value causes a task to fail if the actual size of a LOB column is greater than the specified <code>LobMaxSize</code> .
             *                                 The default value is <code>false</code> .
             *                                 <p>
             *                                 If task is set to Limited LOB mode and this option is set to true, the task fails instead of truncating the LOB data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failTasksOnLobTruncation(java.lang.Boolean failTasksOnLobTruncation) {
                this.failTasksOnLobTruncation = failTasksOnLobTruncation;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getFailTasksOnLobTruncation}
             * @param failTasksOnLobTruncation When set to <code>true</code> , this value causes a task to fail if the actual size of a LOB column is greater than the specified <code>LobMaxSize</code> .
             *                                 The default value is <code>false</code> .
             *                                 <p>
             *                                 If task is set to Limited LOB mode and this option is set to true, the task fails instead of truncating the LOB data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failTasksOnLobTruncation(software.amazon.awscdk.IResolvable failTasksOnLobTruncation) {
                this.failTasksOnLobTruncation = failTasksOnLobTruncation;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getHeartbeatEnable}
             * @param heartbeatEnable The write-ahead log (WAL) heartbeat feature mimics a dummy transaction.
             *                        By doing this, it prevents idle logical replication slots from holding onto old WAL logs, which can result in storage full situations on the source. This heartbeat keeps <code>restart_lsn</code> moving and prevents storage full scenarios.
             *                        <p>
             *                        The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder heartbeatEnable(java.lang.Boolean heartbeatEnable) {
                this.heartbeatEnable = heartbeatEnable;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getHeartbeatEnable}
             * @param heartbeatEnable The write-ahead log (WAL) heartbeat feature mimics a dummy transaction.
             *                        By doing this, it prevents idle logical replication slots from holding onto old WAL logs, which can result in storage full situations on the source. This heartbeat keeps <code>restart_lsn</code> moving and prevents storage full scenarios.
             *                        <p>
             *                        The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder heartbeatEnable(software.amazon.awscdk.IResolvable heartbeatEnable) {
                this.heartbeatEnable = heartbeatEnable;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getHeartbeatFrequency}
             * @param heartbeatFrequency Sets the WAL heartbeat frequency (in minutes).
             *                           The default value is 5 minutes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder heartbeatFrequency(java.lang.Number heartbeatFrequency) {
                this.heartbeatFrequency = heartbeatFrequency;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getHeartbeatSchema}
             * @param heartbeatSchema Sets the schema in which the heartbeat artifacts are created.
             *                        The default value is <code>public</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder heartbeatSchema(java.lang.String heartbeatSchema) {
                this.heartbeatSchema = heartbeatSchema;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getMapBooleanAsBoolean}
             * @param mapBooleanAsBoolean When true, lets PostgreSQL migrate the boolean type as boolean.
             *                            By default, PostgreSQL migrates booleans as <code>varchar(5)</code> . You must set this setting on both the source and target endpoints for it to take effect.
             *                            <p>
             *                            The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapBooleanAsBoolean(java.lang.Boolean mapBooleanAsBoolean) {
                this.mapBooleanAsBoolean = mapBooleanAsBoolean;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getMapBooleanAsBoolean}
             * @param mapBooleanAsBoolean When true, lets PostgreSQL migrate the boolean type as boolean.
             *                            By default, PostgreSQL migrates booleans as <code>varchar(5)</code> . You must set this setting on both the source and target endpoints for it to take effect.
             *                            <p>
             *                            The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapBooleanAsBoolean(software.amazon.awscdk.IResolvable mapBooleanAsBoolean) {
                this.mapBooleanAsBoolean = mapBooleanAsBoolean;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getMaxFileSize}
             * @param maxFileSize Specifies the maximum size (in KB) of any .csv file used to transfer data to PostgreSQL.
             *                    The default value is 32,768 KB (32 MB).
             *                    <p>
             *                    Example: <code>maxFileSize=512</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFileSize(java.lang.Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getPluginName}
             * @param pluginName Specifies the plugin to use to create a replication slot.
             *                   The default value is <code>pglogical</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pluginName(java.lang.String pluginName) {
                this.pluginName = pluginName;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
             *                                    The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the PostgreSQL endpoint.
             *                                    <p>
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
             *                                    <p>
             *                                    For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the PostgreSQL endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getSlotName}
             * @param slotName Sets the name of a previously created logical replication slot for a change data capture (CDC) load of the PostgreSQL source instance.
             *                 When used with the <code>CdcStartPosition</code> request parameter for the AWS DMS API , this attribute also makes it possible to use native CDC start points. DMS verifies that the specified logical replication slot exists before starting the CDC load task. It also verifies that the task was created with a valid setting of <code>CdcStartPosition</code> . If the specified slot doesn't exist or the task doesn't have a valid <code>CdcStartPosition</code> setting, DMS raises an error.
             *                 <p>
             *                 For more information about setting the <code>CdcStartPosition</code> request parameter, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native">Determining a CDC native start point</a> in the <em>AWS Database Migration Service User Guide</em> . For more information about using <code>CdcStartPosition</code> , see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">CreateReplicationTask</a> , <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">StartReplicationTask</a> , and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">ModifyReplicationTask</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotName(java.lang.String slotName) {
                this.slotName = slotName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PostgreSqlSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PostgreSqlSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PostgreSqlSettingsProperty {
            private final java.lang.String afterConnectScript;
            private final java.lang.String babelfishDatabaseName;
            private final java.lang.Object captureDdls;
            private final java.lang.String databaseMode;
            private final java.lang.String ddlArtifactsSchema;
            private final java.lang.Number executeTimeout;
            private final java.lang.Object failTasksOnLobTruncation;
            private final java.lang.Object heartbeatEnable;
            private final java.lang.Number heartbeatFrequency;
            private final java.lang.String heartbeatSchema;
            private final java.lang.Object mapBooleanAsBoolean;
            private final java.lang.Number maxFileSize;
            private final java.lang.String pluginName;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.String slotName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.afterConnectScript = software.amazon.jsii.Kernel.get(this, "afterConnectScript", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.babelfishDatabaseName = software.amazon.jsii.Kernel.get(this, "babelfishDatabaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.captureDdls = software.amazon.jsii.Kernel.get(this, "captureDdls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.databaseMode = software.amazon.jsii.Kernel.get(this, "databaseMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ddlArtifactsSchema = software.amazon.jsii.Kernel.get(this, "ddlArtifactsSchema", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.executeTimeout = software.amazon.jsii.Kernel.get(this, "executeTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.failTasksOnLobTruncation = software.amazon.jsii.Kernel.get(this, "failTasksOnLobTruncation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.heartbeatEnable = software.amazon.jsii.Kernel.get(this, "heartbeatEnable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.heartbeatFrequency = software.amazon.jsii.Kernel.get(this, "heartbeatFrequency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.heartbeatSchema = software.amazon.jsii.Kernel.get(this, "heartbeatSchema", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mapBooleanAsBoolean = software.amazon.jsii.Kernel.get(this, "mapBooleanAsBoolean", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxFileSize = software.amazon.jsii.Kernel.get(this, "maxFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pluginName = software.amazon.jsii.Kernel.get(this, "pluginName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slotName = software.amazon.jsii.Kernel.get(this, "slotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.afterConnectScript = builder.afterConnectScript;
                this.babelfishDatabaseName = builder.babelfishDatabaseName;
                this.captureDdls = builder.captureDdls;
                this.databaseMode = builder.databaseMode;
                this.ddlArtifactsSchema = builder.ddlArtifactsSchema;
                this.executeTimeout = builder.executeTimeout;
                this.failTasksOnLobTruncation = builder.failTasksOnLobTruncation;
                this.heartbeatEnable = builder.heartbeatEnable;
                this.heartbeatFrequency = builder.heartbeatFrequency;
                this.heartbeatSchema = builder.heartbeatSchema;
                this.mapBooleanAsBoolean = builder.mapBooleanAsBoolean;
                this.maxFileSize = builder.maxFileSize;
                this.pluginName = builder.pluginName;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.slotName = builder.slotName;
            }

            @Override
            public final java.lang.String getAfterConnectScript() {
                return this.afterConnectScript;
            }

            @Override
            public final java.lang.String getBabelfishDatabaseName() {
                return this.babelfishDatabaseName;
            }

            @Override
            public final java.lang.Object getCaptureDdls() {
                return this.captureDdls;
            }

            @Override
            public final java.lang.String getDatabaseMode() {
                return this.databaseMode;
            }

            @Override
            public final java.lang.String getDdlArtifactsSchema() {
                return this.ddlArtifactsSchema;
            }

            @Override
            public final java.lang.Number getExecuteTimeout() {
                return this.executeTimeout;
            }

            @Override
            public final java.lang.Object getFailTasksOnLobTruncation() {
                return this.failTasksOnLobTruncation;
            }

            @Override
            public final java.lang.Object getHeartbeatEnable() {
                return this.heartbeatEnable;
            }

            @Override
            public final java.lang.Number getHeartbeatFrequency() {
                return this.heartbeatFrequency;
            }

            @Override
            public final java.lang.String getHeartbeatSchema() {
                return this.heartbeatSchema;
            }

            @Override
            public final java.lang.Object getMapBooleanAsBoolean() {
                return this.mapBooleanAsBoolean;
            }

            @Override
            public final java.lang.Number getMaxFileSize() {
                return this.maxFileSize;
            }

            @Override
            public final java.lang.String getPluginName() {
                return this.pluginName;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSlotName() {
                return this.slotName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAfterConnectScript() != null) {
                    data.set("afterConnectScript", om.valueToTree(this.getAfterConnectScript()));
                }
                if (this.getBabelfishDatabaseName() != null) {
                    data.set("babelfishDatabaseName", om.valueToTree(this.getBabelfishDatabaseName()));
                }
                if (this.getCaptureDdls() != null) {
                    data.set("captureDdls", om.valueToTree(this.getCaptureDdls()));
                }
                if (this.getDatabaseMode() != null) {
                    data.set("databaseMode", om.valueToTree(this.getDatabaseMode()));
                }
                if (this.getDdlArtifactsSchema() != null) {
                    data.set("ddlArtifactsSchema", om.valueToTree(this.getDdlArtifactsSchema()));
                }
                if (this.getExecuteTimeout() != null) {
                    data.set("executeTimeout", om.valueToTree(this.getExecuteTimeout()));
                }
                if (this.getFailTasksOnLobTruncation() != null) {
                    data.set("failTasksOnLobTruncation", om.valueToTree(this.getFailTasksOnLobTruncation()));
                }
                if (this.getHeartbeatEnable() != null) {
                    data.set("heartbeatEnable", om.valueToTree(this.getHeartbeatEnable()));
                }
                if (this.getHeartbeatFrequency() != null) {
                    data.set("heartbeatFrequency", om.valueToTree(this.getHeartbeatFrequency()));
                }
                if (this.getHeartbeatSchema() != null) {
                    data.set("heartbeatSchema", om.valueToTree(this.getHeartbeatSchema()));
                }
                if (this.getMapBooleanAsBoolean() != null) {
                    data.set("mapBooleanAsBoolean", om.valueToTree(this.getMapBooleanAsBoolean()));
                }
                if (this.getMaxFileSize() != null) {
                    data.set("maxFileSize", om.valueToTree(this.getMaxFileSize()));
                }
                if (this.getPluginName() != null) {
                    data.set("pluginName", om.valueToTree(this.getPluginName()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getSlotName() != null) {
                    data.set("slotName", om.valueToTree(this.getSlotName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.PostgreSqlSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PostgreSqlSettingsProperty.Jsii$Proxy that = (PostgreSqlSettingsProperty.Jsii$Proxy) o;

                if (this.afterConnectScript != null ? !this.afterConnectScript.equals(that.afterConnectScript) : that.afterConnectScript != null) return false;
                if (this.babelfishDatabaseName != null ? !this.babelfishDatabaseName.equals(that.babelfishDatabaseName) : that.babelfishDatabaseName != null) return false;
                if (this.captureDdls != null ? !this.captureDdls.equals(that.captureDdls) : that.captureDdls != null) return false;
                if (this.databaseMode != null ? !this.databaseMode.equals(that.databaseMode) : that.databaseMode != null) return false;
                if (this.ddlArtifactsSchema != null ? !this.ddlArtifactsSchema.equals(that.ddlArtifactsSchema) : that.ddlArtifactsSchema != null) return false;
                if (this.executeTimeout != null ? !this.executeTimeout.equals(that.executeTimeout) : that.executeTimeout != null) return false;
                if (this.failTasksOnLobTruncation != null ? !this.failTasksOnLobTruncation.equals(that.failTasksOnLobTruncation) : that.failTasksOnLobTruncation != null) return false;
                if (this.heartbeatEnable != null ? !this.heartbeatEnable.equals(that.heartbeatEnable) : that.heartbeatEnable != null) return false;
                if (this.heartbeatFrequency != null ? !this.heartbeatFrequency.equals(that.heartbeatFrequency) : that.heartbeatFrequency != null) return false;
                if (this.heartbeatSchema != null ? !this.heartbeatSchema.equals(that.heartbeatSchema) : that.heartbeatSchema != null) return false;
                if (this.mapBooleanAsBoolean != null ? !this.mapBooleanAsBoolean.equals(that.mapBooleanAsBoolean) : that.mapBooleanAsBoolean != null) return false;
                if (this.maxFileSize != null ? !this.maxFileSize.equals(that.maxFileSize) : that.maxFileSize != null) return false;
                if (this.pluginName != null ? !this.pluginName.equals(that.pluginName) : that.pluginName != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                return this.slotName != null ? this.slotName.equals(that.slotName) : that.slotName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.afterConnectScript != null ? this.afterConnectScript.hashCode() : 0;
                result = 31 * result + (this.babelfishDatabaseName != null ? this.babelfishDatabaseName.hashCode() : 0);
                result = 31 * result + (this.captureDdls != null ? this.captureDdls.hashCode() : 0);
                result = 31 * result + (this.databaseMode != null ? this.databaseMode.hashCode() : 0);
                result = 31 * result + (this.ddlArtifactsSchema != null ? this.ddlArtifactsSchema.hashCode() : 0);
                result = 31 * result + (this.executeTimeout != null ? this.executeTimeout.hashCode() : 0);
                result = 31 * result + (this.failTasksOnLobTruncation != null ? this.failTasksOnLobTruncation.hashCode() : 0);
                result = 31 * result + (this.heartbeatEnable != null ? this.heartbeatEnable.hashCode() : 0);
                result = 31 * result + (this.heartbeatFrequency != null ? this.heartbeatFrequency.hashCode() : 0);
                result = 31 * result + (this.heartbeatSchema != null ? this.heartbeatSchema.hashCode() : 0);
                result = 31 * result + (this.mapBooleanAsBoolean != null ? this.mapBooleanAsBoolean.hashCode() : 0);
                result = 31 * result + (this.maxFileSize != null ? this.maxFileSize.hashCode() : 0);
                result = 31 * result + (this.pluginName != null ? this.pluginName.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.slotName != null ? this.slotName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a Redis target endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redis.html#CHAP_Target.Redis.EndpointSettings">Specifying endpoint settings for Redis as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * RedisSettingsProperty redisSettingsProperty = RedisSettingsProperty.builder()
     *         .authPassword("authPassword")
     *         .authType("authType")
     *         .authUserName("authUserName")
     *         .port(123)
     *         .serverName("serverName")
     *         .sslCaCertificateArn("sslCaCertificateArn")
     *         .sslSecurityProtocol("sslSecurityProtocol")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.RedisSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedisSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedisSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password provided with the <code>auth-role</code> and <code>auth-token</code> options of the <code>AuthType</code> setting for a Redis target endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-authpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-authpassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthPassword() {
            return null;
        }

        /**
         * The type of authentication to perform when connecting to a Redis target.
         * <p>
         * Options include <code>none</code> , <code>auth-token</code> , and <code>auth-role</code> . The <code>auth-token</code> option requires an <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option requires <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-authtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthType() {
            return null;
        }

        /**
         * The user name provided with the <code>auth-role</code> option of the <code>AuthType</code> setting for a Redis target endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-authusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-authusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthUserName() {
            return null;
        }

        /**
         * Transmission Control Protocol (TCP) port for the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * Fully qualified domain name of the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-sslcacertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-sslcacertificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslCaCertificateArn() {
            return null;
        }

        /**
         * The connection to a Redis target endpoint using Transport Layer Security (TLS).
         * <p>
         * Valid values include <code>plaintext</code> and <code>ssl-encryption</code> . The default is <code>ssl-encryption</code> . The <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon Resource Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn</code> setting. If an ARN isn't given for a CA, DMS uses the Amazon root CA.
         * <p>
         * The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-sslsecurityprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redissettings.html#cfn-dms-endpoint-redissettings-sslsecurityprotocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslSecurityProtocol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedisSettingsProperty> {
            java.lang.String authPassword;
            java.lang.String authType;
            java.lang.String authUserName;
            java.lang.Number port;
            java.lang.String serverName;
            java.lang.String sslCaCertificateArn;
            java.lang.String sslSecurityProtocol;

            /**
             * Sets the value of {@link RedisSettingsProperty#getAuthPassword}
             * @param authPassword The password provided with the <code>auth-role</code> and <code>auth-token</code> options of the <code>AuthType</code> setting for a Redis target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authPassword(java.lang.String authPassword) {
                this.authPassword = authPassword;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getAuthType}
             * @param authType The type of authentication to perform when connecting to a Redis target.
             *                 Options include <code>none</code> , <code>auth-token</code> , and <code>auth-role</code> . The <code>auth-token</code> option requires an <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option requires <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getAuthUserName}
             * @param authUserName The user name provided with the <code>auth-role</code> option of the <code>AuthType</code> setting for a Redis target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authUserName(java.lang.String authUserName) {
                this.authUserName = authUserName;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getPort}
             * @param port Transmission Control Protocol (TCP) port for the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getServerName}
             * @param serverName Fully qualified domain name of the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getSslCaCertificateArn}
             * @param sslCaCertificateArn The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslCaCertificateArn(java.lang.String sslCaCertificateArn) {
                this.sslCaCertificateArn = sslCaCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getSslSecurityProtocol}
             * @param sslSecurityProtocol The connection to a Redis target endpoint using Transport Layer Security (TLS).
             *                            Valid values include <code>plaintext</code> and <code>ssl-encryption</code> . The default is <code>ssl-encryption</code> . The <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon Resource Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn</code> setting. If an ARN isn't given for a CA, DMS uses the Amazon root CA.
             *                            <p>
             *                            The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslSecurityProtocol(java.lang.String sslSecurityProtocol) {
                this.sslSecurityProtocol = sslSecurityProtocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedisSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedisSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedisSettingsProperty {
            private final java.lang.String authPassword;
            private final java.lang.String authType;
            private final java.lang.String authUserName;
            private final java.lang.Number port;
            private final java.lang.String serverName;
            private final java.lang.String sslCaCertificateArn;
            private final java.lang.String sslSecurityProtocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authPassword = software.amazon.jsii.Kernel.get(this, "authPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authUserName = software.amazon.jsii.Kernel.get(this, "authUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslCaCertificateArn = software.amazon.jsii.Kernel.get(this, "sslCaCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslSecurityProtocol = software.amazon.jsii.Kernel.get(this, "sslSecurityProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authPassword = builder.authPassword;
                this.authType = builder.authType;
                this.authUserName = builder.authUserName;
                this.port = builder.port;
                this.serverName = builder.serverName;
                this.sslCaCertificateArn = builder.sslCaCertificateArn;
                this.sslSecurityProtocol = builder.sslSecurityProtocol;
            }

            @Override
            public final java.lang.String getAuthPassword() {
                return this.authPassword;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.String getAuthUserName() {
                return this.authUserName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getSslCaCertificateArn() {
                return this.sslCaCertificateArn;
            }

            @Override
            public final java.lang.String getSslSecurityProtocol() {
                return this.sslSecurityProtocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthPassword() != null) {
                    data.set("authPassword", om.valueToTree(this.getAuthPassword()));
                }
                if (this.getAuthType() != null) {
                    data.set("authType", om.valueToTree(this.getAuthType()));
                }
                if (this.getAuthUserName() != null) {
                    data.set("authUserName", om.valueToTree(this.getAuthUserName()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getServerName() != null) {
                    data.set("serverName", om.valueToTree(this.getServerName()));
                }
                if (this.getSslCaCertificateArn() != null) {
                    data.set("sslCaCertificateArn", om.valueToTree(this.getSslCaCertificateArn()));
                }
                if (this.getSslSecurityProtocol() != null) {
                    data.set("sslSecurityProtocol", om.valueToTree(this.getSslSecurityProtocol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.RedisSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedisSettingsProperty.Jsii$Proxy that = (RedisSettingsProperty.Jsii$Proxy) o;

                if (this.authPassword != null ? !this.authPassword.equals(that.authPassword) : that.authPassword != null) return false;
                if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
                if (this.authUserName != null ? !this.authUserName.equals(that.authUserName) : that.authUserName != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
                if (this.sslCaCertificateArn != null ? !this.sslCaCertificateArn.equals(that.sslCaCertificateArn) : that.sslCaCertificateArn != null) return false;
                return this.sslSecurityProtocol != null ? this.sslSecurityProtocol.equals(that.sslSecurityProtocol) : that.sslSecurityProtocol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authPassword != null ? this.authPassword.hashCode() : 0;
                result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
                result = 31 * result + (this.authUserName != null ? this.authUserName.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
                result = 31 * result + (this.sslCaCertificateArn != null ? this.sslCaCertificateArn.hashCode() : 0);
                result = 31 * result + (this.sslSecurityProtocol != null ? this.sslSecurityProtocol.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines an Amazon Redshift endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redshift.html#CHAP_Target.Redshift.ConnectionAttrib">Extra connection attributes when using Amazon Redshift as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * RedshiftSettingsProperty redshiftSettingsProperty = RedshiftSettingsProperty.builder()
     *         .acceptAnyDate(false)
     *         .afterConnectScript("afterConnectScript")
     *         .bucketFolder("bucketFolder")
     *         .bucketName("bucketName")
     *         .caseSensitiveNames(false)
     *         .compUpdate(false)
     *         .connectionTimeout(123)
     *         .dateFormat("dateFormat")
     *         .emptyAsNull(false)
     *         .encryptionMode("encryptionMode")
     *         .explicitIds(false)
     *         .fileTransferUploadStreams(123)
     *         .loadTimeout(123)
     *         .mapBooleanAsBoolean(false)
     *         .maxFileSize(123)
     *         .removeQuotes(false)
     *         .replaceChars("replaceChars")
     *         .replaceInvalidChars("replaceInvalidChars")
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .serverSideEncryptionKmsKeyId("serverSideEncryptionKmsKeyId")
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .timeFormat("timeFormat")
     *         .trimBlanks(false)
     *         .truncateColumns(false)
     *         .writeBufferSize(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.RedshiftSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to be loaded without generating an error.
         * <p>
         * You can choose <code>true</code> or <code>false</code> (the default).
         * <p>
         * This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift inserts a NULL value into that field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-acceptanydate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-acceptanydate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceptAnyDate() {
            return null;
        }

        /**
         * Code to run after connecting.
         * <p>
         * This parameter should contain the code itself, not the name of a file containing the code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-afterconnectscript">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-afterconnectscript</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAfterConnectScript() {
            return null;
        }

        /**
         * An S3 folder where the comma-separated-value (.csv) files are stored before being uploaded to the target Redshift cluster.
         * <p>
         * For full load mode, AWS DMS converts source records into .csv files and loads them to the <em>BucketFolder/TableID</em> path. AWS DMS uses the Redshift <code>COPY</code> command to upload the .csv files to the target table. The files are deleted once the <code>COPY</code> operation has finished. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in the <em>Amazon Redshift Database Developer Guide</em> .
         * <p>
         * For change-data-capture (CDC) mode, AWS DMS creates a <em>NetChanges</em> table, and loads the .csv files to this <em>BucketFolder/NetChangesTableID</em> path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-bucketfolder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-bucketfolder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketFolder() {
            return null;
        }

        /**
         * The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
            return null;
        }

        /**
         * If Amazon Redshift is configured to support case sensitive schema names, set <code>CaseSensitiveNames</code> to <code>true</code> .
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-casesensitivenames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-casesensitivenames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaseSensitiveNames() {
            return null;
        }

        /**
         * If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies automatic compression if the table is empty.
         * <p>
         * This applies even if the table columns already have encodings other than <code>RAW</code> . If you set <code>CompUpdate</code> to <code>false</code> , automatic compression is disabled and existing column encodings aren't changed. The default is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-compupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-compupdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompUpdate() {
            return null;
        }

        /**
         * A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you initially establish a connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-connectiontimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-connectiontimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionTimeout() {
            return null;
        }

        /**
         * The date format that you are using.
         * <p>
         * Valid values are <code>auto</code> (case-sensitive), your date format string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of 'YYYY-MM-DD'. Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a date format string.
         * <p>
         * If your date and time values use formats different from each other, set this to <code>auto</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-dateformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-dateformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateFormat() {
            return null;
        }

        /**
         * A value that specifies whether AWS DMS should migrate empty CHAR and VARCHAR fields as NULL.
         * <p>
         * A value of <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-emptyasnull">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-emptyasnull</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmptyAsNull() {
            return null;
        }

        /**
         * The type of server-side encryption that you want to use for your data.
         * <p>
         * This encryption type is part of the endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code> .
         * <p>
         * <blockquote>
         * <p>
         * For the <code>ModifyEndpoint</code> operation, you can change the existing value of the <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code> . But you can’t change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code> .
         * <p>
         * </blockquote>
         * <p>
         * To use <code>SSE_S3</code> , create an AWS Identity and Access Management (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-encryptionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-encryptionmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionMode() {
            return null;
        }

        /**
         * This setting is only valid for a full-load migration task.
         * <p>
         * Set <code>ExplicitIds</code> to <code>true</code> to have tables with <code>IDENTITY</code> columns override their auto-generated values with explicit values loaded from the source data files used to populate the tables. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-explicitids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-explicitids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExplicitIds() {
            return null;
        }

        /**
         * The number of threads used to upload a single file.
         * <p>
         * This parameter accepts a value from 1 through 64. It defaults to 10.
         * <p>
         * The number of parallel streams used to upload a single .csv file to an S3 bucket using S3 Multipart Upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload overview</a> .
         * <p>
         * <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It defaults to 10.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-filetransferuploadstreams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-filetransferuploadstreams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFileTransferUploadStreams() {
            return null;
        }

        /**
         * The amount of time to wait (in milliseconds) before timing out of operations performed by AWS DMS on a Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-loadtimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-loadtimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoadTimeout() {
            return null;
        }

        /**
         * When true, lets Redshift migrate the boolean type as boolean.
         * <p>
         * By default, Redshift migrates booleans as <code>varchar(1)</code> . You must set this setting on both the source and target endpoints for it to take effect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-mapbooleanasboolean">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-mapbooleanasboolean</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMapBooleanAsBoolean() {
            return null;
        }

        /**
         * The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer data to Amazon Redshift. It defaults to 1048576KB (1 GB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-maxfilesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-maxfilesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFileSize() {
            return null;
        }

        /**
         * A value that specifies to remove surrounding quotation marks from strings in the incoming data.
         * <p>
         * All characters within the quotation marks, including delimiters, are retained. Choose <code>true</code> to remove quotation marks. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-removequotes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-removequotes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveQuotes() {
            return null;
        }

        /**
         * A value that specifies to replaces the invalid characters specified in <code>ReplaceInvalidChars</code> , substituting the specified characters instead.
         * <p>
         * The default is <code>"?"</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-replacechars">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-replacechars</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplaceChars() {
            return null;
        }

        /**
         * A list of characters that you want to replace.
         * <p>
         * Use with <code>ReplaceChars</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-replaceinvalidchars">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-replaceinvalidchars</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplaceInvalidChars() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the Amazon Redshift endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the Amazon Redshift endpoint connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * The AWS KMS key ID.
         * <p>
         * If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code> , provide this key ID. The key that you use needs an attached policy that enables IAM user permissions and allows use of the key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-serversideencryptionkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-serversideencryptionkmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerSideEncryptionKmsKeyId() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service.
         * <p>
         * The role must allow the <code>iam:PassRole</code> action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-serviceaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-serviceaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * The time format that you want to use.
         * <p>
         * Valid values are <code>auto</code> (case-sensitive), <code>'timeformat_string'</code> , <code>'epochsecs'</code> , or <code>'epochmillisecs'</code> . It defaults to 10. Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a time format string.
         * <p>
         * If your date and time values use formats different from each other, set this parameter to <code>auto</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-timeformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-timeformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeFormat() {
            return null;
        }

        /**
         * A value that specifies to remove the trailing white space characters from a VARCHAR string.
         * <p>
         * This parameter applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove unneeded white space. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-trimblanks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-trimblanks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTrimBlanks() {
            return null;
        }

        /**
         * A value that specifies to truncate data in columns to the appropriate number of characters, so that the data fits in the column.
         * <p>
         * This parameter applies only to columns with a VARCHAR or CHAR data type, and rows with a size of 4 MB or less. Choose <code>true</code> to truncate data. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-truncatecolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-truncatecolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTruncateColumns() {
            return null;
        }

        /**
         * The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk at the DMS replication instance. The default value is 1000 (buffer size is 1000KB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-writebuffersize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-redshiftsettings.html#cfn-dms-endpoint-redshiftsettings-writebuffersize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWriteBufferSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftSettingsProperty> {
            java.lang.Object acceptAnyDate;
            java.lang.String afterConnectScript;
            java.lang.String bucketFolder;
            java.lang.String bucketName;
            java.lang.Object caseSensitiveNames;
            java.lang.Object compUpdate;
            java.lang.Number connectionTimeout;
            java.lang.String dateFormat;
            java.lang.Object emptyAsNull;
            java.lang.String encryptionMode;
            java.lang.Object explicitIds;
            java.lang.Number fileTransferUploadStreams;
            java.lang.Number loadTimeout;
            java.lang.Object mapBooleanAsBoolean;
            java.lang.Number maxFileSize;
            java.lang.Object removeQuotes;
            java.lang.String replaceChars;
            java.lang.String replaceInvalidChars;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;
            java.lang.String serverSideEncryptionKmsKeyId;
            java.lang.String serviceAccessRoleArn;
            java.lang.String timeFormat;
            java.lang.Object trimBlanks;
            java.lang.Object truncateColumns;
            java.lang.Number writeBufferSize;

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getAcceptAnyDate}
             * @param acceptAnyDate A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to be loaded without generating an error.
             *                      You can choose <code>true</code> or <code>false</code> (the default).
             *                      <p>
             *                      This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift inserts a NULL value into that field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceptAnyDate(java.lang.Boolean acceptAnyDate) {
                this.acceptAnyDate = acceptAnyDate;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getAcceptAnyDate}
             * @param acceptAnyDate A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to be loaded without generating an error.
             *                      You can choose <code>true</code> or <code>false</code> (the default).
             *                      <p>
             *                      This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift inserts a NULL value into that field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceptAnyDate(software.amazon.awscdk.IResolvable acceptAnyDate) {
                this.acceptAnyDate = acceptAnyDate;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getAfterConnectScript}
             * @param afterConnectScript Code to run after connecting.
             *                           This parameter should contain the code itself, not the name of a file containing the code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder afterConnectScript(java.lang.String afterConnectScript) {
                this.afterConnectScript = afterConnectScript;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getBucketFolder}
             * @param bucketFolder An S3 folder where the comma-separated-value (.csv) files are stored before being uploaded to the target Redshift cluster.
             *                     For full load mode, AWS DMS converts source records into .csv files and loads them to the <em>BucketFolder/TableID</em> path. AWS DMS uses the Redshift <code>COPY</code> command to upload the .csv files to the target table. The files are deleted once the <code>COPY</code> operation has finished. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in the <em>Amazon Redshift Database Developer Guide</em> .
             *                     <p>
             *                     For change-data-capture (CDC) mode, AWS DMS creates a <em>NetChanges</em> table, and loads the .csv files to this <em>BucketFolder/NetChangesTableID</em> path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketFolder(java.lang.String bucketFolder) {
                this.bucketFolder = bucketFolder;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getBucketName}
             * @param bucketName The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getCaseSensitiveNames}
             * @param caseSensitiveNames If Amazon Redshift is configured to support case sensitive schema names, set <code>CaseSensitiveNames</code> to <code>true</code> .
             *                           The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caseSensitiveNames(java.lang.Boolean caseSensitiveNames) {
                this.caseSensitiveNames = caseSensitiveNames;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getCaseSensitiveNames}
             * @param caseSensitiveNames If Amazon Redshift is configured to support case sensitive schema names, set <code>CaseSensitiveNames</code> to <code>true</code> .
             *                           The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caseSensitiveNames(software.amazon.awscdk.IResolvable caseSensitiveNames) {
                this.caseSensitiveNames = caseSensitiveNames;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getCompUpdate}
             * @param compUpdate If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies automatic compression if the table is empty.
             *                   This applies even if the table columns already have encodings other than <code>RAW</code> . If you set <code>CompUpdate</code> to <code>false</code> , automatic compression is disabled and existing column encodings aren't changed. The default is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compUpdate(java.lang.Boolean compUpdate) {
                this.compUpdate = compUpdate;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getCompUpdate}
             * @param compUpdate If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies automatic compression if the table is empty.
             *                   This applies even if the table columns already have encodings other than <code>RAW</code> . If you set <code>CompUpdate</code> to <code>false</code> , automatic compression is disabled and existing column encodings aren't changed. The default is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compUpdate(software.amazon.awscdk.IResolvable compUpdate) {
                this.compUpdate = compUpdate;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getConnectionTimeout}
             * @param connectionTimeout A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you initially establish a connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionTimeout(java.lang.Number connectionTimeout) {
                this.connectionTimeout = connectionTimeout;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getDateFormat}
             * @param dateFormat The date format that you are using.
             *                   Valid values are <code>auto</code> (case-sensitive), your date format string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of 'YYYY-MM-DD'. Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a date format string.
             *                   <p>
             *                   If your date and time values use formats different from each other, set this to <code>auto</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFormat(java.lang.String dateFormat) {
                this.dateFormat = dateFormat;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getEmptyAsNull}
             * @param emptyAsNull A value that specifies whether AWS DMS should migrate empty CHAR and VARCHAR fields as NULL.
             *                    A value of <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emptyAsNull(java.lang.Boolean emptyAsNull) {
                this.emptyAsNull = emptyAsNull;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getEmptyAsNull}
             * @param emptyAsNull A value that specifies whether AWS DMS should migrate empty CHAR and VARCHAR fields as NULL.
             *                    A value of <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emptyAsNull(software.amazon.awscdk.IResolvable emptyAsNull) {
                this.emptyAsNull = emptyAsNull;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getEncryptionMode}
             * @param encryptionMode The type of server-side encryption that you want to use for your data.
             *                       This encryption type is part of the endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       For the <code>ModifyEndpoint</code> operation, you can change the existing value of the <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code> . But you can’t change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code> .
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       To use <code>SSE_S3</code> , create an AWS Identity and Access Management (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionMode(java.lang.String encryptionMode) {
                this.encryptionMode = encryptionMode;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getExplicitIds}
             * @param explicitIds This setting is only valid for a full-load migration task.
             *                    Set <code>ExplicitIds</code> to <code>true</code> to have tables with <code>IDENTITY</code> columns override their auto-generated values with explicit values loaded from the source data files used to populate the tables. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explicitIds(java.lang.Boolean explicitIds) {
                this.explicitIds = explicitIds;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getExplicitIds}
             * @param explicitIds This setting is only valid for a full-load migration task.
             *                    Set <code>ExplicitIds</code> to <code>true</code> to have tables with <code>IDENTITY</code> columns override their auto-generated values with explicit values loaded from the source data files used to populate the tables. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explicitIds(software.amazon.awscdk.IResolvable explicitIds) {
                this.explicitIds = explicitIds;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getFileTransferUploadStreams}
             * @param fileTransferUploadStreams The number of threads used to upload a single file.
             *                                  This parameter accepts a value from 1 through 64. It defaults to 10.
             *                                  <p>
             *                                  The number of parallel streams used to upload a single .csv file to an S3 bucket using S3 Multipart Upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload overview</a> .
             *                                  <p>
             *                                  <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It defaults to 10.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileTransferUploadStreams(java.lang.Number fileTransferUploadStreams) {
                this.fileTransferUploadStreams = fileTransferUploadStreams;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getLoadTimeout}
             * @param loadTimeout The amount of time to wait (in milliseconds) before timing out of operations performed by AWS DMS on a Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadTimeout(java.lang.Number loadTimeout) {
                this.loadTimeout = loadTimeout;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getMapBooleanAsBoolean}
             * @param mapBooleanAsBoolean When true, lets Redshift migrate the boolean type as boolean.
             *                            By default, Redshift migrates booleans as <code>varchar(1)</code> . You must set this setting on both the source and target endpoints for it to take effect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapBooleanAsBoolean(java.lang.Boolean mapBooleanAsBoolean) {
                this.mapBooleanAsBoolean = mapBooleanAsBoolean;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getMapBooleanAsBoolean}
             * @param mapBooleanAsBoolean When true, lets Redshift migrate the boolean type as boolean.
             *                            By default, Redshift migrates booleans as <code>varchar(1)</code> . You must set this setting on both the source and target endpoints for it to take effect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapBooleanAsBoolean(software.amazon.awscdk.IResolvable mapBooleanAsBoolean) {
                this.mapBooleanAsBoolean = mapBooleanAsBoolean;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getMaxFileSize}
             * @param maxFileSize The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer data to Amazon Redshift. It defaults to 1048576KB (1 GB).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFileSize(java.lang.Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getRemoveQuotes}
             * @param removeQuotes A value that specifies to remove surrounding quotation marks from strings in the incoming data.
             *                     All characters within the quotation marks, including delimiters, are retained. Choose <code>true</code> to remove quotation marks. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeQuotes(java.lang.Boolean removeQuotes) {
                this.removeQuotes = removeQuotes;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getRemoveQuotes}
             * @param removeQuotes A value that specifies to remove surrounding quotation marks from strings in the incoming data.
             *                     All characters within the quotation marks, including delimiters, are retained. Choose <code>true</code> to remove quotation marks. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeQuotes(software.amazon.awscdk.IResolvable removeQuotes) {
                this.removeQuotes = removeQuotes;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getReplaceChars}
             * @param replaceChars A value that specifies to replaces the invalid characters specified in <code>ReplaceInvalidChars</code> , substituting the specified characters instead.
             *                     The default is <code>"?"</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceChars(java.lang.String replaceChars) {
                this.replaceChars = replaceChars;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getReplaceInvalidChars}
             * @param replaceInvalidChars A list of characters that you want to replace.
             *                            Use with <code>ReplaceChars</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceInvalidChars(java.lang.String replaceInvalidChars) {
                this.replaceInvalidChars = replaceInvalidChars;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
             *                                    The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the Amazon Redshift endpoint.
             *                                    <p>
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
             *                                    <p>
             *                                    For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the Amazon Redshift endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getServerSideEncryptionKmsKeyId}
             * @param serverSideEncryptionKmsKeyId The AWS KMS key ID.
             *                                     If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code> , provide this key ID. The key that you use needs an attached policy that enables IAM user permissions and allows use of the key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionKmsKeyId(java.lang.String serverSideEncryptionKmsKeyId) {
                this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service.
             *                             The role must allow the <code>iam:PassRole</code> action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getTimeFormat}
             * @param timeFormat The time format that you want to use.
             *                   Valid values are <code>auto</code> (case-sensitive), <code>'timeformat_string'</code> , <code>'epochsecs'</code> , or <code>'epochmillisecs'</code> . It defaults to 10. Using <code>auto</code> recognizes most strings, even some that aren't supported when you use a time format string.
             *                   <p>
             *                   If your date and time values use formats different from each other, set this parameter to <code>auto</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeFormat(java.lang.String timeFormat) {
                this.timeFormat = timeFormat;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getTrimBlanks}
             * @param trimBlanks A value that specifies to remove the trailing white space characters from a VARCHAR string.
             *                   This parameter applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove unneeded white space. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trimBlanks(java.lang.Boolean trimBlanks) {
                this.trimBlanks = trimBlanks;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getTrimBlanks}
             * @param trimBlanks A value that specifies to remove the trailing white space characters from a VARCHAR string.
             *                   This parameter applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove unneeded white space. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trimBlanks(software.amazon.awscdk.IResolvable trimBlanks) {
                this.trimBlanks = trimBlanks;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getTruncateColumns}
             * @param truncateColumns A value that specifies to truncate data in columns to the appropriate number of characters, so that the data fits in the column.
             *                        This parameter applies only to columns with a VARCHAR or CHAR data type, and rows with a size of 4 MB or less. Choose <code>true</code> to truncate data. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder truncateColumns(java.lang.Boolean truncateColumns) {
                this.truncateColumns = truncateColumns;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getTruncateColumns}
             * @param truncateColumns A value that specifies to truncate data in columns to the appropriate number of characters, so that the data fits in the column.
             *                        This parameter applies only to columns with a VARCHAR or CHAR data type, and rows with a size of 4 MB or less. Choose <code>true</code> to truncate data. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder truncateColumns(software.amazon.awscdk.IResolvable truncateColumns) {
                this.truncateColumns = truncateColumns;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getWriteBufferSize}
             * @param writeBufferSize The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk at the DMS replication instance. The default value is 1000 (buffer size is 1000KB).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeBufferSize(java.lang.Number writeBufferSize) {
                this.writeBufferSize = writeBufferSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftSettingsProperty {
            private final java.lang.Object acceptAnyDate;
            private final java.lang.String afterConnectScript;
            private final java.lang.String bucketFolder;
            private final java.lang.String bucketName;
            private final java.lang.Object caseSensitiveNames;
            private final java.lang.Object compUpdate;
            private final java.lang.Number connectionTimeout;
            private final java.lang.String dateFormat;
            private final java.lang.Object emptyAsNull;
            private final java.lang.String encryptionMode;
            private final java.lang.Object explicitIds;
            private final java.lang.Number fileTransferUploadStreams;
            private final java.lang.Number loadTimeout;
            private final java.lang.Object mapBooleanAsBoolean;
            private final java.lang.Number maxFileSize;
            private final java.lang.Object removeQuotes;
            private final java.lang.String replaceChars;
            private final java.lang.String replaceInvalidChars;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.String serverSideEncryptionKmsKeyId;
            private final java.lang.String serviceAccessRoleArn;
            private final java.lang.String timeFormat;
            private final java.lang.Object trimBlanks;
            private final java.lang.Object truncateColumns;
            private final java.lang.Number writeBufferSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acceptAnyDate = software.amazon.jsii.Kernel.get(this, "acceptAnyDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.afterConnectScript = software.amazon.jsii.Kernel.get(this, "afterConnectScript", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketFolder = software.amazon.jsii.Kernel.get(this, "bucketFolder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.caseSensitiveNames = software.amazon.jsii.Kernel.get(this, "caseSensitiveNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compUpdate = software.amazon.jsii.Kernel.get(this, "compUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectionTimeout = software.amazon.jsii.Kernel.get(this, "connectionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dateFormat = software.amazon.jsii.Kernel.get(this, "dateFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emptyAsNull = software.amazon.jsii.Kernel.get(this, "emptyAsNull", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionMode = software.amazon.jsii.Kernel.get(this, "encryptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.explicitIds = software.amazon.jsii.Kernel.get(this, "explicitIds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fileTransferUploadStreams = software.amazon.jsii.Kernel.get(this, "fileTransferUploadStreams", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.loadTimeout = software.amazon.jsii.Kernel.get(this, "loadTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mapBooleanAsBoolean = software.amazon.jsii.Kernel.get(this, "mapBooleanAsBoolean", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxFileSize = software.amazon.jsii.Kernel.get(this, "maxFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.removeQuotes = software.amazon.jsii.Kernel.get(this, "removeQuotes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.replaceChars = software.amazon.jsii.Kernel.get(this, "replaceChars", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.replaceInvalidChars = software.amazon.jsii.Kernel.get(this, "replaceInvalidChars", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverSideEncryptionKmsKeyId = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeFormat = software.amazon.jsii.Kernel.get(this, "timeFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trimBlanks = software.amazon.jsii.Kernel.get(this, "trimBlanks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.truncateColumns = software.amazon.jsii.Kernel.get(this, "truncateColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.writeBufferSize = software.amazon.jsii.Kernel.get(this, "writeBufferSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acceptAnyDate = builder.acceptAnyDate;
                this.afterConnectScript = builder.afterConnectScript;
                this.bucketFolder = builder.bucketFolder;
                this.bucketName = builder.bucketName;
                this.caseSensitiveNames = builder.caseSensitiveNames;
                this.compUpdate = builder.compUpdate;
                this.connectionTimeout = builder.connectionTimeout;
                this.dateFormat = builder.dateFormat;
                this.emptyAsNull = builder.emptyAsNull;
                this.encryptionMode = builder.encryptionMode;
                this.explicitIds = builder.explicitIds;
                this.fileTransferUploadStreams = builder.fileTransferUploadStreams;
                this.loadTimeout = builder.loadTimeout;
                this.mapBooleanAsBoolean = builder.mapBooleanAsBoolean;
                this.maxFileSize = builder.maxFileSize;
                this.removeQuotes = builder.removeQuotes;
                this.replaceChars = builder.replaceChars;
                this.replaceInvalidChars = builder.replaceInvalidChars;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.serverSideEncryptionKmsKeyId = builder.serverSideEncryptionKmsKeyId;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
                this.timeFormat = builder.timeFormat;
                this.trimBlanks = builder.trimBlanks;
                this.truncateColumns = builder.truncateColumns;
                this.writeBufferSize = builder.writeBufferSize;
            }

            @Override
            public final java.lang.Object getAcceptAnyDate() {
                return this.acceptAnyDate;
            }

            @Override
            public final java.lang.String getAfterConnectScript() {
                return this.afterConnectScript;
            }

            @Override
            public final java.lang.String getBucketFolder() {
                return this.bucketFolder;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.Object getCaseSensitiveNames() {
                return this.caseSensitiveNames;
            }

            @Override
            public final java.lang.Object getCompUpdate() {
                return this.compUpdate;
            }

            @Override
            public final java.lang.Number getConnectionTimeout() {
                return this.connectionTimeout;
            }

            @Override
            public final java.lang.String getDateFormat() {
                return this.dateFormat;
            }

            @Override
            public final java.lang.Object getEmptyAsNull() {
                return this.emptyAsNull;
            }

            @Override
            public final java.lang.String getEncryptionMode() {
                return this.encryptionMode;
            }

            @Override
            public final java.lang.Object getExplicitIds() {
                return this.explicitIds;
            }

            @Override
            public final java.lang.Number getFileTransferUploadStreams() {
                return this.fileTransferUploadStreams;
            }

            @Override
            public final java.lang.Number getLoadTimeout() {
                return this.loadTimeout;
            }

            @Override
            public final java.lang.Object getMapBooleanAsBoolean() {
                return this.mapBooleanAsBoolean;
            }

            @Override
            public final java.lang.Number getMaxFileSize() {
                return this.maxFileSize;
            }

            @Override
            public final java.lang.Object getRemoveQuotes() {
                return this.removeQuotes;
            }

            @Override
            public final java.lang.String getReplaceChars() {
                return this.replaceChars;
            }

            @Override
            public final java.lang.String getReplaceInvalidChars() {
                return this.replaceInvalidChars;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getServerSideEncryptionKmsKeyId() {
                return this.serverSideEncryptionKmsKeyId;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getTimeFormat() {
                return this.timeFormat;
            }

            @Override
            public final java.lang.Object getTrimBlanks() {
                return this.trimBlanks;
            }

            @Override
            public final java.lang.Object getTruncateColumns() {
                return this.truncateColumns;
            }

            @Override
            public final java.lang.Number getWriteBufferSize() {
                return this.writeBufferSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcceptAnyDate() != null) {
                    data.set("acceptAnyDate", om.valueToTree(this.getAcceptAnyDate()));
                }
                if (this.getAfterConnectScript() != null) {
                    data.set("afterConnectScript", om.valueToTree(this.getAfterConnectScript()));
                }
                if (this.getBucketFolder() != null) {
                    data.set("bucketFolder", om.valueToTree(this.getBucketFolder()));
                }
                if (this.getBucketName() != null) {
                    data.set("bucketName", om.valueToTree(this.getBucketName()));
                }
                if (this.getCaseSensitiveNames() != null) {
                    data.set("caseSensitiveNames", om.valueToTree(this.getCaseSensitiveNames()));
                }
                if (this.getCompUpdate() != null) {
                    data.set("compUpdate", om.valueToTree(this.getCompUpdate()));
                }
                if (this.getConnectionTimeout() != null) {
                    data.set("connectionTimeout", om.valueToTree(this.getConnectionTimeout()));
                }
                if (this.getDateFormat() != null) {
                    data.set("dateFormat", om.valueToTree(this.getDateFormat()));
                }
                if (this.getEmptyAsNull() != null) {
                    data.set("emptyAsNull", om.valueToTree(this.getEmptyAsNull()));
                }
                if (this.getEncryptionMode() != null) {
                    data.set("encryptionMode", om.valueToTree(this.getEncryptionMode()));
                }
                if (this.getExplicitIds() != null) {
                    data.set("explicitIds", om.valueToTree(this.getExplicitIds()));
                }
                if (this.getFileTransferUploadStreams() != null) {
                    data.set("fileTransferUploadStreams", om.valueToTree(this.getFileTransferUploadStreams()));
                }
                if (this.getLoadTimeout() != null) {
                    data.set("loadTimeout", om.valueToTree(this.getLoadTimeout()));
                }
                if (this.getMapBooleanAsBoolean() != null) {
                    data.set("mapBooleanAsBoolean", om.valueToTree(this.getMapBooleanAsBoolean()));
                }
                if (this.getMaxFileSize() != null) {
                    data.set("maxFileSize", om.valueToTree(this.getMaxFileSize()));
                }
                if (this.getRemoveQuotes() != null) {
                    data.set("removeQuotes", om.valueToTree(this.getRemoveQuotes()));
                }
                if (this.getReplaceChars() != null) {
                    data.set("replaceChars", om.valueToTree(this.getReplaceChars()));
                }
                if (this.getReplaceInvalidChars() != null) {
                    data.set("replaceInvalidChars", om.valueToTree(this.getReplaceInvalidChars()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getServerSideEncryptionKmsKeyId() != null) {
                    data.set("serverSideEncryptionKmsKeyId", om.valueToTree(this.getServerSideEncryptionKmsKeyId()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }
                if (this.getTimeFormat() != null) {
                    data.set("timeFormat", om.valueToTree(this.getTimeFormat()));
                }
                if (this.getTrimBlanks() != null) {
                    data.set("trimBlanks", om.valueToTree(this.getTrimBlanks()));
                }
                if (this.getTruncateColumns() != null) {
                    data.set("truncateColumns", om.valueToTree(this.getTruncateColumns()));
                }
                if (this.getWriteBufferSize() != null) {
                    data.set("writeBufferSize", om.valueToTree(this.getWriteBufferSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.RedshiftSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftSettingsProperty.Jsii$Proxy that = (RedshiftSettingsProperty.Jsii$Proxy) o;

                if (this.acceptAnyDate != null ? !this.acceptAnyDate.equals(that.acceptAnyDate) : that.acceptAnyDate != null) return false;
                if (this.afterConnectScript != null ? !this.afterConnectScript.equals(that.afterConnectScript) : that.afterConnectScript != null) return false;
                if (this.bucketFolder != null ? !this.bucketFolder.equals(that.bucketFolder) : that.bucketFolder != null) return false;
                if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
                if (this.caseSensitiveNames != null ? !this.caseSensitiveNames.equals(that.caseSensitiveNames) : that.caseSensitiveNames != null) return false;
                if (this.compUpdate != null ? !this.compUpdate.equals(that.compUpdate) : that.compUpdate != null) return false;
                if (this.connectionTimeout != null ? !this.connectionTimeout.equals(that.connectionTimeout) : that.connectionTimeout != null) return false;
                if (this.dateFormat != null ? !this.dateFormat.equals(that.dateFormat) : that.dateFormat != null) return false;
                if (this.emptyAsNull != null ? !this.emptyAsNull.equals(that.emptyAsNull) : that.emptyAsNull != null) return false;
                if (this.encryptionMode != null ? !this.encryptionMode.equals(that.encryptionMode) : that.encryptionMode != null) return false;
                if (this.explicitIds != null ? !this.explicitIds.equals(that.explicitIds) : that.explicitIds != null) return false;
                if (this.fileTransferUploadStreams != null ? !this.fileTransferUploadStreams.equals(that.fileTransferUploadStreams) : that.fileTransferUploadStreams != null) return false;
                if (this.loadTimeout != null ? !this.loadTimeout.equals(that.loadTimeout) : that.loadTimeout != null) return false;
                if (this.mapBooleanAsBoolean != null ? !this.mapBooleanAsBoolean.equals(that.mapBooleanAsBoolean) : that.mapBooleanAsBoolean != null) return false;
                if (this.maxFileSize != null ? !this.maxFileSize.equals(that.maxFileSize) : that.maxFileSize != null) return false;
                if (this.removeQuotes != null ? !this.removeQuotes.equals(that.removeQuotes) : that.removeQuotes != null) return false;
                if (this.replaceChars != null ? !this.replaceChars.equals(that.replaceChars) : that.replaceChars != null) return false;
                if (this.replaceInvalidChars != null ? !this.replaceInvalidChars.equals(that.replaceInvalidChars) : that.replaceInvalidChars != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                if (this.serverSideEncryptionKmsKeyId != null ? !this.serverSideEncryptionKmsKeyId.equals(that.serverSideEncryptionKmsKeyId) : that.serverSideEncryptionKmsKeyId != null) return false;
                if (this.serviceAccessRoleArn != null ? !this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn != null) return false;
                if (this.timeFormat != null ? !this.timeFormat.equals(that.timeFormat) : that.timeFormat != null) return false;
                if (this.trimBlanks != null ? !this.trimBlanks.equals(that.trimBlanks) : that.trimBlanks != null) return false;
                if (this.truncateColumns != null ? !this.truncateColumns.equals(that.truncateColumns) : that.truncateColumns != null) return false;
                return this.writeBufferSize != null ? this.writeBufferSize.equals(that.writeBufferSize) : that.writeBufferSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acceptAnyDate != null ? this.acceptAnyDate.hashCode() : 0;
                result = 31 * result + (this.afterConnectScript != null ? this.afterConnectScript.hashCode() : 0);
                result = 31 * result + (this.bucketFolder != null ? this.bucketFolder.hashCode() : 0);
                result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
                result = 31 * result + (this.caseSensitiveNames != null ? this.caseSensitiveNames.hashCode() : 0);
                result = 31 * result + (this.compUpdate != null ? this.compUpdate.hashCode() : 0);
                result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
                result = 31 * result + (this.dateFormat != null ? this.dateFormat.hashCode() : 0);
                result = 31 * result + (this.emptyAsNull != null ? this.emptyAsNull.hashCode() : 0);
                result = 31 * result + (this.encryptionMode != null ? this.encryptionMode.hashCode() : 0);
                result = 31 * result + (this.explicitIds != null ? this.explicitIds.hashCode() : 0);
                result = 31 * result + (this.fileTransferUploadStreams != null ? this.fileTransferUploadStreams.hashCode() : 0);
                result = 31 * result + (this.loadTimeout != null ? this.loadTimeout.hashCode() : 0);
                result = 31 * result + (this.mapBooleanAsBoolean != null ? this.mapBooleanAsBoolean.hashCode() : 0);
                result = 31 * result + (this.maxFileSize != null ? this.maxFileSize.hashCode() : 0);
                result = 31 * result + (this.removeQuotes != null ? this.removeQuotes.hashCode() : 0);
                result = 31 * result + (this.replaceChars != null ? this.replaceChars.hashCode() : 0);
                result = 31 * result + (this.replaceInvalidChars != null ? this.replaceInvalidChars.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.serverSideEncryptionKmsKeyId != null ? this.serverSideEncryptionKmsKeyId.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.timeFormat != null ? this.timeFormat.hashCode() : 0);
                result = 31 * result + (this.trimBlanks != null ? this.trimBlanks.hashCode() : 0);
                result = 31 * result + (this.truncateColumns != null ? this.truncateColumns.hashCode() : 0);
                result = 31 * result + (this.writeBufferSize != null ? this.writeBufferSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines an Amazon S3 endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.S3.html#CHAP_Source.S3.Configuring">Extra connection attributes when using Amazon S3 as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra connection attributes when using Amazon S3 as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * S3SettingsProperty s3SettingsProperty = S3SettingsProperty.builder()
     *         .addColumnName(false)
     *         .addTrailingPaddingCharacter(false)
     *         .bucketFolder("bucketFolder")
     *         .bucketName("bucketName")
     *         .cannedAclForObjects("cannedAclForObjects")
     *         .cdcInsertsAndUpdates(false)
     *         .cdcInsertsOnly(false)
     *         .cdcMaxBatchInterval(123)
     *         .cdcMinFileSize(123)
     *         .cdcPath("cdcPath")
     *         .compressionType("compressionType")
     *         .csvDelimiter("csvDelimiter")
     *         .csvNoSupValue("csvNoSupValue")
     *         .csvNullValue("csvNullValue")
     *         .csvRowDelimiter("csvRowDelimiter")
     *         .dataFormat("dataFormat")
     *         .dataPageSize(123)
     *         .datePartitionDelimiter("datePartitionDelimiter")
     *         .datePartitionEnabled(false)
     *         .datePartitionSequence("datePartitionSequence")
     *         .datePartitionTimezone("datePartitionTimezone")
     *         .dictPageSizeLimit(123)
     *         .enableStatistics(false)
     *         .encodingType("encodingType")
     *         .encryptionMode("encryptionMode")
     *         .expectedBucketOwner("expectedBucketOwner")
     *         .externalTableDefinition("externalTableDefinition")
     *         .glueCatalogGeneration(false)
     *         .ignoreHeaderRows(123)
     *         .includeOpForFullLoad(false)
     *         .maxFileSize(123)
     *         .parquetTimestampInMillisecond(false)
     *         .parquetVersion("parquetVersion")
     *         .preserveTransactions(false)
     *         .rfc4180(false)
     *         .rowGroupLength(123)
     *         .serverSideEncryptionKmsKeyId("serverSideEncryptionKmsKeyId")
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .timestampColumnName("timestampColumnName")
     *         .useCsvNoSupValue(false)
     *         .useTaskStartTimeForFullLoadTimestamp(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.S3SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(S3SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An optional parameter that, when set to <code>true</code> or <code>y</code> , you can use to add column name information to the .csv output file.
         * <p>
         * The default value is <code>false</code> . Valid values are <code>true</code> , <code>false</code> , <code>y</code> , and <code>n</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-addcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-addcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddColumnName() {
            return null;
        }

        /**
         * Use the S3 target endpoint setting <code>AddTrailingPaddingCharacter</code> to add padding on string data.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-addtrailingpaddingcharacter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-addtrailingpaddingcharacter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddTrailingPaddingCharacter() {
            return null;
        }

        /**
         * An optional parameter to set a folder name in the S3 bucket.
         * <p>
         * If provided, tables are created in the path <code>*bucketFolder* / *schema_name* / *table_name* /</code> . If this parameter isn't specified, the path used is <code>*schema_name* / *table_name* /</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-bucketfolder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-bucketfolder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketFolder() {
            return null;
        }

        /**
         * The name of the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
            return null;
        }

        /**
         * A value that enables AWS DMS to specify a predefined (canned) access control list (ACL) for objects created in an Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 Developer Guide</em> .
         * <p>
         * The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE, AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cannedaclforobjects">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cannedaclforobjects</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCannedAclForObjects() {
            return null;
        }

        /**
         * A value that enables a change data capture (CDC) load to write INSERT and UPDATE operations to .csv or .parquet (columnar storage) output files. The default setting is <code>false</code> , but when <code>CdcInsertsAndUpdates</code> is set to <code>true</code> or <code>y</code> , only INSERTs and UPDATEs from the source database are migrated to the .csv or .parquet file.
         * <p>
         * For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the value of the <code>IncludeOpForFullLoad</code> parameter. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> , the first field of every CDC record is set to either <code>I</code> or <code>U</code> to indicate INSERT and UPDATE operations at the source. But if <code>IncludeOpForFullLoad</code> is set to <code>false</code> , CDC records are written without an indication of INSERT or UPDATE operations at the source. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * AWS DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in versions 3.3.1 and later.
         * <p>
         * <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code> for the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code> for the same endpoint, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cdcinsertsandupdates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cdcinsertsandupdates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCdcInsertsAndUpdates() {
            return null;
        }

        /**
         * A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar storage (.parquet) output files. By default (the <code>false</code> setting), the first field in a .csv or .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was inserted, updated, or deleted at the source database for a CDC load to the target.
         * <p>
         * If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code> , only INSERTs from the source database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are recorded depends on the value of <code>IncludeOpForFullLoad</code> . If <code>IncludeOpForFullLoad</code> is set to <code>true</code> , the first field of every CDC record is set to I to indicate the INSERT operation at the source. If <code>IncludeOpForFullLoad</code> is set to <code>false</code> , every CDC record is written without a first field to indicate the INSERT operation at the source. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * AWS DMS supports the interaction described preceding between the <code>CdcInsertsOnly</code> and <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later.
         * <p>
         * <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code> for the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code> for the same endpoint, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cdcinsertsonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cdcinsertsonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCdcInsertsOnly() {
            return null;
        }

        /**
         * Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.
         * <p>
         * When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the file write is triggered by whichever parameter condition is met first within an AWS DMS CloudFormation template.
         * <p>
         * The default value is 60 seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cdcmaxbatchinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cdcmaxbatchinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCdcMaxBatchInterval() {
            return null;
        }

        /**
         * Minimum file size, defined in kilobytes, to reach for a file output to Amazon S3.
         * <p>
         * When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file write is triggered by whichever parameter condition is met first within an AWS DMS CloudFormation template.
         * <p>
         * The default value is 32 MB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cdcminfilesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cdcminfilesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCdcMinFileSize() {
            return null;
        }

        /**
         * Specifies the folder path of CDC files.
         * <p>
         * For an S3 source, this setting is required if a task captures change data; otherwise, it's optional. If <code>CdcPath</code> is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. For an S3 target if you set <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions"><code>PreserveTransactions</code></a> to <code>true</code> , AWS DMS verifies that you have set this parameter to a folder path on your S3 target where AWS DMS can save the transaction order for the CDC load. AWS DMS creates this CDC folder path in either your S3 target working directory or the S3 target location specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder"><code>BucketFolder</code></a> and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName"><code>BucketName</code></a> .
         * <p>
         * For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code> , and you specify <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify <code>BucketFolder</code> , AWS DMS creates the CDC folder path following: <code>MyTargetBucket/MyChangedData</code> .
         * <p>
         * If you specify the same <code>CdcPath</code> , and you specify <code>BucketName</code> as <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code> , AWS DMS creates the CDC folder path following: <code>MyTargetBucket/MyTargetData/MyChangedData</code> .
         * <p>
         * For more information on CDC including transaction order on an S3 target, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3 target</a> .
         * <p>
         * <blockquote>
         * <p>
         * This setting is supported in AWS DMS versions 3.4.2 and later.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cdcpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-cdcpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCdcPath() {
            return null;
        }

        /**
         * An optional parameter.
         * <p>
         * When set to GZIP it enables the service to compress the target files. To allow the service to write the target files uncompressed, either set this parameter to NONE (the default) or don't specify the parameter at all. This parameter applies to both .csv and .parquet file formats.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-compressiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-compressiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompressionType() {
            return null;
        }

        /**
         * The delimiter used to separate columns in the .csv file for both source and target. The default is a comma.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvdelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvdelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCsvDelimiter() {
            return null;
        }

        /**
         * This setting only applies if your Amazon S3 output files during a change data capture (CDC) load are written in .csv format. If <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue"><code>UseCsvNoSupValue</code></a> is set to true, specify a string value that you want AWS DMS to use for all columns not included in the supplemental log. If you do not specify a string value, AWS DMS uses the null value for these columns regardless of the <code>UseCsvNoSupValue</code> setting.
         * <p>
         * <blockquote>
         * <p>
         * This setting is supported in AWS DMS versions 3.4.1 and later.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvnosupvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvnosupvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCsvNoSupValue() {
            return null;
        }

        /**
         * An optional parameter that specifies how AWS DMS treats null values.
         * <p>
         * While handling the null value, you can use this parameter to pass a user-defined string as null when writing to the target. For example, when target columns are not nullable, you can use this option to differentiate between the empty string value and the null value. So, if you set this parameter value to the empty string ("" or ''), AWS DMS treats the empty string as the null value instead of <code>NULL</code> .
         * <p>
         * The default value is <code>NULL</code> . Valid values include any valid string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvnullvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvnullvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCsvNullValue() {
            return null;
        }

        /**
         * The delimiter used to separate rows in the .csv file for both source and target.
         * <p>
         * The default is a carriage return ( <code>\n</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvrowdelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvrowdelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCsvRowDelimiter() {
            return null;
        }

        /**
         * The format of the data that you want to use for output. You can choose one of the following:.
         * <p>
         * <ul>
         * <li><code>csv</code> : This is a row-based file format with comma-separated values (.csv).</li>
         * <li><code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient compression and provides faster query response.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-dataformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-dataformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataFormat() {
            return null;
        }

        /**
         * The size of one data page in bytes.
         * <p>
         * This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is used for .parquet file format only.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-datapagesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-datapagesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDataPageSize() {
            return null;
        }

        /**
         * Specifies a date separating delimiter to use during folder partitioning.
         * <p>
         * The default value is <code>SLASH</code> . Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-datepartitiondelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-datepartitiondelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatePartitionDelimiter() {
            return null;
        }

        /**
         * When set to <code>true</code> , this parameter partitions S3 bucket folders based on transaction commit dates.
         * <p>
         * The default value is <code>false</code> . For more information about date-based folder partitioning, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning">Using date-based folder partitioning</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-datepartitionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-datepartitionenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatePartitionEnabled() {
            return null;
        }

        /**
         * Identifies the sequence of the date format to use during folder partitioning.
         * <p>
         * The default value is <code>YYYYMMDD</code> . Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-datepartitionsequence">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-datepartitionsequence</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatePartitionSequence() {
            return null;
        }

        /**
         * When creating an S3 target endpoint, set <code>DatePartitionTimezone</code> to convert the current UTC time into a specified time zone.
         * <p>
         * The conversion occurs when a date partition folder is created and a change data capture (CDC) file name is generated. The time zone format is Area/Location. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code> , as shown in the following example.
         * <p>
         * <code>s3-settings='{"DatePartitionEnabled": true, "DatePartitionSequence": "YYYYMMDDHH", "DatePartitionDelimiter": "SLASH", "DatePartitionTimezone":" *Asia/Seoul* ", "BucketName": "dms-nattarat-test"}'</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-datepartitiontimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-datepartitiontimezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatePartitionTimezone() {
            return null;
        }

        /**
         * The maximum size of an encoded dictionary page of a column.
         * <p>
         * If the dictionary page exceeds this, this column is stored using an encoding type of <code>PLAIN</code> . This parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding. This size is used for .parquet file format only.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-dictpagesizelimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-dictpagesizelimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDictPageSizeLimit() {
            return null;
        }

        /**
         * A value that enables statistics for Parquet pages and row groups.
         * <p>
         * Choose <code>true</code> to enable statistics, <code>false</code> to disable. Statistics include <code>NULL</code> , <code>DISTINCT</code> , <code>MAX</code> , and <code>MIN</code> values. This parameter defaults to <code>true</code> . This value is used for .parquet file format only.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-enablestatistics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-enablestatistics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableStatistics() {
            return null;
        }

        /**
         * The type of encoding that you're using:.
         * <p>
         * <ul>
         * <li><code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated values more efficiently. This is the default.</li>
         * <li><code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.</li>
         * <li><code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary is stored in a dictionary page for each column chunk.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-encodingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-encodingtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncodingType() {
            return null;
        }

        /**
         * The type of server-side encryption that you want to use for your data.
         * <p>
         * This encryption type is part of the endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code> .
         * <p>
         * <blockquote>
         * <p>
         * For the <code>ModifyEndpoint</code> operation, you can change the existing value of the <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code> . But you can’t change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code> .
         * <p>
         * </blockquote>
         * <p>
         * To use <code>SSE_S3</code> , you need an IAM role with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
         * <p>
         * <ul>
         * <li><code>s3:CreateBucket</code></li>
         * <li><code>s3:ListBucket</code></li>
         * <li><code>s3:DeleteBucket</code></li>
         * <li><code>s3:GetBucketLocation</code></li>
         * <li><code>s3:GetObject</code></li>
         * <li><code>s3:PutObject</code></li>
         * <li><code>s3:DeleteObject</code></li>
         * <li><code>s3:GetObjectVersion</code></li>
         * <li><code>s3:GetBucketPolicy</code></li>
         * <li><code>s3:PutBucketPolicy</code></li>
         * <li><code>s3:DeleteBucketPolicy</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-encryptionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-encryptionmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionMode() {
            return null;
        }

        /**
         * To specify a bucket owner and prevent sniping, you can use the <code>ExpectedBucketOwner</code> endpoint setting.
         * <p>
         * Example: <code>--s3-settings='{"ExpectedBucketOwner": " *AWS_Account_ID* "}'</code>
         * <p>
         * When you make a request to test a connection or perform a migration, S3 checks the account ID of the bucket owner against the specified parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-expectedbucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-expectedbucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpectedBucketOwner() {
            return null;
        }

        /**
         * The external table definition.
         * <p>
         * Conditional: If <code>S3</code> is used as a source then <code>ExternalTableDefinition</code> is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-externaltabledefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-externaltabledefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalTableDefinition() {
            return null;
        }

        /**
         * When true, allows AWS Glue to catalog your S3 bucket.
         * <p>
         * Creating an AWS Glue catalog lets you use Athena to query your data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-gluecataloggeneration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-gluecataloggeneration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlueCatalogGeneration() {
            return null;
        }

        /**
         * When this value is set to 1, AWS DMS ignores the first row header in a .csv file. A value of 1 turns on the feature; a value of 0 turns off the feature.
         * <p>
         * The default is 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-ignoreheaderrows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-ignoreheaderrows</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIgnoreHeaderRows() {
            return null;
        }

        /**
         * A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output files only to indicate how the rows were added to the source database.
         * <p>
         * <blockquote>
         * <p>
         * AWS DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
         * <p>
         * </blockquote>
         * <p>
         * For full load, records can only be inserted. By default (the <code>false</code> setting), no information is recorded in these output files for a full load to indicate that the rows were inserted at the source database. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> or <code>y</code> , the INSERT is recorded as an I annotation in the first field of the .csv file. This allows the format of your target records from a full load to be consistent with the target records from a CDC load.
         * <p>
         * <blockquote>
         * <p>
         * This setting works together with the <code>CdcInsertsOnly</code> and the <code>CdcInsertsAndUpdates</code> parameters for output to .csv files only. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-includeopforfullload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-includeopforfullload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeOpForFullLoad() {
            return null;
        }

        /**
         * A value that specifies the maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load.
         * <p>
         * The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-maxfilesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-maxfilesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFileSize() {
            return null;
        }

        /**
         * A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to an Amazon S3 object file in .parquet format.
         * <p>
         * <blockquote>
         * <p>
         * AWS DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
         * <p>
         * </blockquote>
         * <p>
         * When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code> , AWS DMS writes all <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision. Otherwise, DMS writes them with microsecond precision.
         * <p>
         * Currently, Amazon Athena and AWS Glue can handle only millisecond precision for <code>TIMESTAMP</code> values. Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet formatted only if you plan to query or process the data with Athena or AWS Glue .
         * <p>
         * <blockquote>
         * <p>
         * AWS DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with microsecond precision.
         * <p>
         * Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp column value that is inserted by setting the <code>TimestampColumnName</code> parameter.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-parquettimestampinmillisecond">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-parquettimestampinmillisecond</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParquetTimestampInMillisecond() {
            return null;
        }

        /**
         * The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or <code>parquet_2_0</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-parquetversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-parquetversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParquetVersion() {
            return null;
        }

        /**
         * If this setting is set to <code>true</code> , AWS DMS saves the transaction order for a change data capture (CDC) load on the Amazon S3 target specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath"><code>CdcPath</code></a> . For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3 target</a> .
         * <p>
         * <blockquote>
         * <p>
         * This setting is supported in AWS DMS versions 3.4.2 and later.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-preservetransactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-preservetransactions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPreserveTransactions() {
            return null;
        }

        /**
         * For an S3 source, when this value is set to <code>true</code> or <code>y</code> , each leading double quotation mark has to be followed by an ending double quotation mark.
         * <p>
         * This formatting complies with RFC 4180. When this value is set to <code>false</code> or <code>n</code> , string literals are copied to the target as is. In this case, a delimiter (row or column) signals the end of the field. Thus, you can't use a delimiter as part of the string, because it signals the end of the value.
         * <p>
         * For an S3 target, an optional parameter used to set behavior to comply with RFC 4180 for data migrated to Amazon S3 using .csv file format only. When this value is set to <code>true</code> or <code>y</code> using Amazon S3 as a target, if the data has quotation marks or newline characters in it, AWS DMS encloses the entire column with an additional pair of double quotation marks ("). Every quotation mark within the data is repeated twice.
         * <p>
         * The default value is <code>true</code> . Valid values include <code>true</code> , <code>false</code> , <code>y</code> , and <code>n</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-rfc4180">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-rfc4180</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRfc4180() {
            return null;
        }

        /**
         * The number of rows in a row group.
         * <p>
         * A smaller row group size provides faster reads. But as the number of row groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used for .parquet file format only.
         * <p>
         * If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group length in bytes (64 * 1024 * 1024).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-rowgrouplength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-rowgrouplength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRowGroupLength() {
            return null;
        }

        /**
         * If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code> , provide the AWS KMS key ID.
         * <p>
         * The key that you use needs an attached policy that enables IAM user permissions and allows use of the key.
         * <p>
         * Here is a CLI example: <code>aws dms create-endpoint --endpoint-identifier *value* --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn= *value* ,BucketFolder= *value* ,BucketName= *value* ,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId= *value*</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-serversideencryptionkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-serversideencryptionkmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerSideEncryptionKmsKeyId() {
            return null;
        }

        /**
         * A required parameter that specifies the Amazon Resource Name (ARN) used by the service to access the IAM role.
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. It enables AWS DMS to read and write objects from an S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-serviceaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-serviceaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * A value that when nonblank causes AWS DMS to add a column with timestamp information to the endpoint data for an Amazon S3 target.
         * <p>
         * <blockquote>
         * <p>
         * AWS DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.
         * <p>
         * </blockquote>
         * <p>
         * AWS DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your migrated data when you set <code>TimestampColumnName</code> to a nonblank value.
         * <p>
         * For a full load, each row of this timestamp column contains a timestamp for when the data was transferred from the source to the target by DMS.
         * <p>
         * For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the commit of that row in the source database.
         * <p>
         * The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code> . By default, the precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on the commit timestamp supported by DMS for the source database.
         * <p>
         * When the <code>AddColumnName</code> parameter is set to <code>true</code> , DMS also includes a name for the timestamp column that you set with <code>TimestampColumnName</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-timestampcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-timestampcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimestampColumnName() {
            return null;
        }

        /**
         * This setting applies if the S3 output files during a change data capture (CDC) load are written in .csv format. If this setting is set to <code>true</code> for columns not included in the supplemental log, AWS DMS uses the value specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue"><code>CsvNoSupValue</code></a> . If this setting isn't set or is set to <code>false</code> , AWS DMS uses the null value for these columns.
         * <p>
         * <blockquote>
         * <p>
         * This setting is supported in AWS DMS versions 3.4.1 and later.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-usecsvnosupvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-usecsvnosupvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseCsvNoSupValue() {
            return null;
        }

        /**
         * When set to true, this parameter uses the task start time as the timestamp column value instead of the time data is written to target.
         * <p>
         * For full load, when <code>useTaskStartTimeForFullLoadTimestamp</code> is set to <code>true</code> , each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.
         * <p>
         * When <code>useTaskStartTimeForFullLoadTimestamp</code> is set to <code>false</code> , the full load timestamp in the timestamp column increments with the time data arrives at the target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-usetaskstarttimeforfullloadtimestamp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-usetaskstarttimeforfullloadtimestamp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseTaskStartTimeForFullLoadTimestamp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3SettingsProperty> {
            java.lang.Object addColumnName;
            java.lang.Object addTrailingPaddingCharacter;
            java.lang.String bucketFolder;
            java.lang.String bucketName;
            java.lang.String cannedAclForObjects;
            java.lang.Object cdcInsertsAndUpdates;
            java.lang.Object cdcInsertsOnly;
            java.lang.Number cdcMaxBatchInterval;
            java.lang.Number cdcMinFileSize;
            java.lang.String cdcPath;
            java.lang.String compressionType;
            java.lang.String csvDelimiter;
            java.lang.String csvNoSupValue;
            java.lang.String csvNullValue;
            java.lang.String csvRowDelimiter;
            java.lang.String dataFormat;
            java.lang.Number dataPageSize;
            java.lang.String datePartitionDelimiter;
            java.lang.Object datePartitionEnabled;
            java.lang.String datePartitionSequence;
            java.lang.String datePartitionTimezone;
            java.lang.Number dictPageSizeLimit;
            java.lang.Object enableStatistics;
            java.lang.String encodingType;
            java.lang.String encryptionMode;
            java.lang.String expectedBucketOwner;
            java.lang.String externalTableDefinition;
            java.lang.Object glueCatalogGeneration;
            java.lang.Number ignoreHeaderRows;
            java.lang.Object includeOpForFullLoad;
            java.lang.Number maxFileSize;
            java.lang.Object parquetTimestampInMillisecond;
            java.lang.String parquetVersion;
            java.lang.Object preserveTransactions;
            java.lang.Object rfc4180;
            java.lang.Number rowGroupLength;
            java.lang.String serverSideEncryptionKmsKeyId;
            java.lang.String serviceAccessRoleArn;
            java.lang.String timestampColumnName;
            java.lang.Object useCsvNoSupValue;
            java.lang.Object useTaskStartTimeForFullLoadTimestamp;

            /**
             * Sets the value of {@link S3SettingsProperty#getAddColumnName}
             * @param addColumnName An optional parameter that, when set to <code>true</code> or <code>y</code> , you can use to add column name information to the .csv output file.
             *                      The default value is <code>false</code> . Valid values are <code>true</code> , <code>false</code> , <code>y</code> , and <code>n</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addColumnName(java.lang.Boolean addColumnName) {
                this.addColumnName = addColumnName;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getAddColumnName}
             * @param addColumnName An optional parameter that, when set to <code>true</code> or <code>y</code> , you can use to add column name information to the .csv output file.
             *                      The default value is <code>false</code> . Valid values are <code>true</code> , <code>false</code> , <code>y</code> , and <code>n</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addColumnName(software.amazon.awscdk.IResolvable addColumnName) {
                this.addColumnName = addColumnName;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getAddTrailingPaddingCharacter}
             * @param addTrailingPaddingCharacter Use the S3 target endpoint setting <code>AddTrailingPaddingCharacter</code> to add padding on string data.
             *                                    The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addTrailingPaddingCharacter(java.lang.Boolean addTrailingPaddingCharacter) {
                this.addTrailingPaddingCharacter = addTrailingPaddingCharacter;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getAddTrailingPaddingCharacter}
             * @param addTrailingPaddingCharacter Use the S3 target endpoint setting <code>AddTrailingPaddingCharacter</code> to add padding on string data.
             *                                    The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addTrailingPaddingCharacter(software.amazon.awscdk.IResolvable addTrailingPaddingCharacter) {
                this.addTrailingPaddingCharacter = addTrailingPaddingCharacter;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getBucketFolder}
             * @param bucketFolder An optional parameter to set a folder name in the S3 bucket.
             *                     If provided, tables are created in the path <code>*bucketFolder* / *schema_name* / *table_name* /</code> . If this parameter isn't specified, the path used is <code>*schema_name* / *table_name* /</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketFolder(java.lang.String bucketFolder) {
                this.bucketFolder = bucketFolder;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getBucketName}
             * @param bucketName The name of the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCannedAclForObjects}
             * @param cannedAclForObjects A value that enables AWS DMS to specify a predefined (canned) access control list (ACL) for objects created in an Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 Developer Guide</em> .
             *                            The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE, AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cannedAclForObjects(java.lang.String cannedAclForObjects) {
                this.cannedAclForObjects = cannedAclForObjects;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCdcInsertsAndUpdates}
             * @param cdcInsertsAndUpdates A value that enables a change data capture (CDC) load to write INSERT and UPDATE operations to .csv or .parquet (columnar storage) output files. The default setting is <code>false</code> , but when <code>CdcInsertsAndUpdates</code> is set to <code>true</code> or <code>y</code> , only INSERTs and UPDATEs from the source database are migrated to the .csv or .parquet file.
             *                             For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the value of the <code>IncludeOpForFullLoad</code> parameter. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> , the first field of every CDC record is set to either <code>I</code> or <code>U</code> to indicate INSERT and UPDATE operations at the source. But if <code>IncludeOpForFullLoad</code> is set to <code>false</code> , CDC records are written without an indication of INSERT or UPDATE operations at the source. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             AWS DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in versions 3.3.1 and later.
             *                             <p>
             *                             <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code> for the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code> for the same endpoint, but not both.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdcInsertsAndUpdates(java.lang.Boolean cdcInsertsAndUpdates) {
                this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCdcInsertsAndUpdates}
             * @param cdcInsertsAndUpdates A value that enables a change data capture (CDC) load to write INSERT and UPDATE operations to .csv or .parquet (columnar storage) output files. The default setting is <code>false</code> , but when <code>CdcInsertsAndUpdates</code> is set to <code>true</code> or <code>y</code> , only INSERTs and UPDATEs from the source database are migrated to the .csv or .parquet file.
             *                             For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the value of the <code>IncludeOpForFullLoad</code> parameter. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> , the first field of every CDC record is set to either <code>I</code> or <code>U</code> to indicate INSERT and UPDATE operations at the source. But if <code>IncludeOpForFullLoad</code> is set to <code>false</code> , CDC records are written without an indication of INSERT or UPDATE operations at the source. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             AWS DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in versions 3.3.1 and later.
             *                             <p>
             *                             <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code> for the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code> for the same endpoint, but not both.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdcInsertsAndUpdates(software.amazon.awscdk.IResolvable cdcInsertsAndUpdates) {
                this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCdcInsertsOnly}
             * @param cdcInsertsOnly A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar storage (.parquet) output files. By default (the <code>false</code> setting), the first field in a .csv or .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was inserted, updated, or deleted at the source database for a CDC load to the target.
             *                       If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code> , only INSERTs from the source database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are recorded depends on the value of <code>IncludeOpForFullLoad</code> . If <code>IncludeOpForFullLoad</code> is set to <code>true</code> , the first field of every CDC record is set to I to indicate the INSERT operation at the source. If <code>IncludeOpForFullLoad</code> is set to <code>false</code> , every CDC record is written without a first field to indicate the INSERT operation at the source. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       AWS DMS supports the interaction described preceding between the <code>CdcInsertsOnly</code> and <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later.
             *                       <p>
             *                       <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code> for the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code> for the same endpoint, but not both.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdcInsertsOnly(java.lang.Boolean cdcInsertsOnly) {
                this.cdcInsertsOnly = cdcInsertsOnly;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCdcInsertsOnly}
             * @param cdcInsertsOnly A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar storage (.parquet) output files. By default (the <code>false</code> setting), the first field in a .csv or .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was inserted, updated, or deleted at the source database for a CDC load to the target.
             *                       If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code> , only INSERTs from the source database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are recorded depends on the value of <code>IncludeOpForFullLoad</code> . If <code>IncludeOpForFullLoad</code> is set to <code>true</code> , the first field of every CDC record is set to I to indicate the INSERT operation at the source. If <code>IncludeOpForFullLoad</code> is set to <code>false</code> , every CDC record is written without a first field to indicate the INSERT operation at the source. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       AWS DMS supports the interaction described preceding between the <code>CdcInsertsOnly</code> and <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later.
             *                       <p>
             *                       <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't both be set to <code>true</code> for the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code> for the same endpoint, but not both.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdcInsertsOnly(software.amazon.awscdk.IResolvable cdcInsertsOnly) {
                this.cdcInsertsOnly = cdcInsertsOnly;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCdcMaxBatchInterval}
             * @param cdcMaxBatchInterval Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.
             *                            When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the file write is triggered by whichever parameter condition is met first within an AWS DMS CloudFormation template.
             *                            <p>
             *                            The default value is 60 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdcMaxBatchInterval(java.lang.Number cdcMaxBatchInterval) {
                this.cdcMaxBatchInterval = cdcMaxBatchInterval;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCdcMinFileSize}
             * @param cdcMinFileSize Minimum file size, defined in kilobytes, to reach for a file output to Amazon S3.
             *                       When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file write is triggered by whichever parameter condition is met first within an AWS DMS CloudFormation template.
             *                       <p>
             *                       The default value is 32 MB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdcMinFileSize(java.lang.Number cdcMinFileSize) {
                this.cdcMinFileSize = cdcMinFileSize;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCdcPath}
             * @param cdcPath Specifies the folder path of CDC files.
             *                For an S3 source, this setting is required if a task captures change data; otherwise, it's optional. If <code>CdcPath</code> is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. For an S3 target if you set <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions"><code>PreserveTransactions</code></a> to <code>true</code> , AWS DMS verifies that you have set this parameter to a folder path on your S3 target where AWS DMS can save the transaction order for the CDC load. AWS DMS creates this CDC folder path in either your S3 target working directory or the S3 target location specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder"><code>BucketFolder</code></a> and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName"><code>BucketName</code></a> .
             *                <p>
             *                For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code> , and you specify <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify <code>BucketFolder</code> , AWS DMS creates the CDC folder path following: <code>MyTargetBucket/MyChangedData</code> .
             *                <p>
             *                If you specify the same <code>CdcPath</code> , and you specify <code>BucketName</code> as <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code> , AWS DMS creates the CDC folder path following: <code>MyTargetBucket/MyTargetData/MyChangedData</code> .
             *                <p>
             *                For more information on CDC including transaction order on an S3 target, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3 target</a> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                This setting is supported in AWS DMS versions 3.4.2 and later.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdcPath(java.lang.String cdcPath) {
                this.cdcPath = cdcPath;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCompressionType}
             * @param compressionType An optional parameter.
             *                        When set to GZIP it enables the service to compress the target files. To allow the service to write the target files uncompressed, either set this parameter to NONE (the default) or don't specify the parameter at all. This parameter applies to both .csv and .parquet file formats.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionType(java.lang.String compressionType) {
                this.compressionType = compressionType;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCsvDelimiter}
             * @param csvDelimiter The delimiter used to separate columns in the .csv file for both source and target. The default is a comma.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvDelimiter(java.lang.String csvDelimiter) {
                this.csvDelimiter = csvDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCsvNoSupValue}
             * @param csvNoSupValue This setting only applies if your Amazon S3 output files during a change data capture (CDC) load are written in .csv format. If <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue"><code>UseCsvNoSupValue</code></a> is set to true, specify a string value that you want AWS DMS to use for all columns not included in the supplemental log. If you do not specify a string value, AWS DMS uses the null value for these columns regardless of the <code>UseCsvNoSupValue</code> setting.
             *                      <blockquote>
             *                      <p>
             *                      This setting is supported in AWS DMS versions 3.4.1 and later.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvNoSupValue(java.lang.String csvNoSupValue) {
                this.csvNoSupValue = csvNoSupValue;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCsvNullValue}
             * @param csvNullValue An optional parameter that specifies how AWS DMS treats null values.
             *                     While handling the null value, you can use this parameter to pass a user-defined string as null when writing to the target. For example, when target columns are not nullable, you can use this option to differentiate between the empty string value and the null value. So, if you set this parameter value to the empty string ("" or ''), AWS DMS treats the empty string as the null value instead of <code>NULL</code> .
             *                     <p>
             *                     The default value is <code>NULL</code> . Valid values include any valid string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvNullValue(java.lang.String csvNullValue) {
                this.csvNullValue = csvNullValue;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCsvRowDelimiter}
             * @param csvRowDelimiter The delimiter used to separate rows in the .csv file for both source and target.
             *                        The default is a carriage return ( <code>\n</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvRowDelimiter(java.lang.String csvRowDelimiter) {
                this.csvRowDelimiter = csvRowDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getDataFormat}
             * @param dataFormat The format of the data that you want to use for output. You can choose one of the following:.
             *                   <ul>
             *                   <li><code>csv</code> : This is a row-based file format with comma-separated values (.csv).</li>
             *                   <li><code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient compression and provides faster query response.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataFormat(java.lang.String dataFormat) {
                this.dataFormat = dataFormat;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getDataPageSize}
             * @param dataPageSize The size of one data page in bytes.
             *                     This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is used for .parquet file format only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataPageSize(java.lang.Number dataPageSize) {
                this.dataPageSize = dataPageSize;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getDatePartitionDelimiter}
             * @param datePartitionDelimiter Specifies a date separating delimiter to use during folder partitioning.
             *                               The default value is <code>SLASH</code> . Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datePartitionDelimiter(java.lang.String datePartitionDelimiter) {
                this.datePartitionDelimiter = datePartitionDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getDatePartitionEnabled}
             * @param datePartitionEnabled When set to <code>true</code> , this parameter partitions S3 bucket folders based on transaction commit dates.
             *                             The default value is <code>false</code> . For more information about date-based folder partitioning, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning">Using date-based folder partitioning</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datePartitionEnabled(java.lang.Boolean datePartitionEnabled) {
                this.datePartitionEnabled = datePartitionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getDatePartitionEnabled}
             * @param datePartitionEnabled When set to <code>true</code> , this parameter partitions S3 bucket folders based on transaction commit dates.
             *                             The default value is <code>false</code> . For more information about date-based folder partitioning, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning">Using date-based folder partitioning</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datePartitionEnabled(software.amazon.awscdk.IResolvable datePartitionEnabled) {
                this.datePartitionEnabled = datePartitionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getDatePartitionSequence}
             * @param datePartitionSequence Identifies the sequence of the date format to use during folder partitioning.
             *                              The default value is <code>YYYYMMDD</code> . Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datePartitionSequence(java.lang.String datePartitionSequence) {
                this.datePartitionSequence = datePartitionSequence;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getDatePartitionTimezone}
             * @param datePartitionTimezone When creating an S3 target endpoint, set <code>DatePartitionTimezone</code> to convert the current UTC time into a specified time zone.
             *                              The conversion occurs when a date partition folder is created and a change data capture (CDC) file name is generated. The time zone format is Area/Location. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code> , as shown in the following example.
             *                              <p>
             *                              <code>s3-settings='{"DatePartitionEnabled": true, "DatePartitionSequence": "YYYYMMDDHH", "DatePartitionDelimiter": "SLASH", "DatePartitionTimezone":" *Asia/Seoul* ", "BucketName": "dms-nattarat-test"}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datePartitionTimezone(java.lang.String datePartitionTimezone) {
                this.datePartitionTimezone = datePartitionTimezone;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getDictPageSizeLimit}
             * @param dictPageSizeLimit The maximum size of an encoded dictionary page of a column.
             *                          If the dictionary page exceeds this, this column is stored using an encoding type of <code>PLAIN</code> . This parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding. This size is used for .parquet file format only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dictPageSizeLimit(java.lang.Number dictPageSizeLimit) {
                this.dictPageSizeLimit = dictPageSizeLimit;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getEnableStatistics}
             * @param enableStatistics A value that enables statistics for Parquet pages and row groups.
             *                         Choose <code>true</code> to enable statistics, <code>false</code> to disable. Statistics include <code>NULL</code> , <code>DISTINCT</code> , <code>MAX</code> , and <code>MIN</code> values. This parameter defaults to <code>true</code> . This value is used for .parquet file format only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableStatistics(java.lang.Boolean enableStatistics) {
                this.enableStatistics = enableStatistics;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getEnableStatistics}
             * @param enableStatistics A value that enables statistics for Parquet pages and row groups.
             *                         Choose <code>true</code> to enable statistics, <code>false</code> to disable. Statistics include <code>NULL</code> , <code>DISTINCT</code> , <code>MAX</code> , and <code>MIN</code> values. This parameter defaults to <code>true</code> . This value is used for .parquet file format only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableStatistics(software.amazon.awscdk.IResolvable enableStatistics) {
                this.enableStatistics = enableStatistics;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getEncodingType}
             * @param encodingType The type of encoding that you're using:.
             *                     <ul>
             *                     <li><code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated values more efficiently. This is the default.</li>
             *                     <li><code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.</li>
             *                     <li><code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary is stored in a dictionary page for each column chunk.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encodingType(java.lang.String encodingType) {
                this.encodingType = encodingType;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getEncryptionMode}
             * @param encryptionMode The type of server-side encryption that you want to use for your data.
             *                       This encryption type is part of the endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       For the <code>ModifyEndpoint</code> operation, you can change the existing value of the <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code> . But you can’t change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code> .
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       To use <code>SSE_S3</code> , you need an IAM role with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
             *                       <p>
             *                       <ul>
             *                       <li><code>s3:CreateBucket</code></li>
             *                       <li><code>s3:ListBucket</code></li>
             *                       <li><code>s3:DeleteBucket</code></li>
             *                       <li><code>s3:GetBucketLocation</code></li>
             *                       <li><code>s3:GetObject</code></li>
             *                       <li><code>s3:PutObject</code></li>
             *                       <li><code>s3:DeleteObject</code></li>
             *                       <li><code>s3:GetObjectVersion</code></li>
             *                       <li><code>s3:GetBucketPolicy</code></li>
             *                       <li><code>s3:PutBucketPolicy</code></li>
             *                       <li><code>s3:DeleteBucketPolicy</code></li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionMode(java.lang.String encryptionMode) {
                this.encryptionMode = encryptionMode;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getExpectedBucketOwner}
             * @param expectedBucketOwner To specify a bucket owner and prevent sniping, you can use the <code>ExpectedBucketOwner</code> endpoint setting.
             *                            Example: <code>--s3-settings='{"ExpectedBucketOwner": " *AWS_Account_ID* "}'</code>
             *                            <p>
             *                            When you make a request to test a connection or perform a migration, S3 checks the account ID of the bucket owner against the specified parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expectedBucketOwner(java.lang.String expectedBucketOwner) {
                this.expectedBucketOwner = expectedBucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getExternalTableDefinition}
             * @param externalTableDefinition The external table definition.
             *                                Conditional: If <code>S3</code> is used as a source then <code>ExternalTableDefinition</code> is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalTableDefinition(java.lang.String externalTableDefinition) {
                this.externalTableDefinition = externalTableDefinition;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getGlueCatalogGeneration}
             * @param glueCatalogGeneration When true, allows AWS Glue to catalog your S3 bucket.
             *                              Creating an AWS Glue catalog lets you use Athena to query your data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueCatalogGeneration(java.lang.Boolean glueCatalogGeneration) {
                this.glueCatalogGeneration = glueCatalogGeneration;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getGlueCatalogGeneration}
             * @param glueCatalogGeneration When true, allows AWS Glue to catalog your S3 bucket.
             *                              Creating an AWS Glue catalog lets you use Athena to query your data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueCatalogGeneration(software.amazon.awscdk.IResolvable glueCatalogGeneration) {
                this.glueCatalogGeneration = glueCatalogGeneration;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getIgnoreHeaderRows}
             * @param ignoreHeaderRows When this value is set to 1, AWS DMS ignores the first row header in a .csv file. A value of 1 turns on the feature; a value of 0 turns off the feature.
             *                         The default is 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoreHeaderRows(java.lang.Number ignoreHeaderRows) {
                this.ignoreHeaderRows = ignoreHeaderRows;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getIncludeOpForFullLoad}
             * @param includeOpForFullLoad A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output files only to indicate how the rows were added to the source database.
             *                             <blockquote>
             *                             <p>
             *                             AWS DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
             *                             <p>
             *                             </blockquote>
             *                             <p>
             *                             For full load, records can only be inserted. By default (the <code>false</code> setting), no information is recorded in these output files for a full load to indicate that the rows were inserted at the source database. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> or <code>y</code> , the INSERT is recorded as an I annotation in the first field of the .csv file. This allows the format of your target records from a full load to be consistent with the target records from a CDC load.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             This setting works together with the <code>CdcInsertsOnly</code> and the <code>CdcInsertsAndUpdates</code> parameters for output to .csv files only. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeOpForFullLoad(java.lang.Boolean includeOpForFullLoad) {
                this.includeOpForFullLoad = includeOpForFullLoad;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getIncludeOpForFullLoad}
             * @param includeOpForFullLoad A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output files only to indicate how the rows were added to the source database.
             *                             <blockquote>
             *                             <p>
             *                             AWS DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
             *                             <p>
             *                             </blockquote>
             *                             <p>
             *                             For full load, records can only be inserted. By default (the <code>false</code> setting), no information is recorded in these output files for a full load to indicate that the rows were inserted at the source database. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> or <code>y</code> , the INSERT is recorded as an I annotation in the first field of the .csv file. This allows the format of your target records from a full load to be consistent with the target records from a CDC load.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             This setting works together with the <code>CdcInsertsOnly</code> and the <code>CdcInsertsAndUpdates</code> parameters for output to .csv files only. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeOpForFullLoad(software.amazon.awscdk.IResolvable includeOpForFullLoad) {
                this.includeOpForFullLoad = includeOpForFullLoad;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getMaxFileSize}
             * @param maxFileSize A value that specifies the maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load.
             *                    The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFileSize(java.lang.Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getParquetTimestampInMillisecond}
             * @param parquetTimestampInMillisecond A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to an Amazon S3 object file in .parquet format.
             *                                      <blockquote>
             *                                      <p>
             *                                      AWS DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
             *                                      <p>
             *                                      </blockquote>
             *                                      <p>
             *                                      When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code> , AWS DMS writes all <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision. Otherwise, DMS writes them with microsecond precision.
             *                                      <p>
             *                                      Currently, Amazon Athena and AWS Glue can handle only millisecond precision for <code>TIMESTAMP</code> values. Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet formatted only if you plan to query or process the data with Athena or AWS Glue .
             *                                      <p>
             *                                      <blockquote>
             *                                      <p>
             *                                      AWS DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with microsecond precision.
             *                                      <p>
             *                                      Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp column value that is inserted by setting the <code>TimestampColumnName</code> parameter.
             *                                      <p>
             *                                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquetTimestampInMillisecond(java.lang.Boolean parquetTimestampInMillisecond) {
                this.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getParquetTimestampInMillisecond}
             * @param parquetTimestampInMillisecond A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to an Amazon S3 object file in .parquet format.
             *                                      <blockquote>
             *                                      <p>
             *                                      AWS DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
             *                                      <p>
             *                                      </blockquote>
             *                                      <p>
             *                                      When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code> , AWS DMS writes all <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision. Otherwise, DMS writes them with microsecond precision.
             *                                      <p>
             *                                      Currently, Amazon Athena and AWS Glue can handle only millisecond precision for <code>TIMESTAMP</code> values. Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet formatted only if you plan to query or process the data with Athena or AWS Glue .
             *                                      <p>
             *                                      <blockquote>
             *                                      <p>
             *                                      AWS DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with microsecond precision.
             *                                      <p>
             *                                      Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp column value that is inserted by setting the <code>TimestampColumnName</code> parameter.
             *                                      <p>
             *                                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquetTimestampInMillisecond(software.amazon.awscdk.IResolvable parquetTimestampInMillisecond) {
                this.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getParquetVersion}
             * @param parquetVersion The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or <code>parquet_2_0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquetVersion(java.lang.String parquetVersion) {
                this.parquetVersion = parquetVersion;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getPreserveTransactions}
             * @param preserveTransactions If this setting is set to <code>true</code> , AWS DMS saves the transaction order for a change data capture (CDC) load on the Amazon S3 target specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath"><code>CdcPath</code></a> . For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3 target</a> .
             *                             <blockquote>
             *                             <p>
             *                             This setting is supported in AWS DMS versions 3.4.2 and later.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveTransactions(java.lang.Boolean preserveTransactions) {
                this.preserveTransactions = preserveTransactions;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getPreserveTransactions}
             * @param preserveTransactions If this setting is set to <code>true</code> , AWS DMS saves the transaction order for a change data capture (CDC) load on the Amazon S3 target specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath"><code>CdcPath</code></a> . For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3 target</a> .
             *                             <blockquote>
             *                             <p>
             *                             This setting is supported in AWS DMS versions 3.4.2 and later.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveTransactions(software.amazon.awscdk.IResolvable preserveTransactions) {
                this.preserveTransactions = preserveTransactions;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getRfc4180}
             * @param rfc4180 For an S3 source, when this value is set to <code>true</code> or <code>y</code> , each leading double quotation mark has to be followed by an ending double quotation mark.
             *                This formatting complies with RFC 4180. When this value is set to <code>false</code> or <code>n</code> , string literals are copied to the target as is. In this case, a delimiter (row or column) signals the end of the field. Thus, you can't use a delimiter as part of the string, because it signals the end of the value.
             *                <p>
             *                For an S3 target, an optional parameter used to set behavior to comply with RFC 4180 for data migrated to Amazon S3 using .csv file format only. When this value is set to <code>true</code> or <code>y</code> using Amazon S3 as a target, if the data has quotation marks or newline characters in it, AWS DMS encloses the entire column with an additional pair of double quotation marks ("). Every quotation mark within the data is repeated twice.
             *                <p>
             *                The default value is <code>true</code> . Valid values include <code>true</code> , <code>false</code> , <code>y</code> , and <code>n</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rfc4180(java.lang.Boolean rfc4180) {
                this.rfc4180 = rfc4180;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getRfc4180}
             * @param rfc4180 For an S3 source, when this value is set to <code>true</code> or <code>y</code> , each leading double quotation mark has to be followed by an ending double quotation mark.
             *                This formatting complies with RFC 4180. When this value is set to <code>false</code> or <code>n</code> , string literals are copied to the target as is. In this case, a delimiter (row or column) signals the end of the field. Thus, you can't use a delimiter as part of the string, because it signals the end of the value.
             *                <p>
             *                For an S3 target, an optional parameter used to set behavior to comply with RFC 4180 for data migrated to Amazon S3 using .csv file format only. When this value is set to <code>true</code> or <code>y</code> using Amazon S3 as a target, if the data has quotation marks or newline characters in it, AWS DMS encloses the entire column with an additional pair of double quotation marks ("). Every quotation mark within the data is repeated twice.
             *                <p>
             *                The default value is <code>true</code> . Valid values include <code>true</code> , <code>false</code> , <code>y</code> , and <code>n</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rfc4180(software.amazon.awscdk.IResolvable rfc4180) {
                this.rfc4180 = rfc4180;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getRowGroupLength}
             * @param rowGroupLength The number of rows in a row group.
             *                       A smaller row group size provides faster reads. But as the number of row groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used for .parquet file format only.
             *                       <p>
             *                       If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group length in bytes (64 * 1024 * 1024).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rowGroupLength(java.lang.Number rowGroupLength) {
                this.rowGroupLength = rowGroupLength;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getServerSideEncryptionKmsKeyId}
             * @param serverSideEncryptionKmsKeyId If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code> , provide the AWS KMS key ID.
             *                                     The key that you use needs an attached policy that enables IAM user permissions and allows use of the key.
             *                                     <p>
             *                                     Here is a CLI example: <code>aws dms create-endpoint --endpoint-identifier *value* --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn= *value* ,BucketFolder= *value* ,BucketName= *value* ,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId= *value*</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionKmsKeyId(java.lang.String serverSideEncryptionKmsKeyId) {
                this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn A required parameter that specifies the Amazon Resource Name (ARN) used by the service to access the IAM role.
             *                             The role must allow the <code>iam:PassRole</code> action. It enables AWS DMS to read and write objects from an S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getTimestampColumnName}
             * @param timestampColumnName A value that when nonblank causes AWS DMS to add a column with timestamp information to the endpoint data for an Amazon S3 target.
             *                            <blockquote>
             *                            <p>
             *                            AWS DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.
             *                            <p>
             *                            </blockquote>
             *                            <p>
             *                            AWS DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your migrated data when you set <code>TimestampColumnName</code> to a nonblank value.
             *                            <p>
             *                            For a full load, each row of this timestamp column contains a timestamp for when the data was transferred from the source to the target by DMS.
             *                            <p>
             *                            For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the commit of that row in the source database.
             *                            <p>
             *                            The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code> . By default, the precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on the commit timestamp supported by DMS for the source database.
             *                            <p>
             *                            When the <code>AddColumnName</code> parameter is set to <code>true</code> , DMS also includes a name for the timestamp column that you set with <code>TimestampColumnName</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestampColumnName(java.lang.String timestampColumnName) {
                this.timestampColumnName = timestampColumnName;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getUseCsvNoSupValue}
             * @param useCsvNoSupValue This setting applies if the S3 output files during a change data capture (CDC) load are written in .csv format. If this setting is set to <code>true</code> for columns not included in the supplemental log, AWS DMS uses the value specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue"><code>CsvNoSupValue</code></a> . If this setting isn't set or is set to <code>false</code> , AWS DMS uses the null value for these columns.
             *                         <blockquote>
             *                         <p>
             *                         This setting is supported in AWS DMS versions 3.4.1 and later.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useCsvNoSupValue(java.lang.Boolean useCsvNoSupValue) {
                this.useCsvNoSupValue = useCsvNoSupValue;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getUseCsvNoSupValue}
             * @param useCsvNoSupValue This setting applies if the S3 output files during a change data capture (CDC) load are written in .csv format. If this setting is set to <code>true</code> for columns not included in the supplemental log, AWS DMS uses the value specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue"><code>CsvNoSupValue</code></a> . If this setting isn't set or is set to <code>false</code> , AWS DMS uses the null value for these columns.
             *                         <blockquote>
             *                         <p>
             *                         This setting is supported in AWS DMS versions 3.4.1 and later.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useCsvNoSupValue(software.amazon.awscdk.IResolvable useCsvNoSupValue) {
                this.useCsvNoSupValue = useCsvNoSupValue;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getUseTaskStartTimeForFullLoadTimestamp}
             * @param useTaskStartTimeForFullLoadTimestamp When set to true, this parameter uses the task start time as the timestamp column value instead of the time data is written to target.
             *                                             For full load, when <code>useTaskStartTimeForFullLoadTimestamp</code> is set to <code>true</code> , each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.
             *                                             <p>
             *                                             When <code>useTaskStartTimeForFullLoadTimestamp</code> is set to <code>false</code> , the full load timestamp in the timestamp column increments with the time data arrives at the target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useTaskStartTimeForFullLoadTimestamp(java.lang.Boolean useTaskStartTimeForFullLoadTimestamp) {
                this.useTaskStartTimeForFullLoadTimestamp = useTaskStartTimeForFullLoadTimestamp;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getUseTaskStartTimeForFullLoadTimestamp}
             * @param useTaskStartTimeForFullLoadTimestamp When set to true, this parameter uses the task start time as the timestamp column value instead of the time data is written to target.
             *                                             For full load, when <code>useTaskStartTimeForFullLoadTimestamp</code> is set to <code>true</code> , each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.
             *                                             <p>
             *                                             When <code>useTaskStartTimeForFullLoadTimestamp</code> is set to <code>false</code> , the full load timestamp in the timestamp column increments with the time data arrives at the target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useTaskStartTimeForFullLoadTimestamp(software.amazon.awscdk.IResolvable useTaskStartTimeForFullLoadTimestamp) {
                this.useTaskStartTimeForFullLoadTimestamp = useTaskStartTimeForFullLoadTimestamp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SettingsProperty {
            private final java.lang.Object addColumnName;
            private final java.lang.Object addTrailingPaddingCharacter;
            private final java.lang.String bucketFolder;
            private final java.lang.String bucketName;
            private final java.lang.String cannedAclForObjects;
            private final java.lang.Object cdcInsertsAndUpdates;
            private final java.lang.Object cdcInsertsOnly;
            private final java.lang.Number cdcMaxBatchInterval;
            private final java.lang.Number cdcMinFileSize;
            private final java.lang.String cdcPath;
            private final java.lang.String compressionType;
            private final java.lang.String csvDelimiter;
            private final java.lang.String csvNoSupValue;
            private final java.lang.String csvNullValue;
            private final java.lang.String csvRowDelimiter;
            private final java.lang.String dataFormat;
            private final java.lang.Number dataPageSize;
            private final java.lang.String datePartitionDelimiter;
            private final java.lang.Object datePartitionEnabled;
            private final java.lang.String datePartitionSequence;
            private final java.lang.String datePartitionTimezone;
            private final java.lang.Number dictPageSizeLimit;
            private final java.lang.Object enableStatistics;
            private final java.lang.String encodingType;
            private final java.lang.String encryptionMode;
            private final java.lang.String expectedBucketOwner;
            private final java.lang.String externalTableDefinition;
            private final java.lang.Object glueCatalogGeneration;
            private final java.lang.Number ignoreHeaderRows;
            private final java.lang.Object includeOpForFullLoad;
            private final java.lang.Number maxFileSize;
            private final java.lang.Object parquetTimestampInMillisecond;
            private final java.lang.String parquetVersion;
            private final java.lang.Object preserveTransactions;
            private final java.lang.Object rfc4180;
            private final java.lang.Number rowGroupLength;
            private final java.lang.String serverSideEncryptionKmsKeyId;
            private final java.lang.String serviceAccessRoleArn;
            private final java.lang.String timestampColumnName;
            private final java.lang.Object useCsvNoSupValue;
            private final java.lang.Object useTaskStartTimeForFullLoadTimestamp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addColumnName = software.amazon.jsii.Kernel.get(this, "addColumnName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.addTrailingPaddingCharacter = software.amazon.jsii.Kernel.get(this, "addTrailingPaddingCharacter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bucketFolder = software.amazon.jsii.Kernel.get(this, "bucketFolder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cannedAclForObjects = software.amazon.jsii.Kernel.get(this, "cannedAclForObjects", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cdcInsertsAndUpdates = software.amazon.jsii.Kernel.get(this, "cdcInsertsAndUpdates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cdcInsertsOnly = software.amazon.jsii.Kernel.get(this, "cdcInsertsOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cdcMaxBatchInterval = software.amazon.jsii.Kernel.get(this, "cdcMaxBatchInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.cdcMinFileSize = software.amazon.jsii.Kernel.get(this, "cdcMinFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.cdcPath = software.amazon.jsii.Kernel.get(this, "cdcPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.compressionType = software.amazon.jsii.Kernel.get(this, "compressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.csvDelimiter = software.amazon.jsii.Kernel.get(this, "csvDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.csvNoSupValue = software.amazon.jsii.Kernel.get(this, "csvNoSupValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.csvNullValue = software.amazon.jsii.Kernel.get(this, "csvNullValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.csvRowDelimiter = software.amazon.jsii.Kernel.get(this, "csvRowDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataFormat = software.amazon.jsii.Kernel.get(this, "dataFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataPageSize = software.amazon.jsii.Kernel.get(this, "dataPageSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.datePartitionDelimiter = software.amazon.jsii.Kernel.get(this, "datePartitionDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datePartitionEnabled = software.amazon.jsii.Kernel.get(this, "datePartitionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datePartitionSequence = software.amazon.jsii.Kernel.get(this, "datePartitionSequence", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datePartitionTimezone = software.amazon.jsii.Kernel.get(this, "datePartitionTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dictPageSizeLimit = software.amazon.jsii.Kernel.get(this, "dictPageSizeLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enableStatistics = software.amazon.jsii.Kernel.get(this, "enableStatistics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encodingType = software.amazon.jsii.Kernel.get(this, "encodingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionMode = software.amazon.jsii.Kernel.get(this, "encryptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expectedBucketOwner = software.amazon.jsii.Kernel.get(this, "expectedBucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalTableDefinition = software.amazon.jsii.Kernel.get(this, "externalTableDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.glueCatalogGeneration = software.amazon.jsii.Kernel.get(this, "glueCatalogGeneration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ignoreHeaderRows = software.amazon.jsii.Kernel.get(this, "ignoreHeaderRows", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.includeOpForFullLoad = software.amazon.jsii.Kernel.get(this, "includeOpForFullLoad", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxFileSize = software.amazon.jsii.Kernel.get(this, "maxFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.parquetTimestampInMillisecond = software.amazon.jsii.Kernel.get(this, "parquetTimestampInMillisecond", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parquetVersion = software.amazon.jsii.Kernel.get(this, "parquetVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preserveTransactions = software.amazon.jsii.Kernel.get(this, "preserveTransactions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rfc4180 = software.amazon.jsii.Kernel.get(this, "rfc4180", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rowGroupLength = software.amazon.jsii.Kernel.get(this, "rowGroupLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverSideEncryptionKmsKeyId = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timestampColumnName = software.amazon.jsii.Kernel.get(this, "timestampColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.useCsvNoSupValue = software.amazon.jsii.Kernel.get(this, "useCsvNoSupValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useTaskStartTimeForFullLoadTimestamp = software.amazon.jsii.Kernel.get(this, "useTaskStartTimeForFullLoadTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addColumnName = builder.addColumnName;
                this.addTrailingPaddingCharacter = builder.addTrailingPaddingCharacter;
                this.bucketFolder = builder.bucketFolder;
                this.bucketName = builder.bucketName;
                this.cannedAclForObjects = builder.cannedAclForObjects;
                this.cdcInsertsAndUpdates = builder.cdcInsertsAndUpdates;
                this.cdcInsertsOnly = builder.cdcInsertsOnly;
                this.cdcMaxBatchInterval = builder.cdcMaxBatchInterval;
                this.cdcMinFileSize = builder.cdcMinFileSize;
                this.cdcPath = builder.cdcPath;
                this.compressionType = builder.compressionType;
                this.csvDelimiter = builder.csvDelimiter;
                this.csvNoSupValue = builder.csvNoSupValue;
                this.csvNullValue = builder.csvNullValue;
                this.csvRowDelimiter = builder.csvRowDelimiter;
                this.dataFormat = builder.dataFormat;
                this.dataPageSize = builder.dataPageSize;
                this.datePartitionDelimiter = builder.datePartitionDelimiter;
                this.datePartitionEnabled = builder.datePartitionEnabled;
                this.datePartitionSequence = builder.datePartitionSequence;
                this.datePartitionTimezone = builder.datePartitionTimezone;
                this.dictPageSizeLimit = builder.dictPageSizeLimit;
                this.enableStatistics = builder.enableStatistics;
                this.encodingType = builder.encodingType;
                this.encryptionMode = builder.encryptionMode;
                this.expectedBucketOwner = builder.expectedBucketOwner;
                this.externalTableDefinition = builder.externalTableDefinition;
                this.glueCatalogGeneration = builder.glueCatalogGeneration;
                this.ignoreHeaderRows = builder.ignoreHeaderRows;
                this.includeOpForFullLoad = builder.includeOpForFullLoad;
                this.maxFileSize = builder.maxFileSize;
                this.parquetTimestampInMillisecond = builder.parquetTimestampInMillisecond;
                this.parquetVersion = builder.parquetVersion;
                this.preserveTransactions = builder.preserveTransactions;
                this.rfc4180 = builder.rfc4180;
                this.rowGroupLength = builder.rowGroupLength;
                this.serverSideEncryptionKmsKeyId = builder.serverSideEncryptionKmsKeyId;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
                this.timestampColumnName = builder.timestampColumnName;
                this.useCsvNoSupValue = builder.useCsvNoSupValue;
                this.useTaskStartTimeForFullLoadTimestamp = builder.useTaskStartTimeForFullLoadTimestamp;
            }

            @Override
            public final java.lang.Object getAddColumnName() {
                return this.addColumnName;
            }

            @Override
            public final java.lang.Object getAddTrailingPaddingCharacter() {
                return this.addTrailingPaddingCharacter;
            }

            @Override
            public final java.lang.String getBucketFolder() {
                return this.bucketFolder;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getCannedAclForObjects() {
                return this.cannedAclForObjects;
            }

            @Override
            public final java.lang.Object getCdcInsertsAndUpdates() {
                return this.cdcInsertsAndUpdates;
            }

            @Override
            public final java.lang.Object getCdcInsertsOnly() {
                return this.cdcInsertsOnly;
            }

            @Override
            public final java.lang.Number getCdcMaxBatchInterval() {
                return this.cdcMaxBatchInterval;
            }

            @Override
            public final java.lang.Number getCdcMinFileSize() {
                return this.cdcMinFileSize;
            }

            @Override
            public final java.lang.String getCdcPath() {
                return this.cdcPath;
            }

            @Override
            public final java.lang.String getCompressionType() {
                return this.compressionType;
            }

            @Override
            public final java.lang.String getCsvDelimiter() {
                return this.csvDelimiter;
            }

            @Override
            public final java.lang.String getCsvNoSupValue() {
                return this.csvNoSupValue;
            }

            @Override
            public final java.lang.String getCsvNullValue() {
                return this.csvNullValue;
            }

            @Override
            public final java.lang.String getCsvRowDelimiter() {
                return this.csvRowDelimiter;
            }

            @Override
            public final java.lang.String getDataFormat() {
                return this.dataFormat;
            }

            @Override
            public final java.lang.Number getDataPageSize() {
                return this.dataPageSize;
            }

            @Override
            public final java.lang.String getDatePartitionDelimiter() {
                return this.datePartitionDelimiter;
            }

            @Override
            public final java.lang.Object getDatePartitionEnabled() {
                return this.datePartitionEnabled;
            }

            @Override
            public final java.lang.String getDatePartitionSequence() {
                return this.datePartitionSequence;
            }

            @Override
            public final java.lang.String getDatePartitionTimezone() {
                return this.datePartitionTimezone;
            }

            @Override
            public final java.lang.Number getDictPageSizeLimit() {
                return this.dictPageSizeLimit;
            }

            @Override
            public final java.lang.Object getEnableStatistics() {
                return this.enableStatistics;
            }

            @Override
            public final java.lang.String getEncodingType() {
                return this.encodingType;
            }

            @Override
            public final java.lang.String getEncryptionMode() {
                return this.encryptionMode;
            }

            @Override
            public final java.lang.String getExpectedBucketOwner() {
                return this.expectedBucketOwner;
            }

            @Override
            public final java.lang.String getExternalTableDefinition() {
                return this.externalTableDefinition;
            }

            @Override
            public final java.lang.Object getGlueCatalogGeneration() {
                return this.glueCatalogGeneration;
            }

            @Override
            public final java.lang.Number getIgnoreHeaderRows() {
                return this.ignoreHeaderRows;
            }

            @Override
            public final java.lang.Object getIncludeOpForFullLoad() {
                return this.includeOpForFullLoad;
            }

            @Override
            public final java.lang.Number getMaxFileSize() {
                return this.maxFileSize;
            }

            @Override
            public final java.lang.Object getParquetTimestampInMillisecond() {
                return this.parquetTimestampInMillisecond;
            }

            @Override
            public final java.lang.String getParquetVersion() {
                return this.parquetVersion;
            }

            @Override
            public final java.lang.Object getPreserveTransactions() {
                return this.preserveTransactions;
            }

            @Override
            public final java.lang.Object getRfc4180() {
                return this.rfc4180;
            }

            @Override
            public final java.lang.Number getRowGroupLength() {
                return this.rowGroupLength;
            }

            @Override
            public final java.lang.String getServerSideEncryptionKmsKeyId() {
                return this.serverSideEncryptionKmsKeyId;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getTimestampColumnName() {
                return this.timestampColumnName;
            }

            @Override
            public final java.lang.Object getUseCsvNoSupValue() {
                return this.useCsvNoSupValue;
            }

            @Override
            public final java.lang.Object getUseTaskStartTimeForFullLoadTimestamp() {
                return this.useTaskStartTimeForFullLoadTimestamp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddColumnName() != null) {
                    data.set("addColumnName", om.valueToTree(this.getAddColumnName()));
                }
                if (this.getAddTrailingPaddingCharacter() != null) {
                    data.set("addTrailingPaddingCharacter", om.valueToTree(this.getAddTrailingPaddingCharacter()));
                }
                if (this.getBucketFolder() != null) {
                    data.set("bucketFolder", om.valueToTree(this.getBucketFolder()));
                }
                if (this.getBucketName() != null) {
                    data.set("bucketName", om.valueToTree(this.getBucketName()));
                }
                if (this.getCannedAclForObjects() != null) {
                    data.set("cannedAclForObjects", om.valueToTree(this.getCannedAclForObjects()));
                }
                if (this.getCdcInsertsAndUpdates() != null) {
                    data.set("cdcInsertsAndUpdates", om.valueToTree(this.getCdcInsertsAndUpdates()));
                }
                if (this.getCdcInsertsOnly() != null) {
                    data.set("cdcInsertsOnly", om.valueToTree(this.getCdcInsertsOnly()));
                }
                if (this.getCdcMaxBatchInterval() != null) {
                    data.set("cdcMaxBatchInterval", om.valueToTree(this.getCdcMaxBatchInterval()));
                }
                if (this.getCdcMinFileSize() != null) {
                    data.set("cdcMinFileSize", om.valueToTree(this.getCdcMinFileSize()));
                }
                if (this.getCdcPath() != null) {
                    data.set("cdcPath", om.valueToTree(this.getCdcPath()));
                }
                if (this.getCompressionType() != null) {
                    data.set("compressionType", om.valueToTree(this.getCompressionType()));
                }
                if (this.getCsvDelimiter() != null) {
                    data.set("csvDelimiter", om.valueToTree(this.getCsvDelimiter()));
                }
                if (this.getCsvNoSupValue() != null) {
                    data.set("csvNoSupValue", om.valueToTree(this.getCsvNoSupValue()));
                }
                if (this.getCsvNullValue() != null) {
                    data.set("csvNullValue", om.valueToTree(this.getCsvNullValue()));
                }
                if (this.getCsvRowDelimiter() != null) {
                    data.set("csvRowDelimiter", om.valueToTree(this.getCsvRowDelimiter()));
                }
                if (this.getDataFormat() != null) {
                    data.set("dataFormat", om.valueToTree(this.getDataFormat()));
                }
                if (this.getDataPageSize() != null) {
                    data.set("dataPageSize", om.valueToTree(this.getDataPageSize()));
                }
                if (this.getDatePartitionDelimiter() != null) {
                    data.set("datePartitionDelimiter", om.valueToTree(this.getDatePartitionDelimiter()));
                }
                if (this.getDatePartitionEnabled() != null) {
                    data.set("datePartitionEnabled", om.valueToTree(this.getDatePartitionEnabled()));
                }
                if (this.getDatePartitionSequence() != null) {
                    data.set("datePartitionSequence", om.valueToTree(this.getDatePartitionSequence()));
                }
                if (this.getDatePartitionTimezone() != null) {
                    data.set("datePartitionTimezone", om.valueToTree(this.getDatePartitionTimezone()));
                }
                if (this.getDictPageSizeLimit() != null) {
                    data.set("dictPageSizeLimit", om.valueToTree(this.getDictPageSizeLimit()));
                }
                if (this.getEnableStatistics() != null) {
                    data.set("enableStatistics", om.valueToTree(this.getEnableStatistics()));
                }
                if (this.getEncodingType() != null) {
                    data.set("encodingType", om.valueToTree(this.getEncodingType()));
                }
                if (this.getEncryptionMode() != null) {
                    data.set("encryptionMode", om.valueToTree(this.getEncryptionMode()));
                }
                if (this.getExpectedBucketOwner() != null) {
                    data.set("expectedBucketOwner", om.valueToTree(this.getExpectedBucketOwner()));
                }
                if (this.getExternalTableDefinition() != null) {
                    data.set("externalTableDefinition", om.valueToTree(this.getExternalTableDefinition()));
                }
                if (this.getGlueCatalogGeneration() != null) {
                    data.set("glueCatalogGeneration", om.valueToTree(this.getGlueCatalogGeneration()));
                }
                if (this.getIgnoreHeaderRows() != null) {
                    data.set("ignoreHeaderRows", om.valueToTree(this.getIgnoreHeaderRows()));
                }
                if (this.getIncludeOpForFullLoad() != null) {
                    data.set("includeOpForFullLoad", om.valueToTree(this.getIncludeOpForFullLoad()));
                }
                if (this.getMaxFileSize() != null) {
                    data.set("maxFileSize", om.valueToTree(this.getMaxFileSize()));
                }
                if (this.getParquetTimestampInMillisecond() != null) {
                    data.set("parquetTimestampInMillisecond", om.valueToTree(this.getParquetTimestampInMillisecond()));
                }
                if (this.getParquetVersion() != null) {
                    data.set("parquetVersion", om.valueToTree(this.getParquetVersion()));
                }
                if (this.getPreserveTransactions() != null) {
                    data.set("preserveTransactions", om.valueToTree(this.getPreserveTransactions()));
                }
                if (this.getRfc4180() != null) {
                    data.set("rfc4180", om.valueToTree(this.getRfc4180()));
                }
                if (this.getRowGroupLength() != null) {
                    data.set("rowGroupLength", om.valueToTree(this.getRowGroupLength()));
                }
                if (this.getServerSideEncryptionKmsKeyId() != null) {
                    data.set("serverSideEncryptionKmsKeyId", om.valueToTree(this.getServerSideEncryptionKmsKeyId()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }
                if (this.getTimestampColumnName() != null) {
                    data.set("timestampColumnName", om.valueToTree(this.getTimestampColumnName()));
                }
                if (this.getUseCsvNoSupValue() != null) {
                    data.set("useCsvNoSupValue", om.valueToTree(this.getUseCsvNoSupValue()));
                }
                if (this.getUseTaskStartTimeForFullLoadTimestamp() != null) {
                    data.set("useTaskStartTimeForFullLoadTimestamp", om.valueToTree(this.getUseTaskStartTimeForFullLoadTimestamp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.S3SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3SettingsProperty.Jsii$Proxy that = (S3SettingsProperty.Jsii$Proxy) o;

                if (this.addColumnName != null ? !this.addColumnName.equals(that.addColumnName) : that.addColumnName != null) return false;
                if (this.addTrailingPaddingCharacter != null ? !this.addTrailingPaddingCharacter.equals(that.addTrailingPaddingCharacter) : that.addTrailingPaddingCharacter != null) return false;
                if (this.bucketFolder != null ? !this.bucketFolder.equals(that.bucketFolder) : that.bucketFolder != null) return false;
                if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
                if (this.cannedAclForObjects != null ? !this.cannedAclForObjects.equals(that.cannedAclForObjects) : that.cannedAclForObjects != null) return false;
                if (this.cdcInsertsAndUpdates != null ? !this.cdcInsertsAndUpdates.equals(that.cdcInsertsAndUpdates) : that.cdcInsertsAndUpdates != null) return false;
                if (this.cdcInsertsOnly != null ? !this.cdcInsertsOnly.equals(that.cdcInsertsOnly) : that.cdcInsertsOnly != null) return false;
                if (this.cdcMaxBatchInterval != null ? !this.cdcMaxBatchInterval.equals(that.cdcMaxBatchInterval) : that.cdcMaxBatchInterval != null) return false;
                if (this.cdcMinFileSize != null ? !this.cdcMinFileSize.equals(that.cdcMinFileSize) : that.cdcMinFileSize != null) return false;
                if (this.cdcPath != null ? !this.cdcPath.equals(that.cdcPath) : that.cdcPath != null) return false;
                if (this.compressionType != null ? !this.compressionType.equals(that.compressionType) : that.compressionType != null) return false;
                if (this.csvDelimiter != null ? !this.csvDelimiter.equals(that.csvDelimiter) : that.csvDelimiter != null) return false;
                if (this.csvNoSupValue != null ? !this.csvNoSupValue.equals(that.csvNoSupValue) : that.csvNoSupValue != null) return false;
                if (this.csvNullValue != null ? !this.csvNullValue.equals(that.csvNullValue) : that.csvNullValue != null) return false;
                if (this.csvRowDelimiter != null ? !this.csvRowDelimiter.equals(that.csvRowDelimiter) : that.csvRowDelimiter != null) return false;
                if (this.dataFormat != null ? !this.dataFormat.equals(that.dataFormat) : that.dataFormat != null) return false;
                if (this.dataPageSize != null ? !this.dataPageSize.equals(that.dataPageSize) : that.dataPageSize != null) return false;
                if (this.datePartitionDelimiter != null ? !this.datePartitionDelimiter.equals(that.datePartitionDelimiter) : that.datePartitionDelimiter != null) return false;
                if (this.datePartitionEnabled != null ? !this.datePartitionEnabled.equals(that.datePartitionEnabled) : that.datePartitionEnabled != null) return false;
                if (this.datePartitionSequence != null ? !this.datePartitionSequence.equals(that.datePartitionSequence) : that.datePartitionSequence != null) return false;
                if (this.datePartitionTimezone != null ? !this.datePartitionTimezone.equals(that.datePartitionTimezone) : that.datePartitionTimezone != null) return false;
                if (this.dictPageSizeLimit != null ? !this.dictPageSizeLimit.equals(that.dictPageSizeLimit) : that.dictPageSizeLimit != null) return false;
                if (this.enableStatistics != null ? !this.enableStatistics.equals(that.enableStatistics) : that.enableStatistics != null) return false;
                if (this.encodingType != null ? !this.encodingType.equals(that.encodingType) : that.encodingType != null) return false;
                if (this.encryptionMode != null ? !this.encryptionMode.equals(that.encryptionMode) : that.encryptionMode != null) return false;
                if (this.expectedBucketOwner != null ? !this.expectedBucketOwner.equals(that.expectedBucketOwner) : that.expectedBucketOwner != null) return false;
                if (this.externalTableDefinition != null ? !this.externalTableDefinition.equals(that.externalTableDefinition) : that.externalTableDefinition != null) return false;
                if (this.glueCatalogGeneration != null ? !this.glueCatalogGeneration.equals(that.glueCatalogGeneration) : that.glueCatalogGeneration != null) return false;
                if (this.ignoreHeaderRows != null ? !this.ignoreHeaderRows.equals(that.ignoreHeaderRows) : that.ignoreHeaderRows != null) return false;
                if (this.includeOpForFullLoad != null ? !this.includeOpForFullLoad.equals(that.includeOpForFullLoad) : that.includeOpForFullLoad != null) return false;
                if (this.maxFileSize != null ? !this.maxFileSize.equals(that.maxFileSize) : that.maxFileSize != null) return false;
                if (this.parquetTimestampInMillisecond != null ? !this.parquetTimestampInMillisecond.equals(that.parquetTimestampInMillisecond) : that.parquetTimestampInMillisecond != null) return false;
                if (this.parquetVersion != null ? !this.parquetVersion.equals(that.parquetVersion) : that.parquetVersion != null) return false;
                if (this.preserveTransactions != null ? !this.preserveTransactions.equals(that.preserveTransactions) : that.preserveTransactions != null) return false;
                if (this.rfc4180 != null ? !this.rfc4180.equals(that.rfc4180) : that.rfc4180 != null) return false;
                if (this.rowGroupLength != null ? !this.rowGroupLength.equals(that.rowGroupLength) : that.rowGroupLength != null) return false;
                if (this.serverSideEncryptionKmsKeyId != null ? !this.serverSideEncryptionKmsKeyId.equals(that.serverSideEncryptionKmsKeyId) : that.serverSideEncryptionKmsKeyId != null) return false;
                if (this.serviceAccessRoleArn != null ? !this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn != null) return false;
                if (this.timestampColumnName != null ? !this.timestampColumnName.equals(that.timestampColumnName) : that.timestampColumnName != null) return false;
                if (this.useCsvNoSupValue != null ? !this.useCsvNoSupValue.equals(that.useCsvNoSupValue) : that.useCsvNoSupValue != null) return false;
                return this.useTaskStartTimeForFullLoadTimestamp != null ? this.useTaskStartTimeForFullLoadTimestamp.equals(that.useTaskStartTimeForFullLoadTimestamp) : that.useTaskStartTimeForFullLoadTimestamp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addColumnName != null ? this.addColumnName.hashCode() : 0;
                result = 31 * result + (this.addTrailingPaddingCharacter != null ? this.addTrailingPaddingCharacter.hashCode() : 0);
                result = 31 * result + (this.bucketFolder != null ? this.bucketFolder.hashCode() : 0);
                result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
                result = 31 * result + (this.cannedAclForObjects != null ? this.cannedAclForObjects.hashCode() : 0);
                result = 31 * result + (this.cdcInsertsAndUpdates != null ? this.cdcInsertsAndUpdates.hashCode() : 0);
                result = 31 * result + (this.cdcInsertsOnly != null ? this.cdcInsertsOnly.hashCode() : 0);
                result = 31 * result + (this.cdcMaxBatchInterval != null ? this.cdcMaxBatchInterval.hashCode() : 0);
                result = 31 * result + (this.cdcMinFileSize != null ? this.cdcMinFileSize.hashCode() : 0);
                result = 31 * result + (this.cdcPath != null ? this.cdcPath.hashCode() : 0);
                result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
                result = 31 * result + (this.csvDelimiter != null ? this.csvDelimiter.hashCode() : 0);
                result = 31 * result + (this.csvNoSupValue != null ? this.csvNoSupValue.hashCode() : 0);
                result = 31 * result + (this.csvNullValue != null ? this.csvNullValue.hashCode() : 0);
                result = 31 * result + (this.csvRowDelimiter != null ? this.csvRowDelimiter.hashCode() : 0);
                result = 31 * result + (this.dataFormat != null ? this.dataFormat.hashCode() : 0);
                result = 31 * result + (this.dataPageSize != null ? this.dataPageSize.hashCode() : 0);
                result = 31 * result + (this.datePartitionDelimiter != null ? this.datePartitionDelimiter.hashCode() : 0);
                result = 31 * result + (this.datePartitionEnabled != null ? this.datePartitionEnabled.hashCode() : 0);
                result = 31 * result + (this.datePartitionSequence != null ? this.datePartitionSequence.hashCode() : 0);
                result = 31 * result + (this.datePartitionTimezone != null ? this.datePartitionTimezone.hashCode() : 0);
                result = 31 * result + (this.dictPageSizeLimit != null ? this.dictPageSizeLimit.hashCode() : 0);
                result = 31 * result + (this.enableStatistics != null ? this.enableStatistics.hashCode() : 0);
                result = 31 * result + (this.encodingType != null ? this.encodingType.hashCode() : 0);
                result = 31 * result + (this.encryptionMode != null ? this.encryptionMode.hashCode() : 0);
                result = 31 * result + (this.expectedBucketOwner != null ? this.expectedBucketOwner.hashCode() : 0);
                result = 31 * result + (this.externalTableDefinition != null ? this.externalTableDefinition.hashCode() : 0);
                result = 31 * result + (this.glueCatalogGeneration != null ? this.glueCatalogGeneration.hashCode() : 0);
                result = 31 * result + (this.ignoreHeaderRows != null ? this.ignoreHeaderRows.hashCode() : 0);
                result = 31 * result + (this.includeOpForFullLoad != null ? this.includeOpForFullLoad.hashCode() : 0);
                result = 31 * result + (this.maxFileSize != null ? this.maxFileSize.hashCode() : 0);
                result = 31 * result + (this.parquetTimestampInMillisecond != null ? this.parquetTimestampInMillisecond.hashCode() : 0);
                result = 31 * result + (this.parquetVersion != null ? this.parquetVersion.hashCode() : 0);
                result = 31 * result + (this.preserveTransactions != null ? this.preserveTransactions.hashCode() : 0);
                result = 31 * result + (this.rfc4180 != null ? this.rfc4180.hashCode() : 0);
                result = 31 * result + (this.rowGroupLength != null ? this.rowGroupLength.hashCode() : 0);
                result = 31 * result + (this.serverSideEncryptionKmsKeyId != null ? this.serverSideEncryptionKmsKeyId.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.timestampColumnName != null ? this.timestampColumnName.hashCode() : 0);
                result = 31 * result + (this.useCsvNoSupValue != null ? this.useCsvNoSupValue.hashCode() : 0);
                result = 31 * result + (this.useTaskStartTimeForFullLoadTimestamp != null ? this.useTaskStartTimeForFullLoadTimestamp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a SAP ASE endpoint.
     * <p>
     * This information includes the output format of records applied to the endpoint and details of transaction and control table data information. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * SybaseSettingsProperty sybaseSettingsProperty = SybaseSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-sybasesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-sybasesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.SybaseSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SybaseSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SybaseSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the SAP ASE endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
         * <p>
         * For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-sybasesettings.html#cfn-dms-endpoint-sybasesettings-secretsmanageraccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-sybasesettings.html#cfn-dms-endpoint-sybasesettings-secretsmanageraccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the SAP SAE endpoint connection details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-sybasesettings.html#cfn-dms-endpoint-sybasesettings-secretsmanagersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-sybasesettings.html#cfn-dms-endpoint-sybasesettings-secretsmanagersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SybaseSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SybaseSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SybaseSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link SybaseSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code> .
             *                                    The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the SAP ASE endpoint.
             *                                    <p>
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both.
             *                                    <p>
             *                                    For more information on creating this <code>SecretsManagerSecret</code> , the corresponding <code>SecretsManagerAccessRoleArn</code> , and the <code>SecretsManagerSecretId</code> that is required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link SybaseSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or display name of the <code>SecretsManagerSecret</code> that contains the SAP SAE endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SybaseSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SybaseSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SybaseSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SybaseSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.SybaseSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SybaseSettingsProperty.Jsii$Proxy that = (SybaseSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dms.CfnEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dms.CfnEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dms.CfnEndpointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dms.CfnEndpointProps.Builder();
        }

        /**
         * The type of endpoint.
         * <p>
         * Valid values are <code>source</code> and <code>target</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointtype</a>
         * @param endpointType The type of endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(final java.lang.String endpointType) {
            this.props.endpointType(endpointType);
            return this;
        }

        /**
         * The type of engine for the endpoint, depending on the <code>EndpointType</code> value.
         * <p>
         * <em>Valid values</em> : <code>mysql</code> | <code>oracle</code> | <code>postgres</code> | <code>mariadb</code> | <code>aurora</code> | <code>aurora-postgresql</code> | <code>opensearch</code> | <code>redshift</code> | <code>redshift-serverless</code> | <code>s3</code> | <code>db2</code> | <code>azuredb</code> | <code>sybase</code> | <code>dynamodb</code> | <code>mongodb</code> | <code>kinesis</code> | <code>kafka</code> | <code>elasticsearch</code> | <code>docdb</code> | <code>sqlserver</code> | <code>neptune</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-enginename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-enginename</a>
         * @param engineName The type of engine for the endpoint, depending on the <code>EndpointType</code> value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineName(final java.lang.String engineName) {
            this.props.engineName(engineName);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) for the certificate.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-certificatearn</a>
         * @param certificateArn The Amazon Resource Name (ARN) for the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateArn(final java.lang.String certificateArn) {
            this.props.certificateArn(certificateArn);
            return this;
        }

        /**
         * The name of the endpoint database.
         * <p>
         * For a MySQL source or target endpoint, don't specify <code>DatabaseName</code> . To migrate to a specific database, use this setting and <code>targetDbType</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-databasename</a>
         * @param databaseName The name of the endpoint database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * Settings in JSON format for the source and target DocumentDB endpoint.
         * <p>
         * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html#CHAP_Source.DocumentDB.ECAs">Using extra connections attributes with Amazon DocumentDB as a source</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DocumentDB.html">Using Amazon DocumentDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-docdbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-docdbsettings</a>
         * @param docDbSettings Settings in JSON format for the source and target DocumentDB endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder docDbSettings(final software.amazon.awscdk.IResolvable docDbSettings) {
            this.props.docDbSettings(docDbSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source and target DocumentDB endpoint.
         * <p>
         * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html#CHAP_Source.DocumentDB.ECAs">Using extra connections attributes with Amazon DocumentDB as a source</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DocumentDB.html">Using Amazon DocumentDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-docdbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-docdbsettings</a>
         * @param docDbSettings Settings in JSON format for the source and target DocumentDB endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder docDbSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.DocDbSettingsProperty docDbSettings) {
            this.props.docDbSettings(docDbSettings);
            return this;
        }

        /**
         * Settings in JSON format for the target Amazon DynamoDB endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using object mapping to migrate data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-dynamodbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-dynamodbsettings</a>
         * @param dynamoDbSettings Settings in JSON format for the target Amazon DynamoDB endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbSettings(final software.amazon.awscdk.IResolvable dynamoDbSettings) {
            this.props.dynamoDbSettings(dynamoDbSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target Amazon DynamoDB endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using object mapping to migrate data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-dynamodbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-dynamodbsettings</a>
         * @param dynamoDbSettings Settings in JSON format for the target Amazon DynamoDB endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.DynamoDbSettingsProperty dynamoDbSettings) {
            this.props.dynamoDbSettings(dynamoDbSettings);
            return this;
        }

        /**
         * Settings in JSON format for the target OpenSearch endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra connection attributes when using OpenSearch as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-elasticsearchsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-elasticsearchsettings</a>
         * @param elasticsearchSettings Settings in JSON format for the target OpenSearch endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchSettings(final software.amazon.awscdk.IResolvable elasticsearchSettings) {
            this.props.elasticsearchSettings(elasticsearchSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target OpenSearch endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra connection attributes when using OpenSearch as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-elasticsearchsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-elasticsearchsettings</a>
         * @param elasticsearchSettings Settings in JSON format for the target OpenSearch endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.ElasticsearchSettingsProperty elasticsearchSettings) {
            this.props.elasticsearchSettings(elasticsearchSettings);
            return this;
        }

        /**
         * The database endpoint identifier.
         * <p>
         * Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointidentifier</a>
         * @param endpointIdentifier The database endpoint identifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointIdentifier(final java.lang.String endpointIdentifier) {
            this.props.endpointIdentifier(endpointIdentifier);
            return this;
        }

        /**
         * Additional attributes associated with the connection.
         * <p>
         * Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with AWS DMS Endpoints</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-extraconnectionattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-extraconnectionattributes</a>
         * @param extraConnectionAttributes Additional attributes associated with the connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraConnectionAttributes(final java.lang.String extraConnectionAttributes) {
            this.props.extraConnectionAttributes(extraConnectionAttributes);
            return this;
        }

        /**
         * Settings in JSON format for the source GCP MySQL endpoint.
         * <p>
         * These settings are much the same as the settings for any MySQL-compatible endpoint. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-gcpmysqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-gcpmysqlsettings</a>
         * @param gcpMySqlSettings Settings in JSON format for the source GCP MySQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gcpMySqlSettings(final software.amazon.awscdk.IResolvable gcpMySqlSettings) {
            this.props.gcpMySqlSettings(gcpMySqlSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source GCP MySQL endpoint.
         * <p>
         * These settings are much the same as the settings for any MySQL-compatible endpoint. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-gcpmysqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-gcpmysqlsettings</a>
         * @param gcpMySqlSettings Settings in JSON format for the source GCP MySQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gcpMySqlSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.GcpMySQLSettingsProperty gcpMySqlSettings) {
            this.props.gcpMySqlSettings(gcpMySqlSettings);
            return this;
        }

        /**
         * Settings in JSON format for the source IBM Db2 LUW endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-ibmdb2settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-ibmdb2settings</a>
         * @param ibmDb2Settings Settings in JSON format for the source IBM Db2 LUW endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ibmDb2Settings(final software.amazon.awscdk.IResolvable ibmDb2Settings) {
            this.props.ibmDb2Settings(ibmDb2Settings);
            return this;
        }
        /**
         * Settings in JSON format for the source IBM Db2 LUW endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-ibmdb2settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-ibmdb2settings</a>
         * @param ibmDb2Settings Settings in JSON format for the source IBM Db2 LUW endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ibmDb2Settings(final software.amazon.awscdk.services.dms.CfnEndpoint.IbmDb2SettingsProperty ibmDb2Settings) {
            this.props.ibmDb2Settings(ibmDb2Settings);
            return this;
        }

        /**
         * Settings in JSON format for the target Apache Kafka endpoint.
         * <p>
         * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kafkasettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kafkasettings</a>
         * @param kafkaSettings Settings in JSON format for the target Apache Kafka endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaSettings(final software.amazon.awscdk.IResolvable kafkaSettings) {
            this.props.kafkaSettings(kafkaSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target Apache Kafka endpoint.
         * <p>
         * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kafkasettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kafkasettings</a>
         * @param kafkaSettings Settings in JSON format for the target Apache Kafka endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.KafkaSettingsProperty kafkaSettings) {
            this.props.kafkaSettings(kafkaSettings);
            return this;
        }

        /**
         * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
         * <p>
         * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kinesissettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kinesissettings</a>
         * @param kinesisSettings Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisSettings(final software.amazon.awscdk.IResolvable kinesisSettings) {
            this.props.kinesisSettings(kinesisSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
         * <p>
         * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kinesissettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kinesissettings</a>
         * @param kinesisSettings Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.KinesisSettingsProperty kinesisSettings) {
            this.props.kinesisSettings(kinesisSettings);
            return this;
        }

        /**
         * An AWS KMS key identifier that is used to encrypt the connection parameters for the endpoint.
         * <p>
         * If you don't specify a value for the <code>KmsKeyId</code> parameter, AWS DMS uses your default encryption key.
         * <p>
         * AWS KMS creates the default encryption key for your AWS account . Your AWS account has a different default encryption key for each AWS Region .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kmskeyid</a>
         * @param kmsKeyId An AWS KMS key identifier that is used to encrypt the connection parameters for the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Settings in JSON format for the source and target Microsoft SQL Server endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-microsoftsqlserversettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-microsoftsqlserversettings</a>
         * @param microsoftSqlServerSettings Settings in JSON format for the source and target Microsoft SQL Server endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder microsoftSqlServerSettings(final software.amazon.awscdk.IResolvable microsoftSqlServerSettings) {
            this.props.microsoftSqlServerSettings(microsoftSqlServerSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source and target Microsoft SQL Server endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-microsoftsqlserversettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-microsoftsqlserversettings</a>
         * @param microsoftSqlServerSettings Settings in JSON format for the source and target Microsoft SQL Server endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder microsoftSqlServerSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty microsoftSqlServerSettings) {
            this.props.microsoftSqlServerSettings(microsoftSqlServerSettings);
            return this;
        }

        /**
         * Settings in JSON format for the source MongoDB endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Using MongoDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mongodbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mongodbsettings</a>
         * @param mongoDbSettings Settings in JSON format for the source MongoDB endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mongoDbSettings(final software.amazon.awscdk.IResolvable mongoDbSettings) {
            this.props.mongoDbSettings(mongoDbSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source MongoDB endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Using MongoDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mongodbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mongodbsettings</a>
         * @param mongoDbSettings Settings in JSON format for the source MongoDB endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mongoDbSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.MongoDbSettingsProperty mongoDbSettings) {
            this.props.mongoDbSettings(mongoDbSettings);
            return this;
        }

        /**
         * Settings in JSON format for the source and target MySQL endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mysqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mysqlsettings</a>
         * @param mySqlSettings Settings in JSON format for the source and target MySQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mySqlSettings(final software.amazon.awscdk.IResolvable mySqlSettings) {
            this.props.mySqlSettings(mySqlSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source and target MySQL endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mysqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mysqlsettings</a>
         * @param mySqlSettings Settings in JSON format for the source and target MySQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mySqlSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.MySqlSettingsProperty mySqlSettings) {
            this.props.mySqlSettings(mySqlSettings);
            return this;
        }

        /**
         * Settings in JSON format for the target Amazon Neptune endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying endpoint settings for Amazon Neptune as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-neptunesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-neptunesettings</a>
         * @param neptuneSettings Settings in JSON format for the target Amazon Neptune endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder neptuneSettings(final software.amazon.awscdk.IResolvable neptuneSettings) {
            this.props.neptuneSettings(neptuneSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target Amazon Neptune endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying endpoint settings for Amazon Neptune as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-neptunesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-neptunesettings</a>
         * @param neptuneSettings Settings in JSON format for the target Amazon Neptune endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder neptuneSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.NeptuneSettingsProperty neptuneSettings) {
            this.props.neptuneSettings(neptuneSettings);
            return this;
        }

        /**
         * Settings in JSON format for the source and target Oracle endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-oraclesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-oraclesettings</a>
         * @param oracleSettings Settings in JSON format for the source and target Oracle endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oracleSettings(final software.amazon.awscdk.IResolvable oracleSettings) {
            this.props.oracleSettings(oracleSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source and target Oracle endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-oraclesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-oraclesettings</a>
         * @param oracleSettings Settings in JSON format for the source and target Oracle endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oracleSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.OracleSettingsProperty oracleSettings) {
            this.props.oracleSettings(oracleSettings);
            return this;
        }

        /**
         * The password to be used to log in to the endpoint database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-password</a>
         * @param password The password to be used to log in to the endpoint database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(final java.lang.String password) {
            this.props.password(password);
            return this;
        }

        /**
         * The port used by the endpoint database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-port</a>
         * @param port The port used by the endpoint database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * Settings in JSON format for the source and target PostgreSQL endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-postgresqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-postgresqlsettings</a>
         * @param postgreSqlSettings Settings in JSON format for the source and target PostgreSQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postgreSqlSettings(final software.amazon.awscdk.IResolvable postgreSqlSettings) {
            this.props.postgreSqlSettings(postgreSqlSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source and target PostgreSQL endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-postgresqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-postgresqlsettings</a>
         * @param postgreSqlSettings Settings in JSON format for the source and target PostgreSQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postgreSqlSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.PostgreSqlSettingsProperty postgreSqlSettings) {
            this.props.postgreSqlSettings(postgreSqlSettings);
            return this;
        }

        /**
         * Settings in JSON format for the target Redis endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redis.html#CHAP_Target.Redis.EndpointSettings">Specifying endpoint settings for Redis as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redissettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redissettings</a>
         * @param redisSettings Settings in JSON format for the target Redis endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redisSettings(final software.amazon.awscdk.IResolvable redisSettings) {
            this.props.redisSettings(redisSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target Redis endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redis.html#CHAP_Target.Redis.EndpointSettings">Specifying endpoint settings for Redis as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redissettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redissettings</a>
         * @param redisSettings Settings in JSON format for the target Redis endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redisSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.RedisSettingsProperty redisSettings) {
            this.props.redisSettings(redisSettings);
            return this;
        }

        /**
         * Settings in JSON format for the Amazon Redshift endpoint.
         * <p>
         * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redshift.html#CHAP_Target.Redshift.ConnectionAttrib">Extra connection attributes when using Amazon Redshift as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redshiftsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redshiftsettings</a>
         * @param redshiftSettings Settings in JSON format for the Amazon Redshift endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftSettings(final software.amazon.awscdk.IResolvable redshiftSettings) {
            this.props.redshiftSettings(redshiftSettings);
            return this;
        }
        /**
         * Settings in JSON format for the Amazon Redshift endpoint.
         * <p>
         * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redshift.html#CHAP_Target.Redshift.ConnectionAttrib">Extra connection attributes when using Amazon Redshift as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redshiftsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redshiftsettings</a>
         * @param redshiftSettings Settings in JSON format for the Amazon Redshift endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.RedshiftSettingsProperty redshiftSettings) {
            this.props.redshiftSettings(redshiftSettings);
            return this;
        }

        /**
         * A display name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object.
         * <p>
         * The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code> .
         * <p>
         * For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code> . If you don't specify a <code>ResourceIdentifier</code> value, AWS DMS generates a default identifier value for the end of <code>EndpointArn</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-resourceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-resourceidentifier</a>
         * @param resourceIdentifier A display name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceIdentifier(final java.lang.String resourceIdentifier) {
            this.props.resourceIdentifier(resourceIdentifier);
            return this;
        }

        /**
         * Settings in JSON format for the source and target Amazon S3 endpoint.
         * <p>
         * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.S3.html#CHAP_Source.S3.Configuring">Extra connection attributes when using Amazon S3 as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra connection attributes when using Amazon S3 as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-s3settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-s3settings</a>
         * @param s3Settings Settings in JSON format for the source and target Amazon S3 endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Settings(final software.amazon.awscdk.IResolvable s3Settings) {
            this.props.s3Settings(s3Settings);
            return this;
        }
        /**
         * Settings in JSON format for the source and target Amazon S3 endpoint.
         * <p>
         * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.S3.html#CHAP_Source.S3.Configuring">Extra connection attributes when using Amazon S3 as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra connection attributes when using Amazon S3 as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-s3settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-s3settings</a>
         * @param s3Settings Settings in JSON format for the source and target Amazon S3 endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Settings(final software.amazon.awscdk.services.dms.CfnEndpoint.S3SettingsProperty s3Settings) {
            this.props.s3Settings(s3Settings);
            return this;
        }

        /**
         * The name of the server where the endpoint database resides.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-servername</a>
         * @param serverName The name of the server where the endpoint database resides. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverName(final java.lang.String serverName) {
            this.props.serverName(serverName);
            return this;
        }

        /**
         * The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code> .
         * <p>
         * <blockquote>
         * <p>
         * When <code>engine_name</code> is set to S3, the only allowed value is <code>none</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sslmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sslmode</a>
         * @param sslMode The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslMode(final java.lang.String sslMode) {
            this.props.sslMode(sslMode);
            return this;
        }

        /**
         * Settings in JSON format for the source and target SAP ASE endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sybasesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sybasesettings</a>
         * @param sybaseSettings Settings in JSON format for the source and target SAP ASE endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sybaseSettings(final software.amazon.awscdk.IResolvable sybaseSettings) {
            this.props.sybaseSettings(sybaseSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source and target SAP ASE endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sybasesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sybasesettings</a>
         * @param sybaseSettings Settings in JSON format for the source and target SAP ASE endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sybaseSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.SybaseSettingsProperty sybaseSettings) {
            this.props.sybaseSettings(sybaseSettings);
            return this;
        }

        /**
         * One or more tags to be assigned to the endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-tags</a>
         * @param tags One or more tags to be assigned to the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The user name to be used to log in to the endpoint database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-username</a>
         * @param username The user name to be used to log in to the endpoint database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(final java.lang.String username) {
            this.props.username(username);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dms.CfnEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dms.CfnEndpoint build() {
            return new software.amazon.awscdk.services.dms.CfnEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
