package software.amazon.awscdk.services.ec2;

/**
 * Specifies a network insights analysis.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnNetworkInsightsAnalysis cfnNetworkInsightsAnalysis = CfnNetworkInsightsAnalysis.Builder.create(this, "MyCfnNetworkInsightsAnalysis")
 *         .networkInsightsPathId("networkInsightsPathId")
 *         // the properties below are optional
 *         .additionalAccounts(List.of("additionalAccounts"))
 *         .filterInArns(List.of("filterInArns"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:56.334Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis")
public class CfnNetworkInsightsAnalysis extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnNetworkInsightsAnalysis(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnNetworkInsightsAnalysis(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnNetworkInsightsAnalysis(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysisProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Potential intermediate components.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrAlternatePathHints() {
        return software.amazon.jsii.Kernel.get(this, "attrAlternatePathHints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The explanations.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrExplanations() {
        return software.amazon.jsii.Kernel.get(this, "attrExplanations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The components in the path from source to destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrForwardPathComponents() {
        return software.amazon.jsii.Kernel.get(this, "attrForwardPathComponents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the network insights analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNetworkInsightsAnalysisArn() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkInsightsAnalysisArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the network insights analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNetworkInsightsAnalysisId() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkInsightsAnalysisId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether the destination is reachable from the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrNetworkPathFound() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkPathFound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The components in the path from destination to source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrReturnPathComponents() {
        return software.amazon.jsii.Kernel.get(this, "attrReturnPathComponents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The time the analysis started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStartDate() {
        return software.amazon.jsii.Kernel.get(this, "attrStartDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the network insights analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status message, if the status is <code>failed</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IDs of potential intermediate accounts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrSuggestedAccounts() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrSuggestedAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID of the path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNetworkInsightsPathId() {
        return software.amazon.jsii.Kernel.get(this, "networkInsightsPathId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkInsightsPathId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "networkInsightsPathId", java.util.Objects.requireNonNull(value, "networkInsightsPathId is required"));
    }

    /**
     * The member accounts that contain resources that the path can traverse.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalAccounts() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "additionalAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The member accounts that contain resources that the path can traverse.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalAccounts(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "additionalAccounts", value);
    }

    /**
     * The Amazon Resource Names (ARN) of the resources that the path must traverse.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFilterInArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "filterInArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The Amazon Resource Names (ARN) of the resources that the path must traverse.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilterInArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "filterInArns", value);
    }

    /**
     * The tags to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Describes an additional detail for a path analysis.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/additional-detail-codes.html">Reachability Analyzer additional detail codes</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AdditionalDetailProperty additionalDetailProperty = AdditionalDetailProperty.builder()
     *         .additionalDetailType("additionalDetailType")
     *         .component(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .loadBalancers(List.of(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build()))
     *         .serviceName("serviceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-additionaldetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-additionaldetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AdditionalDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(AdditionalDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdditionalDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The additional detail code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-additionaldetail.html#cfn-ec2-networkinsightsanalysis-additionaldetail-additionaldetailtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-additionaldetail.html#cfn-ec2-networkinsightsanalysis-additionaldetail-additionaldetailtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalDetailType() {
            return null;
        }

        /**
         * The path component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-additionaldetail.html#cfn-ec2-networkinsightsanalysis-additionaldetail-component">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-additionaldetail.html#cfn-ec2-networkinsightsanalysis-additionaldetail-component</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComponent() {
            return null;
        }

        /**
         * The load balancers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-additionaldetail.html#cfn-ec2-networkinsightsanalysis-additionaldetail-loadbalancers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-additionaldetail.html#cfn-ec2-networkinsightsanalysis-additionaldetail-loadbalancers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancers() {
            return null;
        }

        /**
         * The name of the VPC endpoint service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-additionaldetail.html#cfn-ec2-networkinsightsanalysis-additionaldetail-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-additionaldetail.html#cfn-ec2-networkinsightsanalysis-additionaldetail-servicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdditionalDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdditionalDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdditionalDetailProperty> {
            java.lang.String additionalDetailType;
            java.lang.Object component;
            java.lang.Object loadBalancers;
            java.lang.String serviceName;

            /**
             * Sets the value of {@link AdditionalDetailProperty#getAdditionalDetailType}
             * @param additionalDetailType The additional detail code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalDetailType(java.lang.String additionalDetailType) {
                this.additionalDetailType = additionalDetailType;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalDetailProperty#getComponent}
             * @param component The path component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder component(software.amazon.awscdk.IResolvable component) {
                this.component = component;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalDetailProperty#getComponent}
             * @param component The path component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder component(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty component) {
                this.component = component;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalDetailProperty#getLoadBalancers}
             * @param loadBalancers The load balancers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancers(software.amazon.awscdk.IResolvable loadBalancers) {
                this.loadBalancers = loadBalancers;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalDetailProperty#getLoadBalancers}
             * @param loadBalancers The load balancers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancers(java.util.List<? extends java.lang.Object> loadBalancers) {
                this.loadBalancers = loadBalancers;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalDetailProperty#getServiceName}
             * @param serviceName The name of the VPC endpoint service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdditionalDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdditionalDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdditionalDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdditionalDetailProperty {
            private final java.lang.String additionalDetailType;
            private final java.lang.Object component;
            private final java.lang.Object loadBalancers;
            private final java.lang.String serviceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalDetailType = software.amazon.jsii.Kernel.get(this, "additionalDetailType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.component = software.amazon.jsii.Kernel.get(this, "component", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loadBalancers = software.amazon.jsii.Kernel.get(this, "loadBalancers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalDetailType = builder.additionalDetailType;
                this.component = builder.component;
                this.loadBalancers = builder.loadBalancers;
                this.serviceName = builder.serviceName;
            }

            @Override
            public final java.lang.String getAdditionalDetailType() {
                return this.additionalDetailType;
            }

            @Override
            public final java.lang.Object getComponent() {
                return this.component;
            }

            @Override
            public final java.lang.Object getLoadBalancers() {
                return this.loadBalancers;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalDetailType() != null) {
                    data.set("additionalDetailType", om.valueToTree(this.getAdditionalDetailType()));
                }
                if (this.getComponent() != null) {
                    data.set("component", om.valueToTree(this.getComponent()));
                }
                if (this.getLoadBalancers() != null) {
                    data.set("loadBalancers", om.valueToTree(this.getLoadBalancers()));
                }
                if (this.getServiceName() != null) {
                    data.set("serviceName", om.valueToTree(this.getServiceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AdditionalDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdditionalDetailProperty.Jsii$Proxy that = (AdditionalDetailProperty.Jsii$Proxy) o;

                if (this.additionalDetailType != null ? !this.additionalDetailType.equals(that.additionalDetailType) : that.additionalDetailType != null) return false;
                if (this.component != null ? !this.component.equals(that.component) : that.component != null) return false;
                if (this.loadBalancers != null ? !this.loadBalancers.equals(that.loadBalancers) : that.loadBalancers != null) return false;
                return this.serviceName != null ? this.serviceName.equals(that.serviceName) : that.serviceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalDetailType != null ? this.additionalDetailType.hashCode() : 0;
                result = 31 * result + (this.component != null ? this.component.hashCode() : 0);
                result = 31 * result + (this.loadBalancers != null ? this.loadBalancers.hashCode() : 0);
                result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an potential intermediate component of a feasible path.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AlternatePathHintProperty alternatePathHintProperty = AlternatePathHintProperty.builder()
     *         .componentArn("componentArn")
     *         .componentId("componentId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AlternatePathHintProperty")
    @software.amazon.jsii.Jsii.Proxy(AlternatePathHintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlternatePathHintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html#cfn-ec2-networkinsightsanalysis-alternatepathhint-componentarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html#cfn-ec2-networkinsightsanalysis-alternatepathhint-componentarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentArn() {
            return null;
        }

        /**
         * The ID of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html#cfn-ec2-networkinsightsanalysis-alternatepathhint-componentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html#cfn-ec2-networkinsightsanalysis-alternatepathhint-componentid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlternatePathHintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlternatePathHintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlternatePathHintProperty> {
            java.lang.String componentArn;
            java.lang.String componentId;

            /**
             * Sets the value of {@link AlternatePathHintProperty#getComponentArn}
             * @param componentArn The Amazon Resource Name (ARN) of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentArn(java.lang.String componentArn) {
                this.componentArn = componentArn;
                return this;
            }

            /**
             * Sets the value of {@link AlternatePathHintProperty#getComponentId}
             * @param componentId The ID of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentId(java.lang.String componentId) {
                this.componentId = componentId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlternatePathHintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlternatePathHintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlternatePathHintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlternatePathHintProperty {
            private final java.lang.String componentArn;
            private final java.lang.String componentId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentArn = software.amazon.jsii.Kernel.get(this, "componentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.componentId = software.amazon.jsii.Kernel.get(this, "componentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentArn = builder.componentArn;
                this.componentId = builder.componentId;
            }

            @Override
            public final java.lang.String getComponentArn() {
                return this.componentArn;
            }

            @Override
            public final java.lang.String getComponentId() {
                return this.componentId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComponentArn() != null) {
                    data.set("componentArn", om.valueToTree(this.getComponentArn()));
                }
                if (this.getComponentId() != null) {
                    data.set("componentId", om.valueToTree(this.getComponentId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AlternatePathHintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlternatePathHintProperty.Jsii$Proxy that = (AlternatePathHintProperty.Jsii$Proxy) o;

                if (this.componentArn != null ? !this.componentArn.equals(that.componentArn) : that.componentArn != null) return false;
                return this.componentId != null ? this.componentId.equals(that.componentId) : that.componentId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentArn != null ? this.componentArn.hashCode() : 0;
                result = 31 * result + (this.componentId != null ? this.componentId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a network access control (ACL) rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AnalysisAclRuleProperty analysisAclRuleProperty = AnalysisAclRuleProperty.builder()
     *         .cidr("cidr")
     *         .egress(false)
     *         .portRange(PortRangeProperty.builder()
     *                 .from(123)
     *                 .to(123)
     *                 .build())
     *         .protocol("protocol")
     *         .ruleAction("ruleAction")
     *         .ruleNumber(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisAclRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisAclRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IPv4 address range, in CIDR notation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-cidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-cidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidr() {
            return null;
        }

        /**
         * Indicates whether the rule is an outbound rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-egress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-egress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEgress() {
            return null;
        }

        /**
         * The range of ports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-portrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-portrange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPortRange() {
            return null;
        }

        /**
         * The protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * Indicates whether to allow or deny traffic that matches the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-ruleaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-ruleaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuleAction() {
            return null;
        }

        /**
         * The rule number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-rulenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-rulenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRuleNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisAclRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisAclRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisAclRuleProperty> {
            java.lang.String cidr;
            java.lang.Object egress;
            java.lang.Object portRange;
            java.lang.String protocol;
            java.lang.String ruleAction;
            java.lang.Number ruleNumber;

            /**
             * Sets the value of {@link AnalysisAclRuleProperty#getCidr}
             * @param cidr The IPv4 address range, in CIDR notation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidr(java.lang.String cidr) {
                this.cidr = cidr;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisAclRuleProperty#getEgress}
             * @param egress Indicates whether the rule is an outbound rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder egress(java.lang.Boolean egress) {
                this.egress = egress;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisAclRuleProperty#getEgress}
             * @param egress Indicates whether the rule is an outbound rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder egress(software.amazon.awscdk.IResolvable egress) {
                this.egress = egress;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisAclRuleProperty#getPortRange}
             * @param portRange The range of ports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portRange(software.amazon.awscdk.IResolvable portRange) {
                this.portRange = portRange;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisAclRuleProperty#getPortRange}
             * @param portRange The range of ports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portRange(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.PortRangeProperty portRange) {
                this.portRange = portRange;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisAclRuleProperty#getProtocol}
             * @param protocol The protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisAclRuleProperty#getRuleAction}
             * @param ruleAction Indicates whether to allow or deny traffic that matches the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleAction(java.lang.String ruleAction) {
                this.ruleAction = ruleAction;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisAclRuleProperty#getRuleNumber}
             * @param ruleNumber The rule number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleNumber(java.lang.Number ruleNumber) {
                this.ruleNumber = ruleNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisAclRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisAclRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisAclRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisAclRuleProperty {
            private final java.lang.String cidr;
            private final java.lang.Object egress;
            private final java.lang.Object portRange;
            private final java.lang.String protocol;
            private final java.lang.String ruleAction;
            private final java.lang.Number ruleNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.egress = software.amazon.jsii.Kernel.get(this, "egress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.portRange = software.amazon.jsii.Kernel.get(this, "portRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ruleAction = software.amazon.jsii.Kernel.get(this, "ruleAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ruleNumber = software.amazon.jsii.Kernel.get(this, "ruleNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cidr = builder.cidr;
                this.egress = builder.egress;
                this.portRange = builder.portRange;
                this.protocol = builder.protocol;
                this.ruleAction = builder.ruleAction;
                this.ruleNumber = builder.ruleNumber;
            }

            @Override
            public final java.lang.String getCidr() {
                return this.cidr;
            }

            @Override
            public final java.lang.Object getEgress() {
                return this.egress;
            }

            @Override
            public final java.lang.Object getPortRange() {
                return this.portRange;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.String getRuleAction() {
                return this.ruleAction;
            }

            @Override
            public final java.lang.Number getRuleNumber() {
                return this.ruleNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCidr() != null) {
                    data.set("cidr", om.valueToTree(this.getCidr()));
                }
                if (this.getEgress() != null) {
                    data.set("egress", om.valueToTree(this.getEgress()));
                }
                if (this.getPortRange() != null) {
                    data.set("portRange", om.valueToTree(this.getPortRange()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getRuleAction() != null) {
                    data.set("ruleAction", om.valueToTree(this.getRuleAction()));
                }
                if (this.getRuleNumber() != null) {
                    data.set("ruleNumber", om.valueToTree(this.getRuleNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisAclRuleProperty.Jsii$Proxy that = (AnalysisAclRuleProperty.Jsii$Proxy) o;

                if (this.cidr != null ? !this.cidr.equals(that.cidr) : that.cidr != null) return false;
                if (this.egress != null ? !this.egress.equals(that.egress) : that.egress != null) return false;
                if (this.portRange != null ? !this.portRange.equals(that.portRange) : that.portRange != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                if (this.ruleAction != null ? !this.ruleAction.equals(that.ruleAction) : that.ruleAction != null) return false;
                return this.ruleNumber != null ? this.ruleNumber.equals(that.ruleNumber) : that.ruleNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cidr != null ? this.cidr.hashCode() : 0;
                result = 31 * result + (this.egress != null ? this.egress.hashCode() : 0);
                result = 31 * result + (this.portRange != null ? this.portRange.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.ruleAction != null ? this.ruleAction.hashCode() : 0);
                result = 31 * result + (this.ruleNumber != null ? this.ruleNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a path component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AnalysisComponentProperty analysisComponentProperty = AnalysisComponentProperty.builder()
     *         .arn("arn")
     *         .id("id")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisComponentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisComponentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html#cfn-ec2-networkinsightsanalysis-analysiscomponent-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html#cfn-ec2-networkinsightsanalysis-analysiscomponent-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * The ID of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html#cfn-ec2-networkinsightsanalysis-analysiscomponent-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html#cfn-ec2-networkinsightsanalysis-analysiscomponent-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisComponentProperty> {
            java.lang.String arn;
            java.lang.String id;

            /**
             * Sets the value of {@link AnalysisComponentProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisComponentProperty#getId}
             * @param id The ID of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisComponentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisComponentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisComponentProperty {
            private final java.lang.String arn;
            private final java.lang.String id;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.id = builder.id;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisComponentProperty.Jsii$Proxy that = (AnalysisComponentProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                return this.id != null ? this.id.equals(that.id) : that.id == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a load balancer listener.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AnalysisLoadBalancerListenerProperty analysisLoadBalancerListenerProperty = AnalysisLoadBalancerListenerProperty.builder()
     *         .instancePort(123)
     *         .loadBalancerPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisLoadBalancerListenerProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisLoadBalancerListenerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisLoadBalancerListenerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * [Classic Load Balancers] The back-end port for the listener.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancerlistener-instanceport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancerlistener-instanceport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstancePort() {
            return null;
        }

        /**
         * The port on which the load balancer is listening.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancerlistener-loadbalancerport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancerlistener-loadbalancerport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoadBalancerPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisLoadBalancerListenerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisLoadBalancerListenerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisLoadBalancerListenerProperty> {
            java.lang.Number instancePort;
            java.lang.Number loadBalancerPort;

            /**
             * Sets the value of {@link AnalysisLoadBalancerListenerProperty#getInstancePort}
             * @param instancePort [Classic Load Balancers] The back-end port for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancePort(java.lang.Number instancePort) {
                this.instancePort = instancePort;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisLoadBalancerListenerProperty#getLoadBalancerPort}
             * @param loadBalancerPort The port on which the load balancer is listening.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerPort(java.lang.Number loadBalancerPort) {
                this.loadBalancerPort = loadBalancerPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisLoadBalancerListenerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisLoadBalancerListenerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisLoadBalancerListenerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisLoadBalancerListenerProperty {
            private final java.lang.Number instancePort;
            private final java.lang.Number loadBalancerPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instancePort = software.amazon.jsii.Kernel.get(this, "instancePort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.loadBalancerPort = software.amazon.jsii.Kernel.get(this, "loadBalancerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instancePort = builder.instancePort;
                this.loadBalancerPort = builder.loadBalancerPort;
            }

            @Override
            public final java.lang.Number getInstancePort() {
                return this.instancePort;
            }

            @Override
            public final java.lang.Number getLoadBalancerPort() {
                return this.loadBalancerPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstancePort() != null) {
                    data.set("instancePort", om.valueToTree(this.getInstancePort()));
                }
                if (this.getLoadBalancerPort() != null) {
                    data.set("loadBalancerPort", om.valueToTree(this.getLoadBalancerPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisLoadBalancerListenerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisLoadBalancerListenerProperty.Jsii$Proxy that = (AnalysisLoadBalancerListenerProperty.Jsii$Proxy) o;

                if (this.instancePort != null ? !this.instancePort.equals(that.instancePort) : that.instancePort != null) return false;
                return this.loadBalancerPort != null ? this.loadBalancerPort.equals(that.loadBalancerPort) : that.loadBalancerPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instancePort != null ? this.instancePort.hashCode() : 0;
                result = 31 * result + (this.loadBalancerPort != null ? this.loadBalancerPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a load balancer target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AnalysisLoadBalancerTargetProperty analysisLoadBalancerTargetProperty = AnalysisLoadBalancerTargetProperty.builder()
     *         .address("address")
     *         .availabilityZone("availabilityZone")
     *         .instance(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisLoadBalancerTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisLoadBalancerTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IP address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-address</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
            return null;
        }

        /**
         * The Availability Zone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-availabilityzone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * Information about the instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-instance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-instance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstance() {
            return null;
        }

        /**
         * The port on which the target is listening.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisLoadBalancerTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisLoadBalancerTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisLoadBalancerTargetProperty> {
            java.lang.String address;
            java.lang.String availabilityZone;
            java.lang.Object instance;
            java.lang.Number port;

            /**
             * Sets the value of {@link AnalysisLoadBalancerTargetProperty#getAddress}
             * @param address The IP address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisLoadBalancerTargetProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisLoadBalancerTargetProperty#getInstance}
             * @param instance Information about the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instance(software.amazon.awscdk.IResolvable instance) {
                this.instance = instance;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisLoadBalancerTargetProperty#getInstance}
             * @param instance Information about the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instance(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty instance) {
                this.instance = instance;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisLoadBalancerTargetProperty#getPort}
             * @param port The port on which the target is listening.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisLoadBalancerTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisLoadBalancerTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisLoadBalancerTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisLoadBalancerTargetProperty {
            private final java.lang.String address;
            private final java.lang.String availabilityZone;
            private final java.lang.Object instance;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instance = software.amazon.jsii.Kernel.get(this, "instance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = builder.address;
                this.availabilityZone = builder.availabilityZone;
                this.instance = builder.instance;
                this.port = builder.port;
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.Object getInstance() {
                return this.instance;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }
                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getInstance() != null) {
                    data.set("instance", om.valueToTree(this.getInstance()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisLoadBalancerTargetProperty.Jsii$Proxy that = (AnalysisLoadBalancerTargetProperty.Jsii$Proxy) o;

                if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.instance != null ? !this.instance.equals(that.instance) : that.instance != null) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.address != null ? this.address.hashCode() : 0;
                result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
                result = 31 * result + (this.instance != null ? this.instance.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a header.
     * <p>
     * Reflects any changes made by a component as traffic passes through. The fields of an inbound header are null except for the first component of a path.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AnalysisPacketHeaderProperty analysisPacketHeaderProperty = AnalysisPacketHeaderProperty.builder()
     *         .destinationAddresses(List.of("destinationAddresses"))
     *         .destinationPortRanges(List.of(PortRangeProperty.builder()
     *                 .from(123)
     *                 .to(123)
     *                 .build()))
     *         .protocol("protocol")
     *         .sourceAddresses(List.of("sourceAddresses"))
     *         .sourcePortRanges(List.of(PortRangeProperty.builder()
     *                 .from(123)
     *                 .to(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisPacketHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisPacketHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination addresses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-destinationaddresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-destinationaddresses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDestinationAddresses() {
            return null;
        }

        /**
         * The destination port ranges.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-destinationportranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-destinationportranges</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationPortRanges() {
            return null;
        }

        /**
         * The protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * The source addresses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-sourceaddresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-sourceaddresses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceAddresses() {
            return null;
        }

        /**
         * The source port ranges.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-sourceportranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-sourceportranges</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourcePortRanges() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisPacketHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisPacketHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisPacketHeaderProperty> {
            java.util.List<java.lang.String> destinationAddresses;
            java.lang.Object destinationPortRanges;
            java.lang.String protocol;
            java.util.List<java.lang.String> sourceAddresses;
            java.lang.Object sourcePortRanges;

            /**
             * Sets the value of {@link AnalysisPacketHeaderProperty#getDestinationAddresses}
             * @param destinationAddresses The destination addresses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationAddresses(java.util.List<java.lang.String> destinationAddresses) {
                this.destinationAddresses = destinationAddresses;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisPacketHeaderProperty#getDestinationPortRanges}
             * @param destinationPortRanges The destination port ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPortRanges(software.amazon.awscdk.IResolvable destinationPortRanges) {
                this.destinationPortRanges = destinationPortRanges;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisPacketHeaderProperty#getDestinationPortRanges}
             * @param destinationPortRanges The destination port ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPortRanges(java.util.List<? extends java.lang.Object> destinationPortRanges) {
                this.destinationPortRanges = destinationPortRanges;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisPacketHeaderProperty#getProtocol}
             * @param protocol The protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisPacketHeaderProperty#getSourceAddresses}
             * @param sourceAddresses The source addresses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceAddresses(java.util.List<java.lang.String> sourceAddresses) {
                this.sourceAddresses = sourceAddresses;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisPacketHeaderProperty#getSourcePortRanges}
             * @param sourcePortRanges The source port ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePortRanges(software.amazon.awscdk.IResolvable sourcePortRanges) {
                this.sourcePortRanges = sourcePortRanges;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisPacketHeaderProperty#getSourcePortRanges}
             * @param sourcePortRanges The source port ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePortRanges(java.util.List<? extends java.lang.Object> sourcePortRanges) {
                this.sourcePortRanges = sourcePortRanges;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisPacketHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisPacketHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisPacketHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisPacketHeaderProperty {
            private final java.util.List<java.lang.String> destinationAddresses;
            private final java.lang.Object destinationPortRanges;
            private final java.lang.String protocol;
            private final java.util.List<java.lang.String> sourceAddresses;
            private final java.lang.Object sourcePortRanges;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationAddresses = software.amazon.jsii.Kernel.get(this, "destinationAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.destinationPortRanges = software.amazon.jsii.Kernel.get(this, "destinationPortRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceAddresses = software.amazon.jsii.Kernel.get(this, "sourceAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourcePortRanges = software.amazon.jsii.Kernel.get(this, "sourcePortRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationAddresses = builder.destinationAddresses;
                this.destinationPortRanges = builder.destinationPortRanges;
                this.protocol = builder.protocol;
                this.sourceAddresses = builder.sourceAddresses;
                this.sourcePortRanges = builder.sourcePortRanges;
            }

            @Override
            public final java.util.List<java.lang.String> getDestinationAddresses() {
                return this.destinationAddresses;
            }

            @Override
            public final java.lang.Object getDestinationPortRanges() {
                return this.destinationPortRanges;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.util.List<java.lang.String> getSourceAddresses() {
                return this.sourceAddresses;
            }

            @Override
            public final java.lang.Object getSourcePortRanges() {
                return this.sourcePortRanges;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationAddresses() != null) {
                    data.set("destinationAddresses", om.valueToTree(this.getDestinationAddresses()));
                }
                if (this.getDestinationPortRanges() != null) {
                    data.set("destinationPortRanges", om.valueToTree(this.getDestinationPortRanges()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getSourceAddresses() != null) {
                    data.set("sourceAddresses", om.valueToTree(this.getSourceAddresses()));
                }
                if (this.getSourcePortRanges() != null) {
                    data.set("sourcePortRanges", om.valueToTree(this.getSourcePortRanges()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisPacketHeaderProperty.Jsii$Proxy that = (AnalysisPacketHeaderProperty.Jsii$Proxy) o;

                if (this.destinationAddresses != null ? !this.destinationAddresses.equals(that.destinationAddresses) : that.destinationAddresses != null) return false;
                if (this.destinationPortRanges != null ? !this.destinationPortRanges.equals(that.destinationPortRanges) : that.destinationPortRanges != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                if (this.sourceAddresses != null ? !this.sourceAddresses.equals(that.sourceAddresses) : that.sourceAddresses != null) return false;
                return this.sourcePortRanges != null ? this.sourcePortRanges.equals(that.sourcePortRanges) : that.sourcePortRanges == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationAddresses != null ? this.destinationAddresses.hashCode() : 0;
                result = 31 * result + (this.destinationPortRanges != null ? this.destinationPortRanges.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.sourceAddresses != null ? this.sourceAddresses.hashCode() : 0);
                result = 31 * result + (this.sourcePortRanges != null ? this.sourcePortRanges.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a route table route.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AnalysisRouteTableRouteProperty analysisRouteTableRouteProperty = AnalysisRouteTableRouteProperty.builder()
     *         .destinationCidr("destinationCidr")
     *         .destinationPrefixListId("destinationPrefixListId")
     *         .egressOnlyInternetGatewayId("egressOnlyInternetGatewayId")
     *         .gatewayId("gatewayId")
     *         .instanceId("instanceId")
     *         .natGatewayId("natGatewayId")
     *         .networkInterfaceId("networkInterfaceId")
     *         .origin("origin")
     *         .state("state")
     *         .transitGatewayId("transitGatewayId")
     *         .vpcPeeringConnectionId("vpcPeeringConnectionId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisRouteTableRouteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisRouteTableRouteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination IPv4 address, in CIDR notation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-destinationcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-destinationcidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationCidr() {
            return null;
        }

        /**
         * The prefix of the AWS service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-destinationprefixlistid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-destinationprefixlistid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationPrefixListId() {
            return null;
        }

        /**
         * The ID of an egress-only internet gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-egressonlyinternetgatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-egressonlyinternetgatewayid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEgressOnlyInternetGatewayId() {
            return null;
        }

        /**
         * The ID of the gateway, such as an internet gateway or virtual private gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-gatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-gatewayid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGatewayId() {
            return null;
        }

        /**
         * The ID of the instance, such as a NAT instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-instanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-instanceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
            return null;
        }

        /**
         * The ID of a NAT gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-natgatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-natgatewayid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNatGatewayId() {
            return null;
        }

        /**
         * The ID of a network interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-networkinterfaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-networkinterfaceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceId() {
            return null;
        }

        /**
         * Describes how the route was created. The following are the possible values:.
         * <p>
         * <ul>
         * <li>CreateRouteTable - The route was automatically created when the route table was created.</li>
         * <li>CreateRoute - The route was manually added to the route table.</li>
         * <li>EnableVgwRoutePropagation - The route was propagated by route propagation.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-origin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-origin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrigin() {
            return null;
        }

        /**
         * The state. The following are the possible values:.
         * <p>
         * <ul>
         * <li>active</li>
         * <li>blackhole</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * The ID of a transit gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-transitgatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-transitgatewayid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
            return null;
        }

        /**
         * The ID of a VPC peering connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-vpcpeeringconnectionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-vpcpeeringconnectionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcPeeringConnectionId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisRouteTableRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisRouteTableRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisRouteTableRouteProperty> {
            java.lang.String destinationCidr;
            java.lang.String destinationPrefixListId;
            java.lang.String egressOnlyInternetGatewayId;
            java.lang.String gatewayId;
            java.lang.String instanceId;
            java.lang.String natGatewayId;
            java.lang.String networkInterfaceId;
            java.lang.String origin;
            java.lang.String state;
            java.lang.String transitGatewayId;
            java.lang.String vpcPeeringConnectionId;

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getDestinationCidr}
             * @param destinationCidr The destination IPv4 address, in CIDR notation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationCidr(java.lang.String destinationCidr) {
                this.destinationCidr = destinationCidr;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getDestinationPrefixListId}
             * @param destinationPrefixListId The prefix of the AWS service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPrefixListId(java.lang.String destinationPrefixListId) {
                this.destinationPrefixListId = destinationPrefixListId;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getEgressOnlyInternetGatewayId}
             * @param egressOnlyInternetGatewayId The ID of an egress-only internet gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder egressOnlyInternetGatewayId(java.lang.String egressOnlyInternetGatewayId) {
                this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getGatewayId}
             * @param gatewayId The ID of the gateway, such as an internet gateway or virtual private gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gatewayId(java.lang.String gatewayId) {
                this.gatewayId = gatewayId;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getInstanceId}
             * @param instanceId The ID of the instance, such as a NAT instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceId(java.lang.String instanceId) {
                this.instanceId = instanceId;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getNatGatewayId}
             * @param natGatewayId The ID of a NAT gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder natGatewayId(java.lang.String natGatewayId) {
                this.natGatewayId = natGatewayId;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getNetworkInterfaceId}
             * @param networkInterfaceId The ID of a network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getOrigin}
             * @param origin Describes how the route was created. The following are the possible values:.
             *               <ul>
             *               <li>CreateRouteTable - The route was automatically created when the route table was created.</li>
             *               <li>CreateRoute - The route was manually added to the route table.</li>
             *               <li>EnableVgwRoutePropagation - The route was propagated by route propagation.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder origin(java.lang.String origin) {
                this.origin = origin;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getState}
             * @param state The state. The following are the possible values:.
             *              <ul>
             *              <li>active</li>
             *              <li>blackhole</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getTransitGatewayId}
             * @param transitGatewayId The ID of a transit gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayId(java.lang.String transitGatewayId) {
                this.transitGatewayId = transitGatewayId;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisRouteTableRouteProperty#getVpcPeeringConnectionId}
             * @param vpcPeeringConnectionId The ID of a VPC peering connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcPeeringConnectionId(java.lang.String vpcPeeringConnectionId) {
                this.vpcPeeringConnectionId = vpcPeeringConnectionId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisRouteTableRouteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisRouteTableRouteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisRouteTableRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisRouteTableRouteProperty {
            private final java.lang.String destinationCidr;
            private final java.lang.String destinationPrefixListId;
            private final java.lang.String egressOnlyInternetGatewayId;
            private final java.lang.String gatewayId;
            private final java.lang.String instanceId;
            private final java.lang.String natGatewayId;
            private final java.lang.String networkInterfaceId;
            private final java.lang.String origin;
            private final java.lang.String state;
            private final java.lang.String transitGatewayId;
            private final java.lang.String vpcPeeringConnectionId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationCidr = software.amazon.jsii.Kernel.get(this, "destinationCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationPrefixListId = software.amazon.jsii.Kernel.get(this, "destinationPrefixListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.egressOnlyInternetGatewayId = software.amazon.jsii.Kernel.get(this, "egressOnlyInternetGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.gatewayId = software.amazon.jsii.Kernel.get(this, "gatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.natGatewayId = software.amazon.jsii.Kernel.get(this, "natGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.origin = software.amazon.jsii.Kernel.get(this, "origin", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitGatewayId = software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcPeeringConnectionId = software.amazon.jsii.Kernel.get(this, "vpcPeeringConnectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationCidr = builder.destinationCidr;
                this.destinationPrefixListId = builder.destinationPrefixListId;
                this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
                this.gatewayId = builder.gatewayId;
                this.instanceId = builder.instanceId;
                this.natGatewayId = builder.natGatewayId;
                this.networkInterfaceId = builder.networkInterfaceId;
                this.origin = builder.origin;
                this.state = builder.state;
                this.transitGatewayId = builder.transitGatewayId;
                this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
            }

            @Override
            public final java.lang.String getDestinationCidr() {
                return this.destinationCidr;
            }

            @Override
            public final java.lang.String getDestinationPrefixListId() {
                return this.destinationPrefixListId;
            }

            @Override
            public final java.lang.String getEgressOnlyInternetGatewayId() {
                return this.egressOnlyInternetGatewayId;
            }

            @Override
            public final java.lang.String getGatewayId() {
                return this.gatewayId;
            }

            @Override
            public final java.lang.String getInstanceId() {
                return this.instanceId;
            }

            @Override
            public final java.lang.String getNatGatewayId() {
                return this.natGatewayId;
            }

            @Override
            public final java.lang.String getNetworkInterfaceId() {
                return this.networkInterfaceId;
            }

            @Override
            public final java.lang.String getOrigin() {
                return this.origin;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.lang.String getTransitGatewayId() {
                return this.transitGatewayId;
            }

            @Override
            public final java.lang.String getVpcPeeringConnectionId() {
                return this.vpcPeeringConnectionId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationCidr() != null) {
                    data.set("destinationCidr", om.valueToTree(this.getDestinationCidr()));
                }
                if (this.getDestinationPrefixListId() != null) {
                    data.set("destinationPrefixListId", om.valueToTree(this.getDestinationPrefixListId()));
                }
                if (this.getEgressOnlyInternetGatewayId() != null) {
                    data.set("egressOnlyInternetGatewayId", om.valueToTree(this.getEgressOnlyInternetGatewayId()));
                }
                if (this.getGatewayId() != null) {
                    data.set("gatewayId", om.valueToTree(this.getGatewayId()));
                }
                if (this.getInstanceId() != null) {
                    data.set("instanceId", om.valueToTree(this.getInstanceId()));
                }
                if (this.getNatGatewayId() != null) {
                    data.set("natGatewayId", om.valueToTree(this.getNatGatewayId()));
                }
                if (this.getNetworkInterfaceId() != null) {
                    data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                }
                if (this.getOrigin() != null) {
                    data.set("origin", om.valueToTree(this.getOrigin()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }
                if (this.getTransitGatewayId() != null) {
                    data.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));
                }
                if (this.getVpcPeeringConnectionId() != null) {
                    data.set("vpcPeeringConnectionId", om.valueToTree(this.getVpcPeeringConnectionId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisRouteTableRouteProperty.Jsii$Proxy that = (AnalysisRouteTableRouteProperty.Jsii$Proxy) o;

                if (this.destinationCidr != null ? !this.destinationCidr.equals(that.destinationCidr) : that.destinationCidr != null) return false;
                if (this.destinationPrefixListId != null ? !this.destinationPrefixListId.equals(that.destinationPrefixListId) : that.destinationPrefixListId != null) return false;
                if (this.egressOnlyInternetGatewayId != null ? !this.egressOnlyInternetGatewayId.equals(that.egressOnlyInternetGatewayId) : that.egressOnlyInternetGatewayId != null) return false;
                if (this.gatewayId != null ? !this.gatewayId.equals(that.gatewayId) : that.gatewayId != null) return false;
                if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) return false;
                if (this.natGatewayId != null ? !this.natGatewayId.equals(that.natGatewayId) : that.natGatewayId != null) return false;
                if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
                if (this.origin != null ? !this.origin.equals(that.origin) : that.origin != null) return false;
                if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
                if (this.transitGatewayId != null ? !this.transitGatewayId.equals(that.transitGatewayId) : that.transitGatewayId != null) return false;
                return this.vpcPeeringConnectionId != null ? this.vpcPeeringConnectionId.equals(that.vpcPeeringConnectionId) : that.vpcPeeringConnectionId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationCidr != null ? this.destinationCidr.hashCode() : 0;
                result = 31 * result + (this.destinationPrefixListId != null ? this.destinationPrefixListId.hashCode() : 0);
                result = 31 * result + (this.egressOnlyInternetGatewayId != null ? this.egressOnlyInternetGatewayId.hashCode() : 0);
                result = 31 * result + (this.gatewayId != null ? this.gatewayId.hashCode() : 0);
                result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
                result = 31 * result + (this.natGatewayId != null ? this.natGatewayId.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
                result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                result = 31 * result + (this.transitGatewayId != null ? this.transitGatewayId.hashCode() : 0);
                result = 31 * result + (this.vpcPeeringConnectionId != null ? this.vpcPeeringConnectionId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a security group rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AnalysisSecurityGroupRuleProperty analysisSecurityGroupRuleProperty = AnalysisSecurityGroupRuleProperty.builder()
     *         .cidr("cidr")
     *         .direction("direction")
     *         .portRange(PortRangeProperty.builder()
     *                 .from(123)
     *                 .to(123)
     *                 .build())
     *         .prefixListId("prefixListId")
     *         .protocol("protocol")
     *         .securityGroupId("securityGroupId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalysisSecurityGroupRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalysisSecurityGroupRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IPv4 address range, in CIDR notation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-cidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-cidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidr() {
            return null;
        }

        /**
         * The direction. The following are the possible values:.
         * <p>
         * <ul>
         * <li>egress</li>
         * <li>ingress</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-direction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-direction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDirection() {
            return null;
        }

        /**
         * The port range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-portrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-portrange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPortRange() {
            return null;
        }

        /**
         * The prefix list ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-prefixlistid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-prefixlistid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefixListId() {
            return null;
        }

        /**
         * The protocol name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * The security group ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-securitygroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-securitygroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityGroupId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalysisSecurityGroupRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalysisSecurityGroupRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalysisSecurityGroupRuleProperty> {
            java.lang.String cidr;
            java.lang.String direction;
            java.lang.Object portRange;
            java.lang.String prefixListId;
            java.lang.String protocol;
            java.lang.String securityGroupId;

            /**
             * Sets the value of {@link AnalysisSecurityGroupRuleProperty#getCidr}
             * @param cidr The IPv4 address range, in CIDR notation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidr(java.lang.String cidr) {
                this.cidr = cidr;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSecurityGroupRuleProperty#getDirection}
             * @param direction The direction. The following are the possible values:.
             *                  <ul>
             *                  <li>egress</li>
             *                  <li>ingress</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder direction(java.lang.String direction) {
                this.direction = direction;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSecurityGroupRuleProperty#getPortRange}
             * @param portRange The port range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portRange(software.amazon.awscdk.IResolvable portRange) {
                this.portRange = portRange;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSecurityGroupRuleProperty#getPortRange}
             * @param portRange The port range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portRange(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.PortRangeProperty portRange) {
                this.portRange = portRange;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSecurityGroupRuleProperty#getPrefixListId}
             * @param prefixListId The prefix list ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixListId(java.lang.String prefixListId) {
                this.prefixListId = prefixListId;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSecurityGroupRuleProperty#getProtocol}
             * @param protocol The protocol name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link AnalysisSecurityGroupRuleProperty#getSecurityGroupId}
             * @param securityGroupId The security group ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupId(java.lang.String securityGroupId) {
                this.securityGroupId = securityGroupId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalysisSecurityGroupRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalysisSecurityGroupRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnalysisSecurityGroupRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisSecurityGroupRuleProperty {
            private final java.lang.String cidr;
            private final java.lang.String direction;
            private final java.lang.Object portRange;
            private final java.lang.String prefixListId;
            private final java.lang.String protocol;
            private final java.lang.String securityGroupId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.direction = software.amazon.jsii.Kernel.get(this, "direction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.portRange = software.amazon.jsii.Kernel.get(this, "portRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefixListId = software.amazon.jsii.Kernel.get(this, "prefixListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroupId = software.amazon.jsii.Kernel.get(this, "securityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cidr = builder.cidr;
                this.direction = builder.direction;
                this.portRange = builder.portRange;
                this.prefixListId = builder.prefixListId;
                this.protocol = builder.protocol;
                this.securityGroupId = builder.securityGroupId;
            }

            @Override
            public final java.lang.String getCidr() {
                return this.cidr;
            }

            @Override
            public final java.lang.String getDirection() {
                return this.direction;
            }

            @Override
            public final java.lang.Object getPortRange() {
                return this.portRange;
            }

            @Override
            public final java.lang.String getPrefixListId() {
                return this.prefixListId;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.String getSecurityGroupId() {
                return this.securityGroupId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCidr() != null) {
                    data.set("cidr", om.valueToTree(this.getCidr()));
                }
                if (this.getDirection() != null) {
                    data.set("direction", om.valueToTree(this.getDirection()));
                }
                if (this.getPortRange() != null) {
                    data.set("portRange", om.valueToTree(this.getPortRange()));
                }
                if (this.getPrefixListId() != null) {
                    data.set("prefixListId", om.valueToTree(this.getPrefixListId()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getSecurityGroupId() != null) {
                    data.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalysisSecurityGroupRuleProperty.Jsii$Proxy that = (AnalysisSecurityGroupRuleProperty.Jsii$Proxy) o;

                if (this.cidr != null ? !this.cidr.equals(that.cidr) : that.cidr != null) return false;
                if (this.direction != null ? !this.direction.equals(that.direction) : that.direction != null) return false;
                if (this.portRange != null ? !this.portRange.equals(that.portRange) : that.portRange != null) return false;
                if (this.prefixListId != null ? !this.prefixListId.equals(that.prefixListId) : that.prefixListId != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                return this.securityGroupId != null ? this.securityGroupId.equals(that.securityGroupId) : that.securityGroupId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cidr != null ? this.cidr.hashCode() : 0;
                result = 31 * result + (this.direction != null ? this.direction.hashCode() : 0);
                result = 31 * result + (this.portRange != null ? this.portRange.hashCode() : 0);
                result = 31 * result + (this.prefixListId != null ? this.prefixListId.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.securityGroupId != null ? this.securityGroupId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an explanation code for an unreachable path.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ExplanationProperty explanationProperty = ExplanationProperty.builder()
     *         .acl(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .aclRule(AnalysisAclRuleProperty.builder()
     *                 .cidr("cidr")
     *                 .egress(false)
     *                 .portRange(PortRangeProperty.builder()
     *                         .from(123)
     *                         .to(123)
     *                         .build())
     *                 .protocol("protocol")
     *                 .ruleAction("ruleAction")
     *                 .ruleNumber(123)
     *                 .build())
     *         .address("address")
     *         .addresses(List.of("addresses"))
     *         .attachedTo(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .availabilityZones(List.of("availabilityZones"))
     *         .cidrs(List.of("cidrs"))
     *         .classicLoadBalancerListener(AnalysisLoadBalancerListenerProperty.builder()
     *                 .instancePort(123)
     *                 .loadBalancerPort(123)
     *                 .build())
     *         .component(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .componentAccount("componentAccount")
     *         .componentRegion("componentRegion")
     *         .customerGateway(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .destination(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .destinationVpc(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .direction("direction")
     *         .elasticLoadBalancerListener(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .explanationCode("explanationCode")
     *         .ingressRouteTable(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .internetGateway(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .loadBalancerArn("loadBalancerArn")
     *         .loadBalancerListenerPort(123)
     *         .loadBalancerTarget(AnalysisLoadBalancerTargetProperty.builder()
     *                 .address("address")
     *                 .availabilityZone("availabilityZone")
     *                 .instance(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .port(123)
     *                 .build())
     *         .loadBalancerTargetGroup(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .loadBalancerTargetGroups(List.of(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build()))
     *         .loadBalancerTargetPort(123)
     *         .missingComponent("missingComponent")
     *         .natGateway(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .networkInterface(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .packetField("packetField")
     *         .port(123)
     *         .portRanges(List.of(PortRangeProperty.builder()
     *                 .from(123)
     *                 .to(123)
     *                 .build()))
     *         .prefixList(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .protocols(List.of("protocols"))
     *         .routeTable(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .routeTableRoute(AnalysisRouteTableRouteProperty.builder()
     *                 .destinationCidr("destinationCidr")
     *                 .destinationPrefixListId("destinationPrefixListId")
     *                 .egressOnlyInternetGatewayId("egressOnlyInternetGatewayId")
     *                 .gatewayId("gatewayId")
     *                 .instanceId("instanceId")
     *                 .natGatewayId("natGatewayId")
     *                 .networkInterfaceId("networkInterfaceId")
     *                 .origin("origin")
     *                 .state("state")
     *                 .transitGatewayId("transitGatewayId")
     *                 .vpcPeeringConnectionId("vpcPeeringConnectionId")
     *                 .build())
     *         .securityGroup(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .securityGroupRule(AnalysisSecurityGroupRuleProperty.builder()
     *                 .cidr("cidr")
     *                 .direction("direction")
     *                 .portRange(PortRangeProperty.builder()
     *                         .from(123)
     *                         .to(123)
     *                         .build())
     *                 .prefixListId("prefixListId")
     *                 .protocol("protocol")
     *                 .securityGroupId("securityGroupId")
     *                 .build())
     *         .securityGroups(List.of(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build()))
     *         .sourceVpc(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .state("state")
     *         .subnet(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .subnetRouteTable(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .transitGateway(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .transitGatewayAttachment(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .transitGatewayRouteTable(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .transitGatewayRouteTableRoute(TransitGatewayRouteTableRouteProperty.builder()
     *                 .attachmentId("attachmentId")
     *                 .destinationCidr("destinationCidr")
     *                 .prefixListId("prefixListId")
     *                 .resourceId("resourceId")
     *                 .resourceType("resourceType")
     *                 .routeOrigin("routeOrigin")
     *                 .state("state")
     *                 .build())
     *         .vpc(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .vpcEndpoint(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .vpcPeeringConnection(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .vpnConnection(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .vpnGateway(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.ExplanationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExplanationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExplanationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The network ACL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-acl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-acl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcl() {
            return null;
        }

        /**
         * The network ACL rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-aclrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-aclrule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAclRule() {
            return null;
        }

        /**
         * The IPv4 address, in CIDR notation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-address</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
            return null;
        }

        /**
         * The IPv4 addresses, in CIDR notation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-addresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-addresses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAddresses() {
            return null;
        }

        /**
         * The resource to which the component is attached.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-attachedto">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-attachedto</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttachedTo() {
            return null;
        }

        /**
         * The Availability Zones.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-availabilityzones">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-availabilityzones</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
            return null;
        }

        /**
         * The CIDR ranges.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-cidrs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-cidrs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCidrs() {
            return null;
        }

        /**
         * The listener for a Classic Load Balancer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-classicloadbalancerlistener">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-classicloadbalancerlistener</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClassicLoadBalancerListener() {
            return null;
        }

        /**
         * The component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-component">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-component</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComponent() {
            return null;
        }

        /**
         * The AWS account for the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-componentaccount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-componentaccount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentAccount() {
            return null;
        }

        /**
         * The Region for the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-componentregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-componentregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentRegion() {
            return null;
        }

        /**
         * The customer gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-customergateway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-customergateway</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerGateway() {
            return null;
        }

        /**
         * The destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestination() {
            return null;
        }

        /**
         * The destination VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-destinationvpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-destinationvpc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationVpc() {
            return null;
        }

        /**
         * The direction. The following are the possible values:.
         * <p>
         * <ul>
         * <li>egress</li>
         * <li>ingress</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-direction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-direction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDirection() {
            return null;
        }

        /**
         * The load balancer listener.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-elasticloadbalancerlistener">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-elasticloadbalancerlistener</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElasticLoadBalancerListener() {
            return null;
        }

        /**
         * The explanation code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-explanationcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-explanationcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExplanationCode() {
            return null;
        }

        /**
         * The route table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-ingressroutetable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-ingressroutetable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIngressRouteTable() {
            return null;
        }

        /**
         * The internet gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-internetgateway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-internetgateway</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInternetGateway() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the load balancer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancerarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerArn() {
            return null;
        }

        /**
         * The listener port of the load balancer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancerlistenerport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancerlistenerport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoadBalancerListenerPort() {
            return null;
        }

        /**
         * The target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertarget</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancerTarget() {
            return null;
        }

        /**
         * The target group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetgroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancerTargetGroup() {
            return null;
        }

        /**
         * The target groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetgroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancerTargetGroups() {
            return null;
        }

        /**
         * The target port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoadBalancerTargetPort() {
            return null;
        }

        /**
         * The missing component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-missingcomponent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-missingcomponent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMissingComponent() {
            return null;
        }

        /**
         * The NAT gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-natgateway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-natgateway</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNatGateway() {
            return null;
        }

        /**
         * The network interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-networkinterface">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-networkinterface</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterface() {
            return null;
        }

        /**
         * The packet field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-packetfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-packetfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPacketField() {
            return null;
        }

        /**
         * The port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * The port ranges.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-portranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-portranges</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPortRanges() {
            return null;
        }

        /**
         * The prefix list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-prefixlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-prefixlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrefixList() {
            return null;
        }

        /**
         * The protocols.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-protocols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-protocols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProtocols() {
            return null;
        }

        /**
         * The route table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-routetable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-routetable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRouteTable() {
            return null;
        }

        /**
         * The route table route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-routetableroute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-routetableroute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRouteTableRoute() {
            return null;
        }

        /**
         * The security group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroup() {
            return null;
        }

        /**
         * The security group rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygrouprule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygrouprule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroupRule() {
            return null;
        }

        /**
         * The security groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroups() {
            return null;
        }

        /**
         * The source VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-sourcevpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-sourcevpc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceVpc() {
            return null;
        }

        /**
         * The state.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * The subnet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-subnet">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-subnet</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubnet() {
            return null;
        }

        /**
         * The route table for the subnet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-subnetroutetable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-subnetroutetable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubnetRouteTable() {
            return null;
        }

        /**
         * The transit gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-transitgateway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-transitgateway</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitGateway() {
            return null;
        }

        /**
         * The transit gateway attachment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-transitgatewayattachment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-transitgatewayattachment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitGatewayAttachment() {
            return null;
        }

        /**
         * The transit gateway route table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-transitgatewayroutetable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-transitgatewayroutetable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitGatewayRouteTable() {
            return null;
        }

        /**
         * The transit gateway route table route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-transitgatewayroutetableroute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-transitgatewayroutetableroute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitGatewayRouteTableRoute() {
            return null;
        }

        /**
         * The component VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpc() {
            return null;
        }

        /**
         * The VPC endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpcendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpcendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcEndpoint() {
            return null;
        }

        /**
         * The VPC peering connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpcpeeringconnection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpcpeeringconnection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcPeeringConnection() {
            return null;
        }

        /**
         * The VPN connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpnconnection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpnconnection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpnConnection() {
            return null;
        }

        /**
         * The VPN gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpngateway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpngateway</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpnGateway() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExplanationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExplanationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExplanationProperty> {
            java.lang.Object acl;
            java.lang.Object aclRule;
            java.lang.String address;
            java.util.List<java.lang.String> addresses;
            java.lang.Object attachedTo;
            java.util.List<java.lang.String> availabilityZones;
            java.util.List<java.lang.String> cidrs;
            java.lang.Object classicLoadBalancerListener;
            java.lang.Object component;
            java.lang.String componentAccount;
            java.lang.String componentRegion;
            java.lang.Object customerGateway;
            java.lang.Object destination;
            java.lang.Object destinationVpc;
            java.lang.String direction;
            java.lang.Object elasticLoadBalancerListener;
            java.lang.String explanationCode;
            java.lang.Object ingressRouteTable;
            java.lang.Object internetGateway;
            java.lang.String loadBalancerArn;
            java.lang.Number loadBalancerListenerPort;
            java.lang.Object loadBalancerTarget;
            java.lang.Object loadBalancerTargetGroup;
            java.lang.Object loadBalancerTargetGroups;
            java.lang.Number loadBalancerTargetPort;
            java.lang.String missingComponent;
            java.lang.Object natGateway;
            java.lang.Object networkInterface;
            java.lang.String packetField;
            java.lang.Number port;
            java.lang.Object portRanges;
            java.lang.Object prefixList;
            java.util.List<java.lang.String> protocols;
            java.lang.Object routeTable;
            java.lang.Object routeTableRoute;
            java.lang.Object securityGroup;
            java.lang.Object securityGroupRule;
            java.lang.Object securityGroups;
            java.lang.Object sourceVpc;
            java.lang.String state;
            java.lang.Object subnet;
            java.lang.Object subnetRouteTable;
            java.lang.Object transitGateway;
            java.lang.Object transitGatewayAttachment;
            java.lang.Object transitGatewayRouteTable;
            java.lang.Object transitGatewayRouteTableRoute;
            java.lang.Object vpc;
            java.lang.Object vpcEndpoint;
            java.lang.Object vpcPeeringConnection;
            java.lang.Object vpnConnection;
            java.lang.Object vpnGateway;

            /**
             * Sets the value of {@link ExplanationProperty#getAcl}
             * @param acl The network ACL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acl(software.amazon.awscdk.IResolvable acl) {
                this.acl = acl;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getAcl}
             * @param acl The network ACL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acl(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty acl) {
                this.acl = acl;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getAclRule}
             * @param aclRule The network ACL rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclRule(software.amazon.awscdk.IResolvable aclRule) {
                this.aclRule = aclRule;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getAclRule}
             * @param aclRule The network ACL rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclRule(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty aclRule) {
                this.aclRule = aclRule;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getAddress}
             * @param address The IPv4 address, in CIDR notation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getAddresses}
             * @param addresses The IPv4 addresses, in CIDR notation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addresses(java.util.List<java.lang.String> addresses) {
                this.addresses = addresses;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getAttachedTo}
             * @param attachedTo The resource to which the component is attached.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachedTo(software.amazon.awscdk.IResolvable attachedTo) {
                this.attachedTo = attachedTo;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getAttachedTo}
             * @param attachedTo The resource to which the component is attached.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachedTo(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty attachedTo) {
                this.attachedTo = attachedTo;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getAvailabilityZones}
             * @param availabilityZones The Availability Zones.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
                this.availabilityZones = availabilityZones;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getCidrs}
             * @param cidrs The CIDR ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidrs(java.util.List<java.lang.String> cidrs) {
                this.cidrs = cidrs;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getClassicLoadBalancerListener}
             * @param classicLoadBalancerListener The listener for a Classic Load Balancer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classicLoadBalancerListener(software.amazon.awscdk.IResolvable classicLoadBalancerListener) {
                this.classicLoadBalancerListener = classicLoadBalancerListener;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getClassicLoadBalancerListener}
             * @param classicLoadBalancerListener The listener for a Classic Load Balancer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classicLoadBalancerListener(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisLoadBalancerListenerProperty classicLoadBalancerListener) {
                this.classicLoadBalancerListener = classicLoadBalancerListener;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getComponent}
             * @param component The component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder component(software.amazon.awscdk.IResolvable component) {
                this.component = component;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getComponent}
             * @param component The component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder component(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty component) {
                this.component = component;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getComponentAccount}
             * @param componentAccount The AWS account for the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentAccount(java.lang.String componentAccount) {
                this.componentAccount = componentAccount;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getComponentRegion}
             * @param componentRegion The Region for the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentRegion(java.lang.String componentRegion) {
                this.componentRegion = componentRegion;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getCustomerGateway}
             * @param customerGateway The customer gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerGateway(software.amazon.awscdk.IResolvable customerGateway) {
                this.customerGateway = customerGateway;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getCustomerGateway}
             * @param customerGateway The customer gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerGateway(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty customerGateway) {
                this.customerGateway = customerGateway;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getDestination}
             * @param destination The destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getDestination}
             * @param destination The destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getDestinationVpc}
             * @param destinationVpc The destination VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationVpc(software.amazon.awscdk.IResolvable destinationVpc) {
                this.destinationVpc = destinationVpc;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getDestinationVpc}
             * @param destinationVpc The destination VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationVpc(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty destinationVpc) {
                this.destinationVpc = destinationVpc;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getDirection}
             * @param direction The direction. The following are the possible values:.
             *                  <ul>
             *                  <li>egress</li>
             *                  <li>ingress</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder direction(java.lang.String direction) {
                this.direction = direction;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getElasticLoadBalancerListener}
             * @param elasticLoadBalancerListener The load balancer listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticLoadBalancerListener(software.amazon.awscdk.IResolvable elasticLoadBalancerListener) {
                this.elasticLoadBalancerListener = elasticLoadBalancerListener;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getElasticLoadBalancerListener}
             * @param elasticLoadBalancerListener The load balancer listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticLoadBalancerListener(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty elasticLoadBalancerListener) {
                this.elasticLoadBalancerListener = elasticLoadBalancerListener;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getExplanationCode}
             * @param explanationCode The explanation code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explanationCode(java.lang.String explanationCode) {
                this.explanationCode = explanationCode;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getIngressRouteTable}
             * @param ingressRouteTable The route table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingressRouteTable(software.amazon.awscdk.IResolvable ingressRouteTable) {
                this.ingressRouteTable = ingressRouteTable;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getIngressRouteTable}
             * @param ingressRouteTable The route table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingressRouteTable(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty ingressRouteTable) {
                this.ingressRouteTable = ingressRouteTable;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getInternetGateway}
             * @param internetGateway The internet gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder internetGateway(software.amazon.awscdk.IResolvable internetGateway) {
                this.internetGateway = internetGateway;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getInternetGateway}
             * @param internetGateway The internet gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder internetGateway(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty internetGateway) {
                this.internetGateway = internetGateway;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getLoadBalancerArn}
             * @param loadBalancerArn The Amazon Resource Name (ARN) of the load balancer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
                this.loadBalancerArn = loadBalancerArn;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getLoadBalancerListenerPort}
             * @param loadBalancerListenerPort The listener port of the load balancer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerListenerPort(java.lang.Number loadBalancerListenerPort) {
                this.loadBalancerListenerPort = loadBalancerListenerPort;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getLoadBalancerTarget}
             * @param loadBalancerTarget The target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerTarget(software.amazon.awscdk.IResolvable loadBalancerTarget) {
                this.loadBalancerTarget = loadBalancerTarget;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getLoadBalancerTarget}
             * @param loadBalancerTarget The target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerTarget(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty loadBalancerTarget) {
                this.loadBalancerTarget = loadBalancerTarget;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getLoadBalancerTargetGroup}
             * @param loadBalancerTargetGroup The target group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerTargetGroup(software.amazon.awscdk.IResolvable loadBalancerTargetGroup) {
                this.loadBalancerTargetGroup = loadBalancerTargetGroup;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getLoadBalancerTargetGroup}
             * @param loadBalancerTargetGroup The target group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerTargetGroup(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty loadBalancerTargetGroup) {
                this.loadBalancerTargetGroup = loadBalancerTargetGroup;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getLoadBalancerTargetGroups}
             * @param loadBalancerTargetGroups The target groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerTargetGroups(software.amazon.awscdk.IResolvable loadBalancerTargetGroups) {
                this.loadBalancerTargetGroups = loadBalancerTargetGroups;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getLoadBalancerTargetGroups}
             * @param loadBalancerTargetGroups The target groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerTargetGroups(java.util.List<? extends java.lang.Object> loadBalancerTargetGroups) {
                this.loadBalancerTargetGroups = loadBalancerTargetGroups;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getLoadBalancerTargetPort}
             * @param loadBalancerTargetPort The target port.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerTargetPort(java.lang.Number loadBalancerTargetPort) {
                this.loadBalancerTargetPort = loadBalancerTargetPort;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getMissingComponent}
             * @param missingComponent The missing component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder missingComponent(java.lang.String missingComponent) {
                this.missingComponent = missingComponent;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getNatGateway}
             * @param natGateway The NAT gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder natGateway(software.amazon.awscdk.IResolvable natGateway) {
                this.natGateway = natGateway;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getNatGateway}
             * @param natGateway The NAT gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder natGateway(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty natGateway) {
                this.natGateway = natGateway;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getNetworkInterface}
             * @param networkInterface The network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterface(software.amazon.awscdk.IResolvable networkInterface) {
                this.networkInterface = networkInterface;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getNetworkInterface}
             * @param networkInterface The network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterface(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty networkInterface) {
                this.networkInterface = networkInterface;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getPacketField}
             * @param packetField The packet field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder packetField(java.lang.String packetField) {
                this.packetField = packetField;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getPort}
             * @param port The port.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getPortRanges}
             * @param portRanges The port ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portRanges(software.amazon.awscdk.IResolvable portRanges) {
                this.portRanges = portRanges;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getPortRanges}
             * @param portRanges The port ranges.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portRanges(java.util.List<? extends java.lang.Object> portRanges) {
                this.portRanges = portRanges;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getPrefixList}
             * @param prefixList The prefix list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixList(software.amazon.awscdk.IResolvable prefixList) {
                this.prefixList = prefixList;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getPrefixList}
             * @param prefixList The prefix list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixList(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty prefixList) {
                this.prefixList = prefixList;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getProtocols}
             * @param protocols The protocols.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocols(java.util.List<java.lang.String> protocols) {
                this.protocols = protocols;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getRouteTable}
             * @param routeTable The route table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeTable(software.amazon.awscdk.IResolvable routeTable) {
                this.routeTable = routeTable;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getRouteTable}
             * @param routeTable The route table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeTable(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty routeTable) {
                this.routeTable = routeTable;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getRouteTableRoute}
             * @param routeTableRoute The route table route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeTableRoute(software.amazon.awscdk.IResolvable routeTableRoute) {
                this.routeTableRoute = routeTableRoute;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getRouteTableRoute}
             * @param routeTableRoute The route table route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeTableRoute(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty routeTableRoute) {
                this.routeTableRoute = routeTableRoute;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSecurityGroup}
             * @param securityGroup The security group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroup(software.amazon.awscdk.IResolvable securityGroup) {
                this.securityGroup = securityGroup;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSecurityGroup}
             * @param securityGroup The security group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroup(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty securityGroup) {
                this.securityGroup = securityGroup;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSecurityGroupRule}
             * @param securityGroupRule The security group rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupRule(software.amazon.awscdk.IResolvable securityGroupRule) {
                this.securityGroupRule = securityGroupRule;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSecurityGroupRule}
             * @param securityGroupRule The security group rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupRule(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty securityGroupRule) {
                this.securityGroupRule = securityGroupRule;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSecurityGroups}
             * @param securityGroups The security groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(software.amazon.awscdk.IResolvable securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSecurityGroups}
             * @param securityGroups The security groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<? extends java.lang.Object> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSourceVpc}
             * @param sourceVpc The source VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVpc(software.amazon.awscdk.IResolvable sourceVpc) {
                this.sourceVpc = sourceVpc;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSourceVpc}
             * @param sourceVpc The source VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVpc(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty sourceVpc) {
                this.sourceVpc = sourceVpc;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getState}
             * @param state The state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSubnet}
             * @param subnet The subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnet(software.amazon.awscdk.IResolvable subnet) {
                this.subnet = subnet;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSubnet}
             * @param subnet The subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnet(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty subnet) {
                this.subnet = subnet;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSubnetRouteTable}
             * @param subnetRouteTable The route table for the subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetRouteTable(software.amazon.awscdk.IResolvable subnetRouteTable) {
                this.subnetRouteTable = subnetRouteTable;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getSubnetRouteTable}
             * @param subnetRouteTable The route table for the subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetRouteTable(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty subnetRouteTable) {
                this.subnetRouteTable = subnetRouteTable;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getTransitGateway}
             * @param transitGateway The transit gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGateway(software.amazon.awscdk.IResolvable transitGateway) {
                this.transitGateway = transitGateway;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getTransitGateway}
             * @param transitGateway The transit gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGateway(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty transitGateway) {
                this.transitGateway = transitGateway;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getTransitGatewayAttachment}
             * @param transitGatewayAttachment The transit gateway attachment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayAttachment(software.amazon.awscdk.IResolvable transitGatewayAttachment) {
                this.transitGatewayAttachment = transitGatewayAttachment;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getTransitGatewayAttachment}
             * @param transitGatewayAttachment The transit gateway attachment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayAttachment(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty transitGatewayAttachment) {
                this.transitGatewayAttachment = transitGatewayAttachment;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getTransitGatewayRouteTable}
             * @param transitGatewayRouteTable The transit gateway route table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayRouteTable(software.amazon.awscdk.IResolvable transitGatewayRouteTable) {
                this.transitGatewayRouteTable = transitGatewayRouteTable;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getTransitGatewayRouteTable}
             * @param transitGatewayRouteTable The transit gateway route table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayRouteTable(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty transitGatewayRouteTable) {
                this.transitGatewayRouteTable = transitGatewayRouteTable;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getTransitGatewayRouteTableRoute}
             * @param transitGatewayRouteTableRoute The transit gateway route table route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayRouteTableRoute(software.amazon.awscdk.IResolvable transitGatewayRouteTableRoute) {
                this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getTransitGatewayRouteTableRoute}
             * @param transitGatewayRouteTableRoute The transit gateway route table route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayRouteTableRoute(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.TransitGatewayRouteTableRouteProperty transitGatewayRouteTableRoute) {
                this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getVpc}
             * @param vpc The component VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpc(software.amazon.awscdk.IResolvable vpc) {
                this.vpc = vpc;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getVpc}
             * @param vpc The component VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpc(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty vpc) {
                this.vpc = vpc;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getVpcEndpoint}
             * @param vpcEndpoint The VPC endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpoint(software.amazon.awscdk.IResolvable vpcEndpoint) {
                this.vpcEndpoint = vpcEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getVpcEndpoint}
             * @param vpcEndpoint The VPC endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpoint(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty vpcEndpoint) {
                this.vpcEndpoint = vpcEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getVpcPeeringConnection}
             * @param vpcPeeringConnection The VPC peering connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcPeeringConnection(software.amazon.awscdk.IResolvable vpcPeeringConnection) {
                this.vpcPeeringConnection = vpcPeeringConnection;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getVpcPeeringConnection}
             * @param vpcPeeringConnection The VPC peering connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcPeeringConnection(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty vpcPeeringConnection) {
                this.vpcPeeringConnection = vpcPeeringConnection;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getVpnConnection}
             * @param vpnConnection The VPN connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpnConnection(software.amazon.awscdk.IResolvable vpnConnection) {
                this.vpnConnection = vpnConnection;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getVpnConnection}
             * @param vpnConnection The VPN connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpnConnection(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty vpnConnection) {
                this.vpnConnection = vpnConnection;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getVpnGateway}
             * @param vpnGateway The VPN gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpnGateway(software.amazon.awscdk.IResolvable vpnGateway) {
                this.vpnGateway = vpnGateway;
                return this;
            }

            /**
             * Sets the value of {@link ExplanationProperty#getVpnGateway}
             * @param vpnGateway The VPN gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpnGateway(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty vpnGateway) {
                this.vpnGateway = vpnGateway;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExplanationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExplanationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExplanationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExplanationProperty {
            private final java.lang.Object acl;
            private final java.lang.Object aclRule;
            private final java.lang.String address;
            private final java.util.List<java.lang.String> addresses;
            private final java.lang.Object attachedTo;
            private final java.util.List<java.lang.String> availabilityZones;
            private final java.util.List<java.lang.String> cidrs;
            private final java.lang.Object classicLoadBalancerListener;
            private final java.lang.Object component;
            private final java.lang.String componentAccount;
            private final java.lang.String componentRegion;
            private final java.lang.Object customerGateway;
            private final java.lang.Object destination;
            private final java.lang.Object destinationVpc;
            private final java.lang.String direction;
            private final java.lang.Object elasticLoadBalancerListener;
            private final java.lang.String explanationCode;
            private final java.lang.Object ingressRouteTable;
            private final java.lang.Object internetGateway;
            private final java.lang.String loadBalancerArn;
            private final java.lang.Number loadBalancerListenerPort;
            private final java.lang.Object loadBalancerTarget;
            private final java.lang.Object loadBalancerTargetGroup;
            private final java.lang.Object loadBalancerTargetGroups;
            private final java.lang.Number loadBalancerTargetPort;
            private final java.lang.String missingComponent;
            private final java.lang.Object natGateway;
            private final java.lang.Object networkInterface;
            private final java.lang.String packetField;
            private final java.lang.Number port;
            private final java.lang.Object portRanges;
            private final java.lang.Object prefixList;
            private final java.util.List<java.lang.String> protocols;
            private final java.lang.Object routeTable;
            private final java.lang.Object routeTableRoute;
            private final java.lang.Object securityGroup;
            private final java.lang.Object securityGroupRule;
            private final java.lang.Object securityGroups;
            private final java.lang.Object sourceVpc;
            private final java.lang.String state;
            private final java.lang.Object subnet;
            private final java.lang.Object subnetRouteTable;
            private final java.lang.Object transitGateway;
            private final java.lang.Object transitGatewayAttachment;
            private final java.lang.Object transitGatewayRouteTable;
            private final java.lang.Object transitGatewayRouteTableRoute;
            private final java.lang.Object vpc;
            private final java.lang.Object vpcEndpoint;
            private final java.lang.Object vpcPeeringConnection;
            private final java.lang.Object vpnConnection;
            private final java.lang.Object vpnGateway;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acl = software.amazon.jsii.Kernel.get(this, "acl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aclRule = software.amazon.jsii.Kernel.get(this, "aclRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.addresses = software.amazon.jsii.Kernel.get(this, "addresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.attachedTo = software.amazon.jsii.Kernel.get(this, "attachedTo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cidrs = software.amazon.jsii.Kernel.get(this, "cidrs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.classicLoadBalancerListener = software.amazon.jsii.Kernel.get(this, "classicLoadBalancerListener", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.component = software.amazon.jsii.Kernel.get(this, "component", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.componentAccount = software.amazon.jsii.Kernel.get(this, "componentAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.componentRegion = software.amazon.jsii.Kernel.get(this, "componentRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customerGateway = software.amazon.jsii.Kernel.get(this, "customerGateway", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationVpc = software.amazon.jsii.Kernel.get(this, "destinationVpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.direction = software.amazon.jsii.Kernel.get(this, "direction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.elasticLoadBalancerListener = software.amazon.jsii.Kernel.get(this, "elasticLoadBalancerListener", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.explanationCode = software.amazon.jsii.Kernel.get(this, "explanationCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ingressRouteTable = software.amazon.jsii.Kernel.get(this, "ingressRouteTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.internetGateway = software.amazon.jsii.Kernel.get(this, "internetGateway", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loadBalancerArn = software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.loadBalancerListenerPort = software.amazon.jsii.Kernel.get(this, "loadBalancerListenerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.loadBalancerTarget = software.amazon.jsii.Kernel.get(this, "loadBalancerTarget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loadBalancerTargetGroup = software.amazon.jsii.Kernel.get(this, "loadBalancerTargetGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loadBalancerTargetGroups = software.amazon.jsii.Kernel.get(this, "loadBalancerTargetGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loadBalancerTargetPort = software.amazon.jsii.Kernel.get(this, "loadBalancerTargetPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.missingComponent = software.amazon.jsii.Kernel.get(this, "missingComponent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.natGateway = software.amazon.jsii.Kernel.get(this, "natGateway", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterface = software.amazon.jsii.Kernel.get(this, "networkInterface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.packetField = software.amazon.jsii.Kernel.get(this, "packetField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.portRanges = software.amazon.jsii.Kernel.get(this, "portRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefixList = software.amazon.jsii.Kernel.get(this, "prefixList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.protocols = software.amazon.jsii.Kernel.get(this, "protocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.routeTable = software.amazon.jsii.Kernel.get(this, "routeTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.routeTableRoute = software.amazon.jsii.Kernel.get(this, "routeTableRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroupRule = software.amazon.jsii.Kernel.get(this, "securityGroupRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceVpc = software.amazon.jsii.Kernel.get(this, "sourceVpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subnet = software.amazon.jsii.Kernel.get(this, "subnet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subnetRouteTable = software.amazon.jsii.Kernel.get(this, "subnetRouteTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transitGateway = software.amazon.jsii.Kernel.get(this, "transitGateway", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transitGatewayAttachment = software.amazon.jsii.Kernel.get(this, "transitGatewayAttachment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transitGatewayRouteTable = software.amazon.jsii.Kernel.get(this, "transitGatewayRouteTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transitGatewayRouteTableRoute = software.amazon.jsii.Kernel.get(this, "transitGatewayRouteTableRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcEndpoint = software.amazon.jsii.Kernel.get(this, "vpcEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcPeeringConnection = software.amazon.jsii.Kernel.get(this, "vpcPeeringConnection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpnConnection = software.amazon.jsii.Kernel.get(this, "vpnConnection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpnGateway = software.amazon.jsii.Kernel.get(this, "vpnGateway", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acl = builder.acl;
                this.aclRule = builder.aclRule;
                this.address = builder.address;
                this.addresses = builder.addresses;
                this.attachedTo = builder.attachedTo;
                this.availabilityZones = builder.availabilityZones;
                this.cidrs = builder.cidrs;
                this.classicLoadBalancerListener = builder.classicLoadBalancerListener;
                this.component = builder.component;
                this.componentAccount = builder.componentAccount;
                this.componentRegion = builder.componentRegion;
                this.customerGateway = builder.customerGateway;
                this.destination = builder.destination;
                this.destinationVpc = builder.destinationVpc;
                this.direction = builder.direction;
                this.elasticLoadBalancerListener = builder.elasticLoadBalancerListener;
                this.explanationCode = builder.explanationCode;
                this.ingressRouteTable = builder.ingressRouteTable;
                this.internetGateway = builder.internetGateway;
                this.loadBalancerArn = builder.loadBalancerArn;
                this.loadBalancerListenerPort = builder.loadBalancerListenerPort;
                this.loadBalancerTarget = builder.loadBalancerTarget;
                this.loadBalancerTargetGroup = builder.loadBalancerTargetGroup;
                this.loadBalancerTargetGroups = builder.loadBalancerTargetGroups;
                this.loadBalancerTargetPort = builder.loadBalancerTargetPort;
                this.missingComponent = builder.missingComponent;
                this.natGateway = builder.natGateway;
                this.networkInterface = builder.networkInterface;
                this.packetField = builder.packetField;
                this.port = builder.port;
                this.portRanges = builder.portRanges;
                this.prefixList = builder.prefixList;
                this.protocols = builder.protocols;
                this.routeTable = builder.routeTable;
                this.routeTableRoute = builder.routeTableRoute;
                this.securityGroup = builder.securityGroup;
                this.securityGroupRule = builder.securityGroupRule;
                this.securityGroups = builder.securityGroups;
                this.sourceVpc = builder.sourceVpc;
                this.state = builder.state;
                this.subnet = builder.subnet;
                this.subnetRouteTable = builder.subnetRouteTable;
                this.transitGateway = builder.transitGateway;
                this.transitGatewayAttachment = builder.transitGatewayAttachment;
                this.transitGatewayRouteTable = builder.transitGatewayRouteTable;
                this.transitGatewayRouteTableRoute = builder.transitGatewayRouteTableRoute;
                this.vpc = builder.vpc;
                this.vpcEndpoint = builder.vpcEndpoint;
                this.vpcPeeringConnection = builder.vpcPeeringConnection;
                this.vpnConnection = builder.vpnConnection;
                this.vpnGateway = builder.vpnGateway;
            }

            @Override
            public final java.lang.Object getAcl() {
                return this.acl;
            }

            @Override
            public final java.lang.Object getAclRule() {
                return this.aclRule;
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            public final java.util.List<java.lang.String> getAddresses() {
                return this.addresses;
            }

            @Override
            public final java.lang.Object getAttachedTo() {
                return this.attachedTo;
            }

            @Override
            public final java.util.List<java.lang.String> getAvailabilityZones() {
                return this.availabilityZones;
            }

            @Override
            public final java.util.List<java.lang.String> getCidrs() {
                return this.cidrs;
            }

            @Override
            public final java.lang.Object getClassicLoadBalancerListener() {
                return this.classicLoadBalancerListener;
            }

            @Override
            public final java.lang.Object getComponent() {
                return this.component;
            }

            @Override
            public final java.lang.String getComponentAccount() {
                return this.componentAccount;
            }

            @Override
            public final java.lang.String getComponentRegion() {
                return this.componentRegion;
            }

            @Override
            public final java.lang.Object getCustomerGateway() {
                return this.customerGateway;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Object getDestinationVpc() {
                return this.destinationVpc;
            }

            @Override
            public final java.lang.String getDirection() {
                return this.direction;
            }

            @Override
            public final java.lang.Object getElasticLoadBalancerListener() {
                return this.elasticLoadBalancerListener;
            }

            @Override
            public final java.lang.String getExplanationCode() {
                return this.explanationCode;
            }

            @Override
            public final java.lang.Object getIngressRouteTable() {
                return this.ingressRouteTable;
            }

            @Override
            public final java.lang.Object getInternetGateway() {
                return this.internetGateway;
            }

            @Override
            public final java.lang.String getLoadBalancerArn() {
                return this.loadBalancerArn;
            }

            @Override
            public final java.lang.Number getLoadBalancerListenerPort() {
                return this.loadBalancerListenerPort;
            }

            @Override
            public final java.lang.Object getLoadBalancerTarget() {
                return this.loadBalancerTarget;
            }

            @Override
            public final java.lang.Object getLoadBalancerTargetGroup() {
                return this.loadBalancerTargetGroup;
            }

            @Override
            public final java.lang.Object getLoadBalancerTargetGroups() {
                return this.loadBalancerTargetGroups;
            }

            @Override
            public final java.lang.Number getLoadBalancerTargetPort() {
                return this.loadBalancerTargetPort;
            }

            @Override
            public final java.lang.String getMissingComponent() {
                return this.missingComponent;
            }

            @Override
            public final java.lang.Object getNatGateway() {
                return this.natGateway;
            }

            @Override
            public final java.lang.Object getNetworkInterface() {
                return this.networkInterface;
            }

            @Override
            public final java.lang.String getPacketField() {
                return this.packetField;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getPortRanges() {
                return this.portRanges;
            }

            @Override
            public final java.lang.Object getPrefixList() {
                return this.prefixList;
            }

            @Override
            public final java.util.List<java.lang.String> getProtocols() {
                return this.protocols;
            }

            @Override
            public final java.lang.Object getRouteTable() {
                return this.routeTable;
            }

            @Override
            public final java.lang.Object getRouteTableRoute() {
                return this.routeTableRoute;
            }

            @Override
            public final java.lang.Object getSecurityGroup() {
                return this.securityGroup;
            }

            @Override
            public final java.lang.Object getSecurityGroupRule() {
                return this.securityGroupRule;
            }

            @Override
            public final java.lang.Object getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.lang.Object getSourceVpc() {
                return this.sourceVpc;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.lang.Object getSubnet() {
                return this.subnet;
            }

            @Override
            public final java.lang.Object getSubnetRouteTable() {
                return this.subnetRouteTable;
            }

            @Override
            public final java.lang.Object getTransitGateway() {
                return this.transitGateway;
            }

            @Override
            public final java.lang.Object getTransitGatewayAttachment() {
                return this.transitGatewayAttachment;
            }

            @Override
            public final java.lang.Object getTransitGatewayRouteTable() {
                return this.transitGatewayRouteTable;
            }

            @Override
            public final java.lang.Object getTransitGatewayRouteTableRoute() {
                return this.transitGatewayRouteTableRoute;
            }

            @Override
            public final java.lang.Object getVpc() {
                return this.vpc;
            }

            @Override
            public final java.lang.Object getVpcEndpoint() {
                return this.vpcEndpoint;
            }

            @Override
            public final java.lang.Object getVpcPeeringConnection() {
                return this.vpcPeeringConnection;
            }

            @Override
            public final java.lang.Object getVpnConnection() {
                return this.vpnConnection;
            }

            @Override
            public final java.lang.Object getVpnGateway() {
                return this.vpnGateway;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcl() != null) {
                    data.set("acl", om.valueToTree(this.getAcl()));
                }
                if (this.getAclRule() != null) {
                    data.set("aclRule", om.valueToTree(this.getAclRule()));
                }
                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }
                if (this.getAddresses() != null) {
                    data.set("addresses", om.valueToTree(this.getAddresses()));
                }
                if (this.getAttachedTo() != null) {
                    data.set("attachedTo", om.valueToTree(this.getAttachedTo()));
                }
                if (this.getAvailabilityZones() != null) {
                    data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
                }
                if (this.getCidrs() != null) {
                    data.set("cidrs", om.valueToTree(this.getCidrs()));
                }
                if (this.getClassicLoadBalancerListener() != null) {
                    data.set("classicLoadBalancerListener", om.valueToTree(this.getClassicLoadBalancerListener()));
                }
                if (this.getComponent() != null) {
                    data.set("component", om.valueToTree(this.getComponent()));
                }
                if (this.getComponentAccount() != null) {
                    data.set("componentAccount", om.valueToTree(this.getComponentAccount()));
                }
                if (this.getComponentRegion() != null) {
                    data.set("componentRegion", om.valueToTree(this.getComponentRegion()));
                }
                if (this.getCustomerGateway() != null) {
                    data.set("customerGateway", om.valueToTree(this.getCustomerGateway()));
                }
                if (this.getDestination() != null) {
                    data.set("destination", om.valueToTree(this.getDestination()));
                }
                if (this.getDestinationVpc() != null) {
                    data.set("destinationVpc", om.valueToTree(this.getDestinationVpc()));
                }
                if (this.getDirection() != null) {
                    data.set("direction", om.valueToTree(this.getDirection()));
                }
                if (this.getElasticLoadBalancerListener() != null) {
                    data.set("elasticLoadBalancerListener", om.valueToTree(this.getElasticLoadBalancerListener()));
                }
                if (this.getExplanationCode() != null) {
                    data.set("explanationCode", om.valueToTree(this.getExplanationCode()));
                }
                if (this.getIngressRouteTable() != null) {
                    data.set("ingressRouteTable", om.valueToTree(this.getIngressRouteTable()));
                }
                if (this.getInternetGateway() != null) {
                    data.set("internetGateway", om.valueToTree(this.getInternetGateway()));
                }
                if (this.getLoadBalancerArn() != null) {
                    data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
                }
                if (this.getLoadBalancerListenerPort() != null) {
                    data.set("loadBalancerListenerPort", om.valueToTree(this.getLoadBalancerListenerPort()));
                }
                if (this.getLoadBalancerTarget() != null) {
                    data.set("loadBalancerTarget", om.valueToTree(this.getLoadBalancerTarget()));
                }
                if (this.getLoadBalancerTargetGroup() != null) {
                    data.set("loadBalancerTargetGroup", om.valueToTree(this.getLoadBalancerTargetGroup()));
                }
                if (this.getLoadBalancerTargetGroups() != null) {
                    data.set("loadBalancerTargetGroups", om.valueToTree(this.getLoadBalancerTargetGroups()));
                }
                if (this.getLoadBalancerTargetPort() != null) {
                    data.set("loadBalancerTargetPort", om.valueToTree(this.getLoadBalancerTargetPort()));
                }
                if (this.getMissingComponent() != null) {
                    data.set("missingComponent", om.valueToTree(this.getMissingComponent()));
                }
                if (this.getNatGateway() != null) {
                    data.set("natGateway", om.valueToTree(this.getNatGateway()));
                }
                if (this.getNetworkInterface() != null) {
                    data.set("networkInterface", om.valueToTree(this.getNetworkInterface()));
                }
                if (this.getPacketField() != null) {
                    data.set("packetField", om.valueToTree(this.getPacketField()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getPortRanges() != null) {
                    data.set("portRanges", om.valueToTree(this.getPortRanges()));
                }
                if (this.getPrefixList() != null) {
                    data.set("prefixList", om.valueToTree(this.getPrefixList()));
                }
                if (this.getProtocols() != null) {
                    data.set("protocols", om.valueToTree(this.getProtocols()));
                }
                if (this.getRouteTable() != null) {
                    data.set("routeTable", om.valueToTree(this.getRouteTable()));
                }
                if (this.getRouteTableRoute() != null) {
                    data.set("routeTableRoute", om.valueToTree(this.getRouteTableRoute()));
                }
                if (this.getSecurityGroup() != null) {
                    data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
                }
                if (this.getSecurityGroupRule() != null) {
                    data.set("securityGroupRule", om.valueToTree(this.getSecurityGroupRule()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getSourceVpc() != null) {
                    data.set("sourceVpc", om.valueToTree(this.getSourceVpc()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }
                if (this.getSubnet() != null) {
                    data.set("subnet", om.valueToTree(this.getSubnet()));
                }
                if (this.getSubnetRouteTable() != null) {
                    data.set("subnetRouteTable", om.valueToTree(this.getSubnetRouteTable()));
                }
                if (this.getTransitGateway() != null) {
                    data.set("transitGateway", om.valueToTree(this.getTransitGateway()));
                }
                if (this.getTransitGatewayAttachment() != null) {
                    data.set("transitGatewayAttachment", om.valueToTree(this.getTransitGatewayAttachment()));
                }
                if (this.getTransitGatewayRouteTable() != null) {
                    data.set("transitGatewayRouteTable", om.valueToTree(this.getTransitGatewayRouteTable()));
                }
                if (this.getTransitGatewayRouteTableRoute() != null) {
                    data.set("transitGatewayRouteTableRoute", om.valueToTree(this.getTransitGatewayRouteTableRoute()));
                }
                if (this.getVpc() != null) {
                    data.set("vpc", om.valueToTree(this.getVpc()));
                }
                if (this.getVpcEndpoint() != null) {
                    data.set("vpcEndpoint", om.valueToTree(this.getVpcEndpoint()));
                }
                if (this.getVpcPeeringConnection() != null) {
                    data.set("vpcPeeringConnection", om.valueToTree(this.getVpcPeeringConnection()));
                }
                if (this.getVpnConnection() != null) {
                    data.set("vpnConnection", om.valueToTree(this.getVpnConnection()));
                }
                if (this.getVpnGateway() != null) {
                    data.set("vpnGateway", om.valueToTree(this.getVpnGateway()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.ExplanationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExplanationProperty.Jsii$Proxy that = (ExplanationProperty.Jsii$Proxy) o;

                if (this.acl != null ? !this.acl.equals(that.acl) : that.acl != null) return false;
                if (this.aclRule != null ? !this.aclRule.equals(that.aclRule) : that.aclRule != null) return false;
                if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
                if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) return false;
                if (this.attachedTo != null ? !this.attachedTo.equals(that.attachedTo) : that.attachedTo != null) return false;
                if (this.availabilityZones != null ? !this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones != null) return false;
                if (this.cidrs != null ? !this.cidrs.equals(that.cidrs) : that.cidrs != null) return false;
                if (this.classicLoadBalancerListener != null ? !this.classicLoadBalancerListener.equals(that.classicLoadBalancerListener) : that.classicLoadBalancerListener != null) return false;
                if (this.component != null ? !this.component.equals(that.component) : that.component != null) return false;
                if (this.componentAccount != null ? !this.componentAccount.equals(that.componentAccount) : that.componentAccount != null) return false;
                if (this.componentRegion != null ? !this.componentRegion.equals(that.componentRegion) : that.componentRegion != null) return false;
                if (this.customerGateway != null ? !this.customerGateway.equals(that.customerGateway) : that.customerGateway != null) return false;
                if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
                if (this.destinationVpc != null ? !this.destinationVpc.equals(that.destinationVpc) : that.destinationVpc != null) return false;
                if (this.direction != null ? !this.direction.equals(that.direction) : that.direction != null) return false;
                if (this.elasticLoadBalancerListener != null ? !this.elasticLoadBalancerListener.equals(that.elasticLoadBalancerListener) : that.elasticLoadBalancerListener != null) return false;
                if (this.explanationCode != null ? !this.explanationCode.equals(that.explanationCode) : that.explanationCode != null) return false;
                if (this.ingressRouteTable != null ? !this.ingressRouteTable.equals(that.ingressRouteTable) : that.ingressRouteTable != null) return false;
                if (this.internetGateway != null ? !this.internetGateway.equals(that.internetGateway) : that.internetGateway != null) return false;
                if (this.loadBalancerArn != null ? !this.loadBalancerArn.equals(that.loadBalancerArn) : that.loadBalancerArn != null) return false;
                if (this.loadBalancerListenerPort != null ? !this.loadBalancerListenerPort.equals(that.loadBalancerListenerPort) : that.loadBalancerListenerPort != null) return false;
                if (this.loadBalancerTarget != null ? !this.loadBalancerTarget.equals(that.loadBalancerTarget) : that.loadBalancerTarget != null) return false;
                if (this.loadBalancerTargetGroup != null ? !this.loadBalancerTargetGroup.equals(that.loadBalancerTargetGroup) : that.loadBalancerTargetGroup != null) return false;
                if (this.loadBalancerTargetGroups != null ? !this.loadBalancerTargetGroups.equals(that.loadBalancerTargetGroups) : that.loadBalancerTargetGroups != null) return false;
                if (this.loadBalancerTargetPort != null ? !this.loadBalancerTargetPort.equals(that.loadBalancerTargetPort) : that.loadBalancerTargetPort != null) return false;
                if (this.missingComponent != null ? !this.missingComponent.equals(that.missingComponent) : that.missingComponent != null) return false;
                if (this.natGateway != null ? !this.natGateway.equals(that.natGateway) : that.natGateway != null) return false;
                if (this.networkInterface != null ? !this.networkInterface.equals(that.networkInterface) : that.networkInterface != null) return false;
                if (this.packetField != null ? !this.packetField.equals(that.packetField) : that.packetField != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.portRanges != null ? !this.portRanges.equals(that.portRanges) : that.portRanges != null) return false;
                if (this.prefixList != null ? !this.prefixList.equals(that.prefixList) : that.prefixList != null) return false;
                if (this.protocols != null ? !this.protocols.equals(that.protocols) : that.protocols != null) return false;
                if (this.routeTable != null ? !this.routeTable.equals(that.routeTable) : that.routeTable != null) return false;
                if (this.routeTableRoute != null ? !this.routeTableRoute.equals(that.routeTableRoute) : that.routeTableRoute != null) return false;
                if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
                if (this.securityGroupRule != null ? !this.securityGroupRule.equals(that.securityGroupRule) : that.securityGroupRule != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                if (this.sourceVpc != null ? !this.sourceVpc.equals(that.sourceVpc) : that.sourceVpc != null) return false;
                if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
                if (this.subnet != null ? !this.subnet.equals(that.subnet) : that.subnet != null) return false;
                if (this.subnetRouteTable != null ? !this.subnetRouteTable.equals(that.subnetRouteTable) : that.subnetRouteTable != null) return false;
                if (this.transitGateway != null ? !this.transitGateway.equals(that.transitGateway) : that.transitGateway != null) return false;
                if (this.transitGatewayAttachment != null ? !this.transitGatewayAttachment.equals(that.transitGatewayAttachment) : that.transitGatewayAttachment != null) return false;
                if (this.transitGatewayRouteTable != null ? !this.transitGatewayRouteTable.equals(that.transitGatewayRouteTable) : that.transitGatewayRouteTable != null) return false;
                if (this.transitGatewayRouteTableRoute != null ? !this.transitGatewayRouteTableRoute.equals(that.transitGatewayRouteTableRoute) : that.transitGatewayRouteTableRoute != null) return false;
                if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
                if (this.vpcEndpoint != null ? !this.vpcEndpoint.equals(that.vpcEndpoint) : that.vpcEndpoint != null) return false;
                if (this.vpcPeeringConnection != null ? !this.vpcPeeringConnection.equals(that.vpcPeeringConnection) : that.vpcPeeringConnection != null) return false;
                if (this.vpnConnection != null ? !this.vpnConnection.equals(that.vpnConnection) : that.vpnConnection != null) return false;
                return this.vpnGateway != null ? this.vpnGateway.equals(that.vpnGateway) : that.vpnGateway == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acl != null ? this.acl.hashCode() : 0;
                result = 31 * result + (this.aclRule != null ? this.aclRule.hashCode() : 0);
                result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
                result = 31 * result + (this.addresses != null ? this.addresses.hashCode() : 0);
                result = 31 * result + (this.attachedTo != null ? this.attachedTo.hashCode() : 0);
                result = 31 * result + (this.availabilityZones != null ? this.availabilityZones.hashCode() : 0);
                result = 31 * result + (this.cidrs != null ? this.cidrs.hashCode() : 0);
                result = 31 * result + (this.classicLoadBalancerListener != null ? this.classicLoadBalancerListener.hashCode() : 0);
                result = 31 * result + (this.component != null ? this.component.hashCode() : 0);
                result = 31 * result + (this.componentAccount != null ? this.componentAccount.hashCode() : 0);
                result = 31 * result + (this.componentRegion != null ? this.componentRegion.hashCode() : 0);
                result = 31 * result + (this.customerGateway != null ? this.customerGateway.hashCode() : 0);
                result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
                result = 31 * result + (this.destinationVpc != null ? this.destinationVpc.hashCode() : 0);
                result = 31 * result + (this.direction != null ? this.direction.hashCode() : 0);
                result = 31 * result + (this.elasticLoadBalancerListener != null ? this.elasticLoadBalancerListener.hashCode() : 0);
                result = 31 * result + (this.explanationCode != null ? this.explanationCode.hashCode() : 0);
                result = 31 * result + (this.ingressRouteTable != null ? this.ingressRouteTable.hashCode() : 0);
                result = 31 * result + (this.internetGateway != null ? this.internetGateway.hashCode() : 0);
                result = 31 * result + (this.loadBalancerArn != null ? this.loadBalancerArn.hashCode() : 0);
                result = 31 * result + (this.loadBalancerListenerPort != null ? this.loadBalancerListenerPort.hashCode() : 0);
                result = 31 * result + (this.loadBalancerTarget != null ? this.loadBalancerTarget.hashCode() : 0);
                result = 31 * result + (this.loadBalancerTargetGroup != null ? this.loadBalancerTargetGroup.hashCode() : 0);
                result = 31 * result + (this.loadBalancerTargetGroups != null ? this.loadBalancerTargetGroups.hashCode() : 0);
                result = 31 * result + (this.loadBalancerTargetPort != null ? this.loadBalancerTargetPort.hashCode() : 0);
                result = 31 * result + (this.missingComponent != null ? this.missingComponent.hashCode() : 0);
                result = 31 * result + (this.natGateway != null ? this.natGateway.hashCode() : 0);
                result = 31 * result + (this.networkInterface != null ? this.networkInterface.hashCode() : 0);
                result = 31 * result + (this.packetField != null ? this.packetField.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.portRanges != null ? this.portRanges.hashCode() : 0);
                result = 31 * result + (this.prefixList != null ? this.prefixList.hashCode() : 0);
                result = 31 * result + (this.protocols != null ? this.protocols.hashCode() : 0);
                result = 31 * result + (this.routeTable != null ? this.routeTable.hashCode() : 0);
                result = 31 * result + (this.routeTableRoute != null ? this.routeTableRoute.hashCode() : 0);
                result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
                result = 31 * result + (this.securityGroupRule != null ? this.securityGroupRule.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.sourceVpc != null ? this.sourceVpc.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                result = 31 * result + (this.subnet != null ? this.subnet.hashCode() : 0);
                result = 31 * result + (this.subnetRouteTable != null ? this.subnetRouteTable.hashCode() : 0);
                result = 31 * result + (this.transitGateway != null ? this.transitGateway.hashCode() : 0);
                result = 31 * result + (this.transitGatewayAttachment != null ? this.transitGatewayAttachment.hashCode() : 0);
                result = 31 * result + (this.transitGatewayRouteTable != null ? this.transitGatewayRouteTable.hashCode() : 0);
                result = 31 * result + (this.transitGatewayRouteTableRoute != null ? this.transitGatewayRouteTableRoute.hashCode() : 0);
                result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
                result = 31 * result + (this.vpcEndpoint != null ? this.vpcEndpoint.hashCode() : 0);
                result = 31 * result + (this.vpcPeeringConnection != null ? this.vpcPeeringConnection.hashCode() : 0);
                result = 31 * result + (this.vpnConnection != null ? this.vpnConnection.hashCode() : 0);
                result = 31 * result + (this.vpnGateway != null ? this.vpnGateway.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a path component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PathComponentProperty pathComponentProperty = PathComponentProperty.builder()
     *         .aclRule(AnalysisAclRuleProperty.builder()
     *                 .cidr("cidr")
     *                 .egress(false)
     *                 .portRange(PortRangeProperty.builder()
     *                         .from(123)
     *                         .to(123)
     *                         .build())
     *                 .protocol("protocol")
     *                 .ruleAction("ruleAction")
     *                 .ruleNumber(123)
     *                 .build())
     *         .additionalDetails(List.of(AdditionalDetailProperty.builder()
     *                 .additionalDetailType("additionalDetailType")
     *                 .component(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .loadBalancers(List.of(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build()))
     *                 .serviceName("serviceName")
     *                 .build()))
     *         .component(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .destinationVpc(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .elasticLoadBalancerListener(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .explanations(List.of(ExplanationProperty.builder()
     *                 .acl(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .aclRule(AnalysisAclRuleProperty.builder()
     *                         .cidr("cidr")
     *                         .egress(false)
     *                         .portRange(PortRangeProperty.builder()
     *                                 .from(123)
     *                                 .to(123)
     *                                 .build())
     *                         .protocol("protocol")
     *                         .ruleAction("ruleAction")
     *                         .ruleNumber(123)
     *                         .build())
     *                 .address("address")
     *                 .addresses(List.of("addresses"))
     *                 .attachedTo(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .availabilityZones(List.of("availabilityZones"))
     *                 .cidrs(List.of("cidrs"))
     *                 .classicLoadBalancerListener(AnalysisLoadBalancerListenerProperty.builder()
     *                         .instancePort(123)
     *                         .loadBalancerPort(123)
     *                         .build())
     *                 .component(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .componentAccount("componentAccount")
     *                 .componentRegion("componentRegion")
     *                 .customerGateway(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .destination(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .destinationVpc(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .direction("direction")
     *                 .elasticLoadBalancerListener(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .explanationCode("explanationCode")
     *                 .ingressRouteTable(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .internetGateway(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .loadBalancerArn("loadBalancerArn")
     *                 .loadBalancerListenerPort(123)
     *                 .loadBalancerTarget(AnalysisLoadBalancerTargetProperty.builder()
     *                         .address("address")
     *                         .availabilityZone("availabilityZone")
     *                         .instance(AnalysisComponentProperty.builder()
     *                                 .arn("arn")
     *                                 .id("id")
     *                                 .build())
     *                         .port(123)
     *                         .build())
     *                 .loadBalancerTargetGroup(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .loadBalancerTargetGroups(List.of(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build()))
     *                 .loadBalancerTargetPort(123)
     *                 .missingComponent("missingComponent")
     *                 .natGateway(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .networkInterface(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .packetField("packetField")
     *                 .port(123)
     *                 .portRanges(List.of(PortRangeProperty.builder()
     *                         .from(123)
     *                         .to(123)
     *                         .build()))
     *                 .prefixList(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .protocols(List.of("protocols"))
     *                 .routeTable(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .routeTableRoute(AnalysisRouteTableRouteProperty.builder()
     *                         .destinationCidr("destinationCidr")
     *                         .destinationPrefixListId("destinationPrefixListId")
     *                         .egressOnlyInternetGatewayId("egressOnlyInternetGatewayId")
     *                         .gatewayId("gatewayId")
     *                         .instanceId("instanceId")
     *                         .natGatewayId("natGatewayId")
     *                         .networkInterfaceId("networkInterfaceId")
     *                         .origin("origin")
     *                         .state("state")
     *                         .transitGatewayId("transitGatewayId")
     *                         .vpcPeeringConnectionId("vpcPeeringConnectionId")
     *                         .build())
     *                 .securityGroup(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .securityGroupRule(AnalysisSecurityGroupRuleProperty.builder()
     *                         .cidr("cidr")
     *                         .direction("direction")
     *                         .portRange(PortRangeProperty.builder()
     *                                 .from(123)
     *                                 .to(123)
     *                                 .build())
     *                         .prefixListId("prefixListId")
     *                         .protocol("protocol")
     *                         .securityGroupId("securityGroupId")
     *                         .build())
     *                 .securityGroups(List.of(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build()))
     *                 .sourceVpc(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .state("state")
     *                 .subnet(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .subnetRouteTable(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .transitGateway(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .transitGatewayAttachment(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .transitGatewayRouteTable(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .transitGatewayRouteTableRoute(TransitGatewayRouteTableRouteProperty.builder()
     *                         .attachmentId("attachmentId")
     *                         .destinationCidr("destinationCidr")
     *                         .prefixListId("prefixListId")
     *                         .resourceId("resourceId")
     *                         .resourceType("resourceType")
     *                         .routeOrigin("routeOrigin")
     *                         .state("state")
     *                         .build())
     *                 .vpc(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .vpcEndpoint(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .vpcPeeringConnection(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .vpnConnection(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .vpnGateway(AnalysisComponentProperty.builder()
     *                         .arn("arn")
     *                         .id("id")
     *                         .build())
     *                 .build()))
     *         .inboundHeader(AnalysisPacketHeaderProperty.builder()
     *                 .destinationAddresses(List.of("destinationAddresses"))
     *                 .destinationPortRanges(List.of(PortRangeProperty.builder()
     *                         .from(123)
     *                         .to(123)
     *                         .build()))
     *                 .protocol("protocol")
     *                 .sourceAddresses(List.of("sourceAddresses"))
     *                 .sourcePortRanges(List.of(PortRangeProperty.builder()
     *                         .from(123)
     *                         .to(123)
     *                         .build()))
     *                 .build())
     *         .outboundHeader(AnalysisPacketHeaderProperty.builder()
     *                 .destinationAddresses(List.of("destinationAddresses"))
     *                 .destinationPortRanges(List.of(PortRangeProperty.builder()
     *                         .from(123)
     *                         .to(123)
     *                         .build()))
     *                 .protocol("protocol")
     *                 .sourceAddresses(List.of("sourceAddresses"))
     *                 .sourcePortRanges(List.of(PortRangeProperty.builder()
     *                         .from(123)
     *                         .to(123)
     *                         .build()))
     *                 .build())
     *         .routeTableRoute(AnalysisRouteTableRouteProperty.builder()
     *                 .destinationCidr("destinationCidr")
     *                 .destinationPrefixListId("destinationPrefixListId")
     *                 .egressOnlyInternetGatewayId("egressOnlyInternetGatewayId")
     *                 .gatewayId("gatewayId")
     *                 .instanceId("instanceId")
     *                 .natGatewayId("natGatewayId")
     *                 .networkInterfaceId("networkInterfaceId")
     *                 .origin("origin")
     *                 .state("state")
     *                 .transitGatewayId("transitGatewayId")
     *                 .vpcPeeringConnectionId("vpcPeeringConnectionId")
     *                 .build())
     *         .securityGroupRule(AnalysisSecurityGroupRuleProperty.builder()
     *                 .cidr("cidr")
     *                 .direction("direction")
     *                 .portRange(PortRangeProperty.builder()
     *                         .from(123)
     *                         .to(123)
     *                         .build())
     *                 .prefixListId("prefixListId")
     *                 .protocol("protocol")
     *                 .securityGroupId("securityGroupId")
     *                 .build())
     *         .sequenceNumber(123)
     *         .serviceName("serviceName")
     *         .sourceVpc(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .subnet(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .transitGateway(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .transitGatewayRouteTableRoute(TransitGatewayRouteTableRouteProperty.builder()
     *                 .attachmentId("attachmentId")
     *                 .destinationCidr("destinationCidr")
     *                 .prefixListId("prefixListId")
     *                 .resourceId("resourceId")
     *                 .resourceType("resourceType")
     *                 .routeOrigin("routeOrigin")
     *                 .state("state")
     *                 .build())
     *         .vpc(AnalysisComponentProperty.builder()
     *                 .arn("arn")
     *                 .id("id")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.PathComponentProperty")
    @software.amazon.jsii.Jsii.Proxy(PathComponentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PathComponentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The network ACL rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-aclrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-aclrule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAclRule() {
            return null;
        }

        /**
         * The additional details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-additionaldetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-additionaldetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalDetails() {
            return null;
        }

        /**
         * The component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-component">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-component</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComponent() {
            return null;
        }

        /**
         * The destination VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-destinationvpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-destinationvpc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationVpc() {
            return null;
        }

        /**
         * The load balancer listener.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-elasticloadbalancerlistener">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-elasticloadbalancerlistener</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElasticLoadBalancerListener() {
            return null;
        }

        /**
         * The explanation codes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-explanations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-explanations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExplanations() {
            return null;
        }

        /**
         * The inbound header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-inboundheader">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-inboundheader</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInboundHeader() {
            return null;
        }

        /**
         * The outbound header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-outboundheader">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-outboundheader</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutboundHeader() {
            return null;
        }

        /**
         * The route table route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-routetableroute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-routetableroute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRouteTableRoute() {
            return null;
        }

        /**
         * The security group rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-securitygrouprule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-securitygrouprule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroupRule() {
            return null;
        }

        /**
         * The sequence number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-sequencenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-sequencenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSequenceNumber() {
            return null;
        }

        /**
         * The name of the VPC endpoint service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-servicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
            return null;
        }

        /**
         * The source VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-sourcevpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-sourcevpc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceVpc() {
            return null;
        }

        /**
         * The subnet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-subnet">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-subnet</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubnet() {
            return null;
        }

        /**
         * The transit gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-transitgateway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-transitgateway</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitGateway() {
            return null;
        }

        /**
         * The route in a transit gateway route table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-transitgatewayroutetableroute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-transitgatewayroutetableroute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitGatewayRouteTableRoute() {
            return null;
        }

        /**
         * The component VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-vpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-vpc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpc() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PathComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PathComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PathComponentProperty> {
            java.lang.Object aclRule;
            java.lang.Object additionalDetails;
            java.lang.Object component;
            java.lang.Object destinationVpc;
            java.lang.Object elasticLoadBalancerListener;
            java.lang.Object explanations;
            java.lang.Object inboundHeader;
            java.lang.Object outboundHeader;
            java.lang.Object routeTableRoute;
            java.lang.Object securityGroupRule;
            java.lang.Number sequenceNumber;
            java.lang.String serviceName;
            java.lang.Object sourceVpc;
            java.lang.Object subnet;
            java.lang.Object transitGateway;
            java.lang.Object transitGatewayRouteTableRoute;
            java.lang.Object vpc;

            /**
             * Sets the value of {@link PathComponentProperty#getAclRule}
             * @param aclRule The network ACL rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclRule(software.amazon.awscdk.IResolvable aclRule) {
                this.aclRule = aclRule;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getAclRule}
             * @param aclRule The network ACL rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclRule(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty aclRule) {
                this.aclRule = aclRule;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getAdditionalDetails}
             * @param additionalDetails The additional details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalDetails(software.amazon.awscdk.IResolvable additionalDetails) {
                this.additionalDetails = additionalDetails;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getAdditionalDetails}
             * @param additionalDetails The additional details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalDetails(java.util.List<? extends java.lang.Object> additionalDetails) {
                this.additionalDetails = additionalDetails;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getComponent}
             * @param component The component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder component(software.amazon.awscdk.IResolvable component) {
                this.component = component;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getComponent}
             * @param component The component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder component(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty component) {
                this.component = component;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getDestinationVpc}
             * @param destinationVpc The destination VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationVpc(software.amazon.awscdk.IResolvable destinationVpc) {
                this.destinationVpc = destinationVpc;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getDestinationVpc}
             * @param destinationVpc The destination VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationVpc(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty destinationVpc) {
                this.destinationVpc = destinationVpc;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getElasticLoadBalancerListener}
             * @param elasticLoadBalancerListener The load balancer listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticLoadBalancerListener(software.amazon.awscdk.IResolvable elasticLoadBalancerListener) {
                this.elasticLoadBalancerListener = elasticLoadBalancerListener;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getElasticLoadBalancerListener}
             * @param elasticLoadBalancerListener The load balancer listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticLoadBalancerListener(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty elasticLoadBalancerListener) {
                this.elasticLoadBalancerListener = elasticLoadBalancerListener;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getExplanations}
             * @param explanations The explanation codes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explanations(software.amazon.awscdk.IResolvable explanations) {
                this.explanations = explanations;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getExplanations}
             * @param explanations The explanation codes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder explanations(java.util.List<? extends java.lang.Object> explanations) {
                this.explanations = explanations;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getInboundHeader}
             * @param inboundHeader The inbound header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inboundHeader(software.amazon.awscdk.IResolvable inboundHeader) {
                this.inboundHeader = inboundHeader;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getInboundHeader}
             * @param inboundHeader The inbound header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inboundHeader(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty inboundHeader) {
                this.inboundHeader = inboundHeader;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getOutboundHeader}
             * @param outboundHeader The outbound header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundHeader(software.amazon.awscdk.IResolvable outboundHeader) {
                this.outboundHeader = outboundHeader;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getOutboundHeader}
             * @param outboundHeader The outbound header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundHeader(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty outboundHeader) {
                this.outboundHeader = outboundHeader;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getRouteTableRoute}
             * @param routeTableRoute The route table route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeTableRoute(software.amazon.awscdk.IResolvable routeTableRoute) {
                this.routeTableRoute = routeTableRoute;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getRouteTableRoute}
             * @param routeTableRoute The route table route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeTableRoute(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty routeTableRoute) {
                this.routeTableRoute = routeTableRoute;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getSecurityGroupRule}
             * @param securityGroupRule The security group rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupRule(software.amazon.awscdk.IResolvable securityGroupRule) {
                this.securityGroupRule = securityGroupRule;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getSecurityGroupRule}
             * @param securityGroupRule The security group rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupRule(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty securityGroupRule) {
                this.securityGroupRule = securityGroupRule;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getSequenceNumber}
             * @param sequenceNumber The sequence number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sequenceNumber(java.lang.Number sequenceNumber) {
                this.sequenceNumber = sequenceNumber;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getServiceName}
             * @param serviceName The name of the VPC endpoint service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getSourceVpc}
             * @param sourceVpc The source VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVpc(software.amazon.awscdk.IResolvable sourceVpc) {
                this.sourceVpc = sourceVpc;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getSourceVpc}
             * @param sourceVpc The source VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVpc(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty sourceVpc) {
                this.sourceVpc = sourceVpc;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getSubnet}
             * @param subnet The subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnet(software.amazon.awscdk.IResolvable subnet) {
                this.subnet = subnet;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getSubnet}
             * @param subnet The subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnet(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty subnet) {
                this.subnet = subnet;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getTransitGateway}
             * @param transitGateway The transit gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGateway(software.amazon.awscdk.IResolvable transitGateway) {
                this.transitGateway = transitGateway;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getTransitGateway}
             * @param transitGateway The transit gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGateway(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty transitGateway) {
                this.transitGateway = transitGateway;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getTransitGatewayRouteTableRoute}
             * @param transitGatewayRouteTableRoute The route in a transit gateway route table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayRouteTableRoute(software.amazon.awscdk.IResolvable transitGatewayRouteTableRoute) {
                this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getTransitGatewayRouteTableRoute}
             * @param transitGatewayRouteTableRoute The route in a transit gateway route table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayRouteTableRoute(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.TransitGatewayRouteTableRouteProperty transitGatewayRouteTableRoute) {
                this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getVpc}
             * @param vpc The component VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpc(software.amazon.awscdk.IResolvable vpc) {
                this.vpc = vpc;
                return this;
            }

            /**
             * Sets the value of {@link PathComponentProperty#getVpc}
             * @param vpc The component VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpc(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis.AnalysisComponentProperty vpc) {
                this.vpc = vpc;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PathComponentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PathComponentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PathComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PathComponentProperty {
            private final java.lang.Object aclRule;
            private final java.lang.Object additionalDetails;
            private final java.lang.Object component;
            private final java.lang.Object destinationVpc;
            private final java.lang.Object elasticLoadBalancerListener;
            private final java.lang.Object explanations;
            private final java.lang.Object inboundHeader;
            private final java.lang.Object outboundHeader;
            private final java.lang.Object routeTableRoute;
            private final java.lang.Object securityGroupRule;
            private final java.lang.Number sequenceNumber;
            private final java.lang.String serviceName;
            private final java.lang.Object sourceVpc;
            private final java.lang.Object subnet;
            private final java.lang.Object transitGateway;
            private final java.lang.Object transitGatewayRouteTableRoute;
            private final java.lang.Object vpc;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aclRule = software.amazon.jsii.Kernel.get(this, "aclRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.additionalDetails = software.amazon.jsii.Kernel.get(this, "additionalDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.component = software.amazon.jsii.Kernel.get(this, "component", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationVpc = software.amazon.jsii.Kernel.get(this, "destinationVpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elasticLoadBalancerListener = software.amazon.jsii.Kernel.get(this, "elasticLoadBalancerListener", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.explanations = software.amazon.jsii.Kernel.get(this, "explanations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inboundHeader = software.amazon.jsii.Kernel.get(this, "inboundHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outboundHeader = software.amazon.jsii.Kernel.get(this, "outboundHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.routeTableRoute = software.amazon.jsii.Kernel.get(this, "routeTableRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroupRule = software.amazon.jsii.Kernel.get(this, "securityGroupRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sequenceNumber = software.amazon.jsii.Kernel.get(this, "sequenceNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceVpc = software.amazon.jsii.Kernel.get(this, "sourceVpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subnet = software.amazon.jsii.Kernel.get(this, "subnet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transitGateway = software.amazon.jsii.Kernel.get(this, "transitGateway", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transitGatewayRouteTableRoute = software.amazon.jsii.Kernel.get(this, "transitGatewayRouteTableRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aclRule = builder.aclRule;
                this.additionalDetails = builder.additionalDetails;
                this.component = builder.component;
                this.destinationVpc = builder.destinationVpc;
                this.elasticLoadBalancerListener = builder.elasticLoadBalancerListener;
                this.explanations = builder.explanations;
                this.inboundHeader = builder.inboundHeader;
                this.outboundHeader = builder.outboundHeader;
                this.routeTableRoute = builder.routeTableRoute;
                this.securityGroupRule = builder.securityGroupRule;
                this.sequenceNumber = builder.sequenceNumber;
                this.serviceName = builder.serviceName;
                this.sourceVpc = builder.sourceVpc;
                this.subnet = builder.subnet;
                this.transitGateway = builder.transitGateway;
                this.transitGatewayRouteTableRoute = builder.transitGatewayRouteTableRoute;
                this.vpc = builder.vpc;
            }

            @Override
            public final java.lang.Object getAclRule() {
                return this.aclRule;
            }

            @Override
            public final java.lang.Object getAdditionalDetails() {
                return this.additionalDetails;
            }

            @Override
            public final java.lang.Object getComponent() {
                return this.component;
            }

            @Override
            public final java.lang.Object getDestinationVpc() {
                return this.destinationVpc;
            }

            @Override
            public final java.lang.Object getElasticLoadBalancerListener() {
                return this.elasticLoadBalancerListener;
            }

            @Override
            public final java.lang.Object getExplanations() {
                return this.explanations;
            }

            @Override
            public final java.lang.Object getInboundHeader() {
                return this.inboundHeader;
            }

            @Override
            public final java.lang.Object getOutboundHeader() {
                return this.outboundHeader;
            }

            @Override
            public final java.lang.Object getRouteTableRoute() {
                return this.routeTableRoute;
            }

            @Override
            public final java.lang.Object getSecurityGroupRule() {
                return this.securityGroupRule;
            }

            @Override
            public final java.lang.Number getSequenceNumber() {
                return this.sequenceNumber;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            public final java.lang.Object getSourceVpc() {
                return this.sourceVpc;
            }

            @Override
            public final java.lang.Object getSubnet() {
                return this.subnet;
            }

            @Override
            public final java.lang.Object getTransitGateway() {
                return this.transitGateway;
            }

            @Override
            public final java.lang.Object getTransitGatewayRouteTableRoute() {
                return this.transitGatewayRouteTableRoute;
            }

            @Override
            public final java.lang.Object getVpc() {
                return this.vpc;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAclRule() != null) {
                    data.set("aclRule", om.valueToTree(this.getAclRule()));
                }
                if (this.getAdditionalDetails() != null) {
                    data.set("additionalDetails", om.valueToTree(this.getAdditionalDetails()));
                }
                if (this.getComponent() != null) {
                    data.set("component", om.valueToTree(this.getComponent()));
                }
                if (this.getDestinationVpc() != null) {
                    data.set("destinationVpc", om.valueToTree(this.getDestinationVpc()));
                }
                if (this.getElasticLoadBalancerListener() != null) {
                    data.set("elasticLoadBalancerListener", om.valueToTree(this.getElasticLoadBalancerListener()));
                }
                if (this.getExplanations() != null) {
                    data.set("explanations", om.valueToTree(this.getExplanations()));
                }
                if (this.getInboundHeader() != null) {
                    data.set("inboundHeader", om.valueToTree(this.getInboundHeader()));
                }
                if (this.getOutboundHeader() != null) {
                    data.set("outboundHeader", om.valueToTree(this.getOutboundHeader()));
                }
                if (this.getRouteTableRoute() != null) {
                    data.set("routeTableRoute", om.valueToTree(this.getRouteTableRoute()));
                }
                if (this.getSecurityGroupRule() != null) {
                    data.set("securityGroupRule", om.valueToTree(this.getSecurityGroupRule()));
                }
                if (this.getSequenceNumber() != null) {
                    data.set("sequenceNumber", om.valueToTree(this.getSequenceNumber()));
                }
                if (this.getServiceName() != null) {
                    data.set("serviceName", om.valueToTree(this.getServiceName()));
                }
                if (this.getSourceVpc() != null) {
                    data.set("sourceVpc", om.valueToTree(this.getSourceVpc()));
                }
                if (this.getSubnet() != null) {
                    data.set("subnet", om.valueToTree(this.getSubnet()));
                }
                if (this.getTransitGateway() != null) {
                    data.set("transitGateway", om.valueToTree(this.getTransitGateway()));
                }
                if (this.getTransitGatewayRouteTableRoute() != null) {
                    data.set("transitGatewayRouteTableRoute", om.valueToTree(this.getTransitGatewayRouteTableRoute()));
                }
                if (this.getVpc() != null) {
                    data.set("vpc", om.valueToTree(this.getVpc()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.PathComponentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PathComponentProperty.Jsii$Proxy that = (PathComponentProperty.Jsii$Proxy) o;

                if (this.aclRule != null ? !this.aclRule.equals(that.aclRule) : that.aclRule != null) return false;
                if (this.additionalDetails != null ? !this.additionalDetails.equals(that.additionalDetails) : that.additionalDetails != null) return false;
                if (this.component != null ? !this.component.equals(that.component) : that.component != null) return false;
                if (this.destinationVpc != null ? !this.destinationVpc.equals(that.destinationVpc) : that.destinationVpc != null) return false;
                if (this.elasticLoadBalancerListener != null ? !this.elasticLoadBalancerListener.equals(that.elasticLoadBalancerListener) : that.elasticLoadBalancerListener != null) return false;
                if (this.explanations != null ? !this.explanations.equals(that.explanations) : that.explanations != null) return false;
                if (this.inboundHeader != null ? !this.inboundHeader.equals(that.inboundHeader) : that.inboundHeader != null) return false;
                if (this.outboundHeader != null ? !this.outboundHeader.equals(that.outboundHeader) : that.outboundHeader != null) return false;
                if (this.routeTableRoute != null ? !this.routeTableRoute.equals(that.routeTableRoute) : that.routeTableRoute != null) return false;
                if (this.securityGroupRule != null ? !this.securityGroupRule.equals(that.securityGroupRule) : that.securityGroupRule != null) return false;
                if (this.sequenceNumber != null ? !this.sequenceNumber.equals(that.sequenceNumber) : that.sequenceNumber != null) return false;
                if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
                if (this.sourceVpc != null ? !this.sourceVpc.equals(that.sourceVpc) : that.sourceVpc != null) return false;
                if (this.subnet != null ? !this.subnet.equals(that.subnet) : that.subnet != null) return false;
                if (this.transitGateway != null ? !this.transitGateway.equals(that.transitGateway) : that.transitGateway != null) return false;
                if (this.transitGatewayRouteTableRoute != null ? !this.transitGatewayRouteTableRoute.equals(that.transitGatewayRouteTableRoute) : that.transitGatewayRouteTableRoute != null) return false;
                return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aclRule != null ? this.aclRule.hashCode() : 0;
                result = 31 * result + (this.additionalDetails != null ? this.additionalDetails.hashCode() : 0);
                result = 31 * result + (this.component != null ? this.component.hashCode() : 0);
                result = 31 * result + (this.destinationVpc != null ? this.destinationVpc.hashCode() : 0);
                result = 31 * result + (this.elasticLoadBalancerListener != null ? this.elasticLoadBalancerListener.hashCode() : 0);
                result = 31 * result + (this.explanations != null ? this.explanations.hashCode() : 0);
                result = 31 * result + (this.inboundHeader != null ? this.inboundHeader.hashCode() : 0);
                result = 31 * result + (this.outboundHeader != null ? this.outboundHeader.hashCode() : 0);
                result = 31 * result + (this.routeTableRoute != null ? this.routeTableRoute.hashCode() : 0);
                result = 31 * result + (this.securityGroupRule != null ? this.securityGroupRule.hashCode() : 0);
                result = 31 * result + (this.sequenceNumber != null ? this.sequenceNumber.hashCode() : 0);
                result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
                result = 31 * result + (this.sourceVpc != null ? this.sourceVpc.hashCode() : 0);
                result = 31 * result + (this.subnet != null ? this.subnet.hashCode() : 0);
                result = 31 * result + (this.transitGateway != null ? this.transitGateway.hashCode() : 0);
                result = 31 * result + (this.transitGatewayRouteTableRoute != null ? this.transitGatewayRouteTableRoute.hashCode() : 0);
                result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a range of ports.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PortRangeProperty portRangeProperty = PortRangeProperty.builder()
     *         .from(123)
     *         .to(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.PortRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(PortRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The first port in the range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html#cfn-ec2-networkinsightsanalysis-portrange-from">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html#cfn-ec2-networkinsightsanalysis-portrange-from</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFrom() {
            return null;
        }

        /**
         * The last port in the range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html#cfn-ec2-networkinsightsanalysis-portrange-to">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html#cfn-ec2-networkinsightsanalysis-portrange-to</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTo() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortRangeProperty> {
            java.lang.Number from;
            java.lang.Number to;

            /**
             * Sets the value of {@link PortRangeProperty#getFrom}
             * @param from The first port in the range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder from(java.lang.Number from) {
                this.from = from;
                return this;
            }

            /**
             * Sets the value of {@link PortRangeProperty#getTo}
             * @param to The last port in the range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder to(java.lang.Number to) {
                this.to = to;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortRangeProperty {
            private final java.lang.Number from;
            private final java.lang.Number to;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.from = software.amazon.jsii.Kernel.get(this, "from", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.to = software.amazon.jsii.Kernel.get(this, "to", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.from = builder.from;
                this.to = builder.to;
            }

            @Override
            public final java.lang.Number getFrom() {
                return this.from;
            }

            @Override
            public final java.lang.Number getTo() {
                return this.to;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFrom() != null) {
                    data.set("from", om.valueToTree(this.getFrom()));
                }
                if (this.getTo() != null) {
                    data.set("to", om.valueToTree(this.getTo()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.PortRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortRangeProperty.Jsii$Proxy that = (PortRangeProperty.Jsii$Proxy) o;

                if (this.from != null ? !this.from.equals(that.from) : that.from != null) return false;
                return this.to != null ? this.to.equals(that.to) : that.to == null;
            }

            @Override
            public final int hashCode() {
                int result = this.from != null ? this.from.hashCode() : 0;
                result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a route in a transit gateway route table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TransitGatewayRouteTableRouteProperty transitGatewayRouteTableRouteProperty = TransitGatewayRouteTableRouteProperty.builder()
     *         .attachmentId("attachmentId")
     *         .destinationCidr("destinationCidr")
     *         .prefixListId("prefixListId")
     *         .resourceId("resourceId")
     *         .resourceType("resourceType")
     *         .routeOrigin("routeOrigin")
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.TransitGatewayRouteTableRouteProperty")
    @software.amazon.jsii.Jsii.Proxy(TransitGatewayRouteTableRouteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransitGatewayRouteTableRouteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the route attachment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-attachmentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-attachmentid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttachmentId() {
            return null;
        }

        /**
         * The CIDR block used for destination matches.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-destinationcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-destinationcidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationCidr() {
            return null;
        }

        /**
         * The ID of the prefix list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-prefixlistid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-prefixlistid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefixListId() {
            return null;
        }

        /**
         * The ID of the resource for the route attachment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
            return null;
        }

        /**
         * The resource type for the route attachment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-resourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * The route origin. The following are the possible values:.
         * <p>
         * <ul>
         * <li>static</li>
         * <li>propagated</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-routeorigin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-routeorigin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRouteOrigin() {
            return null;
        }

        /**
         * The state of the route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-transitgatewayroutetableroute.html#cfn-ec2-networkinsightsanalysis-transitgatewayroutetableroute-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransitGatewayRouteTableRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransitGatewayRouteTableRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransitGatewayRouteTableRouteProperty> {
            java.lang.String attachmentId;
            java.lang.String destinationCidr;
            java.lang.String prefixListId;
            java.lang.String resourceId;
            java.lang.String resourceType;
            java.lang.String routeOrigin;
            java.lang.String state;

            /**
             * Sets the value of {@link TransitGatewayRouteTableRouteProperty#getAttachmentId}
             * @param attachmentId The ID of the route attachment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachmentId(java.lang.String attachmentId) {
                this.attachmentId = attachmentId;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayRouteTableRouteProperty#getDestinationCidr}
             * @param destinationCidr The CIDR block used for destination matches.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationCidr(java.lang.String destinationCidr) {
                this.destinationCidr = destinationCidr;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayRouteTableRouteProperty#getPrefixListId}
             * @param prefixListId The ID of the prefix list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixListId(java.lang.String prefixListId) {
                this.prefixListId = prefixListId;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayRouteTableRouteProperty#getResourceId}
             * @param resourceId The ID of the resource for the route attachment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayRouteTableRouteProperty#getResourceType}
             * @param resourceType The resource type for the route attachment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayRouteTableRouteProperty#getRouteOrigin}
             * @param routeOrigin The route origin. The following are the possible values:.
             *                    <ul>
             *                    <li>static</li>
             *                    <li>propagated</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeOrigin(java.lang.String routeOrigin) {
                this.routeOrigin = routeOrigin;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayRouteTableRouteProperty#getState}
             * @param state The state of the route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitGatewayRouteTableRouteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransitGatewayRouteTableRouteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransitGatewayRouteTableRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitGatewayRouteTableRouteProperty {
            private final java.lang.String attachmentId;
            private final java.lang.String destinationCidr;
            private final java.lang.String prefixListId;
            private final java.lang.String resourceId;
            private final java.lang.String resourceType;
            private final java.lang.String routeOrigin;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attachmentId = software.amazon.jsii.Kernel.get(this, "attachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationCidr = software.amazon.jsii.Kernel.get(this, "destinationCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefixListId = software.amazon.jsii.Kernel.get(this, "prefixListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.routeOrigin = software.amazon.jsii.Kernel.get(this, "routeOrigin", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attachmentId = builder.attachmentId;
                this.destinationCidr = builder.destinationCidr;
                this.prefixListId = builder.prefixListId;
                this.resourceId = builder.resourceId;
                this.resourceType = builder.resourceType;
                this.routeOrigin = builder.routeOrigin;
                this.state = builder.state;
            }

            @Override
            public final java.lang.String getAttachmentId() {
                return this.attachmentId;
            }

            @Override
            public final java.lang.String getDestinationCidr() {
                return this.destinationCidr;
            }

            @Override
            public final java.lang.String getPrefixListId() {
                return this.prefixListId;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.lang.String getRouteOrigin() {
                return this.routeOrigin;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttachmentId() != null) {
                    data.set("attachmentId", om.valueToTree(this.getAttachmentId()));
                }
                if (this.getDestinationCidr() != null) {
                    data.set("destinationCidr", om.valueToTree(this.getDestinationCidr()));
                }
                if (this.getPrefixListId() != null) {
                    data.set("prefixListId", om.valueToTree(this.getPrefixListId()));
                }
                if (this.getResourceId() != null) {
                    data.set("resourceId", om.valueToTree(this.getResourceId()));
                }
                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getRouteOrigin() != null) {
                    data.set("routeOrigin", om.valueToTree(this.getRouteOrigin()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsAnalysis.TransitGatewayRouteTableRouteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransitGatewayRouteTableRouteProperty.Jsii$Proxy that = (TransitGatewayRouteTableRouteProperty.Jsii$Proxy) o;

                if (this.attachmentId != null ? !this.attachmentId.equals(that.attachmentId) : that.attachmentId != null) return false;
                if (this.destinationCidr != null ? !this.destinationCidr.equals(that.destinationCidr) : that.destinationCidr != null) return false;
                if (this.prefixListId != null ? !this.prefixListId.equals(that.prefixListId) : that.prefixListId != null) return false;
                if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) return false;
                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                if (this.routeOrigin != null ? !this.routeOrigin.equals(that.routeOrigin) : that.routeOrigin != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attachmentId != null ? this.attachmentId.hashCode() : 0;
                result = 31 * result + (this.destinationCidr != null ? this.destinationCidr.hashCode() : 0);
                result = 31 * result + (this.prefixListId != null ? this.prefixListId.hashCode() : 0);
                result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
                result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
                result = 31 * result + (this.routeOrigin != null ? this.routeOrigin.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysisProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysisProps.Builder();
        }

        /**
         * The ID of the path.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-networkinsightspathid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-networkinsightspathid</a>
         * @param networkInsightsPathId The ID of the path. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInsightsPathId(final java.lang.String networkInsightsPathId) {
            this.props.networkInsightsPathId(networkInsightsPathId);
            return this;
        }

        /**
         * The member accounts that contain resources that the path can traverse.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-additionalaccounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-additionalaccounts</a>
         * @param additionalAccounts The member accounts that contain resources that the path can traverse. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAccounts(final java.util.List<java.lang.String> additionalAccounts) {
            this.props.additionalAccounts(additionalAccounts);
            return this;
        }

        /**
         * The Amazon Resource Names (ARN) of the resources that the path must traverse.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-filterinarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-filterinarns</a>
         * @param filterInArns The Amazon Resource Names (ARN) of the resources that the path must traverse. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterInArns(final java.util.List<java.lang.String> filterInArns) {
            this.props.filterInArns(filterInArns);
            return this;
        }

        /**
         * The tags to apply.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-tags</a>
         * @param tags The tags to apply. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis build() {
            return new software.amazon.awscdk.services.ec2.CfnNetworkInsightsAnalysis(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
