package software.amazon.awscdk.services.ec2;

/**
 * The type of VPC traffic to log.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = new Vpc(this, "Vpc");
 * vpc.addFlowLog("FlowLogS3", FlowLogOptions.builder()
 *         .destination(FlowLogDestination.toS3())
 *         .build());
 * // Only reject traffic and interval every minute.
 * vpc.addFlowLog("FlowLogCloudWatch", FlowLogOptions.builder()
 *         .trafficType(FlowLogTrafficType.REJECT)
 *         .maxAggregationInterval(FlowLogMaxAggregationInterval.ONE_MINUTE)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:56.583Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.FlowLogTrafficType")
public enum FlowLogTrafficType {
    /**
     * Only log accepts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACCEPT,
    /**
     * Log all requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
    /**
     * Only log rejects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REJECT,
}
