package software.amazon.awscdk.services.ecs;

/**
 * Represents revision of a task definition, either a specific numbered revision or the <code>latest</code> revision.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * ExternalService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .desiredCount(5)
 *         .taskDefinitionRevision(TaskDefinitionRevision.of(1))
 *         .build();
 * ExternalService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .desiredCount(5)
 *         .taskDefinitionRevision(TaskDefinitionRevision.LATEST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:57.116Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.TaskDefinitionRevision")
public class TaskDefinitionRevision extends software.amazon.jsii.JsiiObject {

    protected TaskDefinitionRevision(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TaskDefinitionRevision(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        LATEST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.TaskDefinitionRevision.class, "LATEST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.TaskDefinitionRevision.class));
    }

    /**
     * Specific revision of a task.
     * <p>
     * @param revision This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinitionRevision of(final @org.jetbrains.annotations.NotNull java.lang.Number revision) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.TaskDefinitionRevision.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.TaskDefinitionRevision.class), new Object[] { java.util.Objects.requireNonNull(revision, "revision is required") });
    }

    /**
     * The most recent revision of a task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.TaskDefinitionRevision LATEST;

    /**
     * The string representation of this revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRevision() {
        return software.amazon.jsii.Kernel.get(this, "revision", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
