package software.amazon.awscdk.services.ecs.patterns;

/**
 * The base class for NetworkLoadBalancedEc2Service and NetworkLoadBalancedFargateService services.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:57.183Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.NetworkLoadBalancedServiceBase")
public abstract class NetworkLoadBalancedServiceBase extends software.constructs.Construct {

    protected NetworkLoadBalancedServiceBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkLoadBalancedServiceBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the NetworkLoadBalancedServiceBase class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected NetworkLoadBalancedServiceBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Constructs a new instance of the NetworkLoadBalancedServiceBase class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected NetworkLoadBalancedServiceBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds service as a target of the target group.
     * <p>
     * @param service This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addServiceAsTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BaseService service) {
        software.amazon.jsii.Kernel.call(this, "addServiceAsTarget", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * @param prefix This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AwsLogDriver createAWSLogDriver(final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        return software.amazon.jsii.Kernel.call(this, "createAWSLogDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AwsLogDriver.class), new Object[] { java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * Returns the default cluster.
     * <p>
     * @param scope This parameter is required.
     * @param vpc
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Cluster getDefaultCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc vpc) {
        return software.amazon.jsii.Kernel.call(this, "getDefaultCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Cluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), vpc });
    }

    /**
     * Returns the default cluster.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Cluster getDefaultCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getDefaultCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Cluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * The cluster that hosts the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
    }

    /**
     * The listener for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener getListener() {
        return software.amazon.jsii.Kernel.get(this, "listener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener.class));
    }

    /**
     * The Network Load Balancer for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer getLoadBalancer() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer.class));
    }

    /**
     * The target group for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup getTargetGroup() {
        return software.amazon.jsii.Kernel.get(this, "targetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup.class));
    }

    /**
     * The desired number of instantiations of the task definition to keep running on the service.
     * <p>
     * The default is 1 for all new services and uses the existing services desired count
     * when updating an existing service, if one is not provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getInternalDesiredCount() {
        return software.amazon.jsii.Kernel.get(this, "internalDesiredCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceBase implements software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
