package software.amazon.awscdk.services.efs;

/**
 * Attributes that can be specified when importing an AccessPoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AccessPoint.fromAccessPointAttributes(this, "ap", AccessPointAttributes.builder()
 *         .accessPointId("fsap-1293c4d9832fo0912")
 *         .fileSystem(FileSystem.fromFileSystemAttributes(this, "efs", FileSystemAttributes.builder()
 *                 .fileSystemId("fs-099d3e2f")
 *                 .securityGroup(SecurityGroup.fromSecurityGroupId(this, "sg", "sg-51530134"))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:57.227Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.AccessPointAttributes")
@software.amazon.jsii.Jsii.Proxy(AccessPointAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessPointAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AccessPoint One of this, or <code>accessPointId</code> is required.
     * <p>
     * Default: - determined based on accessPointId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointArn() {
        return null;
    }

    /**
     * The ID of the AccessPoint One of this, or <code>accessPointArn</code> is required.
     * <p>
     * Default: - determined based on accessPointArn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointId() {
        return null;
    }

    /**
     * The EFS file system.
     * <p>
     * Default: - no EFS file system
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.IFileSystem getFileSystem() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AccessPointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessPointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessPointAttributes> {
        java.lang.String accessPointArn;
        java.lang.String accessPointId;
        software.amazon.awscdk.services.efs.IFileSystem fileSystem;

        /**
         * Sets the value of {@link AccessPointAttributes#getAccessPointArn}
         * @param accessPointArn The ARN of the AccessPoint One of this, or <code>accessPointId</code> is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPointArn(java.lang.String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointAttributes#getAccessPointId}
         * @param accessPointId The ID of the AccessPoint One of this, or <code>accessPointArn</code> is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPointId(java.lang.String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointAttributes#getFileSystem}
         * @param fileSystem The EFS file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystem(software.amazon.awscdk.services.efs.IFileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessPointAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessPointAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessPointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessPointAttributes {
        private final java.lang.String accessPointArn;
        private final java.lang.String accessPointId;
        private final software.amazon.awscdk.services.efs.IFileSystem fileSystem;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessPointArn = software.amazon.jsii.Kernel.get(this, "accessPointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessPointId = software.amazon.jsii.Kernel.get(this, "accessPointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSystem = software.amazon.jsii.Kernel.get(this, "fileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IFileSystem.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessPointArn = builder.accessPointArn;
            this.accessPointId = builder.accessPointId;
            this.fileSystem = builder.fileSystem;
        }

        @Override
        public final java.lang.String getAccessPointArn() {
            return this.accessPointArn;
        }

        @Override
        public final java.lang.String getAccessPointId() {
            return this.accessPointId;
        }

        @Override
        public final software.amazon.awscdk.services.efs.IFileSystem getFileSystem() {
            return this.fileSystem;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessPointArn() != null) {
                data.set("accessPointArn", om.valueToTree(this.getAccessPointArn()));
            }
            if (this.getAccessPointId() != null) {
                data.set("accessPointId", om.valueToTree(this.getAccessPointId()));
            }
            if (this.getFileSystem() != null) {
                data.set("fileSystem", om.valueToTree(this.getFileSystem()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.AccessPointAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessPointAttributes.Jsii$Proxy that = (AccessPointAttributes.Jsii$Proxy) o;

            if (this.accessPointArn != null ? !this.accessPointArn.equals(that.accessPointArn) : that.accessPointArn != null) return false;
            if (this.accessPointId != null ? !this.accessPointId.equals(that.accessPointId) : that.accessPointId != null) return false;
            return this.fileSystem != null ? this.fileSystem.equals(that.fileSystem) : that.fileSystem == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessPointArn != null ? this.accessPointArn.hashCode() : 0;
            result = 31 * result + (this.accessPointId != null ? this.accessPointId.hashCode() : 0);
            result = 31 * result + (this.fileSystem != null ? this.fileSystem.hashCode() : 0);
            return result;
        }
    }
}
