package software.amazon.awscdk.services.elasticache;

/**
 * The resource representing a serverless cache.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * CfnServerlessCache cfnServerlessCache = CfnServerlessCache.Builder.create(this, "MyCfnServerlessCache")
 *         .engine("engine")
 *         .serverlessCacheName("serverlessCacheName")
 *         // the properties below are optional
 *         .cacheUsageLimits(CacheUsageLimitsProperty.builder()
 *                 .dataStorage(DataStorageProperty.builder()
 *                         .unit("unit")
 *                         // the properties below are optional
 *                         .maximum(123)
 *                         .minimum(123)
 *                         .build())
 *                 .ecpuPerSecond(ECPUPerSecondProperty.builder()
 *                         .maximum(123)
 *                         .minimum(123)
 *                         .build())
 *                 .build())
 *         .dailySnapshotTime("dailySnapshotTime")
 *         .description("description")
 *         .endpoint(EndpointProperty.builder()
 *                 .address("address")
 *                 .port("port")
 *                 .build())
 *         .finalSnapshotName("finalSnapshotName")
 *         .kmsKeyId("kmsKeyId")
 *         .majorEngineVersion("majorEngineVersion")
 *         .readerEndpoint(EndpointProperty.builder()
 *                 .address("address")
 *                 .port("port")
 *                 .build())
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .snapshotArnsToRestore(List.of("snapshotArnsToRestore"))
 *         .snapshotRetentionLimit(123)
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userGroupId("userGroupId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:57.467Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnServerlessCache")
public class CfnServerlessCache extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnServerlessCache(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnServerlessCache(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticache.CfnServerlessCache.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnServerlessCache(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticache.CfnServerlessCacheProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When the serverless cache was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DNS hostname of the cache node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number that the cache engine is listening on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name and version number of the engine the serverless cache is compatible with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFullEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrFullEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DNS hostname of the cache node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReaderEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrReaderEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number that the cache engine is listening on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReaderEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrReaderEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of the serverless cache.
     * <p>
     * The allowed values are CREATING, AVAILABLE, DELETING, CREATE-FAILED and MODIFYING.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The engine the serverless cache is compatible with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The engine the serverless cache is compatible with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", java.util.Objects.requireNonNull(value, "engine is required"));
    }

    /**
     * The unique identifier of the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServerlessCacheName() {
        return software.amazon.jsii.Kernel.get(this, "serverlessCacheName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerlessCacheName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverlessCacheName", java.util.Objects.requireNonNull(value, "serverlessCacheName is required"));
    }

    /**
     * The cache usage limit for the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCacheUsageLimits() {
        return software.amazon.jsii.Kernel.get(this, "cacheUsageLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The cache usage limit for the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheUsageLimits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cacheUsageLimits", value);
    }

    /**
     * The cache usage limit for the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheUsageLimits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticache.CfnServerlessCache.CacheUsageLimitsProperty value) {
        software.amazon.jsii.Kernel.set(this, "cacheUsageLimits", value);
    }

    /**
     * The daily time that a cache snapshot will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDailySnapshotTime() {
        return software.amazon.jsii.Kernel.get(this, "dailySnapshotTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The daily time that a cache snapshot will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDailySnapshotTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dailySnapshotTime", value);
    }

    /**
     * A description of the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Represents the information required for client programs to connect to a cache node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents the information required for client programs to connect to a cache node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpoint(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "endpoint", value);
    }

    /**
     * Represents the information required for client programs to connect to a cache node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpoint(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticache.CfnServerlessCache.EndpointProperty value) {
        software.amazon.jsii.Kernel.set(this, "endpoint", value);
    }

    /**
     * The name of the final snapshot taken of a cache before the cache is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFinalSnapshotName() {
        return software.amazon.jsii.Kernel.get(this, "finalSnapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the final snapshot taken of a cache before the cache is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFinalSnapshotName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "finalSnapshotName", value);
    }

    /**
     * The ID of the AWS Key Management Service (KMS) key that is used to encrypt data at rest in the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS Key Management Service (KMS) key that is used to encrypt data at rest in the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * The version number of the engine the serverless cache is compatible with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMajorEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "majorEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version number of the engine the serverless cache is compatible with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMajorEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "majorEngineVersion", value);
    }

    /**
     * Represents the information required for client programs to connect to a cache node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReaderEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "readerEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents the information required for client programs to connect to a cache node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReaderEndpoint(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "readerEndpoint", value);
    }

    /**
     * Represents the information required for client programs to connect to a cache node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReaderEndpoint(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticache.CfnServerlessCache.EndpointProperty value) {
        software.amazon.jsii.Kernel.set(this, "readerEndpoint", value);
    }

    /**
     * The IDs of the EC2 security groups associated with the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The IDs of the EC2 security groups associated with the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIds", value);
    }

    /**
     * The ARN of the snapshot from which to restore data into the new cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSnapshotArnsToRestore() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "snapshotArnsToRestore", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The ARN of the snapshot from which to restore data into the new cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotArnsToRestore(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "snapshotArnsToRestore", value);
    }

    /**
     * The current setting for the number of serverless cache snapshots the system will retain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSnapshotRetentionLimit() {
        return software.amazon.jsii.Kernel.get(this, "snapshotRetentionLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The current setting for the number of serverless cache snapshots the system will retain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotRetentionLimit(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "snapshotRetentionLimit", value);
    }

    /**
     * If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets across AZs in your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets across AZs in your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnetIds", value);
    }

    /**
     * A list of tags to be added to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of tags to be added to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The identifier of the user group associated with the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUserGroupId() {
        return software.amazon.jsii.Kernel.get(this, "userGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the user group associated with the serverless cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserGroupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userGroupId", value);
    }
    /**
     * The usage limits for storage and ElastiCache Processing Units for the cache.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * CacheUsageLimitsProperty cacheUsageLimitsProperty = CacheUsageLimitsProperty.builder()
     *         .dataStorage(DataStorageProperty.builder()
     *                 .unit("unit")
     *                 // the properties below are optional
     *                 .maximum(123)
     *                 .minimum(123)
     *                 .build())
     *         .ecpuPerSecond(ECPUPerSecondProperty.builder()
     *                 .maximum(123)
     *                 .minimum(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-cacheusagelimits.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-cacheusagelimits.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnServerlessCache.CacheUsageLimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(CacheUsageLimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CacheUsageLimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum data storage limit in the cache, expressed in Gigabytes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-cacheusagelimits.html#cfn-elasticache-serverlesscache-cacheusagelimits-datastorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-cacheusagelimits.html#cfn-elasticache-serverlesscache-cacheusagelimits-datastorage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataStorage() {
            return null;
        }

        /**
         * The number of ElastiCache Processing Units (ECPU) the cache can consume per second.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-cacheusagelimits.html#cfn-elasticache-serverlesscache-cacheusagelimits-ecpupersecond">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-cacheusagelimits.html#cfn-elasticache-serverlesscache-cacheusagelimits-ecpupersecond</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcpuPerSecond() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CacheUsageLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CacheUsageLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CacheUsageLimitsProperty> {
            java.lang.Object dataStorage;
            java.lang.Object ecpuPerSecond;

            /**
             * Sets the value of {@link CacheUsageLimitsProperty#getDataStorage}
             * @param dataStorage The maximum data storage limit in the cache, expressed in Gigabytes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataStorage(software.amazon.awscdk.IResolvable dataStorage) {
                this.dataStorage = dataStorage;
                return this;
            }

            /**
             * Sets the value of {@link CacheUsageLimitsProperty#getDataStorage}
             * @param dataStorage The maximum data storage limit in the cache, expressed in Gigabytes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataStorage(software.amazon.awscdk.services.elasticache.CfnServerlessCache.DataStorageProperty dataStorage) {
                this.dataStorage = dataStorage;
                return this;
            }

            /**
             * Sets the value of {@link CacheUsageLimitsProperty#getEcpuPerSecond}
             * @param ecpuPerSecond The number of ElastiCache Processing Units (ECPU) the cache can consume per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecpuPerSecond(software.amazon.awscdk.IResolvable ecpuPerSecond) {
                this.ecpuPerSecond = ecpuPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link CacheUsageLimitsProperty#getEcpuPerSecond}
             * @param ecpuPerSecond The number of ElastiCache Processing Units (ECPU) the cache can consume per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecpuPerSecond(software.amazon.awscdk.services.elasticache.CfnServerlessCache.ECPUPerSecondProperty ecpuPerSecond) {
                this.ecpuPerSecond = ecpuPerSecond;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CacheUsageLimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CacheUsageLimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CacheUsageLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CacheUsageLimitsProperty {
            private final java.lang.Object dataStorage;
            private final java.lang.Object ecpuPerSecond;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataStorage = software.amazon.jsii.Kernel.get(this, "dataStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecpuPerSecond = software.amazon.jsii.Kernel.get(this, "ecpuPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataStorage = builder.dataStorage;
                this.ecpuPerSecond = builder.ecpuPerSecond;
            }

            @Override
            public final java.lang.Object getDataStorage() {
                return this.dataStorage;
            }

            @Override
            public final java.lang.Object getEcpuPerSecond() {
                return this.ecpuPerSecond;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataStorage() != null) {
                    data.set("dataStorage", om.valueToTree(this.getDataStorage()));
                }
                if (this.getEcpuPerSecond() != null) {
                    data.set("ecpuPerSecond", om.valueToTree(this.getEcpuPerSecond()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnServerlessCache.CacheUsageLimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CacheUsageLimitsProperty.Jsii$Proxy that = (CacheUsageLimitsProperty.Jsii$Proxy) o;

                if (this.dataStorage != null ? !this.dataStorage.equals(that.dataStorage) : that.dataStorage != null) return false;
                return this.ecpuPerSecond != null ? this.ecpuPerSecond.equals(that.ecpuPerSecond) : that.ecpuPerSecond == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataStorage != null ? this.dataStorage.hashCode() : 0;
                result = 31 * result + (this.ecpuPerSecond != null ? this.ecpuPerSecond.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The data storage limit.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * DataStorageProperty dataStorageProperty = DataStorageProperty.builder()
     *         .unit("unit")
     *         // the properties below are optional
     *         .maximum(123)
     *         .minimum(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-datastorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-datastorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnServerlessCache.DataStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(DataStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unit that the storage is measured in, in GB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-datastorage.html#cfn-elasticache-serverlesscache-datastorage-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-datastorage.html#cfn-elasticache-serverlesscache-datastorage-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * The upper limit for data storage the cache is set to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-datastorage.html#cfn-elasticache-serverlesscache-datastorage-maximum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-datastorage.html#cfn-elasticache-serverlesscache-datastorage-maximum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximum() {
            return null;
        }

        /**
         * The lower limit for data storage the cache is set to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-datastorage.html#cfn-elasticache-serverlesscache-datastorage-minimum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-datastorage.html#cfn-elasticache-serverlesscache-datastorage-minimum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimum() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataStorageProperty> {
            java.lang.String unit;
            java.lang.Number maximum;
            java.lang.Number minimum;

            /**
             * Sets the value of {@link DataStorageProperty#getUnit}
             * @param unit The unit that the storage is measured in, in GB. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link DataStorageProperty#getMaximum}
             * @param maximum The upper limit for data storage the cache is set to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximum(java.lang.Number maximum) {
                this.maximum = maximum;
                return this;
            }

            /**
             * Sets the value of {@link DataStorageProperty#getMinimum}
             * @param minimum The lower limit for data storage the cache is set to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimum(java.lang.Number minimum) {
                this.minimum = minimum;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataStorageProperty {
            private final java.lang.String unit;
            private final java.lang.Number maximum;
            private final java.lang.Number minimum;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximum = software.amazon.jsii.Kernel.get(this, "maximum", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimum = software.amazon.jsii.Kernel.get(this, "minimum", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.maximum = builder.maximum;
                this.minimum = builder.minimum;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getMaximum() {
                return this.maximum;
            }

            @Override
            public final java.lang.Number getMinimum() {
                return this.minimum;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                if (this.getMaximum() != null) {
                    data.set("maximum", om.valueToTree(this.getMaximum()));
                }
                if (this.getMinimum() != null) {
                    data.set("minimum", om.valueToTree(this.getMinimum()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnServerlessCache.DataStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataStorageProperty.Jsii$Proxy that = (DataStorageProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                if (this.maximum != null ? !this.maximum.equals(that.maximum) : that.maximum != null) return false;
                return this.minimum != null ? this.minimum.equals(that.minimum) : that.minimum == null;
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.maximum != null ? this.maximum.hashCode() : 0);
                result = 31 * result + (this.minimum != null ? this.minimum.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * ECPUPerSecondProperty eCPUPerSecondProperty = ECPUPerSecondProperty.builder()
     *         .maximum(123)
     *         .minimum(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-ecpupersecond.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-ecpupersecond.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnServerlessCache.ECPUPerSecondProperty")
    @software.amazon.jsii.Jsii.Proxy(ECPUPerSecondProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ECPUPerSecondProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for the maximum number of ECPUs the cache can consume per second.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-ecpupersecond.html#cfn-elasticache-serverlesscache-ecpupersecond-maximum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-ecpupersecond.html#cfn-elasticache-serverlesscache-ecpupersecond-maximum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximum() {
            return null;
        }

        /**
         * The configuration for the minimum number of ECPUs the cache should be able consume per second.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-ecpupersecond.html#cfn-elasticache-serverlesscache-ecpupersecond-minimum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-ecpupersecond.html#cfn-elasticache-serverlesscache-ecpupersecond-minimum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimum() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ECPUPerSecondProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ECPUPerSecondProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ECPUPerSecondProperty> {
            java.lang.Number maximum;
            java.lang.Number minimum;

            /**
             * Sets the value of {@link ECPUPerSecondProperty#getMaximum}
             * @param maximum The configuration for the maximum number of ECPUs the cache can consume per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximum(java.lang.Number maximum) {
                this.maximum = maximum;
                return this;
            }

            /**
             * Sets the value of {@link ECPUPerSecondProperty#getMinimum}
             * @param minimum The configuration for the minimum number of ECPUs the cache should be able consume per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimum(java.lang.Number minimum) {
                this.minimum = minimum;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ECPUPerSecondProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ECPUPerSecondProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ECPUPerSecondProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ECPUPerSecondProperty {
            private final java.lang.Number maximum;
            private final java.lang.Number minimum;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximum = software.amazon.jsii.Kernel.get(this, "maximum", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimum = software.amazon.jsii.Kernel.get(this, "minimum", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximum = builder.maximum;
                this.minimum = builder.minimum;
            }

            @Override
            public final java.lang.Number getMaximum() {
                return this.maximum;
            }

            @Override
            public final java.lang.Number getMinimum() {
                return this.minimum;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaximum() != null) {
                    data.set("maximum", om.valueToTree(this.getMaximum()));
                }
                if (this.getMinimum() != null) {
                    data.set("minimum", om.valueToTree(this.getMinimum()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnServerlessCache.ECPUPerSecondProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ECPUPerSecondProperty.Jsii$Proxy that = (ECPUPerSecondProperty.Jsii$Proxy) o;

                if (this.maximum != null ? !this.maximum.equals(that.maximum) : that.maximum != null) return false;
                return this.minimum != null ? this.minimum.equals(that.minimum) : that.minimum == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximum != null ? this.maximum.hashCode() : 0;
                result = 31 * result + (this.minimum != null ? this.minimum.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the information required for client programs to connect to a cache node.
     * <p>
     * This value is read-only.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * EndpointProperty endpointProperty = EndpointProperty.builder()
     *         .address("address")
     *         .port("port")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-endpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-endpoint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnServerlessCache.EndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The DNS hostname of the cache node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-endpoint.html#cfn-elasticache-serverlesscache-endpoint-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-endpoint.html#cfn-elasticache-serverlesscache-endpoint-address</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
            return null;
        }

        /**
         * The port number that the cache engine is listening on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-endpoint.html#cfn-elasticache-serverlesscache-endpoint-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-serverlesscache-endpoint.html#cfn-elasticache-serverlesscache-endpoint-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointProperty> {
            java.lang.String address;
            java.lang.String port;

            /**
             * Sets the value of {@link EndpointProperty#getAddress}
             * @param address The DNS hostname of the cache node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link EndpointProperty#getPort}
             * @param port The port number that the cache engine is listening on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointProperty {
            private final java.lang.String address;
            private final java.lang.String port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = builder.address;
                this.port = builder.port;
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnServerlessCache.EndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointProperty.Jsii$Proxy that = (EndpointProperty.Jsii$Proxy) o;

                if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.address != null ? this.address.hashCode() : 0;
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticache.CfnServerlessCache}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticache.CfnServerlessCache> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticache.CfnServerlessCacheProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticache.CfnServerlessCacheProps.Builder();
        }

        /**
         * The engine the serverless cache is compatible with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-engine</a>
         * @param engine The engine the serverless cache is compatible with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * The unique identifier of the serverless cache.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-serverlesscachename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-serverlesscachename</a>
         * @param serverlessCacheName The unique identifier of the serverless cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessCacheName(final java.lang.String serverlessCacheName) {
            this.props.serverlessCacheName(serverlessCacheName);
            return this;
        }

        /**
         * The cache usage limit for the serverless cache.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-cacheusagelimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-cacheusagelimits</a>
         * @param cacheUsageLimits The cache usage limit for the serverless cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheUsageLimits(final software.amazon.awscdk.IResolvable cacheUsageLimits) {
            this.props.cacheUsageLimits(cacheUsageLimits);
            return this;
        }
        /**
         * The cache usage limit for the serverless cache.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-cacheusagelimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-cacheusagelimits</a>
         * @param cacheUsageLimits The cache usage limit for the serverless cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheUsageLimits(final software.amazon.awscdk.services.elasticache.CfnServerlessCache.CacheUsageLimitsProperty cacheUsageLimits) {
            this.props.cacheUsageLimits(cacheUsageLimits);
            return this;
        }

        /**
         * The daily time that a cache snapshot will be created.
         * <p>
         * Default is NULL, i.e. snapshots will not be created at a specific time on a daily basis. Available for Valkey, Redis OSS, and Serverless Memcached only.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-dailysnapshottime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-dailysnapshottime</a>
         * @param dailySnapshotTime The daily time that a cache snapshot will be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dailySnapshotTime(final java.lang.String dailySnapshotTime) {
            this.props.dailySnapshotTime(dailySnapshotTime);
            return this;
        }

        /**
         * A description of the serverless cache.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-description</a>
         * @param description A description of the serverless cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Represents the information required for client programs to connect to a cache node.
         * <p>
         * This value is read-only.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-endpoint</a>
         * @param endpoint Represents the information required for client programs to connect to a cache node. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(final software.amazon.awscdk.IResolvable endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }
        /**
         * Represents the information required for client programs to connect to a cache node.
         * <p>
         * This value is read-only.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-endpoint</a>
         * @param endpoint Represents the information required for client programs to connect to a cache node. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(final software.amazon.awscdk.services.elasticache.CfnServerlessCache.EndpointProperty endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        /**
         * The name of the final snapshot taken of a cache before the cache is deleted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-finalsnapshotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-finalsnapshotname</a>
         * @param finalSnapshotName The name of the final snapshot taken of a cache before the cache is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder finalSnapshotName(final java.lang.String finalSnapshotName) {
            this.props.finalSnapshotName(finalSnapshotName);
            return this;
        }

        /**
         * The ID of the AWS Key Management Service (KMS) key that is used to encrypt data at rest in the serverless cache.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-kmskeyid</a>
         * @param kmsKeyId The ID of the AWS Key Management Service (KMS) key that is used to encrypt data at rest in the serverless cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * The version number of the engine the serverless cache is compatible with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-majorengineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-majorengineversion</a>
         * @param majorEngineVersion The version number of the engine the serverless cache is compatible with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder majorEngineVersion(final java.lang.String majorEngineVersion) {
            this.props.majorEngineVersion(majorEngineVersion);
            return this;
        }

        /**
         * Represents the information required for client programs to connect to a cache node.
         * <p>
         * This value is read-only.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-readerendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-readerendpoint</a>
         * @param readerEndpoint Represents the information required for client programs to connect to a cache node. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readerEndpoint(final software.amazon.awscdk.IResolvable readerEndpoint) {
            this.props.readerEndpoint(readerEndpoint);
            return this;
        }
        /**
         * Represents the information required for client programs to connect to a cache node.
         * <p>
         * This value is read-only.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-readerendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-readerendpoint</a>
         * @param readerEndpoint Represents the information required for client programs to connect to a cache node. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readerEndpoint(final software.amazon.awscdk.services.elasticache.CfnServerlessCache.EndpointProperty readerEndpoint) {
            this.props.readerEndpoint(readerEndpoint);
            return this;
        }

        /**
         * The IDs of the EC2 security groups associated with the serverless cache.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-securitygroupids</a>
         * @param securityGroupIds The IDs of the EC2 security groups associated with the serverless cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * The ARN of the snapshot from which to restore data into the new cache.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-snapshotarnstorestore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-snapshotarnstorestore</a>
         * @param snapshotArnsToRestore The ARN of the snapshot from which to restore data into the new cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotArnsToRestore(final java.util.List<java.lang.String> snapshotArnsToRestore) {
            this.props.snapshotArnsToRestore(snapshotArnsToRestore);
            return this;
        }

        /**
         * The current setting for the number of serverless cache snapshots the system will retain.
         * <p>
         * Available for Valkey, Redis OSS, and Serverless Memcached only.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-snapshotretentionlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-snapshotretentionlimit</a>
         * @param snapshotRetentionLimit The current setting for the number of serverless cache snapshots the system will retain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotRetentionLimit(final java.lang.Number snapshotRetentionLimit) {
            this.props.snapshotRetentionLimit(snapshotRetentionLimit);
            return this;
        }

        /**
         * If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets across AZs in your VPC.
         * <p>
         * For all other Regions, if no subnet IDs are given then ElastiCache will select 3 default subnets across AZs in your default VPC.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-subnetids</a>
         * @param subnetIds If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets across AZs in your VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(final java.util.List<java.lang.String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        /**
         * A list of tags to be added to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-tags</a>
         * @param tags A list of tags to be added to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The identifier of the user group associated with the serverless cache.
         * <p>
         * Available for Valkey and Redis OSS only. Default is NULL.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-usergroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-serverlesscache.html#cfn-elasticache-serverlesscache-usergroupid</a>
         * @param userGroupId The identifier of the user group associated with the serverless cache. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userGroupId(final java.lang.String userGroupId) {
            this.props.userGroupId(userGroupId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticache.CfnServerlessCache}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticache.CfnServerlessCache build() {
            return new software.amazon.awscdk.services.elasticache.CfnServerlessCache(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
