package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define a new network load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpNlbIntegration;
 * Vpc vpc = new Vpc(this, "VPC");
 * NetworkLoadBalancer lb = NetworkLoadBalancer.Builder.create(this, "lb").vpc(vpc).build();
 * NetworkListener listener = lb.addListener("listener", BaseNetworkListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddNetworkTargetsProps.builder()
 *         .port(80)
 *         .build());
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(new HttpNlbIntegration("DefaultIntegration", listener))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:57.660Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer")
public class NetworkLoadBalancer extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer implements software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer {

    protected NetworkLoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkLoadBalancer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Looks up the network load balancer.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer fromNetworkLoadBalancerAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer.class, "fromNetworkLoadBalancerAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add a listener to this load balancer.
     * <p>
     * @return The newly created listener
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener addListener(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.BaseNetworkListenerProps props) {
        return software.amazon.jsii.Kernel.call(this, "addListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a security group to this load balancer.
     * <p>
     * @param securityGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        software.amazon.jsii.Kernel.call(this, "addSecurityGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * (deprecated) Return the given named metric for this Network Load Balancer.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.custom</code> instead
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * (deprecated) Return the given named metric for this Network Load Balancer.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.custom</code> instead
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * (deprecated) The total number of concurrent TCP flows (or connections) from clients to targets.
     * <p>
     * This metric includes connections in the SYN_SENT and ESTABLISHED states.
     * TCP connections are not terminated at the load balancer, so a client
     * opening a TCP connection to a target counts as a single flow.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.activeFlowCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricActiveFlowCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricActiveFlowCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The total number of concurrent TCP flows (or connections) from clients to targets.
     * <p>
     * This metric includes connections in the SYN_SENT and ESTABLISHED states.
     * TCP connections are not terminated at the load balancer, so a client
     * opening a TCP connection to a target counts as a single flow.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.activeFlowCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricActiveFlowCount() {
        return software.amazon.jsii.Kernel.call(this, "metricActiveFlowCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The number of load balancer capacity units (LCU) used by your load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.activeFlowCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedLCUs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedLCUs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The number of load balancer capacity units (LCU) used by your load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.activeFlowCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedLCUs() {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedLCUs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The total number of new TCP flows (or connections) established from clients to targets in the time period.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.newFlowCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNewFlowCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricNewFlowCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The total number of new TCP flows (or connections) established from clients to targets in the time period.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.newFlowCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNewFlowCount() {
        return software.amazon.jsii.Kernel.call(this, "metricNewFlowCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The total number of bytes processed by the load balancer, including TCP/IP headers.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.processedBytes</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProcessedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The total number of bytes processed by the load balancer, including TCP/IP headers.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.processedBytes</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProcessedBytes() {
        return software.amazon.jsii.Kernel.call(this, "metricProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The total number of reset (RST) packets sent from a client to a target.
     * <p>
     * These resets are generated by the client and forwarded by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.tcpClientResetCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpClientResetCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTcpClientResetCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The total number of reset (RST) packets sent from a client to a target.
     * <p>
     * These resets are generated by the client and forwarded by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.tcpClientResetCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpClientResetCount() {
        return software.amazon.jsii.Kernel.call(this, "metricTcpClientResetCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The total number of reset (RST) packets generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.tcpElbResetCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpElbResetCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTcpElbResetCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The total number of reset (RST) packets generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.tcpElbResetCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpElbResetCount() {
        return software.amazon.jsii.Kernel.call(this, "metricTcpElbResetCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) The total number of reset (RST) packets sent from a target to a client.
     * <p>
     * These resets are generated by the target and forwarded by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.tcpTargetResetCount</code> instead
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpTargetResetCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTcpTargetResetCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) The total number of reset (RST) packets sent from a target to a client.
     * <p>
     * These resets are generated by the target and forwarded by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @deprecated Use <code>NetworkLoadBalancer.metrics.tcpTargetResetCount</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpTargetResetCount() {
        return software.amazon.jsii.Kernel.call(this, "metricTcpTargetResetCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The network connections associated with this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * All metrics available for this load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerMetrics getMetrics() {
        return software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerMetrics.class));
    }

    /**
     * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through AWS PrivateLink.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
        return software.amazon.jsii.Kernel.get(this, "enforceSecurityGroupInboundRulesOnPrivateLinkTraffic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of IP addresses to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
        return software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType.class));
    }

    /**
     * After the implementation of <code>IConnectable</code> (see https://github.com/aws/aws-cdk/pull/28494), the default value for <code>securityGroups</code> is set by the <code>ec2.Connections</code> constructor to an empty array. To keep backward compatibility (<code>securityGroups</code> is <code>undefined</code> if the related property is not specified) a getter has been added.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerProps.Builder();
        }

        /**
         * The VPC network to place the load balancer in.
         * <p>
         * @return {@code this}
         * @param vpc The VPC network to place the load balancer in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Indicates whether cross-zone load balancing is enabled.
         * <p>
         * Default: - false for Network Load Balancers and true for Application Load Balancers.
         * This can not be `false` for Application Load Balancers.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattribute.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattribute.html</a>
         * @param crossZoneEnabled Indicates whether cross-zone load balancing is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZoneEnabled(final java.lang.Boolean crossZoneEnabled) {
            this.props.crossZoneEnabled(crossZoneEnabled);
            return this;
        }

        /**
         * Indicates whether deletion protection is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deletionProtection Indicates whether deletion protection is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Indicates whether the load balancer blocks traffic through the Internet Gateway (IGW).
         * <p>
         * Default: - false for internet-facing load balancers and true for internal load balancers
         * <p>
         * @return {@code this}
         * @param denyAllIgwTraffic Indicates whether the load balancer blocks traffic through the Internet Gateway (IGW). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder denyAllIgwTraffic(final java.lang.Boolean denyAllIgwTraffic) {
            this.props.denyAllIgwTraffic(denyAllIgwTraffic);
            return this;
        }

        /**
         * Whether the load balancer has an internet-routable address.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param internetFacing Whether the load balancer has an internet-routable address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(final java.lang.Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        /**
         * Name of the load balancer.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param loadBalancerName Name of the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(final java.lang.String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        /**
         * Which subnets place the load balancer in.
         * <p>
         * Default: - the Vpc default strategy.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Which subnets place the load balancer in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * The AZ affinity routing policy.
         * <p>
         * Default: - AZ affinity is disabled.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity">https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity</a>
         * @param clientRoutingPolicy The AZ affinity routing policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientRoutingPolicy(final software.amazon.awscdk.services.elasticloadbalancingv2.ClientRoutingPolicy clientRoutingPolicy) {
            this.props.clientRoutingPolicy(clientRoutingPolicy);
            return this;
        }

        /**
         * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through AWS PrivateLink.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enforceSecurityGroupInboundRulesOnPrivateLinkTraffic Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through AWS PrivateLink. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(final java.lang.Boolean enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.props.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);
            return this;
        }

        /**
         * The type of IP addresses to use.
         * <p>
         * If you want to add a UDP or TCP_UDP listener to the load balancer,
         * you must choose IPv4.
         * <p>
         * Default: IpAddressType.IPV4
         * <p>
         * @return {@code this}
         * @param ipAddressType The type of IP addresses to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        /**
         * Security groups to associate with this load balancer.
         * <p>
         * Default: - No security groups associated with the load balancer.
         * <p>
         * @return {@code this}
         * @param securityGroups Security groups to associate with this load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Indicates whether zonal shift is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/zonal-shift.html">https://docs.aws.amazon.com/elasticloadbalancing/latest/network/zonal-shift.html</a>
         * @param zonalShift Indicates whether zonal shift is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zonalShift(final java.lang.Boolean zonalShift) {
            this.props.zonalShift(zonalShift);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
