package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Load balancing algorithmm type for target groups.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ApplicationTargetGroup tg = ApplicationTargetGroup.Builder.create(this, "TargetGroup")
 *         .vpc(vpc)
 *         .loadBalancingAlgorithmType(TargetGroupLoadBalancingAlgorithmType.WEIGHTED_RANDOM)
 *         .enableAnomalyMitigation(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:57.670Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.TargetGroupLoadBalancingAlgorithmType")
public enum TargetGroupLoadBalancingAlgorithmType {
    /**
     * round_robin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ROUND_ROBIN,
    /**
     * least_outstanding_requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LEAST_OUTSTANDING_REQUESTS,
    /**
     * weighted_random.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WEIGHTED_RANDOM,
}
