package software.amazon.awscdk.services.gamelift;

/**
 * Properties for defining a <code>CfnContainerGroupDefinition</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnContainerGroupDefinitionProps cfnContainerGroupDefinitionProps = CfnContainerGroupDefinitionProps.builder()
 *         .name("name")
 *         .operatingSystem("operatingSystem")
 *         .totalMemoryLimitMebibytes(123)
 *         .totalVcpuLimit(123)
 *         // the properties below are optional
 *         .containerGroupType("containerGroupType")
 *         .gameServerContainerDefinition(GameServerContainerDefinitionProperty.builder()
 *                 .containerName("containerName")
 *                 .imageUri("imageUri")
 *                 .serverSdkVersion("serverSdkVersion")
 *                 // the properties below are optional
 *                 .dependsOn(List.of(ContainerDependencyProperty.builder()
 *                         .condition("condition")
 *                         .containerName("containerName")
 *                         .build()))
 *                 .environmentOverride(List.of(ContainerEnvironmentProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .mountPoints(List.of(ContainerMountPointProperty.builder()
 *                         .instancePath("instancePath")
 *                         // the properties below are optional
 *                         .accessLevel("accessLevel")
 *                         .containerPath("containerPath")
 *                         .build()))
 *                 .portConfiguration(PortConfigurationProperty.builder()
 *                         .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
 *                                 .fromPort(123)
 *                                 .protocol("protocol")
 *                                 .toPort(123)
 *                                 .build()))
 *                         .build())
 *                 .resolvedImageDigest("resolvedImageDigest")
 *                 .build())
 *         .sourceVersionNumber(123)
 *         .supportContainerDefinitions(List.of(SupportContainerDefinitionProperty.builder()
 *                 .containerName("containerName")
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .dependsOn(List.of(ContainerDependencyProperty.builder()
 *                         .condition("condition")
 *                         .containerName("containerName")
 *                         .build()))
 *                 .environmentOverride(List.of(ContainerEnvironmentProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .essential(false)
 *                 .healthCheck(ContainerHealthCheckProperty.builder()
 *                         .command(List.of("command"))
 *                         // the properties below are optional
 *                         .interval(123)
 *                         .retries(123)
 *                         .startPeriod(123)
 *                         .timeout(123)
 *                         .build())
 *                 .memoryHardLimitMebibytes(123)
 *                 .mountPoints(List.of(ContainerMountPointProperty.builder()
 *                         .instancePath("instancePath")
 *                         // the properties below are optional
 *                         .accessLevel("accessLevel")
 *                         .containerPath("containerPath")
 *                         .build()))
 *                 .portConfiguration(PortConfigurationProperty.builder()
 *                         .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
 *                                 .fromPort(123)
 *                                 .protocol("protocol")
 *                                 .toPort(123)
 *                                 .build()))
 *                         .build())
 *                 .resolvedImageDigest("resolvedImageDigest")
 *                 .vcpu(123)
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .versionDescription("versionDescription")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:58.218Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnContainerGroupDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnContainerGroupDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A descriptive identifier for the container group definition.
     * <p>
     * The name value is unique in an AWS Region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The platform that all containers in the container group definition run on.
     * <p>
     * <blockquote>
     * <p>
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a href="https://docs.aws.amazon.com/https://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a> . For game servers that are hosted on AL2 and use Amazon GameLift server SDK 4.x, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">Migrate to Amazon GameLift server SDK version 5.</a>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-operatingsystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-operatingsystem</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOperatingSystem();

    /**
     * The amount of memory (in MiB) on a fleet instance to allocate for the container group.
     * <p>
     * All containers in the group share these resources.
     * <p>
     * You can set a limit for each container definition in the group. If individual containers have limits, this total value must be greater than any individual container's memory limit.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalmemorylimitmebibytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalmemorylimitmebibytes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getTotalMemoryLimitMebibytes();

    /**
     * The amount of vCPU units on a fleet instance to allocate for the container group (1 vCPU is equal to 1024 CPU units).
     * <p>
     * All containers in the group share these resources. You can set a limit for each container definition in the group. If individual containers have limits, this total value must be equal to or greater than the sum of the limits for each container in the group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalvcpulimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalvcpulimit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getTotalVcpuLimit();

    /**
     * The type of container group.
     * <p>
     * Container group type determines how Amazon GameLift deploys the container group on each fleet instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-containergrouptype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-containergrouptype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerGroupType() {
        return null;
    }

    /**
     * The definition for the game server container in this group.
     * <p>
     * This property is used only when the container group type is <code>GAME_SERVER</code> . This container definition specifies a container image with the game server build.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-gameservercontainerdefinition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGameServerContainerDefinition() {
        return null;
    }

    /**
     * A specific ContainerGroupDefinition version to be updated.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-sourceversionnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-sourceversionnumber</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSourceVersionNumber() {
        return null;
    }

    /**
     * The set of definitions for support containers in this group.
     * <p>
     * A container group definition might have zero support container definitions. Support container can be used in any type of container group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-supportcontainerdefinitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSupportContainerDefinitions() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * An optional description that was provided for a container group definition update.
     * <p>
     * Each version can have a unique description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-versiondescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-versiondescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnContainerGroupDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnContainerGroupDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnContainerGroupDefinitionProps> {
        java.lang.String name;
        java.lang.String operatingSystem;
        java.lang.Number totalMemoryLimitMebibytes;
        java.lang.Number totalVcpuLimit;
        java.lang.String containerGroupType;
        java.lang.Object gameServerContainerDefinition;
        java.lang.Number sourceVersionNumber;
        java.lang.Object supportContainerDefinitions;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String versionDescription;

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getName}
         * @param name A descriptive identifier for the container group definition. This parameter is required.
         *             The name value is unique in an AWS Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getOperatingSystem}
         * @param operatingSystem The platform that all containers in the container group definition run on. This parameter is required.
         *                        <blockquote>
         *                        <p>
         *                        Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a href="https://docs.aws.amazon.com/https://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a> . For game servers that are hosted on AL2 and use Amazon GameLift server SDK 4.x, first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">Migrate to Amazon GameLift server SDK version 5.</a>
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatingSystem(java.lang.String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getTotalMemoryLimitMebibytes}
         * @param totalMemoryLimitMebibytes The amount of memory (in MiB) on a fleet instance to allocate for the container group. This parameter is required.
         *                                  All containers in the group share these resources.
         *                                  <p>
         *                                  You can set a limit for each container definition in the group. If individual containers have limits, this total value must be greater than any individual container's memory limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalMemoryLimitMebibytes(java.lang.Number totalMemoryLimitMebibytes) {
            this.totalMemoryLimitMebibytes = totalMemoryLimitMebibytes;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getTotalVcpuLimit}
         * @param totalVcpuLimit The amount of vCPU units on a fleet instance to allocate for the container group (1 vCPU is equal to 1024 CPU units). This parameter is required.
         *                       All containers in the group share these resources. You can set a limit for each container definition in the group. If individual containers have limits, this total value must be equal to or greater than the sum of the limits for each container in the group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalVcpuLimit(java.lang.Number totalVcpuLimit) {
            this.totalVcpuLimit = totalVcpuLimit;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getContainerGroupType}
         * @param containerGroupType The type of container group.
         *                           Container group type determines how Amazon GameLift deploys the container group on each fleet instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerGroupType(java.lang.String containerGroupType) {
            this.containerGroupType = containerGroupType;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getGameServerContainerDefinition}
         * @param gameServerContainerDefinition The definition for the game server container in this group.
         *                                      This property is used only when the container group type is <code>GAME_SERVER</code> . This container definition specifies a container image with the game server build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameServerContainerDefinition(software.amazon.awscdk.IResolvable gameServerContainerDefinition) {
            this.gameServerContainerDefinition = gameServerContainerDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getGameServerContainerDefinition}
         * @param gameServerContainerDefinition The definition for the game server container in this group.
         *                                      This property is used only when the container group type is <code>GAME_SERVER</code> . This container definition specifies a container image with the game server build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameServerContainerDefinition(software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.GameServerContainerDefinitionProperty gameServerContainerDefinition) {
            this.gameServerContainerDefinition = gameServerContainerDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getSourceVersionNumber}
         * @param sourceVersionNumber A specific ContainerGroupDefinition version to be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceVersionNumber(java.lang.Number sourceVersionNumber) {
            this.sourceVersionNumber = sourceVersionNumber;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getSupportContainerDefinitions}
         * @param supportContainerDefinitions The set of definitions for support containers in this group.
         *                                    A container group definition might have zero support container definitions. Support container can be used in any type of container group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportContainerDefinitions(software.amazon.awscdk.IResolvable supportContainerDefinitions) {
            this.supportContainerDefinitions = supportContainerDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getSupportContainerDefinitions}
         * @param supportContainerDefinitions The set of definitions for support containers in this group.
         *                                    A container group definition might have zero support container definitions. Support container can be used in any type of container group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportContainerDefinitions(java.util.List<? extends java.lang.Object> supportContainerDefinitions) {
            this.supportContainerDefinitions = supportContainerDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getVersionDescription}
         * @param versionDescription An optional description that was provided for a container group definition update.
         *                           Each version can have a unique description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(java.lang.String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnContainerGroupDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnContainerGroupDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnContainerGroupDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnContainerGroupDefinitionProps {
        private final java.lang.String name;
        private final java.lang.String operatingSystem;
        private final java.lang.Number totalMemoryLimitMebibytes;
        private final java.lang.Number totalVcpuLimit;
        private final java.lang.String containerGroupType;
        private final java.lang.Object gameServerContainerDefinition;
        private final java.lang.Number sourceVersionNumber;
        private final java.lang.Object supportContainerDefinitions;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String versionDescription;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.operatingSystem = software.amazon.jsii.Kernel.get(this, "operatingSystem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.totalMemoryLimitMebibytes = software.amazon.jsii.Kernel.get(this, "totalMemoryLimitMebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.totalVcpuLimit = software.amazon.jsii.Kernel.get(this, "totalVcpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.containerGroupType = software.amazon.jsii.Kernel.get(this, "containerGroupType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gameServerContainerDefinition = software.amazon.jsii.Kernel.get(this, "gameServerContainerDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceVersionNumber = software.amazon.jsii.Kernel.get(this, "sourceVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.supportContainerDefinitions = software.amazon.jsii.Kernel.get(this, "supportContainerDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.versionDescription = software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.operatingSystem = java.util.Objects.requireNonNull(builder.operatingSystem, "operatingSystem is required");
            this.totalMemoryLimitMebibytes = java.util.Objects.requireNonNull(builder.totalMemoryLimitMebibytes, "totalMemoryLimitMebibytes is required");
            this.totalVcpuLimit = java.util.Objects.requireNonNull(builder.totalVcpuLimit, "totalVcpuLimit is required");
            this.containerGroupType = builder.containerGroupType;
            this.gameServerContainerDefinition = builder.gameServerContainerDefinition;
            this.sourceVersionNumber = builder.sourceVersionNumber;
            this.supportContainerDefinitions = builder.supportContainerDefinitions;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.versionDescription = builder.versionDescription;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final java.lang.Number getTotalMemoryLimitMebibytes() {
            return this.totalMemoryLimitMebibytes;
        }

        @Override
        public final java.lang.Number getTotalVcpuLimit() {
            return this.totalVcpuLimit;
        }

        @Override
        public final java.lang.String getContainerGroupType() {
            return this.containerGroupType;
        }

        @Override
        public final java.lang.Object getGameServerContainerDefinition() {
            return this.gameServerContainerDefinition;
        }

        @Override
        public final java.lang.Number getSourceVersionNumber() {
            return this.sourceVersionNumber;
        }

        @Override
        public final java.lang.Object getSupportContainerDefinitions() {
            return this.supportContainerDefinitions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVersionDescription() {
            return this.versionDescription;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("operatingSystem", om.valueToTree(this.getOperatingSystem()));
            data.set("totalMemoryLimitMebibytes", om.valueToTree(this.getTotalMemoryLimitMebibytes()));
            data.set("totalVcpuLimit", om.valueToTree(this.getTotalVcpuLimit()));
            if (this.getContainerGroupType() != null) {
                data.set("containerGroupType", om.valueToTree(this.getContainerGroupType()));
            }
            if (this.getGameServerContainerDefinition() != null) {
                data.set("gameServerContainerDefinition", om.valueToTree(this.getGameServerContainerDefinition()));
            }
            if (this.getSourceVersionNumber() != null) {
                data.set("sourceVersionNumber", om.valueToTree(this.getSourceVersionNumber()));
            }
            if (this.getSupportContainerDefinitions() != null) {
                data.set("supportContainerDefinitions", om.valueToTree(this.getSupportContainerDefinitions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVersionDescription() != null) {
                data.set("versionDescription", om.valueToTree(this.getVersionDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnContainerGroupDefinitionProps.Jsii$Proxy that = (CfnContainerGroupDefinitionProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!operatingSystem.equals(that.operatingSystem)) return false;
            if (!totalMemoryLimitMebibytes.equals(that.totalMemoryLimitMebibytes)) return false;
            if (!totalVcpuLimit.equals(that.totalVcpuLimit)) return false;
            if (this.containerGroupType != null ? !this.containerGroupType.equals(that.containerGroupType) : that.containerGroupType != null) return false;
            if (this.gameServerContainerDefinition != null ? !this.gameServerContainerDefinition.equals(that.gameServerContainerDefinition) : that.gameServerContainerDefinition != null) return false;
            if (this.sourceVersionNumber != null ? !this.sourceVersionNumber.equals(that.sourceVersionNumber) : that.sourceVersionNumber != null) return false;
            if (this.supportContainerDefinitions != null ? !this.supportContainerDefinitions.equals(that.supportContainerDefinitions) : that.supportContainerDefinitions != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.versionDescription != null ? this.versionDescription.equals(that.versionDescription) : that.versionDescription == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.operatingSystem.hashCode());
            result = 31 * result + (this.totalMemoryLimitMebibytes.hashCode());
            result = 31 * result + (this.totalVcpuLimit.hashCode());
            result = 31 * result + (this.containerGroupType != null ? this.containerGroupType.hashCode() : 0);
            result = 31 * result + (this.gameServerContainerDefinition != null ? this.gameServerContainerDefinition.hashCode() : 0);
            result = 31 * result + (this.sourceVersionNumber != null ? this.sourceVersionNumber.hashCode() : 0);
            result = 31 * result + (this.supportContainerDefinitions != null ? this.supportContainerDefinitions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.versionDescription != null ? this.versionDescription.hashCode() : 0);
            return result;
        }
    }
}
