package software.amazon.awscdk.services.iam;

/**
 * Options for a service principal.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * Object conditions;
 * ServicePrincipalOpts servicePrincipalOpts = ServicePrincipalOpts.builder()
 *         .conditions(Map.of(
 *                 "conditionsKey", conditions))
 *         .region("region")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:58.712Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.ServicePrincipalOpts")
@software.amazon.jsii.Jsii.Proxy(ServicePrincipalOpts.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServicePrincipalOpts extends software.amazon.jsii.JsiiSerializable {

    /**
     * Additional conditions to add to the Service Principal.
     * <p>
     * Default: - No conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getConditions() {
        return null;
    }

    /**
     * The region in which you want to reference the service.
     * <p>
     * This is only necessary for <em>cross-region</em> references to <em>opt-in</em> regions. In those
     * cases, the region name needs to be included to reference the correct service principal.
     * In all other cases, the global service principal name is sufficient.
     * <p>
     * This field behaves differently depending on whether the <code>&#64;aws-cdk/aws-iam:standardizedServicePrincipals</code>
     * flag is set or not:
     * <p>
     * <ul>
     * <li>If the flag is set, the input service principal is assumed to be of the form <code>SERVICE.amazonaws.com</code>.
     * That value will always be returned, unless the given region is an opt-in region and the service
     * principal is rendered in a stack in a different region, in which case <code>SERVICE.REGION.amazonaws.com</code>
     * will be rendered. Under this regime, there is no downside to always specifying the region property:
     * it will be rendered only if necessary.</li>
     * <li>If the flag is not set, the service principal will resolve to a single principal
     * whose name comes from the <code>&#64;aws-cdk/region-info</code> package, using the region to override
     * the stack region. If there is no entry for this service principal in the database,, the input
     * service name is returned literally. This is legacy behavior and is not recommended.</li>
     * </ul>
     * <p>
     * Default: - the resolving Stack's region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServicePrincipalOpts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServicePrincipalOpts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServicePrincipalOpts> {
        java.util.Map<java.lang.String, java.lang.Object> conditions;
        java.lang.String region;

        /**
         * Sets the value of {@link ServicePrincipalOpts#getConditions}
         * @param conditions Additional conditions to add to the Service Principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.Map<java.lang.String, ? extends java.lang.Object> conditions) {
            this.conditions = (java.util.Map<java.lang.String, java.lang.Object>)conditions;
            return this;
        }

        /**
         * Sets the value of {@link ServicePrincipalOpts#getRegion}
         * @param region The region in which you want to reference the service.
         *               This is only necessary for <em>cross-region</em> references to <em>opt-in</em> regions. In those
         *               cases, the region name needs to be included to reference the correct service principal.
         *               In all other cases, the global service principal name is sufficient.
         *               <p>
         *               This field behaves differently depending on whether the <code>&#64;aws-cdk/aws-iam:standardizedServicePrincipals</code>
         *               flag is set or not:
         *               <p>
         *               <ul>
         *               <li>If the flag is set, the input service principal is assumed to be of the form <code>SERVICE.amazonaws.com</code>.
         *               That value will always be returned, unless the given region is an opt-in region and the service
         *               principal is rendered in a stack in a different region, in which case <code>SERVICE.REGION.amazonaws.com</code>
         *               will be rendered. Under this regime, there is no downside to always specifying the region property:
         *               it will be rendered only if necessary.</li>
         *               <li>If the flag is not set, the service principal will resolve to a single principal
         *               whose name comes from the <code>&#64;aws-cdk/region-info</code> package, using the region to override
         *               the stack region. If there is no entry for this service principal in the database,, the input
         *               service name is returned literally. This is legacy behavior and is not recommended.</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServicePrincipalOpts}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServicePrincipalOpts build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServicePrincipalOpts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServicePrincipalOpts {
        private final java.util.Map<java.lang.String, java.lang.Object> conditions;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.conditions = (java.util.Map<java.lang.String, java.lang.Object>)builder.conditions;
            this.region = builder.region;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getConditions() {
            return this.conditions;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.ServicePrincipalOpts"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServicePrincipalOpts.Jsii$Proxy that = (ServicePrincipalOpts.Jsii$Proxy) o;

            if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public final int hashCode() {
            int result = this.conditions != null ? this.conditions.hashCode() : 0;
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
