package software.amazon.awscdk.services.inspector;

/**
 * Properties for defining a <code>CfnAssessmentTarget</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.inspector.*;
 * CfnAssessmentTargetProps cfnAssessmentTargetProps = CfnAssessmentTargetProps.builder()
 *         .assessmentTargetName("assessmentTargetName")
 *         .resourceGroupArn("resourceGroupArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttarget.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:58.785Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspector.CfnAssessmentTargetProps")
@software.amazon.jsii.Jsii.Proxy(CfnAssessmentTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAssessmentTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Amazon Inspector assessment target.
     * <p>
     * The name must be unique within the AWS account .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttarget.html#cfn-inspector-assessmenttarget-assessmenttargetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttarget.html#cfn-inspector-assessmenttarget-assessmenttargetname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssessmentTargetName() {
        return null;
    }

    /**
     * The ARN that specifies the resource group that is used to create the assessment target.
     * <p>
     * If <code>resourceGroupArn</code> is not specified, all EC2 instances in the current AWS account and Region are included in the assessment target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttarget.html#cfn-inspector-assessmenttarget-resourcegrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspector-assessmenttarget.html#cfn-inspector-assessmenttarget-resourcegrouparn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceGroupArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAssessmentTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAssessmentTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAssessmentTargetProps> {
        java.lang.String assessmentTargetName;
        java.lang.String resourceGroupArn;

        /**
         * Sets the value of {@link CfnAssessmentTargetProps#getAssessmentTargetName}
         * @param assessmentTargetName The name of the Amazon Inspector assessment target.
         *                             The name must be unique within the AWS account .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assessmentTargetName(java.lang.String assessmentTargetName) {
            this.assessmentTargetName = assessmentTargetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssessmentTargetProps#getResourceGroupArn}
         * @param resourceGroupArn The ARN that specifies the resource group that is used to create the assessment target.
         *                         If <code>resourceGroupArn</code> is not specified, all EC2 instances in the current AWS account and Region are included in the assessment target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceGroupArn(java.lang.String resourceGroupArn) {
            this.resourceGroupArn = resourceGroupArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAssessmentTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAssessmentTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAssessmentTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAssessmentTargetProps {
        private final java.lang.String assessmentTargetName;
        private final java.lang.String resourceGroupArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assessmentTargetName = software.amazon.jsii.Kernel.get(this, "assessmentTargetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceGroupArn = software.amazon.jsii.Kernel.get(this, "resourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assessmentTargetName = builder.assessmentTargetName;
            this.resourceGroupArn = builder.resourceGroupArn;
        }

        @Override
        public final java.lang.String getAssessmentTargetName() {
            return this.assessmentTargetName;
        }

        @Override
        public final java.lang.String getResourceGroupArn() {
            return this.resourceGroupArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssessmentTargetName() != null) {
                data.set("assessmentTargetName", om.valueToTree(this.getAssessmentTargetName()));
            }
            if (this.getResourceGroupArn() != null) {
                data.set("resourceGroupArn", om.valueToTree(this.getResourceGroupArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspector.CfnAssessmentTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAssessmentTargetProps.Jsii$Proxy that = (CfnAssessmentTargetProps.Jsii$Proxy) o;

            if (this.assessmentTargetName != null ? !this.assessmentTargetName.equals(that.assessmentTargetName) : that.assessmentTargetName != null) return false;
            return this.resourceGroupArn != null ? this.resourceGroupArn.equals(that.resourceGroupArn) : that.resourceGroupArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assessmentTargetName != null ? this.assessmentTargetName.hashCode() : 0;
            result = 31 * result + (this.resourceGroupArn != null ? this.resourceGroupArn.hashCode() : 0);
            return result;
        }
    }
}
