package software.amazon.awscdk.services.iotevents;

/**
 * Properties for defining a <code>CfnAlarmModel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotevents.*;
 * CfnAlarmModelProps cfnAlarmModelProps = CfnAlarmModelProps.builder()
 *         .alarmRule(AlarmRuleProperty.builder()
 *                 .simpleRule(SimpleRuleProperty.builder()
 *                         .comparisonOperator("comparisonOperator")
 *                         .inputProperty("inputProperty")
 *                         .threshold("threshold")
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .alarmCapabilities(AlarmCapabilitiesProperty.builder()
 *                 .acknowledgeFlow(AcknowledgeFlowProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .initializationConfiguration(InitializationConfigurationProperty.builder()
 *                         .disabledOnInitialization(false)
 *                         .build())
 *                 .build())
 *         .alarmEventActions(AlarmEventActionsProperty.builder()
 *                 .alarmActions(List.of(AlarmActionProperty.builder()
 *                         .dynamoDb(DynamoDBProperty.builder()
 *                                 .hashKeyField("hashKeyField")
 *                                 .hashKeyValue("hashKeyValue")
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .hashKeyType("hashKeyType")
 *                                 .operation("operation")
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .payloadField("payloadField")
 *                                 .rangeKeyField("rangeKeyField")
 *                                 .rangeKeyType("rangeKeyType")
 *                                 .rangeKeyValue("rangeKeyValue")
 *                                 .build())
 *                         .dynamoDBv2(DynamoDBv2Property.builder()
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .firehose(FirehoseProperty.builder()
 *                                 .deliveryStreamName("deliveryStreamName")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .separator("separator")
 *                                 .build())
 *                         .iotEvents(IotEventsProperty.builder()
 *                                 .inputName("inputName")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .iotSiteWise(IotSiteWiseProperty.builder()
 *                                 .assetId("assetId")
 *                                 .entryId("entryId")
 *                                 .propertyAlias("propertyAlias")
 *                                 .propertyId("propertyId")
 *                                 .propertyValue(AssetPropertyValueProperty.builder()
 *                                         .value(AssetPropertyVariantProperty.builder()
 *                                                 .booleanValue("booleanValue")
 *                                                 .doubleValue("doubleValue")
 *                                                 .integerValue("integerValue")
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .quality("quality")
 *                                         .timestamp(AssetPropertyTimestampProperty.builder()
 *                                                 .timeInSeconds("timeInSeconds")
 *                                                 // the properties below are optional
 *                                                 .offsetInNanos("offsetInNanos")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .iotTopicPublish(IotTopicPublishProperty.builder()
 *                                 .mqttTopic("mqttTopic")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .lambda(LambdaProperty.builder()
 *                                 .functionArn("functionArn")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .sns(SnsProperty.builder()
 *                                 .targetArn("targetArn")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .sqs(SqsProperty.builder()
 *                                 .queueUrl("queueUrl")
 *                                 // the properties below are optional
 *                                 .payload(PayloadProperty.builder()
 *                                         .contentExpression("contentExpression")
 *                                         .type("type")
 *                                         .build())
 *                                 .useBase64(false)
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .alarmModelDescription("alarmModelDescription")
 *         .alarmModelName("alarmModelName")
 *         .key("key")
 *         .severity(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:59.028Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnAlarmModelProps")
@software.amazon.jsii.Jsii.Proxy(CfnAlarmModelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAlarmModelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Defines when your alarm is invoked.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmrule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAlarmRule();

    /**
     * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <em>AWS General Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Contains the configuration information of alarm state changes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmcapabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmcapabilities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAlarmCapabilities() {
        return null;
    }

    /**
     * Contains information about one or more alarm actions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmeventactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmeventactions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAlarmEventActions() {
        return null;
    }

    /**
     * The description of the alarm model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmmodeldescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmmodeldescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmModelDescription() {
        return null;
    }

    /**
     * The name of the alarm model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmmodelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-alarmmodelname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmModelName() {
        return null;
    }

    /**
     * An input attribute used as a key to create an alarm.
     * <p>
     * AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this key to the alarm.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-key</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return null;
    }

    /**
     * A non-negative integer that reflects the severity level of the alarm.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-severity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-severity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSeverity() {
        return null;
    }

    /**
     * A list of key-value pairs that contain metadata for the alarm model.
     * <p>
     * The tags help you manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events resources</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * You can create up to 50 tags for one alarm model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-alarmmodel.html#cfn-iotevents-alarmmodel-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAlarmModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAlarmModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAlarmModelProps> {
        java.lang.Object alarmRule;
        java.lang.String roleArn;
        java.lang.Object alarmCapabilities;
        java.lang.Object alarmEventActions;
        java.lang.String alarmModelDescription;
        java.lang.String alarmModelName;
        java.lang.String key;
        java.lang.Number severity;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAlarmModelProps#getAlarmRule}
         * @param alarmRule Defines when your alarm is invoked. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmRule(software.amazon.awscdk.IResolvable alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getAlarmRule}
         * @param alarmRule Defines when your alarm is invoked. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmRule(software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmRuleProperty alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getRoleArn}
         * @param roleArn The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. This parameter is required.
         *                For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <em>AWS General Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getAlarmCapabilities}
         * @param alarmCapabilities Contains the configuration information of alarm state changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmCapabilities(software.amazon.awscdk.IResolvable alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getAlarmCapabilities}
         * @param alarmCapabilities Contains the configuration information of alarm state changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmCapabilities(software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmCapabilitiesProperty alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getAlarmEventActions}
         * @param alarmEventActions Contains information about one or more alarm actions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmEventActions(software.amazon.awscdk.IResolvable alarmEventActions) {
            this.alarmEventActions = alarmEventActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getAlarmEventActions}
         * @param alarmEventActions Contains information about one or more alarm actions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmEventActions(software.amazon.awscdk.services.iotevents.CfnAlarmModel.AlarmEventActionsProperty alarmEventActions) {
            this.alarmEventActions = alarmEventActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getAlarmModelDescription}
         * @param alarmModelDescription The description of the alarm model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmModelDescription(java.lang.String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getAlarmModelName}
         * @param alarmModelName The name of the alarm model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmModelName(java.lang.String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getKey}
         * @param key An input attribute used as a key to create an alarm.
         *            AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this key to the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getSeverity}
         * @param severity A non-negative integer that reflects the severity level of the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder severity(java.lang.Number severity) {
            this.severity = severity;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmModelProps#getTags}
         * @param tags A list of key-value pairs that contain metadata for the alarm model.
         *             The tags help you manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events resources</a> in the <em>AWS IoT Events Developer Guide</em> .
         *             <p>
         *             You can create up to 50 tags for one alarm model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAlarmModelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAlarmModelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAlarmModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAlarmModelProps {
        private final java.lang.Object alarmRule;
        private final java.lang.String roleArn;
        private final java.lang.Object alarmCapabilities;
        private final java.lang.Object alarmEventActions;
        private final java.lang.String alarmModelDescription;
        private final java.lang.String alarmModelName;
        private final java.lang.String key;
        private final java.lang.Number severity;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alarmRule = software.amazon.jsii.Kernel.get(this, "alarmRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alarmCapabilities = software.amazon.jsii.Kernel.get(this, "alarmCapabilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.alarmEventActions = software.amazon.jsii.Kernel.get(this, "alarmEventActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.alarmModelDescription = software.amazon.jsii.Kernel.get(this, "alarmModelDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alarmModelName = software.amazon.jsii.Kernel.get(this, "alarmModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.severity = software.amazon.jsii.Kernel.get(this, "severity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alarmRule = java.util.Objects.requireNonNull(builder.alarmRule, "alarmRule is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.alarmCapabilities = builder.alarmCapabilities;
            this.alarmEventActions = builder.alarmEventActions;
            this.alarmModelDescription = builder.alarmModelDescription;
            this.alarmModelName = builder.alarmModelName;
            this.key = builder.key;
            this.severity = builder.severity;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAlarmRule() {
            return this.alarmRule;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getAlarmCapabilities() {
            return this.alarmCapabilities;
        }

        @Override
        public final java.lang.Object getAlarmEventActions() {
            return this.alarmEventActions;
        }

        @Override
        public final java.lang.String getAlarmModelDescription() {
            return this.alarmModelDescription;
        }

        @Override
        public final java.lang.String getAlarmModelName() {
            return this.alarmModelName;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final java.lang.Number getSeverity() {
            return this.severity;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alarmRule", om.valueToTree(this.getAlarmRule()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getAlarmCapabilities() != null) {
                data.set("alarmCapabilities", om.valueToTree(this.getAlarmCapabilities()));
            }
            if (this.getAlarmEventActions() != null) {
                data.set("alarmEventActions", om.valueToTree(this.getAlarmEventActions()));
            }
            if (this.getAlarmModelDescription() != null) {
                data.set("alarmModelDescription", om.valueToTree(this.getAlarmModelDescription()));
            }
            if (this.getAlarmModelName() != null) {
                data.set("alarmModelName", om.valueToTree(this.getAlarmModelName()));
            }
            if (this.getKey() != null) {
                data.set("key", om.valueToTree(this.getKey()));
            }
            if (this.getSeverity() != null) {
                data.set("severity", om.valueToTree(this.getSeverity()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnAlarmModelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAlarmModelProps.Jsii$Proxy that = (CfnAlarmModelProps.Jsii$Proxy) o;

            if (!alarmRule.equals(that.alarmRule)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.alarmCapabilities != null ? !this.alarmCapabilities.equals(that.alarmCapabilities) : that.alarmCapabilities != null) return false;
            if (this.alarmEventActions != null ? !this.alarmEventActions.equals(that.alarmEventActions) : that.alarmEventActions != null) return false;
            if (this.alarmModelDescription != null ? !this.alarmModelDescription.equals(that.alarmModelDescription) : that.alarmModelDescription != null) return false;
            if (this.alarmModelName != null ? !this.alarmModelName.equals(that.alarmModelName) : that.alarmModelName != null) return false;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
            if (this.severity != null ? !this.severity.equals(that.severity) : that.severity != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alarmRule.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.alarmCapabilities != null ? this.alarmCapabilities.hashCode() : 0);
            result = 31 * result + (this.alarmEventActions != null ? this.alarmEventActions.hashCode() : 0);
            result = 31 * result + (this.alarmModelDescription != null ? this.alarmModelDescription.hashCode() : 0);
            result = 31 * result + (this.alarmModelName != null ? this.alarmModelName.hashCode() : 0);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
