package software.amazon.awscdk.services.iotevents;

/**
 * The AWS::IoTEvents::DetectorModel resource creates a detector model.
 * <p>
 * You create a <em>detector model</em> (a model of your equipment or process) using <em>states</em> . For each state, you define conditional (Boolean) logic that evaluates the incoming inputs to detect significant events. When an event is detected, it can change the state or trigger custom-built or predefined actions using other AWS services. You can define additional events that trigger actions when entering or exiting a state and, optionally, when a condition is met. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/how-to-use-iotevents.html">How to Use AWS IoT Events</a> in the <em>AWS IoT Events Developer Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * When you successfully update a detector model (using the AWS IoT Events console, AWS IoT Events API or CLI commands, or AWS CloudFormation ) all detector instances created by the model are reset to their initial states. (The detector's <code>state</code> , and the values of any variables and timers are reset.)
 * <p>
 * When you successfully update a detector model (using the AWS IoT Events console, AWS IoT Events API or CLI commands, or AWS CloudFormation ) the version number of the detector model is incremented. (A detector model with version number 1 before the update has version number 2 after the update succeeds.)
 * <p>
 * If you attempt to update a detector model using AWS CloudFormation and the update does not succeed, the system may, in some cases, restore the original detector model. When this occurs, the detector model's version is incremented twice (for example, from version 1 to version 3) and the detector instances are reset.
 * <p>
 * Also, be aware that if you attempt to update several detector models at once using AWS CloudFormation , some updates may succeed and others fail. In this case, the effects on each detector model's detector instances and version number depend on whether the update succeeded or failed, with the results as stated.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:59.029Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel")
public class CfnDetectorModel extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDetectorModel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDetectorModel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotevents.CfnDetectorModel.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDetectorModel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.CfnDetectorModelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Information that defines how a detector operates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDetectorModelDefinition() {
        return software.amazon.jsii.Kernel.get(this, "detectorModelDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information that defines how a detector operates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDetectorModelDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "detectorModelDefinition", java.util.Objects.requireNonNull(value, "detectorModelDefinition is required"));
    }

    /**
     * Information that defines how a detector operates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDetectorModelDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.CfnDetectorModel.DetectorModelDefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "detectorModelDefinition", java.util.Objects.requireNonNull(value, "detectorModelDefinition is required"));
    }

    /**
     * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * A brief description of the detector model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDetectorModelDescription() {
        return software.amazon.jsii.Kernel.get(this, "detectorModelDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A brief description of the detector model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDetectorModelDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "detectorModelDescription", value);
    }

    /**
     * The name of the detector model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDetectorModelName() {
        return software.amazon.jsii.Kernel.get(this, "detectorModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the detector model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDetectorModelName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "detectorModelName", value);
    }

    /**
     * Information about the order in which events are evaluated and how actions are executed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEvaluationMethod() {
        return software.amazon.jsii.Kernel.get(this, "evaluationMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Information about the order in which events are evaluated and how actions are executed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvaluationMethod(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "evaluationMethod", value);
    }

    /**
     * The value used to identify a detector instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The value used to identify a detector instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "key", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * An action to be performed when the <code>condition</code> is TRUE.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .clearTimer(ClearTimerProperty.builder()
     *                 .timerName("timerName")
     *                 .build())
     *         .dynamoDb(DynamoDBProperty.builder()
     *                 .hashKeyField("hashKeyField")
     *                 .hashKeyValue("hashKeyValue")
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .hashKeyType("hashKeyType")
     *                 .operation("operation")
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .payloadField("payloadField")
     *                 .rangeKeyField("rangeKeyField")
     *                 .rangeKeyType("rangeKeyType")
     *                 .rangeKeyValue("rangeKeyValue")
     *                 .build())
     *         .dynamoDBv2(DynamoDBv2Property.builder()
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .firehose(FirehoseProperty.builder()
     *                 .deliveryStreamName("deliveryStreamName")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .separator("separator")
     *                 .build())
     *         .iotEvents(IotEventsProperty.builder()
     *                 .inputName("inputName")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .iotSiteWise(IotSiteWiseProperty.builder()
     *                 .propertyValue(AssetPropertyValueProperty.builder()
     *                         .value(AssetPropertyVariantProperty.builder()
     *                                 .booleanValue("booleanValue")
     *                                 .doubleValue("doubleValue")
     *                                 .integerValue("integerValue")
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         // the properties below are optional
     *                         .quality("quality")
     *                         .timestamp(AssetPropertyTimestampProperty.builder()
     *                                 .timeInSeconds("timeInSeconds")
     *                                 // the properties below are optional
     *                                 .offsetInNanos("offsetInNanos")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .assetId("assetId")
     *                 .entryId("entryId")
     *                 .propertyAlias("propertyAlias")
     *                 .propertyId("propertyId")
     *                 .build())
     *         .iotTopicPublish(IotTopicPublishProperty.builder()
     *                 .mqttTopic("mqttTopic")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .lambda(LambdaProperty.builder()
     *                 .functionArn("functionArn")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .resetTimer(ResetTimerProperty.builder()
     *                 .timerName("timerName")
     *                 .build())
     *         .setTimer(SetTimerProperty.builder()
     *                 .timerName("timerName")
     *                 // the properties below are optional
     *                 .durationExpression("durationExpression")
     *                 .seconds(123)
     *                 .build())
     *         .setVariable(SetVariableProperty.builder()
     *                 .value("value")
     *                 .variableName("variableName")
     *                 .build())
     *         .sns(SnsProperty.builder()
     *                 .targetArn("targetArn")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .sqs(SqsProperty.builder()
     *                 .queueUrl("queueUrl")
     *                 // the properties below are optional
     *                 .payload(PayloadProperty.builder()
     *                         .contentExpression("contentExpression")
     *                         .type("type")
     *                         .build())
     *                 .useBase64(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information needed to clear the timer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-cleartimer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-cleartimer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClearTimer() {
            return null;
        }

        /**
         * Writes to the DynamoDB table that you created.
         * <p>
         * The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <em>AWS IoT Events Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-dynamodb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-dynamodb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDb() {
            return null;
        }

        /**
         * Writes to the DynamoDB table that you created.
         * <p>
         * The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <em>AWS IoT Events Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-dynamodbv2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-dynamodbv2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDBv2() {
            return null;
        }

        /**
         * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-firehose">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-firehose</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirehose() {
            return null;
        }

        /**
         * Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iotevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iotevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotEvents() {
            return null;
        }

        /**
         * Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iotsitewise">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iotsitewise</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotSiteWise() {
            return null;
        }

        /**
         * Publishes an MQTT message with the given topic to the AWS IoT message broker.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iottopicpublish">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iottopicpublish</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotTopicPublish() {
            return null;
        }

        /**
         * Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-lambda">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-lambda</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambda() {
            return null;
        }

        /**
         * Information needed to reset the timer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-resettimer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-resettimer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResetTimer() {
            return null;
        }

        /**
         * Information needed to set the timer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-settimer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-settimer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSetTimer() {
            return null;
        }

        /**
         * Sets a variable to a specified value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-setvariable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-setvariable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSetVariable() {
            return null;
        }

        /**
         * Sends an Amazon SNS message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-sns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-sns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSns() {
            return null;
        }

        /**
         * Sends an Amazon SNS message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-sqs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-sqs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.Object clearTimer;
            java.lang.Object dynamoDb;
            java.lang.Object dynamoDBv2;
            java.lang.Object firehose;
            java.lang.Object iotEvents;
            java.lang.Object iotSiteWise;
            java.lang.Object iotTopicPublish;
            java.lang.Object lambda;
            java.lang.Object resetTimer;
            java.lang.Object setTimer;
            java.lang.Object setVariable;
            java.lang.Object sns;
            java.lang.Object sqs;

            /**
             * Sets the value of {@link ActionProperty#getClearTimer}
             * @param clearTimer Information needed to clear the timer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clearTimer(software.amazon.awscdk.IResolvable clearTimer) {
                this.clearTimer = clearTimer;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getClearTimer}
             * @param clearTimer Information needed to clear the timer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clearTimer(software.amazon.awscdk.services.iotevents.CfnDetectorModel.ClearTimerProperty clearTimer) {
                this.clearTimer = clearTimer;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getDynamoDb}
             * @param dynamoDb Writes to the DynamoDB table that you created.
             *                 The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <em>AWS IoT Events Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDb(software.amazon.awscdk.IResolvable dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getDynamoDb}
             * @param dynamoDb Writes to the DynamoDB table that you created.
             *                 The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <em>AWS IoT Events Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDb(software.amazon.awscdk.services.iotevents.CfnDetectorModel.DynamoDBProperty dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getDynamoDBv2}
             * @param dynamoDBv2 Writes to the DynamoDB table that you created.
             *                   The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <em>AWS IoT Events Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDBv2(software.amazon.awscdk.IResolvable dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getDynamoDBv2}
             * @param dynamoDBv2 Writes to the DynamoDB table that you created.
             *                   The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <em>AWS IoT Events Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDBv2(software.amazon.awscdk.services.iotevents.CfnDetectorModel.DynamoDBv2Property dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getFirehose}
             * @param firehose Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehose(software.amazon.awscdk.IResolvable firehose) {
                this.firehose = firehose;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getFirehose}
             * @param firehose Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehose(software.amazon.awscdk.services.iotevents.CfnDetectorModel.FirehoseProperty firehose) {
                this.firehose = firehose;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotEvents}
             * @param iotEvents Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotEvents(software.amazon.awscdk.IResolvable iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotEvents}
             * @param iotEvents Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotEvents(software.amazon.awscdk.services.iotevents.CfnDetectorModel.IotEventsProperty iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotSiteWise}
             * @param iotSiteWise Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotSiteWise(software.amazon.awscdk.IResolvable iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotSiteWise}
             * @param iotSiteWise Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotSiteWise(software.amazon.awscdk.services.iotevents.CfnDetectorModel.IotSiteWiseProperty iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotTopicPublish}
             * @param iotTopicPublish Publishes an MQTT message with the given topic to the AWS IoT message broker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotTopicPublish(software.amazon.awscdk.IResolvable iotTopicPublish) {
                this.iotTopicPublish = iotTopicPublish;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotTopicPublish}
             * @param iotTopicPublish Publishes an MQTT message with the given topic to the AWS IoT message broker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotTopicPublish(software.amazon.awscdk.services.iotevents.CfnDetectorModel.IotTopicPublishProperty iotTopicPublish) {
                this.iotTopicPublish = iotTopicPublish;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getLambda}
             * @param lambda Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getLambda}
             * @param lambda Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.services.iotevents.CfnDetectorModel.LambdaProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getResetTimer}
             * @param resetTimer Information needed to reset the timer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resetTimer(software.amazon.awscdk.IResolvable resetTimer) {
                this.resetTimer = resetTimer;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getResetTimer}
             * @param resetTimer Information needed to reset the timer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resetTimer(software.amazon.awscdk.services.iotevents.CfnDetectorModel.ResetTimerProperty resetTimer) {
                this.resetTimer = resetTimer;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSetTimer}
             * @param setTimer Information needed to set the timer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setTimer(software.amazon.awscdk.IResolvable setTimer) {
                this.setTimer = setTimer;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSetTimer}
             * @param setTimer Information needed to set the timer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setTimer(software.amazon.awscdk.services.iotevents.CfnDetectorModel.SetTimerProperty setTimer) {
                this.setTimer = setTimer;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSetVariable}
             * @param setVariable Sets a variable to a specified value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setVariable(software.amazon.awscdk.IResolvable setVariable) {
                this.setVariable = setVariable;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSetVariable}
             * @param setVariable Sets a variable to a specified value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setVariable(software.amazon.awscdk.services.iotevents.CfnDetectorModel.SetVariableProperty setVariable) {
                this.setVariable = setVariable;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSns}
             * @param sns Sends an Amazon SNS message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sns(software.amazon.awscdk.IResolvable sns) {
                this.sns = sns;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSns}
             * @param sns Sends an Amazon SNS message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sns(software.amazon.awscdk.services.iotevents.CfnDetectorModel.SnsProperty sns) {
                this.sns = sns;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSqs}
             * @param sqs Sends an Amazon SNS message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqs(software.amazon.awscdk.IResolvable sqs) {
                this.sqs = sqs;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSqs}
             * @param sqs Sends an Amazon SNS message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqs(software.amazon.awscdk.services.iotevents.CfnDetectorModel.SqsProperty sqs) {
                this.sqs = sqs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.Object clearTimer;
            private final java.lang.Object dynamoDb;
            private final java.lang.Object dynamoDBv2;
            private final java.lang.Object firehose;
            private final java.lang.Object iotEvents;
            private final java.lang.Object iotSiteWise;
            private final java.lang.Object iotTopicPublish;
            private final java.lang.Object lambda;
            private final java.lang.Object resetTimer;
            private final java.lang.Object setTimer;
            private final java.lang.Object setVariable;
            private final java.lang.Object sns;
            private final java.lang.Object sqs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clearTimer = software.amazon.jsii.Kernel.get(this, "clearTimer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDb = software.amazon.jsii.Kernel.get(this, "dynamoDb", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDBv2 = software.amazon.jsii.Kernel.get(this, "dynamoDBv2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firehose = software.amazon.jsii.Kernel.get(this, "firehose", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iotEvents = software.amazon.jsii.Kernel.get(this, "iotEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iotSiteWise = software.amazon.jsii.Kernel.get(this, "iotSiteWise", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iotTopicPublish = software.amazon.jsii.Kernel.get(this, "iotTopicPublish", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambda = software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resetTimer = software.amazon.jsii.Kernel.get(this, "resetTimer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.setTimer = software.amazon.jsii.Kernel.get(this, "setTimer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.setVariable = software.amazon.jsii.Kernel.get(this, "setVariable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sns = software.amazon.jsii.Kernel.get(this, "sns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqs = software.amazon.jsii.Kernel.get(this, "sqs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clearTimer = builder.clearTimer;
                this.dynamoDb = builder.dynamoDb;
                this.dynamoDBv2 = builder.dynamoDBv2;
                this.firehose = builder.firehose;
                this.iotEvents = builder.iotEvents;
                this.iotSiteWise = builder.iotSiteWise;
                this.iotTopicPublish = builder.iotTopicPublish;
                this.lambda = builder.lambda;
                this.resetTimer = builder.resetTimer;
                this.setTimer = builder.setTimer;
                this.setVariable = builder.setVariable;
                this.sns = builder.sns;
                this.sqs = builder.sqs;
            }

            @Override
            public final java.lang.Object getClearTimer() {
                return this.clearTimer;
            }

            @Override
            public final java.lang.Object getDynamoDb() {
                return this.dynamoDb;
            }

            @Override
            public final java.lang.Object getDynamoDBv2() {
                return this.dynamoDBv2;
            }

            @Override
            public final java.lang.Object getFirehose() {
                return this.firehose;
            }

            @Override
            public final java.lang.Object getIotEvents() {
                return this.iotEvents;
            }

            @Override
            public final java.lang.Object getIotSiteWise() {
                return this.iotSiteWise;
            }

            @Override
            public final java.lang.Object getIotTopicPublish() {
                return this.iotTopicPublish;
            }

            @Override
            public final java.lang.Object getLambda() {
                return this.lambda;
            }

            @Override
            public final java.lang.Object getResetTimer() {
                return this.resetTimer;
            }

            @Override
            public final java.lang.Object getSetTimer() {
                return this.setTimer;
            }

            @Override
            public final java.lang.Object getSetVariable() {
                return this.setVariable;
            }

            @Override
            public final java.lang.Object getSns() {
                return this.sns;
            }

            @Override
            public final java.lang.Object getSqs() {
                return this.sqs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClearTimer() != null) {
                    data.set("clearTimer", om.valueToTree(this.getClearTimer()));
                }
                if (this.getDynamoDb() != null) {
                    data.set("dynamoDb", om.valueToTree(this.getDynamoDb()));
                }
                if (this.getDynamoDBv2() != null) {
                    data.set("dynamoDBv2", om.valueToTree(this.getDynamoDBv2()));
                }
                if (this.getFirehose() != null) {
                    data.set("firehose", om.valueToTree(this.getFirehose()));
                }
                if (this.getIotEvents() != null) {
                    data.set("iotEvents", om.valueToTree(this.getIotEvents()));
                }
                if (this.getIotSiteWise() != null) {
                    data.set("iotSiteWise", om.valueToTree(this.getIotSiteWise()));
                }
                if (this.getIotTopicPublish() != null) {
                    data.set("iotTopicPublish", om.valueToTree(this.getIotTopicPublish()));
                }
                if (this.getLambda() != null) {
                    data.set("lambda", om.valueToTree(this.getLambda()));
                }
                if (this.getResetTimer() != null) {
                    data.set("resetTimer", om.valueToTree(this.getResetTimer()));
                }
                if (this.getSetTimer() != null) {
                    data.set("setTimer", om.valueToTree(this.getSetTimer()));
                }
                if (this.getSetVariable() != null) {
                    data.set("setVariable", om.valueToTree(this.getSetVariable()));
                }
                if (this.getSns() != null) {
                    data.set("sns", om.valueToTree(this.getSns()));
                }
                if (this.getSqs() != null) {
                    data.set("sqs", om.valueToTree(this.getSqs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (this.clearTimer != null ? !this.clearTimer.equals(that.clearTimer) : that.clearTimer != null) return false;
                if (this.dynamoDb != null ? !this.dynamoDb.equals(that.dynamoDb) : that.dynamoDb != null) return false;
                if (this.dynamoDBv2 != null ? !this.dynamoDBv2.equals(that.dynamoDBv2) : that.dynamoDBv2 != null) return false;
                if (this.firehose != null ? !this.firehose.equals(that.firehose) : that.firehose != null) return false;
                if (this.iotEvents != null ? !this.iotEvents.equals(that.iotEvents) : that.iotEvents != null) return false;
                if (this.iotSiteWise != null ? !this.iotSiteWise.equals(that.iotSiteWise) : that.iotSiteWise != null) return false;
                if (this.iotTopicPublish != null ? !this.iotTopicPublish.equals(that.iotTopicPublish) : that.iotTopicPublish != null) return false;
                if (this.lambda != null ? !this.lambda.equals(that.lambda) : that.lambda != null) return false;
                if (this.resetTimer != null ? !this.resetTimer.equals(that.resetTimer) : that.resetTimer != null) return false;
                if (this.setTimer != null ? !this.setTimer.equals(that.setTimer) : that.setTimer != null) return false;
                if (this.setVariable != null ? !this.setVariable.equals(that.setVariable) : that.setVariable != null) return false;
                if (this.sns != null ? !this.sns.equals(that.sns) : that.sns != null) return false;
                return this.sqs != null ? this.sqs.equals(that.sqs) : that.sqs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clearTimer != null ? this.clearTimer.hashCode() : 0;
                result = 31 * result + (this.dynamoDb != null ? this.dynamoDb.hashCode() : 0);
                result = 31 * result + (this.dynamoDBv2 != null ? this.dynamoDBv2.hashCode() : 0);
                result = 31 * result + (this.firehose != null ? this.firehose.hashCode() : 0);
                result = 31 * result + (this.iotEvents != null ? this.iotEvents.hashCode() : 0);
                result = 31 * result + (this.iotSiteWise != null ? this.iotSiteWise.hashCode() : 0);
                result = 31 * result + (this.iotTopicPublish != null ? this.iotTopicPublish.hashCode() : 0);
                result = 31 * result + (this.lambda != null ? this.lambda.hashCode() : 0);
                result = 31 * result + (this.resetTimer != null ? this.resetTimer.hashCode() : 0);
                result = 31 * result + (this.setTimer != null ? this.setTimer.hashCode() : 0);
                result = 31 * result + (this.setVariable != null ? this.setVariable.hashCode() : 0);
                result = 31 * result + (this.sns != null ? this.sns.hashCode() : 0);
                result = 31 * result + (this.sqs != null ? this.sqs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains timestamp information. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html">TimeInNanos</a> in the <em>AWS IoT SiteWise API Reference</em> .
     * <p>
     * You must use expressions for all parameters in <code>AssetPropertyTimestamp</code> . The expressions accept literals, operators, functions, references, and substitution templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>timeInSeconds</code> parameter can be <code>'1586400675'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or input values. For example, the value for the <code>offsetInNanos</code> parameter can be <code>$variable.time</code> .</li>
     * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>timeInSeconds</code> parameter uses a substitution template.
     * <p>
     * <code>'${$input.TemperatureInput.sensorData.timestamp / 1000}'</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AssetPropertyTimestampProperty assetPropertyTimestampProperty = AssetPropertyTimestampProperty.builder()
     *         .timeInSeconds("timeInSeconds")
     *         // the properties below are optional
     *         .offsetInNanos("offsetInNanos")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.AssetPropertyTimestampProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyTimestampProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyTimestampProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The timestamp, in seconds, in the Unix epoch format.
         * <p>
         * The valid range is between 1-31556889864403199.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html#cfn-iotevents-detectormodel-assetpropertytimestamp-timeinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html#cfn-iotevents-detectormodel-assetpropertytimestamp-timeinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeInSeconds();

        /**
         * The nanosecond offset converted from <code>timeInSeconds</code> .
         * <p>
         * The valid range is between 0-999999999.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html#cfn-iotevents-detectormodel-assetpropertytimestamp-offsetinnanos">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html#cfn-iotevents-detectormodel-assetpropertytimestamp-offsetinnanos</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOffsetInNanos() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyTimestampProperty> {
            java.lang.String timeInSeconds;
            java.lang.String offsetInNanos;

            /**
             * Sets the value of {@link AssetPropertyTimestampProperty#getTimeInSeconds}
             * @param timeInSeconds The timestamp, in seconds, in the Unix epoch format. This parameter is required.
             *                      The valid range is between 1-31556889864403199.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeInSeconds(java.lang.String timeInSeconds) {
                this.timeInSeconds = timeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyTimestampProperty#getOffsetInNanos}
             * @param offsetInNanos The nanosecond offset converted from <code>timeInSeconds</code> .
             *                      The valid range is between 0-999999999.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offsetInNanos(java.lang.String offsetInNanos) {
                this.offsetInNanos = offsetInNanos;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyTimestampProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyTimestampProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyTimestampProperty {
            private final java.lang.String timeInSeconds;
            private final java.lang.String offsetInNanos;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeInSeconds = software.amazon.jsii.Kernel.get(this, "timeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.offsetInNanos = software.amazon.jsii.Kernel.get(this, "offsetInNanos", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeInSeconds = java.util.Objects.requireNonNull(builder.timeInSeconds, "timeInSeconds is required");
                this.offsetInNanos = builder.offsetInNanos;
            }

            @Override
            public final java.lang.String getTimeInSeconds() {
                return this.timeInSeconds;
            }

            @Override
            public final java.lang.String getOffsetInNanos() {
                return this.offsetInNanos;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timeInSeconds", om.valueToTree(this.getTimeInSeconds()));
                if (this.getOffsetInNanos() != null) {
                    data.set("offsetInNanos", om.valueToTree(this.getOffsetInNanos()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.AssetPropertyTimestampProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyTimestampProperty.Jsii$Proxy that = (AssetPropertyTimestampProperty.Jsii$Proxy) o;

                if (!timeInSeconds.equals(that.timeInSeconds)) return false;
                return this.offsetInNanos != null ? this.offsetInNanos.equals(that.offsetInNanos) : that.offsetInNanos == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timeInSeconds.hashCode();
                result = 31 * result + (this.offsetInNanos != null ? this.offsetInNanos.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains value information. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html">AssetPropertyValue</a> in the <em>AWS IoT SiteWise API Reference</em> .
     * <p>
     * You must use expressions for all parameters in <code>AssetPropertyValue</code> . The expressions accept literals, operators, functions, references, and substitution templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>quality</code> parameter can be <code>'GOOD'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or input values. For example, the value for the <code>quality</code> parameter can be <code>$input.TemperatureInput.sensorData.quality</code> .</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AssetPropertyValueProperty assetPropertyValueProperty = AssetPropertyValueProperty.builder()
     *         .value(AssetPropertyVariantProperty.builder()
     *                 .booleanValue("booleanValue")
     *                 .doubleValue("doubleValue")
     *                 .integerValue("integerValue")
     *                 .stringValue("stringValue")
     *                 .build())
     *         // the properties below are optional
     *         .quality("quality")
     *         .timestamp(AssetPropertyTimestampProperty.builder()
     *                 .timeInSeconds("timeInSeconds")
     *                 // the properties below are optional
     *                 .offsetInNanos("offsetInNanos")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.AssetPropertyValueProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value to send to an asset property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * The quality of the asset property value.
         * <p>
         * The value must be <code>'GOOD'</code> , <code>'BAD'</code> , or <code>'UNCERTAIN'</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-quality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-quality</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQuality() {
            return null;
        }

        /**
         * The timestamp associated with the asset property value.
         * <p>
         * The default is the current event time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-timestamp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-timestamp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimestamp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyValueProperty> {
            java.lang.Object value;
            java.lang.String quality;
            java.lang.Object timestamp;

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getValue}
             * @param value The value to send to an asset property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getValue}
             * @param value The value to send to an asset property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.iotevents.CfnDetectorModel.AssetPropertyVariantProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getQuality}
             * @param quality The quality of the asset property value.
             *                The value must be <code>'GOOD'</code> , <code>'BAD'</code> , or <code>'UNCERTAIN'</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quality(java.lang.String quality) {
                this.quality = quality;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getTimestamp}
             * @param timestamp The timestamp associated with the asset property value.
             *                  The default is the current event time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(software.amazon.awscdk.IResolvable timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getTimestamp}
             * @param timestamp The timestamp associated with the asset property value.
             *                  The default is the current event time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(software.amazon.awscdk.services.iotevents.CfnDetectorModel.AssetPropertyTimestampProperty timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyValueProperty {
            private final java.lang.Object value;
            private final java.lang.String quality;
            private final java.lang.Object timestamp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.quality = software.amazon.jsii.Kernel.get(this, "quality", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timestamp = software.amazon.jsii.Kernel.get(this, "timestamp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.quality = builder.quality;
                this.timestamp = builder.timestamp;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getQuality() {
                return this.quality;
            }

            @Override
            public final java.lang.Object getTimestamp() {
                return this.timestamp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));
                if (this.getQuality() != null) {
                    data.set("quality", om.valueToTree(this.getQuality()));
                }
                if (this.getTimestamp() != null) {
                    data.set("timestamp", om.valueToTree(this.getTimestamp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.AssetPropertyValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyValueProperty.Jsii$Proxy that = (AssetPropertyValueProperty.Jsii$Proxy) o;

                if (!value.equals(that.value)) return false;
                if (this.quality != null ? !this.quality.equals(that.quality) : that.quality != null) return false;
                return this.timestamp != null ? this.timestamp.equals(that.timestamp) : that.timestamp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                result = 31 * result + (this.quality != null ? this.quality.hashCode() : 0);
                result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains an asset property value.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html">Variant</a> in the <em>AWS IoT SiteWise API Reference</em> .
     * <p>
     * You must use expressions for all parameters in <code>AssetPropertyVariant</code> . The expressions accept literals, operators, functions, references, and substitution templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>integerValue</code> parameter can be <code>'100'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or parameters. For example, the value for the <code>booleanValue</code> parameter can be <code>$variable.offline</code> .</li>
     * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>doubleValue</code> parameter uses a substitution template.
     * <p>
     * <code>'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * You must specify one of the following value types, depending on the <code>dataType</code> of the specified asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html">AssetProperty</a> in the <em>AWS IoT SiteWise API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * AssetPropertyVariantProperty assetPropertyVariantProperty = AssetPropertyVariantProperty.builder()
     *         .booleanValue("booleanValue")
     *         .doubleValue("doubleValue")
     *         .integerValue("integerValue")
     *         .stringValue("stringValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.AssetPropertyVariantProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyVariantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyVariantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code> .
         * <p>
         * You must use an expression, and the evaluated result should be a Boolean value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-booleanvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-booleanvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBooleanValue() {
            return null;
        }

        /**
         * The asset property value is a double.
         * <p>
         * You must use an expression, and the evaluated result should be a double.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-doublevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-doublevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDoubleValue() {
            return null;
        }

        /**
         * The asset property value is an integer.
         * <p>
         * You must use an expression, and the evaluated result should be an integer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-integervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-integervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntegerValue() {
            return null;
        }

        /**
         * The asset property value is a string.
         * <p>
         * You must use an expression, and the evaluated result should be a string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-stringvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-stringvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyVariantProperty> {
            java.lang.String booleanValue;
            java.lang.String doubleValue;
            java.lang.String integerValue;
            java.lang.String stringValue;

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getBooleanValue}
             * @param booleanValue The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code> .
             *                     You must use an expression, and the evaluated result should be a Boolean value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(java.lang.String booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getDoubleValue}
             * @param doubleValue The asset property value is a double.
             *                    You must use an expression, and the evaluated result should be a double.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder doubleValue(java.lang.String doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getIntegerValue}
             * @param integerValue The asset property value is an integer.
             *                     You must use an expression, and the evaluated result should be an integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerValue(java.lang.String integerValue) {
                this.integerValue = integerValue;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getStringValue}
             * @param stringValue The asset property value is a string.
             *                    You must use an expression, and the evaluated result should be a string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringValue(java.lang.String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyVariantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyVariantProperty {
            private final java.lang.String booleanValue;
            private final java.lang.String doubleValue;
            private final java.lang.String integerValue;
            private final java.lang.String stringValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.booleanValue = software.amazon.jsii.Kernel.get(this, "booleanValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.doubleValue = software.amazon.jsii.Kernel.get(this, "doubleValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.integerValue = software.amazon.jsii.Kernel.get(this, "integerValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.booleanValue = builder.booleanValue;
                this.doubleValue = builder.doubleValue;
                this.integerValue = builder.integerValue;
                this.stringValue = builder.stringValue;
            }

            @Override
            public final java.lang.String getBooleanValue() {
                return this.booleanValue;
            }

            @Override
            public final java.lang.String getDoubleValue() {
                return this.doubleValue;
            }

            @Override
            public final java.lang.String getIntegerValue() {
                return this.integerValue;
            }

            @Override
            public final java.lang.String getStringValue() {
                return this.stringValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBooleanValue() != null) {
                    data.set("booleanValue", om.valueToTree(this.getBooleanValue()));
                }
                if (this.getDoubleValue() != null) {
                    data.set("doubleValue", om.valueToTree(this.getDoubleValue()));
                }
                if (this.getIntegerValue() != null) {
                    data.set("integerValue", om.valueToTree(this.getIntegerValue()));
                }
                if (this.getStringValue() != null) {
                    data.set("stringValue", om.valueToTree(this.getStringValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.AssetPropertyVariantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyVariantProperty.Jsii$Proxy that = (AssetPropertyVariantProperty.Jsii$Proxy) o;

                if (this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null) return false;
                if (this.doubleValue != null ? !this.doubleValue.equals(that.doubleValue) : that.doubleValue != null) return false;
                if (this.integerValue != null ? !this.integerValue.equals(that.integerValue) : that.integerValue != null) return false;
                return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.booleanValue != null ? this.booleanValue.hashCode() : 0;
                result = 31 * result + (this.doubleValue != null ? this.doubleValue.hashCode() : 0);
                result = 31 * result + (this.integerValue != null ? this.integerValue.hashCode() : 0);
                result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information needed to clear the timer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * ClearTimerProperty clearTimerProperty = ClearTimerProperty.builder()
     *         .timerName("timerName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-cleartimer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-cleartimer.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.ClearTimerProperty")
    @software.amazon.jsii.Jsii.Proxy(ClearTimerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClearTimerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the timer to clear.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-cleartimer.html#cfn-iotevents-detectormodel-cleartimer-timername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-cleartimer.html#cfn-iotevents-detectormodel-cleartimer-timername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimerName();

        /**
         * @return a {@link Builder} of {@link ClearTimerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClearTimerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClearTimerProperty> {
            java.lang.String timerName;

            /**
             * Sets the value of {@link ClearTimerProperty#getTimerName}
             * @param timerName The name of the timer to clear. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timerName(java.lang.String timerName) {
                this.timerName = timerName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClearTimerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClearTimerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClearTimerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClearTimerProperty {
            private final java.lang.String timerName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timerName = software.amazon.jsii.Kernel.get(this, "timerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timerName = java.util.Objects.requireNonNull(builder.timerName, "timerName is required");
            }

            @Override
            public final java.lang.String getTimerName() {
                return this.timerName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timerName", om.valueToTree(this.getTimerName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.ClearTimerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClearTimerProperty.Jsii$Proxy that = (ClearTimerProperty.Jsii$Proxy) o;

                return this.timerName.equals(that.timerName);
            }

            @Override
            public final int hashCode() {
                int result = this.timerName.hashCode();
                return result;
            }
        }
    }
    /**
     * Information that defines how a detector operates.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.DetectorModelDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(DetectorModelDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DetectorModelDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The state that is entered at the creation of each detector (instance).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html#cfn-iotevents-detectormodel-detectormodeldefinition-initialstatename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html#cfn-iotevents-detectormodel-detectormodeldefinition-initialstatename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInitialStateName();

        /**
         * Information about the states of the detector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html#cfn-iotevents-detectormodel-detectormodeldefinition-states">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html#cfn-iotevents-detectormodel-detectormodeldefinition-states</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStates();

        /**
         * @return a {@link Builder} of {@link DetectorModelDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DetectorModelDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DetectorModelDefinitionProperty> {
            java.lang.String initialStateName;
            java.lang.Object states;

            /**
             * Sets the value of {@link DetectorModelDefinitionProperty#getInitialStateName}
             * @param initialStateName The state that is entered at the creation of each detector (instance). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialStateName(java.lang.String initialStateName) {
                this.initialStateName = initialStateName;
                return this;
            }

            /**
             * Sets the value of {@link DetectorModelDefinitionProperty#getStates}
             * @param states Information about the states of the detector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder states(software.amazon.awscdk.IResolvable states) {
                this.states = states;
                return this;
            }

            /**
             * Sets the value of {@link DetectorModelDefinitionProperty#getStates}
             * @param states Information about the states of the detector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder states(java.util.List<? extends java.lang.Object> states) {
                this.states = states;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DetectorModelDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DetectorModelDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DetectorModelDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DetectorModelDefinitionProperty {
            private final java.lang.String initialStateName;
            private final java.lang.Object states;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.initialStateName = software.amazon.jsii.Kernel.get(this, "initialStateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.states = software.amazon.jsii.Kernel.get(this, "states", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.initialStateName = java.util.Objects.requireNonNull(builder.initialStateName, "initialStateName is required");
                this.states = java.util.Objects.requireNonNull(builder.states, "states is required");
            }

            @Override
            public final java.lang.String getInitialStateName() {
                return this.initialStateName;
            }

            @Override
            public final java.lang.Object getStates() {
                return this.states;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("initialStateName", om.valueToTree(this.getInitialStateName()));
                data.set("states", om.valueToTree(this.getStates()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.DetectorModelDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DetectorModelDefinitionProperty.Jsii$Proxy that = (DetectorModelDefinitionProperty.Jsii$Proxy) o;

                if (!initialStateName.equals(that.initialStateName)) return false;
                return this.states.equals(that.states);
            }

            @Override
            public final int hashCode() {
                int result = this.initialStateName.hashCode();
                result = 31 * result + (this.states.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines an action to write to the Amazon DynamoDB table that you created.
     * <p>
     * The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
     * <p>
     * You must use expressions for all parameters in <code>DynamoDBAction</code> . The expressions accept literals, operators, functions, references, and substitution templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>'STRING'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code> .</li>
     * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template.
     * <p>
     * <code>'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'</code>
     * <p>
     * <ul>
     * <li>For a string concatenation, you must use <code>+</code> . A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>tableName</code> parameter uses a string concatenation.
     * <p>
     * <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>&lt;payload-field&gt;_raw</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * DynamoDBProperty dynamoDBProperty = DynamoDBProperty.builder()
     *         .hashKeyField("hashKeyField")
     *         .hashKeyValue("hashKeyValue")
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .hashKeyType("hashKeyType")
     *         .operation("operation")
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .payloadField("payloadField")
     *         .rangeKeyField("rangeKeyField")
     *         .rangeKeyType("rangeKeyType")
     *         .rangeKeyValue("rangeKeyValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.DynamoDBProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the hash key (also called the partition key).
         * <p>
         * The <code>hashKeyField</code> value must match the partition key of the target DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeyfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeyfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHashKeyField();

        /**
         * The value of the hash key (also called the partition key).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHashKeyValue();

        /**
         * The name of the DynamoDB table.
         * <p>
         * The <code>tableName</code> value must match the table name of the target DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * The data type for the hash key (also called the partition key). You can specify the following values:.
         * <p>
         * <ul>
         * <li><code>'STRING'</code> - The hash key is a string.</li>
         * <li><code>'NUMBER'</code> - The hash key is a number.</li>
         * </ul>
         * <p>
         * If you don't specify <code>hashKeyType</code> , the default value is <code>'STRING'</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHashKeyType() {
            return null;
        }

        /**
         * The type of operation to perform. You can specify the following values:.
         * <p>
         * <ul>
         * <li><code>'INSERT'</code> - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.</li>
         * <li><code>'UPDATE'</code> - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</li>
         * <li><code>'DELETE'</code> - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</li>
         * </ul>
         * <p>
         * If you don't specify this parameter, AWS IoT Events triggers the <code>'INSERT'</code> operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-operation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-operation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperation() {
            return null;
        }

        /**
         * Information needed to configure the payload.
         * <p>
         * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * The name of the DynamoDB column that receives the action payload.
         * <p>
         * If you don't specify this parameter, the name of the DynamoDB column is <code>payload</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-payloadfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-payloadfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayloadField() {
            return null;
        }

        /**
         * The name of the range key (also called the sort key).
         * <p>
         * The <code>rangeKeyField</code> value must match the sort key of the target DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeyfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeyfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRangeKeyField() {
            return null;
        }

        /**
         * The data type for the range key (also called the sort key), You can specify the following values:.
         * <p>
         * <ul>
         * <li><code>'STRING'</code> - The range key is a string.</li>
         * <li><code>'NUMBER'</code> - The range key is number.</li>
         * </ul>
         * <p>
         * If you don't specify <code>rangeKeyField</code> , the default value is <code>'STRING'</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRangeKeyType() {
            return null;
        }

        /**
         * The value of the range key (also called the sort key).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRangeKeyValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBProperty> {
            java.lang.String hashKeyField;
            java.lang.String hashKeyValue;
            java.lang.String tableName;
            java.lang.String hashKeyType;
            java.lang.String operation;
            java.lang.Object payload;
            java.lang.String payloadField;
            java.lang.String rangeKeyField;
            java.lang.String rangeKeyType;
            java.lang.String rangeKeyValue;

            /**
             * Sets the value of {@link DynamoDBProperty#getHashKeyField}
             * @param hashKeyField The name of the hash key (also called the partition key). This parameter is required.
             *                     The <code>hashKeyField</code> value must match the partition key of the target DynamoDB table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashKeyField(java.lang.String hashKeyField) {
                this.hashKeyField = hashKeyField;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getHashKeyValue}
             * @param hashKeyValue The value of the hash key (also called the partition key). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashKeyValue(java.lang.String hashKeyValue) {
                this.hashKeyValue = hashKeyValue;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getTableName}
             * @param tableName The name of the DynamoDB table. This parameter is required.
             *                  The <code>tableName</code> value must match the table name of the target DynamoDB table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getHashKeyType}
             * @param hashKeyType The data type for the hash key (also called the partition key). You can specify the following values:.
             *                    <ul>
             *                    <li><code>'STRING'</code> - The hash key is a string.</li>
             *                    <li><code>'NUMBER'</code> - The hash key is a number.</li>
             *                    </ul>
             *                    <p>
             *                    If you don't specify <code>hashKeyType</code> , the default value is <code>'STRING'</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashKeyType(java.lang.String hashKeyType) {
                this.hashKeyType = hashKeyType;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getOperation}
             * @param operation The type of operation to perform. You can specify the following values:.
             *                  <ul>
             *                  <li><code>'INSERT'</code> - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.</li>
             *                  <li><code>'UPDATE'</code> - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</li>
             *                  <li><code>'DELETE'</code> - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</li>
             *                  </ul>
             *                  <p>
             *                  If you don't specify this parameter, AWS IoT Events triggers the <code>'INSERT'</code> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operation(java.lang.String operation) {
                this.operation = operation;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getPayload}
             * @param payload Information needed to configure the payload.
             *                By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getPayload}
             * @param payload Information needed to configure the payload.
             *                By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnDetectorModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getPayloadField}
             * @param payloadField The name of the DynamoDB column that receives the action payload.
             *                     If you don't specify this parameter, the name of the DynamoDB column is <code>payload</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadField(java.lang.String payloadField) {
                this.payloadField = payloadField;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getRangeKeyField}
             * @param rangeKeyField The name of the range key (also called the sort key).
             *                      The <code>rangeKeyField</code> value must match the sort key of the target DynamoDB table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeKeyField(java.lang.String rangeKeyField) {
                this.rangeKeyField = rangeKeyField;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getRangeKeyType}
             * @param rangeKeyType The data type for the range key (also called the sort key), You can specify the following values:.
             *                     <ul>
             *                     <li><code>'STRING'</code> - The range key is a string.</li>
             *                     <li><code>'NUMBER'</code> - The range key is number.</li>
             *                     </ul>
             *                     <p>
             *                     If you don't specify <code>rangeKeyField</code> , the default value is <code>'STRING'</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeKeyType(java.lang.String rangeKeyType) {
                this.rangeKeyType = rangeKeyType;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBProperty#getRangeKeyValue}
             * @param rangeKeyValue The value of the range key (also called the sort key).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeKeyValue(java.lang.String rangeKeyValue) {
                this.rangeKeyValue = rangeKeyValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBProperty {
            private final java.lang.String hashKeyField;
            private final java.lang.String hashKeyValue;
            private final java.lang.String tableName;
            private final java.lang.String hashKeyType;
            private final java.lang.String operation;
            private final java.lang.Object payload;
            private final java.lang.String payloadField;
            private final java.lang.String rangeKeyField;
            private final java.lang.String rangeKeyType;
            private final java.lang.String rangeKeyValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hashKeyField = software.amazon.jsii.Kernel.get(this, "hashKeyField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hashKeyValue = software.amazon.jsii.Kernel.get(this, "hashKeyValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hashKeyType = software.amazon.jsii.Kernel.get(this, "hashKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operation = software.amazon.jsii.Kernel.get(this, "operation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.payloadField = software.amazon.jsii.Kernel.get(this, "payloadField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rangeKeyField = software.amazon.jsii.Kernel.get(this, "rangeKeyField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rangeKeyType = software.amazon.jsii.Kernel.get(this, "rangeKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rangeKeyValue = software.amazon.jsii.Kernel.get(this, "rangeKeyValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hashKeyField = java.util.Objects.requireNonNull(builder.hashKeyField, "hashKeyField is required");
                this.hashKeyValue = java.util.Objects.requireNonNull(builder.hashKeyValue, "hashKeyValue is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.hashKeyType = builder.hashKeyType;
                this.operation = builder.operation;
                this.payload = builder.payload;
                this.payloadField = builder.payloadField;
                this.rangeKeyField = builder.rangeKeyField;
                this.rangeKeyType = builder.rangeKeyType;
                this.rangeKeyValue = builder.rangeKeyValue;
            }

            @Override
            public final java.lang.String getHashKeyField() {
                return this.hashKeyField;
            }

            @Override
            public final java.lang.String getHashKeyValue() {
                return this.hashKeyValue;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.String getHashKeyType() {
                return this.hashKeyType;
            }

            @Override
            public final java.lang.String getOperation() {
                return this.operation;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            public final java.lang.String getPayloadField() {
                return this.payloadField;
            }

            @Override
            public final java.lang.String getRangeKeyField() {
                return this.rangeKeyField;
            }

            @Override
            public final java.lang.String getRangeKeyType() {
                return this.rangeKeyType;
            }

            @Override
            public final java.lang.String getRangeKeyValue() {
                return this.rangeKeyValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hashKeyField", om.valueToTree(this.getHashKeyField()));
                data.set("hashKeyValue", om.valueToTree(this.getHashKeyValue()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getHashKeyType() != null) {
                    data.set("hashKeyType", om.valueToTree(this.getHashKeyType()));
                }
                if (this.getOperation() != null) {
                    data.set("operation", om.valueToTree(this.getOperation()));
                }
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }
                if (this.getPayloadField() != null) {
                    data.set("payloadField", om.valueToTree(this.getPayloadField()));
                }
                if (this.getRangeKeyField() != null) {
                    data.set("rangeKeyField", om.valueToTree(this.getRangeKeyField()));
                }
                if (this.getRangeKeyType() != null) {
                    data.set("rangeKeyType", om.valueToTree(this.getRangeKeyType()));
                }
                if (this.getRangeKeyValue() != null) {
                    data.set("rangeKeyValue", om.valueToTree(this.getRangeKeyValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.DynamoDBProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBProperty.Jsii$Proxy that = (DynamoDBProperty.Jsii$Proxy) o;

                if (!hashKeyField.equals(that.hashKeyField)) return false;
                if (!hashKeyValue.equals(that.hashKeyValue)) return false;
                if (!tableName.equals(that.tableName)) return false;
                if (this.hashKeyType != null ? !this.hashKeyType.equals(that.hashKeyType) : that.hashKeyType != null) return false;
                if (this.operation != null ? !this.operation.equals(that.operation) : that.operation != null) return false;
                if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
                if (this.payloadField != null ? !this.payloadField.equals(that.payloadField) : that.payloadField != null) return false;
                if (this.rangeKeyField != null ? !this.rangeKeyField.equals(that.rangeKeyField) : that.rangeKeyField != null) return false;
                if (this.rangeKeyType != null ? !this.rangeKeyType.equals(that.rangeKeyType) : that.rangeKeyType != null) return false;
                return this.rangeKeyValue != null ? this.rangeKeyValue.equals(that.rangeKeyValue) : that.rangeKeyValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hashKeyField.hashCode();
                result = 31 * result + (this.hashKeyValue.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.hashKeyType != null ? this.hashKeyType.hashCode() : 0);
                result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                result = 31 * result + (this.payloadField != null ? this.payloadField.hashCode() : 0);
                result = 31 * result + (this.rangeKeyField != null ? this.rangeKeyField.hashCode() : 0);
                result = 31 * result + (this.rangeKeyType != null ? this.rangeKeyType.hashCode() : 0);
                result = 31 * result + (this.rangeKeyValue != null ? this.rangeKeyValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines an action to write to the Amazon DynamoDB table that you created.
     * <p>
     * The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a> . A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
     * <p>
     * You must use expressions for all parameters in <code>DynamoDBv2Action</code> . The expressions accept literals, operators, functions, references, and substitution templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>'GreenhouseTemperatureTable'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code> .</li>
     * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template.
     * <p>
     * <code>'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'</code>
     * <p>
     * <ul>
     * <li>For a string concatenation, you must use <code>+</code> . A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>tableName</code> parameter uses a string concatenation.
     * <p>
     * <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * DynamoDBv2Property dynamoDBv2Property = DynamoDBv2Property.builder()
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.DynamoDBv2Property")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBv2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBv2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html#cfn-iotevents-detectormodel-dynamodbv2-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html#cfn-iotevents-detectormodel-dynamodbv2-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * Information needed to configure the payload.
         * <p>
         * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html#cfn-iotevents-detectormodel-dynamodbv2-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html#cfn-iotevents-detectormodel-dynamodbv2-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBv2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBv2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBv2Property> {
            java.lang.String tableName;
            java.lang.Object payload;

            /**
             * Sets the value of {@link DynamoDBv2Property#getTableName}
             * @param tableName The name of the DynamoDB table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBv2Property#getPayload}
             * @param payload Information needed to configure the payload.
             *                By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBv2Property#getPayload}
             * @param payload Information needed to configure the payload.
             *                By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnDetectorModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBv2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBv2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBv2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBv2Property {
            private final java.lang.String tableName;
            private final java.lang.Object payload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.payload = builder.payload;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.DynamoDBv2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBv2Property.Jsii$Proxy that = (DynamoDBv2Property.Jsii$Proxy) o;

                if (!tableName.equals(that.tableName)) return false;
                return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tableName.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the <code>actions</code> to be performed when the <code>condition</code> evaluates to TRUE.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * EventProperty eventProperty = EventProperty.builder()
     *         .eventName("eventName")
     *         // the properties below are optional
     *         .actions(List.of(ActionProperty.builder()
     *                 .clearTimer(ClearTimerProperty.builder()
     *                         .timerName("timerName")
     *                         .build())
     *                 .dynamoDb(DynamoDBProperty.builder()
     *                         .hashKeyField("hashKeyField")
     *                         .hashKeyValue("hashKeyValue")
     *                         .tableName("tableName")
     *                         // the properties below are optional
     *                         .hashKeyType("hashKeyType")
     *                         .operation("operation")
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .payloadField("payloadField")
     *                         .rangeKeyField("rangeKeyField")
     *                         .rangeKeyType("rangeKeyType")
     *                         .rangeKeyValue("rangeKeyValue")
     *                         .build())
     *                 .dynamoDBv2(DynamoDBv2Property.builder()
     *                         .tableName("tableName")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .firehose(FirehoseProperty.builder()
     *                         .deliveryStreamName("deliveryStreamName")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .separator("separator")
     *                         .build())
     *                 .iotEvents(IotEventsProperty.builder()
     *                         .inputName("inputName")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .iotSiteWise(IotSiteWiseProperty.builder()
     *                         .propertyValue(AssetPropertyValueProperty.builder()
     *                                 .value(AssetPropertyVariantProperty.builder()
     *                                         .booleanValue("booleanValue")
     *                                         .doubleValue("doubleValue")
     *                                         .integerValue("integerValue")
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .quality("quality")
     *                                 .timestamp(AssetPropertyTimestampProperty.builder()
     *                                         .timeInSeconds("timeInSeconds")
     *                                         // the properties below are optional
     *                                         .offsetInNanos("offsetInNanos")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .assetId("assetId")
     *                         .entryId("entryId")
     *                         .propertyAlias("propertyAlias")
     *                         .propertyId("propertyId")
     *                         .build())
     *                 .iotTopicPublish(IotTopicPublishProperty.builder()
     *                         .mqttTopic("mqttTopic")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .lambda(LambdaProperty.builder()
     *                         .functionArn("functionArn")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .resetTimer(ResetTimerProperty.builder()
     *                         .timerName("timerName")
     *                         .build())
     *                 .setTimer(SetTimerProperty.builder()
     *                         .timerName("timerName")
     *                         // the properties below are optional
     *                         .durationExpression("durationExpression")
     *                         .seconds(123)
     *                         .build())
     *                 .setVariable(SetVariableProperty.builder()
     *                         .value("value")
     *                         .variableName("variableName")
     *                         .build())
     *                 .sns(SnsProperty.builder()
     *                         .targetArn("targetArn")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .sqs(SqsProperty.builder()
     *                         .queueUrl("queueUrl")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .useBase64(false)
     *                         .build())
     *                 .build()))
     *         .condition("condition")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.EventProperty")
    @software.amazon.jsii.Jsii.Proxy(EventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-eventname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-eventname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventName();

        /**
         * The actions to be performed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
            return null;
        }

        /**
         * Optional.
         * <p>
         * The Boolean expression that, when TRUE, causes the <code>actions</code> to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventProperty> {
            java.lang.String eventName;
            java.lang.Object actions;
            java.lang.String condition;

            /**
             * Sets the value of {@link EventProperty#getEventName}
             * @param eventName The name of the event. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventName(java.lang.String eventName) {
                this.eventName = eventName;
                return this;
            }

            /**
             * Sets the value of {@link EventProperty#getActions}
             * @param actions The actions to be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link EventProperty#getActions}
             * @param actions The actions to be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link EventProperty#getCondition}
             * @param condition Optional.
             *                  The Boolean expression that, when TRUE, causes the <code>actions</code> to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventProperty {
            private final java.lang.String eventName;
            private final java.lang.Object actions;
            private final java.lang.String condition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventName = software.amazon.jsii.Kernel.get(this, "eventName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventName = java.util.Objects.requireNonNull(builder.eventName, "eventName is required");
                this.actions = builder.actions;
                this.condition = builder.condition;
            }

            @Override
            public final java.lang.String getEventName() {
                return this.eventName;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventName", om.valueToTree(this.getEventName()));
                if (this.getActions() != null) {
                    data.set("actions", om.valueToTree(this.getActions()));
                }
                if (this.getCondition() != null) {
                    data.set("condition", om.valueToTree(this.getCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.EventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventProperty.Jsii$Proxy that = (EventProperty.Jsii$Proxy) o;

                if (!eventName.equals(that.eventName)) return false;
                if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
                return this.condition != null ? this.condition.equals(that.condition) : that.condition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventName.hashCode();
                result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
                result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * FirehoseProperty firehoseProperty = FirehoseProperty.builder()
     *         .deliveryStreamName("deliveryStreamName")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .separator("separator")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.FirehoseProperty")
    @software.amazon.jsii.Jsii.Proxy(FirehoseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FirehoseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Kinesis Data Firehose delivery stream where the data is written.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-deliverystreamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-deliverystreamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeliveryStreamName();

        /**
         * You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream.
         * <p>
         * Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-separator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-separator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSeparator() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FirehoseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FirehoseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FirehoseProperty> {
            java.lang.String deliveryStreamName;
            java.lang.Object payload;
            java.lang.String separator;

            /**
             * Sets the value of {@link FirehoseProperty#getDeliveryStreamName}
             * @param deliveryStreamName The name of the Kinesis Data Firehose delivery stream where the data is written. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryStreamName(java.lang.String deliveryStreamName) {
                this.deliveryStreamName = deliveryStreamName;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnDetectorModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseProperty#getSeparator}
             * @param separator A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream.
             *                  Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder separator(java.lang.String separator) {
                this.separator = separator;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FirehoseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FirehoseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FirehoseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirehoseProperty {
            private final java.lang.String deliveryStreamName;
            private final java.lang.Object payload;
            private final java.lang.String separator;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deliveryStreamName = software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.separator = software.amazon.jsii.Kernel.get(this, "separator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deliveryStreamName = java.util.Objects.requireNonNull(builder.deliveryStreamName, "deliveryStreamName is required");
                this.payload = builder.payload;
                this.separator = builder.separator;
            }

            @Override
            public final java.lang.String getDeliveryStreamName() {
                return this.deliveryStreamName;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            public final java.lang.String getSeparator() {
                return this.separator;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deliveryStreamName", om.valueToTree(this.getDeliveryStreamName()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }
                if (this.getSeparator() != null) {
                    data.set("separator", om.valueToTree(this.getSeparator()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.FirehoseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FirehoseProperty.Jsii$Proxy that = (FirehoseProperty.Jsii$Proxy) o;

                if (!deliveryStreamName.equals(that.deliveryStreamName)) return false;
                if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
                return this.separator != null ? this.separator.equals(that.separator) : that.separator == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deliveryStreamName.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                result = 31 * result + (this.separator != null ? this.separator.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * IotEventsProperty iotEventsProperty = IotEventsProperty.builder()
     *         .inputName("inputName")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.IotEventsProperty")
    @software.amazon.jsii.Jsii.Proxy(IotEventsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotEventsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AWS IoT Events input where the data is sent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html#cfn-iotevents-detectormodel-iotevents-inputname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html#cfn-iotevents-detectormodel-iotevents-inputname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputName();

        /**
         * You can configure the action payload when you send a message to an AWS IoT Events input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html#cfn-iotevents-detectormodel-iotevents-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html#cfn-iotevents-detectormodel-iotevents-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IotEventsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotEventsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotEventsProperty> {
            java.lang.String inputName;
            java.lang.Object payload;

            /**
             * Sets the value of {@link IotEventsProperty#getInputName}
             * @param inputName The name of the AWS IoT Events input where the data is sent. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputName(java.lang.String inputName) {
                this.inputName = inputName;
                return this;
            }

            /**
             * Sets the value of {@link IotEventsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an AWS IoT Events input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link IotEventsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an AWS IoT Events input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnDetectorModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotEventsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotEventsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotEventsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotEventsProperty {
            private final java.lang.String inputName;
            private final java.lang.Object payload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputName = software.amazon.jsii.Kernel.get(this, "inputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputName = java.util.Objects.requireNonNull(builder.inputName, "inputName is required");
                this.payload = builder.payload;
            }

            @Override
            public final java.lang.String getInputName() {
                return this.inputName;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputName", om.valueToTree(this.getInputName()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.IotEventsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotEventsProperty.Jsii$Proxy that = (IotEventsProperty.Jsii$Proxy) o;

                if (!inputName.equals(that.inputName)) return false;
                return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputName.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise .
     * <p>
     * You must use expressions for all parameters in <code>IotSiteWiseAction</code> . The expressions accept literals, operators, functions, references, and substitutions templates.
     * <p>
     * <strong>Examples</strong> - For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code> .
     * <p>
     * <ul>
     * <li>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code> .</li>
     * <li>For a substitution template, you must use <code>${}</code> , and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</li>
     * </ul>
     * <p>
     * In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template.
     * <p>
     * <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code>
     * <p>
     * You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <em>AWS IoT Events Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * IotSiteWiseProperty iotSiteWiseProperty = IotSiteWiseProperty.builder()
     *         .propertyValue(AssetPropertyValueProperty.builder()
     *                 .value(AssetPropertyVariantProperty.builder()
     *                         .booleanValue("booleanValue")
     *                         .doubleValue("doubleValue")
     *                         .integerValue("integerValue")
     *                         .stringValue("stringValue")
     *                         .build())
     *                 // the properties below are optional
     *                 .quality("quality")
     *                 .timestamp(AssetPropertyTimestampProperty.builder()
     *                         .timeInSeconds("timeInSeconds")
     *                         // the properties below are optional
     *                         .offsetInNanos("offsetInNanos")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .assetId("assetId")
     *         .entryId("entryId")
     *         .propertyAlias("propertyAlias")
     *         .propertyId("propertyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.IotSiteWiseProperty")
    @software.amazon.jsii.Jsii.Proxy(IotSiteWiseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotSiteWiseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value to send to the asset property.
         * <p>
         * This value contains timestamp, quality, and value (TQV) information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPropertyValue();

        /**
         * The ID of the asset that has the specified property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-assetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-assetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssetId() {
            return null;
        }

        /**
         * A unique identifier for this entry.
         * <p>
         * You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-entryid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-entryid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntryId() {
            return null;
        }

        /**
         * The alias of the asset property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyalias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyalias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyAlias() {
            return null;
        }

        /**
         * The ID of the asset property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IotSiteWiseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotSiteWiseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotSiteWiseProperty> {
            java.lang.Object propertyValue;
            java.lang.String assetId;
            java.lang.String entryId;
            java.lang.String propertyAlias;
            java.lang.String propertyId;

            /**
             * Sets the value of {@link IotSiteWiseProperty#getPropertyValue}
             * @param propertyValue The value to send to the asset property. This parameter is required.
             *                      This value contains timestamp, quality, and value (TQV) information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyValue(software.amazon.awscdk.IResolvable propertyValue) {
                this.propertyValue = propertyValue;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseProperty#getPropertyValue}
             * @param propertyValue The value to send to the asset property. This parameter is required.
             *                      This value contains timestamp, quality, and value (TQV) information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyValue(software.amazon.awscdk.services.iotevents.CfnDetectorModel.AssetPropertyValueProperty propertyValue) {
                this.propertyValue = propertyValue;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseProperty#getAssetId}
             * @param assetId The ID of the asset that has the specified property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assetId(java.lang.String assetId) {
                this.assetId = assetId;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseProperty#getEntryId}
             * @param entryId A unique identifier for this entry.
             *                You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entryId(java.lang.String entryId) {
                this.entryId = entryId;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseProperty#getPropertyAlias}
             * @param propertyAlias The alias of the asset property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyAlias(java.lang.String propertyAlias) {
                this.propertyAlias = propertyAlias;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseProperty#getPropertyId}
             * @param propertyId The ID of the asset property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyId(java.lang.String propertyId) {
                this.propertyId = propertyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotSiteWiseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotSiteWiseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotSiteWiseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotSiteWiseProperty {
            private final java.lang.Object propertyValue;
            private final java.lang.String assetId;
            private final java.lang.String entryId;
            private final java.lang.String propertyAlias;
            private final java.lang.String propertyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.propertyValue = software.amazon.jsii.Kernel.get(this, "propertyValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.assetId = software.amazon.jsii.Kernel.get(this, "assetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.entryId = software.amazon.jsii.Kernel.get(this, "entryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyAlias = software.amazon.jsii.Kernel.get(this, "propertyAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyId = software.amazon.jsii.Kernel.get(this, "propertyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.propertyValue = java.util.Objects.requireNonNull(builder.propertyValue, "propertyValue is required");
                this.assetId = builder.assetId;
                this.entryId = builder.entryId;
                this.propertyAlias = builder.propertyAlias;
                this.propertyId = builder.propertyId;
            }

            @Override
            public final java.lang.Object getPropertyValue() {
                return this.propertyValue;
            }

            @Override
            public final java.lang.String getAssetId() {
                return this.assetId;
            }

            @Override
            public final java.lang.String getEntryId() {
                return this.entryId;
            }

            @Override
            public final java.lang.String getPropertyAlias() {
                return this.propertyAlias;
            }

            @Override
            public final java.lang.String getPropertyId() {
                return this.propertyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("propertyValue", om.valueToTree(this.getPropertyValue()));
                if (this.getAssetId() != null) {
                    data.set("assetId", om.valueToTree(this.getAssetId()));
                }
                if (this.getEntryId() != null) {
                    data.set("entryId", om.valueToTree(this.getEntryId()));
                }
                if (this.getPropertyAlias() != null) {
                    data.set("propertyAlias", om.valueToTree(this.getPropertyAlias()));
                }
                if (this.getPropertyId() != null) {
                    data.set("propertyId", om.valueToTree(this.getPropertyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.IotSiteWiseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotSiteWiseProperty.Jsii$Proxy that = (IotSiteWiseProperty.Jsii$Proxy) o;

                if (!propertyValue.equals(that.propertyValue)) return false;
                if (this.assetId != null ? !this.assetId.equals(that.assetId) : that.assetId != null) return false;
                if (this.entryId != null ? !this.entryId.equals(that.entryId) : that.entryId != null) return false;
                if (this.propertyAlias != null ? !this.propertyAlias.equals(that.propertyAlias) : that.propertyAlias != null) return false;
                return this.propertyId != null ? this.propertyId.equals(that.propertyId) : that.propertyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.propertyValue.hashCode();
                result = 31 * result + (this.assetId != null ? this.assetId.hashCode() : 0);
                result = 31 * result + (this.entryId != null ? this.entryId.hashCode() : 0);
                result = 31 * result + (this.propertyAlias != null ? this.propertyAlias.hashCode() : 0);
                result = 31 * result + (this.propertyId != null ? this.propertyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information required to publish the MQTT message through the AWS IoT message broker.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * IotTopicPublishProperty iotTopicPublishProperty = IotTopicPublishProperty.builder()
     *         .mqttTopic("mqttTopic")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.IotTopicPublishProperty")
    @software.amazon.jsii.Jsii.Proxy(IotTopicPublishProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotTopicPublishProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The MQTT topic of the message.
         * <p>
         * You can use a string expression that includes variables ( <code>$variable.&lt;variable-name&gt;</code> ) and input values ( <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code> ) as the topic string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html#cfn-iotevents-detectormodel-iottopicpublish-mqtttopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html#cfn-iotevents-detectormodel-iottopicpublish-mqtttopic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMqttTopic();

        /**
         * You can configure the action payload when you publish a message to an AWS IoT Core topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html#cfn-iotevents-detectormodel-iottopicpublish-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html#cfn-iotevents-detectormodel-iottopicpublish-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IotTopicPublishProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotTopicPublishProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotTopicPublishProperty> {
            java.lang.String mqttTopic;
            java.lang.Object payload;

            /**
             * Sets the value of {@link IotTopicPublishProperty#getMqttTopic}
             * @param mqttTopic The MQTT topic of the message. This parameter is required.
             *                  You can use a string expression that includes variables ( <code>$variable.&lt;variable-name&gt;</code> ) and input values ( <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code> ) as the topic string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mqttTopic(java.lang.String mqttTopic) {
                this.mqttTopic = mqttTopic;
                return this;
            }

            /**
             * Sets the value of {@link IotTopicPublishProperty#getPayload}
             * @param payload You can configure the action payload when you publish a message to an AWS IoT Core topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link IotTopicPublishProperty#getPayload}
             * @param payload You can configure the action payload when you publish a message to an AWS IoT Core topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnDetectorModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotTopicPublishProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotTopicPublishProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotTopicPublishProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotTopicPublishProperty {
            private final java.lang.String mqttTopic;
            private final java.lang.Object payload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mqttTopic = software.amazon.jsii.Kernel.get(this, "mqttTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mqttTopic = java.util.Objects.requireNonNull(builder.mqttTopic, "mqttTopic is required");
                this.payload = builder.payload;
            }

            @Override
            public final java.lang.String getMqttTopic() {
                return this.mqttTopic;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mqttTopic", om.valueToTree(this.getMqttTopic()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.IotTopicPublishProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotTopicPublishProperty.Jsii$Proxy that = (IotTopicPublishProperty.Jsii$Proxy) o;

                if (!mqttTopic.equals(that.mqttTopic)) return false;
                return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mqttTopic.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * LambdaProperty lambdaProperty = LambdaProperty.builder()
     *         .functionArn("functionArn")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.LambdaProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Lambda function that is executed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html#cfn-iotevents-detectormodel-lambda-functionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html#cfn-iotevents-detectormodel-lambda-functionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn();

        /**
         * You can configure the action payload when you send a message to a Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html#cfn-iotevents-detectormodel-lambda-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html#cfn-iotevents-detectormodel-lambda-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaProperty> {
            java.lang.String functionArn;
            java.lang.Object payload;

            /**
             * Sets the value of {@link LambdaProperty#getFunctionArn}
             * @param functionArn The ARN of the Lambda function that is executed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionArn(java.lang.String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            /**
             * Sets the value of {@link LambdaProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to a Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link LambdaProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to a Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnDetectorModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaProperty {
            private final java.lang.String functionArn;
            private final java.lang.Object payload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionArn = java.util.Objects.requireNonNull(builder.functionArn, "functionArn is required");
                this.payload = builder.payload;
            }

            @Override
            public final java.lang.String getFunctionArn() {
                return this.functionArn;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionArn", om.valueToTree(this.getFunctionArn()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.LambdaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaProperty.Jsii$Proxy that = (LambdaProperty.Jsii$Proxy) o;

                if (!functionArn.equals(that.functionArn)) return false;
                return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.functionArn.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * OnEnterProperty onEnterProperty = OnEnterProperty.builder()
     *         .events(List.of(EventProperty.builder()
     *                 .eventName("eventName")
     *                 // the properties below are optional
     *                 .actions(List.of(ActionProperty.builder()
     *                         .clearTimer(ClearTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 .build())
     *                         .dynamoDb(DynamoDBProperty.builder()
     *                                 .hashKeyField("hashKeyField")
     *                                 .hashKeyValue("hashKeyValue")
     *                                 .tableName("tableName")
     *                                 // the properties below are optional
     *                                 .hashKeyType("hashKeyType")
     *                                 .operation("operation")
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .payloadField("payloadField")
     *                                 .rangeKeyField("rangeKeyField")
     *                                 .rangeKeyType("rangeKeyType")
     *                                 .rangeKeyValue("rangeKeyValue")
     *                                 .build())
     *                         .dynamoDBv2(DynamoDBv2Property.builder()
     *                                 .tableName("tableName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .firehose(FirehoseProperty.builder()
     *                                 .deliveryStreamName("deliveryStreamName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .separator("separator")
     *                                 .build())
     *                         .iotEvents(IotEventsProperty.builder()
     *                                 .inputName("inputName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .iotSiteWise(IotSiteWiseProperty.builder()
     *                                 .propertyValue(AssetPropertyValueProperty.builder()
     *                                         .value(AssetPropertyVariantProperty.builder()
     *                                                 .booleanValue("booleanValue")
     *                                                 .doubleValue("doubleValue")
     *                                                 .integerValue("integerValue")
     *                                                 .stringValue("stringValue")
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .quality("quality")
     *                                         .timestamp(AssetPropertyTimestampProperty.builder()
     *                                                 .timeInSeconds("timeInSeconds")
     *                                                 // the properties below are optional
     *                                                 .offsetInNanos("offsetInNanos")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .assetId("assetId")
     *                                 .entryId("entryId")
     *                                 .propertyAlias("propertyAlias")
     *                                 .propertyId("propertyId")
     *                                 .build())
     *                         .iotTopicPublish(IotTopicPublishProperty.builder()
     *                                 .mqttTopic("mqttTopic")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .lambda(LambdaProperty.builder()
     *                                 .functionArn("functionArn")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .resetTimer(ResetTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 .build())
     *                         .setTimer(SetTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 // the properties below are optional
     *                                 .durationExpression("durationExpression")
     *                                 .seconds(123)
     *                                 .build())
     *                         .setVariable(SetVariableProperty.builder()
     *                                 .value("value")
     *                                 .variableName("variableName")
     *                                 .build())
     *                         .sns(SnsProperty.builder()
     *                                 .targetArn("targetArn")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .sqs(SqsProperty.builder()
     *                                 .queueUrl("queueUrl")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .useBase64(false)
     *                                 .build())
     *                         .build()))
     *                 .condition("condition")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onenter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onenter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.OnEnterProperty")
    @software.amazon.jsii.Jsii.Proxy(OnEnterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnEnterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the actions that are performed when the state is entered and the <code>condition</code> is <code>TRUE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onenter.html#cfn-iotevents-detectormodel-onenter-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onenter.html#cfn-iotevents-detectormodel-onenter-events</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnEnterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnEnterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnEnterProperty> {
            java.lang.Object events;

            /**
             * Sets the value of {@link OnEnterProperty#getEvents}
             * @param events Specifies the actions that are performed when the state is entered and the <code>condition</code> is <code>TRUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(software.amazon.awscdk.IResolvable events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link OnEnterProperty#getEvents}
             * @param events Specifies the actions that are performed when the state is entered and the <code>condition</code> is <code>TRUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<? extends java.lang.Object> events) {
                this.events = events;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnEnterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnEnterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnEnterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnEnterProperty {
            private final java.lang.Object events;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.events = builder.events;
            }

            @Override
            public final java.lang.Object getEvents() {
                return this.events;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEvents() != null) {
                    data.set("events", om.valueToTree(this.getEvents()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.OnEnterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnEnterProperty.Jsii$Proxy that = (OnEnterProperty.Jsii$Proxy) o;

                return this.events != null ? this.events.equals(that.events) : that.events == null;
            }

            @Override
            public final int hashCode() {
                int result = this.events != null ? this.events.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * OnExitProperty onExitProperty = OnExitProperty.builder()
     *         .events(List.of(EventProperty.builder()
     *                 .eventName("eventName")
     *                 // the properties below are optional
     *                 .actions(List.of(ActionProperty.builder()
     *                         .clearTimer(ClearTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 .build())
     *                         .dynamoDb(DynamoDBProperty.builder()
     *                                 .hashKeyField("hashKeyField")
     *                                 .hashKeyValue("hashKeyValue")
     *                                 .tableName("tableName")
     *                                 // the properties below are optional
     *                                 .hashKeyType("hashKeyType")
     *                                 .operation("operation")
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .payloadField("payloadField")
     *                                 .rangeKeyField("rangeKeyField")
     *                                 .rangeKeyType("rangeKeyType")
     *                                 .rangeKeyValue("rangeKeyValue")
     *                                 .build())
     *                         .dynamoDBv2(DynamoDBv2Property.builder()
     *                                 .tableName("tableName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .firehose(FirehoseProperty.builder()
     *                                 .deliveryStreamName("deliveryStreamName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .separator("separator")
     *                                 .build())
     *                         .iotEvents(IotEventsProperty.builder()
     *                                 .inputName("inputName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .iotSiteWise(IotSiteWiseProperty.builder()
     *                                 .propertyValue(AssetPropertyValueProperty.builder()
     *                                         .value(AssetPropertyVariantProperty.builder()
     *                                                 .booleanValue("booleanValue")
     *                                                 .doubleValue("doubleValue")
     *                                                 .integerValue("integerValue")
     *                                                 .stringValue("stringValue")
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .quality("quality")
     *                                         .timestamp(AssetPropertyTimestampProperty.builder()
     *                                                 .timeInSeconds("timeInSeconds")
     *                                                 // the properties below are optional
     *                                                 .offsetInNanos("offsetInNanos")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .assetId("assetId")
     *                                 .entryId("entryId")
     *                                 .propertyAlias("propertyAlias")
     *                                 .propertyId("propertyId")
     *                                 .build())
     *                         .iotTopicPublish(IotTopicPublishProperty.builder()
     *                                 .mqttTopic("mqttTopic")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .lambda(LambdaProperty.builder()
     *                                 .functionArn("functionArn")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .resetTimer(ResetTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 .build())
     *                         .setTimer(SetTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 // the properties below are optional
     *                                 .durationExpression("durationExpression")
     *                                 .seconds(123)
     *                                 .build())
     *                         .setVariable(SetVariableProperty.builder()
     *                                 .value("value")
     *                                 .variableName("variableName")
     *                                 .build())
     *                         .sns(SnsProperty.builder()
     *                                 .targetArn("targetArn")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .sqs(SqsProperty.builder()
     *                                 .queueUrl("queueUrl")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .useBase64(false)
     *                                 .build())
     *                         .build()))
     *                 .condition("condition")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onexit.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onexit.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.OnExitProperty")
    @software.amazon.jsii.Jsii.Proxy(OnExitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnExitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the <code>actions</code> that are performed when the state is exited and the <code>condition</code> is <code>TRUE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onexit.html#cfn-iotevents-detectormodel-onexit-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onexit.html#cfn-iotevents-detectormodel-onexit-events</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnExitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnExitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnExitProperty> {
            java.lang.Object events;

            /**
             * Sets the value of {@link OnExitProperty#getEvents}
             * @param events Specifies the <code>actions</code> that are performed when the state is exited and the <code>condition</code> is <code>TRUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(software.amazon.awscdk.IResolvable events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link OnExitProperty#getEvents}
             * @param events Specifies the <code>actions</code> that are performed when the state is exited and the <code>condition</code> is <code>TRUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<? extends java.lang.Object> events) {
                this.events = events;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnExitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnExitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnExitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnExitProperty {
            private final java.lang.Object events;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.events = builder.events;
            }

            @Override
            public final java.lang.Object getEvents() {
                return this.events;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEvents() != null) {
                    data.set("events", om.valueToTree(this.getEvents()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.OnExitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnExitProperty.Jsii$Proxy that = (OnExitProperty.Jsii$Proxy) o;

                return this.events != null ? this.events.equals(that.events) : that.events == null;
            }

            @Override
            public final int hashCode() {
                int result = this.events != null ? this.events.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the actions performed when the <code>condition</code> evaluates to TRUE.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * OnInputProperty onInputProperty = OnInputProperty.builder()
     *         .events(List.of(EventProperty.builder()
     *                 .eventName("eventName")
     *                 // the properties below are optional
     *                 .actions(List.of(ActionProperty.builder()
     *                         .clearTimer(ClearTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 .build())
     *                         .dynamoDb(DynamoDBProperty.builder()
     *                                 .hashKeyField("hashKeyField")
     *                                 .hashKeyValue("hashKeyValue")
     *                                 .tableName("tableName")
     *                                 // the properties below are optional
     *                                 .hashKeyType("hashKeyType")
     *                                 .operation("operation")
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .payloadField("payloadField")
     *                                 .rangeKeyField("rangeKeyField")
     *                                 .rangeKeyType("rangeKeyType")
     *                                 .rangeKeyValue("rangeKeyValue")
     *                                 .build())
     *                         .dynamoDBv2(DynamoDBv2Property.builder()
     *                                 .tableName("tableName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .firehose(FirehoseProperty.builder()
     *                                 .deliveryStreamName("deliveryStreamName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .separator("separator")
     *                                 .build())
     *                         .iotEvents(IotEventsProperty.builder()
     *                                 .inputName("inputName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .iotSiteWise(IotSiteWiseProperty.builder()
     *                                 .propertyValue(AssetPropertyValueProperty.builder()
     *                                         .value(AssetPropertyVariantProperty.builder()
     *                                                 .booleanValue("booleanValue")
     *                                                 .doubleValue("doubleValue")
     *                                                 .integerValue("integerValue")
     *                                                 .stringValue("stringValue")
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .quality("quality")
     *                                         .timestamp(AssetPropertyTimestampProperty.builder()
     *                                                 .timeInSeconds("timeInSeconds")
     *                                                 // the properties below are optional
     *                                                 .offsetInNanos("offsetInNanos")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .assetId("assetId")
     *                                 .entryId("entryId")
     *                                 .propertyAlias("propertyAlias")
     *                                 .propertyId("propertyId")
     *                                 .build())
     *                         .iotTopicPublish(IotTopicPublishProperty.builder()
     *                                 .mqttTopic("mqttTopic")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .lambda(LambdaProperty.builder()
     *                                 .functionArn("functionArn")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .resetTimer(ResetTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 .build())
     *                         .setTimer(SetTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 // the properties below are optional
     *                                 .durationExpression("durationExpression")
     *                                 .seconds(123)
     *                                 .build())
     *                         .setVariable(SetVariableProperty.builder()
     *                                 .value("value")
     *                                 .variableName("variableName")
     *                                 .build())
     *                         .sns(SnsProperty.builder()
     *                                 .targetArn("targetArn")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .sqs(SqsProperty.builder()
     *                                 .queueUrl("queueUrl")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .useBase64(false)
     *                                 .build())
     *                         .build()))
     *                 .condition("condition")
     *                 .build()))
     *         .transitionEvents(List.of(TransitionEventProperty.builder()
     *                 .condition("condition")
     *                 .eventName("eventName")
     *                 .nextState("nextState")
     *                 // the properties below are optional
     *                 .actions(List.of(ActionProperty.builder()
     *                         .clearTimer(ClearTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 .build())
     *                         .dynamoDb(DynamoDBProperty.builder()
     *                                 .hashKeyField("hashKeyField")
     *                                 .hashKeyValue("hashKeyValue")
     *                                 .tableName("tableName")
     *                                 // the properties below are optional
     *                                 .hashKeyType("hashKeyType")
     *                                 .operation("operation")
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .payloadField("payloadField")
     *                                 .rangeKeyField("rangeKeyField")
     *                                 .rangeKeyType("rangeKeyType")
     *                                 .rangeKeyValue("rangeKeyValue")
     *                                 .build())
     *                         .dynamoDBv2(DynamoDBv2Property.builder()
     *                                 .tableName("tableName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .firehose(FirehoseProperty.builder()
     *                                 .deliveryStreamName("deliveryStreamName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .separator("separator")
     *                                 .build())
     *                         .iotEvents(IotEventsProperty.builder()
     *                                 .inputName("inputName")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .iotSiteWise(IotSiteWiseProperty.builder()
     *                                 .propertyValue(AssetPropertyValueProperty.builder()
     *                                         .value(AssetPropertyVariantProperty.builder()
     *                                                 .booleanValue("booleanValue")
     *                                                 .doubleValue("doubleValue")
     *                                                 .integerValue("integerValue")
     *                                                 .stringValue("stringValue")
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .quality("quality")
     *                                         .timestamp(AssetPropertyTimestampProperty.builder()
     *                                                 .timeInSeconds("timeInSeconds")
     *                                                 // the properties below are optional
     *                                                 .offsetInNanos("offsetInNanos")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .assetId("assetId")
     *                                 .entryId("entryId")
     *                                 .propertyAlias("propertyAlias")
     *                                 .propertyId("propertyId")
     *                                 .build())
     *                         .iotTopicPublish(IotTopicPublishProperty.builder()
     *                                 .mqttTopic("mqttTopic")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .lambda(LambdaProperty.builder()
     *                                 .functionArn("functionArn")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .resetTimer(ResetTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 .build())
     *                         .setTimer(SetTimerProperty.builder()
     *                                 .timerName("timerName")
     *                                 // the properties below are optional
     *                                 .durationExpression("durationExpression")
     *                                 .seconds(123)
     *                                 .build())
     *                         .setVariable(SetVariableProperty.builder()
     *                                 .value("value")
     *                                 .variableName("variableName")
     *                                 .build())
     *                         .sns(SnsProperty.builder()
     *                                 .targetArn("targetArn")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .sqs(SqsProperty.builder()
     *                                 .queueUrl("queueUrl")
     *                                 // the properties below are optional
     *                                 .payload(PayloadProperty.builder()
     *                                         .contentExpression("contentExpression")
     *                                         .type("type")
     *                                         .build())
     *                                 .useBase64(false)
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.OnInputProperty")
    @software.amazon.jsii.Jsii.Proxy(OnInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the actions performed when the <code>condition</code> evaluates to TRUE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html#cfn-iotevents-detectormodel-oninput-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html#cfn-iotevents-detectormodel-oninput-events</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
            return null;
        }

        /**
         * Specifies the actions performed, and the next state entered, when a <code>condition</code> evaluates to TRUE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html#cfn-iotevents-detectormodel-oninput-transitionevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html#cfn-iotevents-detectormodel-oninput-transitionevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransitionEvents() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnInputProperty> {
            java.lang.Object events;
            java.lang.Object transitionEvents;

            /**
             * Sets the value of {@link OnInputProperty#getEvents}
             * @param events Specifies the actions performed when the <code>condition</code> evaluates to TRUE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(software.amazon.awscdk.IResolvable events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link OnInputProperty#getEvents}
             * @param events Specifies the actions performed when the <code>condition</code> evaluates to TRUE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<? extends java.lang.Object> events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link OnInputProperty#getTransitionEvents}
             * @param transitionEvents Specifies the actions performed, and the next state entered, when a <code>condition</code> evaluates to TRUE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionEvents(software.amazon.awscdk.IResolvable transitionEvents) {
                this.transitionEvents = transitionEvents;
                return this;
            }

            /**
             * Sets the value of {@link OnInputProperty#getTransitionEvents}
             * @param transitionEvents Specifies the actions performed, and the next state entered, when a <code>condition</code> evaluates to TRUE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionEvents(java.util.List<? extends java.lang.Object> transitionEvents) {
                this.transitionEvents = transitionEvents;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnInputProperty {
            private final java.lang.Object events;
            private final java.lang.Object transitionEvents;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transitionEvents = software.amazon.jsii.Kernel.get(this, "transitionEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.events = builder.events;
                this.transitionEvents = builder.transitionEvents;
            }

            @Override
            public final java.lang.Object getEvents() {
                return this.events;
            }

            @Override
            public final java.lang.Object getTransitionEvents() {
                return this.transitionEvents;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEvents() != null) {
                    data.set("events", om.valueToTree(this.getEvents()));
                }
                if (this.getTransitionEvents() != null) {
                    data.set("transitionEvents", om.valueToTree(this.getTransitionEvents()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.OnInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnInputProperty.Jsii$Proxy that = (OnInputProperty.Jsii$Proxy) o;

                if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
                return this.transitionEvents != null ? this.transitionEvents.equals(that.transitionEvents) : that.transitionEvents == null;
            }

            @Override
            public final int hashCode() {
                int result = this.events != null ? this.events.hashCode() : 0;
                result = 31 * result + (this.transitionEvents != null ? this.transitionEvents.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information needed to configure the payload.
     * <p>
     * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * PayloadProperty payloadProperty = PayloadProperty.builder()
     *         .contentExpression("contentExpression")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.PayloadProperty")
    @software.amazon.jsii.Jsii.Proxy(PayloadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PayloadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The content of the payload.
         * <p>
         * You can use a string expression that includes quoted strings ( <code>'&lt;string&gt;'</code> ), variables ( <code>$variable.&lt;variable-name&gt;</code> ), input values ( <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code> ), string concatenations, and quoted strings that contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html#cfn-iotevents-detectormodel-payload-contentexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html#cfn-iotevents-detectormodel-payload-contentexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContentExpression();

        /**
         * The value of the payload type can be either <code>STRING</code> or <code>JSON</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html#cfn-iotevents-detectormodel-payload-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html#cfn-iotevents-detectormodel-payload-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link PayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PayloadProperty> {
            java.lang.String contentExpression;
            java.lang.String type;

            /**
             * Sets the value of {@link PayloadProperty#getContentExpression}
             * @param contentExpression The content of the payload. This parameter is required.
             *                          You can use a string expression that includes quoted strings ( <code>'&lt;string&gt;'</code> ), variables ( <code>$variable.&lt;variable-name&gt;</code> ), input values ( <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code> ), string concatenations, and quoted strings that contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentExpression(java.lang.String contentExpression) {
                this.contentExpression = contentExpression;
                return this;
            }

            /**
             * Sets the value of {@link PayloadProperty#getType}
             * @param type The value of the payload type can be either <code>STRING</code> or <code>JSON</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PayloadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PayloadProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PayloadProperty {
            private final java.lang.String contentExpression;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contentExpression = software.amazon.jsii.Kernel.get(this, "contentExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contentExpression = java.util.Objects.requireNonNull(builder.contentExpression, "contentExpression is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getContentExpression() {
                return this.contentExpression;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("contentExpression", om.valueToTree(this.getContentExpression()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.PayloadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PayloadProperty.Jsii$Proxy that = (PayloadProperty.Jsii$Proxy) o;

                if (!contentExpression.equals(that.contentExpression)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.contentExpression.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Information required to reset the timer.
     * <p>
     * The timer is reset to the previously evaluated result of the duration. The duration expression isn't reevaluated when you reset the timer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * ResetTimerProperty resetTimerProperty = ResetTimerProperty.builder()
     *         .timerName("timerName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-resettimer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-resettimer.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.ResetTimerProperty")
    @software.amazon.jsii.Jsii.Proxy(ResetTimerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResetTimerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the timer to reset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-resettimer.html#cfn-iotevents-detectormodel-resettimer-timername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-resettimer.html#cfn-iotevents-detectormodel-resettimer-timername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimerName();

        /**
         * @return a {@link Builder} of {@link ResetTimerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResetTimerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResetTimerProperty> {
            java.lang.String timerName;

            /**
             * Sets the value of {@link ResetTimerProperty#getTimerName}
             * @param timerName The name of the timer to reset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timerName(java.lang.String timerName) {
                this.timerName = timerName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResetTimerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResetTimerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResetTimerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResetTimerProperty {
            private final java.lang.String timerName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timerName = software.amazon.jsii.Kernel.get(this, "timerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timerName = java.util.Objects.requireNonNull(builder.timerName, "timerName is required");
            }

            @Override
            public final java.lang.String getTimerName() {
                return this.timerName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timerName", om.valueToTree(this.getTimerName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.ResetTimerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResetTimerProperty.Jsii$Proxy that = (ResetTimerProperty.Jsii$Proxy) o;

                return this.timerName.equals(that.timerName);
            }

            @Override
            public final int hashCode() {
                int result = this.timerName.hashCode();
                return result;
            }
        }
    }
    /**
     * Information needed to set the timer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * SetTimerProperty setTimerProperty = SetTimerProperty.builder()
     *         .timerName("timerName")
     *         // the properties below are optional
     *         .durationExpression("durationExpression")
     *         .seconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.SetTimerProperty")
    @software.amazon.jsii.Jsii.Proxy(SetTimerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SetTimerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the timer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-timername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-timername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimerName();

        /**
         * The duration of the timer, in seconds.
         * <p>
         * You can use a string expression that includes numbers, variables ( <code>$variable.&lt;variable-name&gt;</code> ), and input values ( <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code> ) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-durationexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-durationexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDurationExpression() {
            return null;
        }

        /**
         * The number of seconds until the timer expires.
         * <p>
         * The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-seconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-seconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SetTimerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SetTimerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SetTimerProperty> {
            java.lang.String timerName;
            java.lang.String durationExpression;
            java.lang.Number seconds;

            /**
             * Sets the value of {@link SetTimerProperty#getTimerName}
             * @param timerName The name of the timer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timerName(java.lang.String timerName) {
                this.timerName = timerName;
                return this;
            }

            /**
             * Sets the value of {@link SetTimerProperty#getDurationExpression}
             * @param durationExpression The duration of the timer, in seconds.
             *                           You can use a string expression that includes numbers, variables ( <code>$variable.&lt;variable-name&gt;</code> ), and input values ( <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code> ) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationExpression(java.lang.String durationExpression) {
                this.durationExpression = durationExpression;
                return this;
            }

            /**
             * Sets the value of {@link SetTimerProperty#getSeconds}
             * @param seconds The number of seconds until the timer expires.
             *                The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seconds(java.lang.Number seconds) {
                this.seconds = seconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SetTimerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SetTimerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SetTimerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SetTimerProperty {
            private final java.lang.String timerName;
            private final java.lang.String durationExpression;
            private final java.lang.Number seconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timerName = software.amazon.jsii.Kernel.get(this, "timerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.durationExpression = software.amazon.jsii.Kernel.get(this, "durationExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.seconds = software.amazon.jsii.Kernel.get(this, "seconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timerName = java.util.Objects.requireNonNull(builder.timerName, "timerName is required");
                this.durationExpression = builder.durationExpression;
                this.seconds = builder.seconds;
            }

            @Override
            public final java.lang.String getTimerName() {
                return this.timerName;
            }

            @Override
            public final java.lang.String getDurationExpression() {
                return this.durationExpression;
            }

            @Override
            public final java.lang.Number getSeconds() {
                return this.seconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timerName", om.valueToTree(this.getTimerName()));
                if (this.getDurationExpression() != null) {
                    data.set("durationExpression", om.valueToTree(this.getDurationExpression()));
                }
                if (this.getSeconds() != null) {
                    data.set("seconds", om.valueToTree(this.getSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.SetTimerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SetTimerProperty.Jsii$Proxy that = (SetTimerProperty.Jsii$Proxy) o;

                if (!timerName.equals(that.timerName)) return false;
                if (this.durationExpression != null ? !this.durationExpression.equals(that.durationExpression) : that.durationExpression != null) return false;
                return this.seconds != null ? this.seconds.equals(that.seconds) : that.seconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timerName.hashCode();
                result = 31 * result + (this.durationExpression != null ? this.durationExpression.hashCode() : 0);
                result = 31 * result + (this.seconds != null ? this.seconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the variable and its new value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * SetVariableProperty setVariableProperty = SetVariableProperty.builder()
     *         .value("value")
     *         .variableName("variableName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.SetVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(SetVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SetVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The new value of the variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html#cfn-iotevents-detectormodel-setvariable-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html#cfn-iotevents-detectormodel-setvariable-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * The name of the variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html#cfn-iotevents-detectormodel-setvariable-variablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html#cfn-iotevents-detectormodel-setvariable-variablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVariableName();

        /**
         * @return a {@link Builder} of {@link SetVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SetVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SetVariableProperty> {
            java.lang.String value;
            java.lang.String variableName;

            /**
             * Sets the value of {@link SetVariableProperty#getValue}
             * @param value The new value of the variable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link SetVariableProperty#getVariableName}
             * @param variableName The name of the variable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variableName(java.lang.String variableName) {
                this.variableName = variableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SetVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SetVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SetVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SetVariableProperty {
            private final java.lang.String value;
            private final java.lang.String variableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.variableName = software.amazon.jsii.Kernel.get(this, "variableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.variableName = java.util.Objects.requireNonNull(builder.variableName, "variableName is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getVariableName() {
                return this.variableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));
                data.set("variableName", om.valueToTree(this.getVariableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.SetVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SetVariableProperty.Jsii$Proxy that = (SetVariableProperty.Jsii$Proxy) o;

                if (!value.equals(that.value)) return false;
                return this.variableName.equals(that.variableName);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                result = 31 * result + (this.variableName.hashCode());
                return result;
            }
        }
    }
    /**
     * Information required to publish the Amazon SNS message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * SnsProperty snsProperty = SnsProperty.builder()
     *         .targetArn("targetArn")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.SnsProperty")
    @software.amazon.jsii.Jsii.Proxy(SnsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Amazon SNS target where the message is sent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html#cfn-iotevents-detectormodel-sns-targetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html#cfn-iotevents-detectormodel-sns-targetarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

        /**
         * You can configure the action payload when you send a message as an Amazon SNS push notification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html#cfn-iotevents-detectormodel-sns-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html#cfn-iotevents-detectormodel-sns-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnsProperty> {
            java.lang.String targetArn;
            java.lang.Object payload;

            /**
             * Sets the value of {@link SnsProperty#getTargetArn}
             * @param targetArn The ARN of the Amazon SNS target where the message is sent. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetArn(java.lang.String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            /**
             * Sets the value of {@link SnsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message as an Amazon SNS push notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link SnsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message as an Amazon SNS push notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnDetectorModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnsProperty {
            private final java.lang.String targetArn;
            private final java.lang.Object payload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
                this.payload = builder.payload;
            }

            @Override
            public final java.lang.String getTargetArn() {
                return this.targetArn;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetArn", om.valueToTree(this.getTargetArn()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.SnsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnsProperty.Jsii$Proxy that = (SnsProperty.Jsii$Proxy) o;

                if (!targetArn.equals(that.targetArn)) return false;
                return this.payload != null ? this.payload.equals(that.payload) : that.payload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetArn.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * SqsProperty sqsProperty = SqsProperty.builder()
     *         .queueUrl("queueUrl")
     *         // the properties below are optional
     *         .payload(PayloadProperty.builder()
     *                 .contentExpression("contentExpression")
     *                 .type("type")
     *                 .build())
     *         .useBase64(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.SqsProperty")
    @software.amazon.jsii.Jsii.Proxy(SqsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL of the SQS queue where the data is written.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-queueurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-queueurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueueUrl();

        /**
         * You can configure the action payload when you send a message to an Amazon SQS queue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPayload() {
            return null;
        }

        /**
         * Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue.
         * <p>
         * Otherwise, set this to FALSE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-usebase64">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-usebase64</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseBase64() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SqsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SqsProperty> {
            java.lang.String queueUrl;
            java.lang.Object payload;
            java.lang.Object useBase64;

            /**
             * Sets the value of {@link SqsProperty#getQueueUrl}
             * @param queueUrl The URL of the SQS queue where the data is written. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueUrl(java.lang.String queueUrl) {
                this.queueUrl = queueUrl;
                return this;
            }

            /**
             * Sets the value of {@link SqsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an Amazon SQS queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.IResolvable payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link SqsProperty#getPayload}
             * @param payload You can configure the action payload when you send a message to an Amazon SQS queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(software.amazon.awscdk.services.iotevents.CfnDetectorModel.PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link SqsProperty#getUseBase64}
             * @param useBase64 Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue.
             *                  Otherwise, set this to FALSE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBase64(java.lang.Boolean useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            /**
             * Sets the value of {@link SqsProperty#getUseBase64}
             * @param useBase64 Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue.
             *                  Otherwise, set this to FALSE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBase64(software.amazon.awscdk.IResolvable useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SqsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SqsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqsProperty {
            private final java.lang.String queueUrl;
            private final java.lang.Object payload;
            private final java.lang.Object useBase64;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queueUrl = software.amazon.jsii.Kernel.get(this, "queueUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useBase64 = software.amazon.jsii.Kernel.get(this, "useBase64", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queueUrl = java.util.Objects.requireNonNull(builder.queueUrl, "queueUrl is required");
                this.payload = builder.payload;
                this.useBase64 = builder.useBase64;
            }

            @Override
            public final java.lang.String getQueueUrl() {
                return this.queueUrl;
            }

            @Override
            public final java.lang.Object getPayload() {
                return this.payload;
            }

            @Override
            public final java.lang.Object getUseBase64() {
                return this.useBase64;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queueUrl", om.valueToTree(this.getQueueUrl()));
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }
                if (this.getUseBase64() != null) {
                    data.set("useBase64", om.valueToTree(this.getUseBase64()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.SqsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqsProperty.Jsii$Proxy that = (SqsProperty.Jsii$Proxy) o;

                if (!queueUrl.equals(that.queueUrl)) return false;
                if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
                return this.useBase64 != null ? this.useBase64.equals(that.useBase64) : that.useBase64 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queueUrl.hashCode();
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                result = 31 * result + (this.useBase64 != null ? this.useBase64.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information that defines a state of a detector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.StateProperty")
    @software.amazon.jsii.Jsii.Proxy(StateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the state.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-statename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-statename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStateName();

        /**
         * When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-onenter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-onenter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnEnter() {
            return null;
        }

        /**
         * When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-onexit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-onexit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnExit() {
            return null;
        }

        /**
         * When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-oninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-oninput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnInput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StateProperty> {
            java.lang.String stateName;
            java.lang.Object onEnter;
            java.lang.Object onExit;
            java.lang.Object onInput;

            /**
             * Sets the value of {@link StateProperty#getStateName}
             * @param stateName The name of the state. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateName(java.lang.String stateName) {
                this.stateName = stateName;
                return this;
            }

            /**
             * Sets the value of {@link StateProperty#getOnEnter}
             * @param onEnter When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onEnter(software.amazon.awscdk.IResolvable onEnter) {
                this.onEnter = onEnter;
                return this;
            }

            /**
             * Sets the value of {@link StateProperty#getOnEnter}
             * @param onEnter When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onEnter(software.amazon.awscdk.services.iotevents.CfnDetectorModel.OnEnterProperty onEnter) {
                this.onEnter = onEnter;
                return this;
            }

            /**
             * Sets the value of {@link StateProperty#getOnExit}
             * @param onExit When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onExit(software.amazon.awscdk.IResolvable onExit) {
                this.onExit = onExit;
                return this;
            }

            /**
             * Sets the value of {@link StateProperty#getOnExit}
             * @param onExit When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onExit(software.amazon.awscdk.services.iotevents.CfnDetectorModel.OnExitProperty onExit) {
                this.onExit = onExit;
                return this;
            }

            /**
             * Sets the value of {@link StateProperty#getOnInput}
             * @param onInput When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onInput(software.amazon.awscdk.IResolvable onInput) {
                this.onInput = onInput;
                return this;
            }

            /**
             * Sets the value of {@link StateProperty#getOnInput}
             * @param onInput When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onInput(software.amazon.awscdk.services.iotevents.CfnDetectorModel.OnInputProperty onInput) {
                this.onInput = onInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateProperty {
            private final java.lang.String stateName;
            private final java.lang.Object onEnter;
            private final java.lang.Object onExit;
            private final java.lang.Object onInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onEnter = software.amazon.jsii.Kernel.get(this, "onEnter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onExit = software.amazon.jsii.Kernel.get(this, "onExit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onInput = software.amazon.jsii.Kernel.get(this, "onInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stateName = java.util.Objects.requireNonNull(builder.stateName, "stateName is required");
                this.onEnter = builder.onEnter;
                this.onExit = builder.onExit;
                this.onInput = builder.onInput;
            }

            @Override
            public final java.lang.String getStateName() {
                return this.stateName;
            }

            @Override
            public final java.lang.Object getOnEnter() {
                return this.onEnter;
            }

            @Override
            public final java.lang.Object getOnExit() {
                return this.onExit;
            }

            @Override
            public final java.lang.Object getOnInput() {
                return this.onInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("stateName", om.valueToTree(this.getStateName()));
                if (this.getOnEnter() != null) {
                    data.set("onEnter", om.valueToTree(this.getOnEnter()));
                }
                if (this.getOnExit() != null) {
                    data.set("onExit", om.valueToTree(this.getOnExit()));
                }
                if (this.getOnInput() != null) {
                    data.set("onInput", om.valueToTree(this.getOnInput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.StateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StateProperty.Jsii$Proxy that = (StateProperty.Jsii$Proxy) o;

                if (!stateName.equals(that.stateName)) return false;
                if (this.onEnter != null ? !this.onEnter.equals(that.onEnter) : that.onEnter != null) return false;
                if (this.onExit != null ? !this.onExit.equals(that.onExit) : that.onExit != null) return false;
                return this.onInput != null ? this.onInput.equals(that.onInput) : that.onInput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.stateName.hashCode();
                result = 31 * result + (this.onEnter != null ? this.onEnter.hashCode() : 0);
                result = 31 * result + (this.onExit != null ? this.onExit.hashCode() : 0);
                result = 31 * result + (this.onInput != null ? this.onInput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the actions performed and the next state entered when a <code>condition</code> evaluates to TRUE.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotevents.*;
     * TransitionEventProperty transitionEventProperty = TransitionEventProperty.builder()
     *         .condition("condition")
     *         .eventName("eventName")
     *         .nextState("nextState")
     *         // the properties below are optional
     *         .actions(List.of(ActionProperty.builder()
     *                 .clearTimer(ClearTimerProperty.builder()
     *                         .timerName("timerName")
     *                         .build())
     *                 .dynamoDb(DynamoDBProperty.builder()
     *                         .hashKeyField("hashKeyField")
     *                         .hashKeyValue("hashKeyValue")
     *                         .tableName("tableName")
     *                         // the properties below are optional
     *                         .hashKeyType("hashKeyType")
     *                         .operation("operation")
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .payloadField("payloadField")
     *                         .rangeKeyField("rangeKeyField")
     *                         .rangeKeyType("rangeKeyType")
     *                         .rangeKeyValue("rangeKeyValue")
     *                         .build())
     *                 .dynamoDBv2(DynamoDBv2Property.builder()
     *                         .tableName("tableName")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .firehose(FirehoseProperty.builder()
     *                         .deliveryStreamName("deliveryStreamName")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .separator("separator")
     *                         .build())
     *                 .iotEvents(IotEventsProperty.builder()
     *                         .inputName("inputName")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .iotSiteWise(IotSiteWiseProperty.builder()
     *                         .propertyValue(AssetPropertyValueProperty.builder()
     *                                 .value(AssetPropertyVariantProperty.builder()
     *                                         .booleanValue("booleanValue")
     *                                         .doubleValue("doubleValue")
     *                                         .integerValue("integerValue")
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .quality("quality")
     *                                 .timestamp(AssetPropertyTimestampProperty.builder()
     *                                         .timeInSeconds("timeInSeconds")
     *                                         // the properties below are optional
     *                                         .offsetInNanos("offsetInNanos")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .assetId("assetId")
     *                         .entryId("entryId")
     *                         .propertyAlias("propertyAlias")
     *                         .propertyId("propertyId")
     *                         .build())
     *                 .iotTopicPublish(IotTopicPublishProperty.builder()
     *                         .mqttTopic("mqttTopic")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .lambda(LambdaProperty.builder()
     *                         .functionArn("functionArn")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .resetTimer(ResetTimerProperty.builder()
     *                         .timerName("timerName")
     *                         .build())
     *                 .setTimer(SetTimerProperty.builder()
     *                         .timerName("timerName")
     *                         // the properties below are optional
     *                         .durationExpression("durationExpression")
     *                         .seconds(123)
     *                         .build())
     *                 .setVariable(SetVariableProperty.builder()
     *                         .value("value")
     *                         .variableName("variableName")
     *                         .build())
     *                 .sns(SnsProperty.builder()
     *                         .targetArn("targetArn")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .sqs(SqsProperty.builder()
     *                         .queueUrl("queueUrl")
     *                         // the properties below are optional
     *                         .payload(PayloadProperty.builder()
     *                                 .contentExpression("contentExpression")
     *                                 .type("type")
     *                                 .build())
     *                         .useBase64(false)
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnDetectorModel.TransitionEventProperty")
    @software.amazon.jsii.Jsii.Proxy(TransitionEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransitionEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Required.
         * <p>
         * A Boolean expression that when TRUE causes the actions to be performed and the <code>nextState</code> to be entered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * The name of the transition event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-eventname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-eventname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventName();

        /**
         * The next state to enter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-nextstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-nextstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNextState();

        /**
         * The actions to be performed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransitionEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransitionEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransitionEventProperty> {
            java.lang.String condition;
            java.lang.String eventName;
            java.lang.String nextState;
            java.lang.Object actions;

            /**
             * Sets the value of {@link TransitionEventProperty#getCondition}
             * @param condition Required. This parameter is required.
             *                  A Boolean expression that when TRUE causes the actions to be performed and the <code>nextState</code> to be entered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link TransitionEventProperty#getEventName}
             * @param eventName The name of the transition event. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventName(java.lang.String eventName) {
                this.eventName = eventName;
                return this;
            }

            /**
             * Sets the value of {@link TransitionEventProperty#getNextState}
             * @param nextState The next state to enter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextState(java.lang.String nextState) {
                this.nextState = nextState;
                return this;
            }

            /**
             * Sets the value of {@link TransitionEventProperty#getActions}
             * @param actions The actions to be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link TransitionEventProperty#getActions}
             * @param actions The actions to be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitionEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransitionEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransitionEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitionEventProperty {
            private final java.lang.String condition;
            private final java.lang.String eventName;
            private final java.lang.String nextState;
            private final java.lang.Object actions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventName = software.amazon.jsii.Kernel.get(this, "eventName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nextState = software.amazon.jsii.Kernel.get(this, "nextState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
                this.eventName = java.util.Objects.requireNonNull(builder.eventName, "eventName is required");
                this.nextState = java.util.Objects.requireNonNull(builder.nextState, "nextState is required");
                this.actions = builder.actions;
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getEventName() {
                return this.eventName;
            }

            @Override
            public final java.lang.String getNextState() {
                return this.nextState;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("condition", om.valueToTree(this.getCondition()));
                data.set("eventName", om.valueToTree(this.getEventName()));
                data.set("nextState", om.valueToTree(this.getNextState()));
                if (this.getActions() != null) {
                    data.set("actions", om.valueToTree(this.getActions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnDetectorModel.TransitionEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransitionEventProperty.Jsii$Proxy that = (TransitionEventProperty.Jsii$Proxy) o;

                if (!condition.equals(that.condition)) return false;
                if (!eventName.equals(that.eventName)) return false;
                if (!nextState.equals(that.nextState)) return false;
                return this.actions != null ? this.actions.equals(that.actions) : that.actions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.condition.hashCode();
                result = 31 * result + (this.eventName.hashCode());
                result = 31 * result + (this.nextState.hashCode());
                result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotevents.CfnDetectorModel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotevents.CfnDetectorModel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotevents.CfnDetectorModelProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotevents.CfnDetectorModelProps.Builder();
        }

        /**
         * Information that defines how a detector operates.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition</a>
         * @param detectorModelDefinition Information that defines how a detector operates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorModelDefinition(final software.amazon.awscdk.IResolvable detectorModelDefinition) {
            this.props.detectorModelDefinition(detectorModelDefinition);
            return this;
        }
        /**
         * Information that defines how a detector operates.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition</a>
         * @param detectorModelDefinition Information that defines how a detector operates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorModelDefinition(final software.amazon.awscdk.services.iotevents.CfnDetectorModel.DetectorModelDefinitionProperty detectorModelDefinition) {
            this.props.detectorModelDefinition(detectorModelDefinition);
            return this;
        }

        /**
         * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-rolearn</a>
         * @param roleArn The ARN of the role that grants permission to AWS IoT Events to perform its operations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * A brief description of the detector model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldescription</a>
         * @param detectorModelDescription A brief description of the detector model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorModelDescription(final java.lang.String detectorModelDescription) {
            this.props.detectorModelDescription(detectorModelDescription);
            return this;
        }

        /**
         * The name of the detector model.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodelname</a>
         * @param detectorModelName The name of the detector model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorModelName(final java.lang.String detectorModelName) {
            this.props.detectorModelName(detectorModelName);
            return this;
        }

        /**
         * Information about the order in which events are evaluated and how actions are executed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-evaluationmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-evaluationmethod</a>
         * @param evaluationMethod Information about the order in which events are evaluated and how actions are executed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationMethod(final java.lang.String evaluationMethod) {
            this.props.evaluationMethod(evaluationMethod);
            return this;
        }

        /**
         * The value used to identify a detector instance.
         * <p>
         * When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information.
         * <p>
         * This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-key</a>
         * @param key The value used to identify a detector instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(final java.lang.String key) {
            this.props.key(key);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotevents.CfnDetectorModel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotevents.CfnDetectorModel build() {
            return new software.amazon.awscdk.services.iotevents.CfnDetectorModel(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
