package software.amazon.awscdk.services.ivs;

/**
 * Properties for defining a <code>CfnChannel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ivs.*;
 * CfnChannelProps cfnChannelProps = CfnChannelProps.builder()
 *         .authorized(false)
 *         .insecureIngest(false)
 *         .latencyMode("latencyMode")
 *         .name("name")
 *         .preset("preset")
 *         .recordingConfigurationArn("recordingConfigurationArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:59.231Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnChannelProps")
@software.amazon.jsii.Jsii.Proxy(CfnChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the channel is authorized.
     * <p>
     * <em>Default</em> : <code>false</code>
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-authorized">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-authorized</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorized() {
        return null;
    }

    /**
     * Whether the channel allows insecure RTMP ingest.
     * <p>
     * <em>Default</em> : <code>false</code>
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-insecureingest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-insecureingest</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInsecureIngest() {
        return null;
    }

    /**
     * Channel latency mode. Valid values:.
     * <p>
     * <ul>
     * <li><code>NORMAL</code> : Use NORMAL to broadcast and deliver live video up to Full HD.</li>
     * <li><code>LOW</code> : Use LOW for near real-time interactions with viewers.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * In the  console, <code>LOW</code> and <code>NORMAL</code> correspond to <code>Ultra-low</code> and <code>Standard</code> , respectively.
     * <p>
     * </blockquote>
     * <p>
     * <em>Default</em> : <code>LOW</code>
     * <p>
     * Default: - "LOW"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-latencymode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-latencymode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLatencyMode() {
        return null;
    }

    /**
     * Channel name.
     * <p>
     * Default: - "-"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * An optional transcode preset for the channel.
     * <p>
     * This is selectable only for <code>ADVANCED_HD</code> and <code>ADVANCED_SD</code> channel types. For those channel types, the default preset is <code>HIGHER_BANDWIDTH_DELIVERY</code> . For other channel types ( <code>BASIC</code> and <code>STANDARD</code> ), <code>preset</code> is the empty string ("").
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-preset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-preset</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreset() {
        return null;
    }

    /**
     * The ARN of a RecordingConfiguration resource.
     * <p>
     * An empty string indicates that recording is disabled for the channel. A RecordingConfiguration ARN indicates that recording is enabled using the specified recording configuration. See the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html">RecordingConfiguration</a> resource for more information and an example.
     * <p>
     * <em>Default</em> : "" (empty string, recording is disabled)
     * <p>
     * Default: - ""
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-recordingconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-recordingconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRecordingConfigurationArn() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-channel-tag.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The channel type, which determines the allowable resolution and bitrate.
     * <p>
     * <em>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</em> Valid values:
     * <p>
     * <ul>
     * <li><code>STANDARD</code> : Video is transcoded: multiple qualities are generated from the original input to automatically give viewers the best experience for their devices and network conditions. Transcoding allows higher playback quality across a range of download speeds. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</li>
     * <li><code>BASIC</code> : Video is transmuxed: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 1080p and bitrate can be up to 1.5 Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.</li>
     * <li><code>ADVANCED_SD</code> : Video is transcoded; multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Input resolution can be up to 1080p and bitrate can be up to 8.5 Mbps; output is capped at SD quality (480p). You can select an optional transcode preset (see below). Audio for all renditions is transcoded, and an audio-only rendition is available.</li>
     * <li><code>ADVANCED_HD</code> : Video is transcoded; multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Input resolution can be up to 1080p and bitrate can be up to 8.5 Mbps; output is capped at HD quality (720p). You can select an optional transcode preset (see below). Audio for all renditions is transcoded, and an audio-only rendition is available.</li>
     * </ul>
     * <p>
     * Optional <em>transcode presets</em> (available for the <code>ADVANCED</code> types) allow you to trade off available download bandwidth and video quality, to optimize the viewing experience. There are two presets:
     * <p>
     * <ul>
     * <li><em>Constrained bandwidth delivery</em> uses a lower bitrate for each quality level. Use it if you have low download bandwidth and/or simple video content (e.g., talking heads)</li>
     * <li><em>Higher bandwidth delivery</em> uses a higher bitrate for each quality level. Use it if you have high download bandwidth and/or complex video content (e.g., flashes and quick scene changes).</li>
     * </ul>
     * <p>
     * <em>Default</em> : <code>STANDARD</code>
     * <p>
     * Default: - "STANDARD"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html#cfn-ivs-channel-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnChannelProps> {
        java.lang.Object authorized;
        java.lang.Object insecureIngest;
        java.lang.String latencyMode;
        java.lang.String name;
        java.lang.String preset;
        java.lang.String recordingConfigurationArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String type;

        /**
         * Sets the value of {@link CfnChannelProps#getAuthorized}
         * @param authorized Whether the channel is authorized.
         *                   <em>Default</em> : <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorized(java.lang.Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getAuthorized}
         * @param authorized Whether the channel is authorized.
         *                   <em>Default</em> : <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorized(software.amazon.awscdk.IResolvable authorized) {
            this.authorized = authorized;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInsecureIngest}
         * @param insecureIngest Whether the channel allows insecure RTMP ingest.
         *                       <em>Default</em> : <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insecureIngest(java.lang.Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getInsecureIngest}
         * @param insecureIngest Whether the channel allows insecure RTMP ingest.
         *                       <em>Default</em> : <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insecureIngest(software.amazon.awscdk.IResolvable insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getLatencyMode}
         * @param latencyMode Channel latency mode. Valid values:.
         *                    <ul>
         *                    <li><code>NORMAL</code> : Use NORMAL to broadcast and deliver live video up to Full HD.</li>
         *                    <li><code>LOW</code> : Use LOW for near real-time interactions with viewers.</li>
         *                    </ul>
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    In the  console, <code>LOW</code> and <code>NORMAL</code> correspond to <code>Ultra-low</code> and <code>Standard</code> , respectively.
         *                    <p>
         *                    </blockquote>
         *                    <p>
         *                    <em>Default</em> : <code>LOW</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latencyMode(java.lang.String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getName}
         * @param name Channel name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getPreset}
         * @param preset An optional transcode preset for the channel.
         *               This is selectable only for <code>ADVANCED_HD</code> and <code>ADVANCED_SD</code> channel types. For those channel types, the default preset is <code>HIGHER_BANDWIDTH_DELIVERY</code> . For other channel types ( <code>BASIC</code> and <code>STANDARD</code> ), <code>preset</code> is the empty string ("").
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preset(java.lang.String preset) {
            this.preset = preset;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getRecordingConfigurationArn}
         * @param recordingConfigurationArn The ARN of a RecordingConfiguration resource.
         *                                  An empty string indicates that recording is disabled for the channel. A RecordingConfiguration ARN indicates that recording is enabled using the specified recording configuration. See the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html">RecordingConfiguration</a> resource for more information and an example.
         *                                  <p>
         *                                  <em>Default</em> : "" (empty string, recording is disabled)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingConfigurationArn(java.lang.String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-channel-tag.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getType}
         * @param type The channel type, which determines the allowable resolution and bitrate.
         *             <em>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</em> Valid values:
         *             <p>
         *             <ul>
         *             <li><code>STANDARD</code> : Video is transcoded: multiple qualities are generated from the original input to automatically give viewers the best experience for their devices and network conditions. Transcoding allows higher playback quality across a range of download speeds. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</li>
         *             <li><code>BASIC</code> : Video is transmuxed: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 1080p and bitrate can be up to 1.5 Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.</li>
         *             <li><code>ADVANCED_SD</code> : Video is transcoded; multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Input resolution can be up to 1080p and bitrate can be up to 8.5 Mbps; output is capped at SD quality (480p). You can select an optional transcode preset (see below). Audio for all renditions is transcoded, and an audio-only rendition is available.</li>
         *             <li><code>ADVANCED_HD</code> : Video is transcoded; multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Input resolution can be up to 1080p and bitrate can be up to 8.5 Mbps; output is capped at HD quality (720p). You can select an optional transcode preset (see below). Audio for all renditions is transcoded, and an audio-only rendition is available.</li>
         *             </ul>
         *             <p>
         *             Optional <em>transcode presets</em> (available for the <code>ADVANCED</code> types) allow you to trade off available download bandwidth and video quality, to optimize the viewing experience. There are two presets:
         *             <p>
         *             <ul>
         *             <li><em>Constrained bandwidth delivery</em> uses a lower bitrate for each quality level. Use it if you have low download bandwidth and/or simple video content (e.g., talking heads)</li>
         *             <li><em>Higher bandwidth delivery</em> uses a higher bitrate for each quality level. Use it if you have high download bandwidth and/or complex video content (e.g., flashes and quick scene changes).</li>
         *             </ul>
         *             <p>
         *             <em>Default</em> : <code>STANDARD</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnChannelProps {
        private final java.lang.Object authorized;
        private final java.lang.Object insecureIngest;
        private final java.lang.String latencyMode;
        private final java.lang.String name;
        private final java.lang.String preset;
        private final java.lang.String recordingConfigurationArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorized = software.amazon.jsii.Kernel.get(this, "authorized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.insecureIngest = software.amazon.jsii.Kernel.get(this, "insecureIngest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.latencyMode = software.amazon.jsii.Kernel.get(this, "latencyMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preset = software.amazon.jsii.Kernel.get(this, "preset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordingConfigurationArn = software.amazon.jsii.Kernel.get(this, "recordingConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorized = builder.authorized;
            this.insecureIngest = builder.insecureIngest;
            this.latencyMode = builder.latencyMode;
            this.name = builder.name;
            this.preset = builder.preset;
            this.recordingConfigurationArn = builder.recordingConfigurationArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.type = builder.type;
        }

        @Override
        public final java.lang.Object getAuthorized() {
            return this.authorized;
        }

        @Override
        public final java.lang.Object getInsecureIngest() {
            return this.insecureIngest;
        }

        @Override
        public final java.lang.String getLatencyMode() {
            return this.latencyMode;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPreset() {
            return this.preset;
        }

        @Override
        public final java.lang.String getRecordingConfigurationArn() {
            return this.recordingConfigurationArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorized() != null) {
                data.set("authorized", om.valueToTree(this.getAuthorized()));
            }
            if (this.getInsecureIngest() != null) {
                data.set("insecureIngest", om.valueToTree(this.getInsecureIngest()));
            }
            if (this.getLatencyMode() != null) {
                data.set("latencyMode", om.valueToTree(this.getLatencyMode()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPreset() != null) {
                data.set("preset", om.valueToTree(this.getPreset()));
            }
            if (this.getRecordingConfigurationArn() != null) {
                data.set("recordingConfigurationArn", om.valueToTree(this.getRecordingConfigurationArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivs.CfnChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnChannelProps.Jsii$Proxy that = (CfnChannelProps.Jsii$Proxy) o;

            if (this.authorized != null ? !this.authorized.equals(that.authorized) : that.authorized != null) return false;
            if (this.insecureIngest != null ? !this.insecureIngest.equals(that.insecureIngest) : that.insecureIngest != null) return false;
            if (this.latencyMode != null ? !this.latencyMode.equals(that.latencyMode) : that.latencyMode != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.preset != null ? !this.preset.equals(that.preset) : that.preset != null) return false;
            if (this.recordingConfigurationArn != null ? !this.recordingConfigurationArn.equals(that.recordingConfigurationArn) : that.recordingConfigurationArn != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.type != null ? this.type.equals(that.type) : that.type == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorized != null ? this.authorized.hashCode() : 0;
            result = 31 * result + (this.insecureIngest != null ? this.insecureIngest.hashCode() : 0);
            result = 31 * result + (this.latencyMode != null ? this.latencyMode.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.preset != null ? this.preset.hashCode() : 0);
            result = 31 * result + (this.recordingConfigurationArn != null ? this.recordingConfigurationArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}
