package software.amazon.awscdk.services.lakeformation;

/**
 * Properties for defining a <code>CfnDataCellsFilter</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lakeformation.*;
 * Object allRowsWildcard;
 * CfnDataCellsFilterProps cfnDataCellsFilterProps = CfnDataCellsFilterProps.builder()
 *         .databaseName("databaseName")
 *         .name("name")
 *         .tableCatalogId("tableCatalogId")
 *         .tableName("tableName")
 *         // the properties below are optional
 *         .columnNames(List.of("columnNames"))
 *         .columnWildcard(ColumnWildcardProperty.builder()
 *                 .excludedColumnNames(List.of("excludedColumnNames"))
 *                 .build())
 *         .rowFilter(RowFilterProperty.builder()
 *                 .allRowsWildcard(allRowsWildcard)
 *                 .filterExpression("filterExpression")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:59.609Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnDataCellsFilterProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataCellsFilterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataCellsFilterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * UTF-8 string, not less than 1 or more than 255 bytes long, matching the <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-aws-lake-formation-api-common.html">single-line string pattern</a> .
     * <p>
     * A database in the Data Catalog .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-databasename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

    /**
     * UTF-8 string, not less than 1 or more than 255 bytes long, matching the <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-aws-lake-formation-api-common.html">single-line string pattern</a> .
     * <p>
     * The name given by the user to the data filter cell.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Catalog id string, not less than 1 or more than 255 bytes long, matching the <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-aws-lake-formation-api-common.html">single-line string pattern</a> .
     * <p>
     * The ID of the catalog to which the table belongs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-tablecatalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-tablecatalogid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableCatalogId();

    /**
     * UTF-8 string, not less than 1 or more than 255 bytes long, matching the <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-aws-lake-formation-api-common.html">single-line string pattern</a> .
     * <p>
     * A table in the database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-tablename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * An array of UTF-8 strings.
     * <p>
     * A list of column names.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-columnnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-columnnames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumnNames() {
        return null;
    }

    /**
     * A wildcard with exclusions.
     * <p>
     * You must specify either a <code>ColumnNames</code> list or the <code>ColumnWildCard</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-columnwildcard">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-columnwildcard</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getColumnWildcard() {
        return null;
    }

    /**
     * A PartiQL predicate.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-rowfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datacellsfilter.html#cfn-lakeformation-datacellsfilter-rowfilter</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRowFilter() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataCellsFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataCellsFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataCellsFilterProps> {
        java.lang.String databaseName;
        java.lang.String name;
        java.lang.String tableCatalogId;
        java.lang.String tableName;
        java.util.List<java.lang.String> columnNames;
        java.lang.Object columnWildcard;
        java.lang.Object rowFilter;

        /**
         * Sets the value of {@link CfnDataCellsFilterProps#getDatabaseName}
         * @param databaseName UTF-8 string, not less than 1 or more than 255 bytes long, matching the <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-aws-lake-formation-api-common.html">single-line string pattern</a> . This parameter is required.
         *                     A database in the Data Catalog .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCellsFilterProps#getName}
         * @param name UTF-8 string, not less than 1 or more than 255 bytes long, matching the <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-aws-lake-formation-api-common.html">single-line string pattern</a> . This parameter is required.
         *             The name given by the user to the data filter cell.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCellsFilterProps#getTableCatalogId}
         * @param tableCatalogId Catalog id string, not less than 1 or more than 255 bytes long, matching the <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-aws-lake-formation-api-common.html">single-line string pattern</a> . This parameter is required.
         *                       The ID of the catalog to which the table belongs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableCatalogId(java.lang.String tableCatalogId) {
            this.tableCatalogId = tableCatalogId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCellsFilterProps#getTableName}
         * @param tableName UTF-8 string, not less than 1 or more than 255 bytes long, matching the <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-aws-lake-formation-api-common.html">single-line string pattern</a> . This parameter is required.
         *                  A table in the database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCellsFilterProps#getColumnNames}
         * @param columnNames An array of UTF-8 strings.
         *                    A list of column names.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnNames(java.util.List<java.lang.String> columnNames) {
            this.columnNames = columnNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCellsFilterProps#getColumnWildcard}
         * @param columnWildcard A wildcard with exclusions.
         *                       You must specify either a <code>ColumnNames</code> list or the <code>ColumnWildCard</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnWildcard(software.amazon.awscdk.IResolvable columnWildcard) {
            this.columnWildcard = columnWildcard;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCellsFilterProps#getColumnWildcard}
         * @param columnWildcard A wildcard with exclusions.
         *                       You must specify either a <code>ColumnNames</code> list or the <code>ColumnWildCard</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnWildcard(software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.ColumnWildcardProperty columnWildcard) {
            this.columnWildcard = columnWildcard;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCellsFilterProps#getRowFilter}
         * @param rowFilter A PartiQL predicate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowFilter(software.amazon.awscdk.IResolvable rowFilter) {
            this.rowFilter = rowFilter;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCellsFilterProps#getRowFilter}
         * @param rowFilter A PartiQL predicate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowFilter(software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.RowFilterProperty rowFilter) {
            this.rowFilter = rowFilter;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataCellsFilterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataCellsFilterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataCellsFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataCellsFilterProps {
        private final java.lang.String databaseName;
        private final java.lang.String name;
        private final java.lang.String tableCatalogId;
        private final java.lang.String tableName;
        private final java.util.List<java.lang.String> columnNames;
        private final java.lang.Object columnWildcard;
        private final java.lang.Object rowFilter;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableCatalogId = software.amazon.jsii.Kernel.get(this, "tableCatalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.columnNames = software.amazon.jsii.Kernel.get(this, "columnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.columnWildcard = software.amazon.jsii.Kernel.get(this, "columnWildcard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rowFilter = software.amazon.jsii.Kernel.get(this, "rowFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.tableCatalogId = java.util.Objects.requireNonNull(builder.tableCatalogId, "tableCatalogId is required");
            this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            this.columnNames = builder.columnNames;
            this.columnWildcard = builder.columnWildcard;
            this.rowFilter = builder.rowFilter;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getTableCatalogId() {
            return this.tableCatalogId;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.util.List<java.lang.String> getColumnNames() {
            return this.columnNames;
        }

        @Override
        public final java.lang.Object getColumnWildcard() {
            return this.columnWildcard;
        }

        @Override
        public final java.lang.Object getRowFilter() {
            return this.rowFilter;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("tableCatalogId", om.valueToTree(this.getTableCatalogId()));
            data.set("tableName", om.valueToTree(this.getTableName()));
            if (this.getColumnNames() != null) {
                data.set("columnNames", om.valueToTree(this.getColumnNames()));
            }
            if (this.getColumnWildcard() != null) {
                data.set("columnWildcard", om.valueToTree(this.getColumnWildcard()));
            }
            if (this.getRowFilter() != null) {
                data.set("rowFilter", om.valueToTree(this.getRowFilter()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnDataCellsFilterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataCellsFilterProps.Jsii$Proxy that = (CfnDataCellsFilterProps.Jsii$Proxy) o;

            if (!databaseName.equals(that.databaseName)) return false;
            if (!name.equals(that.name)) return false;
            if (!tableCatalogId.equals(that.tableCatalogId)) return false;
            if (!tableName.equals(that.tableName)) return false;
            if (this.columnNames != null ? !this.columnNames.equals(that.columnNames) : that.columnNames != null) return false;
            if (this.columnWildcard != null ? !this.columnWildcard.equals(that.columnWildcard) : that.columnWildcard != null) return false;
            return this.rowFilter != null ? this.rowFilter.equals(that.rowFilter) : that.rowFilter == null;
        }

        @Override
        public final int hashCode() {
            int result = this.databaseName.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.tableCatalogId.hashCode());
            result = 31 * result + (this.tableName.hashCode());
            result = 31 * result + (this.columnNames != null ? this.columnNames.hashCode() : 0);
            result = 31 * result + (this.columnWildcard != null ? this.columnWildcard.hashCode() : 0);
            result = 31 * result + (this.rowFilter != null ? this.rowFilter.hashCode() : 0);
            return result;
        }
    }
}
