package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a <code>CfnEventSourceMapping</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnEventSourceMappingProps cfnEventSourceMappingProps = CfnEventSourceMappingProps.builder()
 *         .functionName("functionName")
 *         // the properties below are optional
 *         .amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfigProperty.builder()
 *                 .consumerGroupId("consumerGroupId")
 *                 .build())
 *         .batchSize(123)
 *         .bisectBatchOnFunctionError(false)
 *         .destinationConfig(DestinationConfigProperty.builder()
 *                 .onFailure(OnFailureProperty.builder()
 *                         .destination("destination")
 *                         .build())
 *                 .build())
 *         .documentDbEventSourceConfig(DocumentDBEventSourceConfigProperty.builder()
 *                 .collectionName("collectionName")
 *                 .databaseName("databaseName")
 *                 .fullDocument("fullDocument")
 *                 .build())
 *         .enabled(false)
 *         .eventSourceArn("eventSourceArn")
 *         .filterCriteria(FilterCriteriaProperty.builder()
 *                 .filters(List.of(FilterProperty.builder()
 *                         .pattern("pattern")
 *                         .build()))
 *                 .build())
 *         .functionResponseTypes(List.of("functionResponseTypes"))
 *         .kmsKeyArn("kmsKeyArn")
 *         .maximumBatchingWindowInSeconds(123)
 *         .maximumRecordAgeInSeconds(123)
 *         .maximumRetryAttempts(123)
 *         .metricsConfig(MetricsConfigProperty.builder()
 *                 .metrics(List.of("metrics"))
 *                 .build())
 *         .parallelizationFactor(123)
 *         .provisionedPollerConfig(ProvisionedPollerConfigProperty.builder()
 *                 .maximumPollers(123)
 *                 .minimumPollers(123)
 *                 .build())
 *         .queues(List.of("queues"))
 *         .scalingConfig(ScalingConfigProperty.builder()
 *                 .maximumConcurrency(123)
 *                 .build())
 *         .selfManagedEventSource(SelfManagedEventSourceProperty.builder()
 *                 .endpoints(EndpointsProperty.builder()
 *                         .kafkaBootstrapServers(List.of("kafkaBootstrapServers"))
 *                         .build())
 *                 .build())
 *         .selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfigProperty.builder()
 *                 .consumerGroupId("consumerGroupId")
 *                 .build())
 *         .sourceAccessConfigurations(List.of(SourceAccessConfigurationProperty.builder()
 *                 .type("type")
 *                 .uri("uri")
 *                 .build()))
 *         .startingPosition("startingPosition")
 *         .startingPositionTimestamp(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .topics(List.of("topics"))
 *         .tumblingWindowInSeconds(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:59.694Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnEventSourceMappingProps")
@software.amazon.jsii.Jsii.Proxy(CfnEventSourceMappingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEventSourceMappingProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Lambda function.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

    /**
     * Specific configuration settings for an MSK event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-amazonmanagedkafkaeventsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-amazonmanagedkafkaeventsourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAmazonManagedKafkaEventSourceConfig() {
        return null;
    }

    /**
     * The maximum number of items to retrieve in a single batch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-batchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-batchsize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
        return null;
    }

    /**
     * (Streams) If the function returns an error, split the batch in two and retry.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-bisectbatchonfunctionerror">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-bisectbatchonfunctionerror</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBisectBatchOnFunctionError() {
        return null;
    }

    /**
     * A configuration object that specifies the destination of an event after Lambda processes it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-destinationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-destinationconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationConfig() {
        return null;
    }

    /**
     * Document db event source config.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-documentdbeventsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-documentdbeventsourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDocumentDbEventSourceConfig() {
        return null;
    }

    /**
     * Disables the event source mapping to pause polling and invocation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-enabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-eventsourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-eventsourcearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventSourceArn() {
        return null;
    }

    /**
     * The filter criteria to control event filtering.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-filtercriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-filtercriteria</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFilterCriteria() {
        return null;
    }

    /**
     * (Streams) A list of response types supported by the function.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionresponsetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionresponsetypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFunctionResponseTypes() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the KMS key.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-kmskeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * (Streams) The maximum amount of time to gather records before invoking the function, in seconds.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumbatchingwindowinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumbatchingwindowinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
        return null;
    }

    /**
     * (Streams) The maximum age of a record that Lambda sends to a function for processing.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumrecordageinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumrecordageinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRecordAgeInSeconds() {
        return null;
    }

    /**
     * (Streams) The maximum number of times to retry when the function returns an error.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumretryattempts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumretryattempts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
        return null;
    }

    /**
     * Metrics config for Event Source Mapping Metrics.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-metricsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-metricsconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetricsConfig() {
        return null;
    }

    /**
     * (Streams) The number of batches to process from each shard concurrently.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-parallelizationfactor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-parallelizationfactor</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getParallelizationFactor() {
        return null;
    }

    /**
     * ProvisionedPollerConfig.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-provisionedpollerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-provisionedpollerconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedPollerConfig() {
        return null;
    }

    /**
     * (ActiveMQ) A list of ActiveMQ queues.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-queues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-queues</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueues() {
        return null;
    }

    /**
     * The scaling configuration for the event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-scalingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-scalingconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScalingConfig() {
        return null;
    }

    /**
     * The configuration used by AWS Lambda to access a self-managed event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-selfmanagedeventsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-selfmanagedeventsource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedEventSource() {
        return null;
    }

    /**
     * Specific configuration settings for a Self-Managed Apache Kafka event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-selfmanagedkafkaeventsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-selfmanagedkafkaeventsourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedKafkaEventSourceConfig() {
        return null;
    }

    /**
     * A list of SourceAccessConfiguration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-sourceaccessconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-sourceaccessconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceAccessConfigurations() {
        return null;
    }

    /**
     * The position in a stream from which to start reading.
     * <p>
     * Required for Amazon Kinesis and Amazon DynamoDB Streams sources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingposition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStartingPosition() {
        return null;
    }

    /**
     * With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingpositiontimestamp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingpositiontimestamp</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStartingPositionTimestamp() {
        return null;
    }

    /**
     * A list of tags to apply to event source mapping resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * (Kafka) A list of Kafka topics.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-topics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-topics</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTopics() {
        return null;
    }

    /**
     * (Streams) Tumbling window (non-overlapping time window) duration to perform aggregations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-tumblingwindowinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-tumblingwindowinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTumblingWindowInSeconds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEventSourceMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEventSourceMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEventSourceMappingProps> {
        java.lang.String functionName;
        java.lang.Object amazonManagedKafkaEventSourceConfig;
        java.lang.Number batchSize;
        java.lang.Object bisectBatchOnFunctionError;
        java.lang.Object destinationConfig;
        java.lang.Object documentDbEventSourceConfig;
        java.lang.Object enabled;
        java.lang.String eventSourceArn;
        java.lang.Object filterCriteria;
        java.util.List<java.lang.String> functionResponseTypes;
        java.lang.String kmsKeyArn;
        java.lang.Number maximumBatchingWindowInSeconds;
        java.lang.Number maximumRecordAgeInSeconds;
        java.lang.Number maximumRetryAttempts;
        java.lang.Object metricsConfig;
        java.lang.Number parallelizationFactor;
        java.lang.Object provisionedPollerConfig;
        java.util.List<java.lang.String> queues;
        java.lang.Object scalingConfig;
        java.lang.Object selfManagedEventSource;
        java.lang.Object selfManagedKafkaEventSourceConfig;
        java.lang.Object sourceAccessConfigurations;
        java.lang.String startingPosition;
        java.lang.Number startingPositionTimestamp;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.util.List<java.lang.String> topics;
        java.lang.Number tumblingWindowInSeconds;

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getFunctionName}
         * @param functionName The name of the Lambda function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getAmazonManagedKafkaEventSourceConfig}
         * @param amazonManagedKafkaEventSourceConfig Specific configuration settings for an MSK event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonManagedKafkaEventSourceConfig(software.amazon.awscdk.IResolvable amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getAmazonManagedKafkaEventSourceConfig}
         * @param amazonManagedKafkaEventSourceConfig Specific configuration settings for an MSK event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonManagedKafkaEventSourceConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.AmazonManagedKafkaEventSourceConfigProperty amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getBatchSize}
         * @param batchSize The maximum number of items to retrieve in a single batch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(java.lang.Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getBisectBatchOnFunctionError}
         * @param bisectBatchOnFunctionError (Streams) If the function returns an error, split the batch in two and retry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnFunctionError(java.lang.Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getBisectBatchOnFunctionError}
         * @param bisectBatchOnFunctionError (Streams) If the function returns an error, split the batch in two and retry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnFunctionError(software.amazon.awscdk.IResolvable bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getDestinationConfig}
         * @param destinationConfig A configuration object that specifies the destination of an event after Lambda processes it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationConfig(software.amazon.awscdk.IResolvable destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getDestinationConfig}
         * @param destinationConfig A configuration object that specifies the destination of an event after Lambda processes it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.DestinationConfigProperty destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getDocumentDbEventSourceConfig}
         * @param documentDbEventSourceConfig Document db event source config.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentDbEventSourceConfig(software.amazon.awscdk.IResolvable documentDbEventSourceConfig) {
            this.documentDbEventSourceConfig = documentDbEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getDocumentDbEventSourceConfig}
         * @param documentDbEventSourceConfig Document db event source config.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentDbEventSourceConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.DocumentDBEventSourceConfigProperty documentDbEventSourceConfig) {
            this.documentDbEventSourceConfig = documentDbEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getEnabled}
         * @param enabled Disables the event source mapping to pause polling and invocation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getEnabled}
         * @param enabled Disables the event source mapping to pause polling and invocation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getEventSourceArn}
         * @param eventSourceArn The Amazon Resource Name (ARN) of the event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceArn(java.lang.String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getFilterCriteria}
         * @param filterCriteria The filter criteria to control event filtering.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterCriteria(software.amazon.awscdk.IResolvable filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getFilterCriteria}
         * @param filterCriteria The filter criteria to control event filtering.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterCriteria(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.FilterCriteriaProperty filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getFunctionResponseTypes}
         * @param functionResponseTypes (Streams) A list of response types supported by the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionResponseTypes(java.util.List<java.lang.String> functionResponseTypes) {
            this.functionResponseTypes = functionResponseTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getKmsKeyArn}
         * @param kmsKeyArn The Amazon Resource Name (ARN) of the KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getMaximumBatchingWindowInSeconds}
         * @param maximumBatchingWindowInSeconds (Streams) The maximum amount of time to gather records before invoking the function, in seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getMaximumRecordAgeInSeconds}
         * @param maximumRecordAgeInSeconds (Streams) The maximum age of a record that Lambda sends to a function for processing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumRecordAgeInSeconds(java.lang.Number maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getMaximumRetryAttempts}
         * @param maximumRetryAttempts (Streams) The maximum number of times to retry when the function returns an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getMetricsConfig}
         * @param metricsConfig Metrics config for Event Source Mapping Metrics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfig(software.amazon.awscdk.IResolvable metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getMetricsConfig}
         * @param metricsConfig Metrics config for Event Source Mapping Metrics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.MetricsConfigProperty metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getParallelizationFactor}
         * @param parallelizationFactor (Streams) The number of batches to process from each shard concurrently.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getProvisionedPollerConfig}
         * @param provisionedPollerConfig ProvisionedPollerConfig.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedPollerConfig(software.amazon.awscdk.IResolvable provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getProvisionedPollerConfig}
         * @param provisionedPollerConfig ProvisionedPollerConfig.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedPollerConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.ProvisionedPollerConfigProperty provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getQueues}
         * @param queues (ActiveMQ) A list of ActiveMQ queues.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queues(java.util.List<java.lang.String> queues) {
            this.queues = queues;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getScalingConfig}
         * @param scalingConfig The scaling configuration for the event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfig(software.amazon.awscdk.IResolvable scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getScalingConfig}
         * @param scalingConfig The scaling configuration for the event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.ScalingConfigProperty scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSelfManagedEventSource}
         * @param selfManagedEventSource The configuration used by AWS Lambda to access a self-managed event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedEventSource(software.amazon.awscdk.IResolvable selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSelfManagedEventSource}
         * @param selfManagedEventSource The configuration used by AWS Lambda to access a self-managed event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedEventSource(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.SelfManagedEventSourceProperty selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSelfManagedKafkaEventSourceConfig}
         * @param selfManagedKafkaEventSourceConfig Specific configuration settings for a Self-Managed Apache Kafka event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedKafkaEventSourceConfig(software.amazon.awscdk.IResolvable selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSelfManagedKafkaEventSourceConfig}
         * @param selfManagedKafkaEventSourceConfig Specific configuration settings for a Self-Managed Apache Kafka event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedKafkaEventSourceConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.SelfManagedKafkaEventSourceConfigProperty selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSourceAccessConfigurations}
         * @param sourceAccessConfigurations A list of SourceAccessConfiguration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAccessConfigurations(software.amazon.awscdk.IResolvable sourceAccessConfigurations) {
            this.sourceAccessConfigurations = sourceAccessConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSourceAccessConfigurations}
         * @param sourceAccessConfigurations A list of SourceAccessConfiguration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAccessConfigurations(java.util.List<? extends java.lang.Object> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = sourceAccessConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getStartingPosition}
         * @param startingPosition The position in a stream from which to start reading.
         *                         Required for Amazon Kinesis and Amazon DynamoDB Streams sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(java.lang.String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getStartingPositionTimestamp}
         * @param startingPositionTimestamp With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPositionTimestamp(java.lang.Number startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getTags}
         * @param tags A list of tags to apply to event source mapping resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getTopics}
         * @param topics (Kafka) A list of Kafka topics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topics(java.util.List<java.lang.String> topics) {
            this.topics = topics;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getTumblingWindowInSeconds}
         * @param tumblingWindowInSeconds (Streams) Tumbling window (non-overlapping time window) duration to perform aggregations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tumblingWindowInSeconds(java.lang.Number tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEventSourceMappingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEventSourceMappingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEventSourceMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEventSourceMappingProps {
        private final java.lang.String functionName;
        private final java.lang.Object amazonManagedKafkaEventSourceConfig;
        private final java.lang.Number batchSize;
        private final java.lang.Object bisectBatchOnFunctionError;
        private final java.lang.Object destinationConfig;
        private final java.lang.Object documentDbEventSourceConfig;
        private final java.lang.Object enabled;
        private final java.lang.String eventSourceArn;
        private final java.lang.Object filterCriteria;
        private final java.util.List<java.lang.String> functionResponseTypes;
        private final java.lang.String kmsKeyArn;
        private final java.lang.Number maximumBatchingWindowInSeconds;
        private final java.lang.Number maximumRecordAgeInSeconds;
        private final java.lang.Number maximumRetryAttempts;
        private final java.lang.Object metricsConfig;
        private final java.lang.Number parallelizationFactor;
        private final java.lang.Object provisionedPollerConfig;
        private final java.util.List<java.lang.String> queues;
        private final java.lang.Object scalingConfig;
        private final java.lang.Object selfManagedEventSource;
        private final java.lang.Object selfManagedKafkaEventSourceConfig;
        private final java.lang.Object sourceAccessConfigurations;
        private final java.lang.String startingPosition;
        private final java.lang.Number startingPositionTimestamp;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.util.List<java.lang.String> topics;
        private final java.lang.Number tumblingWindowInSeconds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.amazonManagedKafkaEventSourceConfig = software.amazon.jsii.Kernel.get(this, "amazonManagedKafkaEventSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.bisectBatchOnFunctionError = software.amazon.jsii.Kernel.get(this, "bisectBatchOnFunctionError", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.destinationConfig = software.amazon.jsii.Kernel.get(this, "destinationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.documentDbEventSourceConfig = software.amazon.jsii.Kernel.get(this, "documentDbEventSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eventSourceArn = software.amazon.jsii.Kernel.get(this, "eventSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filterCriteria = software.amazon.jsii.Kernel.get(this, "filterCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.functionResponseTypes = software.amazon.jsii.Kernel.get(this, "functionResponseTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maximumRecordAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumRecordAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metricsConfig = software.amazon.jsii.Kernel.get(this, "metricsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.provisionedPollerConfig = software.amazon.jsii.Kernel.get(this, "provisionedPollerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.queues = software.amazon.jsii.Kernel.get(this, "queues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.scalingConfig = software.amazon.jsii.Kernel.get(this, "scalingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.selfManagedEventSource = software.amazon.jsii.Kernel.get(this, "selfManagedEventSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.selfManagedKafkaEventSourceConfig = software.amazon.jsii.Kernel.get(this, "selfManagedKafkaEventSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceAccessConfigurations = software.amazon.jsii.Kernel.get(this, "sourceAccessConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.startingPositionTimestamp = software.amazon.jsii.Kernel.get(this, "startingPositionTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.topics = software.amazon.jsii.Kernel.get(this, "topics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tumblingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "tumblingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            this.amazonManagedKafkaEventSourceConfig = builder.amazonManagedKafkaEventSourceConfig;
            this.batchSize = builder.batchSize;
            this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
            this.destinationConfig = builder.destinationConfig;
            this.documentDbEventSourceConfig = builder.documentDbEventSourceConfig;
            this.enabled = builder.enabled;
            this.eventSourceArn = builder.eventSourceArn;
            this.filterCriteria = builder.filterCriteria;
            this.functionResponseTypes = builder.functionResponseTypes;
            this.kmsKeyArn = builder.kmsKeyArn;
            this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
            this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
            this.maximumRetryAttempts = builder.maximumRetryAttempts;
            this.metricsConfig = builder.metricsConfig;
            this.parallelizationFactor = builder.parallelizationFactor;
            this.provisionedPollerConfig = builder.provisionedPollerConfig;
            this.queues = builder.queues;
            this.scalingConfig = builder.scalingConfig;
            this.selfManagedEventSource = builder.selfManagedEventSource;
            this.selfManagedKafkaEventSourceConfig = builder.selfManagedKafkaEventSourceConfig;
            this.sourceAccessConfigurations = builder.sourceAccessConfigurations;
            this.startingPosition = builder.startingPosition;
            this.startingPositionTimestamp = builder.startingPositionTimestamp;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.topics = builder.topics;
            this.tumblingWindowInSeconds = builder.tumblingWindowInSeconds;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.lang.Object getAmazonManagedKafkaEventSourceConfig() {
            return this.amazonManagedKafkaEventSourceConfig;
        }

        @Override
        public final java.lang.Number getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final java.lang.Object getBisectBatchOnFunctionError() {
            return this.bisectBatchOnFunctionError;
        }

        @Override
        public final java.lang.Object getDestinationConfig() {
            return this.destinationConfig;
        }

        @Override
        public final java.lang.Object getDocumentDbEventSourceConfig() {
            return this.documentDbEventSourceConfig;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getEventSourceArn() {
            return this.eventSourceArn;
        }

        @Override
        public final java.lang.Object getFilterCriteria() {
            return this.filterCriteria;
        }

        @Override
        public final java.util.List<java.lang.String> getFunctionResponseTypes() {
            return this.functionResponseTypes;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.lang.Number getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        @Override
        public final java.lang.Number getMaximumRecordAgeInSeconds() {
            return this.maximumRecordAgeInSeconds;
        }

        @Override
        public final java.lang.Number getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        @Override
        public final java.lang.Object getMetricsConfig() {
            return this.metricsConfig;
        }

        @Override
        public final java.lang.Number getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        @Override
        public final java.lang.Object getProvisionedPollerConfig() {
            return this.provisionedPollerConfig;
        }

        @Override
        public final java.util.List<java.lang.String> getQueues() {
            return this.queues;
        }

        @Override
        public final java.lang.Object getScalingConfig() {
            return this.scalingConfig;
        }

        @Override
        public final java.lang.Object getSelfManagedEventSource() {
            return this.selfManagedEventSource;
        }

        @Override
        public final java.lang.Object getSelfManagedKafkaEventSourceConfig() {
            return this.selfManagedKafkaEventSourceConfig;
        }

        @Override
        public final java.lang.Object getSourceAccessConfigurations() {
            return this.sourceAccessConfigurations;
        }

        @Override
        public final java.lang.String getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public final java.lang.Number getStartingPositionTimestamp() {
            return this.startingPositionTimestamp;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getTopics() {
            return this.topics;
        }

        @Override
        public final java.lang.Number getTumblingWindowInSeconds() {
            return this.tumblingWindowInSeconds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionName", om.valueToTree(this.getFunctionName()));
            if (this.getAmazonManagedKafkaEventSourceConfig() != null) {
                data.set("amazonManagedKafkaEventSourceConfig", om.valueToTree(this.getAmazonManagedKafkaEventSourceConfig()));
            }
            if (this.getBatchSize() != null) {
                data.set("batchSize", om.valueToTree(this.getBatchSize()));
            }
            if (this.getBisectBatchOnFunctionError() != null) {
                data.set("bisectBatchOnFunctionError", om.valueToTree(this.getBisectBatchOnFunctionError()));
            }
            if (this.getDestinationConfig() != null) {
                data.set("destinationConfig", om.valueToTree(this.getDestinationConfig()));
            }
            if (this.getDocumentDbEventSourceConfig() != null) {
                data.set("documentDbEventSourceConfig", om.valueToTree(this.getDocumentDbEventSourceConfig()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEventSourceArn() != null) {
                data.set("eventSourceArn", om.valueToTree(this.getEventSourceArn()));
            }
            if (this.getFilterCriteria() != null) {
                data.set("filterCriteria", om.valueToTree(this.getFilterCriteria()));
            }
            if (this.getFunctionResponseTypes() != null) {
                data.set("functionResponseTypes", om.valueToTree(this.getFunctionResponseTypes()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getMaximumBatchingWindowInSeconds() != null) {
                data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
            }
            if (this.getMaximumRecordAgeInSeconds() != null) {
                data.set("maximumRecordAgeInSeconds", om.valueToTree(this.getMaximumRecordAgeInSeconds()));
            }
            if (this.getMaximumRetryAttempts() != null) {
                data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
            }
            if (this.getMetricsConfig() != null) {
                data.set("metricsConfig", om.valueToTree(this.getMetricsConfig()));
            }
            if (this.getParallelizationFactor() != null) {
                data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
            }
            if (this.getProvisionedPollerConfig() != null) {
                data.set("provisionedPollerConfig", om.valueToTree(this.getProvisionedPollerConfig()));
            }
            if (this.getQueues() != null) {
                data.set("queues", om.valueToTree(this.getQueues()));
            }
            if (this.getScalingConfig() != null) {
                data.set("scalingConfig", om.valueToTree(this.getScalingConfig()));
            }
            if (this.getSelfManagedEventSource() != null) {
                data.set("selfManagedEventSource", om.valueToTree(this.getSelfManagedEventSource()));
            }
            if (this.getSelfManagedKafkaEventSourceConfig() != null) {
                data.set("selfManagedKafkaEventSourceConfig", om.valueToTree(this.getSelfManagedKafkaEventSourceConfig()));
            }
            if (this.getSourceAccessConfigurations() != null) {
                data.set("sourceAccessConfigurations", om.valueToTree(this.getSourceAccessConfigurations()));
            }
            if (this.getStartingPosition() != null) {
                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
            }
            if (this.getStartingPositionTimestamp() != null) {
                data.set("startingPositionTimestamp", om.valueToTree(this.getStartingPositionTimestamp()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTopics() != null) {
                data.set("topics", om.valueToTree(this.getTopics()));
            }
            if (this.getTumblingWindowInSeconds() != null) {
                data.set("tumblingWindowInSeconds", om.valueToTree(this.getTumblingWindowInSeconds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnEventSourceMappingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEventSourceMappingProps.Jsii$Proxy that = (CfnEventSourceMappingProps.Jsii$Proxy) o;

            if (!functionName.equals(that.functionName)) return false;
            if (this.amazonManagedKafkaEventSourceConfig != null ? !this.amazonManagedKafkaEventSourceConfig.equals(that.amazonManagedKafkaEventSourceConfig) : that.amazonManagedKafkaEventSourceConfig != null) return false;
            if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
            if (this.bisectBatchOnFunctionError != null ? !this.bisectBatchOnFunctionError.equals(that.bisectBatchOnFunctionError) : that.bisectBatchOnFunctionError != null) return false;
            if (this.destinationConfig != null ? !this.destinationConfig.equals(that.destinationConfig) : that.destinationConfig != null) return false;
            if (this.documentDbEventSourceConfig != null ? !this.documentDbEventSourceConfig.equals(that.documentDbEventSourceConfig) : that.documentDbEventSourceConfig != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.eventSourceArn != null ? !this.eventSourceArn.equals(that.eventSourceArn) : that.eventSourceArn != null) return false;
            if (this.filterCriteria != null ? !this.filterCriteria.equals(that.filterCriteria) : that.filterCriteria != null) return false;
            if (this.functionResponseTypes != null ? !this.functionResponseTypes.equals(that.functionResponseTypes) : that.functionResponseTypes != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            if (this.maximumBatchingWindowInSeconds != null ? !this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds != null) return false;
            if (this.maximumRecordAgeInSeconds != null ? !this.maximumRecordAgeInSeconds.equals(that.maximumRecordAgeInSeconds) : that.maximumRecordAgeInSeconds != null) return false;
            if (this.maximumRetryAttempts != null ? !this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts != null) return false;
            if (this.metricsConfig != null ? !this.metricsConfig.equals(that.metricsConfig) : that.metricsConfig != null) return false;
            if (this.parallelizationFactor != null ? !this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor != null) return false;
            if (this.provisionedPollerConfig != null ? !this.provisionedPollerConfig.equals(that.provisionedPollerConfig) : that.provisionedPollerConfig != null) return false;
            if (this.queues != null ? !this.queues.equals(that.queues) : that.queues != null) return false;
            if (this.scalingConfig != null ? !this.scalingConfig.equals(that.scalingConfig) : that.scalingConfig != null) return false;
            if (this.selfManagedEventSource != null ? !this.selfManagedEventSource.equals(that.selfManagedEventSource) : that.selfManagedEventSource != null) return false;
            if (this.selfManagedKafkaEventSourceConfig != null ? !this.selfManagedKafkaEventSourceConfig.equals(that.selfManagedKafkaEventSourceConfig) : that.selfManagedKafkaEventSourceConfig != null) return false;
            if (this.sourceAccessConfigurations != null ? !this.sourceAccessConfigurations.equals(that.sourceAccessConfigurations) : that.sourceAccessConfigurations != null) return false;
            if (this.startingPosition != null ? !this.startingPosition.equals(that.startingPosition) : that.startingPosition != null) return false;
            if (this.startingPositionTimestamp != null ? !this.startingPositionTimestamp.equals(that.startingPositionTimestamp) : that.startingPositionTimestamp != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.topics != null ? !this.topics.equals(that.topics) : that.topics != null) return false;
            return this.tumblingWindowInSeconds != null ? this.tumblingWindowInSeconds.equals(that.tumblingWindowInSeconds) : that.tumblingWindowInSeconds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.functionName.hashCode();
            result = 31 * result + (this.amazonManagedKafkaEventSourceConfig != null ? this.amazonManagedKafkaEventSourceConfig.hashCode() : 0);
            result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
            result = 31 * result + (this.bisectBatchOnFunctionError != null ? this.bisectBatchOnFunctionError.hashCode() : 0);
            result = 31 * result + (this.destinationConfig != null ? this.destinationConfig.hashCode() : 0);
            result = 31 * result + (this.documentDbEventSourceConfig != null ? this.documentDbEventSourceConfig.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.eventSourceArn != null ? this.eventSourceArn.hashCode() : 0);
            result = 31 * result + (this.filterCriteria != null ? this.filterCriteria.hashCode() : 0);
            result = 31 * result + (this.functionResponseTypes != null ? this.functionResponseTypes.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
            result = 31 * result + (this.maximumRecordAgeInSeconds != null ? this.maximumRecordAgeInSeconds.hashCode() : 0);
            result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
            result = 31 * result + (this.metricsConfig != null ? this.metricsConfig.hashCode() : 0);
            result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
            result = 31 * result + (this.provisionedPollerConfig != null ? this.provisionedPollerConfig.hashCode() : 0);
            result = 31 * result + (this.queues != null ? this.queues.hashCode() : 0);
            result = 31 * result + (this.scalingConfig != null ? this.scalingConfig.hashCode() : 0);
            result = 31 * result + (this.selfManagedEventSource != null ? this.selfManagedEventSource.hashCode() : 0);
            result = 31 * result + (this.selfManagedKafkaEventSourceConfig != null ? this.selfManagedKafkaEventSourceConfig.hashCode() : 0);
            result = 31 * result + (this.sourceAccessConfigurations != null ? this.sourceAccessConfigurations.hashCode() : 0);
            result = 31 * result + (this.startingPosition != null ? this.startingPosition.hashCode() : 0);
            result = 31 * result + (this.startingPositionTimestamp != null ? this.startingPositionTimestamp.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.topics != null ? this.topics.hashCode() : 0);
            result = 31 * result + (this.tumblingWindowInSeconds != null ? this.tumblingWindowInSeconds.hashCode() : 0);
            return result;
        }
    }
}
