package software.amazon.awscdk.services.lambda;

/**
 * Options when creating an asset from a Docker build.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * DockerBuildAssetOptions dockerBuildAssetOptions = DockerBuildAssetOptions.builder()
 *         .buildArgs(Map.of(
 *                 "buildArgsKey", "buildArgs"))
 *         .cacheDisabled(false)
 *         .cacheFrom(List.of(DockerCacheOption.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .params(Map.of(
 *                         "paramsKey", "params"))
 *                 .build()))
 *         .cacheTo(DockerCacheOption.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .params(Map.of(
 *                         "paramsKey", "params"))
 *                 .build())
 *         .file("file")
 *         .imagePath("imagePath")
 *         .outputPath("outputPath")
 *         .platform("platform")
 *         .targetStage("targetStage")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:59.748Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.DockerBuildAssetOptions")
@software.amazon.jsii.Jsii.Proxy(DockerBuildAssetOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DockerBuildAssetOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.DockerBuildOptions {

    /**
     * The path in the Docker image where the asset is located after the build operation.
     * <p>
     * Default: /asset
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImagePath() {
        return null;
    }

    /**
     * The path on the local filesystem where the asset will be copied using <code>docker cp</code>.
     * <p>
     * Default: - a unique temporary directory in the system temp directory
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutputPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DockerBuildAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerBuildAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DockerBuildAssetOptions> {
        java.lang.String imagePath;
        java.lang.String outputPath;
        java.util.Map<java.lang.String, java.lang.String> buildArgs;
        java.lang.Boolean cacheDisabled;
        java.util.List<software.amazon.awscdk.DockerCacheOption> cacheFrom;
        software.amazon.awscdk.DockerCacheOption cacheTo;
        java.lang.String file;
        java.lang.String platform;
        java.lang.String targetStage;

        /**
         * Sets the value of {@link DockerBuildAssetOptions#getImagePath}
         * @param imagePath The path in the Docker image where the asset is located after the build operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imagePath(java.lang.String imagePath) {
            this.imagePath = imagePath;
            return this;
        }

        /**
         * Sets the value of {@link DockerBuildAssetOptions#getOutputPath}
         * @param outputPath The path on the local filesystem where the asset will be copied using <code>docker cp</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link DockerBuildAssetOptions#getBuildArgs}
         * @param buildArgs Build args.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link DockerBuildAssetOptions#getCacheDisabled}
         * @param cacheDisabled Disable the cache and pass <code>--no-cache</code> to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheDisabled(java.lang.Boolean cacheDisabled) {
            this.cacheDisabled = cacheDisabled;
            return this;
        }

        /**
         * Sets the value of {@link DockerBuildAssetOptions#getCacheFrom}
         * @param cacheFrom Cache from options to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder cacheFrom(java.util.List<? extends software.amazon.awscdk.DockerCacheOption> cacheFrom) {
            this.cacheFrom = (java.util.List<software.amazon.awscdk.DockerCacheOption>)cacheFrom;
            return this;
        }

        /**
         * Sets the value of {@link DockerBuildAssetOptions#getCacheTo}
         * @param cacheTo Cache to options to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheTo(software.amazon.awscdk.DockerCacheOption cacheTo) {
            this.cacheTo = cacheTo;
            return this;
        }

        /**
         * Sets the value of {@link DockerBuildAssetOptions#getFile}
         * @param file Name of the Dockerfile, must relative to the docker build path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder file(java.lang.String file) {
            this.file = file;
            return this;
        }

        /**
         * Sets the value of {@link DockerBuildAssetOptions#getPlatform}
         * @param platform Set platform if server is multi-platform capable. <em>Requires Docker Engine API v1.38+</em>.
         *                 Example value: <code>linux/amd64</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(java.lang.String platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link DockerBuildAssetOptions#getTargetStage}
         * @param targetStage Set build target for multi-stage container builds. Any stage defined afterwards will be ignored.
         *                    Example value: <code>build-env</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetStage(java.lang.String targetStage) {
            this.targetStage = targetStage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerBuildAssetOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DockerBuildAssetOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DockerBuildAssetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerBuildAssetOptions {
        private final java.lang.String imagePath;
        private final java.lang.String outputPath;
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final java.lang.Boolean cacheDisabled;
        private final java.util.List<software.amazon.awscdk.DockerCacheOption> cacheFrom;
        private final software.amazon.awscdk.DockerCacheOption cacheTo;
        private final java.lang.String file;
        private final java.lang.String platform;
        private final java.lang.String targetStage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.imagePath = software.amazon.jsii.Kernel.get(this, "imagePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cacheDisabled = software.amazon.jsii.Kernel.get(this, "cacheDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cacheFrom = software.amazon.jsii.Kernel.get(this, "cacheFrom", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerCacheOption.class)));
            this.cacheTo = software.amazon.jsii.Kernel.get(this, "cacheTo", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerCacheOption.class));
            this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetStage = software.amazon.jsii.Kernel.get(this, "targetStage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.imagePath = builder.imagePath;
            this.outputPath = builder.outputPath;
            this.buildArgs = builder.buildArgs;
            this.cacheDisabled = builder.cacheDisabled;
            this.cacheFrom = (java.util.List<software.amazon.awscdk.DockerCacheOption>)builder.cacheFrom;
            this.cacheTo = builder.cacheTo;
            this.file = builder.file;
            this.platform = builder.platform;
            this.targetStage = builder.targetStage;
        }

        @Override
        public final java.lang.String getImagePath() {
            return this.imagePath;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final java.lang.Boolean getCacheDisabled() {
            return this.cacheDisabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.DockerCacheOption> getCacheFrom() {
            return this.cacheFrom;
        }

        @Override
        public final software.amazon.awscdk.DockerCacheOption getCacheTo() {
            return this.cacheTo;
        }

        @Override
        public final java.lang.String getFile() {
            return this.file;
        }

        @Override
        public final java.lang.String getPlatform() {
            return this.platform;
        }

        @Override
        public final java.lang.String getTargetStage() {
            return this.targetStage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getImagePath() != null) {
                data.set("imagePath", om.valueToTree(this.getImagePath()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getCacheDisabled() != null) {
                data.set("cacheDisabled", om.valueToTree(this.getCacheDisabled()));
            }
            if (this.getCacheFrom() != null) {
                data.set("cacheFrom", om.valueToTree(this.getCacheFrom()));
            }
            if (this.getCacheTo() != null) {
                data.set("cacheTo", om.valueToTree(this.getCacheTo()));
            }
            if (this.getFile() != null) {
                data.set("file", om.valueToTree(this.getFile()));
            }
            if (this.getPlatform() != null) {
                data.set("platform", om.valueToTree(this.getPlatform()));
            }
            if (this.getTargetStage() != null) {
                data.set("targetStage", om.valueToTree(this.getTargetStage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.DockerBuildAssetOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerBuildAssetOptions.Jsii$Proxy that = (DockerBuildAssetOptions.Jsii$Proxy) o;

            if (this.imagePath != null ? !this.imagePath.equals(that.imagePath) : that.imagePath != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.cacheDisabled != null ? !this.cacheDisabled.equals(that.cacheDisabled) : that.cacheDisabled != null) return false;
            if (this.cacheFrom != null ? !this.cacheFrom.equals(that.cacheFrom) : that.cacheFrom != null) return false;
            if (this.cacheTo != null ? !this.cacheTo.equals(that.cacheTo) : that.cacheTo != null) return false;
            if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) return false;
            return this.targetStage != null ? this.targetStage.equals(that.targetStage) : that.targetStage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.imagePath != null ? this.imagePath.hashCode() : 0;
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.buildArgs != null ? this.buildArgs.hashCode() : 0);
            result = 31 * result + (this.cacheDisabled != null ? this.cacheDisabled.hashCode() : 0);
            result = 31 * result + (this.cacheFrom != null ? this.cacheFrom.hashCode() : 0);
            result = 31 * result + (this.cacheTo != null ? this.cacheTo.hashCode() : 0);
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
            result = 31 * result + (this.targetStage != null ? this.targetStage.hashCode() : 0);
            return result;
        }
    }
}
