package software.amazon.awscdk.services.lambda;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * ProvisionedPollerConfig provisionedPollerConfig = ProvisionedPollerConfig.builder()
 *         .maximumPollers(123)
 *         .minimumPollers(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:50:59.820Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.ProvisionedPollerConfig")
@software.amazon.jsii.Jsii.Proxy(ProvisionedPollerConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProvisionedPollerConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum number of pollers that can be provisioned.
     * <p>
     * Default: - 200
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumPollers() {
        return null;
    }

    /**
     * The minimum number of pollers that should be provisioned.
     * <p>
     * Default: - 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumPollers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProvisionedPollerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProvisionedPollerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProvisionedPollerConfig> {
        java.lang.Number maximumPollers;
        java.lang.Number minimumPollers;

        /**
         * Sets the value of {@link ProvisionedPollerConfig#getMaximumPollers}
         * @param maximumPollers The maximum number of pollers that can be provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumPollers(java.lang.Number maximumPollers) {
            this.maximumPollers = maximumPollers;
            return this;
        }

        /**
         * Sets the value of {@link ProvisionedPollerConfig#getMinimumPollers}
         * @param minimumPollers The minimum number of pollers that should be provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumPollers(java.lang.Number minimumPollers) {
            this.minimumPollers = minimumPollers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProvisionedPollerConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProvisionedPollerConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProvisionedPollerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedPollerConfig {
        private final java.lang.Number maximumPollers;
        private final java.lang.Number minimumPollers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maximumPollers = software.amazon.jsii.Kernel.get(this, "maximumPollers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minimumPollers = software.amazon.jsii.Kernel.get(this, "minimumPollers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maximumPollers = builder.maximumPollers;
            this.minimumPollers = builder.minimumPollers;
        }

        @Override
        public final java.lang.Number getMaximumPollers() {
            return this.maximumPollers;
        }

        @Override
        public final java.lang.Number getMinimumPollers() {
            return this.minimumPollers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaximumPollers() != null) {
                data.set("maximumPollers", om.valueToTree(this.getMaximumPollers()));
            }
            if (this.getMinimumPollers() != null) {
                data.set("minimumPollers", om.valueToTree(this.getMinimumPollers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.ProvisionedPollerConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProvisionedPollerConfig.Jsii$Proxy that = (ProvisionedPollerConfig.Jsii$Proxy) o;

            if (this.maximumPollers != null ? !this.maximumPollers.equals(that.maximumPollers) : that.maximumPollers != null) return false;
            return this.minimumPollers != null ? this.minimumPollers.equals(that.minimumPollers) : that.minimumPollers == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maximumPollers != null ? this.maximumPollers.hashCode() : 0;
            result = 31 * result + (this.minimumPollers != null ? this.minimumPollers.hashCode() : 0);
            return result;
        }
    }
}
